<?php $__env->startSection('isi'); ?>
    <div class="row">
        <div class="col-md-12 project-list">
            <div class="card">
                <div class="row">
                    <div class="col-md-6 mt-2 p-0 d-flex">
                        <h4><?php echo e($title); ?></h4>
                    </div>
                    <div class="col-md-6 p-0">
                        <a href="<?php echo e(url('/reimbursement/tambah')); ?>" class="btn btn-primary">+ Tambah</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <form action="<?php echo e(url('/reimbursement')); ?>">
                        <div class="row mb-2">
                            <div class="col-3">
                                <input type="datetime" class="form-control" name="mulai" placeholder="Tanggal Mulai" id="mulai" value="<?php echo e(request('mulai')); ?>">
                            </div>
                            <div class="col-3">
                                <input type="datetime" class="form-control" name="akhir" placeholder="Tanggal Akhir" id="akhir" value="<?php echo e(request('akhir')); ?>">
                            </div>
                            <div class="col-3">
                                <button type="submit" id="search"class="border-0 mt-3" style="background-color: transparent;"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="mytable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Tanggal</th>
                                    <th>Nama</th>
                                    <th>Event</th>
                                    <th>Kategori</th>
                                    <th>Status</th>
                                    <th>Jumlah</th>
                                    <th>Qty</th>
                                    <th>Total</th>
                                    <th>Partner</th>
                                    <th>Sisa</th>
                                    <th>File</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $reimbursement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $re): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($re->tanggal ?? '-'); ?></td>
                                        <td><?php echo e($re->user->name ?? '-'); ?></td>
                                        <td><?php echo e($re->event ?? '-'); ?></td>
                                        <td><?php echo e($re->kategori->name ?? '-'); ?></td>
                                        <td>
                                            <?php if($re->status == 'Pending'): ?>
                                                <span class="badge badge-warning">Pending</span>
                                            <?php elseif($re->status == 'Approved'): ?>
                                                <span class="badge badge-success">Approved</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Rejected</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>Rp <?php echo e(number_format($re->jumlah)); ?></td>
                                        <td><?php echo e($re->qty ?? '-'); ?></td>
                                        <td>Rp <?php echo e(number_format($re->total)); ?></td>
                                        <td>
                                            <?php $__currentLoopData = $re->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p class="btn btn-xs mb-1" style="background-color: rgb(146, 146, 146); font-size:10px;color:black"><?php echo e($item->user->name ?? '-'); ?> - Rp <?php echo e(number_format($item->fee)); ?></p>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                        <td>Rp <?php echo e(number_format($re->sisa)); ?></td>
                                        <td>
                                            <?php if($re->file_path): ?>
                                                <a href="<?php echo e(url('/storage/'.$re->file_path)); ?>" style="font-size:10px" target="_blank" class="btn btn-primary"><i class="fa fa-download me-2"></i><?php echo e($re->file_name); ?></a>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <ul class="action">
                                                <?php if($re->status == 'Pending'): ?>
                                                    <button class="border-0" style="background-color: transparent" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal"><i style="color:blue" class="fa fa-check-circle"></i></button>

                                                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                        <div class="modal-dialog" role="document">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="exampleModalLabel">Approval</h5>
                                                                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                                <form action="<?php echo e(url('/reimbursement/approval/'.$re->id)); ?>" method="POST">
                                                                    <?php echo csrf_field(); ?>
                                                                    <div class="modal-body">
                                                                        <div class="form-group">
                                                                            <?php
                                                                                $status = array(
                                                                                    [
                                                                                        "status" => "Pending",
                                                                                        "status_name" => "Pending"
                                                                                    ],
                                                                                    [
                                                                                        "status" => "Approved",
                                                                                        "status_name" => "Approve"
                                                                                    ],
                                                                                    [
                                                                                        "status" => "Rejected",
                                                                                        "status_name" => "Reject"
                                                                                    ]
                                                                                );
                                                                            ?>
                                                                            <label for="status">Status</label>
                                                                            <select name="status" id="status" class="form-control selectpicker" data-live-search="true">
                                                                                <option value="">-- Pilih --</option>
                                                                                <?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <?php if(old('status', $re->status) == $s["status"]): ?>
                                                                                    <option value="<?php echo e($s["status"]); ?>" selected><?php echo e($s["status_name"]); ?></option>
                                                                                    <?php else: ?>
                                                                                    <option value="<?php echo e($s["status"]); ?>"><?php echo e($s["status_name"]); ?></option>
                                                                                    <?php endif; ?>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>
                                                                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                <div class="invalid-feedback">
                                                                                    <?php echo e($message); ?>

                                                                                </div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
                                                                        <button class="btn btn-secondary" type="submit">Save changes</button>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <li class="edit">
                                                        <a href="<?php echo e(url('/reimbursement/edit/'.$re->id)); ?>"><i class="fa fa-solid fa-edit"></i></a>
                                                    </li>
                                                    <li class="delete">
                                                        <form action="<?php echo e(url('/reimbursement/delete/'.$re->id)); ?>" method="post" class="d-inline">
                                                            <?php echo method_field('delete'); ?>
                                                            <?php echo csrf_field(); ?>
                                                            <button class="border-0" style="background-color: transparent;" onClick="return confirm('Are You Sure')"><i class="fa fa-solid fa-trash"></i></button>
                                                        </form>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-end mt-4">
                        <?php echo e($reimbursement->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <br>

    <?php $__env->startPush('script'); ?>
        <script>
            $(document).ready(function() {
                $('#mulai').change(function(){
                    var mulai = $(this).val();
                $('#akhir').val(mulai);
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\absensi\resources\views/reimbursement/index.blade.php ENDPATH**/ ?>