<?php $__env->startSection('container'); ?>
    <div class="card-secton">
        <div class="tf-container">
            <div class="tf-balance-box">
                <div class="balance">
                    <div class="row">
                        <div class="col-6 br-right">
                            <div class="inner-left">
                                <p><?php echo e($shift_karyawan->Shift->nama_shift ?? '-'); ?></p>
                                <h4><?php echo e(auth()->user()->Lokasi->nama_lokasi); ?></h4>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="inner-right">
                                <p>Jam Kerja</p>
                                <h3>
                                    <span><?php echo e($shift_karyawan->Shift->jam_masuk ?? ''); ?> - <?php echo e($shift_karyawan->Shift->jam_keluar ?? ''); ?></span>
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                    $tahun_skrg = date('Y');
                    $bulan_skrg = date('m');
                    $jmlh_bulan = cal_days_in_month(CAL_GREGORIAN,$bulan_skrg,$tahun_skrg);
                    $tgl_mulai = date('Y-m-01');
                    $tgl_akhir = date('Y-m-'.$jmlh_bulan);
                    $sisa_reimbursement = auth()->user()->reimbursement->whereBetween('tanggal', [$tgl_mulai, $tgl_akhir])->where('status', 'Approved')->sum('sisa');
                    $fee_reimbursement = App\Models\ReimbursementsItem::whereHas('reimbursement', function ($query) use ($tgl_mulai, $tgl_akhir) {
                        $query->whereBetween('tanggal', [$tgl_mulai, $tgl_akhir])->where('status', 'Approved');
                    })->where('user_id', auth()->user()->id)->sum('fee');
                    $total_reimbursement = $sisa_reimbursement + $fee_reimbursement;

                    $total_kasbon = App\Models\Kasbon::where('user_id', auth()->user()->id)->whereBetween('tanggal', [$tgl_mulai, $tgl_akhir])->where('status', 'Acc')->sum('nominal');
                ?>
                <div class="wallet-footer">
                    <ul class="d-flex justify-content-between align-items-center">
                        <li class="wallet-card-item">
                            <a href="<?php echo e(url('/payroll')); ?>" class="fw_6 text-center" >
                                <ul class="icon icon-group-transfers">
                                    <li class="path1"></li>
                                    <li class="path2"></li>
                                    <li class="path3"></li>
                                </ul>
                                Payroll
                            </a>
                        </li>
                        <li class="wallet-card-item">
                            <a href="<?php echo e(url('/reimbursement')); ?>">
                                <div class="icon-box bg_color_6">
                                    <svg width="50" height="50" viewBox="0 -3.99 48.891 48.891" xmlns="http://www.w3.org/2000/svg">
                                        <g id="send_money" data-name="send money" transform="translate(-321.837 -134.263)">
                                          <path id="Path_48" data-name="Path 48" d="M334.31,150.727H322.337v23.946H334.31V150.727Z" fill="#ffe959" fill-rule="evenodd"/>
                                          <path id="Path_49" data-name="Path 49" d="M334.31,170.681a3.991,3.991,0,0,0-7.982,0v3.991h7.982v-3.991Z" fill="#e23a44" fill-rule="evenodd"/>
                                          <path id="Path_50" data-name="Path 50" d="M370.228,162.785a3.786,3.786,0,0,0-5.883-3.149c-3.027,2.022-6.09,4.061-6.09,4.061h-7.982a3.991,3.991,0,0,0,0-7.982h-7.982a2,2,0,0,0-1.995-1.995H336.3a1.993,1.993,0,0,0-1.993,1.993v15.966h23.945l11.219-7.479a1.688,1.688,0,0,0,.754-1.409v-.006Z" fill="#eeedec" fill-rule="evenodd"/>
                                          <path id="Path_51" data-name="Path 51" d="M370.228,134.763H338.3v15.964h31.927V134.763Z" fill="#56ae89" fill-rule="evenodd"/>
                                          <path id="Path_52" data-name="Path 52" d="M343.622,150.725a5.32,5.32,0,0,0-5.32-5.32h0v5.322h5.322v0Z" fill="#f2f7fd" fill-rule="evenodd"/>
                                          <path id="Path_53" data-name="Path 53" d="M343.622,134.765a5.32,5.32,0,0,1-5.32,5.32h0v-5.322h5.322v0Z" fill="#f2f7fd" fill-rule="evenodd"/>
                                          <path id="Path_54" data-name="Path 54" d="M364.906,150.725a5.321,5.321,0,0,1,5.32-5.32h0v5.322h-5.322v0Z" fill="#f2f7fd" fill-rule="evenodd"/>
                                          <path id="Path_55" data-name="Path 55" d="M364.906,134.765a5.32,5.32,0,0,0,5.32,5.32h0v-5.322h-5.322v0Z" fill="#f2f7fd" fill-rule="evenodd"/>
                                          <path id="Path_56" data-name="Path 56" d="M354.264,145.94v.8m0-7.982v.8m-1.6,4.789a1.6,1.6,0,1,0,1.6-1.6m1.6-1.6a1.6,1.6,0,1,0-1.6,1.6m10.642-7.98a5.32,5.32,0,0,0,5.32,5.32h0v-5.322h-5.322v0Zm0,15.96a5.321,5.321,0,0,1,5.32-5.32h0v5.322h-5.322v0Zm-21.284-15.96a5.32,5.32,0,0,1-5.32,5.32h0v-5.322h5.322v0Zm0,15.96a5.32,5.32,0,0,0-5.32-5.32h0v5.322h5.322v0Zm26.606-15.962H338.3v15.964h31.928V134.763Zm0,28.022a3.786,3.786,0,0,0-5.883-3.149c-3.027,2.022-6.09,4.061-6.09,4.061h-7.982a3.991,3.991,0,0,0,0-7.982h-7.982a2,2,0,0,0-1.995-1.995H336.3a2,2,0,0,0-1.995,1.995v15.964h23.945l11.219-7.479a1.688,1.688,0,0,0,.754-1.409v-.006Zm-35.918,7.9a3.991,3.991,0,0,0-7.982,0v3.991h7.982v-3.991Zm-11.973-3.991v7.982H334.31V150.727H322.337v7.982m0,3.492v1" fill="none" stroke="#0f0e0b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1"/>
                                        </g>
                                      </svg>
                                </div>
                                <p>Reimbursement</p>
                                <p style="color: green">Rp <?php echo e(number_format($total_reimbursement)); ?></p>
                             </a>
                        </li>
                        
                        <li class="wallet-card-item"><a class="fw_6" href="<?php echo e(url('/kasbon')); ?>">
                                <ul class="icon icon-group-credit-card">
                                    <li class="path1"></li>
                                    <li class="path2"></li>
                                    <li class="path3"></li>
                                </ul>
                                <p>Kasbon</p>
                                <p style="color: green">Rp <?php echo e(number_format($total_kasbon)); ?></p>
                            </a></li>
                    </ul>
                </div>
            </div>
        </div>

    </div>

    <div class="mt-5">
        <div class="tf-container">
            <div class="tf-title d-flex justify-content-between">
                <h3 class="fw_6">Layanan</h3>
            </div>
            <ul class="box-service mt-3">
                <li>
                    <a href="<?php echo e(url('/absen')); ?>">
                    <div class="icon-box bg_service-2">
                        <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M6.45831 5.67188C6.07 5.67188 5.75519 5.98669 5.75519 6.375C5.75519 6.76331 6.07 7.07812 6.45831 7.07812C6.84663 7.07812 7.16144 6.76331 7.16144 6.375C7.16144 5.98669 6.84663 5.67188 6.45831 5.67188ZM3.64581 11.2969C3.2575 11.2969 2.94269 11.6117 2.94269 12C2.94269 12.3883 3.2575 12.7031 3.64581 12.7031H6.45831C6.84663 12.7031 7.16144 12.3883 7.16144 12C7.16144 11.6117 6.84663 11.2969 6.45831 11.2969H3.64581ZM2.94269 3.5625V9.1875C2.94269 9.57581 3.2575 9.89062 3.64581 9.89062H9.27081C9.65913 9.89062 9.97394 9.57581 9.97394 9.1875V3.5625C9.97394 3.17419 9.65913 2.85938 9.27081 2.85938H3.64581C3.2575 2.85938 2.94269 3.17419 2.94269 3.5625ZM4.34894 4.26562H8.56769V8.48438H4.34894V4.26562ZM8.56769 12C8.56769 12.3883 8.8825 12.7031 9.27081 12.7031H14.8958C15.2841 12.7031 15.5989 12.3883 15.5989 12C15.5989 11.6117 15.2841 11.2969 14.8958 11.2969H12.7864L12.7864 3.5625C12.7864 3.17419 12.4716 2.85938 12.0833 2.85938C11.695 2.85938 11.3802 3.17419 11.3802 3.5625L11.3801 11.2969H9.27081C8.8825 11.2969 8.56769 11.6117 8.56769 12ZM14.8958 4.26562H19.8177V9.1875C19.8177 9.57581 20.1325 9.89062 20.5208 9.89062C20.9091 9.89062 21.2239 9.57581 21.2239 9.1875V3.5625C21.2239 3.17419 20.9091 2.85938 20.5208 2.85938H14.8958C14.5075 2.85938 14.1927 3.17419 14.1927 3.5625C14.1927 3.95081 14.5075 4.26562 14.8958 4.26562ZM17.0052 6.375C17.0052 6.76331 17.32 7.07812 17.7083 7.07812C18.0966 7.07812 18.4114 6.76331 18.4114 6.375C18.4114 5.98669 18.0966 5.67188 17.7083 5.67188C17.32 5.67188 17.0052 5.98669 17.0052 6.375ZM20.5208 11.2969H17.7083C17.32 11.2969 17.0052 11.6117 17.0052 12C17.0052 12.3883 17.32 12.7031 17.7083 12.7031H20.5208C20.9091 12.7031 21.2239 12.3883 21.2239 12C21.2239 11.6117 20.9091 11.2969 20.5208 11.2969ZM14.8958 9.89062H17.7083C18.0966 9.89062 18.4114 9.57581 18.4114 9.1875C18.4114 8.79919 18.0966 8.48438 17.7083 8.48438H15.5989V6.375C15.5989 5.98669 15.2841 5.67188 14.8958 5.67188C14.5075 5.67188 14.1927 5.98669 14.1927 6.375V9.1875C14.1927 9.57581 14.5075 9.89062 14.8958 9.89062ZM21.9739 0H19.1614C18.7731 0 18.4583 0.314812 18.4583 0.703125C18.4583 1.09144 18.7731 1.40625 19.1614 1.40625H21.9739C22.3616 1.40625 22.6771 1.72167 22.6771 2.10938V4.92188C22.6771 5.31019 22.9919 5.625 23.3802 5.625C23.7685 5.625 24.0833 5.31019 24.0833 4.92188V2.10938C24.0833 0.946266 23.137 0 21.9739 0ZM21.2239 20.4375V14.8125C21.2239 14.4242 20.9091 14.1094 20.5208 14.1094H14.8958C14.5075 14.1094 14.1927 14.4242 14.1927 14.8125V20.4375C14.1927 20.8258 14.5075 21.1406 14.8958 21.1406H20.5208C20.9091 21.1406 21.2239 20.8258 21.2239 20.4375ZM19.8177 19.7344H15.5989V15.5156H19.8177V19.7344ZM12.0833 14.1094C11.695 14.1094 11.3802 14.4242 11.3802 14.8125V20.4375C11.3802 20.8258 11.695 21.1406 12.0833 21.1406C12.4716 21.1406 12.7864 20.8258 12.7864 20.4375V14.8125C12.7864 14.4242 12.4716 14.1094 12.0833 14.1094ZM17.7083 18.3281C18.0966 18.3281 18.4114 18.0133 18.4114 17.625C18.4114 17.2367 18.0966 16.9219 17.7083 16.9219C17.32 16.9219 17.0052 17.2367 17.0052 17.625C17.0052 18.0133 17.32 18.3281 17.7083 18.3281ZM23.3802 18.375C22.9919 18.375 22.6771 18.6898 22.6771 19.0781V21.8906C22.6771 22.2783 22.3616 22.5938 21.9739 22.5938H19.1614C18.7731 22.5938 18.4583 22.9086 18.4583 23.2969C18.4583 23.6852 18.7731 24 19.1614 24H21.9739C23.137 24 24.0833 23.0537 24.0833 21.8906V19.0781C24.0833 18.6898 23.7685 18.375 23.3802 18.375ZM6.45831 18.3281C6.84663 18.3281 7.16144 18.0133 7.16144 17.625C7.16144 17.2367 6.84663 16.9219 6.45831 16.9219C6.07 16.9219 5.75519 17.2367 5.75519 17.625C5.75519 18.0133 6.07 18.3281 6.45831 18.3281ZM9.27081 14.1094H3.64581C3.2575 14.1094 2.94269 14.4242 2.94269 14.8125V20.4375C2.94269 20.8258 3.2575 21.1406 3.64581 21.1406H9.27081C9.65913 21.1406 9.97394 20.8258 9.97394 20.4375V14.8125C9.97394 14.4242 9.65913 14.1094 9.27081 14.1094ZM8.56769 19.7344H4.34894V15.5156H8.56769V19.7344ZM5.00519 22.5938H2.19269C1.80498 22.5938 1.48956 22.2783 1.48956 21.8906V19.0781C1.48956 18.6898 1.17475 18.375 0.786438 18.375C0.398125 18.375 0.083313 18.6898 0.083313 19.0781V21.8906C0.083313 23.0537 1.02958 24 2.19269 24H5.00519C5.3935 24 5.70831 23.6852 5.70831 23.2969C5.70831 22.9086 5.3935 22.5938 5.00519 22.5938ZM0.786438 5.625C1.17475 5.625 1.48956 5.31019 1.48956 4.92188V2.10938C1.48956 1.72167 1.80498 1.40625 2.19269 1.40625H5.00519C5.3935 1.40625 5.70831 1.09144 5.70831 0.703125C5.70831 0.314812 5.3935 0 5.00519 0H2.19269C1.02958 0 0.083313 0.946266 0.083313 2.10938V4.92188C0.083313 5.31019 0.398125 5.625 0.786438 5.625Z" fill="url(#paint0_linear_4552_4954)"/>
                            <defs>
                            <linearGradient id="paint0_linear_4552_4954" x1="12.0833" y1="24" x2="12.0833" y2="0" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#5558FF"/>
                            <stop offset="1" stop-color="#00C0FF"/>
                            </linearGradient>
                            </defs>
                            </svg>

                    </div>
                    Absensi
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(url('/cuti')); ?>">
                    <div class="icon-box bg_color_2">
                        <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_4355_17182)">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M12.1251 3.44482C11.8537 3.44482 11.5823 3.44929 11.3754 3.45819C7.2762 3.6346 3.36945 5.25275 0.34614 8.02658C0.0409477 8.30659 0.0419856 8.78279 0.334879 9.07568L1.73847 10.4793C2.03137 10.7722 2.50495 10.7704 2.81312 10.4937C5.17879 8.36971 8.20079 7.11796 11.3755 6.94708C11.7891 6.92482 12.4612 6.92482 12.8748 6.94708C16.0495 7.11796 19.0716 8.36971 21.4372 10.4937C21.7454 10.7704 22.219 10.7722 22.5119 10.4793L23.9154 9.07568C24.2083 8.78279 24.2094 8.30659 23.9042 8.02658C20.8809 5.25275 16.9742 3.63459 12.8749 3.45819C12.668 3.44929 12.3966 3.44482 12.1251 3.44482ZM12.0831 10.4116L11.3339 10.4416C9.09872 10.6112 6.9762 11.4953 5.28166 12.9627C4.9686 13.2338 4.97027 13.7111 5.26316 14.004L6.66667 15.4076C6.95956 15.7005 7.43228 15.6967 7.75477 15.437C8.79066 14.603 10.0444 14.0826 11.3663 13.9378L12.1251 13.8964C14.1994 14.0799 15.4569 14.6008 16.4955 15.437C16.818 15.6967 17.2907 15.7005 17.5836 15.4076L18.9872 14.004C19.2801 13.7111 19.2817 13.2338 18.9686 12.9627C17.2632 11.4859 15.1247 10.6002 12.8745 10.4385C12.4614 10.4089 12.1063 10.4116 12.0831 10.4116ZM12.1251 17.3954C11.854 17.3954 11.5828 17.4175 11.3809 17.4616C10.9771 17.5499 10.5921 17.7094 10.2442 17.9325C9.89616 18.1556 9.89855 18.6394 10.1914 18.9323L11.5949 20.3357C11.7355 20.4763 11.9263 20.5553 12.1252 20.5553C12.3241 20.5553 12.5148 20.4763 12.6555 20.3357L14.0589 18.9323C14.3518 18.6394 14.3542 18.1556 14.0062 17.9325C13.6582 17.7094 13.2732 17.5499 12.8694 17.4616C12.6674 17.4175 12.3963 17.3954 12.1251 17.3954Z" fill="#1E90FF"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M12.134 3.44482V6.93042C12.4023 6.93056 12.6702 6.93599 12.8746 6.94699C16.0493 7.11786 19.0714 8.36962 21.4371 10.4937C21.7453 10.7703 22.2189 10.7721 22.5118 10.4792L23.9153 9.07559C24.2082 8.7827 24.2093 8.3065 23.9041 8.02649C20.8808 5.25266 16.974 3.6345 12.8748 3.4581C12.6703 3.4493 12.4024 3.44492 12.134 3.44482ZM0.133981 8.39334C0.110813 8.49681 0.111064 8.60452 0.133981 8.70874V8.39334ZM12.134 10.4115V13.8971C14.2028 14.0814 15.4582 14.602 16.4954 15.437C16.8179 15.6966 17.2906 15.7004 17.5835 15.4075L18.9871 14.0039C19.28 13.711 19.2815 13.2337 18.9685 12.9626C17.2631 11.4858 15.1246 10.6001 12.8744 10.4384C12.5312 10.4138 12.2401 10.4116 12.134 10.4115ZM12.134 17.3955V20.5552C12.3298 20.5529 12.5169 20.474 12.6554 20.3356L14.0588 18.9322C14.3517 18.6393 14.3541 18.1556 14.0061 17.9324C13.6581 17.7093 13.273 17.5498 12.8692 17.4615C12.6695 17.4179 12.4021 17.396 12.134 17.3955Z" fill="#0584FF"/>
                            </g>
                            <defs>
                            <clipPath id="clip0_4355_17182">
                            <rect width="24" height="24" fill="white" transform="translate(0.125)"/>
                            </clipPath>
                            </defs>
                            </svg>

                    </div>
                    Cuti & Izin
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(url('/dinas-luar')); ?>">
                        <div class="icon-box bg_color_3">
                        <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5.87511 1.25C5.49974 1.24954 5.1266 1.30757 4.76911 1.422C4.00043 1.65173 3.32708 2.12475 2.85029 2.76998C2.37349 3.4152 2.11901 4.19775 2.12511 5V10C2.12564 10.7292 2.41554 11.4284 2.93115 11.944C3.44676 12.4596 4.14592 12.7495 4.87511 12.75H8.87511C9.07402 12.75 9.26479 12.671 9.40544 12.5303C9.54609 12.3897 9.62511 12.1989 9.62511 12V5C9.62379 4.00585 9.22827 3.05279 8.5253 2.34981C7.82232 1.64684 6.86926 1.25133 5.87511 1.25Z" fill="#DA9B00"/>
                            <path d="M23.6248 6.00002V20C23.625 20.3612 23.5541 20.7189 23.416 21.0527C23.2779 21.3865 23.0753 21.6897 22.8199 21.9452C22.5645 22.2006 22.2612 22.4031 21.9275 22.5412C21.5937 22.6793 21.236 22.7503 20.8748 22.75H10.8748C10.5136 22.7503 10.1558 22.6793 9.82208 22.5412C9.48831 22.4031 9.18505 22.2006 8.92964 21.9452C8.67422 21.6897 8.47167 21.3865 8.33356 21.0527C8.19545 20.7189 8.1245 20.3612 8.12477 20V4.25002C8.12328 3.54389 7.87275 2.86092 7.41729 2.32131C6.96182 1.78171 6.33062 1.42006 5.63477 1.30002C5.70929 1.26345 5.79184 1.24626 5.87477 1.25002H18.8748C20.1342 1.25108 21.3418 1.75186 22.2324 2.64243C23.1229 3.533 23.6237 4.74057 23.6248 6.00002Z" fill="#FECC0E"/>
                            <path d="M15.875 8.75H12.875C12.6761 8.75 12.4853 8.67098 12.3447 8.53033C12.204 8.38968 12.125 8.19891 12.125 8C12.125 7.80109 12.204 7.61032 12.3447 7.46967C12.4853 7.32902 12.6761 7.25 12.875 7.25H15.875C16.0739 7.25 16.2647 7.32902 16.4053 7.46967C16.546 7.61032 16.625 7.80109 16.625 8C16.625 8.19891 16.546 8.38968 16.4053 8.53033C16.2647 8.67098 16.0739 8.75 15.875 8.75Z" fill="white"/>
                            <path d="M18.875 11.75H12.875C12.6761 11.75 12.4853 11.671 12.3447 11.5303C12.204 11.3897 12.125 11.1989 12.125 11C12.125 10.8011 12.204 10.6103 12.3447 10.4697C12.4853 10.329 12.6761 10.25 12.875 10.25H18.875C19.0739 10.25 19.2647 10.329 19.4053 10.4697C19.546 10.6103 19.625 10.8011 19.625 11C19.625 11.1989 19.546 11.3897 19.4053 11.5303C19.2647 11.671 19.0739 11.75 18.875 11.75Z" fill="white"/>
                            <path d="M18.875 14.75H12.875C12.6761 14.75 12.4853 14.671 12.3447 14.5303C12.204 14.3897 12.125 14.1989 12.125 14C12.125 13.8011 12.204 13.6103 12.3447 13.4697C12.4853 13.329 12.6761 13.25 12.875 13.25H18.875C19.0739 13.25 19.2647 13.329 19.4053 13.4697C19.546 13.6103 19.625 13.8011 19.625 14C19.625 14.1989 19.546 14.3897 19.4053 14.5303C19.2647 14.671 19.0739 14.75 18.875 14.75Z" fill="white"/>
                            <path d="M18.875 17.75H12.875C12.6761 17.75 12.4853 17.671 12.3447 17.5303C12.204 17.3897 12.125 17.1989 12.125 17C12.125 16.8011 12.204 16.6103 12.3447 16.4697C12.4853 16.329 12.6761 16.25 12.875 16.25H18.875C19.0739 16.25 19.2647 16.329 19.4053 16.4697C19.546 16.6103 19.625 16.8011 19.625 17C19.625 17.1989 19.546 17.3897 19.4053 17.5303C19.2647 17.671 19.0739 17.75 18.875 17.75Z" fill="white"/>
                        </svg>

                        </div>
                        Dinas Luar
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(url('/lembur')); ?>">
                    <div class="icon-box bg_color_4">
                        <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_4355_16088)">
                            <path d="M20.3247 10.3362C20.1985 10.1213 19.9678 9.98934 19.7186 9.98934H14.5737L15.2515 0.754543C15.2756 0.425527 15.0678 0.12398 14.7518 0.0294335C14.4357 -0.0653009 13.7855 -0.288481 13.625 -0.000246391L6.91695 12.9651C6.79568 13.1828 6.79878 13.4485 6.92506 13.6634C7.05134 13.8783 7.28201 14.0102 7.53124 14.0102H12.6762L11.625 23.9998H12.625C12.9436 24.0952 13.1548 23.9244 13.3139 23.6386L20.3329 11.0346C20.4541 10.8168 20.451 10.5511 20.3247 10.3362Z" fill="#C8A52A"/>
                            <path d="M19.3247 10.3364C19.1985 10.1215 18.9678 9.98956 18.7186 9.98956H13.5737L14.2515 0.754767C14.2756 0.425751 14.0678 0.124204 13.7518 0.0296573C13.4357 -0.0650771 13.0965 0.0729229 12.936 0.361157L5.91695 12.9653C5.79568 13.1831 5.79878 13.4487 5.92506 13.6636C6.05134 13.8785 6.28201 14.0105 6.53124 14.0105H11.6762L10.9983 23.2453C10.9742 23.5743 11.182 23.8758 11.4981 23.9704C11.8167 24.0658 12.1548 23.9246 12.3139 23.6389L19.3329 11.0348C19.4541 10.817 19.451 10.5513 19.3247 10.3364Z" fill="#F2C31C"/>
                            </g>
                            <defs>
                            <clipPath id="clip0_4355_16088">
                            <rect width="24" height="24" fill="white" transform="translate(0.625)"/>
                            </clipPath>
                            </defs>
                        </svg>
                    </div>
                    Lembur
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(url('/request-location')); ?>">
                    <div class="icon-box bg_color_5">
                        <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_4355_16445)">
                            <path d="M12.9209 20.7275C18.6446 20.7275 23.2846 16.0875 23.2846 10.3637C23.2846 4.64 18.6446 0 12.9209 0C7.19713 0 2.55713 4.64 2.55713 10.3637C2.55713 16.0875 7.19713 20.7275 12.9209 20.7275Z" fill="#F57C04"/>
                            <path d="M12.9204 19.6363C18.0415 19.6363 22.1929 15.4848 22.1929 10.3638C22.1929 5.24274 18.0415 1.09131 12.9204 1.09131C7.79938 1.09131 3.64795 5.24274 3.64795 10.3638C3.64795 15.4848 7.79938 19.6363 12.9204 19.6363Z" fill="#F55600"/>
                            <path d="M10.7389 18.5456C15.2575 18.5456 18.9206 14.8825 18.9206 10.3639C18.9206 5.84522 15.2575 2.18213 10.7389 2.18213C6.22022 2.18213 2.55713 5.84522 2.55713 10.3639C2.55713 14.8825 6.22022 18.5456 10.7389 18.5456Z" fill="#744EC1"/>
                            <path d="M10.7385 17.4545C14.6548 17.4545 17.8295 14.2797 17.8295 10.3635C17.8295 6.44722 14.6548 3.27246 10.7385 3.27246C6.82222 3.27246 3.64746 6.44722 3.64746 10.3635C3.64746 14.2797 6.82222 17.4545 10.7385 17.4545Z" fill="#653BBA"/>
                            <path d="M10.7386 15.2727C13.4498 15.2727 15.6477 13.0748 15.6477 10.3636C15.6477 7.65245 13.4498 5.45459 10.7386 5.45459C8.02745 5.45459 5.82959 7.65245 5.82959 10.3636C5.82959 13.0748 8.02745 15.2727 10.7386 15.2727Z" fill="#5628B4"/>
                            <path d="M10.7388 13.0909C12.2449 13.0909 13.4659 11.8699 13.4659 10.3638C13.4659 8.85767 12.2449 7.63672 10.7388 7.63672C9.23267 7.63672 8.01172 8.85767 8.01172 10.3638C8.01172 11.8699 9.23267 13.0909 10.7388 13.0909Z" fill="#3E0AA9"/>
                            <path d="M10.7385 2.18194C9.23226 2.18194 8.01123 3.40297 8.01123 4.90918C8.01123 6.41539 9.23226 7.63641 10.7385 7.63641H10.7432H10.7449H10.7479H10.7499H10.7526H10.7547H10.7573H10.7595H10.762H10.7643H10.7667H10.769H10.7713L10.7737 7.63636H10.7752L10.7815 7.63626H10.7828L10.7859 7.63621L10.7874 7.63616L10.7903 7.63611L10.7921 7.63605L10.795 7.636L10.7966 7.63595L10.7997 7.6359L10.8011 7.63585L10.8043 7.63575H10.8054L10.8089 7.63565H10.8092C10.8148 7.63549 10.8204 7.63534 10.8259 7.63519H10.8267L10.8302 7.63508L10.8313 7.63503L10.8347 7.63493L10.8358 7.63488L10.8392 7.63478L10.8403 7.63473L10.8436 7.63462L10.8448 7.63457L10.8483 7.63442H10.8485C10.8522 7.63426 10.856 7.63411 10.8597 7.63396L10.8618 7.63386L10.8639 7.63375L10.8666 7.63365L10.8684 7.63355L10.8716 7.6334L10.8729 7.63334L10.8766 7.63314L10.8774 7.63309C10.8838 7.63278 10.8903 7.63242 10.8967 7.63207C11.1975 7.61488 11.4274 7.35711 11.4101 7.05633C11.3936 6.76782 11.155 6.54226 10.866 6.542C10.8556 6.542 10.845 6.54231 10.8344 6.54292C10.8027 6.54476 10.7707 6.54563 10.7385 6.54568C9.83479 6.54568 9.10217 5.81306 9.10217 4.90933C9.10217 4.00561 9.83479 3.27298 10.7385 3.27298C11.0374 3.31062 11.3107 3.09452 11.3484 2.79563C11.386 2.49674 11.1742 2.22398 10.8753 2.18634C10.83 2.18051 10.7842 2.18051 10.7385 2.18194Z" fill="#3E0AA9"/>
                            <path d="M7.53387 12.0493C6.02767 12.0493 4.80664 13.2703 4.80664 14.7766C4.80664 16.2828 6.02767 17.5038 7.53387 17.5038H7.53858H7.54027H7.54328H7.54533H7.54804H7.55009H7.55274H7.55494H7.5574H7.5597H7.5621H7.56445H7.5667L7.56916 17.5037H7.57064L7.57693 17.5036H7.57821L7.58128 17.5036L7.58281 17.5035L7.58573 17.5035L7.58747 17.5034L7.59043 17.5034L7.59197 17.5033L7.59514 17.5033L7.59647 17.5032L7.59974 17.5031H7.60081L7.60434 17.503H7.6046C7.61017 17.5029 7.61579 17.5027 7.62132 17.5026H7.62208L7.62561 17.5025L7.62669 17.5024L7.63006 17.5023L7.63119 17.5023L7.63456 17.5021L7.63574 17.5021L7.63901 17.502L7.64019 17.5019L7.64366 17.5018H7.64392C7.64765 17.5016 7.65139 17.5015 7.65512 17.5013L7.65716 17.5012L7.65926 17.5011L7.66197 17.501L7.66376 17.5009L7.66698 17.5008L7.66826 17.5007L7.67199 17.5005L7.67281 17.5005C7.67925 17.5002 7.6857 17.4998 7.69214 17.4994C7.99292 17.4823 8.22278 17.2245 8.20555 16.9238C8.18903 16.6352 7.95043 16.4097 7.66146 16.4094C7.65098 16.4094 7.64044 16.4097 7.62986 16.4103C7.5981 16.4122 7.56609 16.4131 7.53393 16.4131C6.6302 16.4131 5.89758 15.6805 5.89758 14.7768C5.89758 13.873 6.6302 13.1404 7.53393 13.1404C7.83517 13.1404 8.07939 12.8962 8.07939 12.5949C8.07934 12.2935 7.83512 12.0493 7.53387 12.0493Z" fill="#3E0AA9"/>
                            <path d="M5.55145 5.95068C4.04524 5.95068 2.82422 7.17171 2.82422 8.67792C2.82422 10.1841 4.04524 11.4052 5.55145 11.4052H5.55616H5.55785H5.56086H5.56291H5.56562H5.56766H5.57032H5.57252H5.57498H5.57728H5.57968H5.58203H5.58428L5.58674 11.4051H5.58822L5.59451 11.405H5.59579L5.59886 11.4049L5.60039 11.4049L5.60331 11.4048L5.60504 11.4048L5.60801 11.4047L5.60954 11.4047L5.61271 11.4046L5.61404 11.4046L5.61732 11.4045H5.61839L5.62192 11.4044H5.62217C5.62775 11.4042 5.63337 11.4041 5.6389 11.4039H5.63966L5.64319 11.4038L5.64426 11.4038L5.64764 11.4037L5.64877 11.4036L5.65214 11.4035L5.65332 11.4035L5.65659 11.4034L5.65776 11.4033L5.66124 11.4032H5.6615C5.66523 11.403 5.66896 11.4029 5.6727 11.4027L5.67474 11.4026L5.67684 11.4025L5.67955 11.4024L5.68134 11.4023L5.68456 11.4021L5.68584 11.4021L5.68957 11.4019L5.69039 11.4018C5.69683 11.4015 5.70328 11.4012 5.70972 11.4008C6.0105 11.3836 6.24036 11.1258 6.22312 10.8251C6.20661 10.5366 5.96801 10.311 5.67904 10.3107C5.66855 10.3107 5.65802 10.311 5.64744 10.3117C5.61568 10.3135 5.58367 10.3144 5.5515 10.3144C4.64778 10.3144 3.91515 9.5818 3.91515 8.67807C3.91515 7.77435 4.64778 7.04172 5.5515 7.04172C5.85275 7.04203 6.09723 6.79811 6.09753 6.49682C6.09784 6.19552 5.85392 5.95109 5.55263 5.95079C5.55217 5.95068 5.55181 5.95068 5.55145 5.95068Z" fill="#3E0AA9"/>
                            <path d="M15.9255 5.95068C14.4193 5.95068 13.1982 7.17171 13.1982 8.67792C13.1982 10.1841 14.4193 11.4052 15.9255 11.4052H15.9302H15.9319H15.9349H15.9369H15.9396H15.9417H15.9443H15.9465H15.949H15.9513H15.9537H15.9561H15.9583L15.9608 11.4051H15.9622L15.9685 11.405H15.9698L15.9729 11.4049L15.9744 11.4049L15.9773 11.4048L15.9791 11.4048L15.982 11.4047L15.9836 11.4047L15.9867 11.4046L15.9881 11.4046L15.9913 11.4045H15.9924L15.9959 11.4044H15.9962C16.0018 11.4042 16.0074 11.4041 16.0129 11.4039H16.0137L16.0172 11.4038L16.0183 11.4038L16.0217 11.4037L16.0228 11.4036L16.0262 11.4035L16.0273 11.4035L16.0306 11.4034L16.0318 11.4033L16.0353 11.4032H16.0355C16.0393 11.403 16.043 11.4029 16.0467 11.4027L16.0488 11.4026L16.0509 11.4025L16.0536 11.4024L16.0553 11.4023L16.0585 11.4021L16.0598 11.4021L16.0635 11.4019L16.0644 11.4018C16.0708 11.4015 16.0772 11.4012 16.0837 11.4008C16.3845 11.3836 16.6143 11.1258 16.5971 10.8251C16.5806 10.5366 16.342 10.311 16.053 10.3107C16.0425 10.3107 16.032 10.311 16.0214 10.3117C15.9897 10.3135 15.9576 10.3144 15.9255 10.3144C15.0218 10.3144 14.2891 9.5818 14.2891 8.67807C14.2891 7.77435 15.0218 7.04172 15.9255 7.04172C16.2267 7.04203 16.4712 6.79811 16.4715 6.49682C16.4718 6.19557 16.2279 5.95109 15.9266 5.95079C15.9262 5.95068 15.9259 5.95068 15.9255 5.95068Z" fill="#3E0AA9"/>
                            <path d="M13.9455 12.0493C12.4393 12.0493 11.2183 13.2703 11.2183 14.7766C11.2183 16.2828 12.4393 17.5038 13.9455 17.5038H13.9502H13.9519H13.9549H13.957H13.9597H13.9617H13.9644H13.9666H13.969H13.9713H13.9737H13.9761H13.9783L13.9808 17.5037H13.9823L13.9886 17.5036H13.9898L13.9929 17.5036L13.9944 17.5035L13.9973 17.5035L13.9991 17.5034L14.0021 17.5034L14.0036 17.5033L14.0068 17.5033L14.0081 17.5032L14.0114 17.5031H14.0124L14.016 17.503H14.0162C14.0218 17.5029 14.0274 17.5027 14.0329 17.5026H14.0337L14.0372 17.5025L14.0383 17.5024L14.0417 17.5023L14.0428 17.5023L14.0462 17.5021L14.0474 17.5021L14.0506 17.502L14.0518 17.5019L14.0553 17.5018H14.0555C14.0593 17.5016 14.063 17.5015 14.0667 17.5013L14.0688 17.5012L14.0709 17.5011L14.0736 17.501L14.0753 17.5009L14.0786 17.5008L14.0798 17.5007L14.0836 17.5005L14.0844 17.5005C14.0908 17.5002 14.0973 17.4998 14.1037 17.4994C14.4045 17.4823 14.6343 17.2245 14.6171 16.9238C14.6006 16.6352 14.362 16.4097 14.073 16.4094C14.0625 16.4094 14.052 16.4097 14.0414 16.4103C14.0097 16.4122 13.9777 16.4131 13.9455 16.4131C13.0418 16.4131 12.3091 15.6805 12.3091 14.7768C12.3091 13.873 13.0418 13.1404 13.9455 13.1404C14.2467 13.1404 14.491 12.8962 14.491 12.5949C14.491 12.2935 14.2467 12.0493 13.9455 12.0493Z" fill="#3E0AA9"/>
                            <path d="M21.1023 10.9092V16.3637C21.1023 18.1712 22.5675 19.6364 24.375 19.6364V24C20.7601 24 17.8296 21.0695 17.8296 17.4546V10.9092H21.1023Z" fill="#5628B4"/>
                            <path d="M10.7386 0C5.01492 0 0.375 4.63992 0.375 10.3636C0.375 16.0872 5.01492 20.7271 10.7386 20.7271C16.4622 20.7271 21.1021 16.0872 21.1021 10.3636C21.1021 4.63992 16.4622 0 10.7386 0ZM10.7386 2.18182C12.2448 2.18182 13.4658 3.40284 13.4658 4.90905C13.4658 6.41526 12.2448 7.63629 10.7386 7.63629C9.23236 7.63629 8.01134 6.41526 8.01134 4.90905C8.01134 3.40284 9.23231 2.18182 10.7385 2.18182C10.7385 2.18182 10.7385 2.18182 10.7386 2.18182ZM2.95721 7.83526C3.42265 6.40273 4.96123 5.61877 6.39375 6.08421C7.82628 6.54965 8.61024 8.08823 8.1448 9.52075C7.67936 10.9533 6.14078 11.7372 4.70826 11.2718H4.70821C3.27574 10.8064 2.49182 9.26778 2.95721 7.83526ZM9.73886 16.3794C8.85355 17.5979 7.14801 17.8681 5.92944 16.9827C4.71087 16.0973 4.44072 14.3919 5.32604 13.1733C6.21135 11.9547 7.91689 11.6846 9.13546 12.5699C10.354 13.4553 10.6242 15.1608 9.73886 16.3794ZM9.10222 10.3636C9.10222 9.45985 9.83485 8.72722 10.7386 8.72722C11.6423 8.72722 12.3749 9.45985 12.3749 10.3636C12.3749 11.2673 11.6423 11.9999 10.7386 11.9999C9.83485 11.9999 9.10222 11.2673 9.10222 10.3636ZM15.5477 16.9828C14.3291 17.8681 12.6235 17.5979 11.7382 16.3794C10.8529 15.1608 11.1231 13.4553 12.3416 12.57C13.5601 11.6847 15.2657 11.9548 16.151 13.1733C17.0363 14.3919 16.7662 16.0974 15.5477 16.9828ZM16.7689 11.2717C15.3364 11.7372 13.7978 10.9532 13.3323 9.52075C12.8669 8.08828 13.6509 6.5497 15.0833 6.08421C16.5158 5.61872 18.0544 6.40273 18.5199 7.83521C18.9853 9.26778 18.2014 10.8063 16.7689 11.2717Z" fill="#F7B236"/>
                            <path d="M10.7386 0C5.01492 0 0.375 4.63992 0.375 10.3636C0.375 16.0872 5.01492 20.7271 10.7386 20.7271C16.4622 20.7271 21.1021 16.0872 21.1021 10.3636C21.1021 4.63992 16.4622 0 10.7386 0ZM10.7386 2.18182C12.2448 2.18182 13.4658 3.40284 13.4658 4.90905C13.4658 6.41526 12.2448 7.63629 10.7386 7.63629C9.23236 7.63629 8.01134 6.41526 8.01134 4.90905C8.01134 3.40284 9.23231 2.18182 10.7385 2.18182C10.7385 2.18182 10.7385 2.18182 10.7386 2.18182ZM2.95721 7.83526C3.42265 6.40273 4.96123 5.61877 6.39375 6.08421C7.82628 6.54965 8.61024 8.08823 8.1448 9.52075C7.67936 10.9533 6.14078 11.7372 4.70826 11.2718H4.70821C3.27574 10.8064 2.49182 9.26778 2.95721 7.83526ZM9.73886 16.3794C8.85355 17.5979 7.14801 17.8681 5.92944 16.9827C4.71087 16.0973 4.44072 14.3919 5.32604 13.1733C6.21135 11.9547 7.91689 11.6846 9.13546 12.5699C10.354 13.4553 10.6242 15.1608 9.73886 16.3794ZM9.10222 10.3636C9.10222 9.45985 9.83485 8.72722 10.7386 8.72722C11.6423 8.72722 12.3749 9.45985 12.3749 10.3636C12.3749 11.2673 11.6423 11.9999 10.7386 11.9999C9.83485 11.9999 9.10222 11.2673 9.10222 10.3636ZM15.5477 16.9828C14.3291 17.8681 12.6235 17.5979 11.7382 16.3794C10.8529 15.1608 11.1231 13.4553 12.3416 12.57C13.5601 11.6847 15.2657 11.9548 16.151 13.1733C17.0363 14.3919 16.7662 16.0974 15.5477 16.9828ZM16.7689 11.2717C15.3364 11.7372 13.7978 10.9532 13.3323 9.52075C12.8669 8.08828 13.6509 6.5497 15.0833 6.08421C16.5158 5.61872 18.0544 6.40273 18.5199 7.83521C18.9853 9.26778 18.2014 10.8063 16.7689 11.2717Z" fill="#F7B236"/>
                            <path d="M10.7385 1.09131C5.61729 1.09131 1.46582 5.24283 1.46582 10.3639C1.46582 15.4851 5.61734 19.6366 10.7385 19.6366C15.8596 19.6366 20.0111 15.4851 20.0111 10.3639C20.0111 5.24278 15.8596 1.09131 10.7385 1.09131ZM10.7385 2.18219C12.2447 2.18219 13.4657 3.40322 13.4657 4.90943C13.4657 6.41564 12.2447 7.63666 10.7385 7.63666C9.23225 7.63666 8.01122 6.41564 8.01122 4.90943C8.01122 3.40322 9.2322 2.18219 10.7384 2.18219C10.7384 2.18219 10.7384 2.18219 10.7385 2.18219ZM2.9571 7.83563C3.42254 6.40311 4.96112 5.61914 6.39364 6.08458C7.82616 6.55002 8.61013 8.0886 8.14469 9.52112C7.67925 10.9536 6.14067 11.7376 4.70815 11.2722H4.7081C3.27562 10.8067 2.49171 9.26815 2.9571 7.83563ZM9.73875 16.3797C8.85343 17.5983 7.1479 17.8685 5.92933 16.9831C4.71076 16.0977 4.4406 14.3922 5.32592 13.1737C6.21124 11.9551 7.91678 11.6849 9.13535 12.5703C10.3539 13.4557 10.6241 15.1612 9.73875 16.3797ZM9.10211 10.3639C9.10211 9.46022 9.83473 8.7276 10.7385 8.7276C11.6422 8.7276 12.3748 9.46022 12.3748 10.3639C12.3748 11.2677 11.6422 12.0003 10.7385 12.0003C9.83473 12.0003 9.10211 11.2677 9.10211 10.3639ZM15.5475 16.9831C14.329 17.8685 12.6234 17.5983 11.7381 16.3798C10.8528 15.1612 11.1229 13.4557 12.3415 12.5704C13.56 11.685 15.2656 11.9552 16.1509 13.1737C17.0362 14.3923 16.7661 16.0978 15.5475 16.9831ZM16.7688 11.2721C15.3363 11.7376 13.7977 10.9536 13.3322 9.52112C12.8668 8.08865 13.6508 6.55007 15.0832 6.08458C16.5157 5.61909 18.0543 6.40311 18.5198 7.83558C18.9852 9.26815 18.2012 10.8067 16.7688 11.2721Z" fill="#F9C15D"/>
                            <path d="M10.7386 0H10.7304H10.729H10.722H10.7212H10.7136H10.713H10.7057H10.704H10.6985H10.6943H10.6927C10.6879 0 10.6831 5.1136e-05 10.6784 5.1136e-05H10.677H10.6728C10.0704 0.00649427 9.58722 0.50011 9.59367 1.10254C9.60006 1.70165 10.0885 2.18345 10.6876 2.18177H10.6907L10.7385 2.18161C15.2499 2.18161 18.9203 5.85195 18.9203 10.3634C18.9203 14.8748 15.2499 18.5451 10.7385 18.5451C9.64593 18.5475 8.56415 18.3296 7.55769 17.9044C7.00281 17.6697 6.36269 17.9292 6.12798 18.4841C5.89326 19.039 6.15278 19.6791 6.70766 19.9138C6.70796 19.914 6.70832 19.9141 6.70863 19.9142C6.86342 19.9796 7.0201 20.0413 7.17872 20.0993L7.17898 20.0995L7.18624 20.1021L7.18629 20.1022L7.1935 20.1048L7.19391 20.1049L7.20102 20.1075L7.20122 20.1076L7.20838 20.1102L7.20874 20.1103L7.21595 20.1129H7.216L7.22336 20.1156L7.22352 20.1157C7.22602 20.1166 7.22837 20.1174 7.23088 20.1183H7.23093L7.23814 20.1209L7.2386 20.1211L7.24561 20.1236L7.24602 20.1237L7.25302 20.1262L7.25353 20.1264L7.26054 20.129L7.26095 20.1291L7.26785 20.1316L7.26867 20.1319L7.27532 20.1342L7.27608 20.1345C7.27823 20.1352 7.28058 20.1361 7.28278 20.1368L7.2836 20.1371L7.29025 20.1395L7.29102 20.1397L7.29756 20.142L7.29874 20.1425L7.30503 20.1447L7.30615 20.1451L7.31249 20.1473L7.31367 20.1477L7.32001 20.1499L7.32108 20.1502L7.32732 20.1524L7.3287 20.1529L7.33484 20.155L7.33612 20.1555L7.34236 20.1576L7.34363 20.1581L7.34987 20.1603L7.35105 20.1607L7.35729 20.1628L7.35872 20.1633L7.36475 20.1654L7.36613 20.1659L7.37217 20.168L7.37375 20.1685L7.37974 20.1706L7.38117 20.171L7.3872 20.1731L7.38874 20.1736L7.39467 20.1756L7.39625 20.1762L7.40213 20.1781L7.40387 20.1788L7.40965 20.1807L7.41134 20.1813L7.41712 20.1832L7.41906 20.1839L7.42458 20.1857L7.42653 20.1864L7.4321 20.1883L7.43399 20.1889L7.43967 20.1908L7.44146 20.1914L7.44708 20.1933L7.44918 20.194L7.45465 20.1958L7.4567 20.1965L7.46212 20.1983L7.46437 20.199L7.46968 20.2008L7.47183 20.2015L7.4772 20.2033L7.4794 20.204L7.48472 20.2057L7.48697 20.2065L7.49229 20.2082L7.49454 20.209L7.49991 20.2108L7.50195 20.2114L7.50747 20.2132L7.50957 20.2139L7.51504 20.2157L7.51709 20.2163L7.52251 20.2181L7.52471 20.2189L7.53018 20.2206L7.53212 20.2213L7.53754 20.223L7.54 20.2238L7.54506 20.2254L7.54756 20.2263L7.55268 20.2279L7.55518 20.2287L7.56025 20.2304L7.5627 20.2312L7.56781 20.2328L7.57032 20.2336L7.57543 20.2353L7.57768 20.236L7.583 20.2377L7.58541 20.2384L7.59062 20.2401L7.59297 20.2408L7.59809 20.2425L7.6009 20.2434L7.6056 20.2449L7.60836 20.2458L7.61322 20.2473L7.61598 20.2482L7.62089 20.2497L7.62345 20.2505L7.62841 20.2521L7.63112 20.253L7.63603 20.2545L7.63864 20.2553L7.64355 20.2568L7.64631 20.2577L7.65117 20.2593L7.65382 20.2601L7.65868 20.2616L7.66165 20.2625L7.66625 20.264L7.66917 20.2648L7.67377 20.2663L7.67689 20.2672L7.68144 20.2686L7.68435 20.2695L7.68906 20.271L7.69218 20.2719L7.69657 20.2733L7.6998 20.2743L7.70424 20.2756L7.70747 20.2766L7.71192 20.2779L7.71504 20.2788L7.71953 20.2802L7.72281 20.2812L7.72715 20.2826L7.73032 20.2835L7.73477 20.2849L7.73805 20.2858L7.74239 20.2872L7.74551 20.2881L7.75001 20.2895L7.75328 20.2904L7.75768 20.2918L7.7608 20.2927L7.76535 20.294L7.76847 20.2949L7.77302 20.2963L7.77609 20.2972L7.78054 20.2985L7.78392 20.2995L7.78821 20.3008L7.79148 20.3018L7.79578 20.3031L7.79926 20.3041L7.8035 20.3053L7.80677 20.3063L7.81112 20.3076L7.81449 20.3085L7.81874 20.3098L7.82211 20.3107L7.82641 20.312L7.82978 20.313L7.83413 20.3142L7.83735 20.3151L7.8417 20.3164L7.84523 20.3174L7.84937 20.3186L7.85279 20.3196L7.85694 20.3209L7.86057 20.3219L7.86466 20.3231L7.86803 20.324L7.87233 20.3253L7.87581 20.3262L7.88 20.3274L7.88348 20.3284L7.88762 20.3296L7.89125 20.3306L7.89534 20.3318L7.89872 20.3328L7.90296 20.334L7.90654 20.335L7.91058 20.3362L7.91416 20.3372L7.9183 20.3384L7.92178 20.3393L7.92602 20.3405L7.9294 20.3415L7.93364 20.3427L7.93722 20.3437L7.94126 20.3448L7.94489 20.3458L7.94898 20.3469L7.95261 20.348L7.95665 20.3491L7.96018 20.3501L7.96437 20.3512L7.96806 20.3523L7.97199 20.3533L7.97562 20.3544L7.97982 20.3555L7.98329 20.3565L7.98754 20.3577L7.99096 20.3586L7.99521 20.3598L7.99884 20.3608L8.00288 20.3619L8.00656 20.3629L8.0106 20.364L8.01428 20.3651L8.01832 20.3662L8.0219 20.3671L8.02604 20.3683L8.02973 20.3692L8.03376 20.3704L8.03729 20.3713L8.04149 20.3725L8.04507 20.3734L8.04921 20.3746L8.05279 20.3755L8.05683 20.3766L8.06071 20.3776L8.06455 20.3787L8.06844 20.3797L8.07227 20.3807L8.07616 20.3817L8.08009 20.3828L8.08367 20.3837L8.08782 20.3848L8.0915 20.3858L8.09559 20.3869L8.09917 20.3878L8.10326 20.3889L8.10704 20.3899L8.11103 20.3909L8.11471 20.3919L8.1187 20.3929L8.12264 20.3939L8.12642 20.3949L8.13026 20.3959L8.13425 20.397L8.13803 20.3979L8.14197 20.399L8.14575 20.3999L8.14969 20.4009L8.15373 20.402L8.15741 20.4029L8.16145 20.4039L8.16524 20.4049L8.16933 20.406L8.17296 20.4069L8.17705 20.4079L8.18073 20.4088L8.18492 20.4099L8.1885 20.4108L8.19264 20.4119L8.19628 20.4128L8.20047 20.4139L8.20405 20.4148L8.20814 20.4158L8.21182 20.4167L8.21606 20.4178L8.21954 20.4187L8.22374 20.4198L8.22737 20.4207L8.23151 20.4217L8.23524 20.4226L8.23918 20.4236L8.24301 20.4245L8.2471 20.4255L8.25079 20.4265L8.25483 20.4274L8.25861 20.4284L8.26255 20.4293L8.26648 20.4303L8.27027 20.4312L8.2741 20.4321L8.2786 20.4332L8.28177 20.434L8.28633 20.4351L8.2896 20.4359L8.29405 20.437L8.29747 20.4378L8.30172 20.4388L8.30519 20.4397L8.3098 20.4408L8.31297 20.4416L8.31742 20.4427L8.32079 20.4435L8.32524 20.4446L8.32862 20.4454L8.33286 20.4464L8.33644 20.4473L8.34084 20.4483L8.34421 20.4491L8.34856 20.4501L8.35214 20.451L8.35643 20.452L8.35991 20.4528L8.36415 20.4538L8.36779 20.4546L8.37198 20.4556L8.37566 20.4565L8.3796 20.4574L8.38348 20.4583L8.38757 20.4593L8.39126 20.4602L8.39535 20.4611L8.39903 20.462L8.40348 20.463L8.40685 20.4637L8.4111 20.4647L8.41468 20.4655L8.41897 20.4665L8.42255 20.4673L8.4268 20.4683L8.43027 20.4691L8.43488 20.4701L8.4381 20.4709L8.44255 20.4719L8.44602 20.4726L8.45052 20.4737L8.45385 20.4744L8.4583 20.4755L8.46167 20.4762L8.46632 20.4772L8.46949 20.478L8.4741 20.479L8.47737 20.4797L8.48207 20.4808L8.48519 20.4815L8.48974 20.4825L8.49302 20.4832L8.49767 20.4842L8.50089 20.485L8.50544 20.4859L8.50877 20.4867L8.51337 20.4877L8.51659 20.4884L8.52109 20.4894L8.52447 20.4901L8.52917 20.4911L8.53229 20.4918L8.53694 20.4928L8.54022 20.4935L8.54477 20.4945L8.54814 20.4952L8.55249 20.4961L8.55602 20.4969L8.56052 20.4979L8.56384 20.4986L8.56829 20.4995L8.57177 20.5003L8.57622 20.5012L8.57964 20.5019L8.58399 20.5029L8.58757 20.5036L8.59202 20.5045L8.59544 20.5053L8.59984 20.5062L8.60337 20.507L8.60777 20.5079L8.61124 20.5086L8.61559 20.5095L8.61922 20.5103L8.62352 20.5112L8.6271 20.5119L8.63124 20.5128L8.63502 20.5135L8.63922 20.5144L8.6429 20.5152L8.64709 20.5161L8.65077 20.5168L8.65532 20.5177L8.6586 20.5184L8.6632 20.5193L8.66647 20.52L8.67107 20.5209L8.6744 20.5216L8.67885 20.5224L8.68232 20.5232L8.68682 20.5241L8.69025 20.5247L8.69475 20.5257L8.69812 20.5263L8.70278 20.5273L8.70605 20.5279L8.7105 20.5288L8.71398 20.5295L8.71858 20.5304L8.72185 20.5311L8.7263 20.532L8.72983 20.5326L8.73423 20.5335L8.73775 20.5342L8.7421 20.535L8.74563 20.5357L8.75013 20.5366L8.75361 20.5373L8.75795 20.5381L8.76153 20.5388L8.76593 20.5397L8.76941 20.5403L8.77375 20.5412L8.77733 20.5418L8.78168 20.5426L8.78531 20.5433L8.78945 20.5441L8.79329 20.5448L8.79753 20.5457L8.80121 20.5464L8.80541 20.5472L8.80914 20.5479L8.81349 20.5487L8.81707 20.5494L8.82131 20.5502L8.82509 20.5509L8.82924 20.5517L8.83307 20.5524L8.83716 20.5532L8.84095 20.5539L8.84529 20.5547L8.84892 20.5554L8.85322 20.5562L8.85685 20.5569L8.8614 20.5577L8.86478 20.5583L8.86928 20.5591L8.8728 20.5598L8.87715 20.5606L8.88073 20.5613L8.88518 20.5621L8.88866 20.5627L8.89331 20.5635L8.89663 20.5641L8.90113 20.5649L8.90461 20.5656L8.90916 20.5664L8.91264 20.567L8.91704 20.5678L8.92062 20.5684L8.92501 20.5691L8.92859 20.5697L8.93294 20.5705L8.93652 20.5711L8.94107 20.5719L8.9445 20.5726L8.94884 20.5733L8.95258 20.574L8.95682 20.5748L8.9605 20.5754L8.96485 20.5761L8.96848 20.5768L8.97303 20.5775L8.97651 20.5781L8.98091 20.5789L8.98454 20.5795L8.98893 20.5803L8.99251 20.5809L8.99706 20.5817L9.00044 20.5822L9.00525 20.583L9.00842 20.5836L9.01307 20.5843L9.01645 20.5849L9.02105 20.5857L9.02442 20.5862L9.02897 20.587L9.03245 20.5875L9.037 20.5883L9.04048 20.5889L9.04498 20.5896L9.04846 20.5902L9.05306 20.591L9.05643 20.5915L9.06098 20.5923L9.06441 20.5929L9.06927 20.5936L9.07239 20.5941L9.07725 20.5949L9.08036 20.5954L9.08563 20.5962L9.08829 20.5966L9.09346 20.5975L9.09637 20.5979L9.10159 20.5987L9.10435 20.5992L9.10972 20.6001L9.11238 20.6005L9.11785 20.6014L9.1204 20.6018L9.12542 20.6025L9.12864 20.603L9.13329 20.6038L9.13667 20.6043L9.14122 20.605L9.14475 20.6055L9.14914 20.6062L9.15282 20.6068L9.15717 20.6074L9.16085 20.608L9.1654 20.6087L9.16898 20.6092L9.17323 20.6099L9.17701 20.6105L9.18146 20.6111L9.18504 20.6117L9.18949 20.6123L9.19302 20.6129L9.19788 20.6136L9.20105 20.614L9.2057 20.6147L9.20912 20.6153L9.21373 20.6159L9.2172 20.6164L9.22165 20.6171L9.22534 20.6177L9.22983 20.6183L9.23336 20.6188L9.23781 20.6195L9.24149 20.62L9.2461 20.6207L9.24952 20.6212L9.25397 20.6219L9.2576 20.6224L9.26215 20.623L9.26568 20.6235L9.27008 20.6242L9.27376 20.6247L9.27831 20.6253L9.28179 20.6258L9.28629 20.6265L9.28987 20.627L9.29457 20.6276L9.29795 20.6281L9.30265 20.6288L9.30603 20.6292L9.31073 20.6299L9.31411 20.6303L9.31851 20.631L9.32219 20.6315L9.32664 20.6321L9.33027 20.6326L9.33461 20.6332L9.3384 20.6337L9.34274 20.6342L9.34648 20.6347L9.35072 20.6353L9.35461 20.6358L9.3589 20.6364L9.36274 20.6369L9.36678 20.6374L9.37082 20.6379L9.37501 20.6385L9.37895 20.639L9.38299 20.6395L9.38703 20.64L9.39127 20.6406L9.39511 20.6411L9.39925 20.6416L9.40319 20.6421L9.40743 20.6427L9.41127 20.6432L9.41556 20.6437L9.41935 20.6442L9.42385 20.6448L9.42742 20.6452L9.43177 20.6458L9.43556 20.6462L9.4399 20.6468L9.44369 20.6473L9.44803 20.6478L9.45182 20.6482L9.45616 20.6488L9.45995 20.6492L9.46414 20.6497L9.46803 20.6502L9.47258 20.6507L9.47611 20.6512L9.48071 20.6517L9.48419 20.6521L9.48899 20.6527L9.49226 20.6531L9.49707 20.6537L9.50034 20.6541L9.5052 20.6546L9.50848 20.655L9.51308 20.6556L9.51661 20.656L9.52116 20.6565L9.52479 20.6569L9.52939 20.6574L9.53276 20.6578L9.53773 20.6584L9.54095 20.6587L9.54555 20.6592L9.54913 20.6596L9.55373 20.6602L9.55726 20.6606L9.56171 20.6611L9.56544 20.6615L9.56984 20.662L9.57362 20.6624L9.57797 20.6629L9.58175 20.6633L9.58615 20.6638L9.58993 20.6642L9.59428 20.6647L9.59807 20.6651L9.60231 20.6656L9.60625 20.666L9.61034 20.6664L9.61438 20.6669L9.61862 20.6674L9.62251 20.6678L9.62665 20.6682L9.63069 20.6686L9.63493 20.6691L9.63882 20.6695L9.64306 20.67L9.647 20.6704L9.6513 20.6708L9.65518 20.6713L9.65938 20.6717L9.66337 20.6721L9.66761 20.6725L9.6715 20.6729L9.67584 20.6734L9.67963 20.6738L9.68413 20.6742L9.68781 20.6746L9.69216 20.675L9.69604 20.6754L9.70039 20.6758L9.70422 20.6762L9.70852 20.6766L9.71241 20.677L9.7167 20.6774L9.72059 20.6777L9.72483 20.6782L9.72877 20.6786L9.73306 20.679L9.73695 20.6793L9.74109 20.6797L9.74513 20.6801L9.74938 20.6805L9.75331 20.6809L9.75756 20.6813L9.7615 20.6816L9.76564 20.682L9.76968 20.6824L9.77382 20.6828L9.77786 20.6832L9.782 20.6836L9.78604 20.6839L9.79003 20.6843L9.79417 20.6847L9.79842 20.685L9.8023 20.6854L9.8067 20.6858L9.81048 20.6861L9.81498 20.6865L9.81867 20.6868L9.82322 20.6873L9.8269 20.6876L9.83135 20.6879L9.83513 20.6883L9.83927 20.6886L9.84331 20.689L9.8473 20.6894L9.85155 20.6897L9.85538 20.69L9.85973 20.6904L9.86382 20.6907L9.86786 20.6911L9.87205 20.6915L9.87609 20.6918L9.88064 20.6921L9.88427 20.6924L9.88898 20.6928L9.89246 20.6931L9.89711 20.6934L9.90069 20.6938L9.90524 20.6941L9.90887 20.6944L9.91347 20.6948L9.91705 20.695L9.9216 20.6954L9.92528 20.6957L9.92953 20.696L9.93352 20.6963L9.93776 20.6966L9.94165 20.6969L9.94686 20.6973L9.94978 20.6975L9.95479 20.6979L9.95806 20.6981L9.96266 20.6985L9.96624 20.6988L9.97044 20.6991L9.97458 20.6994L9.97852 20.6997L9.98276 20.7L9.98655 20.7002L9.99104 20.7006L9.99447 20.7008L9.99928 20.7012L10.0026 20.7014L10.0075 20.7017L10.0111 20.702L10.0157 20.7023L10.0191 20.7025L10.0239 20.7029L10.0272 20.7031L10.0322 20.7034L10.0351 20.7036L10.0404 20.704L10.0438 20.7042L10.0487 20.7045L10.052 20.7047L10.0569 20.705L10.0601 20.7052L10.0652 20.7055L10.0686 20.7057L10.0734 20.706L10.0774 20.7063L10.0816 20.7065L10.0857 20.7068L10.0898 20.707L10.0941 20.7073L10.0981 20.7076L10.102 20.7078L10.1064 20.7081L10.1103 20.7083L10.1146 20.7085L10.1181 20.7087L10.1229 20.709L10.1261 20.7092L10.1312 20.7096L10.1345 20.7098L10.1394 20.7101L10.1433 20.7103L10.1477 20.7105L10.1524 20.7108L10.1558 20.711L10.1609 20.7112L10.1641 20.7114L10.1684 20.7117L10.1725 20.7119L10.1763 20.7121L10.1808 20.7124L10.1843 20.7126L10.1891 20.7128L10.193 20.713L10.1973 20.7132L10.2014 20.7134L10.2056 20.7136L10.2094 20.7138L10.2139 20.714L10.2173 20.7142L10.2222 20.7144L10.2258 20.7146L10.2304 20.7148L10.2343 20.715L10.2387 20.7152L10.2428 20.7154L10.247 20.7156L10.2508 20.7158L10.2553 20.716L10.2586 20.7162L10.2636 20.7164L10.2667 20.7165L10.2718 20.7167L10.2755 20.7169L10.2801 20.7171L10.2835 20.7172L10.2884 20.7174L10.292 20.7176L10.2967 20.7178L10.3004 20.7179L10.305 20.7181L10.3093 20.7183L10.3133 20.7185L10.3177 20.7186L10.3215 20.7188L10.3258 20.7189L10.3299 20.7191L10.334 20.7192L10.3382 20.7194L10.3426 20.7195L10.3464 20.7197L10.3511 20.7198L10.3547 20.72L10.3589 20.7201L10.3631 20.7203L10.3666 20.7204L10.3713 20.7205L10.376 20.7207L10.3796 20.7208L10.3842 20.721L10.388 20.7211L10.3921 20.7213L10.3963 20.7214L10.4001 20.7215L10.4047 20.7217L10.408 20.7218L10.413 20.7219L10.4156 20.722L10.4213 20.7222L10.4242 20.7223L10.4296 20.7224L10.4332 20.7225L10.4379 20.7227L10.4418 20.7228L10.4463 20.7229L10.4505 20.723L10.4545 20.7231L10.4588 20.7232L10.4629 20.7233L10.4673 20.7234L10.4712 20.7235L10.4754 20.7236L10.4795 20.7237L10.4836 20.7238L10.4878 20.7239L10.493 20.724L10.4961 20.7241L10.502 20.7242L10.5044 20.7243L10.51 20.7244L10.5128 20.7244L10.5178 20.7245L10.5211 20.7246L10.5258 20.7247L10.5295 20.7247L10.5341 20.7248L10.5378 20.7249L10.5417 20.7249L10.5462 20.725L10.5493 20.7251L10.5545 20.7252L10.5579 20.7253L10.5629 20.7254L10.5659 20.7254L10.5712 20.7255L10.5753 20.7256L10.5796 20.7256L10.5835 20.7257L10.5879 20.7257L10.5921 20.7258L10.5962 20.7258L10.5998 20.7259L10.6046 20.7259L10.6077 20.726L10.613 20.726L10.6155 20.7261L10.6297 20.7262H10.6314L10.6381 20.7263H10.6396C10.6475 20.7263 10.6553 20.7264 10.6631 20.7265L10.6684 20.7265H10.6716H10.6754H10.6799H10.6824L10.6883 20.7266L10.701 20.7266C10.7134 20.7267 10.726 20.7267 10.7385 20.7267C16.4621 20.7267 21.1021 16.0868 21.1021 10.3631C21.1021 4.63946 16.4622 0 10.7386 0Z" fill="#F59500"/>
                            </g>
                            <defs>
                            <clipPath id="clip0_4355_16445">
                            <rect width="24" height="24" fill="white" transform="translate(0.375)"/>
                            </clipPath>
                            </defs>
                        </svg>
                    </div>
                    Request Location
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(url('/my-profile/edit-password')); ?>">
                        <div class="icon-box bg_service-6">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M4.12146 3.3103H5.77663V7.03444H4.12146V3.3103Z" fill="#95A5A5"/>
                                <path d="M9.91455 3.3103H11.5697V7.03444H9.91455V3.3103Z" fill="#95A5A5"/>
                                <path d="M6.19052 1.65527V3.72424C6.19052 3.95277 6.00526 4.13803 5.77673 4.13803H4.12156C3.89303 4.13803 3.70776 3.95277 3.70776 3.72424V1.65527H6.19052Z" fill="#35495E"/>
                                <path d="M11.9836 1.65527V3.72424C11.9836 3.95277 11.7984 4.13803 11.5698 4.13803H9.91465C9.68612 4.13803 9.50085 3.95277 9.50085 3.72424V1.65527H11.9836Z" fill="#35495E"/>
                                <path d="M13.2249 1.03448C13.2258 1.30911 13.1171 1.57275 12.9229 1.76695C12.7287 1.96114 12.4651 2.06985 12.1904 2.06897H3.50079C2.92946 2.06897 2.46631 1.60581 2.46631 1.03448C2.46631 0.463154 2.92946 0 3.50079 0H12.1904C12.7618 0 13.2249 0.463154 13.2249 1.03448Z" fill="#3F5C6C"/>
                                <path d="M15.5918 10.3861C15.9974 8.49506 15.2732 8.8261 15.2732 7.78334C15.2732 7.71713 15.2774 7.65506 15.2815 7.59713C15.3224 7.24544 15.2118 6.89295 14.9773 6.62766C14.7428 6.36238 14.4066 6.20935 14.0525 6.20679H1.63874C1.28427 6.2091 0.947475 6.36189 0.712268 6.62709C0.477061 6.89229 0.365593 7.24493 0.405639 7.59713C0.409777 7.65506 0.413915 7.71713 0.413915 7.78334C0.413915 8.56955 0.00012207 8.56955 0.00012207 9.35575C0.00012207 10.142 0.413915 10.142 0.413915 10.9282C0.413915 11.7144 0.00012207 11.7144 0.00012207 12.5006C0.00012207 13.2868 0.413915 13.2868 0.413915 14.073C0.413915 14.8592 0.00012207 14.8592 0.00012207 15.6454C0.00012207 16.4316 0.413915 16.4316 0.413915 17.2178C0.413915 18.004 0.00012207 18.004 0.00012207 18.7902C0.00012207 19.5764 0.413915 19.5764 0.413915 20.3585C0.413915 20.4247 0.409777 20.4826 0.405639 20.5364C0.364867 20.8892 0.47595 21.2427 0.711187 21.5087C0.946424 21.7747 1.28364 21.9282 1.63874 21.9309H4.13805L16.5518 16.5516L15.5918 10.3861Z" fill="#2980BA"/>
                                <path d="M13.6387 11.1723V16.5516H11.9835V11.1723C11.9835 10.7152 12.354 10.3447 12.8111 10.3447C13.2668 10.3481 13.6353 10.7167 13.6387 11.1723Z" fill="#3B97D3"/>
                                <path d="M10.3284 11.1723V16.5516H8.67322V11.1723C8.67322 10.7152 9.04374 10.3447 9.5008 10.3447C9.95646 10.3481 10.325 10.7167 10.3284 11.1723Z" fill="#3B97D3"/>
                                <path d="M7.01809 11.1723V16.5516H5.36292V11.1723C5.36292 10.7152 5.73344 10.3447 6.1905 10.3447C6.64616 10.3481 7.01471 10.7167 7.01809 11.1723Z" fill="#3B97D3"/>
                                <path d="M3.7077 11.1724V19.0344C3.70634 19.4909 3.33661 19.8607 2.88011 19.862C2.42446 19.8587 2.05591 19.4901 2.05253 19.0344V11.2179C2.0441 10.7782 2.36916 10.4031 2.80563 10.3489C3.0367 10.3293 3.26546 10.4071 3.43673 10.5634C3.608 10.7197 3.70622 10.9405 3.7077 11.1724Z" fill="#3B97D3"/>
                                <path d="M11.9819 9.51723C11.7534 9.51723 11.5681 9.33197 11.5681 9.10344V8.27585C11.5681 8.04732 11.7534 7.86206 11.9819 7.86206C12.2104 7.86206 12.3957 8.04732 12.3957 8.27585V9.10344C12.3957 9.33197 12.2104 9.51723 11.9819 9.51723Z" fill="#35495E"/>
                                <path d="M12.8096 8.68965H2.87851C2.64998 8.68965 2.46472 8.50439 2.46472 8.27585C2.46472 8.04732 2.64998 7.86206 2.87851 7.86206H12.8096C13.0381 7.86206 13.2233 8.04732 13.2233 8.27585C13.2233 8.50439 13.0381 8.68965 12.8096 8.68965Z" fill="#95A5A5"/>
                                <path d="M21.9312 10.3448C21.7027 10.3448 21.5174 10.1595 21.5174 9.931V9.10341C21.5174 8.64635 21.1469 8.27583 20.6898 8.27583H18.6209C18.1638 8.27583 17.7933 8.64635 17.7933 9.10341V9.931C17.7933 10.1595 17.608 10.3448 17.3795 10.3448C17.151 10.3448 16.9657 10.1595 16.9657 9.931V9.10341C16.9657 8.18929 17.7067 7.44824 18.6209 7.44824H20.6898C21.604 7.44824 22.345 8.18929 22.345 9.10341V9.931C22.345 10.1595 22.1597 10.3448 21.9312 10.3448Z" fill="#E57E25"/>
                                <path d="M5.37948 24.0001H2.46638C2.00932 24.0001 1.63879 23.6296 1.63879 23.1725V21.9312H4.5519V23.1725C4.55326 23.629 4.92299 23.9988 5.37948 24.0001Z" fill="#3F5C6C"/>
                                <path d="M24.0001 11.1725V15.3105C24.0001 15.9961 23.4443 16.5518 22.7587 16.5518H16.5518C15.8662 16.5518 15.3104 15.9961 15.3104 15.3105V11.1725C15.3113 10.8859 15.4106 10.6084 15.5918 10.3863C15.827 10.0979 16.1796 9.93071 16.5518 9.93115H22.7587C23.4443 9.93115 24.0001 10.4869 24.0001 11.1725Z" fill="#F29C1F"/>
                                <path d="M21.5173 13.2413C21.2888 13.2413 21.1035 13.0561 21.1035 12.8275V11.5862C21.1035 11.3576 21.2888 11.1724 21.5173 11.1724C21.7458 11.1724 21.9311 11.3576 21.9311 11.5862V12.8275C21.9311 13.0561 21.7458 13.2413 21.5173 13.2413Z" fill="#802F34"/>
                                <path d="M22.345 11.9999H16.9657C16.7371 11.9999 16.5519 11.8147 16.5519 11.5862C16.5519 11.3576 16.7371 11.1724 16.9657 11.1724H22.345C22.5735 11.1724 22.7588 11.3576 22.7588 11.5862C22.7588 11.8147 22.5735 11.9999 22.345 11.9999Z" fill="#C03A2B"/>
                                <path d="M23.1725 16.5518H4.96565C4.50915 16.5531 4.13942 16.9228 4.13806 17.3793V23.1724C4.13942 23.6289 4.50915 23.9987 4.96565 24H23.1725C23.629 23.9987 23.9988 23.6289 24.0001 23.1724V17.3793C23.9988 16.9228 23.629 16.5531 23.1725 16.5518Z" fill="#A56A43"/>
                                <path d="M24.0001 20.2759V21.5173C22.6289 21.5173 21.5174 22.6288 21.5174 24H6.62082C6.62082 22.6288 5.50925 21.5173 4.13806 21.5173V20.2759H7.03461V21.1035C7.03461 21.332 7.21987 21.5173 7.44841 21.5173H8.27599C8.50452 21.5173 8.68979 21.332 8.68979 21.1035V20.2759H10.345C10.345 21.19 11.086 21.9311 12.0001 21.9311H16.1381C17.0522 21.9311 17.7932 21.19 17.7932 20.2759H19.4484V21.1035C19.4484 21.332 19.6337 21.5173 19.8622 21.5173H20.6898C20.9183 21.5173 21.1036 21.332 21.1036 21.1035V20.2759H24.0001Z" fill="#805333"/>
                                <path d="M6.62082 16.5518C6.62082 17.9229 5.50925 19.0345 4.13806 19.0345V17.3793C4.13942 16.9228 4.50915 16.5531 4.96565 16.5518H6.62082Z" fill="#F3D55B"/>
                                <path d="M6.62082 24.0001H4.96565C4.50915 23.9987 4.13942 23.629 4.13806 23.1725V21.5173C5.50925 21.5173 6.62082 22.6289 6.62082 24.0001Z" fill="#F3D55B"/>
                                <path d="M24.0001 17.3793V19.0345C22.6289 19.0345 21.5173 17.9229 21.5173 16.5518H23.1725C23.629 16.5531 23.9987 16.9228 24.0001 17.3793Z" fill="#F3D55B"/>
                                <path d="M24.0001 21.5173V23.1725C23.9987 23.629 23.629 23.9987 23.1725 24.0001H21.5173C21.5173 23.3416 21.7789 22.7101 22.2445 22.2445C22.7101 21.7789 23.3416 21.5173 24.0001 21.5173Z" fill="#F3D55B"/>
                                <path d="M17.7932 19.4482V20.2758C17.7932 21.1899 17.0522 21.9309 16.1381 21.9309H12.0001C11.086 21.9309 10.345 21.1899 10.345 20.2758V19.4482C10.345 18.9911 10.7155 18.6206 11.1726 18.6206C11.6296 18.6206 12.0001 18.9911 12.0001 19.4482V20.2758H16.1381V19.4482C16.1381 18.9911 16.5086 18.6206 16.9657 18.6206C17.4227 18.6206 17.7932 18.9911 17.7932 19.4482Z" fill="#F3D55B"/>
                                <path d="M8.27593 19.0344H7.44834C7.21981 19.0344 7.03455 19.2197 7.03455 19.4482V21.1034C7.03455 21.3319 7.21981 21.5172 7.44834 21.5172H8.27593C8.50446 21.5172 8.68972 21.3319 8.68972 21.1034V19.4482C8.68972 19.2197 8.50446 19.0344 8.27593 19.0344Z" fill="#BDC3C7"/>
                                <path d="M20.6897 19.0344H19.8622C19.6336 19.0344 19.4484 19.2197 19.4484 19.4482V21.1034C19.4484 21.3319 19.6336 21.5172 19.8622 21.5172H20.6897C20.9183 21.5172 21.1035 21.3319 21.1035 21.1034V19.4482C21.1035 19.2197 20.9183 19.0344 20.6897 19.0344Z" fill="#BDC3C7"/>
                            </svg>
                        </div>
                        Change Password
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(url('/pegawai')); ?>">
                        <div class="icon-box bg_surface_color">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M7.14721 0H16.717C17.152 0 17.5047 0.288097 17.5047 0.643459V2.41376C17.5047 2.76912 17.152 3.05722 16.717 3.05722H15.5176L13.9173 3.91499H8.77838L7.14721 3.05722C6.7122 3.05722 6.35956 2.76912 6.35956 2.41376V0.643459C6.35956 0.288097 6.7122 0 7.14721 0V0Z" fill="#FABE2C"/>
                                <path d="M16.717 0H11.75V3.05722L12.2187 3.91504H13.9174L15.5176 3.05726H16.717C17.152 3.05726 17.5047 2.76917 17.5047 2.4138V0.643459C17.5047 0.288097 17.152 0 16.717 0V0Z" fill="#FF9100"/>
                                <path d="M5.94777 3.05713H15.5176C15.9526 3.05713 16.3052 3.34523 16.3052 3.70059V5.47089C16.3052 5.82625 15.9526 6.11435 15.5176 6.11435L14.3112 6.54321H8.3845L7.14718 6.11435H5.94777C5.51277 6.11435 5.16013 5.82625 5.16013 5.47089V3.70064C5.16017 3.34523 5.51282 3.05713 5.94777 3.05713Z" fill="#FFE666"/>
                                <path d="M15.5176 3.05713H11.75V6.11432L12.2187 6.54318H14.3113L15.5176 6.11432C15.9526 6.11432 16.3052 5.82622 16.3052 5.47086V3.70063C16.3052 3.34522 15.9526 3.05713 15.5176 3.05713Z" fill="#FABE2C"/>
                                <path d="M7.06285 6.1145H16.8014C17.1898 6.1145 17.5046 6.42936 17.5046 6.81777V8.46845C17.5046 8.85686 17.1898 9.17172 16.8014 9.17172L11.9321 10.1092L7.0628 9.17172C6.67439 9.17172 6.35953 8.85686 6.35953 8.46845V6.81777C6.35957 6.42936 6.67444 6.1145 7.06285 6.1145Z" fill="#FABE2C"/>
                                <path d="M16.8014 6.1145H11.75V9.17177L11.9321 10.1093L16.8014 9.17177C17.1898 9.17177 17.5046 8.8569 17.5046 8.46849V6.81782C17.5047 6.42937 17.1898 6.1145 16.8014 6.1145Z" fill="#FF9100"/>
                                <path d="M19.4778 9.17163H4.11213C3.74139 9.17163 3.44083 9.4722 3.44083 9.84293V13.2938C3.44083 13.6645 3.74139 13.9651 4.11213 13.9651C4.48287 13.9651 4.78343 13.6645 4.78343 13.2938V10.5142H11.0787V13.2938C11.0787 13.6645 11.3793 13.9651 11.75 13.9651C12.1208 13.9651 12.4213 13.6645 12.4213 13.2938V10.5142H18.8065V13.2938C18.8065 13.6645 19.1071 13.9651 19.4778 13.9651C19.8485 13.9651 20.1491 13.6645 20.1491 13.2938V9.84293C20.1491 9.47215 19.8485 9.17163 19.4778 9.17163Z" fill="#5C7099"/>
                                <path d="M7.93107 20.827C7.93107 18.9625 6.51173 17.4297 4.6946 17.2497C5.73055 16.9889 6.49823 16.0427 6.49823 14.915C6.49823 13.5861 5.43223 12.5088 4.11728 12.5088C2.80233 12.5088 1.73634 13.5861 1.73634 14.915C1.73634 16.0418 2.50275 16.9874 3.53743 17.2491C1.7166 17.4255 0.293182 18.9598 0.293182 20.8269V23.3288C0.293182 23.6995 0.593701 24 0.964392 24H8.86858L7.93107 20.827Z" fill="#9EE2F8"/>
                                <path d="M19.4778 9.17163H11.75V12.5086L12.4213 13.2937V10.5142H18.8065V13.2937C18.8065 13.6645 19.107 13.965 19.4778 13.965C19.8485 13.965 20.1491 13.6645 20.1491 13.2937V9.84289C20.1491 9.47215 19.8485 9.17163 19.4778 9.17163Z" fill="#404A80"/>
                                <path d="M19.9704 17.2497C21.0063 16.9889 21.774 16.0427 21.774 14.915C21.774 13.5861 20.708 12.5088 19.393 12.5088C18.0781 12.5088 17.0121 13.5861 17.0121 14.915C17.0121 16.0418 17.7786 16.9874 18.8132 17.2491C16.9924 17.4255 15.5689 18.9598 15.5689 20.8269L14.6314 24H22.5357C22.9064 24 23.2069 23.6995 23.2069 23.3288V20.8269C23.2068 18.9625 21.7875 17.4297 19.9704 17.2497Z" fill="#E62E6B"/>
                                <path d="M12.2773 17.2625C13.341 17.0219 14.1361 16.0626 14.1361 14.915C14.1361 13.5861 13.0701 12.5088 11.7552 12.5088C10.4402 12.5088 9.37423 13.5861 9.37423 14.915C9.37423 16.0613 10.1676 17.0197 11.2294 17.2617C9.37034 17.492 7.93103 19.0761 7.93103 20.9975V24.0001H15.5689V20.9974C15.569 19.0784 14.1331 17.4958 12.2773 17.2625Z" fill="#00DD80"/>
                                <path d="M12.2773 17.2625C13.341 17.0219 14.1361 16.0626 14.1361 14.9151C14.1361 13.5844 13.0674 12.506 11.7501 12.5088C11.7501 12.5088 11.75 12.5089 11.75 12.5089V24H15.569V20.9974C15.569 19.0784 14.1331 17.4958 12.2773 17.2625Z" fill="#00AA95"/>
                                </svg>

                        </div>
                        Pegawai
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(url('/menu')); ?>">
                        <div class="icon-box bg_surface_color">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M5.00012 7H2.00012C0.895522 7 0.00012207 6.1046 0.00012207 5V2C0.00012207 0.8954 0.895522 0 2.00012 0H5.00012C6.10472 0 7.00012 0.8954 7.00012 2V5C7.00012 6.1046 6.10472 7 5.00012 7ZM16.0001 3.5C16.0001 1.567 14.4331 0 12.5001 0C10.5671 0 9.00012 1.567 9.00012 3.5C9.00012 5.433 10.5671 7 12.5001 7C14.4331 7 16.0001 5.433 16.0001 3.5ZM16.0001 14V11C16.0001 9.8954 15.1047 9 14.0001 9H11.0001C9.89552 9 9.00012 9.8954 9.00012 11V14C9.00012 15.1046 9.89552 16 11.0001 16H14.0001C15.1047 16 16.0001 15.1046 16.0001 14ZM7.00012 14V11C7.00012 9.8954 6.10472 9 5.00012 9H2.00012C0.895522 9 0.00012207 9.8954 0.00012207 11V14C0.00012207 15.1046 0.895522 16 2.00012 16H5.00012C6.10472 16 7.00012 15.1046 7.00012 14Z" fill="url(#paint0_linear_4516_5717)"/>
                                <defs>
                                <linearGradient id="paint0_linear_4516_5717" x1="12.8241" y1="-0.355" x2="2.90212" y2="16.83" gradientUnits="userSpaceOnUse">
                                <stop stop-color="#FFF3B0"/>
                                <stop offset="1" stop-color="#CA26FF"/>
                                </linearGradient>
                                </defs>
                            </svg>

                        </div>
                        Other
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <div class="mt-5 mb-9">
        <div class="tf-container">
            <div class="mt-5">
                <div class="d-flex justify-content-between">
                    <h3>Berita</h3> <a href="#" class="primary_color fw_6">View All</a>
                </div>
                <div class="swiper-container banner-tes">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <img src="<?php echo e(url('/myhr/images/banner/banner.jpg')); ?>" alt="images">
                    </div>
                    <div class="swiper-slide">
                        <img src="<?php echo e(url('/myhr/images/banner/banner2.jpg')); ?>" alt="images">
                    </div>
                    <div class="swiper-slide">
                        <img src="<?php echo e(url('/myhr/images/banner/banner3.jpg')); ?>" alt="images">
                    </div>
                    <div class="swiper-slide">
                        <img src="<?php echo e(url('/myhr/images/banner/banner2.jpg')); ?>" alt="images">
                    </div>
                    <div class="swiper-slide">
                        <img src="<?php echo e(url('/myhr/images/banner/banner3.jpg')); ?>" alt="images">
                    </div>
                </div>
                </div>
            </div>
            <div class="mt-5">
                <div class="d-flex justify-content-between">
                    <h3>Informasi</h3> <a href="#" class="primary_color fw_6">View All</a>
                </div>
                <div class="swiper-container tes-gift mt-5">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="box-gift-card bg_gift-card-1">
                                <ul class="desc">
                                <li class="name"><a href="66_deal-near-you.html" class="on_surface_color fw_7">THE TEST KITCHEN</a></li>
                                <li class="code success_color fw_6">R100</li>
                                <li class="counpon">COUPON</li>
                                <li>
                                        <i class="icon-noti"></i>
                                        Term of use
                                </li>
                                </ul>
                                <div class="img-gift">
                                    <img src="<?php echo e(url('/myhr/images/rewards/gift-1.jpg')); ?>" alt="images">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="box-gift-card bg_gift-card-2">
                                <ul class="desc">
                                <li class="name"><a href="66_deal-near-you.html" class="white_color fw_5">THE TEST KITCHEN</a></li>
                                <li class="code success_color fw_6">R100</li>
                                <li class="counpon white_color fw_4">COUPON</li>
                                <li class="white_color fw_4">
                                        <i class="icon-noti white_color"></i>
                                        Term of use
                                </li>
                                </ul>
                                <div class="img-gift">
                                    <img src="<?php echo e(url('/myhr/images/rewards/gift-2.jpg')); ?>" alt="images">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide space1">
                            <div class="box-gift-card bg_gift-card-1">
                                <ul class="desc">
                                <li class="name"><a href="66_deal-near-you.html" class="on_surface_color fw_7">THE TEST KITCHEN</a></li>
                                <li class="code success_color fw_6">R100</li>
                                <li class="counpon">COUPON</li>
                                <li>
                                        <i class="icon-noti"></i>
                                        Term of use
                                </li>
                                </ul>
                                <div class="img-gift">
                                    <img src="<?php echo e(url('/myhr/images/rewards/gift-1.jpg')); ?>" alt="images">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iusoluti/absensi.igtax.net/resources/views/dashboard/indexUser.blade.php ENDPATH**/ ?>