<?php $__env->startSection('isi'); ?>
    <div class="row">
        <div class="col-md-12 project-list">
            <div class="card">
                <div class="row">
                    <div class="col-md-6 mt-2 p-0 d-flex">
                        <h4><?php echo e($title); ?></h4>
                    </div>
                    <div class="col-md-6 p-0">    
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <form action="<?php echo e(url('/data-lembur')); ?>">
                        <div class="row">
                            <div class="col-3">
                                <select name="user_id" id="user_id" class="form-control selectpicker" data-live-search="true">
                                    <option value=""selected>Pilih Pegawai</option>
                                    <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(request('user_id') == $u->id): ?>
                                            <option value="<?php echo e($u->id); ?>"selected><?php echo e($u->name); ?></option>
                                        <?php else: ?>
                                            <option value="<?php echo e($u->id); ?>"><?php echo e($u->name); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-3">
                                <input type="datetime" class="form-control" name="mulai" placeholder="Tanggal Mulai" id="mulai" value="<?php echo e(request('mulai')); ?>">
                            </div>
                            <div class="col-3">
                                <input type="datetime" class="form-control" name="akhir" placeholder="Tanggal Akhir" id="akhir" value="<?php echo e(request('akhir')); ?>">
                            </div>
                            <div class="col-3">
                                <button type="submit" id="search"class="border-0 mt-3" style="background-color: transparent;"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="mytable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nama Pegawai</th>
                                    <th>Tanggal</th>
                                    <th>Jam Masuk</th>
                                    <th>Lokasi Masuk</th>
                                    <th>Foto Masuk</th>
                                    <th>Jam Pulang</th>
                                    <th>Lokasi Pulang</th>
                                    <th>Foto Pulang</th>
                                    <th>Total Lembur</th>
                                    <th>Notes</th>
                                    <th>User Approval</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data_lembur; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($dl->User->name); ?></td>
                                    <td><?php echo e($dl->tanggal); ?></td>
                                    <td>
                                        <?php
                                            $jam_masuk = explode(" ", $dl->jam_masuk);
                                        ?>
                                        <span class="badge badge-success"><?php echo e($jam_masuk[1]); ?></span>
                                    </td>
                                    <td>
                                        <?php
                                            $jarak_masuk = explode(".", $dl->jarak_masuk);
                                        ?>
                                        <a href="<?php echo e(url('/maps/'.$dl->lat_masuk.'/'.$dl->long_masuk.'/'.$dl->user_id)); ?>" class="btn btn-sm btn-secondary" target="_blank">lihat</a>
                                        <span class="badge badge-warning"><?php echo e($jarak_masuk[0]); ?> Meter</span>
                                    </td>
                                    <td>
                                        <img src="<?php echo e(url('storage/' . $dl->foto_jam_masuk)); ?>" style="width: 60px">
                                    </td>
                                    <td>
                                        <?php if($dl->jam_keluar == null): ?>
                                            <span class="badge badge-warning">Belum Pulang Lembur</span>
                                        <?php else: ?>
                                            <?php
                                                $jam_keluar = explode(" ", $dl->jam_keluar);
                                            ?>
                                            <span class="badge badge-success"><?php echo e($jam_keluar[1]); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($dl->jam_keluar == null): ?>
                                            <span class="badge badge-warning">Belum Pulang Lembur</span>
                                        <?php else: ?>
                                            <?php
                                                $jarak_keluar = explode(".", $dl->jarak_keluar);
                                            ?>
                                            <a href="<?php echo e(url('/maps/'.$dl->lat_keluar.'/'.$dl->long_keluar.'/'.$dl->user_id)); ?>" class="btn btn-sm btn-secondary" target="_blank">lihat</a>
                                            <span class="badge badge-warning"><?php echo e($jarak_keluar[0]); ?> Meter</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($dl->jam_keluar == null): ?>
                                            <span class="badge badge-warning">Belum Pulang Lembur</span>
                                        <?php else: ?>
                                            <img src="<?php echo e(url('storage/' . $dl->foto_jam_keluar)); ?>" style="width: 60px">
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($dl->jam_keluar == null): ?>
                                            <span class="badge badge-warning">Belum Pulang Lembur</span>
                                        <?php else: ?>
                                            <?php
                                                $total_lembur = $dl->total_lembur;
                                                $jam   = floor($total_lembur / (60 * 60));
                                                $menit = $total_lembur - ( $jam * (60 * 60) );
                                                $menit2 = floor( $menit / 60 );
                                            ?>
                                            <span class="badge badge-success"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($dl->notes); ?></td>
                                    <td><?php echo e($dl->approvedBy ? $dl->approvedBy->name : ''); ?></td>
                                    <td>
                                        <?php if($dl->status == 'Pending'): ?>
                                            <span class="badge badge-warning"><?php echo e($dl->status); ?></span>
                                        <?php elseif($dl->status == 'Rejected'): ?>
                                            <span class="badge badge-danger"><?php echo e($dl->status); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-success"><?php echo e($dl->status); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($dl->status !== 'Approved' && $dl->jam_keluar !== null): ?>
                                            <ul class="action">
                                                <li>
                                                    <button class="border-0" style="background-color: transparent" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal"><i style="color:blue" class="fa fa-check-circle"></i></button>

                                                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                        <div class="modal-dialog" role="document">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="exampleModalLabel">Import Users</h5>
                                                                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                                <form action="<?php echo e(url('/data-lembur/approval/'.$dl->id)); ?>" method="POST">
                                                                    <?php echo csrf_field(); ?>
                                                                    <div class="modal-body">
                                                                        <div class="form-group">
                                                                            <?php
                                                                                $status = array(
                                                                                    [
                                                                                        "status" => "Approved",
                                                                                        "status_name" => "Approve"
                                                                                    ],
                                                                                    [
                                                                                        "status" => "Rejected",
                                                                                        "status_name" => "Reject"
                                                                                    ]
                                                                                );
                                                                            ?>
                                                                            <label for="status">Status</label>
                                                                            <select name="status" id="status" class="form-control selectpicker" data-live-search="true">
                                                                                <option value="">Pilih Status</option>
                                                                                <?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <?php if(old('status', $dl->status) == $s["status"]): ?>
                                                                                    <option value="<?php echo e($s["status"]); ?>" selected><?php echo e($s["status_name"]); ?></option>
                                                                                    <?php else: ?>
                                                                                    <option value="<?php echo e($s["status"]); ?>"><?php echo e($s["status_name"]); ?></option>
                                                                                    <?php endif; ?>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>
                                                                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                <div class="invalid-feedback">
                                                                                    <?php echo e($message); ?>

                                                                                </div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label for="notes" class="col-form-label">Notes:</label>
                                                                            <textarea class="form-control" id="notes" name="notes"><?php echo e(old('notes')); ?></textarea>
                                                                            <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                <div class="invalid-feedback">
                                                                                    <?php echo e($message); ?>

                                                                                </div>
                                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                        </div>
                                                                        <input type="hidden" name="approved_by" value="<?php echo e(auth()->user()->id); ?>">
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
                                                                        <button class="btn btn-secondary" type="submit">Save changes</button>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                             </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-end me-4 mt-4">
                        <?php echo e($data_lembur->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iusoluti/absensi.igtax.net/resources/views/lembur/datalembur.blade.php ENDPATH**/ ?>