<?php $__env->startSection('isi'); ?>
    <div class="row">
        <div class="col-md-12 project-list">
            <div class="card">
                <div class="row">
                    <div class="col-md-6 mt-2 p-0 d-flex">
                        <h4><?php echo e($title); ?></h4>
                    </div>
                    <div class="col-md-6 p-0">
                        <a href="<?php echo e(url('/rekap-data')); ?>" class="btn btn-primary">+ Tambah</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <form action="<?php echo e(url('/payroll')); ?>">
                        <?php
                            $bulan = array(
                            [
                                "id" => "1",
                                "bulan" => "Januari"
                            ],
                            [
                                "id" => "2",
                                "bulan" => "Februari"
                            ],
                            [
                                "id" => "3",
                                "bulan" => "Maret"
                            ],
                            [
                                "id" => "4",
                                "bulan" => "April"
                            ],
                            [
                                "id" => "5",
                                "bulan" => "Mei"
                            ],
                            [
                                "id" => "6",
                                "bulan" => "Juni"
                            ],
                            [
                                "id" => "7",
                                "bulan" => "Juli"
                            ],
                            [
                                "id" => "8",
                                "bulan" => "Agustus"
                            ],
                            [
                                "id" => "9",
                                "bulan" => "September"
                            ],
                            [
                                "id" => "10",
                                "bulan" => "Oktober"
                            ],
                            [
                                "id" => "11",
                                "bulan" => "November"
                            ],
                            [
                                "id" => "12",
                                "bulan" => "Desember"
                            ]);

                            $last = date('Y')-10;
                            $now = date('Y');
                        ?>
                        <div class="row">
                            <div class="col-3">
                                <select name="tahun" id="tahun" class="form-control selectpicker" data-live-search="true">
                                    <option value=""selected>Tahun</option>
                                    <?php for($i = $now; $i >= $last; $i--): ?>
                                        <?php if(old('tahun') == $i): ?>
                                            <option value="<?php echo e($i); ?>" selected><?php echo e($i); ?></option>
                                        <?php else: ?>
                                            <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                </select>
                            </div>
                            <div class="col-3">
                                <select name="bulan" id="bulan" class="form-control selectpicker" data-live-search="true">
                                    <option value=""selected>Bulan</option>
                                    <?php $__currentLoopData = $bulan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bul): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(request('bulan') == $bul['id']): ?>
                                            <option value="<?php echo e($bul['id']); ?>"selected><?php echo e($bul['bulan']); ?></option>
                                        <?php else: ?>
                                            <option value="<?php echo e($bul['id']); ?>"><?php echo e($bul['bulan']); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-3">
                                <button type="submit" id="search"class="border-0 mt-3" style="background-color: transparent;"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="mytable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nomor Gaji</th>
                                    <th>Nama</th>
                                    <th>Jabatan</th>
                                    <th>Bulan</th>
                                    <th>Grand Total</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($d->no_gaji); ?></td>
                                        <td><?php echo e($d->user->name); ?></td>
                                        <td><?php echo e($d->User->Jabatan->nama_jabatan); ?></td>
                                        <td>
                                            <?php
                                                if ($d->bulan == 1){
                                                    $nama_bulan = 'Januari';
                                                } else if($d->bulan == 2) {
                                                    $nama_bulan = 'Februari';
                                                } else if($d->bulan == 3) {
                                                    $nama_bulan = 'Maret';
                                                } else if($d->bulan == 4) {
                                                    $nama_bulan = 'April';
                                                } else if($d->bulan == 5) {
                                                    $nama_bulan = 'Mei';
                                                } else if($d->bulan == 6) {
                                                    $nama_bulan = 'Juni';
                                                } else if($d->bulan == 7) {
                                                    $nama_bulan = 'Juli';
                                                } else if($d->bulan == 8) {
                                                    $nama_bulan = 'Agustus';
                                                } else if($d->bulan == 9) {
                                                    $nama_bulan = 'September';
                                                } else if($d->bulan == 10) {
                                                    $nama_bulan = 'Oktober';
                                                } else if($d->bulan == 11) {
                                                    $nama_bulan = 'November';
                                                } else if($d->bulan == 12) {
                                                    $nama_bulan = 'Desember';
                                                } else {
                                                    $nama_bulan = '-';
                                                }
                                            ?>
                                            <?php echo e($nama_bulan); ?> <?php echo e($d->tahun); ?>

                                        </td>
                                        <td>Rp <?php echo e(number_format($d->grand_total)); ?></td>
                                        <td>
                                            <ul class="action">
                                                <li class="me-2">
                                                    <a href="<?php echo e(url('/payroll/'.$d->id.'/download')); ?>" target="_blank"><i style="color:blue" class="fa fa-solid fa-print"></i></a>
                                                </li>

                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin')): ?>
                                                    <li>
                                                        <a href="<?php echo e(url('/payroll/'.$d->id.'/edit')); ?>"><i style="color: brown" class="fa fa-solid fa-edit"></i></a>
                                                    </li>
                                                    <li class="delete">
                                                        <form action="<?php echo e(url('/payroll/'.$d->id.'/delete')); ?>" method="post" class="d-inline">
                                                            <?php echo method_field('delete'); ?>
                                                            <?php echo csrf_field(); ?>
                                                            <button class="border-0" style="background-color: transparent" onClick="return confirm('Are You Sure')"><i class="fa fa-solid fa-trash"></i></button>
                                                        </form>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-end mt-4">
                        <?php echo e($data->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\absensi\resources\views/payroll/index.blade.php ENDPATH**/ ?>