<?php $__env->startSection('isi'); ?>
   <div class="container-fluid">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <form action="<?php echo e(url('/rekap-data')); ?>">
                        <div class="form-row">
                        <div class="col-3">
                            <input type="datetime" class="form-control" name="mulai" placeholder="Tanggal Mulai" id="mulai" value="<?php echo e(request('mulai')); ?>">
                        </div>
                        <div class="col-3">
                            <input type="datetime" class="form-control" name="akhir" placeholder="Tanggal Akhir" id="akhir" value="<?php echo e(request('akhir')); ?>">
                        </div>
                        <div>
                            <button type="submit" id="search" class="form-control btn btn-primary"><i class="fas fa-search"></i></button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="tableprint" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Nama Karyawan</th>
                                <th>Total Cuti Dadakan</th>
                                <th>Total Cuti Bersama</th>
                                <th>Total Cuti Menikah</th>
                                <th>Total Cuti Diluar Tanggungan</th>
                                <th>Total Cuti Khusus</th>
                                <th>Total Cuti Melahirkan</th>
                                <th>Total Izin Telat</th>
                                <th>Total Izin Pulang Cepat</th>
                                <th>Total Hadir</th>
                                <th>Total Alfa</th>
                                <th>Total Libur</th>
                                <th>Total Telat</th>
                                <th>Total Pulang Cepat</th>
                                <th>Total Lembur</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data_user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $du): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($du->name); ?>

                                </td>
                              
                                <td>
                                    <?php
                                        echo $du->Cuti->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('nama_cuti', 'Cuti Dadakan')->where('status_cuti', 'Diterima')->count() . " x";
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo $du->Cuti->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('nama_cuti', 'Cuti Bersama')->where('status_cuti', 'Diterima')->count() . " x";
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo $du->Cuti->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('nama_cuti', 'Cuti Menikah')->where('status_cuti', 'Diterima')->count() . " x";
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo $du->Cuti->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('nama_cuti', 'Cuti Diluar Tanggungan')->where('status_cuti', 'Diterima')->count() . " x";
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo $du->Cuti->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('nama_cuti', 'Cuti Khusus')->where('status_cuti', 'Diterima')->count() . " x";
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo $du->Cuti->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('nama_cuti', 'Cuti Melahirkan')->where('status_cuti', 'Diterima')->count() . " x";
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        $jumlah_izin_telat = $du->MappingShift->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('status_absen', 'Izin Telat')->count()
                                    ?>
                                    <?php echo e($jumlah_izin_telat . " x"); ?>

                                </td>
                                <td>
                                    <?php
                                        $jumlah_izin_pulang_cepat = $du->MappingShift->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('status_absen', 'Izin Pulang Cepat')->count()
                                    ?>
                                    <?php echo e($jumlah_izin_pulang_cepat . " x"); ?>

                                </td>
                                <td>
                                    <?php
                                        $jumlah_hadir = $du->MappingShift->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('status_absen', '=', 'Masuk')->count();
                                    ?>
                                    <?php echo e($jumlah_hadir + $jumlah_izin_telat + $jumlah_izin_pulang_cepat. " x"); ?>

                                </td>
                                <td>
                                    <?php
                                        echo $du->MappingShift->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('status_absen', 'Tidak Masuk')->count() . " x";
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo $du->MappingShift->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->where('status_absen', 'Libur')->count() . " x";
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        $total_telat = $du->MappingShift->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->sum('telat');
                                        $jam   = floor($total_telat / (60 * 60));
                                        $menit = $total_telat - ( $jam * (60 * 60) );
                                        $menit2 = floor($menit / 60);
                                        $detik = $total_telat % 60;
                                    ?>

                                    <?php if($jam <= 0 && $menit2 <= 0): ?>
                                        <span class="badge badge-success">Tidak Pernah Telat</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                        $total_pulang_cepat = $du->MappingShift->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->sum('pulang_cepat');
                                        $jam   = floor($total_pulang_cepat / (60 * 60));
                                        $menit = $total_pulang_cepat - ( $jam * (60 * 60) );
                                        $menit2 = floor($menit / 60);
                                        $detik = $total_pulang_cepat % 60;
                                    ?>

                                    <?php if($jam <= 0 && $menit2 <= 0): ?>
                                        <span class="badge badge-success">Tidak Pernah Pulang Cepat</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                        $total_lembur = $du->Lembur->whereBetween('tanggal', [$tanggal_mulai, $tanggal_akhir])->sum('total_lembur');
                                        $jam   = floor($total_lembur / (60 * 60));
                                        $menit = $total_lembur - ( $jam * (60 * 60) );
                                        $menit2 = floor($menit / 60);
                                        $detik = $total_lembur % 60;
                                    ?>
                                    
                                    <span class="badge badge-success"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<br>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/t46813/gpiclick.grhapermataibu.com/laravel/resources/views/rekapdata/index.blade.php ENDPATH**/ ?>