
<?php $__env->startSection('isi'); ?>
    <div class="row">
        <div class="col-md-12 project-list">
            <div class="card">
                <div class="row">
                    <div class="col-md-6 mt-2 p-0 d-flex">
                        <h4><?php echo e($title); ?></h4>
                    </div>
                    <div class="col-md-6 p-0">    
                        <a href="<?php echo e(url('/kasbon/tambah')); ?>" class="btn btn-sm btn-primary">+ Tambah</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <form action="<?php echo e(url('/kasbon')); ?>">
                        <?php
                            $status = array(
                            [
                                "status" => "PENDING",
                            ],
                            [
                                "status" => "ACC",
                            ]);
                        ?>
                        <div class="row">
                            <div class="col-3">
                                <input type="datetime" class="form-control" name="tanggal" placeholder="Tanggal" id="tanggal" value="<?php echo e(request('tanggal')); ?>">
                            </div>
                            <div class="col-3">
                                <select name="status" id="status" class="form-control selectpicker" data-live-search="true">
                                    <option value=""selected>Status</option>
                                    <?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(request('status') == $stat['status']): ?>
                                            <option value="<?php echo e($stat['status']); ?>"selected><?php echo e($stat['status']); ?></option>
                                        <?php else: ?>
                                            <option value="<?php echo e($stat['status']); ?>"><?php echo e($stat['status']); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-3">
                                <button type="submit" id="search"class="border-0 mt-3" style="background-color: transparent;"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="mytable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nama</th>
                                    <th>Total</th>
                                    <th>Keperluan</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($d->User->name); ?></td>
                                        <td>Rp <?php echo e(number_format($d->nominal)); ?></td>
                                        <td><?php echo e($d->keperluan); ?></td>
                                        <td>
                                            <?php if($d->status == 'ACC'): ?>
                                                <span class="badge badge-success"><?php echo e($d->status); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge-warning"><?php echo e($d->status); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <ul class="action">
                                                <?php if(auth()->user()->is_admin == 'admin'): ?>
                                                    <?php if($d->status !== 'ACC'): ?>
                                                        <li>
                                                            <a href="<?php echo e(url('/kasbon/edit/'.$d->id)); ?>"><i style="color: blue" class="fa fa-solid fa-edit"></i></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <li class="delete">
                                                        <form action="<?php echo e(url('/kasbon/delete/'.$d->id)); ?>" method="post" class="d-inline">
                                                            <?php echo method_field('delete'); ?>
                                                            <?php echo csrf_field(); ?>
                                                            <button class="border-0" style="background-color: transparent" onClick="return confirm('Are You Sure')"><i class="fa fa-solid fa-trash"></i></button>
                                                        </form>
                                                    </li>
                                                <?php else: ?>
                                                    <?php if($d->status !== 'ACC'): ?>
                                                        <li>
                                                            <a href="<?php echo e(url('/kasbon/edit/'.$d->id)); ?>"><i style="color: blue" class="fa fa-solid fa-edit"></i></a>
                                                        </li>
                                                        <li class="delete">
                                                            <form action="<?php echo e(url('/kasbon/delete/'.$d->id)); ?>" method="post" class="d-inline">
                                                                <?php echo method_field('delete'); ?>
                                                                <?php echo csrf_field(); ?>
                                                                <button class="border-0" style="background-color: transparent" onClick="return confirm('Are You Sure')"><i class="fa fa-solid fa-trash"></i></button>
                                                            </form>
                                                        </li>
                                                    <?php else: ?>
                                                    -
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </ul>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-end mt-4">
                        <?php echo e($data->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\absensi\resources\views/kasbon/index.blade.php ENDPATH**/ ?>