<?php $__env->startSection('isi'); ?>
    <div class="container-fluid">
        <div class="card">
            <div class="card-header">
                <form action="<?php echo e(url('/my-lembur')); ?>">
                    <span>Filter Rentang Tanggal</span><br><br>
                    <div class="form-row">
                        <div class="col-3">
                            <input type="datetime" class="form-control" name="mulai" placeholder="Tanggal Mulai" id="mulai" value="<?php echo e(request('mulai')); ?>">
                        </div>
                        <div class="col-3">
                            <input type="datetime" class="form-control" name="akhir" placeholder="Tanggal Akhir" id="akhir" value="<?php echo e(request('akhir')); ?>">
                        </div>
                        <div>
                            <button type="submit" id="search" class="form-control btn btn-primary"><i class="fas fa-search"></i></button>
                        </div>
                    </div>
        </form>
            </div>
            <div class="card-body">
                <table id="tableprint" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Nama Karyawan</th>
                            <th>Tanggal</th>
                            <th>Jam Masuk</th>
                            <th>Lokasi Masuk</th>
                            <th>Foto Masuk</th>
                            <th>Jam Pulang</th>
                            <th>Lokasi Pulang</th>
                            <th>Foto Pulang</th>
                            <th>Total Lembur</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data_lembur; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($dl->User->name); ?></td>
                            <td><?php echo e($dl->tanggal); ?></td>
                            <td>
                                <?php
                                    $jam_masuk = explode(" ", $dl->jam_masuk);
                                ?>
                                <span class="badge badge-success"><?php echo e($jam_masuk[1]); ?></span>
                            </td>
                            <td>
                                <?php
                                    $jarak_masuk = explode(".", $dl->jarak_masuk);
                                ?>
                                <a href="<?php echo e(url('/maps/'.$dl->lat_masuk.'/'.$dl->long_masuk)); ?>" class="btn btn-sm btn-secondary" target="_blank">lihat</a>
                                <span class="badge badge-warning"><?php echo e($jarak_masuk[0]); ?> Meter</span>
                            </td>
                            <td>
                                <img src="<?php echo e(url('storage/' . $dl->foto_jam_masuk)); ?>" style="width: 60px">
                            </td>
                            <td>
                                <?php if($dl->jam_keluar == null): ?>
                                    <span class="badge badge-warning">Belum Pulang Lembur</span>
                                <?php else: ?>
                                    <?php
                                        $jam_keluar = explode(" ", $dl->jam_keluar);
                                    ?>
                                    <span class="badge badge-success"><?php echo e($jam_keluar[1]); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($dl->jam_keluar == null): ?>
                                    <span class="badge badge-warning">Belum Pulang Lembur</span>
                                <?php else: ?>
                                    <?php
                                        $jarak_keluar = explode(".", $dl->jarak_keluar);
                                    ?>
                                    <a href="<?php echo e(url('/maps/'.$dl->lat_keluar.'/'.$dl->long_keluar)); ?>" class="btn btn-sm btn-secondary" target="_blank">lihat</a>
                                    <span class="badge badge-warning"><?php echo e($jarak_keluar[0]); ?> Meter</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($dl->jam_keluar == null): ?>
                                    <span class="badge badge-warning">Belum Pulang Lembur</span>
                                <?php else: ?>
                                    <img src="<?php echo e(url('storage/' . $dl->foto_jam_keluar)); ?>" style="width: 60px">
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($dl->jam_keluar == null): ?>
                                    <span class="badge badge-warning">Belum Pulang Lembur</span>
                                <?php else: ?>
                                    <?php
                                        $total_lembur = $dl->total_lembur;
                                        $jam   = floor($total_lembur / (60 * 60));
                                        $menit = $total_lembur - ( $jam * (60 * 60) );
                                        $menit2 = floor( $menit / 60 );
                                    ?>
                                    <span class="badge badge-success"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </tbody>
                </table>
            </div>
        </div>
    </div>
    <br>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/t46813/gpiclick.grhapermataibu.com/gpiclick/resources/views/lembur/mylembur.blade.php ENDPATH**/ ?>