/**
 * Framework7 6.3.12
 * Full featured mobile HTML framework for building iOS & Android apps
 * https://framework7.io/
 *
 * Copyright 2014-2021 Vladimir Kharlampidi
 *
 * Released under the MIT License
 *
 * Released on: December 13, 2021
 */

(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.Framework7 = factory());
}(this, (function () { 'use strict';

    /**
     * SSR Window 3.0.0
     * Better handling for window object in SSR environment
     * https://github.com/nolimits4web/ssr-window
     *
     * Copyright 2020, Vladimir Kharlampidi
     *
     * Licensed under MIT
     *
     * Released on: November 9, 2020
     */

    /* eslint-disable no-param-reassign */
    function isObject$2(obj) {
      return obj !== null && typeof obj === 'object' && 'constructor' in obj && obj.constructor === Object;
    }

    function extend$2(target, src) {
      if (target === void 0) {
        target = {};
      }

      if (src === void 0) {
        src = {};
      }

      Object.keys(src).forEach(function (key) {
        if (typeof target[key] === 'undefined') target[key] = src[key];else if (isObject$2(src[key]) && isObject$2(target[key]) && Object.keys(src[key]).length > 0) {
          extend$2(target[key], src[key]);
        }
      });
    }

    var ssrDocument = {
      body: {},
      addEventListener: function addEventListener() {},
      removeEventListener: function removeEventListener() {},
      activeElement: {
        blur: function blur() {},
        nodeName: ''
      },
      querySelector: function querySelector() {
        return null;
      },
      querySelectorAll: function querySelectorAll() {
        return [];
      },
      getElementById: function getElementById() {
        return null;
      },
      createEvent: function createEvent() {
        return {
          initEvent: function initEvent() {}
        };
      },
      createElement: function createElement() {
        return {
          children: [],
          childNodes: [],
          style: {},
          setAttribute: function setAttribute() {},
          getElementsByTagName: function getElementsByTagName() {
            return [];
          }
        };
      },
      createElementNS: function createElementNS() {
        return {};
      },
      importNode: function importNode() {
        return null;
      },
      location: {
        hash: '',
        host: '',
        hostname: '',
        href: '',
        origin: '',
        pathname: '',
        protocol: '',
        search: ''
      }
    };

    function getDocument() {
      var doc = typeof document !== 'undefined' ? document : {};
      extend$2(doc, ssrDocument);
      return doc;
    }

    var ssrWindow = {
      document: ssrDocument,
      navigator: {
        userAgent: ''
      },
      location: {
        hash: '',
        host: '',
        hostname: '',
        href: '',
        origin: '',
        pathname: '',
        protocol: '',
        search: ''
      },
      history: {
        replaceState: function replaceState() {},
        pushState: function pushState() {},
        go: function go() {},
        back: function back() {}
      },
      CustomEvent: function CustomEvent() {
        return this;
      },
      addEventListener: function addEventListener() {},
      removeEventListener: function removeEventListener() {},
      getComputedStyle: function getComputedStyle() {
        return {
          getPropertyValue: function getPropertyValue() {
            return '';
          }
        };
      },
      Image: function Image() {},
      Date: function Date() {},
      screen: {},
      setTimeout: function setTimeout() {},
      clearTimeout: function clearTimeout() {},
      matchMedia: function matchMedia() {
        return {};
      },
      requestAnimationFrame: function requestAnimationFrame(callback) {
        if (typeof setTimeout === 'undefined') {
          callback();
          return null;
        }

        return setTimeout(callback, 0);
      },
      cancelAnimationFrame: function cancelAnimationFrame(id) {
        if (typeof setTimeout === 'undefined') {
          return;
        }

        clearTimeout(id);
      }
    };

    function getWindow() {
      var win = typeof window !== 'undefined' ? window : {};
      extend$2(win, ssrWindow);
      return win;
    }

    /**
     * Dom7 3.0.0
     * Minimalistic JavaScript library for DOM manipulation, with a jQuery-compatible API
     * https://framework7.io/docs/dom7.html
     *
     * Copyright 2020, Vladimir Kharlampidi
     *
     * Licensed under MIT
     *
     * Released on: November 9, 2020
     */

    function _inheritsLoose$1(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      subClass.__proto__ = superClass;
    }

    function _getPrototypeOf$1(o) {
      _getPrototypeOf$1 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };
      return _getPrototypeOf$1(o);
    }

    function _setPrototypeOf$1(o, p) {
      _setPrototypeOf$1 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;
        return o;
      };

      return _setPrototypeOf$1(o, p);
    }

    function _isNativeReflectConstruct$1() {
      if (typeof Reflect === "undefined" || !Reflect.construct) return false;
      if (Reflect.construct.sham) return false;
      if (typeof Proxy === "function") return true;

      try {
        Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
        return true;
      } catch (e) {
        return false;
      }
    }

    function _construct$1(Parent, args, Class) {
      if (_isNativeReflectConstruct$1()) {
        _construct$1 = Reflect.construct;
      } else {
        _construct$1 = function _construct(Parent, args, Class) {
          var a = [null];
          a.push.apply(a, args);
          var Constructor = Function.bind.apply(Parent, a);
          var instance = new Constructor();
          if (Class) _setPrototypeOf$1(instance, Class.prototype);
          return instance;
        };
      }

      return _construct$1.apply(null, arguments);
    }

    function _isNativeFunction$1(fn) {
      return Function.toString.call(fn).indexOf("[native code]") !== -1;
    }

    function _wrapNativeSuper$1(Class) {
      var _cache = typeof Map === "function" ? new Map() : undefined;

      _wrapNativeSuper$1 = function _wrapNativeSuper(Class) {
        if (Class === null || !_isNativeFunction$1(Class)) return Class;

        if (typeof Class !== "function") {
          throw new TypeError("Super expression must either be null or a function");
        }

        if (typeof _cache !== "undefined") {
          if (_cache.has(Class)) return _cache.get(Class);

          _cache.set(Class, Wrapper);
        }

        function Wrapper() {
          return _construct$1(Class, arguments, _getPrototypeOf$1(this).constructor);
        }

        Wrapper.prototype = Object.create(Class.prototype, {
          constructor: {
            value: Wrapper,
            enumerable: false,
            writable: true,
            configurable: true
          }
        });
        return _setPrototypeOf$1(Wrapper, Class);
      };

      return _wrapNativeSuper$1(Class);
    }

    function _assertThisInitialized$1(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }

      return self;
    }
    /* eslint-disable no-proto */


    function makeReactive(obj) {
      var proto = obj.__proto__;
      Object.defineProperty(obj, '__proto__', {
        get: function get() {
          return proto;
        },
        set: function set(value) {
          proto.__proto__ = value;
        }
      });
    }

    var Dom7 = /*#__PURE__*/function (_Array) {
      _inheritsLoose$1(Dom7, _Array);

      function Dom7(items) {
        var _this;

        _this = _Array.call.apply(_Array, [this].concat(items)) || this;
        makeReactive(_assertThisInitialized$1(_this));
        return _this;
      }

      return Dom7;
    }( /*#__PURE__*/_wrapNativeSuper$1(Array));

    function arrayFlat(arr) {
      if (arr === void 0) {
        arr = [];
      }

      var res = [];
      arr.forEach(function (el) {
        if (Array.isArray(el)) {
          res.push.apply(res, arrayFlat(el));
        } else {
          res.push(el);
        }
      });
      return res;
    }

    function arrayFilter(arr, callback) {
      return Array.prototype.filter.call(arr, callback);
    }

    function arrayUnique(arr) {
      var uniqueArray = [];

      for (var i = 0; i < arr.length; i += 1) {
        if (uniqueArray.indexOf(arr[i]) === -1) uniqueArray.push(arr[i]);
      }

      return uniqueArray;
    }

    function toCamelCase$1(string) {
      return string.toLowerCase().replace(/-(.)/g, function (match, group) {
        return group.toUpperCase();
      });
    }

    function qsa(selector, context) {
      if (typeof selector !== 'string') {
        return [selector];
      }

      var a = [];
      var res = context.querySelectorAll(selector);

      for (var i = 0; i < res.length; i += 1) {
        a.push(res[i]);
      }

      return a;
    }

    function $$1(selector, context) {
      var window = getWindow();
      var document = getDocument();
      var arr = [];

      if (!context && selector instanceof Dom7) {
        return selector;
      }

      if (!selector) {
        return new Dom7(arr);
      }

      if (typeof selector === 'string') {
        var html = selector.trim();

        if (html.indexOf('<') >= 0 && html.indexOf('>') >= 0) {
          var toCreate = 'div';
          if (html.indexOf('<li') === 0) toCreate = 'ul';
          if (html.indexOf('<tr') === 0) toCreate = 'tbody';
          if (html.indexOf('<td') === 0 || html.indexOf('<th') === 0) toCreate = 'tr';
          if (html.indexOf('<tbody') === 0) toCreate = 'table';
          if (html.indexOf('<option') === 0) toCreate = 'select';
          var tempParent = document.createElement(toCreate);
          tempParent.innerHTML = html;

          for (var i = 0; i < tempParent.childNodes.length; i += 1) {
            arr.push(tempParent.childNodes[i]);
          }
        } else {
          arr = qsa(selector.trim(), context || document);
        } // arr = qsa(selector, document);

      } else if (selector.nodeType || selector === window || selector === document) {
        arr.push(selector);
      } else if (Array.isArray(selector)) {
        if (selector instanceof Dom7) return selector;
        arr = selector;
      }

      return new Dom7(arrayUnique(arr));
    }

    $$1.fn = Dom7.prototype;

    function addClass() {
      for (var _len = arguments.length, classes = new Array(_len), _key = 0; _key < _len; _key++) {
        classes[_key] = arguments[_key];
      }

      var classNames = arrayFlat(classes.map(function (c) {
        return c.split(' ');
      }));
      this.forEach(function (el) {
        var _el$classList;

        (_el$classList = el.classList).add.apply(_el$classList, classNames);
      });
      return this;
    }

    function removeClass() {
      for (var _len2 = arguments.length, classes = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        classes[_key2] = arguments[_key2];
      }

      var classNames = arrayFlat(classes.map(function (c) {
        return c.split(' ');
      }));
      this.forEach(function (el) {
        var _el$classList2;

        (_el$classList2 = el.classList).remove.apply(_el$classList2, classNames);
      });
      return this;
    }

    function toggleClass() {
      for (var _len3 = arguments.length, classes = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        classes[_key3] = arguments[_key3];
      }

      var classNames = arrayFlat(classes.map(function (c) {
        return c.split(' ');
      }));
      this.forEach(function (el) {
        classNames.forEach(function (className) {
          el.classList.toggle(className);
        });
      });
    }

    function hasClass() {
      for (var _len4 = arguments.length, classes = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        classes[_key4] = arguments[_key4];
      }

      var classNames = arrayFlat(classes.map(function (c) {
        return c.split(' ');
      }));
      return arrayFilter(this, function (el) {
        return classNames.filter(function (className) {
          return el.classList.contains(className);
        }).length > 0;
      }).length > 0;
    }

    function attr(attrs, value) {
      if (arguments.length === 1 && typeof attrs === 'string') {
        // Get attr
        if (this[0]) return this[0].getAttribute(attrs);
        return undefined;
      } // Set attrs


      for (var i = 0; i < this.length; i += 1) {
        if (arguments.length === 2) {
          // String
          this[i].setAttribute(attrs, value);
        } else {
          // Object
          for (var attrName in attrs) {
            this[i][attrName] = attrs[attrName];
            this[i].setAttribute(attrName, attrs[attrName]);
          }
        }
      }

      return this;
    }

    function removeAttr(attr) {
      for (var i = 0; i < this.length; i += 1) {
        this[i].removeAttribute(attr);
      }

      return this;
    }

    function prop(props, value) {
      if (arguments.length === 1 && typeof props === 'string') {
        // Get prop
        if (this[0]) return this[0][props];
      } else {
        // Set props
        for (var i = 0; i < this.length; i += 1) {
          if (arguments.length === 2) {
            // String
            this[i][props] = value;
          } else {
            // Object
            for (var propName in props) {
              this[i][propName] = props[propName];
            }
          }
        }

        return this;
      }

      return this;
    }

    function data(key, value) {
      var el;

      if (typeof value === 'undefined') {
        el = this[0];
        if (!el) return undefined; // Get value

        if (el.dom7ElementDataStorage && key in el.dom7ElementDataStorage) {
          return el.dom7ElementDataStorage[key];
        }

        var dataKey = el.getAttribute("data-" + key);

        if (dataKey) {
          return dataKey;
        }

        return undefined;
      } // Set value


      for (var i = 0; i < this.length; i += 1) {
        el = this[i];
        if (!el.dom7ElementDataStorage) el.dom7ElementDataStorage = {};
        el.dom7ElementDataStorage[key] = value;
      }

      return this;
    }

    function removeData(key) {
      for (var i = 0; i < this.length; i += 1) {
        var el = this[i];

        if (el.dom7ElementDataStorage && el.dom7ElementDataStorage[key]) {
          el.dom7ElementDataStorage[key] = null;
          delete el.dom7ElementDataStorage[key];
        }
      }
    }

    function dataset() {
      var el = this[0];
      if (!el) return undefined;
      var dataset = {}; // eslint-disable-line

      if (el.dataset) {
        for (var dataKey in el.dataset) {
          dataset[dataKey] = el.dataset[dataKey];
        }
      } else {
        for (var i = 0; i < el.attributes.length; i += 1) {
          var _attr = el.attributes[i];

          if (_attr.name.indexOf('data-') >= 0) {
            dataset[toCamelCase$1(_attr.name.split('data-')[1])] = _attr.value;
          }
        }
      }

      for (var key in dataset) {
        if (dataset[key] === 'false') dataset[key] = false;else if (dataset[key] === 'true') dataset[key] = true;else if (parseFloat(dataset[key]) === dataset[key] * 1) dataset[key] *= 1;
      }

      return dataset;
    }

    function val(value) {
      if (typeof value === 'undefined') {
        // get value
        var el = this[0];
        if (!el) return undefined;

        if (el.multiple && el.nodeName.toLowerCase() === 'select') {
          var values = [];

          for (var i = 0; i < el.selectedOptions.length; i += 1) {
            values.push(el.selectedOptions[i].value);
          }

          return values;
        }

        return el.value;
      } // set value


      for (var _i = 0; _i < this.length; _i += 1) {
        var _el = this[_i];

        if (Array.isArray(value) && _el.multiple && _el.nodeName.toLowerCase() === 'select') {
          for (var j = 0; j < _el.options.length; j += 1) {
            _el.options[j].selected = value.indexOf(_el.options[j].value) >= 0;
          }
        } else {
          _el.value = value;
        }
      }

      return this;
    }

    function value(value) {
      return this.val(value);
    }

    function transform(transform) {
      for (var i = 0; i < this.length; i += 1) {
        this[i].style.transform = transform;
      }

      return this;
    }

    function transition$1(duration) {
      for (var i = 0; i < this.length; i += 1) {
        this[i].style.transitionDuration = typeof duration !== 'string' ? duration + "ms" : duration;
      }

      return this;
    }

    function on() {
      for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
        args[_key5] = arguments[_key5];
      }

      var eventType = args[0],
          targetSelector = args[1],
          listener = args[2],
          capture = args[3];

      if (typeof args[1] === 'function') {
        eventType = args[0];
        listener = args[1];
        capture = args[2];
        targetSelector = undefined;
      }

      if (!capture) capture = false;

      function handleLiveEvent(e) {
        var target = e.target;
        if (!target) return;
        var eventData = e.target.dom7EventData || [];

        if (eventData.indexOf(e) < 0) {
          eventData.unshift(e);
        }

        if ($$1(target).is(targetSelector)) listener.apply(target, eventData);else {
          var _parents = $$1(target).parents(); // eslint-disable-line


          for (var k = 0; k < _parents.length; k += 1) {
            if ($$1(_parents[k]).is(targetSelector)) listener.apply(_parents[k], eventData);
          }
        }
      }

      function handleEvent(e) {
        var eventData = e && e.target ? e.target.dom7EventData || [] : [];

        if (eventData.indexOf(e) < 0) {
          eventData.unshift(e);
        }

        listener.apply(this, eventData);
      }

      var events = eventType.split(' ');
      var j;

      for (var i = 0; i < this.length; i += 1) {
        var el = this[i];

        if (!targetSelector) {
          for (j = 0; j < events.length; j += 1) {
            var event = events[j];
            if (!el.dom7Listeners) el.dom7Listeners = {};
            if (!el.dom7Listeners[event]) el.dom7Listeners[event] = [];
            el.dom7Listeners[event].push({
              listener: listener,
              proxyListener: handleEvent
            });
            el.addEventListener(event, handleEvent, capture);
          }
        } else {
          // Live events
          for (j = 0; j < events.length; j += 1) {
            var _event = events[j];
            if (!el.dom7LiveListeners) el.dom7LiveListeners = {};
            if (!el.dom7LiveListeners[_event]) el.dom7LiveListeners[_event] = [];

            el.dom7LiveListeners[_event].push({
              listener: listener,
              proxyListener: handleLiveEvent
            });

            el.addEventListener(_event, handleLiveEvent, capture);
          }
        }
      }

      return this;
    }

    function off() {
      for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
        args[_key6] = arguments[_key6];
      }

      var eventType = args[0],
          targetSelector = args[1],
          listener = args[2],
          capture = args[3];

      if (typeof args[1] === 'function') {
        eventType = args[0];
        listener = args[1];
        capture = args[2];
        targetSelector = undefined;
      }

      if (!capture) capture = false;
      var events = eventType.split(' ');

      for (var i = 0; i < events.length; i += 1) {
        var event = events[i];

        for (var j = 0; j < this.length; j += 1) {
          var el = this[j];
          var handlers = void 0;

          if (!targetSelector && el.dom7Listeners) {
            handlers = el.dom7Listeners[event];
          } else if (targetSelector && el.dom7LiveListeners) {
            handlers = el.dom7LiveListeners[event];
          }

          if (handlers && handlers.length) {
            for (var k = handlers.length - 1; k >= 0; k -= 1) {
              var handler = handlers[k];

              if (listener && handler.listener === listener) {
                el.removeEventListener(event, handler.proxyListener, capture);
                handlers.splice(k, 1);
              } else if (listener && handler.listener && handler.listener.dom7proxy && handler.listener.dom7proxy === listener) {
                el.removeEventListener(event, handler.proxyListener, capture);
                handlers.splice(k, 1);
              } else if (!listener) {
                el.removeEventListener(event, handler.proxyListener, capture);
                handlers.splice(k, 1);
              }
            }
          }
        }
      }

      return this;
    }

    function once() {
      var dom = this;

      for (var _len7 = arguments.length, args = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
        args[_key7] = arguments[_key7];
      }

      var eventName = args[0],
          targetSelector = args[1],
          listener = args[2],
          capture = args[3];

      if (typeof args[1] === 'function') {
        eventName = args[0];
        listener = args[1];
        capture = args[2];
        targetSelector = undefined;
      }

      function onceHandler() {
        for (var _len8 = arguments.length, eventArgs = new Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
          eventArgs[_key8] = arguments[_key8];
        }

        listener.apply(this, eventArgs);
        dom.off(eventName, targetSelector, onceHandler, capture);

        if (onceHandler.dom7proxy) {
          delete onceHandler.dom7proxy;
        }
      }

      onceHandler.dom7proxy = listener;
      return dom.on(eventName, targetSelector, onceHandler, capture);
    }

    function trigger() {
      var window = getWindow();

      for (var _len9 = arguments.length, args = new Array(_len9), _key9 = 0; _key9 < _len9; _key9++) {
        args[_key9] = arguments[_key9];
      }

      var events = args[0].split(' ');
      var eventData = args[1];

      for (var i = 0; i < events.length; i += 1) {
        var event = events[i];

        for (var j = 0; j < this.length; j += 1) {
          var el = this[j];

          if (window.CustomEvent) {
            var evt = new window.CustomEvent(event, {
              detail: eventData,
              bubbles: true,
              cancelable: true
            });
            el.dom7EventData = args.filter(function (data, dataIndex) {
              return dataIndex > 0;
            });
            el.dispatchEvent(evt);
            el.dom7EventData = [];
            delete el.dom7EventData;
          }
        }
      }

      return this;
    }

    function transitionEnd$1(callback) {
      var dom = this;

      function fireCallBack(e) {
        if (e.target !== this) return;
        callback.call(this, e);
        dom.off('transitionend', fireCallBack);
      }

      if (callback) {
        dom.on('transitionend', fireCallBack);
      }

      return this;
    }

    function animationEnd(callback) {
      var dom = this;

      function fireCallBack(e) {
        if (e.target !== this) return;
        callback.call(this, e);
        dom.off('animationend', fireCallBack);
      }

      if (callback) {
        dom.on('animationend', fireCallBack);
      }

      return this;
    }

    function width() {
      var window = getWindow();

      if (this[0] === window) {
        return window.innerWidth;
      }

      if (this.length > 0) {
        return parseFloat(this.css('width'));
      }

      return null;
    }

    function outerWidth(includeMargins) {
      if (this.length > 0) {
        if (includeMargins) {
          var _styles = this.styles();

          return this[0].offsetWidth + parseFloat(_styles.getPropertyValue('margin-right')) + parseFloat(_styles.getPropertyValue('margin-left'));
        }

        return this[0].offsetWidth;
      }

      return null;
    }

    function height() {
      var window = getWindow();

      if (this[0] === window) {
        return window.innerHeight;
      }

      if (this.length > 0) {
        return parseFloat(this.css('height'));
      }

      return null;
    }

    function outerHeight(includeMargins) {
      if (this.length > 0) {
        if (includeMargins) {
          var _styles2 = this.styles();

          return this[0].offsetHeight + parseFloat(_styles2.getPropertyValue('margin-top')) + parseFloat(_styles2.getPropertyValue('margin-bottom'));
        }

        return this[0].offsetHeight;
      }

      return null;
    }

    function offset() {
      if (this.length > 0) {
        var window = getWindow();
        var document = getDocument();
        var el = this[0];
        var box = el.getBoundingClientRect();
        var body = document.body;
        var clientTop = el.clientTop || body.clientTop || 0;
        var clientLeft = el.clientLeft || body.clientLeft || 0;
        var scrollTop = el === window ? window.scrollY : el.scrollTop;
        var scrollLeft = el === window ? window.scrollX : el.scrollLeft;
        return {
          top: box.top + scrollTop - clientTop,
          left: box.left + scrollLeft - clientLeft
        };
      }

      return null;
    }

    function hide() {
      for (var i = 0; i < this.length; i += 1) {
        this[i].style.display = 'none';
      }

      return this;
    }

    function show() {
      var window = getWindow();

      for (var i = 0; i < this.length; i += 1) {
        var el = this[i];

        if (el.style.display === 'none') {
          el.style.display = '';
        }

        if (window.getComputedStyle(el, null).getPropertyValue('display') === 'none') {
          // Still not visible
          el.style.display = 'block';
        }
      }

      return this;
    }

    function styles() {
      var window = getWindow();
      if (this[0]) return window.getComputedStyle(this[0], null);
      return {};
    }

    function css(props, value) {
      var window = getWindow();
      var i;

      if (arguments.length === 1) {
        if (typeof props === 'string') {
          // .css('width')
          if (this[0]) return window.getComputedStyle(this[0], null).getPropertyValue(props);
        } else {
          // .css({ width: '100px' })
          for (i = 0; i < this.length; i += 1) {
            for (var _prop in props) {
              this[i].style[_prop] = props[_prop];
            }
          }

          return this;
        }
      }

      if (arguments.length === 2 && typeof props === 'string') {
        // .css('width', '100px')
        for (i = 0; i < this.length; i += 1) {
          this[i].style[props] = value;
        }

        return this;
      }

      return this;
    }

    function each(callback) {
      if (!callback) return this;
      this.forEach(function (el, index) {
        callback.apply(el, [el, index]);
      });
      return this;
    }

    function filter(callback) {
      var result = arrayFilter(this, callback);
      return $$1(result);
    }

    function html(html) {
      if (typeof html === 'undefined') {
        return this[0] ? this[0].innerHTML : null;
      }

      for (var i = 0; i < this.length; i += 1) {
        this[i].innerHTML = html;
      }

      return this;
    }

    function text(text) {
      if (typeof text === 'undefined') {
        return this[0] ? this[0].textContent.trim() : null;
      }

      for (var i = 0; i < this.length; i += 1) {
        this[i].textContent = text;
      }

      return this;
    }

    function is(selector) {
      var window = getWindow();
      var document = getDocument();
      var el = this[0];
      var compareWith;
      var i;
      if (!el || typeof selector === 'undefined') return false;

      if (typeof selector === 'string') {
        if (el.matches) return el.matches(selector);
        if (el.webkitMatchesSelector) return el.webkitMatchesSelector(selector);
        if (el.msMatchesSelector) return el.msMatchesSelector(selector);
        compareWith = $$1(selector);

        for (i = 0; i < compareWith.length; i += 1) {
          if (compareWith[i] === el) return true;
        }

        return false;
      }

      if (selector === document) {
        return el === document;
      }

      if (selector === window) {
        return el === window;
      }

      if (selector.nodeType || selector instanceof Dom7) {
        compareWith = selector.nodeType ? [selector] : selector;

        for (i = 0; i < compareWith.length; i += 1) {
          if (compareWith[i] === el) return true;
        }

        return false;
      }

      return false;
    }

    function index() {
      var child = this[0];
      var i;

      if (child) {
        i = 0; // eslint-disable-next-line

        while ((child = child.previousSibling) !== null) {
          if (child.nodeType === 1) i += 1;
        }

        return i;
      }

      return undefined;
    }

    function eq(index) {
      if (typeof index === 'undefined') return this;
      var length = this.length;

      if (index > length - 1) {
        return $$1([]);
      }

      if (index < 0) {
        var returnIndex = length + index;
        if (returnIndex < 0) return $$1([]);
        return $$1([this[returnIndex]]);
      }

      return $$1([this[index]]);
    }

    function append() {
      var newChild;
      var document = getDocument();

      for (var k = 0; k < arguments.length; k += 1) {
        newChild = k < 0 || arguments.length <= k ? undefined : arguments[k];

        for (var i = 0; i < this.length; i += 1) {
          if (typeof newChild === 'string') {
            var tempDiv = document.createElement('div');
            tempDiv.innerHTML = newChild;

            while (tempDiv.firstChild) {
              this[i].appendChild(tempDiv.firstChild);
            }
          } else if (newChild instanceof Dom7) {
            for (var j = 0; j < newChild.length; j += 1) {
              this[i].appendChild(newChild[j]);
            }
          } else {
            this[i].appendChild(newChild);
          }
        }
      }

      return this;
    }

    function appendTo(parent) {
      $$1(parent).append(this);
      return this;
    }

    function prepend(newChild) {
      var document = getDocument();
      var i;
      var j;

      for (i = 0; i < this.length; i += 1) {
        if (typeof newChild === 'string') {
          var tempDiv = document.createElement('div');
          tempDiv.innerHTML = newChild;

          for (j = tempDiv.childNodes.length - 1; j >= 0; j -= 1) {
            this[i].insertBefore(tempDiv.childNodes[j], this[i].childNodes[0]);
          }
        } else if (newChild instanceof Dom7) {
          for (j = 0; j < newChild.length; j += 1) {
            this[i].insertBefore(newChild[j], this[i].childNodes[0]);
          }
        } else {
          this[i].insertBefore(newChild, this[i].childNodes[0]);
        }
      }

      return this;
    }

    function prependTo(parent) {
      $$1(parent).prepend(this);
      return this;
    }

    function insertBefore$1(selector) {
      var before = $$1(selector);

      for (var i = 0; i < this.length; i += 1) {
        if (before.length === 1) {
          before[0].parentNode.insertBefore(this[i], before[0]);
        } else if (before.length > 1) {
          for (var j = 0; j < before.length; j += 1) {
            before[j].parentNode.insertBefore(this[i].cloneNode(true), before[j]);
          }
        }
      }
    }

    function insertAfter(selector) {
      var after = $$1(selector);

      for (var i = 0; i < this.length; i += 1) {
        if (after.length === 1) {
          after[0].parentNode.insertBefore(this[i], after[0].nextSibling);
        } else if (after.length > 1) {
          for (var j = 0; j < after.length; j += 1) {
            after[j].parentNode.insertBefore(this[i].cloneNode(true), after[j].nextSibling);
          }
        }
      }
    }

    function next(selector) {
      if (this.length > 0) {
        if (selector) {
          if (this[0].nextElementSibling && $$1(this[0].nextElementSibling).is(selector)) {
            return $$1([this[0].nextElementSibling]);
          }

          return $$1([]);
        }

        if (this[0].nextElementSibling) return $$1([this[0].nextElementSibling]);
        return $$1([]);
      }

      return $$1([]);
    }

    function nextAll(selector) {
      var nextEls = [];
      var el = this[0];
      if (!el) return $$1([]);

      while (el.nextElementSibling) {
        var _next = el.nextElementSibling; // eslint-disable-line

        if (selector) {
          if ($$1(_next).is(selector)) nextEls.push(_next);
        } else nextEls.push(_next);

        el = _next;
      }

      return $$1(nextEls);
    }

    function prev(selector) {
      if (this.length > 0) {
        var el = this[0];

        if (selector) {
          if (el.previousElementSibling && $$1(el.previousElementSibling).is(selector)) {
            return $$1([el.previousElementSibling]);
          }

          return $$1([]);
        }

        if (el.previousElementSibling) return $$1([el.previousElementSibling]);
        return $$1([]);
      }

      return $$1([]);
    }

    function prevAll(selector) {
      var prevEls = [];
      var el = this[0];
      if (!el) return $$1([]);

      while (el.previousElementSibling) {
        var _prev = el.previousElementSibling; // eslint-disable-line

        if (selector) {
          if ($$1(_prev).is(selector)) prevEls.push(_prev);
        } else prevEls.push(_prev);

        el = _prev;
      }

      return $$1(prevEls);
    }

    function siblings(selector) {
      return this.nextAll(selector).add(this.prevAll(selector));
    }

    function parent(selector) {
      var parents = []; // eslint-disable-line

      for (var i = 0; i < this.length; i += 1) {
        if (this[i].parentNode !== null) {
          if (selector) {
            if ($$1(this[i].parentNode).is(selector)) parents.push(this[i].parentNode);
          } else {
            parents.push(this[i].parentNode);
          }
        }
      }

      return $$1(parents);
    }

    function parents(selector) {
      var parents = []; // eslint-disable-line

      for (var i = 0; i < this.length; i += 1) {
        var _parent = this[i].parentNode; // eslint-disable-line

        while (_parent) {
          if (selector) {
            if ($$1(_parent).is(selector)) parents.push(_parent);
          } else {
            parents.push(_parent);
          }

          _parent = _parent.parentNode;
        }
      }

      return $$1(parents);
    }

    function closest(selector) {
      var closest = this; // eslint-disable-line

      if (typeof selector === 'undefined') {
        return $$1([]);
      }

      if (!closest.is(selector)) {
        closest = closest.parents(selector).eq(0);
      }

      return closest;
    }

    function find(selector) {
      var foundElements = [];

      for (var i = 0; i < this.length; i += 1) {
        var found = this[i].querySelectorAll(selector);

        for (var j = 0; j < found.length; j += 1) {
          foundElements.push(found[j]);
        }
      }

      return $$1(foundElements);
    }

    function children(selector) {
      var children = []; // eslint-disable-line

      for (var i = 0; i < this.length; i += 1) {
        var childNodes = this[i].children;

        for (var j = 0; j < childNodes.length; j += 1) {
          if (!selector || $$1(childNodes[j]).is(selector)) {
            children.push(childNodes[j]);
          }
        }
      }

      return $$1(children);
    }

    function remove() {
      for (var i = 0; i < this.length; i += 1) {
        if (this[i].parentNode) this[i].parentNode.removeChild(this[i]);
      }

      return this;
    }

    function detach() {
      return this.remove();
    }

    function add() {
      var dom = this;
      var i;
      var j;

      for (var _len10 = arguments.length, els = new Array(_len10), _key10 = 0; _key10 < _len10; _key10++) {
        els[_key10] = arguments[_key10];
      }

      for (i = 0; i < els.length; i += 1) {
        var toAdd = $$1(els[i]);

        for (j = 0; j < toAdd.length; j += 1) {
          dom.push(toAdd[j]);
        }
      }

      return dom;
    }

    function empty() {
      for (var i = 0; i < this.length; i += 1) {
        var el = this[i];

        if (el.nodeType === 1) {
          for (var j = 0; j < el.childNodes.length; j += 1) {
            if (el.childNodes[j].parentNode) {
              el.childNodes[j].parentNode.removeChild(el.childNodes[j]);
            }
          }

          el.textContent = '';
        }
      }

      return this;
    }

    function scrollTo() {
      var window = getWindow();

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var left = args[0],
          top = args[1],
          duration = args[2],
          easing = args[3],
          callback = args[4];

      if (args.length === 4 && typeof easing === 'function') {
        callback = easing;
        left = args[0];
        top = args[1];
        duration = args[2];
        callback = args[3];
        easing = args[4];
      }

      if (typeof easing === 'undefined') easing = 'swing';
      return this.each(function animate() {
        var el = this;
        var currentTop;
        var currentLeft;
        var maxTop;
        var maxLeft;
        var newTop;
        var newLeft;
        var scrollTop; // eslint-disable-line

        var scrollLeft; // eslint-disable-line

        var animateTop = top > 0 || top === 0;
        var animateLeft = left > 0 || left === 0;

        if (typeof easing === 'undefined') {
          easing = 'swing';
        }

        if (animateTop) {
          currentTop = el.scrollTop;

          if (!duration) {
            el.scrollTop = top;
          }
        }

        if (animateLeft) {
          currentLeft = el.scrollLeft;

          if (!duration) {
            el.scrollLeft = left;
          }
        }

        if (!duration) return;

        if (animateTop) {
          maxTop = el.scrollHeight - el.offsetHeight;
          newTop = Math.max(Math.min(top, maxTop), 0);
        }

        if (animateLeft) {
          maxLeft = el.scrollWidth - el.offsetWidth;
          newLeft = Math.max(Math.min(left, maxLeft), 0);
        }

        var startTime = null;
        if (animateTop && newTop === currentTop) animateTop = false;
        if (animateLeft && newLeft === currentLeft) animateLeft = false;

        function render(time) {
          if (time === void 0) {
            time = new Date().getTime();
          }

          if (startTime === null) {
            startTime = time;
          }

          var progress = Math.max(Math.min((time - startTime) / duration, 1), 0);
          var easeProgress = easing === 'linear' ? progress : 0.5 - Math.cos(progress * Math.PI) / 2;
          var done;
          if (animateTop) scrollTop = currentTop + easeProgress * (newTop - currentTop);
          if (animateLeft) scrollLeft = currentLeft + easeProgress * (newLeft - currentLeft);

          if (animateTop && newTop > currentTop && scrollTop >= newTop) {
            el.scrollTop = newTop;
            done = true;
          }

          if (animateTop && newTop < currentTop && scrollTop <= newTop) {
            el.scrollTop = newTop;
            done = true;
          }

          if (animateLeft && newLeft > currentLeft && scrollLeft >= newLeft) {
            el.scrollLeft = newLeft;
            done = true;
          }

          if (animateLeft && newLeft < currentLeft && scrollLeft <= newLeft) {
            el.scrollLeft = newLeft;
            done = true;
          }

          if (done) {
            if (callback) callback();
            return;
          }

          if (animateTop) el.scrollTop = scrollTop;
          if (animateLeft) el.scrollLeft = scrollLeft;
          window.requestAnimationFrame(render);
        }

        window.requestAnimationFrame(render);
      });
    } // scrollTop(top, duration, easing, callback) {


    function scrollTop() {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      var top = args[0],
          duration = args[1],
          easing = args[2],
          callback = args[3];

      if (args.length === 3 && typeof easing === 'function') {
        top = args[0];
        duration = args[1];
        callback = args[2];
        easing = args[3];
      }

      var dom = this;

      if (typeof top === 'undefined') {
        if (dom.length > 0) return dom[0].scrollTop;
        return null;
      }

      return dom.scrollTo(undefined, top, duration, easing, callback);
    }

    function scrollLeft() {
      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      var left = args[0],
          duration = args[1],
          easing = args[2],
          callback = args[3];

      if (args.length === 3 && typeof easing === 'function') {
        left = args[0];
        duration = args[1];
        callback = args[2];
        easing = args[3];
      }

      var dom = this;

      if (typeof left === 'undefined') {
        if (dom.length > 0) return dom[0].scrollLeft;
        return null;
      }

      return dom.scrollTo(left, undefined, duration, easing, callback);
    }

    function animate(initialProps, initialParams) {
      var window = getWindow();
      var els = this;
      var a = {
        props: Object.assign({}, initialProps),
        params: Object.assign({
          duration: 300,
          easing: 'swing' // or 'linear'

          /* Callbacks
          begin(elements)
          complete(elements)
          progress(elements, complete, remaining, start, tweenValue)
          */

        }, initialParams),
        elements: els,
        animating: false,
        que: [],
        easingProgress: function easingProgress(easing, progress) {
          if (easing === 'swing') {
            return 0.5 - Math.cos(progress * Math.PI) / 2;
          }

          if (typeof easing === 'function') {
            return easing(progress);
          }

          return progress;
        },
        stop: function stop() {
          if (a.frameId) {
            window.cancelAnimationFrame(a.frameId);
          }

          a.animating = false;
          a.elements.each(function (el) {
            var element = el;
            delete element.dom7AnimateInstance;
          });
          a.que = [];
        },
        done: function done(complete) {
          a.animating = false;
          a.elements.each(function (el) {
            var element = el;
            delete element.dom7AnimateInstance;
          });
          if (complete) complete(els);

          if (a.que.length > 0) {
            var que = a.que.shift();
            a.animate(que[0], que[1]);
          }
        },
        animate: function animate(props, params) {
          if (a.animating) {
            a.que.push([props, params]);
            return a;
          }

          var elements = []; // Define & Cache Initials & Units

          a.elements.each(function (el, index) {
            var initialFullValue;
            var initialValue;
            var unit;
            var finalValue;
            var finalFullValue;
            if (!el.dom7AnimateInstance) a.elements[index].dom7AnimateInstance = a;
            elements[index] = {
              container: el
            };
            Object.keys(props).forEach(function (prop) {
              initialFullValue = window.getComputedStyle(el, null).getPropertyValue(prop).replace(',', '.');
              initialValue = parseFloat(initialFullValue);
              unit = initialFullValue.replace(initialValue, '');
              finalValue = parseFloat(props[prop]);
              finalFullValue = props[prop] + unit;
              elements[index][prop] = {
                initialFullValue: initialFullValue,
                initialValue: initialValue,
                unit: unit,
                finalValue: finalValue,
                finalFullValue: finalFullValue,
                currentValue: initialValue
              };
            });
          });
          var startTime = null;
          var time;
          var elementsDone = 0;
          var propsDone = 0;
          var done;
          var began = false;
          a.animating = true;

          function render() {
            time = new Date().getTime();
            var progress;
            var easeProgress; // let el;

            if (!began) {
              began = true;
              if (params.begin) params.begin(els);
            }

            if (startTime === null) {
              startTime = time;
            }

            if (params.progress) {
              // eslint-disable-next-line
              params.progress(els, Math.max(Math.min((time - startTime) / params.duration, 1), 0), startTime + params.duration - time < 0 ? 0 : startTime + params.duration - time, startTime);
            }

            elements.forEach(function (element) {
              var el = element;
              if (done || el.done) return;
              Object.keys(props).forEach(function (prop) {
                if (done || el.done) return;
                progress = Math.max(Math.min((time - startTime) / params.duration, 1), 0);
                easeProgress = a.easingProgress(params.easing, progress);
                var _el$prop = el[prop],
                    initialValue = _el$prop.initialValue,
                    finalValue = _el$prop.finalValue,
                    unit = _el$prop.unit;
                el[prop].currentValue = initialValue + easeProgress * (finalValue - initialValue);
                var currentValue = el[prop].currentValue;

                if (finalValue > initialValue && currentValue >= finalValue || finalValue < initialValue && currentValue <= finalValue) {
                  el.container.style[prop] = finalValue + unit;
                  propsDone += 1;

                  if (propsDone === Object.keys(props).length) {
                    el.done = true;
                    elementsDone += 1;
                  }

                  if (elementsDone === elements.length) {
                    done = true;
                  }
                }

                if (done) {
                  a.done(params.complete);
                  return;
                }

                el.container.style[prop] = currentValue + unit;
              });
            });
            if (done) return; // Then call

            a.frameId = window.requestAnimationFrame(render);
          }

          a.frameId = window.requestAnimationFrame(render);
          return a;
        }
      };

      if (a.elements.length === 0) {
        return els;
      }

      var animateInstance;

      for (var i = 0; i < a.elements.length; i += 1) {
        if (a.elements[i].dom7AnimateInstance) {
          animateInstance = a.elements[i].dom7AnimateInstance;
        } else a.elements[i].dom7AnimateInstance = a;
      }

      if (!animateInstance) {
        animateInstance = a;
      }

      if (initialProps === 'stop') {
        animateInstance.stop();
      } else {
        animateInstance.animate(a.props, a.params);
      }

      return els;
    }

    function stop() {
      var els = this;

      for (var i = 0; i < els.length; i += 1) {
        if (els[i].dom7AnimateInstance) {
          els[i].dom7AnimateInstance.stop();
        }
      }
    }

    var noTrigger = 'resize scroll'.split(' ');

    function shortcut(name) {
      function eventHandler() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        if (typeof args[0] === 'undefined') {
          for (var i = 0; i < this.length; i += 1) {
            if (noTrigger.indexOf(name) < 0) {
              if (name in this[i]) this[i][name]();else {
                $$1(this[i]).trigger(name);
              }
            }
          }

          return this;
        }

        return this.on.apply(this, [name].concat(args));
      }

      return eventHandler;
    }

    var click = shortcut('click');
    var blur = shortcut('blur');
    var focus = shortcut('focus');
    var focusin = shortcut('focusin');
    var focusout = shortcut('focusout');
    var keyup = shortcut('keyup');
    var keydown = shortcut('keydown');
    var keypress = shortcut('keypress');
    var submit = shortcut('submit');
    var change = shortcut('change');
    var mousedown = shortcut('mousedown');
    var mousemove = shortcut('mousemove');
    var mouseup = shortcut('mouseup');
    var mouseenter = shortcut('mouseenter');
    var mouseleave = shortcut('mouseleave');
    var mouseout = shortcut('mouseout');
    var mouseover = shortcut('mouseover');
    var touchstart = shortcut('touchstart');
    var touchend = shortcut('touchend');
    var touchmove = shortcut('touchmove');
    var resize = shortcut('resize');
    var scroll = shortcut('scroll');

    var methods = /*#__PURE__*/Object.freeze({
        __proto__: null,
        'default': $$1,
        $: $$1,
        add: add,
        addClass: addClass,
        animate: animate,
        animationEnd: animationEnd,
        append: append,
        appendTo: appendTo,
        attr: attr,
        blur: blur,
        change: change,
        children: children,
        click: click,
        closest: closest,
        css: css,
        data: data,
        dataset: dataset,
        detach: detach,
        each: each,
        empty: empty,
        eq: eq,
        filter: filter,
        find: find,
        focus: focus,
        focusin: focusin,
        focusout: focusout,
        hasClass: hasClass,
        height: height,
        hide: hide,
        html: html,
        index: index,
        insertAfter: insertAfter,
        insertBefore: insertBefore$1,
        is: is,
        keydown: keydown,
        keypress: keypress,
        keyup: keyup,
        mousedown: mousedown,
        mouseenter: mouseenter,
        mouseleave: mouseleave,
        mousemove: mousemove,
        mouseout: mouseout,
        mouseover: mouseover,
        mouseup: mouseup,
        next: next,
        nextAll: nextAll,
        off: off,
        offset: offset,
        on: on,
        once: once,
        outerHeight: outerHeight,
        outerWidth: outerWidth,
        parent: parent,
        parents: parents,
        prepend: prepend,
        prependTo: prependTo,
        prev: prev,
        prevAll: prevAll,
        prop: prop,
        remove: remove,
        removeAttr: removeAttr,
        removeClass: removeClass,
        removeData: removeData,
        resize: resize,
        scroll: scroll,
        scrollLeft: scrollLeft,
        scrollTo: scrollTo,
        scrollTop: scrollTop,
        show: show,
        siblings: siblings,
        stop: stop,
        styles: styles,
        submit: submit,
        text: text,
        toggleClass: toggleClass,
        touchend: touchend,
        touchmove: touchmove,
        touchstart: touchstart,
        transform: transform,
        transition: transition$1,
        transitionEnd: transitionEnd$1,
        trigger: trigger,
        val: val,
        value: value,
        width: width
    });

    Object.keys(methods).forEach(function (methodName) {
      if (methodName === '$') return;
      $$1.fn[methodName] = methods[methodName];
    });
    var $ = $$1;

    var REACT_ELEMENT_TYPE;

    function _jsx(type, props, key, children) {
      if (!REACT_ELEMENT_TYPE) {
        REACT_ELEMENT_TYPE = typeof Symbol === "function" && Symbol["for"] && Symbol["for"]("react.element") || 0xeac7;
      }

      var defaultProps = type && type.defaultProps;
      var childrenLength = arguments.length - 3;

      if (!props && childrenLength !== 0) {
        props = {
          children: void 0
        };
      }

      if (childrenLength === 1) {
        props.children = children;
      } else if (childrenLength > 1) {
        var childArray = new Array(childrenLength);

        for (var i = 0; i < childrenLength; i++) {
          childArray[i] = arguments[i + 3];
        }

        props.children = childArray;
      }

      if (props && defaultProps) {
        for (var propName in defaultProps) {
          if (props[propName] === void 0) {
            props[propName] = defaultProps[propName];
          }
        }
      } else if (!props) {
        props = defaultProps || {};
      }

      return {
        $$typeof: REACT_ELEMENT_TYPE,
        type: type,
        key: key === undefined ? null : "" + key,
        ref: null,
        props: props,
        _owner: null
      };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);

      if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);

        if (enumerableOnly) {
          symbols = symbols.filter(function (sym) {
            return Object.getOwnPropertyDescriptor(object, sym).enumerable;
          });
        }

        keys.push.apply(keys, symbols);
      }

      return keys;
    }

    function _objectSpread2(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};

        if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }

      return target;
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";

      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function (obj) {
          return typeof obj;
        };
      } else {
        _typeof = function (obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }

      return _typeof(obj);
    }

    function _wrapRegExp() {
      _wrapRegExp = function (re, groups) {
        return new BabelRegExp(re, undefined, groups);
      };

      var _super = RegExp.prototype;

      var _groups = new WeakMap();

      function BabelRegExp(re, flags, groups) {
        var _this = new RegExp(re, flags);

        _groups.set(_this, groups || _groups.get(re));

        return _setPrototypeOf(_this, BabelRegExp.prototype);
      }

      _inherits(BabelRegExp, RegExp);

      BabelRegExp.prototype.exec = function (str) {
        var result = _super.exec.call(this, str);

        if (result) result.groups = buildGroups(result, this);
        return result;
      };

      BabelRegExp.prototype[Symbol.replace] = function (str, substitution) {
        if (typeof substitution === "string") {
          var groups = _groups.get(this);

          return _super[Symbol.replace].call(this, str, substitution.replace(/\$<([^>]+)>/g, function (_, name) {
            return "$" + groups[name];
          }));
        } else if (typeof substitution === "function") {
          var _this = this;

          return _super[Symbol.replace].call(this, str, function () {
            var args = arguments;

            if (typeof args[args.length - 1] !== "object") {
              args = [].slice.call(args);
              args.push(buildGroups(args, _this));
            }

            return substitution.apply(this, args);
          });
        } else {
          return _super[Symbol.replace].call(this, str, substitution);
        }
      };

      function buildGroups(result, re) {
        var g = _groups.get(re);

        return Object.keys(g).reduce(function (groups, name) {
          groups[name] = result[g[name]];
          return groups;
        }, Object.create(null));
      }

      return _wrapRegExp.apply(this, arguments);
    }

    function _asyncIterator(iterable) {
      var method;

      if (typeof Symbol !== "undefined") {
        if (Symbol.asyncIterator) method = iterable[Symbol.asyncIterator];
        if (method == null && Symbol.iterator) method = iterable[Symbol.iterator];
      }

      if (method == null) method = iterable["@@asyncIterator"];
      if (method == null) method = iterable["@@iterator"];
      if (method == null) throw new TypeError("Object is not async iterable");
      return method.call(iterable);
    }

    function _AwaitValue(value) {
      this.wrapped = value;
    }

    function _AsyncGenerator(gen) {
      var front, back;

      function send(key, arg) {
        return new Promise(function (resolve, reject) {
          var request = {
            key: key,
            arg: arg,
            resolve: resolve,
            reject: reject,
            next: null
          };

          if (back) {
            back = back.next = request;
          } else {
            front = back = request;
            resume(key, arg);
          }
        });
      }

      function resume(key, arg) {
        try {
          var result = gen[key](arg);
          var value = result.value;
          var wrappedAwait = value instanceof _AwaitValue;
          Promise.resolve(wrappedAwait ? value.wrapped : value).then(function (arg) {
            if (wrappedAwait) {
              resume(key === "return" ? "return" : "next", arg);
              return;
            }

            settle(result.done ? "return" : "normal", arg);
          }, function (err) {
            resume("throw", err);
          });
        } catch (err) {
          settle("throw", err);
        }
      }

      function settle(type, value) {
        switch (type) {
          case "return":
            front.resolve({
              value: value,
              done: true
            });
            break;

          case "throw":
            front.reject(value);
            break;

          default:
            front.resolve({
              value: value,
              done: false
            });
            break;
        }

        front = front.next;

        if (front) {
          resume(front.key, front.arg);
        } else {
          back = null;
        }
      }

      this._invoke = send;

      if (typeof gen.return !== "function") {
        this.return = undefined;
      }
    }

    _AsyncGenerator.prototype[typeof Symbol === "function" && Symbol.asyncIterator || "@@asyncIterator"] = function () {
      return this;
    };

    _AsyncGenerator.prototype.next = function (arg) {
      return this._invoke("next", arg);
    };

    _AsyncGenerator.prototype.throw = function (arg) {
      return this._invoke("throw", arg);
    };

    _AsyncGenerator.prototype.return = function (arg) {
      return this._invoke("return", arg);
    };

    function _wrapAsyncGenerator(fn) {
      return function () {
        return new _AsyncGenerator(fn.apply(this, arguments));
      };
    }

    function _awaitAsyncGenerator(value) {
      return new _AwaitValue(value);
    }

    function _asyncGeneratorDelegate(inner, awaitWrap) {
      var iter = {},
          waiting = false;

      function pump(key, value) {
        waiting = true;
        value = new Promise(function (resolve) {
          resolve(inner[key](value));
        });
        return {
          done: false,
          value: awaitWrap(value)
        };
      }

      ;

      iter[typeof Symbol !== "undefined" && Symbol.iterator || "@@iterator"] = function () {
        return this;
      };

      iter.next = function (value) {
        if (waiting) {
          waiting = false;
          return value;
        }

        return pump("next", value);
      };

      if (typeof inner.throw === "function") {
        iter.throw = function (value) {
          if (waiting) {
            waiting = false;
            throw value;
          }

          return pump("throw", value);
        };
      }

      if (typeof inner.return === "function") {
        iter.return = function (value) {
          if (waiting) {
            waiting = false;
            return value;
          }

          return pump("return", value);
        };
      }

      return iter;
    }

    function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
      try {
        var info = gen[key](arg);
        var value = info.value;
      } catch (error) {
        reject(error);
        return;
      }

      if (info.done) {
        resolve(value);
      } else {
        Promise.resolve(value).then(_next, _throw);
      }
    }

    function _asyncToGenerator(fn) {
      return function () {
        var self = this,
            args = arguments;
        return new Promise(function (resolve, reject) {
          var gen = fn.apply(self, args);

          function _next(value) {
            asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
          }

          function _throw(err) {
            asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
          }

          _next(undefined);
        });
      };
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties$1(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass$1(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties$1(Constructor.prototype, protoProps);
      if (staticProps) _defineProperties$1(Constructor, staticProps);
      return Constructor;
    }

    function _defineEnumerableProperties(obj, descs) {
      for (var key in descs) {
        var desc = descs[key];
        desc.configurable = desc.enumerable = true;
        if ("value" in desc) desc.writable = true;
        Object.defineProperty(obj, key, desc);
      }

      if (Object.getOwnPropertySymbols) {
        var objectSymbols = Object.getOwnPropertySymbols(descs);

        for (var i = 0; i < objectSymbols.length; i++) {
          var sym = objectSymbols[i];
          var desc = descs[sym];
          desc.configurable = desc.enumerable = true;
          if ("value" in desc) desc.writable = true;
          Object.defineProperty(obj, sym, desc);
        }
      }

      return obj;
    }

    function _defaults(obj, defaults) {
      var keys = Object.getOwnPropertyNames(defaults);

      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var value = Object.getOwnPropertyDescriptor(defaults, key);

        if (value && value.configurable && obj[key] === undefined) {
          Object.defineProperty(obj, key, value);
        }
      }

      return obj;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, {
          value: value,
          enumerable: true,
          configurable: true,
          writable: true
        });
      } else {
        obj[key] = value;
      }

      return obj;
    }

    function _extends$j() {
      _extends$j = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];

          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }

        return target;
      };

      return _extends$j.apply(this, arguments);
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? Object(arguments[i]) : {};
        var ownKeys = Object.keys(source);

        if (typeof Object.getOwnPropertySymbols === 'function') {
          ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
            return Object.getOwnPropertyDescriptor(source, sym).enumerable;
          }));
        }

        ownKeys.forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      }

      return target;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }

      subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {
          value: subClass,
          writable: true,
          configurable: true
        }
      });
      if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;

      _setPrototypeOf(subClass, superClass);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };
      return _getPrototypeOf(o);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;
        return o;
      };

      return _setPrototypeOf(o, p);
    }

    function _isNativeReflectConstruct() {
      if (typeof Reflect === "undefined" || !Reflect.construct) return false;
      if (Reflect.construct.sham) return false;
      if (typeof Proxy === "function") return true;

      try {
        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
        return true;
      } catch (e) {
        return false;
      }
    }

    function _construct(Parent, args, Class) {
      if (_isNativeReflectConstruct()) {
        _construct = Reflect.construct;
      } else {
        _construct = function _construct(Parent, args, Class) {
          var a = [null];
          a.push.apply(a, args);
          var Constructor = Function.bind.apply(Parent, a);
          var instance = new Constructor();
          if (Class) _setPrototypeOf(instance, Class.prototype);
          return instance;
        };
      }

      return _construct.apply(null, arguments);
    }

    function _isNativeFunction(fn) {
      return Function.toString.call(fn).indexOf("[native code]") !== -1;
    }

    function _wrapNativeSuper(Class) {
      var _cache = typeof Map === "function" ? new Map() : undefined;

      _wrapNativeSuper = function _wrapNativeSuper(Class) {
        if (Class === null || !_isNativeFunction(Class)) return Class;

        if (typeof Class !== "function") {
          throw new TypeError("Super expression must either be null or a function");
        }

        if (typeof _cache !== "undefined") {
          if (_cache.has(Class)) return _cache.get(Class);

          _cache.set(Class, Wrapper);
        }

        function Wrapper() {
          return _construct(Class, arguments, _getPrototypeOf(this).constructor);
        }

        Wrapper.prototype = Object.create(Class.prototype, {
          constructor: {
            value: Wrapper,
            enumerable: false,
            writable: true,
            configurable: true
          }
        });
        return _setPrototypeOf(Wrapper, Class);
      };

      return _wrapNativeSuper(Class);
    }

    function _instanceof(left, right) {
      if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) {
        return !!right[Symbol.hasInstance](left);
      } else {
        return left instanceof right;
      }
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }

    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function") return null;
      var cacheBabelInterop = new WeakMap();
      var cacheNodeInterop = new WeakMap();
      return (_getRequireWildcardCache = function (nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }

    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }

      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
          default: obj
        };
      }

      var cache = _getRequireWildcardCache(nodeInterop);

      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }

      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }

      newObj.default = obj;

      if (cache) {
        cache.set(obj, newObj);
      }

      return newObj;
    }

    function _newArrowCheck(innerThis, boundThis) {
      if (innerThis !== boundThis) {
        throw new TypeError("Cannot instantiate an arrow function");
      }
    }

    function _objectDestructuringEmpty(obj) {
      if (obj == null) throw new TypeError("Cannot destructure undefined");
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};
      var target = {};
      var sourceKeys = Object.keys(source);
      var key, i;

      for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        target[key] = source[key];
      }

      return target;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};

      var target = _objectWithoutPropertiesLoose(source, excluded);

      var key, i;

      if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

        for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];
          if (excluded.indexOf(key) >= 0) continue;
          if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
          target[key] = source[key];
        }
      }

      return target;
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }

      return self;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (typeof call === "object" || typeof call === "function")) {
        return call;
      }

      return _assertThisInitialized(self);
    }

    function _createSuper(Derived) {
      var hasNativeReflectConstruct = _isNativeReflectConstruct();

      return function _createSuperInternal() {
        var Super = _getPrototypeOf(Derived),
            result;

        if (hasNativeReflectConstruct) {
          var NewTarget = _getPrototypeOf(this).constructor;

          result = Reflect.construct(Super, arguments, NewTarget);
        } else {
          result = Super.apply(this, arguments);
        }

        return _possibleConstructorReturn(this, result);
      };
    }

    function _superPropBase(object, property) {
      while (!Object.prototype.hasOwnProperty.call(object, property)) {
        object = _getPrototypeOf(object);
        if (object === null) break;
      }

      return object;
    }

    function _get(target, property, receiver) {
      if (typeof Reflect !== "undefined" && Reflect.get) {
        _get = Reflect.get;
      } else {
        _get = function _get(target, property, receiver) {
          var base = _superPropBase(target, property);

          if (!base) return;
          var desc = Object.getOwnPropertyDescriptor(base, property);

          if (desc.get) {
            return desc.get.call(receiver);
          }

          return desc.value;
        };
      }

      return _get(target, property, receiver || target);
    }

    function set(target, property, value, receiver) {
      if (typeof Reflect !== "undefined" && Reflect.set) {
        set = Reflect.set;
      } else {
        set = function set(target, property, value, receiver) {
          var base = _superPropBase(target, property);

          var desc;

          if (base) {
            desc = Object.getOwnPropertyDescriptor(base, property);

            if (desc.set) {
              desc.set.call(receiver, value);
              return true;
            } else if (!desc.writable) {
              return false;
            }
          }

          desc = Object.getOwnPropertyDescriptor(receiver, property);

          if (desc) {
            if (!desc.writable) {
              return false;
            }

            desc.value = value;
            Object.defineProperty(receiver, property, desc);
          } else {
            _defineProperty(receiver, property, value);
          }

          return true;
        };
      }

      return set(target, property, value, receiver);
    }

    function _set(target, property, value, receiver, isStrict) {
      var s = set(target, property, value, receiver || target);

      if (!s && isStrict) {
        throw new Error('failed to set property');
      }

      return value;
    }

    function _taggedTemplateLiteral(strings, raw) {
      if (!raw) {
        raw = strings.slice(0);
      }

      return Object.freeze(Object.defineProperties(strings, {
        raw: {
          value: Object.freeze(raw)
        }
      }));
    }

    function _taggedTemplateLiteralLoose(strings, raw) {
      if (!raw) {
        raw = strings.slice(0);
      }

      strings.raw = raw;
      return strings;
    }

    function _readOnlyError(name) {
      throw new TypeError("\"" + name + "\" is read-only");
    }

    function _writeOnlyError(name) {
      throw new TypeError("\"" + name + "\" is write-only");
    }

    function _classNameTDZError(name) {
      throw new Error("Class \"" + name + "\" cannot be referenced in computed property keys.");
    }

    function _temporalUndefined() {}

    function _tdz(name) {
      throw new ReferenceError(name + " is not defined - temporal dead zone");
    }

    function _temporalRef(val, name) {
      return val === _temporalUndefined ? _tdz(name) : val;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
    }

    function _slicedToArrayLoose(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimitLoose(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
    }

    function _toArray(arr) {
      return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest();
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) return _arrayLikeToArray(arr);
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _maybeArrayLike(next, arr, i) {
      if (arr && !Array.isArray(arr) && typeof arr.length === "number") {
        var len = arr.length;
        return _arrayLikeToArray(arr, i !== void 0 && i < len ? i : len);
      }

      return next(arr, i);
    }

    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
    }

    function _iterableToArrayLimit(arr, i) {
      var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]);

      if (_i == null) return;
      var _arr = [];
      var _n = true;
      var _d = false;

      var _s, _e;

      try {
        for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);

          if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;
        _e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }

      return _arr;
    }

    function _iterableToArrayLimitLoose(arr, i) {
      var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]);

      if (_i == null) return;
      var _arr = [];

      for (_i = _i.call(arr), _step; !(_step = _i.next()).done;) {
        _arr.push(_step.value);

        if (i && _arr.length === i) break;
      }

      return _arr;
    }

    function _unsupportedIterableToArray(o, minLen) {
      if (!o) return;
      if (typeof o === "string") return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor) n = o.constructor.name;
      if (n === "Map" || n === "Set") return Array.from(o);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
    }

    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length) len = arr.length;

      for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

      return arr2;
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    function _createForOfIteratorHelper(o, allowArrayLike) {
      var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];

      if (!it) {
        if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
          if (it) o = it;
          var i = 0;

          var F = function () {};

          return {
            s: F,
            n: function () {
              if (i >= o.length) return {
                done: true
              };
              return {
                done: false,
                value: o[i++]
              };
            },
            e: function (e) {
              throw e;
            },
            f: F
          };
        }

        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
      }

      var normalCompletion = true,
          didErr = false,
          err;
      return {
        s: function () {
          it = it.call(o);
        },
        n: function () {
          var step = it.next();
          normalCompletion = step.done;
          return step;
        },
        e: function (e) {
          didErr = true;
          err = e;
        },
        f: function () {
          try {
            if (!normalCompletion && it.return != null) it.return();
          } finally {
            if (didErr) throw err;
          }
        }
      };
    }

    function _createForOfIteratorHelperLoose(o, allowArrayLike) {
      var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
      if (it) return (it = it.call(o)).next.bind(it);

      if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
        if (it) o = it;
        var i = 0;
        return function () {
          if (i >= o.length) return {
            done: true
          };
          return {
            done: false,
            value: o[i++]
          };
        };
      }

      throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    function _skipFirstGeneratorNext(fn) {
      return function () {
        var it = fn.apply(this, arguments);
        it.next();
        return it;
      };
    }

    function _toPrimitive(input, hint) {
      if (typeof input !== "object" || input === null) return input;
      var prim = input[Symbol.toPrimitive];

      if (prim !== undefined) {
        var res = prim.call(input, hint || "default");
        if (typeof res !== "object") return res;
        throw new TypeError("@@toPrimitive must return a primitive value.");
      }

      return (hint === "string" ? String : Number)(input);
    }

    function _toPropertyKey(arg) {
      var key = _toPrimitive(arg, "string");

      return typeof key === "symbol" ? key : String(key);
    }

    function _initializerWarningHelper(descriptor, context) {
      throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.');
    }

    function _initializerDefineProperty(target, property, descriptor, context) {
      if (!descriptor) return;
      Object.defineProperty(target, property, {
        enumerable: descriptor.enumerable,
        configurable: descriptor.configurable,
        writable: descriptor.writable,
        value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
      });
    }

    function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
      var desc = {};
      Object.keys(descriptor).forEach(function (key) {
        desc[key] = descriptor[key];
      });
      desc.enumerable = !!desc.enumerable;
      desc.configurable = !!desc.configurable;

      if ('value' in desc || desc.initializer) {
        desc.writable = true;
      }

      desc = decorators.slice().reverse().reduce(function (desc, decorator) {
        return decorator(target, property, desc) || desc;
      }, desc);

      if (context && desc.initializer !== void 0) {
        desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
        desc.initializer = undefined;
      }

      if (desc.initializer === void 0) {
        Object.defineProperty(target, property, desc);
        desc = null;
      }

      return desc;
    }

    var id$1 = 0;

    function _classPrivateFieldLooseKey(name) {
      return "__private_" + id$1++ + "_" + name;
    }

    function _classPrivateFieldLooseBase(receiver, privateKey) {
      if (!Object.prototype.hasOwnProperty.call(receiver, privateKey)) {
        throw new TypeError("attempted to use private field on non-instance");
      }

      return receiver;
    }

    function _classPrivateFieldGet(receiver, privateMap) {
      var descriptor = _classExtractFieldDescriptor(receiver, privateMap, "get");

      return _classApplyDescriptorGet(receiver, descriptor);
    }

    function _classPrivateFieldSet(receiver, privateMap, value) {
      var descriptor = _classExtractFieldDescriptor(receiver, privateMap, "set");

      _classApplyDescriptorSet(receiver, descriptor, value);

      return value;
    }

    function _classPrivateFieldDestructureSet(receiver, privateMap) {
      var descriptor = _classExtractFieldDescriptor(receiver, privateMap, "set");

      return _classApplyDescriptorDestructureSet(receiver, descriptor);
    }

    function _classExtractFieldDescriptor(receiver, privateMap, action) {
      if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to " + action + " private field on non-instance");
      }

      return privateMap.get(receiver);
    }

    function _classStaticPrivateFieldSpecGet(receiver, classConstructor, descriptor) {
      _classCheckPrivateStaticAccess(receiver, classConstructor);

      _classCheckPrivateStaticFieldDescriptor(descriptor, "get");

      return _classApplyDescriptorGet(receiver, descriptor);
    }

    function _classStaticPrivateFieldSpecSet(receiver, classConstructor, descriptor, value) {
      _classCheckPrivateStaticAccess(receiver, classConstructor);

      _classCheckPrivateStaticFieldDescriptor(descriptor, "set");

      _classApplyDescriptorSet(receiver, descriptor, value);

      return value;
    }

    function _classStaticPrivateMethodGet(receiver, classConstructor, method) {
      _classCheckPrivateStaticAccess(receiver, classConstructor);

      return method;
    }

    function _classStaticPrivateMethodSet() {
      throw new TypeError("attempted to set read only static private field");
    }

    function _classApplyDescriptorGet(receiver, descriptor) {
      if (descriptor.get) {
        return descriptor.get.call(receiver);
      }

      return descriptor.value;
    }

    function _classApplyDescriptorSet(receiver, descriptor, value) {
      if (descriptor.set) {
        descriptor.set.call(receiver, value);
      } else {
        if (!descriptor.writable) {
          throw new TypeError("attempted to set read only private field");
        }

        descriptor.value = value;
      }
    }

    function _classApplyDescriptorDestructureSet(receiver, descriptor) {
      if (descriptor.set) {
        if (!("__destrObj" in descriptor)) {
          descriptor.__destrObj = {
            set value(v) {
              descriptor.set.call(receiver, v);
            }

          };
        }

        return descriptor.__destrObj;
      } else {
        if (!descriptor.writable) {
          throw new TypeError("attempted to set read only private field");
        }

        return descriptor;
      }
    }

    function _classStaticPrivateFieldDestructureSet(receiver, classConstructor, descriptor) {
      _classCheckPrivateStaticAccess(receiver, classConstructor);

      _classCheckPrivateStaticFieldDescriptor(descriptor, "set");

      return _classApplyDescriptorDestructureSet(receiver, descriptor);
    }

    function _classCheckPrivateStaticAccess(receiver, classConstructor) {
      if (receiver !== classConstructor) {
        throw new TypeError("Private static access of wrong provenance");
      }
    }

    function _classCheckPrivateStaticFieldDescriptor(descriptor, action) {
      if (descriptor === undefined) {
        throw new TypeError("attempted to " + action + " private static field before its declaration");
      }
    }

    function _decorate(decorators, factory, superClass, mixins) {
      var api = _getDecoratorsApi();

      if (mixins) {
        for (var i = 0; i < mixins.length; i++) {
          api = mixins[i](api);
        }
      }

      var r = factory(function initialize(O) {
        api.initializeInstanceElements(O, decorated.elements);
      }, superClass);
      var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators);
      api.initializeClassElements(r.F, decorated.elements);
      return api.runClassFinishers(r.F, decorated.finishers);
    }

    function _getDecoratorsApi() {
      _getDecoratorsApi = function () {
        return api;
      };

      var api = {
        elementsDefinitionOrder: [["method"], ["field"]],
        initializeInstanceElements: function (O, elements) {
          ["method", "field"].forEach(function (kind) {
            elements.forEach(function (element) {
              if (element.kind === kind && element.placement === "own") {
                this.defineClassElement(O, element);
              }
            }, this);
          }, this);
        },
        initializeClassElements: function (F, elements) {
          var proto = F.prototype;
          ["method", "field"].forEach(function (kind) {
            elements.forEach(function (element) {
              var placement = element.placement;

              if (element.kind === kind && (placement === "static" || placement === "prototype")) {
                var receiver = placement === "static" ? F : proto;
                this.defineClassElement(receiver, element);
              }
            }, this);
          }, this);
        },
        defineClassElement: function (receiver, element) {
          var descriptor = element.descriptor;

          if (element.kind === "field") {
            var initializer = element.initializer;
            descriptor = {
              enumerable: descriptor.enumerable,
              writable: descriptor.writable,
              configurable: descriptor.configurable,
              value: initializer === void 0 ? void 0 : initializer.call(receiver)
            };
          }

          Object.defineProperty(receiver, element.key, descriptor);
        },
        decorateClass: function (elements, decorators) {
          var newElements = [];
          var finishers = [];
          var placements = {
            static: [],
            prototype: [],
            own: []
          };
          elements.forEach(function (element) {
            this.addElementPlacement(element, placements);
          }, this);
          elements.forEach(function (element) {
            if (!_hasDecorators(element)) return newElements.push(element);
            var elementFinishersExtras = this.decorateElement(element, placements);
            newElements.push(elementFinishersExtras.element);
            newElements.push.apply(newElements, elementFinishersExtras.extras);
            finishers.push.apply(finishers, elementFinishersExtras.finishers);
          }, this);

          if (!decorators) {
            return {
              elements: newElements,
              finishers: finishers
            };
          }

          var result = this.decorateConstructor(newElements, decorators);
          finishers.push.apply(finishers, result.finishers);
          result.finishers = finishers;
          return result;
        },
        addElementPlacement: function (element, placements, silent) {
          var keys = placements[element.placement];

          if (!silent && keys.indexOf(element.key) !== -1) {
            throw new TypeError("Duplicated element (" + element.key + ")");
          }

          keys.push(element.key);
        },
        decorateElement: function (element, placements) {
          var extras = [];
          var finishers = [];

          for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) {
            var keys = placements[element.placement];
            keys.splice(keys.indexOf(element.key), 1);
            var elementObject = this.fromElementDescriptor(element);
            var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject);
            element = elementFinisherExtras.element;
            this.addElementPlacement(element, placements);

            if (elementFinisherExtras.finisher) {
              finishers.push(elementFinisherExtras.finisher);
            }

            var newExtras = elementFinisherExtras.extras;

            if (newExtras) {
              for (var j = 0; j < newExtras.length; j++) {
                this.addElementPlacement(newExtras[j], placements);
              }

              extras.push.apply(extras, newExtras);
            }
          }

          return {
            element: element,
            finishers: finishers,
            extras: extras
          };
        },
        decorateConstructor: function (elements, decorators) {
          var finishers = [];

          for (var i = decorators.length - 1; i >= 0; i--) {
            var obj = this.fromClassDescriptor(elements);
            var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj);

            if (elementsAndFinisher.finisher !== undefined) {
              finishers.push(elementsAndFinisher.finisher);
            }

            if (elementsAndFinisher.elements !== undefined) {
              elements = elementsAndFinisher.elements;

              for (var j = 0; j < elements.length - 1; j++) {
                for (var k = j + 1; k < elements.length; k++) {
                  if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) {
                    throw new TypeError("Duplicated element (" + elements[j].key + ")");
                  }
                }
              }
            }
          }

          return {
            elements: elements,
            finishers: finishers
          };
        },
        fromElementDescriptor: function (element) {
          var obj = {
            kind: element.kind,
            key: element.key,
            placement: element.placement,
            descriptor: element.descriptor
          };
          var desc = {
            value: "Descriptor",
            configurable: true
          };
          Object.defineProperty(obj, Symbol.toStringTag, desc);
          if (element.kind === "field") obj.initializer = element.initializer;
          return obj;
        },
        toElementDescriptors: function (elementObjects) {
          if (elementObjects === undefined) return;
          return _toArray(elementObjects).map(function (elementObject) {
            var element = this.toElementDescriptor(elementObject);
            this.disallowProperty(elementObject, "finisher", "An element descriptor");
            this.disallowProperty(elementObject, "extras", "An element descriptor");
            return element;
          }, this);
        },
        toElementDescriptor: function (elementObject) {
          var kind = String(elementObject.kind);

          if (kind !== "method" && kind !== "field") {
            throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"');
          }

          var key = _toPropertyKey(elementObject.key);

          var placement = String(elementObject.placement);

          if (placement !== "static" && placement !== "prototype" && placement !== "own") {
            throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"');
          }

          var descriptor = elementObject.descriptor;
          this.disallowProperty(elementObject, "elements", "An element descriptor");
          var element = {
            kind: kind,
            key: key,
            placement: placement,
            descriptor: Object.assign({}, descriptor)
          };

          if (kind !== "field") {
            this.disallowProperty(elementObject, "initializer", "A method descriptor");
          } else {
            this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor");
            this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor");
            this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor");
            element.initializer = elementObject.initializer;
          }

          return element;
        },
        toElementFinisherExtras: function (elementObject) {
          var element = this.toElementDescriptor(elementObject);

          var finisher = _optionalCallableProperty(elementObject, "finisher");

          var extras = this.toElementDescriptors(elementObject.extras);
          return {
            element: element,
            finisher: finisher,
            extras: extras
          };
        },
        fromClassDescriptor: function (elements) {
          var obj = {
            kind: "class",
            elements: elements.map(this.fromElementDescriptor, this)
          };
          var desc = {
            value: "Descriptor",
            configurable: true
          };
          Object.defineProperty(obj, Symbol.toStringTag, desc);
          return obj;
        },
        toClassDescriptor: function (obj) {
          var kind = String(obj.kind);

          if (kind !== "class") {
            throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"');
          }

          this.disallowProperty(obj, "key", "A class descriptor");
          this.disallowProperty(obj, "placement", "A class descriptor");
          this.disallowProperty(obj, "descriptor", "A class descriptor");
          this.disallowProperty(obj, "initializer", "A class descriptor");
          this.disallowProperty(obj, "extras", "A class descriptor");

          var finisher = _optionalCallableProperty(obj, "finisher");

          var elements = this.toElementDescriptors(obj.elements);
          return {
            elements: elements,
            finisher: finisher
          };
        },
        runClassFinishers: function (constructor, finishers) {
          for (var i = 0; i < finishers.length; i++) {
            var newConstructor = (0, finishers[i])(constructor);

            if (newConstructor !== undefined) {
              if (typeof newConstructor !== "function") {
                throw new TypeError("Finishers must return a constructor.");
              }

              constructor = newConstructor;
            }
          }

          return constructor;
        },
        disallowProperty: function (obj, name, objectType) {
          if (obj[name] !== undefined) {
            throw new TypeError(objectType + " can't have a ." + name + " property.");
          }
        }
      };
      return api;
    }

    function _createElementDescriptor(def) {
      var key = _toPropertyKey(def.key);

      var descriptor;

      if (def.kind === "method") {
        descriptor = {
          value: def.value,
          writable: true,
          configurable: true,
          enumerable: false
        };
      } else if (def.kind === "get") {
        descriptor = {
          get: def.value,
          configurable: true,
          enumerable: false
        };
      } else if (def.kind === "set") {
        descriptor = {
          set: def.value,
          configurable: true,
          enumerable: false
        };
      } else if (def.kind === "field") {
        descriptor = {
          configurable: true,
          writable: true,
          enumerable: true
        };
      }

      var element = {
        kind: def.kind === "field" ? "field" : "method",
        key: key,
        placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype",
        descriptor: descriptor
      };
      if (def.decorators) element.decorators = def.decorators;
      if (def.kind === "field") element.initializer = def.value;
      return element;
    }

    function _coalesceGetterSetter(element, other) {
      if (element.descriptor.get !== undefined) {
        other.descriptor.get = element.descriptor.get;
      } else {
        other.descriptor.set = element.descriptor.set;
      }
    }

    function _coalesceClassElements(elements) {
      var newElements = [];

      var isSameElement = function (other) {
        return other.kind === "method" && other.key === element.key && other.placement === element.placement;
      };

      for (var i = 0; i < elements.length; i++) {
        var element = elements[i];
        var other;

        if (element.kind === "method" && (other = newElements.find(isSameElement))) {
          if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) {
            if (_hasDecorators(element) || _hasDecorators(other)) {
              throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated.");
            }

            other.descriptor = element.descriptor;
          } else {
            if (_hasDecorators(element)) {
              if (_hasDecorators(other)) {
                throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ").");
              }

              other.decorators = element.decorators;
            }

            _coalesceGetterSetter(element, other);
          }
        } else {
          newElements.push(element);
        }
      }

      return newElements;
    }

    function _hasDecorators(element) {
      return element.decorators && element.decorators.length;
    }

    function _isDataDescriptor(desc) {
      return desc !== undefined && !(desc.value === undefined && desc.writable === undefined);
    }

    function _optionalCallableProperty(obj, name) {
      var value = obj[name];

      if (value !== undefined && typeof value !== "function") {
        throw new TypeError("Expected '" + name + "' to be a function");
      }

      return value;
    }

    function _classPrivateMethodGet(receiver, privateSet, fn) {
      if (!privateSet.has(receiver)) {
        throw new TypeError("attempted to get private field on non-instance");
      }

      return fn;
    }

    function _classPrivateMethodSet() {
      throw new TypeError("attempted to reassign private method");
    }

    var uniqueNum = 0;
    function uniqueNumber() {
      uniqueNum += 1;
      return uniqueNum;
    }
    function id(mask, map) {
      if (mask === void 0) {
        mask = 'xxxxxxxxxx';
      }

      if (map === void 0) {
        map = '0123456789abcdef';
      }

      var length = map.length;
      return mask.replace(/x/g, function () {
        return map[Math.floor(Math.random() * length)];
      });
    }
    var mdPreloaderContent = "\n  <span class=\"preloader-inner\">\n    <svg viewBox=\"0 0 36 36\">\n      <circle cx=\"18\" cy=\"18\" r=\"16\"></circle>\n    </svg>\n  </span>\n".trim();
    var iosPreloaderContent = ("\n  <span class=\"preloader-inner\">\n    " + [0, 1, 2, 3, 4, 5, 6, 7].map(function () {
      return '<span class="preloader-inner-line"></span>';
    }).join('') + "\n  </span>\n").trim();
    var auroraPreloaderContent = "\n  <span class=\"preloader-inner\">\n    <span class=\"preloader-inner-circle\"></span>\n  </span>\n";
    function eventNameToColonCase(eventName) {
      var hasColon;
      return eventName.split('').map(function (char, index) {
        if (char.match(/[A-Z]/) && index !== 0 && !hasColon) {
          hasColon = true;
          return ":" + char.toLowerCase();
        }

        return char.toLowerCase();
      }).join('');
    }
    function deleteProps$1(obj) {
      var object = obj;
      Object.keys(object).forEach(function (key) {
        try {
          object[key] = null;
        } catch (e) {// no setter for object
        }

        try {
          delete object[key];
        } catch (e) {// something got wrong
        }
      });
    }
    function requestAnimationFrame(callback) {
      var window = getWindow();
      return window.requestAnimationFrame(callback);
    }
    function cancelAnimationFrame$1(frameId) {
      var window = getWindow();
      return window.cancelAnimationFrame(frameId);
    }
    function nextTick$1(callback, delay) {
      if (delay === void 0) {
        delay = 0;
      }

      return setTimeout(callback, delay);
    }
    function nextFrame$1(callback) {
      return requestAnimationFrame(function () {
        requestAnimationFrame(callback);
      });
    }
    function now$1() {
      return Date.now();
    }
    function parseUrlQuery(url) {
      var window = getWindow();
      var query = {};
      var urlToParse = url || window.location.href;
      var i;
      var params;
      var param;
      var length;

      if (typeof urlToParse === 'string' && urlToParse.length) {
        urlToParse = urlToParse.indexOf('?') > -1 ? urlToParse.replace(/\S*\?/, '') : '';
        params = urlToParse.split('&').filter(function (paramsPart) {
          return paramsPart !== '';
        });
        length = params.length;

        for (i = 0; i < length; i += 1) {
          param = params[i].replace(/#\S+/g, '').split('=');
          query[decodeURIComponent(param[0])] = typeof param[1] === 'undefined' ? undefined : decodeURIComponent(param.slice(1).join('=')) || '';
        }
      }

      return query;
    }
    function getTranslate$1(el, axis) {
      if (axis === void 0) {
        axis = 'x';
      }

      var window = getWindow();
      var matrix;
      var curTransform;
      var transformMatrix;
      var curStyle = window.getComputedStyle(el, null);

      if (window.WebKitCSSMatrix) {
        curTransform = curStyle.transform || curStyle.webkitTransform;

        if (curTransform.split(',').length > 6) {
          curTransform = curTransform.split(', ').map(function (a) {
            return a.replace(',', '.');
          }).join(', ');
        } // Some old versions of Webkit choke when 'none' is passed; pass
        // empty string instead in this case


        transformMatrix = new window.WebKitCSSMatrix(curTransform === 'none' ? '' : curTransform);
      } else {
        transformMatrix = curStyle.MozTransform || curStyle.OTransform || curStyle.MsTransform || curStyle.msTransform || curStyle.transform || curStyle.getPropertyValue('transform').replace('translate(', 'matrix(1, 0, 0, 1,');
        matrix = transformMatrix.toString().split(',');
      }

      if (axis === 'x') {
        // Latest Chrome and webkits Fix
        if (window.WebKitCSSMatrix) curTransform = transformMatrix.m41; // Crazy IE10 Matrix
        else if (matrix.length === 16) curTransform = parseFloat(matrix[12]); // Normal Browsers
          else curTransform = parseFloat(matrix[4]);
      }

      if (axis === 'y') {
        // Latest Chrome and webkits Fix
        if (window.WebKitCSSMatrix) curTransform = transformMatrix.m42; // Crazy IE10 Matrix
        else if (matrix.length === 16) curTransform = parseFloat(matrix[13]); // Normal Browsers
          else curTransform = parseFloat(matrix[5]);
      }

      return curTransform || 0;
    }
    function serializeObject(obj, parents) {
      if (parents === void 0) {
        parents = [];
      }

      if (typeof obj === 'string') return obj;
      var resultArray = [];
      var separator = '&';
      var newParents;

      function varName(name) {
        if (parents.length > 0) {
          var parentParts = '';

          for (var j = 0; j < parents.length; j += 1) {
            if (j === 0) parentParts += parents[j];else parentParts += "[" + encodeURIComponent(parents[j]) + "]";
          }

          return parentParts + "[" + encodeURIComponent(name) + "]";
        }

        return encodeURIComponent(name);
      }

      function varValue(value) {
        return encodeURIComponent(value);
      }

      Object.keys(obj).forEach(function (prop) {
        var toPush;

        if (Array.isArray(obj[prop])) {
          toPush = [];

          for (var i = 0; i < obj[prop].length; i += 1) {
            if (!Array.isArray(obj[prop][i]) && typeof obj[prop][i] === 'object') {
              newParents = parents.slice();
              newParents.push(prop);
              newParents.push(String(i));
              toPush.push(serializeObject(obj[prop][i], newParents));
            } else {
              toPush.push(varName(prop) + "[]=" + varValue(obj[prop][i]));
            }
          }

          if (toPush.length > 0) resultArray.push(toPush.join(separator));
        } else if (obj[prop] === null || obj[prop] === '') {
          resultArray.push(varName(prop) + "=");
        } else if (typeof obj[prop] === 'object') {
          // Object, convert to named array
          newParents = parents.slice();
          newParents.push(prop);
          toPush = serializeObject(obj[prop], newParents);
          if (toPush !== '') resultArray.push(toPush);
        } else if (typeof obj[prop] !== 'undefined' && obj[prop] !== '') {
          // Should be string or plain value
          resultArray.push(varName(prop) + "=" + varValue(obj[prop]));
        } else if (obj[prop] === '') resultArray.push(varName(prop));
      });
      return resultArray.join(separator);
    }
    function isObject$1(o) {
      return typeof o === 'object' && o !== null && o.constructor && o.constructor === Object;
    }
    function merge() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var to = args[0];
      args.splice(0, 1);
      var from = args;

      for (var i = 0; i < from.length; i += 1) {
        var nextSource = args[i];

        if (nextSource !== undefined && nextSource !== null) {
          var keysArray = Object.keys(Object(nextSource));

          for (var nextIndex = 0, len = keysArray.length; nextIndex < len; nextIndex += 1) {
            var nextKey = keysArray[nextIndex];
            var desc = Object.getOwnPropertyDescriptor(nextSource, nextKey);

            if (desc !== undefined && desc.enumerable) {
              to[nextKey] = nextSource[nextKey];
            }
          }
        }
      }

      return to;
    }
    function extend$1() {
      var deep = true;
      var to;
      var from;

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      if (typeof args[0] === 'boolean') {
        deep = args[0];
        to = args[1];
        args.splice(0, 2);
        from = args;
      } else {
        to = args[0];
        args.splice(0, 1);
        from = args;
      }

      for (var i = 0; i < from.length; i += 1) {
        var nextSource = args[i];

        if (nextSource !== undefined && nextSource !== null) {
          var keysArray = Object.keys(Object(nextSource));

          for (var nextIndex = 0, len = keysArray.length; nextIndex < len; nextIndex += 1) {
            var nextKey = keysArray[nextIndex];
            var desc = Object.getOwnPropertyDescriptor(nextSource, nextKey);

            if (desc !== undefined && desc.enumerable) {
              if (!deep) {
                to[nextKey] = nextSource[nextKey];
              } else if (isObject$1(to[nextKey]) && isObject$1(nextSource[nextKey])) {
                extend$1(to[nextKey], nextSource[nextKey]);
              } else if (!isObject$1(to[nextKey]) && isObject$1(nextSource[nextKey])) {
                to[nextKey] = {};
                extend$1(to[nextKey], nextSource[nextKey]);
              } else {
                to[nextKey] = nextSource[nextKey];
              }
            }
          }
        }
      }

      return to;
    }
    function colorHexToRgb(hex) {
      var h = hex.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i, function (m, r, g, b) {
        return r + r + g + g + b + b;
      });
      var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(h);
      return result ? result.slice(1).map(function (n) {
        return parseInt(n, 16);
      }) : null;
    }
    function colorRgbToHex(r, g, b) {
      var result = [r, g, b].map(function (n) {
        var hex = n.toString(16);
        return hex.length === 1 ? "0" + hex : hex;
      }).join('');
      return "#" + result;
    }
    function colorRgbToHsl(r, g, b) {
      r /= 255; // eslint-disable-line

      g /= 255; // eslint-disable-line

      b /= 255; // eslint-disable-line

      var max = Math.max(r, g, b);
      var min = Math.min(r, g, b);
      var d = max - min;
      var h;
      if (d === 0) h = 0;else if (max === r) h = (g - b) / d % 6;else if (max === g) h = (b - r) / d + 2;else if (max === b) h = (r - g) / d + 4;
      var l = (min + max) / 2;
      var s = d === 0 ? 0 : d / (1 - Math.abs(2 * l - 1));
      if (h < 0) h = 360 / 60 + h;
      return [h * 60, s, l];
    }
    function colorHslToRgb(h, s, l) {
      var c = (1 - Math.abs(2 * l - 1)) * s;
      var hp = h / 60;
      var x = c * (1 - Math.abs(hp % 2 - 1));
      var rgb1;

      if (Number.isNaN(h) || typeof h === 'undefined') {
        rgb1 = [0, 0, 0];
      } else if (hp <= 1) rgb1 = [c, x, 0];else if (hp <= 2) rgb1 = [x, c, 0];else if (hp <= 3) rgb1 = [0, c, x];else if (hp <= 4) rgb1 = [0, x, c];else if (hp <= 5) rgb1 = [x, 0, c];else if (hp <= 6) rgb1 = [c, 0, x];

      var m = l - c / 2;
      return rgb1.map(function (n) {
        return Math.max(0, Math.min(255, Math.round(255 * (n + m))));
      });
    }
    function colorHsbToHsl(h, s, b) {
      var HSL = {
        h: h,
        s: 0,
        l: 0
      };
      var HSB = {
        h: h,
        s: s,
        b: b
      };
      HSL.l = (2 - HSB.s) * HSB.b / 2;
      HSL.s = HSL.l && HSL.l < 1 ? HSB.s * HSB.b / (HSL.l < 0.5 ? HSL.l * 2 : 2 - HSL.l * 2) : HSL.s;
      return [HSL.h, HSL.s, HSL.l];
    }
    function colorHslToHsb(h, s, l) {
      var HSB = {
        h: h,
        s: 0,
        b: 0
      };
      var HSL = {
        h: h,
        s: s,
        l: l
      };
      var t = HSL.s * (HSL.l < 0.5 ? HSL.l : 1 - HSL.l);
      HSB.b = HSL.l + t;
      HSB.s = HSL.l > 0 ? 2 * t / HSB.b : HSB.s;
      return [HSB.h, HSB.s, HSB.b];
    }
    function colorThemeCSSProperties() {
      var hex;
      var rgb;

      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      if (args.length === 1) {
        hex = args[0];
        rgb = colorHexToRgb(hex);
      } else if (args.length === 3) {
        rgb = args;
        hex = colorRgbToHex.apply(void 0, rgb);
      }

      if (!rgb) return {};
      var hsl = colorRgbToHsl.apply(void 0, rgb);
      var hslShade = [hsl[0], hsl[1], Math.max(0, hsl[2] - 0.08)];
      var hslTint = [hsl[0], hsl[1], Math.max(0, hsl[2] + 0.08)];
      var shade = colorRgbToHex.apply(void 0, colorHslToRgb.apply(void 0, hslShade));
      var tint = colorRgbToHex.apply(void 0, colorHslToRgb.apply(void 0, hslTint));
      return {
        '--f7-theme-color': hex,
        '--f7-theme-color-rgb': rgb.join(', '),
        '--f7-theme-color-shade': shade,
        '--f7-theme-color-tint': tint
      };
    }
    function bindMethods(instance, obj) {
      Object.keys(obj).forEach(function (key) {
        if (isObject$1(obj[key])) {
          Object.keys(obj[key]).forEach(function (subKey) {
            if (typeof obj[key][subKey] === 'function') {
              obj[key][subKey] = obj[key][subKey].bind(instance);
            }
          });
        }

        instance[key] = obj[key];
      });
    }
    function flattenArray() {
      var arr = [];

      for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        args[_key4] = arguments[_key4];
      }

      args.forEach(function (arg) {
        if (Array.isArray(arg)) arr.push.apply(arr, flattenArray.apply(void 0, arg));else arr.push(arg);
      });
      return arr;
    }

    var utils = /*#__PURE__*/Object.freeze({
        __proto__: null,
        uniqueNumber: uniqueNumber,
        id: id,
        mdPreloaderContent: mdPreloaderContent,
        iosPreloaderContent: iosPreloaderContent,
        auroraPreloaderContent: auroraPreloaderContent,
        eventNameToColonCase: eventNameToColonCase,
        deleteProps: deleteProps$1,
        requestAnimationFrame: requestAnimationFrame,
        cancelAnimationFrame: cancelAnimationFrame$1,
        nextTick: nextTick$1,
        nextFrame: nextFrame$1,
        now: now$1,
        parseUrlQuery: parseUrlQuery,
        getTranslate: getTranslate$1,
        serializeObject: serializeObject,
        isObject: isObject$1,
        merge: merge,
        extend: extend$1,
        colorHexToRgb: colorHexToRgb,
        colorRgbToHex: colorRgbToHex,
        colorRgbToHsl: colorRgbToHsl,
        colorHslToRgb: colorHslToRgb,
        colorHsbToHsl: colorHsbToHsl,
        colorHslToHsb: colorHslToHsb,
        colorThemeCSSProperties: colorThemeCSSProperties,
        bindMethods: bindMethods,
        flattenArray: flattenArray
    });

    var support$1;

    function calcSupport$1() {
      var window = getWindow();
      var document = getDocument();
      return {
        touch: !!('ontouchstart' in window || window.DocumentTouch && document instanceof window.DocumentTouch),
        pointerEvents: !!window.PointerEvent && 'maxTouchPoints' in window.navigator && window.navigator.maxTouchPoints >= 0,
        passiveListener: function checkPassiveListener() {
          var supportsPassive = false;

          try {
            var opts = Object.defineProperty({}, 'passive', {
              // eslint-disable-next-line
              get: function get() {
                supportsPassive = true;
              }
            });
            window.addEventListener('testPassiveListener', null, opts);
          } catch (e) {// No support
          }

          return supportsPassive;
        }(),
        intersectionObserver: function checkObserver() {
          return 'IntersectionObserver' in window;
        }()
      };
    }

    function getSupport$1() {
      if (!support$1) {
        support$1 = calcSupport$1();
      }

      return support$1;
    }

    var deviceCalculated;

    function calcDevice$1(_temp) {
      var _ref = _temp === void 0 ? {} : _temp,
          userAgent = _ref.userAgent;

      var support = getSupport$1();
      var window = getWindow();
      var platform = window.navigator.platform;
      var ua = userAgent || window.navigator.userAgent;
      var device = {
        ios: false,
        android: false,
        androidChrome: false,
        desktop: false,
        iphone: false,
        ipod: false,
        ipad: false,
        edge: false,
        ie: false,
        firefox: false,
        macos: false,
        windows: false,
        cordova: !!(window.cordova || window.phonegap),
        phonegap: !!(window.cordova || window.phonegap),
        electron: false,
        capacitor: !!window.Capacitor,
        nwjs: false
      };
      var screenWidth = window.screen.width;
      var screenHeight = window.screen.height;
      var android = ua.match(/(Android);?[\s\/]+([\d.]+)?/); // eslint-disable-line

      var ipad = ua.match(/(iPad).*OS\s([\d_]+)/);
      var ipod = ua.match(/(iPod)(.*OS\s([\d_]+))?/);
      var iphone = !ipad && ua.match(/(iPhone\sOS|iOS|iPhone;\sCPU\sOS)\s([\d_]+)/);
      var ie = ua.indexOf('MSIE ') >= 0 || ua.indexOf('Trident/') >= 0;
      var edge = ua.indexOf('Edge/') >= 0;
      var firefox = ua.indexOf('Gecko/') >= 0 && ua.indexOf('Firefox/') >= 0;
      var windows = platform === 'Win32';
      var electron = ua.toLowerCase().indexOf('electron') >= 0;
      var nwjs = typeof nw !== 'undefined' && typeof process !== 'undefined' && typeof process.versions !== 'undefined' && typeof process.versions.nw !== 'undefined';
      var macos = platform === 'MacIntel'; // iPadOs 13 fix

      var iPadScreens = ['1024x1366', '1366x1024', '834x1194', '1194x834', '834x1112', '1112x834', '768x1024', '1024x768', '820x1180', '1180x820', '810x1080', '1080x810'];

      if (!ipad && macos && support.touch && iPadScreens.indexOf(screenWidth + "x" + screenHeight) >= 0) {
        ipad = ua.match(/(Version)\/([\d.]+)/);
        if (!ipad) ipad = [0, 1, '13_0_0'];
        macos = false;
      }

      device.ie = ie;
      device.edge = edge;
      device.firefox = firefox; // Android

      if (android) {
        device.os = 'android';
        device.osVersion = android[2];
        device.android = true;
        device.androidChrome = ua.toLowerCase().indexOf('chrome') >= 0;
      }

      if (ipad || iphone || ipod) {
        device.os = 'ios';
        device.ios = true;
      } // iOS


      if (iphone && !ipod) {
        device.osVersion = iphone[2].replace(/_/g, '.');
        device.iphone = true;
      }

      if (ipad) {
        device.osVersion = ipad[2].replace(/_/g, '.');
        device.ipad = true;
      }

      if (ipod) {
        device.osVersion = ipod[3] ? ipod[3].replace(/_/g, '.') : null;
        device.ipod = true;
      } // iOS 8+ changed UA


      if (device.ios && device.osVersion && ua.indexOf('Version/') >= 0) {
        if (device.osVersion.split('.')[0] === '10') {
          device.osVersion = ua.toLowerCase().split('version/')[1].split(' ')[0];
        }
      } // Webview


      device.webView = !!((iphone || ipad || ipod) && (ua.match(/.*AppleWebKit(?!.*Safari)/i) || window.navigator.standalone)) || window.matchMedia && window.matchMedia('(display-mode: standalone)').matches;
      device.webview = device.webView;
      device.standalone = device.webView; // Desktop

      device.desktop = !(device.ios || device.android) || electron || nwjs;

      if (device.desktop) {
        device.electron = electron;
        device.nwjs = nwjs;
        device.macos = macos;
        device.windows = windows;

        if (device.macos) {
          device.os = 'macos';
        }

        if (device.windows) {
          device.os = 'windows';
        }
      } // Pixel Ratio


      device.pixelRatio = window.devicePixelRatio || 1; // Color Scheme

      var DARK = '(prefers-color-scheme: dark)';
      var LIGHT = '(prefers-color-scheme: light)';

      device.prefersColorScheme = function prefersColorTheme() {
        var theme;

        if (window.matchMedia && window.matchMedia(LIGHT).matches) {
          theme = 'light';
        }

        if (window.matchMedia && window.matchMedia(DARK).matches) {
          theme = 'dark';
        }

        return theme;
      }; // Export object


      return device;
    }

    function getDevice$1(overrides, reset) {
      if (overrides === void 0) {
        overrides = {};
      }

      if (!deviceCalculated || reset) {
        deviceCalculated = calcDevice$1(overrides);
      }

      return deviceCalculated;
    }

    var EventsClass = /*#__PURE__*/function () {
      function EventsClass(parents) {
        if (parents === void 0) {
          parents = [];
        }

        var self = this;
        self.eventsParents = parents;
        self.eventsListeners = {};
      }

      var _proto = EventsClass.prototype;

      _proto.on = function on(events, handler, priority) {
        var self = this;
        if (typeof handler !== 'function') return self;
        var method = priority ? 'unshift' : 'push';
        events.split(' ').forEach(function (event) {
          if (!self.eventsListeners[event]) self.eventsListeners[event] = [];
          self.eventsListeners[event][method](handler);
        });
        return self;
      };

      _proto.once = function once(events, handler, priority) {
        var self = this;
        if (typeof handler !== 'function') return self;

        function onceHandler() {
          self.off(events, onceHandler);

          if (onceHandler.f7proxy) {
            delete onceHandler.f7proxy;
          }

          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          handler.apply(self, args);
        }

        onceHandler.f7proxy = handler;
        return self.on(events, onceHandler, priority);
      };

      _proto.off = function off(events, handler) {
        var self = this;
        if (!self.eventsListeners) return self;
        events.split(' ').forEach(function (event) {
          if (typeof handler === 'undefined') {
            self.eventsListeners[event] = [];
          } else if (self.eventsListeners[event]) {
            self.eventsListeners[event].forEach(function (eventHandler, index) {
              if (eventHandler === handler || eventHandler.f7proxy && eventHandler.f7proxy === handler) {
                self.eventsListeners[event].splice(index, 1);
              }
            });
          }
        });
        return self;
      };

      _proto.emit = function emit() {
        var self = this;
        if (!self.eventsListeners) return self;
        var events;
        var data;
        var context;
        var eventsParents;

        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        if (typeof args[0] === 'string' || Array.isArray(args[0])) {
          events = args[0];
          data = args.slice(1, args.length);
          context = self;
          eventsParents = self.eventsParents;
        } else {
          events = args[0].events;
          data = args[0].data;
          context = args[0].context || self;
          eventsParents = args[0].local ? [] : args[0].parents || self.eventsParents;
        }

        var eventsArray = Array.isArray(events) ? events : events.split(' ');
        var localEvents = eventsArray.map(function (eventName) {
          return eventName.replace('local::', '');
        });
        var parentEvents = eventsArray.filter(function (eventName) {
          return eventName.indexOf('local::') < 0;
        });
        localEvents.forEach(function (event) {
          if (self.eventsListeners && self.eventsListeners[event]) {
            var handlers = [];
            self.eventsListeners[event].forEach(function (eventHandler) {
              handlers.push(eventHandler);
            });
            handlers.forEach(function (eventHandler) {
              eventHandler.apply(context, data);
            });
          }
        });

        if (eventsParents && eventsParents.length > 0) {
          eventsParents.forEach(function (eventsParent) {
            eventsParent.emit.apply(eventsParent, [parentEvents].concat(data));
          });
        }

        return self;
      };

      return EventsClass;
    }();

    var Framework7Class = /*#__PURE__*/function (_EventsClass) {
      _inheritsLoose(Framework7Class, _EventsClass);

      function Framework7Class(params, parents) {
        var _this;

        if (params === void 0) {
          params = {};
        }

        if (parents === void 0) {
          parents = [];
        }

        _this = _EventsClass.call(this, parents) || this;

        var self = _assertThisInitialized(_this);

        self.params = params;

        if (self.params && self.params.on) {
          Object.keys(self.params.on).forEach(function (eventName) {
            self.on(eventName, self.params.on[eventName]);
          });
        }

        return _this;
      } // eslint-disable-next-line


      var _proto = Framework7Class.prototype;

      _proto.useModuleParams = function useModuleParams(module, instanceParams) {
        if (module.params) {
          var originalParams = {};
          Object.keys(module.params).forEach(function (paramKey) {
            if (typeof instanceParams[paramKey] === 'undefined') return;
            originalParams[paramKey] = extend$1({}, instanceParams[paramKey]);
          });
          extend$1(instanceParams, module.params);
          Object.keys(originalParams).forEach(function (paramKey) {
            extend$1(instanceParams[paramKey], originalParams[paramKey]);
          });
        }
      };

      _proto.useModulesParams = function useModulesParams(instanceParams) {
        var instance = this;
        if (!instance.modules) return;
        Object.keys(instance.modules).forEach(function (moduleName) {
          var module = instance.modules[moduleName]; // Extend params

          if (module.params) {
            extend$1(instanceParams, module.params);
          }
        });
      };

      _proto.useModule = function useModule(moduleName, moduleParams) {
        if (moduleName === void 0) {
          moduleName = '';
        }

        if (moduleParams === void 0) {
          moduleParams = {};
        }

        var instance = this;
        if (!instance.modules) return;
        var module = typeof moduleName === 'string' ? instance.modules[moduleName] : moduleName;
        if (!module) return; // Extend instance methods and props

        if (module.instance) {
          Object.keys(module.instance).forEach(function (modulePropName) {
            var moduleProp = module.instance[modulePropName];

            if (typeof moduleProp === 'function') {
              instance[modulePropName] = moduleProp.bind(instance);
            } else {
              instance[modulePropName] = moduleProp;
            }
          });
        } // Add event listeners


        if (module.on && instance.on) {
          Object.keys(module.on).forEach(function (moduleEventName) {
            instance.on(moduleEventName, module.on[moduleEventName]);
          });
        } // Add vnode hooks


        if (module.vnode) {
          if (!instance.vnodeHooks) instance.vnodeHooks = {};
          Object.keys(module.vnode).forEach(function (vnodeId) {
            Object.keys(module.vnode[vnodeId]).forEach(function (hookName) {
              var handler = module.vnode[vnodeId][hookName];
              if (!instance.vnodeHooks[hookName]) instance.vnodeHooks[hookName] = {};
              if (!instance.vnodeHooks[hookName][vnodeId]) instance.vnodeHooks[hookName][vnodeId] = [];
              instance.vnodeHooks[hookName][vnodeId].push(handler.bind(instance));
            });
          });
        } // Module create callback


        if (module.create) {
          module.create.bind(instance)(moduleParams);
        }
      };

      _proto.useModules = function useModules(modulesParams) {
        if (modulesParams === void 0) {
          modulesParams = {};
        }

        var instance = this;
        if (!instance.modules) return;
        Object.keys(instance.modules).forEach(function (moduleName) {
          var moduleParams = modulesParams[moduleName] || {};
          instance.useModule(moduleName, moduleParams);
        });
      };

      Framework7Class.installModule = function installModule(module) {
        var Class = this;
        if (!Class.prototype.modules) Class.prototype.modules = {};
        var name = module.name || Object.keys(Class.prototype.modules).length + "_" + now$1();
        Class.prototype.modules[name] = module; // Prototype

        if (module.proto) {
          Object.keys(module.proto).forEach(function (key) {
            Class.prototype[key] = module.proto[key];
          });
        } // Class


        if (module.static) {
          Object.keys(module.static).forEach(function (key) {
            Class[key] = module.static[key];
          });
        } // Callback


        if (module.install) {
          for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            params[_key - 1] = arguments[_key];
          }

          module.install.apply(Class, params);
        }

        return Class;
      };

      Framework7Class.use = function use(module) {
        var Class = this;

        if (Array.isArray(module)) {
          module.forEach(function (m) {
            return Class.installModule(m);
          });
          return Class;
        }

        for (var _len2 = arguments.length, params = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          params[_key2 - 1] = arguments[_key2];
        }

        return Class.installModule.apply(Class, [module].concat(params));
      };

      _createClass$1(Framework7Class, null, [{
        key: "components",
        set: function set(components) {
          var Class = this;
          if (!Class.use) return;
          Class.use(components);
        }
      }]);

      return Framework7Class;
    }(EventsClass);

    function ConstructorMethods(parameters) {
      if (parameters === void 0) {
        parameters = {};
      }

      var _parameters = parameters,
          defaultSelector = _parameters.defaultSelector,
          Constructor = _parameters.constructor,
          domProp = _parameters.domProp,
          app = _parameters.app,
          addMethods = _parameters.addMethods;
      var methods = {
        create: function create() {
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          if (app) return _construct(Constructor, [app].concat(args));
          return _construct(Constructor, args);
        },
        get: function get(el) {
          if (el === void 0) {
            el = defaultSelector;
          }

          if (el instanceof Constructor) return el;
          var $el = $(el);
          if ($el.length === 0) return undefined;
          return $el[0][domProp];
        },
        destroy: function destroy(el) {
          var instance = methods.get(el);
          if (instance && instance.destroy) return instance.destroy();
          return undefined;
        }
      };

      if (addMethods && Array.isArray(addMethods)) {
        addMethods.forEach(function (methodName) {
          methods[methodName] = function (el) {
            if (el === void 0) {
              el = defaultSelector;
            }

            var instance = methods.get(el);

            for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
              args[_key2 - 1] = arguments[_key2];
            }

            if (instance && instance[methodName]) return instance[methodName].apply(instance, args);
            return undefined;
          };
        });
      }

      return methods;
    }

    function ModalMethods(parameters) {
      if (parameters === void 0) {
        parameters = {};
      }

      var _parameters = parameters,
          defaultSelector = _parameters.defaultSelector,
          Constructor = _parameters.constructor,
          app = _parameters.app;
      var methods = extend$1(ConstructorMethods({
        defaultSelector: defaultSelector,
        constructor: Constructor,
        app: app,
        domProp: 'f7Modal'
      }), {
        open: function open(el, animate, targetEl) {
          var $el = $(el);

          if ($el.length > 1 && targetEl) {
            // check if same modal in other page
            var $targetPage = $(targetEl).parents('.page');

            if ($targetPage.length) {
              $el.each(function (modalEl) {
                var $modalEl = $(modalEl);

                if ($modalEl.parents($targetPage)[0] === $targetPage[0]) {
                  $el = $modalEl;
                }
              });
            }
          }

          if ($el.length > 1) {
            $el = $el.eq($el.length - 1);
          }

          if (!$el.length) return undefined;
          var instance = $el[0].f7Modal;

          if (!instance) {
            var params = $el.dataset();
            instance = new Constructor(app, _extends$j({
              el: $el
            }, params));
          }

          return instance.open(animate);
        },
        close: function close(el, animate, targetEl) {
          if (el === void 0) {
            el = defaultSelector;
          }

          var $el = $(el);
          if (!$el.length) return undefined;

          if ($el.length > 1) {
            // check if close link (targetEl) in this modal
            var $parentEl;

            if (targetEl) {
              var $targetEl = $(targetEl);

              if ($targetEl.length) {
                $parentEl = $targetEl.parents($el);
              }
            }

            if ($parentEl && $parentEl.length > 0) {
              $el = $parentEl;
            } else {
              $el = $el.eq($el.length - 1);
            }
          }

          var instance = $el[0].f7Modal;

          if (!instance) {
            var params = $el.dataset();
            instance = new Constructor(app, _extends$j({
              el: $el
            }, params));
          }

          return instance.close(animate);
        }
      });
      return methods;
    }

    var fetchedModules = [];

    function loadModule(moduleToLoad) {
      var Framework7 = this;
      var window = getWindow();
      var document = getDocument();
      return new Promise(function (resolve, reject) {
        var app = Framework7.instance;
        var modulePath;
        var moduleObj;
        var moduleFunc;

        if (!moduleToLoad) {
          reject(new Error('Framework7: Lazy module must be specified'));
          return;
        }

        function install(module) {
          Framework7.use(module);

          if (app) {
            app.useModuleParams(module, app.params);
            app.useModule(module);
          }
        }

        if (typeof moduleToLoad === 'string') {
          var matchNamePattern = moduleToLoad.match(/([a-z0-9-]*)/i);

          if (moduleToLoad.indexOf('.') < 0 && matchNamePattern && matchNamePattern[0].length === moduleToLoad.length) {
            if (!app || app && !app.params.lazyModulesPath) {
              reject(new Error('Framework7: "lazyModulesPath" app parameter must be specified to fetch module by name'));
              return;
            }

            modulePath = app.params.lazyModulesPath + "/" + moduleToLoad + "/" + moduleToLoad + ".js";
          } else {
            modulePath = moduleToLoad;
          }
        } else if (typeof moduleToLoad === 'function') {
          moduleFunc = moduleToLoad;
        } else {
          // considering F7-Plugin object
          moduleObj = moduleToLoad;
        }

        if (moduleFunc) {
          var module = moduleFunc(Framework7, false);

          if (!module) {
            reject(new Error("Framework7: Can't find Framework7 component in specified component function"));
            return;
          } // Check if it was added


          if (Framework7.prototype.modules && Framework7.prototype.modules[module.name]) {
            resolve();
            return;
          } // Install It


          install(module);
          resolve();
        }

        if (moduleObj) {
          var _module = moduleObj;

          if (!_module) {
            reject(new Error("Framework7: Can't find Framework7 component in specified component"));
            return;
          } // Check if it was added


          if (Framework7.prototype.modules && Framework7.prototype.modules[_module.name]) {
            resolve();
            return;
          } // Install It


          install(_module);
          resolve();
        }

        if (modulePath) {
          if (fetchedModules.indexOf(modulePath) >= 0) {
            resolve();
            return;
          }

          fetchedModules.push(modulePath);
          var scriptLoad = new Promise(function (resolveScript, rejectScript) {
            Framework7.request.get(modulePath, function (scriptContent) {
              var callbackId = id();
              var callbackLoadName = "f7_component_loader_callback_" + callbackId;
              var scriptEl = document.createElement('script');
              scriptEl.innerHTML = "window." + callbackLoadName + " = function (Framework7, Framework7AutoInstallComponent) {return " + scriptContent.trim() + "}";
              $('head').append(scriptEl);
              var componentLoader = window[callbackLoadName];
              delete window[callbackLoadName];
              $(scriptEl).remove();
              var module = componentLoader(Framework7, false);

              if (!module) {
                rejectScript(new Error("Framework7: Can't find Framework7 component in " + modulePath + " file"));
                return;
              } // Check if it was added


              if (Framework7.prototype.modules && Framework7.prototype.modules[module.name]) {
                resolveScript();
                return;
              } // Install It


              install(module);
              resolveScript();
            }, function (xhr, status) {
              rejectScript(xhr, status);
            });
          });
          var styleLoad = new Promise(function (resolveStyle) {
            Framework7.request.get(modulePath.replace('.js', app.rtl ? '.rtl.css' : '.css'), function (styleContent) {
              var styleEl = document.createElement('style');
              styleEl.innerHTML = styleContent;
              $('head').append(styleEl);
              resolveStyle();
            }, function () {
              resolveStyle();
            });
          });
          Promise.all([scriptLoad, styleLoad]).then(function () {
            resolve();
          }).catch(function (err) {
            reject(err);
          });
        }
      });
    }

    var Framework7 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(Framework7, _Framework7Class);

      function Framework7(params) {
        var _this;

        if (params === void 0) {
          params = {};
        }

        _this = _Framework7Class.call(this, params) || this; // eslint-disable-next-line

        if (Framework7.instance && typeof window !== 'undefined') {
          throw new Error("Framework7 is already initialized and can't be initialized more than once");
        }

        var device = getDevice$1({
          userAgent: params.userAgent || undefined
        });
        var support = getSupport$1();
        var passedParams = extend$1({}, params); // App Instance

        var app = _assertThisInitialized(_this);

        app.device = device;
        app.support = support;
        var w = getWindow();
        var d = getDocument();
        Framework7.instance = app; // Default

        var defaults = {
          version: '1.0.0',
          id: 'io.framework7.myapp',
          el: 'body',
          theme: 'auto',
          language: w.navigator.language,
          routes: [],
          name: 'Framework7',
          lazyModulesPath: null,
          initOnDeviceReady: true,
          init: true,
          autoDarkTheme: false,
          iosTranslucentBars: true,
          iosTranslucentModals: true,
          component: undefined,
          componentUrl: undefined,
          userAgent: null,
          url: null
        }; // Extend defaults with modules params

        app.useModulesParams(defaults); // Extend defaults with passed params

        app.params = extend$1(defaults, params);
        extend$1(app, {
          // App Id
          id: app.params.id,
          // App Name
          name: app.params.name,
          // App version
          version: app.params.version,
          // Routes
          routes: app.params.routes,
          // Lang
          language: app.params.language,
          // Theme
          theme: function getTheme() {
            if (app.params.theme === 'auto') {
              if (device.ios) return 'ios';
              if (device.desktop && device.electron) return 'aurora';
              return 'md';
            }

            return app.params.theme;
          }(),
          // Initially passed parameters
          passedParams: passedParams,
          online: w.navigator.onLine
        });
        if (params.store) app.params.store = params.store; // Save Root

        if (app.$el && app.$el[0]) {
          app.$el[0].f7 = app;
        } // Install Modules


        app.useModules(); // Init Store

        app.initStore(); // Init

        if (app.params.init) {
          if (device.cordova && app.params.initOnDeviceReady) {
            $(d).on('deviceready', function () {
              app.init();
            });
          } else {
            app.init();
          }
        } // Return app instance


        return app || _assertThisInitialized(_this);
      }

      var _proto = Framework7.prototype;

      _proto.mount = function mount(rootEl) {
        var app = this;
        var window = getWindow();
        var document = getDocument();
        var $rootEl = $(rootEl || app.params.el).eq(0);
        app.$el = $rootEl;

        if (app.$el && app.$el[0]) {
          app.el = app.$el[0];
          app.el.f7 = app;
          app.rtl = $rootEl.css('direction') === 'rtl';
        } // Auto Dark Theme


        var DARK = '(prefers-color-scheme: dark)';
        var LIGHT = '(prefers-color-scheme: light)';
        app.mq = {};

        if (window.matchMedia) {
          app.mq.dark = window.matchMedia(DARK);
          app.mq.light = window.matchMedia(LIGHT);
        }

        app.colorSchemeListener = function colorSchemeListener(_ref) {
          var matches = _ref.matches,
              media = _ref.media;

          if (!matches) {
            return;
          }

          var html = document.querySelector('html');

          if (media === DARK) {
            html.classList.add('theme-dark');
            app.darkTheme = true;
            app.emit('darkThemeChange', true);
          } else if (media === LIGHT) {
            html.classList.remove('theme-dark');
            app.darkTheme = false;
            app.emit('darkThemeChange', false);
          }
        };

        app.emit('mount');
      };

      _proto.initStore = function initStore() {
        var app = this;

        if (typeof app.params.store !== 'undefined' && app.params.store.__store) {
          app.store = app.params.store;
        } else {
          app.store = app.createStore(app.params.store);
        }
      };

      _proto.enableAutoDarkTheme = function enableAutoDarkTheme() {
        var window = getWindow();
        var document = getDocument();
        if (!window.matchMedia) return;
        var app = this;
        var html = document.querySelector('html');

        if (app.mq.dark && app.mq.light) {
          app.mq.dark.addListener(app.colorSchemeListener);
          app.mq.light.addListener(app.colorSchemeListener);
        }

        if (app.mq.dark && app.mq.dark.matches) {
          html.classList.add('theme-dark');
          app.darkTheme = true;
          app.emit('darkThemeChange', true);
        } else if (app.mq.light && app.mq.light.matches) {
          html.classList.remove('theme-dark');
          app.darkTheme = false;
          app.emit('darkThemeChange', false);
        }
      };

      _proto.disableAutoDarkTheme = function disableAutoDarkTheme() {
        var window = getWindow();
        if (!window.matchMedia) return;
        var app = this;
        if (app.mq.dark) app.mq.dark.removeListener(app.colorSchemeListener);
        if (app.mq.light) app.mq.light.removeListener(app.colorSchemeListener);
      };

      _proto.initAppComponent = function initAppComponent(callback) {
        var app = this;
        app.router.componentLoader(app.params.component, app.params.componentUrl, {
          componentOptions: {
            el: app.$el[0]
          }
        }, function (el) {
          app.$el = $(el);
          app.$el[0].f7 = app;
          app.$elComponent = el.f7Component;
          app.el = app.$el[0];
          if (callback) callback();
        }, function () {});
      };

      _proto.init = function init(rootEl) {
        var app = this;
        app.mount(rootEl);

        var init = function init() {
          if (app.initialized) return;
          app.$el.addClass('framework7-initializing'); // RTL attr

          if (app.rtl) {
            $('html').attr('dir', 'rtl');
          } // Auto Dark Theme


          if (app.params.autoDarkTheme) {
            app.enableAutoDarkTheme();
          } // Watch for online/offline state


          var window = getWindow();
          window.addEventListener('offline', function () {
            app.online = false;
            app.emit('offline');
            app.emit('connection', false);
          });
          window.addEventListener('online', function () {
            app.online = true;
            app.emit('online');
            app.emit('connection', true);
          }); // Root class

          app.$el.addClass('framework7-root'); // Theme class

          $('html').removeClass('ios md aurora').addClass(app.theme); // iOS Translucent

          var device = app.device;

          if (app.params.iosTranslucentBars && app.theme === 'ios' && device.ios) {
            $('html').addClass('ios-translucent-bars');
          }

          if (app.params.iosTranslucentModals && app.theme === 'ios' && device.ios) {
            $('html').addClass('ios-translucent-modals');
          } // Init class


          nextFrame$1(function () {
            app.$el.removeClass('framework7-initializing');
          }); // Emit, init other modules

          app.initialized = true;
          app.emit('init');
        };

        if (app.params.component || app.params.componentUrl) {
          app.initAppComponent(function () {
            init();
          });
        } else {
          init();
        }

        return app;
      } // eslint-disable-next-line
      ;

      _proto.loadModule = function loadModule() {
        return Framework7.loadModule.apply(Framework7, arguments);
      } // eslint-disable-next-line
      ;

      _proto.loadModules = function loadModules() {
        return Framework7.loadModules.apply(Framework7, arguments);
      };

      _proto.getVnodeHooks = function getVnodeHooks(hook, id) {
        var app = this;
        if (!app.vnodeHooks || !app.vnodeHooks[hook]) return [];
        return app.vnodeHooks[hook][id] || [];
      } // eslint-disable-next-line
      ;

      _createClass$1(Framework7, [{
        key: "$",
        get: function get() {
          return $;
        }
      }], [{
        key: "Dom7",
        get: function get() {
          return $;
        }
      }, {
        key: "$",
        get: function get() {
          return $;
        }
      }, {
        key: "device",
        get: function get() {
          return getDevice$1();
        }
      }, {
        key: "support",
        get: function get() {
          return getSupport$1();
        }
      }, {
        key: "Class",
        get: function get() {
          return Framework7Class;
        }
      }, {
        key: "Events",
        get: function get() {
          return EventsClass;
        }
      }]);

      return Framework7;
    }(Framework7Class);

    Framework7.ModalMethods = ModalMethods;
    Framework7.ConstructorMethods = ConstructorMethods;
    Framework7.loadModule = loadModule;

    Framework7.loadModules = function loadModules(modules) {
      return Promise.all(modules.map(function (module) {
        return Framework7.loadModule(module);
      }));
    };

    var DeviceModule = {
      name: 'device',
      static: {
        getDevice: getDevice$1
      },
      on: {
        init: function init() {
          var document = getDocument();
          var device = getDevice$1();
          var classNames = [];
          var html = document.querySelector('html');
          var metaStatusbar = document.querySelector('meta[name="apple-mobile-web-app-status-bar-style"]');
          if (!html) return;

          if (device.standalone && device.ios && metaStatusbar && metaStatusbar.content === 'black-translucent') {
            classNames.push('device-full-viewport');
          } // Pixel Ratio


          classNames.push("device-pixel-ratio-" + Math.floor(device.pixelRatio)); // OS classes

          if (device.os && !device.desktop) {
            classNames.push("device-" + device.os);
          } else if (device.desktop) {
            classNames.push('device-desktop');

            if (device.os) {
              classNames.push("device-" + device.os);
            }
          }

          if (device.cordova || device.phonegap) {
            classNames.push('device-cordova');
          }

          if (device.capacitor) {
            classNames.push('device-capacitor');
          } // Add html classes


          classNames.forEach(function (className) {
            html.classList.add(className);
          });
        }
      }
    };

    var SupportModule = {
      name: 'support',
      static: {
        getSupport: getSupport$1
      }
    };

    var UtilsModule = {
      name: 'utils',
      proto: {
        utils: utils
      },
      static: {
        utils: utils
      }
    };

    var ResizeModule = {
      name: 'resize',
      create: function create() {
        var app = this;

        app.getSize = function () {
          if (!app.el) return {
            width: 0,
            height: 0,
            left: 0,
            top: 0
          };
          var offset = app.$el.offset();
          var _ref = [app.el.offsetWidth, app.el.offsetHeight, offset.left, offset.top],
              width = _ref[0],
              height = _ref[1],
              left = _ref[2],
              top = _ref[3];
          app.width = width;
          app.height = height;
          app.left = left;
          app.top = top;
          return {
            width: width,
            height: height,
            left: left,
            top: top
          };
        };
      },
      on: {
        init: function init() {
          var app = this;
          var window = getWindow(); // Get Size

          app.getSize(); // Emit resize

          window.addEventListener('resize', function () {
            app.emit('resize');
          }, false); // Emit orientationchange

          window.addEventListener('orientationchange', function () {
            app.emit('orientationchange');
          });
        },
        orientationchange: function orientationchange() {
          var document = getDocument();
          var device = getDevice$1(); // Fix iPad weird body scroll

          if (device.ipad) {
            document.body.scrollLeft = 0;
            setTimeout(function () {
              document.body.scrollLeft = 0;
            }, 0);
          }
        },
        resize: function resize() {
          var app = this;
          app.getSize();
        }
      }
    };

    var globals = {};
    var jsonpRequests = 0;

    var RequestResponse = function RequestResponse(obj) {
      Object.assign(this, obj);
    };

    var RequestError = /*#__PURE__*/function (_Error) {
      _inheritsLoose(RequestError, _Error);

      function RequestError(obj) {
        var _this;

        _this = _Error.call(this) || this;
        Object.assign(_assertThisInitialized(_this), obj);
        return _this;
      }

      return RequestError;
    }( /*#__PURE__*/_wrapNativeSuper(Error));

    var request = function request(requestOptions) {
      return new Promise(function (resolve, reject) {
        var window = getWindow();
        var document = getDocument();
        var globalsNoCallbacks = extend$1({}, globals);
        'beforeCreate beforeOpen beforeSend error complete success statusCode'.split(' ').forEach(function (callbackName) {
          delete globalsNoCallbacks[callbackName];
        });
        var defaults = extend$1({
          url: window.location.toString(),
          method: 'GET',
          data: false,
          async: true,
          cache: true,
          user: '',
          password: '',
          headers: {},
          xhrFields: {},
          statusCode: {},
          processData: true,
          dataType: 'text',
          contentType: 'application/x-www-form-urlencoded',
          timeout: 0
        }, globalsNoCallbacks);
        var proceedRequest;
        var options = extend$1({}, defaults, requestOptions);

        if (requestOptions.abortController) {
          options.abortController = requestOptions.abortController;
        }

        if (options.abortController && options.abortController.canceled) {
          reject(new RequestError({
            options: options,
            status: 'canceled',
            message: 'canceled'
          }));
          return;
        } // Function to run XHR callbacks and events


        function fireCallback(callbackName) {
          /*
          Callbacks:
          beforeCreate (options),
          beforeOpen (xhr, options),
          beforeSend (xhr, options),
          error (xhr, status, message),
          complete (xhr, status),
          success (response, status, xhr),
          statusCode ()
          */
          var globalCallbackValue;
          var optionCallbackValue;

          for (var _len = arguments.length, data = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            data[_key - 1] = arguments[_key];
          }

          if (globals[callbackName]) {
            globalCallbackValue = globals[callbackName].apply(globals, data);
          }

          if (options[callbackName]) {
            optionCallbackValue = options[callbackName].apply(options, data);
          }

          if (typeof globalCallbackValue !== 'boolean') globalCallbackValue = true;
          if (typeof optionCallbackValue !== 'boolean') optionCallbackValue = true;

          if (options.abortController && options.abortController.canceled && (callbackName === 'beforeCreate' || callbackName === 'beforeOpen' || callbackName === 'beforeSend')) {
            return false;
          }

          return globalCallbackValue && optionCallbackValue;
        } // Before create callback


        proceedRequest = fireCallback('beforeCreate', options);

        if (proceedRequest === false) {
          reject(new RequestError({
            options: options,
            status: 'canceled',
            message: 'canceled'
          }));
          return;
        } // For jQuery guys


        if (options.type) options.method = options.type; // Parameters Prefix

        var paramsPrefix = options.url.indexOf('?') >= 0 ? '&' : '?'; // UC method

        var method = options.method.toUpperCase(); // Data to modify GET URL

        if ((method === 'GET' || method === 'HEAD' || method === 'OPTIONS' || method === 'DELETE') && options.data) {
          var stringData;

          if (typeof options.data === 'string') {
            // Should be key=value string
            if (options.data.indexOf('?') >= 0) stringData = options.data.split('?')[1];else stringData = options.data;
          } else {
            // Should be key=value object
            stringData = serializeObject(options.data);
          }

          if (stringData.length) {
            options.url += paramsPrefix + stringData;
            if (paramsPrefix === '?') paramsPrefix = '&';
          }
        } // JSONP


        if (options.dataType === 'json' && options.url.indexOf('callback=') >= 0) {
          var callbackName = "f7jsonp_" + (Date.now() + (jsonpRequests += 1));
          var abortTimeout;
          var callbackSplit = options.url.split('callback=');
          var requestUrl = callbackSplit[0] + "callback=" + callbackName;

          if (callbackSplit[1].indexOf('&') >= 0) {
            var addVars = callbackSplit[1].split('&').filter(function (el) {
              return el.indexOf('=') > 0;
            }).join('&');
            if (addVars.length > 0) requestUrl += "&" + addVars;
          } // Create script


          var script = document.createElement('script');
          script.type = 'text/javascript';

          script.onerror = function onerror() {
            clearTimeout(abortTimeout);
            fireCallback('error', null, 'scripterror', 'scripterror');
            reject(new RequestError({
              options: options,
              status: 'scripterror',
              message: 'scripterror'
            }));
            fireCallback('complete', null, 'scripterror');
          };

          script.src = requestUrl; // Handler

          window[callbackName] = function jsonpCallback(data) {
            clearTimeout(abortTimeout);
            fireCallback('success', data);
            script.parentNode.removeChild(script);
            script = null;
            delete window[callbackName];
            resolve(new RequestResponse({
              options: options,
              data: data
            }));
          };

          document.querySelector('head').appendChild(script);

          if (options.timeout > 0) {
            abortTimeout = setTimeout(function () {
              script.parentNode.removeChild(script);
              script = null;
              fireCallback('error', null, 'timeout', 'timeout');
              reject(new RequestError({
                options: options,
                status: 'timeout',
                message: 'timeout'
              }));
            }, options.timeout);
          }

          return;
        } // Cache for GET/HEAD requests


        if (method === 'GET' || method === 'HEAD' || method === 'OPTIONS' || method === 'DELETE') {
          if (options.cache === false) {
            options.url += paramsPrefix + "_nocache" + Date.now();
          }
        } // Create XHR


        var xhr = new XMLHttpRequest();

        if (options.abortController) {
          var aborted = false;

          options.abortController.onAbort = function () {
            if (aborted) return;
            aborted = true;
            xhr.abort();
            reject(new RequestError({
              options: options,
              xhr: xhr,
              status: 'canceled',
              message: 'canceled'
            }));
          };
        } // Save Request URL


        xhr.requestUrl = options.url;
        xhr.requestParameters = options; // Before open callback

        proceedRequest = fireCallback('beforeOpen', xhr, options);

        if (proceedRequest === false) {
          reject(new RequestError({
            options: options,
            xhr: xhr,
            status: 'canceled',
            message: 'canceled'
          }));
          return;
        } // Open XHR


        xhr.open(method, options.url, options.async, options.user, options.password); // Create POST Data

        var postData = null;

        if ((method === 'POST' || method === 'PUT' || method === 'PATCH') && options.data) {
          if (options.processData) {
            var postDataInstances = [ArrayBuffer, Blob, Document, FormData]; // Post Data

            if (postDataInstances.indexOf(options.data.constructor) >= 0) {
              postData = options.data;
            } else {
              // POST Headers
              var boundary = "---------------------------" + Date.now().toString(16);

              if (options.contentType === 'multipart/form-data') {
                xhr.setRequestHeader('Content-Type', "multipart/form-data; boundary=" + boundary);
              } else {
                xhr.setRequestHeader('Content-Type', options.contentType);
              }

              postData = '';
              var data = serializeObject(options.data);

              if (options.contentType === 'multipart/form-data') {
                data = data.split('&');
                var newData = [];

                for (var i = 0; i < data.length; i += 1) {
                  newData.push("Content-Disposition: form-data; name=\"" + data[i].split('=')[0] + "\"\r\n\r\n" + data[i].split('=')[1] + "\r\n");
                }

                postData = "--" + boundary + "\r\n" + newData.join("--" + boundary + "\r\n") + "--" + boundary + "--\r\n";
              } else if (options.contentType === 'application/json') {
                postData = JSON.stringify(options.data);
              } else {
                postData = data;
              }
            }
          } else {
            postData = options.data;
            xhr.setRequestHeader('Content-Type', options.contentType);
          }
        }

        if (options.dataType === 'json' && (!options.headers || !options.headers.Accept)) {
          xhr.setRequestHeader('Accept', 'application/json');
        } // Additional headers


        if (options.headers) {
          Object.keys(options.headers).forEach(function (headerName) {
            if (typeof options.headers[headerName] === 'undefined') return;
            xhr.setRequestHeader(headerName, options.headers[headerName]);
          });
        } // Check for crossDomain


        if (typeof options.crossDomain === 'undefined') {
          options.crossDomain = // eslint-disable-next-line
          /^([\w-]+:)?\/\/([^\/]+)/.test(options.url) && RegExp.$2 !== window.location.host;
        }

        if (!options.crossDomain) {
          xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
        }

        if (options.xhrFields) {
          extend$1(xhr, options.xhrFields);
        } // Handle XHR


        xhr.onload = function onload() {
          if (xhr.status >= 200 && xhr.status < 300 || xhr.status === 0) {
            var responseData;

            if (options.dataType === 'json') {
              var parseError;

              try {
                responseData = JSON.parse(xhr.responseText);
              } catch (err) {
                parseError = true;
              }

              if (!parseError) {
                fireCallback('success', responseData, xhr.status, xhr);
                resolve(new RequestResponse({
                  options: options,
                  data: responseData,
                  status: xhr.status,
                  xhr: xhr
                }));
              } else {
                fireCallback('error', xhr, 'parseerror', 'parseerror');
                reject(new RequestError({
                  options: options,
                  xhr: xhr,
                  status: 'parseerror',
                  message: 'parseerror'
                }));
              }
            } else {
              responseData = xhr.responseType === 'text' || xhr.responseType === '' ? xhr.responseText : xhr.response;
              fireCallback('success', responseData, xhr.status, xhr);
              resolve(new RequestResponse({
                options: options,
                data: responseData,
                status: xhr.status,
                xhr: xhr
              }));
            }
          } else {
            fireCallback('error', xhr, xhr.status, xhr.statusText);
            reject(new RequestError({
              options: options,
              xhr: xhr,
              status: xhr.status,
              message: xhr.statusText
            }));
          }

          if (options.statusCode) {
            if (globals.statusCode && globals.statusCode[xhr.status]) globals.statusCode[xhr.status](xhr);
            if (options.statusCode[xhr.status]) options.statusCode[xhr.status](xhr);
          }

          fireCallback('complete', xhr, xhr.status);
        };

        xhr.onerror = function onerror() {
          fireCallback('error', xhr, xhr.status, xhr.status);
          reject(new RequestError({
            options: options,
            xhr: xhr,
            status: xhr.status,
            message: xhr.statusText
          }));
          fireCallback('complete', xhr, 'error');
        }; // Timeout


        if (options.timeout > 0) {
          xhr.timeout = options.timeout;

          xhr.ontimeout = function () {
            fireCallback('error', xhr, 'timeout', 'timeout');
            reject(new RequestError({
              options: options,
              xhr: xhr,
              status: 'timeout',
              message: 'timeout'
            }));
            fireCallback('complete', xhr, 'timeout');
          };
        } // Ajax start callback


        proceedRequest = fireCallback('beforeSend', xhr, options);

        if (proceedRequest === false) {
          reject(new RequestError({
            options: options,
            xhr: xhr,
            status: 'canceled',
            message: 'canceled'
          }));
          return;
        } // Send XHR


        xhr.send(postData);
      });
    };

    function requestShortcut(method) {
      var _ref = [],
          url = _ref[0],
          data = _ref[1],
          success = _ref[2],
          error = _ref[3],
          dataType = _ref[4];

      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }

      if (typeof args[1] === 'function') {
        url = args[0];
        success = args[1];
        error = args[2];
        dataType = args[3];
      } else {
        url = args[0];
        data = args[1];
        success = args[2];
        error = args[3];
        dataType = args[4];
      }

      [success, error].forEach(function (callback) {
        if (typeof callback === 'string') {
          dataType = callback;
          if (callback === success) success = undefined;else error = undefined;
        }
      });
      dataType = dataType || (method === 'json' || method === 'postJSON' ? 'json' : undefined);
      var requestOptions = {
        url: url,
        method: method === 'post' || method === 'postJSON' ? 'POST' : 'GET',
        data: data,
        success: success,
        error: error,
        dataType: dataType
      };

      if (method === 'postJSON') {
        extend$1(requestOptions, {
          contentType: 'application/json',
          processData: false,
          crossDomain: true,
          data: typeof data === 'string' ? data : JSON.stringify(data)
        });
      }

      return request(requestOptions);
    }

    Object.assign(request, {
      get: function get() {
        for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
          args[_key3] = arguments[_key3];
        }

        return requestShortcut.apply(void 0, ['get'].concat(args));
      },
      post: function post() {
        for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
          args[_key4] = arguments[_key4];
        }

        return requestShortcut.apply(void 0, ['post'].concat(args));
      },
      json: function json() {
        for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
          args[_key5] = arguments[_key5];
        }

        return requestShortcut.apply(void 0, ['json'].concat(args));
      },
      getJSON: function getJSON() {
        for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
          args[_key6] = arguments[_key6];
        }

        return requestShortcut.apply(void 0, ['json'].concat(args));
      },
      postJSON: function postJSON() {
        for (var _len7 = arguments.length, args = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
          args[_key7] = arguments[_key7];
        }

        return requestShortcut.apply(void 0, ['postJSON'].concat(args));
      }
    });

    request.abortController = function () {
      var contoller = {
        canceled: false,
        onAbort: null,
        abort: function abort() {
          contoller.canceled = true;
          if (contoller.onAbort) contoller.onAbort();
        }
      };
      return contoller;
    };

    request.setup = function setup(options) {
      if (options.type && !options.method) {
        extend$1(options, {
          method: options.type
        });
      }

      extend$1(globals, options);
    };

    /* eslint no-param-reassign: "off" */
    var RequestModule = {
      name: 'request',
      proto: {
        request: request
      },
      static: {
        request: request
      }
    };

    /* eslint-disable no-nested-ternary */

    function initTouch() {
      var app = this;
      var device = getDevice$1();
      var support = getSupport$1();
      var window = getWindow();
      var document = getDocument();
      var params = app.params.touch;
      var useRipple = params[app.theme + "TouchRipple"];

      if (device.ios && device.webView) {
        // Strange hack required for iOS 8 webview to work on inputs
        window.addEventListener('touchstart', function () {});
      }

      var touchStartX;
      var touchStartY;
      var targetElement;
      var isMoved;
      var tapHoldFired;
      var tapHoldTimeout;
      var preventClick;
      var activableElement;
      var activeTimeout;
      var rippleWave;
      var rippleTarget;
      var rippleTimeout;

      function findActivableElement(el) {
        var target = $(el);
        var parents = target.parents(params.activeStateElements);

        if (target.closest('.no-active-state').length) {
          return null;
        }

        var activable;

        if (target.is(params.activeStateElements)) {
          activable = target;
        }

        if (parents.length > 0) {
          activable = activable ? activable.add(parents) : parents;
        }

        if (activable && activable.length > 1) {
          var newActivable = [];
          var preventPropagation;

          for (var i = 0; i < activable.length; i += 1) {
            if (!preventPropagation) {
              newActivable.push(activable[i]);

              if (activable.eq(i).hasClass('prevent-active-state-propagation') || activable.eq(i).hasClass('no-active-state-propagation')) {
                preventPropagation = true;
              }
            }
          }

          activable = $(newActivable);
        }

        return activable || target;
      }

      function isInsideScrollableView(el) {
        var pageContent = el.parents('.page-content');
        return pageContent.length > 0;
      }

      function addActive() {
        if (!activableElement) return;
        activableElement.addClass('active-state');
      }

      function removeActive() {
        if (!activableElement) return;
        activableElement.removeClass('active-state');
        activableElement = null;
      } // Ripple handlers


      function findRippleElement(el) {
        var rippleElements = params.touchRippleElements;
        var $el = $(el);

        if ($el.is(rippleElements)) {
          if ($el.hasClass('no-ripple')) {
            return false;
          }

          return $el;
        }

        if ($el.parents(rippleElements).length > 0) {
          var rippleParent = $el.parents(rippleElements).eq(0);

          if (rippleParent.hasClass('no-ripple')) {
            return false;
          }

          return rippleParent;
        }

        return false;
      }

      function createRipple($el, x, y) {
        if (!$el) return;
        rippleWave = app.touchRipple.create(app, $el, x, y);
      }

      function removeRipple() {
        if (!rippleWave) return;
        rippleWave.remove();
        rippleWave = undefined;
        rippleTarget = undefined;
      }

      function rippleTouchStart(el) {
        rippleTarget = findRippleElement(el);

        if (!rippleTarget || rippleTarget.length === 0) {
          rippleTarget = undefined;
          return;
        }

        var inScrollable = isInsideScrollableView(rippleTarget);

        if (!inScrollable) {
          removeRipple();
          createRipple(rippleTarget, touchStartX, touchStartY);
        } else {
          clearTimeout(rippleTimeout);
          rippleTimeout = setTimeout(function () {
            removeRipple();
            createRipple(rippleTarget, touchStartX, touchStartY);
          }, 80);
        }
      }

      function rippleTouchMove() {
        clearTimeout(rippleTimeout);
        removeRipple();
      }

      function rippleTouchEnd() {
        if (!rippleWave && rippleTarget && !isMoved) {
          clearTimeout(rippleTimeout);
          createRipple(rippleTarget, touchStartX, touchStartY);
          setTimeout(removeRipple, 0);
        } else {
          removeRipple();
        }
      } // Mouse Handlers


      function handleMouseDown(e) {
        var $activableEl = findActivableElement(e.target);

        if ($activableEl) {
          $activableEl.addClass('active-state');

          if ('which' in e && e.which === 3) {
            setTimeout(function () {
              $('.active-state').removeClass('active-state');
            }, 0);
          }
        }

        if (useRipple) {
          touchStartX = e.pageX;
          touchStartY = e.pageY;
          rippleTouchStart(e.target, e.pageX, e.pageY);
        }
      }

      function handleMouseMove() {
        if (!params.activeStateOnMouseMove) {
          $('.active-state').removeClass('active-state');
        }

        if (useRipple) {
          rippleTouchMove();
        }
      }

      function handleMouseUp() {
        $('.active-state').removeClass('active-state');

        if (useRipple) {
          rippleTouchEnd();
        }
      }

      function handleTouchCancel() {
        targetElement = null; // Remove Active State

        clearTimeout(activeTimeout);
        clearTimeout(tapHoldTimeout);

        if (params.activeState) {
          removeActive();
        } // Remove Ripple


        if (useRipple) {
          rippleTouchEnd();
        }
      }

      var isScrolling;
      var isSegmentedStrong = false;
      var segmentedStrongEl = null;
      var touchMoveActivableIos = '.dialog-button, .actions-button';
      var isTouchMoveActivable = false;
      var touchmoveActivableEl = null;

      function handleTouchStart(e) {
        isMoved = false;
        tapHoldFired = false;
        preventClick = false;
        isScrolling = undefined;

        if (e.targetTouches.length > 1) {
          if (activableElement) removeActive();
          return true;
        }

        if (e.touches.length > 1 && activableElement) {
          removeActive();
        }

        if (params.tapHold) {
          if (tapHoldTimeout) clearTimeout(tapHoldTimeout);
          tapHoldTimeout = setTimeout(function () {
            if (e && e.touches && e.touches.length > 1) return;
            tapHoldFired = true;
            e.preventDefault();
            preventClick = true;
            $(e.target).trigger('taphold', e);
            app.emit('taphold', e);
          }, params.tapHoldDelay);
        }

        targetElement = e.target;
        touchStartX = e.targetTouches[0].pageX;
        touchStartY = e.targetTouches[0].pageY;
        isSegmentedStrong = e.target.closest('.segmented-strong .button-active, .segmented-strong .tab-link-active');
        isTouchMoveActivable = app.theme === 'ios' && e.target.closest(touchMoveActivableIos);

        if (isSegmentedStrong) {
          segmentedStrongEl = isSegmentedStrong.closest('.segmented-strong');
        }

        if (params.activeState) {
          activableElement = findActivableElement(targetElement);

          if (activableElement && !isInsideScrollableView(activableElement)) {
            addActive();
          } else if (activableElement) {
            activeTimeout = setTimeout(addActive, 80);
          }
        }

        if (useRipple) {
          rippleTouchStart(targetElement, touchStartX, touchStartY);
        }

        return true;
      }

      function handleTouchMove(e) {
        var touch;
        var distance;
        var shouldRemoveActive = true;

        if (e.type === 'touchmove') {
          touch = e.targetTouches[0];
          distance = params.touchClicksDistanceThreshold;
        }

        var touchCurrentX = e.targetTouches[0].pageX;
        var touchCurrentY = e.targetTouches[0].pageY;

        if (typeof isScrolling === 'undefined') {
          isScrolling = !!(isScrolling || Math.abs(touchCurrentY - touchStartY) > Math.abs(touchCurrentX - touchStartX));
        }

        if (isTouchMoveActivable || !isScrolling && isSegmentedStrong && segmentedStrongEl) {
          if (e.cancelable) e.preventDefault();
        }

        if (!isScrolling && isSegmentedStrong && segmentedStrongEl) {
          var elementFromPoint = document.elementFromPoint(e.targetTouches[0].clientX, e.targetTouches[0].clientY);
          var buttonEl = elementFromPoint.closest('.segmented-strong .button:not(.button-active):not(.tab-link-active)');

          if (buttonEl && segmentedStrongEl.contains(buttonEl)) {
            $(buttonEl).trigger('click', 'f7Segmented');
            targetElement = buttonEl;
          }
        }

        if (distance && touch) {
          var pageX = touch.pageX;
          var pageY = touch.pageY;

          if (Math.abs(pageX - touchStartX) > distance || Math.abs(pageY - touchStartY) > distance) {
            isMoved = true;
          }
        } else {
          isMoved = true;
        }

        if (isMoved) {
          preventClick = true; // Keep active state on touchMove (for dialog and actions buttons)

          if (isTouchMoveActivable) {
            var _elementFromPoint = document.elementFromPoint(e.targetTouches[0].clientX, e.targetTouches[0].clientY);

            touchmoveActivableEl = _elementFromPoint.closest(touchMoveActivableIos);

            if (touchmoveActivableEl && activableElement && activableElement[0] === touchmoveActivableEl) {
              shouldRemoveActive = false;
            } else if (touchmoveActivableEl) {
              setTimeout(function () {
                activableElement = findActivableElement(touchmoveActivableEl);
                addActive();
              });
            }
          }

          if (params.tapHold) {
            clearTimeout(tapHoldTimeout);
          }

          if (params.activeState && shouldRemoveActive) {
            clearTimeout(activeTimeout);
            removeActive();
          }

          if (useRipple) {
            rippleTouchMove();
          }
        }
      }

      function handleTouchEnd(e) {
        isScrolling = undefined;
        isSegmentedStrong = false;
        segmentedStrongEl = null;
        isTouchMoveActivable = false;
        clearTimeout(activeTimeout);
        clearTimeout(tapHoldTimeout);

        if (touchmoveActivableEl) {
          $(touchmoveActivableEl).trigger('click', 'f7TouchMoveActivable');
          touchmoveActivableEl = null;
        }

        if (document.activeElement === e.target) {
          if (params.activeState) removeActive();

          if (useRipple) {
            rippleTouchEnd();
          }

          return true;
        }

        if (params.activeState) {
          addActive();
          setTimeout(removeActive, 0);
        }

        if (useRipple) {
          rippleTouchEnd();
        }

        if (params.tapHoldPreventClicks && tapHoldFired || preventClick) {
          if (e.cancelable) e.preventDefault();
          preventClick = true;
          return false;
        }

        return true;
      }

      function handleClick(e) {
        var isOverswipe = e && e.detail && e.detail === 'f7Overswipe';
        var isSegmented = e && e.detail && e.detail === 'f7Segmented'; // eslint-disable-next-line

        var isTouchMoveActivable = e && e.detail && e.detail === 'f7TouchMoveActivable';
        var localPreventClick = preventClick;

        if (targetElement && e.target !== targetElement) {
          if (isOverswipe || isSegmented || isTouchMoveActivable) {
            localPreventClick = false;
          } else {
            localPreventClick = true;
          }
        } else if (isTouchMoveActivable) {
          localPreventClick = false;
        }

        if (params.tapHold && params.tapHoldPreventClicks && tapHoldFired) {
          localPreventClick = true;
        }

        if (localPreventClick) {
          e.stopImmediatePropagation();
          e.stopPropagation();
          e.preventDefault();
        }

        if (params.tapHold) {
          tapHoldTimeout = setTimeout(function () {
            tapHoldFired = false;
          }, device.ios || device.androidChrome ? 100 : 400);
        }

        preventClick = false;
        targetElement = null;
        return !localPreventClick;
      }

      function emitAppTouchEvent(name, e) {
        app.emit({
          events: name,
          data: [e]
        });
      }

      function appClick(e) {
        emitAppTouchEvent('click', e);
      }

      function appTouchStartActive(e) {
        emitAppTouchEvent('touchstart touchstart:active', e);
      }

      function appTouchMoveActive(e) {
        emitAppTouchEvent('touchmove touchmove:active', e);
      }

      function appTouchEndActive(e) {
        emitAppTouchEvent('touchend touchend:active', e);
      }

      function appTouchStartPassive(e) {
        emitAppTouchEvent('touchstart:passive', e);
      }

      function appTouchMovePassive(e) {
        emitAppTouchEvent('touchmove:passive', e);
      }

      function appTouchEndPassive(e) {
        emitAppTouchEvent('touchend:passive', e);
      }

      var passiveListener = support.passiveListener ? {
        passive: true
      } : false;
      var passiveListenerCapture = support.passiveListener ? {
        passive: true,
        capture: true
      } : true;
      var activeListener = support.passiveListener ? {
        passive: false
      } : false;
      var activeListenerCapture = support.passiveListener ? {
        passive: false,
        capture: true
      } : true;
      document.addEventListener('click', appClick, true);

      if (support.passiveListener) {
        document.addEventListener(app.touchEvents.start, appTouchStartActive, activeListenerCapture);
        document.addEventListener(app.touchEvents.move, appTouchMoveActive, activeListener);
        document.addEventListener(app.touchEvents.end, appTouchEndActive, activeListener);
        document.addEventListener(app.touchEvents.start, appTouchStartPassive, passiveListenerCapture);
        document.addEventListener(app.touchEvents.move, appTouchMovePassive, passiveListener);
        document.addEventListener(app.touchEvents.end, appTouchEndPassive, passiveListener);
      } else {
        document.addEventListener(app.touchEvents.start, function (e) {
          appTouchStartActive(e);
          appTouchStartPassive(e);
        }, true);
        document.addEventListener(app.touchEvents.move, function (e) {
          appTouchMoveActive(e);
          appTouchMovePassive(e);
        }, false);
        document.addEventListener(app.touchEvents.end, function (e) {
          appTouchEndActive(e);
          appTouchEndPassive(e);
        }, false);
      }

      if (support.touch) {
        app.on('click', handleClick);
        app.on('touchstart', handleTouchStart);
        app.on('touchmove', handleTouchMove);
        app.on('touchend', handleTouchEnd);
        document.addEventListener('touchcancel', handleTouchCancel, {
          passive: true
        });
      } else if (params.activeState) {
        app.on('touchstart', handleMouseDown);
        app.on('touchmove', handleMouseMove);
        app.on('touchend', handleMouseUp);
        document.addEventListener('pointercancel', handleMouseUp, {
          passive: true
        });
      }

      document.addEventListener('contextmenu', function (e) {
        if (params.disableContextMenu && (device.ios || device.android || device.cordova || window.Capacitor && window.Capacitor.isNative)) {
          e.preventDefault();
        }

        if (useRipple) {
          if (activableElement) removeActive();
          rippleTouchEnd();
        }
      });
    }

    var TouchModule = {
      name: 'touch',
      params: {
        touch: {
          // Clicks
          touchClicksDistanceThreshold: 5,
          // ContextMenu
          disableContextMenu: false,
          // Tap Hold
          tapHold: false,
          tapHoldDelay: 750,
          tapHoldPreventClicks: true,
          // Active State
          activeState: true,
          activeStateElements: 'a, button, label, span, .actions-button, .stepper-button, .stepper-button-plus, .stepper-button-minus, .card-expandable, .menu-item, .link, .item-link, .accordion-item-toggle',
          activeStateOnMouseMove: false,
          mdTouchRipple: true,
          iosTouchRipple: false,
          auroraTouchRipple: false,
          touchRippleElements: '.ripple, .link, .item-link, .list-button, .links-list a, .button, button, .input-clear-button, .dialog-button, .tab-link, .item-radio, .item-checkbox, .actions-button, .searchbar-disable-button, .fab a, .checkbox, .radio, .data-table .sortable-cell:not(.input-cell), .notification-close-button, .stepper-button, .stepper-button-minus, .stepper-button-plus, .menu-item-content, .list.accordion-list .accordion-item-toggle',
          touchRippleInsetElements: '.ripple-inset, .icon-only, .searchbar-disable-button, .input-clear-button, .notification-close-button, .md .navbar .link.back'
        }
      },
      create: function create() {
        var app = this;
        var support = getSupport$1();
        extend$1(app, {
          touchEvents: {
            start: support.touch ? 'touchstart' : support.pointerEvents ? 'pointerdown' : 'mousedown',
            move: support.touch ? 'touchmove' : support.pointerEvents ? 'pointermove' : 'mousemove',
            end: support.touch ? 'touchend' : support.pointerEvents ? 'pointerup' : 'mouseup'
          }
        });
      },
      on: {
        init: initTouch
      }
    };

    /**
     * Tokenize input string.
     */
    function lexer(str) {
      var tokens = [];
      var i = 0;

      while (i < str.length) {
        var char = str[i];

        if (char === "*" || char === "+" || char === "?") {
          tokens.push({
            type: "MODIFIER",
            index: i,
            value: str[i++]
          });
          continue;
        }

        if (char === "\\") {
          tokens.push({
            type: "ESCAPED_CHAR",
            index: i++,
            value: str[i++]
          });
          continue;
        }

        if (char === "{") {
          tokens.push({
            type: "OPEN",
            index: i,
            value: str[i++]
          });
          continue;
        }

        if (char === "}") {
          tokens.push({
            type: "CLOSE",
            index: i,
            value: str[i++]
          });
          continue;
        }

        if (char === ":") {
          var name = "";
          var j = i + 1;

          while (j < str.length) {
            var code = str.charCodeAt(j);

            if ( // `0-9`
            code >= 48 && code <= 57 || // `A-Z`
            code >= 65 && code <= 90 || // `a-z`
            code >= 97 && code <= 122 || // `_`
            code === 95) {
              name += str[j++];
              continue;
            }

            break;
          }

          if (!name) throw new TypeError("Missing parameter name at " + i);
          tokens.push({
            type: "NAME",
            index: i,
            value: name
          });
          i = j;
          continue;
        }

        if (char === "(") {
          var count = 1;
          var pattern = "";
          var j = i + 1;

          if (str[j] === "?") {
            throw new TypeError("Pattern cannot start with \"?\" at " + j);
          }

          while (j < str.length) {
            if (str[j] === "\\") {
              pattern += str[j++] + str[j++];
              continue;
            }

            if (str[j] === ")") {
              count--;

              if (count === 0) {
                j++;
                break;
              }
            } else if (str[j] === "(") {
              count++;

              if (str[j + 1] !== "?") {
                throw new TypeError("Capturing groups are not allowed at " + j);
              }
            }

            pattern += str[j++];
          }

          if (count) throw new TypeError("Unbalanced pattern at " + i);
          if (!pattern) throw new TypeError("Missing pattern at " + i);
          tokens.push({
            type: "PATTERN",
            index: i,
            value: pattern
          });
          i = j;
          continue;
        }

        tokens.push({
          type: "CHAR",
          index: i,
          value: str[i++]
        });
      }

      tokens.push({
        type: "END",
        index: i,
        value: ""
      });
      return tokens;
    }
    /**
     * Parse a string for the raw tokens.
     */


    function parse(str, options) {
      if (options === void 0) {
        options = {};
      }

      var tokens = lexer(str);
      var _a = options.prefixes,
          prefixes = _a === void 0 ? "./" : _a;
      var defaultPattern = "[^" + escapeString(options.delimiter || "/#?") + "]+?";
      var result = [];
      var key = 0;
      var i = 0;
      var path = "";

      var tryConsume = function tryConsume(type) {
        if (i < tokens.length && tokens[i].type === type) return tokens[i++].value;
      };

      var mustConsume = function mustConsume(type) {
        var value = tryConsume(type);
        if (value !== undefined) return value;
        var _a = tokens[i],
            nextType = _a.type,
            index = _a.index;
        throw new TypeError("Unexpected " + nextType + " at " + index + ", expected " + type);
      };

      var consumeText = function consumeText() {
        var result = "";
        var value; // tslint:disable-next-line

        while (value = tryConsume("CHAR") || tryConsume("ESCAPED_CHAR")) {
          result += value;
        }

        return result;
      };

      while (i < tokens.length) {
        var char = tryConsume("CHAR");
        var name = tryConsume("NAME");
        var pattern = tryConsume("PATTERN");

        if (name || pattern) {
          var prefix = char || "";

          if (prefixes.indexOf(prefix) === -1) {
            path += prefix;
            prefix = "";
          }

          if (path) {
            result.push(path);
            path = "";
          }

          result.push({
            name: name || key++,
            prefix: prefix,
            suffix: "",
            pattern: pattern || defaultPattern,
            modifier: tryConsume("MODIFIER") || ""
          });
          continue;
        }

        var value = char || tryConsume("ESCAPED_CHAR");

        if (value) {
          path += value;
          continue;
        }

        if (path) {
          result.push(path);
          path = "";
        }

        var open = tryConsume("OPEN");

        if (open) {
          var prefix = consumeText();
          var name_1 = tryConsume("NAME") || "";
          var pattern_1 = tryConsume("PATTERN") || "";
          var suffix = consumeText();
          mustConsume("CLOSE");
          result.push({
            name: name_1 || (pattern_1 ? key++ : ""),
            pattern: name_1 && !pattern_1 ? defaultPattern : pattern_1,
            prefix: prefix,
            suffix: suffix,
            modifier: tryConsume("MODIFIER") || ""
          });
          continue;
        }

        mustConsume("END");
      }

      return result;
    }
    /**
     * Compile a string to a template function for the path.
     */

    function compile(str, options) {
      return tokensToFunction(parse(str, options), options);
    }
    /**
     * Expose a method for transforming tokens into the path function.
     */

    function tokensToFunction(tokens, options) {
      if (options === void 0) {
        options = {};
      }

      var reFlags = flags(options);
      var _a = options.encode,
          encode = _a === void 0 ? function (x) {
        return x;
      } : _a,
          _b = options.validate,
          validate = _b === void 0 ? true : _b; // Compile all the tokens into regexps.

      var matches = tokens.map(function (token) {
        if (typeof token === "object") {
          return new RegExp("^(?:" + token.pattern + ")$", reFlags);
        }
      });
      return function (data) {
        var path = "";

        for (var i = 0; i < tokens.length; i++) {
          var token = tokens[i];

          if (typeof token === "string") {
            path += token;
            continue;
          }

          var value = data ? data[token.name] : undefined;
          var optional = token.modifier === "?" || token.modifier === "*";
          var repeat = token.modifier === "*" || token.modifier === "+";

          if (Array.isArray(value)) {
            if (!repeat) {
              throw new TypeError("Expected \"" + token.name + "\" to not repeat, but got an array");
            }

            if (value.length === 0) {
              if (optional) continue;
              throw new TypeError("Expected \"" + token.name + "\" to not be empty");
            }

            for (var j = 0; j < value.length; j++) {
              var segment = encode(value[j], token);

              if (validate && !matches[i].test(segment)) {
                throw new TypeError("Expected all \"" + token.name + "\" to match \"" + token.pattern + "\", but got \"" + segment + "\"");
              }

              path += token.prefix + segment + token.suffix;
            }

            continue;
          }

          if (typeof value === "string" || typeof value === "number") {
            var segment = encode(String(value), token);

            if (validate && !matches[i].test(segment)) {
              throw new TypeError("Expected \"" + token.name + "\" to match \"" + token.pattern + "\", but got \"" + segment + "\"");
            }

            path += token.prefix + segment + token.suffix;
            continue;
          }

          if (optional) continue;
          var typeOfMessage = repeat ? "an array" : "a string";
          throw new TypeError("Expected \"" + token.name + "\" to be " + typeOfMessage);
        }

        return path;
      };
    }
    /**
     * Create path match function from `path-to-regexp` spec.
     */

    function match(str, options) {
      var keys = [];
      var re = pathToRegexp(str, keys, options);
      return regexpToFunction(re, keys, options);
    }
    /**
     * Create a path match function from `path-to-regexp` output.
     */

    function regexpToFunction(re, keys, options) {
      if (options === void 0) {
        options = {};
      }

      var _a = options.decode,
          decode = _a === void 0 ? function (x) {
        return x;
      } : _a;
      return function (pathname) {
        var m = re.exec(pathname);
        if (!m) return false;
        var path = m[0],
            index = m.index;
        var params = Object.create(null);

        var _loop_1 = function _loop_1(i) {
          // tslint:disable-next-line
          if (m[i] === undefined) return "continue";
          var key = keys[i - 1];

          if (key.modifier === "*" || key.modifier === "+") {
            params[key.name] = m[i].split(key.prefix + key.suffix).map(function (value) {
              return decode(value, key);
            });
          } else {
            params[key.name] = decode(m[i], key);
          }
        };

        for (var i = 1; i < m.length; i++) {
          _loop_1(i);
        }

        return {
          path: path,
          index: index,
          params: params
        };
      };
    }
    /**
     * Escape a regular expression string.
     */

    function escapeString(str) {
      return str.replace(/([.+*?=^!:${}()[\]|/\\])/g, "\\$1");
    }
    /**
     * Get the flags for a regexp from the options.
     */


    function flags(options) {
      return options && options.sensitive ? "" : "i";
    }
    /**
     * Pull out keys from a regexp.
     */


    function regexpToRegexp(path, keys) {
      if (!keys) return path;
      var groupsRegex = /\((?:\?<(.*?)>)?(?!\?)/g;
      var index = 0;
      var execResult = groupsRegex.exec(path.source);

      while (execResult) {
        keys.push({
          // Use parenthesized substring match if available, index otherwise
          name: execResult[1] || index++,
          prefix: "",
          suffix: "",
          modifier: "",
          pattern: ""
        });
        execResult = groupsRegex.exec(path.source);
      }

      return path;
    }
    /**
     * Transform an array into a regexp.
     */


    function arrayToRegexp(paths, keys, options) {
      var parts = paths.map(function (path) {
        return pathToRegexp(path, keys, options).source;
      });
      return new RegExp("(?:" + parts.join("|") + ")", flags(options));
    }
    /**
     * Create a path regexp from string input.
     */


    function stringToRegexp(path, keys, options) {
      return tokensToRegexp(parse(path, options), keys, options);
    }
    /**
     * Expose a function for taking tokens and returning a RegExp.
     */


    function tokensToRegexp(tokens, keys, options) {
      if (options === void 0) {
        options = {};
      }

      var _a = options.strict,
          strict = _a === void 0 ? false : _a,
          _b = options.start,
          start = _b === void 0 ? true : _b,
          _c = options.end,
          end = _c === void 0 ? true : _c,
          _d = options.encode,
          encode = _d === void 0 ? function (x) {
        return x;
      } : _d;
      var endsWith = "[" + escapeString(options.endsWith || "") + "]|$";
      var delimiter = "[" + escapeString(options.delimiter || "/#?") + "]";
      var route = start ? "^" : ""; // Iterate over the tokens and create our regexp string.

      for (var _i = 0, tokens_1 = tokens; _i < tokens_1.length; _i++) {
        var token = tokens_1[_i];

        if (typeof token === "string") {
          route += escapeString(encode(token));
        } else {
          var prefix = escapeString(encode(token.prefix));
          var suffix = escapeString(encode(token.suffix));

          if (token.pattern) {
            if (keys) keys.push(token);

            if (prefix || suffix) {
              if (token.modifier === "+" || token.modifier === "*") {
                var mod = token.modifier === "*" ? "?" : "";
                route += "(?:" + prefix + "((?:" + token.pattern + ")(?:" + suffix + prefix + "(?:" + token.pattern + "))*)" + suffix + ")" + mod;
              } else {
                route += "(?:" + prefix + "(" + token.pattern + ")" + suffix + ")" + token.modifier;
              }
            } else {
              route += "(" + token.pattern + ")" + token.modifier;
            }
          } else {
            route += "(?:" + prefix + suffix + ")" + token.modifier;
          }
        }
      }

      if (end) {
        if (!strict) route += delimiter + "?";
        route += !options.endsWith ? "$" : "(?=" + endsWith + ")";
      } else {
        var endToken = tokens[tokens.length - 1];
        var isEndDelimited = typeof endToken === "string" ? delimiter.indexOf(endToken[endToken.length - 1]) > -1 : // tslint:disable-next-line
        endToken === undefined;

        if (!strict) {
          route += "(?:" + delimiter + "(?=" + endsWith + "))?";
        }

        if (!isEndDelimited) {
          route += "(?=" + delimiter + "|" + endsWith + ")";
        }
      }

      return new RegExp(route, flags(options));
    }
    /**
     * Normalize the given path string, returning a regular expression.
     *
     * An empty array can be passed in for the keys, which will hold the
     * placeholder key descriptions. For example, using `/user/:id`, `keys` will
     * contain `[{ name: 'id', delimiter: '/', optional: false, repeat: false }]`.
     */

    function pathToRegexp(path, keys, options) {
      if (path instanceof RegExp) return regexpToRegexp(path, keys);
      if (Array.isArray(path)) return arrayToRegexp(path, keys, options);
      return stringToRegexp(path, keys, options);
    }

    var History$2 = {
      queue: [],
      clearQueue: function clearQueue() {
        if (History$2.queue.length === 0) return;
        var currentQueue = History$2.queue.shift();
        currentQueue();
      },
      routerQueue: [],
      clearRouterQueue: function clearRouterQueue() {
        if (History$2.routerQueue.length === 0) return;
        var currentQueue = History$2.routerQueue.pop();
        var router = currentQueue.router,
            stateUrl = currentQueue.stateUrl,
            action = currentQueue.action;
        var animate = router.params.animate;
        if (router.params.browserHistoryAnimate === false) animate = false;

        if (action === 'back') {
          router.back({
            animate: animate,
            browserHistory: false
          });
        }

        if (action === 'load') {
          router.navigate(stateUrl, {
            animate: animate,
            browserHistory: false
          });
        }
      },
      handle: function handle(e) {
        if (History$2.blockPopstate) return;
        var app = this; // const mainView = app.views.main;

        var state = e.state;
        History$2.previousState = History$2.state;
        History$2.state = state;
        History$2.allowChange = true;
        History$2.clearQueue();
        state = History$2.state;
        if (!state) state = {};
        app.views.forEach(function (view) {
          var router = view.router;
          var viewState = state[view.id];

          if (!viewState && view.params.browserHistory) {
            viewState = {
              url: view.router.history[0]
            };
          }

          if (!viewState) return;
          var stateUrl = viewState.url || undefined;
          var animate = router.params.animate;
          if (router.params.browserHistoryAnimate === false) animate = false;

          if (stateUrl !== router.url) {
            if (router.history.indexOf(stateUrl) >= 0) {
              // Go Back
              if (router.allowPageChange) {
                router.back({
                  animate: animate,
                  browserHistory: false
                });
              } else {
                History$2.routerQueue.push({
                  action: 'back',
                  router: router
                });
              }
            } else if (router.allowPageChange) {
              // Load page
              router.navigate(stateUrl, {
                animate: animate,
                browserHistory: false
              });
            } else {
              History$2.routerQueue.unshift({
                action: 'load',
                stateUrl: stateUrl,
                router: router
              });
            }
          }
        });
      },
      initViewState: function initViewState(viewId, viewState) {
        var _extend;

        var window = getWindow();
        var newState = extend$1({}, History$2.state || {}, (_extend = {}, _extend[viewId] = viewState, _extend));
        History$2.state = newState;
        window.history.replaceState(newState, '');
      },
      push: function push(viewId, viewState, url) {
        var _extend2;

        var window = getWindow();

        if (url.substr(-3) === '#!/') {
          // eslint-disable-next-line
          url = url.replace('#!/', '');
        }

        if (!History$2.allowChange) {
          History$2.queue.push(function () {
            History$2.push(viewId, viewState, url);
          });
          return;
        }

        History$2.previousState = History$2.state;
        var newState = extend$1({}, History$2.previousState || {}, (_extend2 = {}, _extend2[viewId] = viewState, _extend2));
        History$2.state = newState;
        window.history.pushState(newState, '', url);
      },
      replace: function replace(viewId, viewState, url) {
        var _extend3;

        var window = getWindow();

        if (url.substr(-3) === '#!/') {
          // eslint-disable-next-line
          url = url.replace('#!/', '');
        }

        if (!History$2.allowChange) {
          History$2.queue.push(function () {
            History$2.replace(viewId, viewState, url);
          });
          return;
        }

        History$2.previousState = History$2.state;
        var newState = extend$1({}, History$2.previousState || {}, (_extend3 = {}, _extend3[viewId] = viewState, _extend3));
        History$2.state = newState;
        window.history.replaceState(newState, '', url);
      },
      go: function go(index) {
        var window = getWindow();
        History$2.allowChange = false;
        window.history.go(index);
      },
      back: function back() {
        var window = getWindow();
        History$2.allowChange = false;
        window.history.back();
      },
      allowChange: true,
      previousState: {},
      state: {},
      blockPopstate: true,
      init: function init(app) {
        var window = getWindow();
        var document = getDocument();
        History$2.state = window.history.state;
        $(window).on('load', function () {
          setTimeout(function () {
            History$2.blockPopstate = false;
          }, 0);
        });

        if (document.readyState && document.readyState === 'complete') {
          History$2.blockPopstate = false;
        }

        $(window).on('popstate', History$2.handle.bind(app));
      }
    };

    function SwipeBack(r) {
      var router = r;
      var $el = router.$el,
          $navbarsEl = router.$navbarsEl,
          app = router.app,
          params = router.params;
      var support = getSupport$1();
      var device = getDevice$1();
      var isTouched = false;
      var isMoved = false;
      var touchesStart = {};
      var isScrolling;
      var $currentPageEl = [];
      var $previousPageEl = [];
      var viewContainerWidth;
      var touchesDiff;
      var allowViewTouchMove = true;
      var touchStartTime;
      var $currentNavbarEl = [];
      var $previousNavbarEl = [];
      var dynamicNavbar;
      var $pageShadowEl;
      var $pageOpacityEl;
      var animatableNavEls;
      var paramsSwipeBackAnimateShadow = params[app.theme + "SwipeBackAnimateShadow"];
      var paramsSwipeBackAnimateOpacity = params[app.theme + "SwipeBackAnimateOpacity"];
      var paramsSwipeBackActiveArea = params[app.theme + "SwipeBackActiveArea"];
      var paramsSwipeBackThreshold = params[app.theme + "SwipeBackThreshold"];
      var transformOrigin = app.rtl ? 'right center' : 'left center';
      var transformOriginTitleLarge = app.rtl ? 'calc(100% - var(--f7-navbar-large-title-padding-left) - var(--f7-safe-area-left)) center' : 'calc(var(--f7-navbar-large-title-padding-left) + var(--f7-safe-area-left)) center';

      function animatableNavElements() {
        var els = [];
        var inverter = app.rtl ? -1 : 1;
        var currentNavIsTransparent = $currentNavbarEl.hasClass('navbar-transparent') && !$currentNavbarEl.hasClass('navbar-large') && !$currentNavbarEl.hasClass('navbar-transparent-visible');
        var currentNavIsLarge = $currentNavbarEl.hasClass('navbar-large');
        var currentNavIsCollapsed = $currentNavbarEl.hasClass('navbar-large-collapsed');
        var currentNavIsLargeTransparent = $currentNavbarEl.hasClass('navbar-large-transparent') || $currentNavbarEl.hasClass('navbar-large') && $currentNavbarEl.hasClass('navbar-transparent');
        var previousNavIsTransparent = $previousNavbarEl.hasClass('navbar-transparent') && !$previousNavbarEl.hasClass('navbar-large') && !$previousNavbarEl.hasClass('navbar-transparent-visible');
        var previousNavIsLarge = $previousNavbarEl.hasClass('navbar-large');
        var previousNavIsCollapsed = $previousNavbarEl.hasClass('navbar-large-collapsed');
        var previousNavIsLargeTransparent = $previousNavbarEl.hasClass('navbar-large-transparent') || $previousNavbarEl.hasClass('navbar-large') && $previousNavbarEl.hasClass('navbar-transparent');
        var fromLarge = currentNavIsLarge && !currentNavIsCollapsed;
        var toLarge = previousNavIsLarge && !previousNavIsCollapsed;
        var $currentNavElements = $currentNavbarEl.find('.left, .title, .right, .subnavbar, .fading, .title-large, .navbar-bg');
        var $previousNavElements = $previousNavbarEl.find('.left, .title, .right, .subnavbar, .fading, .title-large, .navbar-bg');
        var activeNavBackIconText;
        var previousNavBackIconText;

        if (params.iosAnimateNavbarBackIcon) {
          if ($currentNavbarEl.hasClass('sliding') || $currentNavbarEl.find('.navbar-inner.sliding').length) {
            activeNavBackIconText = $currentNavbarEl.find('.left').find('.back .icon + span').eq(0);
          } else {
            activeNavBackIconText = $currentNavbarEl.find('.left.sliding').find('.back .icon + span').eq(0);
          }

          if ($previousNavbarEl.hasClass('sliding') || $previousNavbarEl.find('.navbar-inner.sliding').length) {
            previousNavBackIconText = $previousNavbarEl.find('.left').find('.back .icon + span').eq(0);
          } else {
            previousNavBackIconText = $previousNavbarEl.find('.left.sliding').find('.back .icon + span').eq(0);
          }

          if (activeNavBackIconText.length) {
            $previousNavElements.each(function (el) {
              if (!$(el).hasClass('title')) return;
              el.f7NavbarLeftOffset += activeNavBackIconText.prev('.icon')[0].offsetWidth;
            });
          }
        }

        $currentNavElements.each(function (navEl) {
          var $navEl = $(navEl);
          var isSubnavbar = $navEl.hasClass('subnavbar');
          var isLeft = $navEl.hasClass('left');
          var isTitle = $navEl.hasClass('title');
          var isBg = $navEl.hasClass('navbar-bg');
          if ((isTitle || isBg) && currentNavIsTransparent) return;
          if (!fromLarge && $navEl.hasClass('.title-large')) return;
          var el = {
            el: navEl
          };

          if (fromLarge) {
            if (isTitle) return;

            if ($navEl.hasClass('title-large')) {
              if (els.indexOf(el) < 0) els.push(el);
              el.overflow = 'visible';
              $navEl.find('.title-large-text').each(function (subNavEl) {
                els.push({
                  el: subNavEl,
                  transform: function transform(progress) {
                    return "translateX(" + progress * 100 * inverter + "%)";
                  }
                });
              });
              return;
            }
          }

          if (toLarge) {
            if (!fromLarge) {
              if ($navEl.hasClass('title-large')) {
                if (els.indexOf(el) < 0) els.push(el);
                el.opacity = 0;
              }
            }

            if (isLeft) {
              if (els.indexOf(el) < 0) els.push(el);

              el.opacity = function (progress) {
                return 1 - Math.pow(progress, 0.33);
              };

              $navEl.find('.back span').each(function (subNavEl) {
                els.push({
                  el: subNavEl,
                  'transform-origin': transformOrigin,
                  transform: function transform(progress) {
                    return "translateX(calc(" + progress + " * (var(--f7-navbarTitleLargeOffset) - var(--f7-navbarLeftTextOffset)))) translateY(calc(" + progress + " * (var(--f7-navbar-large-title-height) - var(--f7-navbar-large-title-padding-vertical) / 2))) scale(" + (1 + 1 * progress) + ")";
                  }
                });
              });
              return;
            }
          }

          if (isBg) {
            if (els.indexOf(el) < 0) els.push(el);

            if (!fromLarge && !toLarge) {
              if (currentNavIsCollapsed) {
                if (currentNavIsLargeTransparent) {
                  el.className = 'ios-swipeback-navbar-bg-large';
                }

                el.transform = function (progress) {
                  return "translateX(" + 100 * progress * inverter + "%) translateY(calc(-1 * var(--f7-navbar-large-title-height)))";
                };
              } else {
                el.transform = function (progress) {
                  return "translateX(" + 100 * progress * inverter + "%)";
                };
              }
            }

            if (!fromLarge && toLarge) {
              el.className = 'ios-swipeback-navbar-bg-large';

              el.transform = function (progress) {
                return "translateX(" + 100 * progress * inverter + "%) translateY(calc(-1 * " + (1 - progress) + " * var(--f7-navbar-large-title-height)))";
              };
            }

            if (fromLarge && toLarge) {
              el.transform = function (progress) {
                return "translateX(" + 100 * progress * inverter + "%)";
              };
            }

            if (fromLarge && !toLarge) {
              el.transform = function (progress) {
                return "translateX(" + 100 * progress * inverter + "%) translateY(calc(-" + progress + " * var(--f7-navbar-large-title-height)))";
              };
            }

            return;
          }

          if ($navEl.hasClass('title-large')) return;
          var isSliding = $navEl.hasClass('sliding') || $navEl.parents('.navbar-inner.sliding').length;
          if (els.indexOf(el) < 0) els.push(el);

          if (!isSubnavbar || isSubnavbar && !isSliding) {
            el.opacity = function (progress) {
              return 1 - Math.pow(progress, 0.33);
            };
          }

          if (isSliding) {
            var transformTarget = el;

            if (isLeft && activeNavBackIconText.length && params.iosAnimateNavbarBackIcon) {
              var textEl = {
                el: activeNavBackIconText[0]
              };
              transformTarget = textEl;
              els.push(textEl);
            }

            transformTarget.transform = function (progress) {
              var activeNavTranslate = progress * transformTarget.el.f7NavbarRightOffset;
              if (device.pixelRatio === 1) activeNavTranslate = Math.round(activeNavTranslate);

              if (isSubnavbar && currentNavIsLarge) {
                return "translate3d(" + activeNavTranslate + "px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)";
              }

              return "translate3d(" + activeNavTranslate + "px,0,0)";
            };
          }
        });
        $previousNavElements.each(function (navEl) {
          var $navEl = $(navEl);
          var isSubnavbar = $navEl.hasClass('subnavbar');
          var isLeft = $navEl.hasClass('left');
          var isTitle = $navEl.hasClass('title');
          var isBg = $navEl.hasClass('navbar-bg');
          if ((isTitle || isBg) && previousNavIsTransparent) return;
          var el = {
            el: navEl
          };

          if (toLarge) {
            if (isTitle) return;
            if (els.indexOf(el) < 0) els.push(el);

            if ($navEl.hasClass('title-large')) {
              el.opacity = 1;
              el.overflow = 'visible';
              $navEl.find('.title-large-text').each(function (subNavEl) {
                els.push({
                  el: subNavEl,
                  'transform-origin': transformOriginTitleLarge,
                  opacity: function opacity(progress) {
                    return Math.pow(progress, 3);
                  },
                  transform: function transform(progress) {
                    return "translateX(calc(" + (1 - progress) + " * (var(--f7-navbarLeftTextOffset) - var(--f7-navbarTitleLargeOffset)))) translateY(calc(" + (progress - 1) + " * var(--f7-navbar-large-title-height) + " + (1 - progress) + " * var(--f7-navbar-large-title-padding-vertical))) scale(" + (0.5 + progress * 0.5) + ")";
                  }
                });
              });
              return;
            }
          }

          if (isBg) {
            if (els.indexOf(el) < 0) els.push(el);

            if (!fromLarge && !toLarge) {
              if (previousNavIsCollapsed) {
                if (previousNavIsLargeTransparent) {
                  el.className = 'ios-swipeback-navbar-bg-large';
                }

                el.transform = function (progress) {
                  return "translateX(" + (-100 + 100 * progress) * inverter + "%) translateY(calc(-1 * var(--f7-navbar-large-title-height)))";
                };
              } else {
                el.transform = function (progress) {
                  return "translateX(" + (-100 + 100 * progress) * inverter + "%)";
                };
              }
            }

            if (!fromLarge && toLarge) {
              el.transform = function (progress) {
                return "translateX(" + (-100 + 100 * progress) * inverter + "%) translateY(calc(-1 * " + (1 - progress) + " * var(--f7-navbar-large-title-height)))";
              };
            }

            if (fromLarge && !toLarge) {
              el.className = 'ios-swipeback-navbar-bg-large';

              el.transform = function (progress) {
                return "translateX(" + (-100 + 100 * progress) * inverter + "%) translateY(calc(-" + progress + " * var(--f7-navbar-large-title-height)))";
              };
            }

            if (fromLarge && toLarge) {
              el.transform = function (progress) {
                return "translateX(" + (-100 + 100 * progress) * inverter + "%)";
              };
            }

            return;
          }

          if ($navEl.hasClass('title-large')) return;
          var isSliding = $navEl.hasClass('sliding') || $previousNavbarEl.children('.navbar-inner.sliding').length;
          if (els.indexOf(el) < 0) els.push(el);

          if (!isSubnavbar || isSubnavbar && !isSliding) {
            el.opacity = function (progress) {
              return Math.pow(progress, 3);
            };
          }

          if (isSliding) {
            var transformTarget = el;

            if (isLeft && previousNavBackIconText.length && params.iosAnimateNavbarBackIcon) {
              var textEl = {
                el: previousNavBackIconText[0]
              };
              transformTarget = textEl;
              els.push(textEl);
            }

            transformTarget.transform = function (progress) {
              var previousNavTranslate = transformTarget.el.f7NavbarLeftOffset * (1 - progress);
              if (device.pixelRatio === 1) previousNavTranslate = Math.round(previousNavTranslate);

              if (isSubnavbar && previousNavIsLarge) {
                return "translate3d(" + previousNavTranslate + "px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)";
              }

              return "translate3d(" + previousNavTranslate + "px,0,0)";
            };
          }
        });
        return els;
      }

      function setAnimatableNavElements(_temp) {
        var _ref = _temp === void 0 ? {} : _temp,
            progress = _ref.progress,
            reset = _ref.reset,
            transition = _ref.transition,
            reflow = _ref.reflow;

        var styles = ['overflow', 'transform', 'transform-origin', 'opacity'];

        if (transition === true || transition === false) {
          for (var i = 0; i < animatableNavEls.length; i += 1) {
            var el = animatableNavEls[i];

            if (el && el.el) {
              if (transition === true) el.el.classList.add('navbar-page-transitioning');
              if (transition === false) el.el.classList.remove('navbar-page-transitioning');
            }
          }
        }

        if (reflow && animatableNavEls.length && animatableNavEls[0] && animatableNavEls[0].el) {
          // eslint-disable-next-line
          animatableNavEls[0].el._clientLeft = animatableNavEls[0].el.clientLeft;
        }

        for (var _i = 0; _i < animatableNavEls.length; _i += 1) {
          var _el = animatableNavEls[_i];

          if (_el && _el.el) {
            if (_el.className && !_el.classNameSet && !reset) {
              _el.el.classList.add(_el.className);

              _el.classNameSet = true;
            }

            if (_el.className && reset) {
              _el.el.classList.remove(_el.className);
            }

            for (var j = 0; j < styles.length; j += 1) {
              var styleProp = styles[j];

              if (_el[styleProp]) {
                if (reset) {
                  _el.el.style[styleProp] = '';
                } else if (typeof _el[styleProp] === 'function') {
                  _el.el.style[styleProp] = _el[styleProp](progress);
                } else {
                  _el.el.style[styleProp] = _el[styleProp];
                }
              }
            }
          }
        }
      }

      function handleTouchStart(e) {
        var swipeBackEnabled = params[app.theme + "SwipeBack"];
        if (!allowViewTouchMove || !swipeBackEnabled || isTouched || app.swipeout && app.swipeout.el || !router.allowPageChange) return;
        if ($(e.target).closest('.range-slider, .calendar-months').length > 0) return;
        if ($(e.target).closest('.page-master, .page-master-detail').length > 0 && params.masterDetailBreakpoint > 0 && app.width >= params.masterDetailBreakpoint) return;
        isMoved = false;
        isTouched = true;
        isScrolling = undefined;
        touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
        touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
        touchStartTime = now$1();
        dynamicNavbar = router.dynamicNavbar;
      }

      function handleTouchMove(e) {
        if (!isTouched) return;
        var pageX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
        var pageY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

        if (typeof isScrolling === 'undefined') {
          isScrolling = !!(isScrolling || Math.abs(pageY - touchesStart.y) > Math.abs(pageX - touchesStart.x)) || pageX < touchesStart.x && !app.rtl || pageX > touchesStart.x && app.rtl;
        }

        if (isScrolling || e.f7PreventSwipeBack || app.preventSwipeBack) {
          isTouched = false;
          return;
        }

        if (!isMoved) {
          // Calc values during first move fired
          var cancel = false;
          var target = $(e.target);
          var swipeout = target.closest('.swipeout');

          if (swipeout.length > 0) {
            if (!app.rtl && swipeout.find('.swipeout-actions-left').length > 0) cancel = true;
            if (app.rtl && swipeout.find('.swipeout-actions-right').length > 0) cancel = true;
          }

          $currentPageEl = target.closest('.page');
          if ($currentPageEl.hasClass('no-swipeback') || target.closest('.no-swipeback, .card-opened').length > 0) cancel = true;
          $previousPageEl = $el.find('.page-previous:not(.stacked)');

          if ($previousPageEl.length > 1) {
            $previousPageEl = $previousPageEl.eq($previousPageEl.length - 1);
          }

          var notFromBorder = touchesStart.x - $el.offset().left > paramsSwipeBackActiveArea;
          viewContainerWidth = $el.width();

          if (app.rtl) {
            notFromBorder = touchesStart.x < $el.offset().left - $el[0].scrollLeft + (viewContainerWidth - paramsSwipeBackActiveArea);
          } else {
            notFromBorder = touchesStart.x - $el.offset().left > paramsSwipeBackActiveArea;
          }

          if (notFromBorder) cancel = true;
          if ($previousPageEl.length === 0 || $currentPageEl.length === 0) cancel = true;

          if (cancel) {
            isTouched = false;
            return;
          }

          if (paramsSwipeBackAnimateShadow) {
            $pageShadowEl = $currentPageEl.find('.page-shadow-effect');

            if ($pageShadowEl.length === 0) {
              $pageShadowEl = $('<div class="page-shadow-effect"></div>');
              $currentPageEl.append($pageShadowEl);
            }
          }

          if (paramsSwipeBackAnimateOpacity) {
            $pageOpacityEl = $previousPageEl.find('.page-opacity-effect');

            if ($pageOpacityEl.length === 0) {
              $pageOpacityEl = $('<div class="page-opacity-effect"></div>');
              $previousPageEl.append($pageOpacityEl);
            }
          }

          if (dynamicNavbar) {
            $currentNavbarEl = $navbarsEl.find('.navbar-current:not(.stacked)');
            $previousNavbarEl = $navbarsEl.find('.navbar-previous:not(.stacked)');

            if ($previousNavbarEl.length > 1) {
              $previousNavbarEl = $previousNavbarEl.eq($previousNavbarEl.length - 1);
            }

            animatableNavEls = animatableNavElements($previousNavbarEl, $currentNavbarEl);
          } // Close/Hide Any Picker


          if ($('.sheet.modal-in').length > 0 && app.sheet) {
            app.sheet.close($('.sheet.modal-in'));
          }
        }

        e.f7PreventSwipePanel = true;
        isMoved = true;
        app.preventSwipePanelBySwipeBack = true;
        e.preventDefault(); // RTL inverter

        var inverter = app.rtl ? -1 : 1; // Touches diff

        touchesDiff = (pageX - touchesStart.x - paramsSwipeBackThreshold) * inverter;
        if (touchesDiff < 0) touchesDiff = 0;
        var percentage = Math.min(Math.max(touchesDiff / viewContainerWidth, 0), 1); // Swipe Back Callback

        var callbackData = {
          percentage: percentage,
          progress: percentage,
          currentPageEl: $currentPageEl[0],
          previousPageEl: $previousPageEl[0],
          currentNavbarEl: $currentNavbarEl[0],
          previousNavbarEl: $previousNavbarEl[0]
        };
        $el.trigger('swipeback:move', callbackData);
        router.emit('swipebackMove', callbackData); // Transform pages

        var currentPageTranslate = touchesDiff * inverter;
        var previousPageTranslate = (touchesDiff / 5 - viewContainerWidth / 5) * inverter;

        if (!app.rtl) {
          currentPageTranslate = Math.min(currentPageTranslate, viewContainerWidth);
          previousPageTranslate = Math.min(previousPageTranslate, 0);
        } else {
          currentPageTranslate = Math.max(currentPageTranslate, -viewContainerWidth);
          previousPageTranslate = Math.max(previousPageTranslate, 0);
        }

        if (device.pixelRatio === 1) {
          currentPageTranslate = Math.round(currentPageTranslate);
          previousPageTranslate = Math.round(previousPageTranslate);
        }

        router.swipeBackActive = true;
        $([$currentPageEl[0], $previousPageEl[0]]).addClass('page-swipeback-active');
        $currentPageEl.transform("translate3d(" + currentPageTranslate + "px,0,0)");
        if (paramsSwipeBackAnimateShadow) $pageShadowEl[0].style.opacity = 1 - 1 * percentage;

        if (app.theme === 'ios') {
          $previousPageEl.transform("translate3d(" + previousPageTranslate + "px,0,0)");
        }

        if (paramsSwipeBackAnimateOpacity) $pageOpacityEl[0].style.opacity = 1 - 1 * percentage; // Dynamic Navbars Animation

        if (!dynamicNavbar) return;
        setAnimatableNavElements({
          progress: percentage
        });
      }

      function handleTouchEnd() {
        app.preventSwipePanelBySwipeBack = false;

        if (!isTouched || !isMoved) {
          isTouched = false;
          isMoved = false;
          return;
        }

        isTouched = false;
        isMoved = false;
        router.swipeBackActive = false;
        var $pages = $([$currentPageEl[0], $previousPageEl[0]]);
        $pages.removeClass('page-swipeback-active');

        if (touchesDiff === 0) {
          $pages.transform('');
          if ($pageShadowEl && $pageShadowEl.length > 0) $pageShadowEl.remove();
          if ($pageOpacityEl && $pageOpacityEl.length > 0) $pageOpacityEl.remove();

          if (dynamicNavbar) {
            setAnimatableNavElements({
              reset: true
            });
          }

          return;
        }

        var timeDiff = now$1() - touchStartTime;
        var pageChanged = false; // Swipe back to previous page

        if (timeDiff < 300 && touchesDiff > 10 || timeDiff >= 300 && touchesDiff > viewContainerWidth / 2) {
          $currentPageEl.removeClass('page-current').addClass("page-next" + (app.theme !== 'ios' ? ' page-next-on-right' : ''));
          $previousPageEl.removeClass('page-previous').addClass('page-current').removeAttr('aria-hidden');
          if ($pageShadowEl) $pageShadowEl[0].style.opacity = '';
          if ($pageOpacityEl) $pageOpacityEl[0].style.opacity = '';

          if (dynamicNavbar) {
            router.setNavbarPosition($currentNavbarEl, 'next');
            router.setNavbarPosition($previousNavbarEl, 'current', false);
          }

          pageChanged = true;
        } // Reset custom styles
        // Add transitioning class for transition-duration


        $pages.addClass('page-transitioning page-transitioning-swipeback');

        if (device.ios) {
          // eslint-disable-next-line
          $currentPageEl[0]._clientLeft = $currentPageEl[0].clientLeft;
        }

        $pages.transform('');

        if (dynamicNavbar) {
          setAnimatableNavElements({
            progress: pageChanged ? 1 : 0,
            transition: true,
            reflow: !!device.ios
          });
        }

        allowViewTouchMove = false;
        router.allowPageChange = false; // Swipe Back Callback

        var callbackData = {
          currentPageEl: $currentPageEl[0],
          previousPageEl: $previousPageEl[0],
          currentNavbarEl: $currentNavbarEl[0],
          previousNavbarEl: $previousNavbarEl[0]
        };

        if (pageChanged) {
          // Update Route
          router.currentRoute = $previousPageEl[0].f7Page.route;
          router.currentPage = $previousPageEl[0]; // Page before animation callback

          router.pageCallback('beforeOut', $currentPageEl, $currentNavbarEl, 'current', 'next', {
            route: $currentPageEl[0].f7Page.route,
            swipeBack: true
          });
          router.pageCallback('beforeIn', $previousPageEl, $previousNavbarEl, 'previous', 'current', {
            route: $previousPageEl[0].f7Page.route,
            swipeBack: true
          }, $currentPageEl[0]);
          $el.trigger('swipeback:beforechange', callbackData);
          router.emit('swipebackBeforeChange', callbackData);
        } else {
          $el.trigger('swipeback:beforereset', callbackData);
          router.emit('swipebackBeforeReset', callbackData);
        }

        $currentPageEl.transitionEnd(function () {
          $pages.removeClass('page-transitioning page-transitioning-swipeback');

          if (dynamicNavbar) {
            setAnimatableNavElements({
              reset: true,
              transition: false
            });
          }

          allowViewTouchMove = true;
          router.allowPageChange = true;

          if (pageChanged) {
            // Update History
            if (router.history.length === 1) {
              router.history.unshift(router.url);
            }

            router.history.pop();
            router.saveHistory(); // Update push state

            if (params.browserHistory) {
              History$2.back();
            } // Page after animation callback


            router.pageCallback('afterOut', $currentPageEl, $currentNavbarEl, 'current', 'next', {
              route: $currentPageEl[0].f7Page.route,
              swipeBack: true
            });
            router.pageCallback('afterIn', $previousPageEl, $previousNavbarEl, 'previous', 'current', {
              route: $previousPageEl[0].f7Page.route,
              swipeBack: true
            }); // Remove Old Page

            if (params.stackPages && router.initialPages.indexOf($currentPageEl[0]) >= 0) {
              $currentPageEl.addClass('stacked');

              if (dynamicNavbar) {
                $currentNavbarEl.addClass('stacked');
              }
            } else {
              router.pageCallback('beforeRemove', $currentPageEl, $currentNavbarEl, 'next', {
                swipeBack: true
              });
              router.removePage($currentPageEl);

              if (dynamicNavbar) {
                router.removeNavbar($currentNavbarEl);
              }
            }

            $el.trigger('swipeback:afterchange', callbackData);
            router.emit('swipebackAfterChange', callbackData);
            router.emit('routeChanged', router.currentRoute, router.previousRoute, router);

            if (params.preloadPreviousPage) {
              router.back(router.history[router.history.length - 2], {
                preload: true
              });
            }
          } else {
            $el.trigger('swipeback:afterreset', callbackData);
            router.emit('swipebackAfterReset', callbackData);
          }

          if ($pageShadowEl && $pageShadowEl.length > 0) $pageShadowEl.remove();
          if ($pageOpacityEl && $pageOpacityEl.length > 0) $pageOpacityEl.remove();
        });
      }

      function attachEvents() {
        var passiveListener = app.touchEvents.start === 'touchstart' && support.passiveListener ? {
          passive: true,
          capture: false
        } : false;
        $el.on(app.touchEvents.start, handleTouchStart, passiveListener);
        app.on('touchmove:active', handleTouchMove);
        app.on('touchend:passive', handleTouchEnd);
      }

      function detachEvents() {
        var passiveListener = app.touchEvents.start === 'touchstart' && support.passiveListener ? {
          passive: true,
          capture: false
        } : false;
        $el.off(app.touchEvents.start, handleTouchStart, passiveListener);
        app.off('touchmove:active', handleTouchMove);
        app.off('touchend:passive', handleTouchEnd);
      }

      attachEvents();
      router.on('routerDestroy', detachEvents);
    }

    function redirect(direction, route, options) {
      var router = this;
      var r = route.route.redirect;
      var method = direction === 'forward' ? 'navigate' : 'back';

      if (options.initial && router.params.browserHistory) {
        options.replaceState = true; // eslint-disable-line

        options.history = true; // eslint-disable-line
      }

      function redirectResolve(redirectUrl, redirectOptions) {
        if (redirectOptions === void 0) {
          redirectOptions = {};
        }

        router.allowPageChange = true;
        router[method](redirectUrl, extend$1({}, options, redirectOptions));
      }

      function redirectReject() {
        router.allowPageChange = true;
      }

      if (typeof r === 'function') {
        router.allowPageChange = false;
        var redirectUrl = r.call(router, {
          router: router,
          to: route,
          resolve: redirectResolve,
          reject: redirectReject,
          direction: direction,
          app: router.app
        });

        if (redirectUrl && typeof redirectUrl === 'string') {
          router.allowPageChange = true;
          return router[method](redirectUrl, options);
        }

        return router;
      }

      return router[method](r, options);
    }

    function processQueue(router, routerQueue, routeQueue, to, from, resolve, _reject, direction) {
      var queue = [];

      if (Array.isArray(routeQueue)) {
        queue.push.apply(queue, routeQueue);
      } else if (routeQueue && typeof routeQueue === 'function') {
        queue.push(routeQueue);
      }

      if (routerQueue) {
        if (Array.isArray(routerQueue)) {
          queue.push.apply(queue, routerQueue);
        } else {
          queue.push(routerQueue);
        }
      }

      function next() {
        if (queue.length === 0) {
          resolve();
          return;
        }

        var queueItem = queue.shift();
        queueItem.call(router, {
          router: router,
          to: to,
          from: from,
          resolve: function resolve() {
            next();
          },
          reject: function reject() {
            _reject();
          },
          direction: direction,
          app: router.app
        });
      }

      next();
    }

    function processRouteQueue(to, from, resolve, reject, direction) {
      var router = this;

      function enterNextRoute() {
        if (to && to.route && (router.params.routesBeforeEnter || to.route.beforeEnter)) {
          router.allowPageChange = false;
          processQueue(router, router.params.routesBeforeEnter, to.route.beforeEnter, to, from, function () {
            router.allowPageChange = true;
            resolve();
          }, function () {
            reject();
          }, direction);
        } else {
          resolve();
        }
      }

      function leaveCurrentRoute() {
        if (from && from.route && (router.params.routesBeforeLeave || from.route.beforeLeave)) {
          router.allowPageChange = false;
          processQueue(router, router.params.routesBeforeLeave, from.route.beforeLeave, to, from, function () {
            router.allowPageChange = true;
            enterNextRoute();
          }, function () {
            reject();
          }, direction);
        } else {
          enterNextRoute();
        }
      }

      leaveCurrentRoute();
    }

    function appRouterCheck(router, method) {
      if (!router.view) {
        throw new Error("Framework7: it is not allowed to use router methods on global app router. Use router methods only on related View, e.g. app.views.main.router." + method + "(...)");
      }
    }

    function asyncComponent(router, component, resolve, reject) {
      function resolvePromise(componentPromise) {
        componentPromise.then(function (c) {
          // eslint-disable-next-line
          resolve({
            component: c.default || c._default || c
          });
        }).catch(function (err) {
          reject();
          throw new Error(err);
        });
      }

      if (component instanceof Promise) {
        resolvePromise(component);
        return;
      }

      var asyncComponentResult = component.call(router);

      if (asyncComponentResult instanceof Promise) {
        resolvePromise(asyncComponentResult);
      } else {
        resolve({
          component: asyncComponentResult
        });
      }
    }

    function refreshPage() {
      var router = this;
      appRouterCheck(router, 'refreshPage');
      return router.navigate(router.currentRoute.url, {
        ignoreCache: true,
        reloadCurrent: true
      });
    }

    function forward(router, el, forwardOptions) {
      if (forwardOptions === void 0) {
        forwardOptions = {};
      }

      var document = getDocument();
      var $el = $(el);
      var app = router.app;
      var view = router.view;
      var options = extend$1(false, {
        animate: router.params.animate,
        browserHistory: true,
        replaceState: false,
        history: true,
        reloadCurrent: router.params.reloadPages,
        reloadPrevious: false,
        reloadAll: false,
        clearPreviousHistory: false,
        reloadDetail: router.params.reloadDetail,
        on: {}
      }, forwardOptions);
      var masterDetailEnabled = router.params.masterDetailBreakpoint > 0;
      var isMaster = masterDetailEnabled && options.route && options.route.route && (options.route.route.master === true || typeof options.route.route.master === 'function' && options.route.route.master(app, router));
      var masterPageEl;
      var otherDetailPageEl;
      var detailsInBetweenRemoved = 0;
      var currentRouteIsModal = router.currentRoute.modal;
      var modalType;

      if (!currentRouteIsModal) {
        'popup popover sheet loginScreen actions customModal panel'.split(' ').forEach(function (modalLoadProp) {
          if (router.currentRoute && router.currentRoute.route && router.currentRoute.route[modalLoadProp]) {
            currentRouteIsModal = true;
            modalType = modalLoadProp;
          }
        });
      }

      if (currentRouteIsModal) {
        var modalToClose = router.currentRoute.modal || router.currentRoute.route.modalInstance || app[modalType].get();
        var previousUrl = router.history[router.history.length - 2];
        var previousRoute = router.findMatchingRoute(previousUrl);

        if (!previousRoute && previousUrl) {
          previousRoute = {
            url: previousUrl,
            path: previousUrl.split('?')[0],
            query: parseUrlQuery(previousUrl),
            route: {
              path: previousUrl.split('?')[0],
              url: previousUrl
            }
          };
        }

        router.modalRemove(modalToClose);
      }

      var dynamicNavbar = router.dynamicNavbar;
      var $viewEl = router.$el;
      var $newPage = $el;
      var reload = options.reloadPrevious || options.reloadCurrent || options.reloadAll;
      var $oldPage;
      var $navbarsEl;
      var $newNavbarEl;
      var $oldNavbarEl;
      router.allowPageChange = false;

      if ($newPage.length === 0) {
        router.allowPageChange = true;
        return router;
      }

      if ($newPage.length) {
        // Remove theme elements
        router.removeThemeElements($newPage);
      }

      if (dynamicNavbar) {
        $newNavbarEl = $newPage.children('.navbar');
        $navbarsEl = router.$navbarsEl;

        if ($newNavbarEl.length === 0 && $newPage[0] && $newPage[0].f7Page) {
          // Try from pageData
          $newNavbarEl = $newPage[0].f7Page.$navbarEl;
        }
      } // Save Keep Alive Cache


      if (options.route && options.route.route && options.route.route.keepAlive && !options.route.route.keepAliveData) {
        options.route.route.keepAliveData = {
          pageEl: $el[0]
        };
      } // Pages In View


      var $pagesInView = $viewEl.children('.page:not(.stacked)').filter(function (pageInView) {
        return pageInView !== $newPage[0];
      }); // Navbars In View

      var $navbarsInView;

      if (dynamicNavbar) {
        $navbarsInView = $navbarsEl.children('.navbar:not(.stacked)').filter(function (navbarInView) {
          return navbarInView !== $newNavbarEl[0];
        });
      } // Exit when reload previous and only 1 page in view so nothing ro reload


      if (options.reloadPrevious && $pagesInView.length < 2) {
        router.allowPageChange = true;
        return router;
      } // Find Detail' master page


      var isDetail;
      var reloadDetail;
      var isDetailRoot;

      if (masterDetailEnabled && !options.reloadAll) {
        for (var i = 0; i < $pagesInView.length; i += 1) {
          if (!masterPageEl && $pagesInView[i].classList.contains('page-master')) {
            masterPageEl = $pagesInView[i];
            continue; // eslint-disable-line
          }
        }

        isDetail = !isMaster && masterPageEl;

        if (isDetail) {
          // Find Other Detail
          if (masterPageEl) {
            for (var _i = 0; _i < $pagesInView.length; _i += 1) {
              if ($pagesInView[_i].classList.contains('page-master-detail')) {
                otherDetailPageEl = $pagesInView[_i];
                continue; // eslint-disable-line
              }
            }
          }
        }

        reloadDetail = isDetail && options.reloadDetail && app.width >= router.params.masterDetailBreakpoint && masterPageEl;
      }

      if (isDetail) {
        isDetailRoot = !otherDetailPageEl || reloadDetail || options.reloadAll || options.reloadCurrent;
      } // New Page


      var newPagePosition = 'next';

      if (options.reloadCurrent || options.reloadAll || reloadDetail) {
        newPagePosition = 'current';
      } else if (options.reloadPrevious) {
        newPagePosition = 'previous';
      }

      $newPage.removeClass('page-previous page-current page-next').addClass("page-" + newPagePosition + (isMaster ? ' page-master' : '') + (isDetail ? ' page-master-detail' : '') + (isDetailRoot ? ' page-master-detail-root' : '')).removeClass('stacked').trigger('page:unstack').trigger('page:position', {
        position: newPagePosition
      });
      router.emit('pageUnstack', $newPage[0]);
      router.emit('pagePosition', $newPage[0], newPagePosition);

      if (isMaster || isDetail) {
        $newPage.trigger('page:role', {
          role: isMaster ? 'master' : 'detail',
          root: !!isDetailRoot
        });
        router.emit('pageRole', $newPage[0], {
          role: isMaster ? 'master' : 'detail',
          detailRoot: !!isDetailRoot
        });
      }

      if (dynamicNavbar && $newNavbarEl.length) {
        $newNavbarEl.removeClass('navbar-previous navbar-current navbar-next').addClass("navbar-" + newPagePosition + (isMaster ? ' navbar-master' : '') + (isDetail ? ' navbar-master-detail' : '') + (isDetailRoot ? ' navbar-master-detail-root' : '')).removeClass('stacked');
        $newNavbarEl.trigger('navbar:position', {
          position: newPagePosition
        });
        router.emit('navbarPosition', $newNavbarEl[0], newPagePosition);

        if (isMaster || isDetail) {
          router.emit('navbarRole', $newNavbarEl[0], {
            role: isMaster ? 'master' : 'detail',
            detailRoot: !!isDetailRoot
          });
        }
      } // Find Old Page


      if (options.reloadCurrent || reloadDetail) {
        if (reloadDetail) {
          $oldPage = $pagesInView.filter(function (pageEl) {
            return !pageEl.classList.contains('page-master');
          });

          if (dynamicNavbar) {
            $oldNavbarEl = $($oldPage.map(function (pageEl) {
              return app.navbar.getElByPage(pageEl);
            }));
          }

          if ($oldPage.length > 1 && masterPageEl) {
            detailsInBetweenRemoved = $oldPage.length - 1;
            $(masterPageEl).removeClass('page-master-stacked').trigger('page:masterunstack');
            router.emit('pageMasterUnstack', masterPageEl);

            if (dynamicNavbar) {
              $(app.navbar.getElByPage(masterPageEl)).removeClass('navbar-master-stacked');
              router.emit('navbarMasterUnstack', app.navbar.getElByPage(masterPageEl));
            }
          }
        } else {
          $oldPage = $pagesInView.eq($pagesInView.length - 1);

          if (dynamicNavbar) {
            $oldNavbarEl = $(app.navbar.getElByPage($oldPage));
          }
        }
      } else if (options.reloadPrevious) {
        $oldPage = $pagesInView.eq($pagesInView.length - 2);

        if (dynamicNavbar) {
          // $oldNavbarEl = $navbarsInView.eq($pagesInView.length - 2);
          $oldNavbarEl = $(app.navbar.getElByPage($oldPage));
        }
      } else if (options.reloadAll) {
        $oldPage = $pagesInView.filter(function (pageEl) {
          return pageEl !== $newPage[0];
        });

        if (dynamicNavbar) {
          $oldNavbarEl = $navbarsInView.filter(function (navbarEl) {
            return navbarEl !== $newNavbarEl[0];
          });
        }
      } else {
        var removedPageEls = [];
        var removedNavbarEls = [];

        if ($pagesInView.length > 1) {
          var _i2 = 0;

          for (_i2 = 0; _i2 < $pagesInView.length - 1; _i2 += 1) {
            if (masterPageEl && $pagesInView[_i2] === masterPageEl) {
              $pagesInView.eq(_i2).addClass('page-master-stacked');
              $pagesInView.eq(_i2).trigger('page:masterstack');
              router.emit('pageMasterStack', $pagesInView[_i2]);

              if (dynamicNavbar) {
                $(app.navbar.getElByPage(masterPageEl)).addClass('navbar-master-stacked');
                router.emit('navbarMasterStack', app.navbar.getElByPage(masterPageEl));
              }

              continue; // eslint-disable-line
            }

            var oldNavbarEl = app.navbar.getElByPage($pagesInView.eq(_i2));

            if (router.params.stackPages) {
              $pagesInView.eq(_i2).addClass('stacked');
              $pagesInView.eq(_i2).trigger('page:stack');
              router.emit('pageStack', $pagesInView[_i2]);

              if (dynamicNavbar) {
                $(oldNavbarEl).addClass('stacked');
              }
            } else {
              // Page remove event
              removedPageEls.push($pagesInView[_i2]);
              router.pageCallback('beforeRemove', $pagesInView[_i2], $navbarsInView && $navbarsInView[_i2], 'previous', undefined, options);
              router.removePage($pagesInView[_i2]);

              if (dynamicNavbar && oldNavbarEl) {
                removedNavbarEls.push(oldNavbarEl);
                router.removeNavbar(oldNavbarEl);
              }
            }
          }
        }

        $oldPage = $viewEl.children('.page:not(.stacked)').filter(function (pageEl) {
          return pageEl !== $newPage[0] && removedPageEls.indexOf(pageEl) < 0;
        });

        if (dynamicNavbar) {
          $oldNavbarEl = $navbarsEl.children('.navbar:not(.stacked)').filter(function (navbarEl) {
            return navbarEl !== $newNavbarEl[0] && removedNavbarEls.indexOf(removedNavbarEls) < 0;
          });
        }

        removedPageEls = [];
        removedNavbarEls = [];
      }

      if (isDetail && !options.reloadAll) {
        if ($oldPage.length > 1 || reloadDetail) {
          $oldPage = $oldPage.filter(function (pageEl) {
            return !pageEl.classList.contains('page-master');
          });
        }

        if ($oldNavbarEl && ($oldNavbarEl.length > 1 || reloadDetail)) {
          $oldNavbarEl = $oldNavbarEl.filter(function (navbarEl) {
            return !navbarEl.classList.contains('navbar-master');
          });
        }
      } // Push State


      if (router.params.browserHistory && (options.browserHistory || options.replaceState) && !options.reloadPrevious) {
        var browserHistoryRoot = router.params.browserHistoryRoot || '';
        History$2[options.reloadCurrent || reloadDetail && otherDetailPageEl || options.reloadAll || options.replaceState ? 'replace' : 'push'](view.id, {
          url: options.route.url
        }, browserHistoryRoot + router.params.browserHistorySeparator + options.route.url);
      }

      if (!options.reloadPrevious) {
        // Current Page & Navbar
        router.currentPageEl = $newPage[0];

        if (dynamicNavbar && $newNavbarEl.length) {
          router.currentNavbarEl = $newNavbarEl[0];
        } else {
          delete router.currentNavbarEl;
        } // Current Route


        router.currentRoute = options.route;
      } // Update router history


      var url = options.route.url;

      if (options.history) {
        if (((options.reloadCurrent || reloadDetail && otherDetailPageEl) && router.history.length) > 0 || options.replaceState) {
          if (reloadDetail && detailsInBetweenRemoved > 0) {
            router.history = router.history.slice(0, router.history.length - detailsInBetweenRemoved);
          }

          router.history[router.history.length - (options.reloadPrevious ? 2 : 1)] = url;
        } else if (options.reloadPrevious) {
          router.history[router.history.length - 2] = url;
        } else if (options.reloadAll) {
          router.history = [url];
        } else {
          router.history.push(url);
        }
      }

      router.saveHistory(); // Insert new page and navbar

      var newPageInDom = $newPage.parents(document).length > 0;
      var f7Component = $newPage[0].f7Component;

      if (options.reloadPrevious) {
        if (f7Component && !newPageInDom) {
          f7Component.mount(function (componentEl) {
            $(componentEl).insertBefore($oldPage);
          });
        } else {
          $newPage.insertBefore($oldPage);
        }

        if (dynamicNavbar && $newNavbarEl.length) {
          if ($newNavbarEl.find('.title-large').length) {
            $newNavbarEl.addClass('navbar-large');
          }

          if ($oldNavbarEl.length) {
            $newNavbarEl.insertBefore($oldNavbarEl);
          } else {
            if (!router.$navbarsEl.parents(document).length) {
              router.$el.prepend(router.$navbarsEl);
            }

            $navbarsEl.append($newNavbarEl);
          }
        }
      } else {
        if ($oldPage.next('.page')[0] !== $newPage[0]) {
          if (f7Component && !newPageInDom) {
            f7Component.mount(function (componentEl) {
              $viewEl.append(componentEl);
            });
          } else {
            $viewEl.append($newPage[0]);
          }
        }

        if (dynamicNavbar && $newNavbarEl.length) {
          if ($newNavbarEl.find('.title-large').length) {
            $newNavbarEl.addClass('navbar-large');
          }

          if (!router.$navbarsEl.parents(document).length) {
            router.$el.prepend(router.$navbarsEl);
          }

          $navbarsEl.append($newNavbarEl[0]);
        }
      }

      if (!newPageInDom) {
        router.pageCallback('mounted', $newPage, $newNavbarEl, newPagePosition, reload ? newPagePosition : 'current', options, $oldPage);
      } else if (options.route && options.route.route && options.route.route.keepAlive && !$newPage[0].f7PageMounted) {
        $newPage[0].f7PageMounted = true;
        router.pageCallback('mounted', $newPage, $newNavbarEl, newPagePosition, reload ? newPagePosition : 'current', options, $oldPage);
      } // Remove old page


      if ((options.reloadCurrent || reloadDetail) && $oldPage.length > 0) {
        if (router.params.stackPages && router.initialPages.indexOf($oldPage[0]) >= 0) {
          $oldPage.addClass('stacked');
          $oldPage.trigger('page:stack');
          router.emit('pageStack', $oldPage[0]);

          if (dynamicNavbar) {
            $oldNavbarEl.addClass('stacked');
          }
        } else {
          // Page remove event
          router.pageCallback('beforeOut', $oldPage, $oldNavbarEl, 'current', undefined, options);
          router.pageCallback('afterOut', $oldPage, $oldNavbarEl, 'current', undefined, options);
          router.pageCallback('beforeRemove', $oldPage, $oldNavbarEl, 'current', undefined, options);
          router.removePage($oldPage);

          if (dynamicNavbar && $oldNavbarEl && $oldNavbarEl.length) {
            router.removeNavbar($oldNavbarEl);
          }
        }
      } else if (options.reloadAll) {
        $oldPage.each(function (pageEl, index) {
          var $oldPageEl = $(pageEl);
          var $oldNavbarElEl = $(app.navbar.getElByPage($oldPageEl));

          if (router.params.stackPages && router.initialPages.indexOf($oldPageEl[0]) >= 0) {
            $oldPageEl.addClass('stacked');
            $oldPageEl.trigger('page:stack');
            router.emit('pageStack', $oldPageEl[0]);

            if (dynamicNavbar) {
              $oldNavbarElEl.addClass('stacked');
            }
          } else {
            // Page remove event
            if ($oldPageEl.hasClass('page-current')) {
              router.pageCallback('beforeOut', $oldPage, $oldNavbarEl, 'current', undefined, options);
              router.pageCallback('afterOut', $oldPage, $oldNavbarEl, 'current', undefined, options);
            }

            router.pageCallback('beforeRemove', $oldPageEl, $oldNavbarEl && $oldNavbarEl.eq(index), 'previous', undefined, options);
            router.removePage($oldPageEl);

            if (dynamicNavbar && $oldNavbarElEl.length) {
              router.removeNavbar($oldNavbarElEl);
            }
          }
        });
      } else if (options.reloadPrevious) {
        if (router.params.stackPages && router.initialPages.indexOf($oldPage[0]) >= 0) {
          $oldPage.addClass('stacked');
          $oldPage.trigger('page:stack');
          router.emit('pageStack', $oldPage[0]);

          if (dynamicNavbar) {
            $oldNavbarEl.addClass('stacked');
          }
        } else {
          // Page remove event
          router.pageCallback('beforeRemove', $oldPage, $oldNavbarEl, 'previous', undefined, options);
          router.removePage($oldPage);

          if (dynamicNavbar && $oldNavbarEl && $oldNavbarEl.length) {
            router.removeNavbar($oldNavbarEl);
          }
        }
      } // Load Tab


      if (options.route.route.tab) {
        router.tabLoad(options.route.route.tab, extend$1({}, options, {
          history: false,
          browserHistory: false
        }));
      } // Check master detail


      if (masterDetailEnabled) {
        view.checkMasterDetailBreakpoint();
      } // Page init and before init events


      router.pageCallback('init', $newPage, $newNavbarEl, newPagePosition, reload ? newPagePosition : 'current', options, $oldPage);

      if (options.reloadCurrent || options.reloadAll || reloadDetail) {
        router.allowPageChange = true;
        router.pageCallback('beforeIn', $newPage, $newNavbarEl, newPagePosition, 'current', options);
        $newPage.removeAttr('aria-hidden');

        if (dynamicNavbar && $newNavbarEl) {
          $newNavbarEl.removeAttr('aria-hidden');
        }

        router.pageCallback('afterIn', $newPage, $newNavbarEl, newPagePosition, 'current', options);
        if (options.reloadCurrent && options.clearPreviousHistory) router.clearPreviousHistory();

        if (reloadDetail) {
          router.setPagePosition($(masterPageEl), 'previous');

          if (masterPageEl.f7Page && masterPageEl.f7Page.navbarEl) {
            router.setNavbarPosition($(masterPageEl.f7Page.navbarEl), 'previous');
          }
        }

        return router;
      }

      if (options.reloadPrevious) {
        router.allowPageChange = true;
        return router;
      } // Before animation event


      router.pageCallback('beforeOut', $oldPage, $oldNavbarEl, 'current', 'previous', options);
      router.pageCallback('beforeIn', $newPage, $newNavbarEl, 'next', 'current', options); // Animation

      function afterAnimation() {
        router.setPagePosition($newPage, 'current', false);
        router.setPagePosition($oldPage, 'previous', !$oldPage.hasClass('page-master'));

        if (dynamicNavbar) {
          router.setNavbarPosition($newNavbarEl, 'current', false);
          router.setNavbarPosition($oldNavbarEl, 'previous', !$oldNavbarEl.hasClass('navbar-master'));
        } // After animation event


        router.allowPageChange = true;
        router.pageCallback('afterOut', $oldPage, $oldNavbarEl, 'current', 'previous', options);
        router.pageCallback('afterIn', $newPage, $newNavbarEl, 'next', 'current', options);
        var keepOldPage = (router.params.preloadPreviousPage || router.params[app.theme + "SwipeBack"]) && !isMaster;

        if (!keepOldPage) {
          if ($newPage.hasClass('smart-select-page') || $newPage.hasClass('photo-browser-page') || $newPage.hasClass('autocomplete-page') || $newPage.hasClass('color-picker-page')) {
            keepOldPage = true;
          }
        }

        if (!keepOldPage) {
          if (router.params.stackPages) {
            $oldPage.addClass('stacked');
            $oldPage.trigger('page:stack');
            router.emit('pageStack', $oldPage[0]);

            if (dynamicNavbar) {
              $oldNavbarEl.addClass('stacked');
            }
          } else if (!($newPage.attr('data-name') && $newPage.attr('data-name') === 'smart-select-page')) {
            // Remove event
            router.pageCallback('beforeRemove', $oldPage, $oldNavbarEl, 'previous', undefined, options);
            router.removePage($oldPage);

            if (dynamicNavbar && $oldNavbarEl.length) {
              router.removeNavbar($oldNavbarEl);
            }
          }
        }

        if (options.clearPreviousHistory) router.clearPreviousHistory();
        router.emit('routeChanged', router.currentRoute, router.previousRoute, router);

        if (router.params.browserHistory) {
          History$2.clearRouterQueue();
        }
      }

      function setPositionClasses() {
        router.setPagePosition($oldPage, 'current', false);
        router.setPagePosition($newPage, 'next', false);

        if (dynamicNavbar) {
          router.setNavbarPosition($oldNavbarEl, 'current', false);
          router.setNavbarPosition($newNavbarEl, 'next', false);
        }
      }

      if (options.animate && !(isMaster && app.width >= router.params.masterDetailBreakpoint)) {
        var delay = router.params[router.app.theme + "PageLoadDelay"];
        var transition = router.params.transition;
        if (options.transition) transition = options.transition;

        if (!transition && router.currentRoute && router.currentRoute.route) {
          transition = router.currentRoute.route.transition;
        }

        if (!transition && router.currentRoute && router.currentRoute.route.options) {
          transition = router.currentRoute.route.options.transition;
        }

        if (transition) {
          $newPage[0].f7PageTransition = transition;
        }

        if (delay) {
          setTimeout(function () {
            setPositionClasses();
            router.animate($oldPage, $newPage, $oldNavbarEl, $newNavbarEl, 'forward', transition, function () {
              afterAnimation();
            });
          }, delay);
        } else {
          setPositionClasses();
          router.animate($oldPage, $newPage, $oldNavbarEl, $newNavbarEl, 'forward', transition, function () {
            afterAnimation();
          });
        }
      } else {
        afterAnimation();
      }

      return router;
    }

    function load(router, loadParams, loadOptions, ignorePageChange) {
      if (loadParams === void 0) {
        loadParams = {};
      }

      if (loadOptions === void 0) {
        loadOptions = {};
      }

      if (!router.allowPageChange && !ignorePageChange) return router;
      var params = loadParams;
      var options = loadOptions;
      var url = params.url,
          content = params.content,
          el = params.el,
          pageName = params.pageName,
          component = params.component,
          componentUrl = params.componentUrl;

      if (!options.reloadCurrent && options.route && options.route.route && options.route.route.parentPath && router.currentRoute.route && router.currentRoute.route.parentPath === options.route.route.parentPath) {
        // Do something nested
        if (options.route.url === router.url) {
          router.allowPageChange = true;
          return false;
        } // Check for same params


        var sameParams = Object.keys(options.route.params).length === Object.keys(router.currentRoute.params).length;

        if (sameParams) {
          // Check for equal params name
          Object.keys(options.route.params).forEach(function (paramName) {
            if (!(paramName in router.currentRoute.params) || router.currentRoute.params[paramName] !== options.route.params[paramName]) {
              sameParams = false;
            }
          });
        }

        if (sameParams) {
          if (options.route.route.tab) {
            return router.tabLoad(options.route.route.tab, options);
          }

          return false;
        }

        if (!sameParams && options.route.route.tab && router.currentRoute.route.tab && router.currentRoute.parentPath === options.route.parentPath) {
          return router.tabLoad(options.route.route.tab, options);
        }
      }

      if (options.route && options.route.url && router.url === options.route.url && !(options.reloadCurrent || options.reloadPrevious) && !router.params.allowDuplicateUrls) {
        router.allowPageChange = true;
        return false;
      }

      if (!options.route && url) {
        options.route = router.parseRouteUrl(url);
        extend$1(options.route, {
          route: {
            url: url,
            path: url
          }
        });
      } // Component Callbacks


      function resolve(pageEl, newOptions) {
        return forward(router, pageEl, extend$1(options, newOptions));
      }

      function reject() {
        router.allowPageChange = true;
        return router;
      }

      if (url || componentUrl || component) {
        router.allowPageChange = false;
      } // Proceed


      if (content) {
        forward(router, router.getPageEl(content), options);
      } else if (el) {
        // Load page from specified HTMLElement or by page name in pages container
        forward(router, router.getPageEl(el), options);
      } else if (pageName) {
        // Load page by page name in pages container
        forward(router, router.$el.children(".page[data-name=\"" + pageName + "\"]").eq(0), options);
      } else if (component || componentUrl) {
        // Load from component (F7/Vue/React/...)
        try {
          router.pageComponentLoader({
            routerEl: router.el,
            component: component,
            componentUrl: componentUrl,
            options: options,
            resolve: resolve,
            reject: reject
          });
        } catch (err) {
          router.allowPageChange = true;
          throw err;
        }
      } else if (url) {
        // Load using XHR
        if (router.xhrAbortController) {
          router.xhrAbortController.abort();
          router.xhrAbortController = false;
        }

        router.xhrRequest(url, options).then(function (pageContent) {
          forward(router, router.getPageEl(pageContent), options);
        }).catch(function () {
          router.allowPageChange = true;
        });
      }

      return router;
    }

    function openIn(router, url, options) {
      var navigateOptions = {
        url: url,
        route: {
          path: url,
          options: _extends$j({}, options, {
            openIn: undefined
          })
        }
      };

      var params = _extends$j({}, options);

      if (options.openIn === 'popup') {
        params.content = "<div class=\"popup popup-router-open-in\" data-url=\"" + url + "\"><div class=\"view view-init\" data-links-view=\"" + router.view.selector + "\" data-url=\"" + url + "\" data-ignore-open-in=\"true\"></div></div>";
        navigateOptions.route.popup = params;
      }

      if (options.openIn === 'loginScreen') {
        params.content = "<div class=\"login-screen login-screen-router-open-in\" data-url=\"" + url + "\"><div class=\"view view-init\" data-links-view=\"" + router.view.selector + "\" data-url=\"" + url + "\" data-ignore-open-in=\"true\"></div></div>";
        navigateOptions.route.loginScreen = params;
      }

      if (options.openIn === 'sheet') {
        params.content = "<div class=\"sheet-modal sheet-modal-router-open-in\" data-url=\"" + url + "\"><div class=\"sheet-modal-inner\"><div class=\"view view-init\" data-links-view=\"" + router.view.selector + "\" data-url=\"" + url + "\" data-ignore-open-in=\"true\"></div></div></div>";
        navigateOptions.route.sheet = params;
      }

      if (options.openIn === 'popover') {
        params.targetEl = options.clickedEl || options.targetEl;
        params.content = "<div class=\"popover popover-router-open-in\" data-url=\"" + url + "\"><div class=\"popover-inner\"><div class=\"view view-init\" data-links-view=\"" + router.view.selector + "\" data-url=\"" + url + "\" data-ignore-open-in=\"true\"></div></div></div>";
        navigateOptions.route.popover = params;
      }

      if (options.openIn.indexOf('panel') >= 0) {
        var parts = options.openIn.split(':');
        var side = parts[1] || 'left';
        var effect = parts[2] || 'cover';
        params.targetEl = options.clickedEl || options.targetEl;
        params.content = "<div class=\"panel panel-router-open-in panel-" + side + " panel-" + effect + "\" data-url=\"" + url + "\"><div class=\"view view-init\" data-links-view=\"" + router.view.selector + "\" data-url=\"" + url + "\" data-ignore-open-in=\"true\"></div></div>";
        navigateOptions.route.panel = params;
      }

      return router.navigate(navigateOptions);
    }

    function navigate(navigateParams, navigateOptions) {
      if (navigateOptions === void 0) {
        navigateOptions = {};
      }

      var router = this;
      if (router.swipeBackActive) return router;
      var url;
      var createRoute;
      var name;
      var path;
      var query;
      var params;
      var route;

      if (typeof navigateParams === 'string') {
        url = navigateParams;
      } else {
        url = navigateParams.url;
        createRoute = navigateParams.route;
        name = navigateParams.name;
        path = navigateParams.path;
        query = navigateParams.query;
        params = navigateParams.params;
      }

      if (name || path) {
        url = router.generateUrl({
          path: path,
          name: name,
          params: params,
          query: query
        });

        if (url) {
          return router.navigate(url, navigateOptions);
        }

        return router;
      }

      var app = router.app;
      appRouterCheck(router, 'navigate');

      if (url === '#' || url === '') {
        return router;
      }

      var navigateUrl = url.replace('./', '');

      if (navigateUrl[0] !== '/' && navigateUrl.indexOf('#') !== 0) {
        var currentPath = router.currentRoute.parentPath || router.currentRoute.path;
        navigateUrl = ((currentPath ? currentPath + "/" : '/') + navigateUrl).replace('///', '/').replace('//', '/');
      }

      if (createRoute) {
        route = extend$1(router.parseRouteUrl(navigateUrl), {
          route: extend$1({}, createRoute)
        });
      } else {
        route = router.findMatchingRoute(navigateUrl);
      }

      if (!route) {
        return router;
      }

      if (route.route && route.route.viewName) {
        var anotherViewName = route.route.viewName;
        var anotherView = app.views[anotherViewName];

        if (!anotherView) {
          throw new Error("Framework7: There is no View with \"" + anotherViewName + "\" name that was specified in this route");
        }

        if (anotherView !== router.view) {
          return anotherView.router.navigate(navigateParams, navigateOptions);
        }
      }

      if (route.route.redirect) {
        return redirect.call(router, 'forward', route, navigateOptions);
      }

      var options = {};

      if (route.route.options) {
        extend$1(options, route.route.options, navigateOptions);
      } else {
        extend$1(options, navigateOptions);
      }

      if (options.openIn && (!router.params.ignoreOpenIn || router.params.ignoreOpenIn && router.history.length > 0)) {
        return openIn(router, navigateUrl, options);
      }

      options.route = route;

      function resolve() {
        var routerLoaded = false;
        'popup popover sheet loginScreen actions customModal panel'.split(' ').forEach(function (modalLoadProp) {
          if (route.route[modalLoadProp] && !routerLoaded) {
            routerLoaded = true;
            router.modalLoad(modalLoadProp, route, options, 'forward');
          }
        });

        if (route.route.keepAlive && route.route.keepAliveData) {
          load(router, {
            el: route.route.keepAliveData.pageEl
          }, options, false);
          routerLoaded = true;
        }

        'url content component pageName el componentUrl'.split(' ').forEach(function (pageLoadProp) {
          if (route.route[pageLoadProp] && !routerLoaded) {
            var _load;

            routerLoaded = true;
            load(router, (_load = {}, _load[pageLoadProp] = route.route[pageLoadProp], _load), options, false);
          }
        });
        if (routerLoaded) return; // Async

        function asyncResolve(resolveParams, resolveOptions) {
          router.allowPageChange = false;
          var resolvedAsModal = false;
          'popup popover sheet loginScreen actions customModal panel'.split(' ').forEach(function (modalLoadProp) {
            if (resolveParams[modalLoadProp]) {
              resolvedAsModal = true;
              var modalRoute = extend$1({}, route, {
                route: resolveParams
              });
              router.allowPageChange = true;
              router.modalLoad(modalLoadProp, modalRoute, extend$1(options, resolveOptions), 'forward');
            }
          });
          if (resolvedAsModal) return;
          load(router, resolveParams, extend$1(options, resolveOptions), true);
        }

        function asyncReject() {
          router.allowPageChange = true;
        }

        if (route.route.async) {
          router.allowPageChange = false;
          route.route.async.call(router, {
            router: router,
            to: options.route,
            from: router.currentRoute,
            resolve: asyncResolve,
            reject: asyncReject,
            direction: 'forward',
            app: app
          });
        }

        if (route.route.asyncComponent) {
          asyncComponent(router, route.route.asyncComponent, asyncResolve, asyncReject);
        }
      }

      function reject() {
        router.allowPageChange = true;
      }

      if (router.params.masterDetailBreakpoint > 0 && route.route.masterRoute) {
        // load detail route
        var preloadMaster = true;
        var masterLoaded = false;

        if (router.currentRoute && router.currentRoute.route) {
          if ((router.currentRoute.route.master === true || typeof router.currentRoute.route.master === 'function' && router.currentRoute.route.master(app, router)) && (router.currentRoute.route === route.route.masterRoute || router.currentRoute.route.path === route.route.masterRoute.path)) {
            preloadMaster = false;
          }

          if (router.currentRoute.route.masterRoute && (router.currentRoute.route.masterRoute === route.route.masterRoute || router.currentRoute.route.masterRoute.path === route.route.masterRoute.path)) {
            preloadMaster = false;
            masterLoaded = true;
          }
        }

        if (preloadMaster || masterLoaded && navigateOptions.reloadAll) {
          router.navigate({
            path: route.route.masterRoute.path,
            params: route.params || {}
          }, {
            animate: false,
            reloadAll: navigateOptions.reloadAll,
            reloadCurrent: navigateOptions.reloadCurrent,
            reloadPrevious: navigateOptions.reloadPrevious,
            browserHistory: !navigateOptions.initial,
            history: !navigateOptions.initial,
            once: {
              pageAfterIn: function pageAfterIn() {
                router.navigate(navigateParams, extend$1({}, navigateOptions, {
                  animate: false,
                  reloadAll: false,
                  reloadCurrent: false,
                  reloadPrevious: false,
                  history: !navigateOptions.initial,
                  browserHistory: !navigateOptions.initial
                }));
              }
            }
          });
          return router;
        }
      }

      processRouteQueue.call(router, route, router.currentRoute, function () {
        if (route.route.modules) {
          app.loadModules(Array.isArray(route.route.modules) ? route.route.modules : [route.route.modules]).then(function () {
            resolve();
          }).catch(function () {
            reject();
          });
        } else {
          resolve();
        }
      }, function () {
        reject();
      }, 'forward'); // Return Router

      return router;
    }

    function tabLoad(tabRoute, loadOptions) {
      if (loadOptions === void 0) {
        loadOptions = {};
      }

      var router = this;
      var options = extend$1({
        animate: router.params.animate,
        browserHistory: true,
        history: true,
        parentPageEl: null,
        preload: false,
        on: {}
      }, loadOptions);
      var currentRoute;
      var previousRoute;

      if (options.route) {
        // Set Route
        if (!options.preload && options.route !== router.currentRoute) {
          previousRoute = router.previousRoute;
          router.currentRoute = options.route;
        }

        if (options.preload) {
          currentRoute = options.route;
          previousRoute = router.currentRoute;
        } else {
          currentRoute = router.currentRoute;
          if (!previousRoute) previousRoute = router.previousRoute;
        } // Update Browser History


        if (router.params.browserHistory && options.browserHistory && !options.reloadPrevious) {
          History$2.replace(router.view.id, {
            url: options.route.url
          }, (router.params.browserHistoryRoot || '') + router.params.browserHistorySeparator + options.route.url);
        } // Update Router History


        if (options.history) {
          router.history[Math.max(router.history.length - 1, 0)] = options.route.url;
          router.saveHistory();
        }
      } // Show Tab


      var $parentPageEl = $(options.parentPageEl || router.currentPageEl);
      var tabEl;

      if ($parentPageEl.length && $parentPageEl.find("#" + tabRoute.id).length) {
        tabEl = $parentPageEl.find("#" + tabRoute.id).eq(0);
      } else if (router.view.selector) {
        tabEl = router.view.selector + " #" + tabRoute.id;
      } else {
        tabEl = "#" + tabRoute.id;
      }

      var tabShowResult = router.app.tab.show({
        tabEl: tabEl,
        animate: options.animate,
        tabRoute: options.route
      });
      var $newTabEl = tabShowResult.$newTabEl,
          $oldTabEl = tabShowResult.$oldTabEl,
          animated = tabShowResult.animated,
          onTabsChanged = tabShowResult.onTabsChanged;

      if ($newTabEl && $newTabEl.parents('.page').length > 0 && options.route) {
        var tabParentPageData = $newTabEl.parents('.page')[0].f7Page;

        if (tabParentPageData && options.route) {
          tabParentPageData.route = options.route;
        }
      } // Tab Content Loaded


      function onTabLoaded(contentEl) {
        // Remove theme elements
        router.removeThemeElements($newTabEl);
        var tabEventTarget = $newTabEl;
        if (typeof contentEl !== 'string') tabEventTarget = $(contentEl);
        tabEventTarget.trigger('tab:init tab:mounted', tabRoute);
        router.emit('tabInit tabMounted', $newTabEl[0], tabRoute);

        if ($oldTabEl && $oldTabEl.length) {
          if (animated) {
            onTabsChanged(function () {
              router.emit('routeChanged', router.currentRoute, router.previousRoute, router);

              if (router.params.unloadTabContent) {
                router.tabRemove($oldTabEl, $newTabEl, tabRoute);
              }
            });
          } else {
            router.emit('routeChanged', router.currentRoute, router.previousRoute, router);

            if (router.params.unloadTabContent) {
              router.tabRemove($oldTabEl, $newTabEl, tabRoute);
            }
          }
        }
      }

      if ($newTabEl[0].f7RouterTabLoaded) {
        if (!$oldTabEl || !$oldTabEl.length) return router;

        if (animated) {
          onTabsChanged(function () {
            router.emit('routeChanged', router.currentRoute, router.previousRoute, router);
          });
        } else {
          router.emit('routeChanged', router.currentRoute, router.previousRoute, router);
        }

        return router;
      } // Load Tab Content


      function loadTab(loadTabParams, loadTabOptions) {
        // Load Tab Props
        var url = loadTabParams.url,
            content = loadTabParams.content,
            el = loadTabParams.el,
            component = loadTabParams.component,
            componentUrl = loadTabParams.componentUrl; // Component/Template Callbacks

        function resolve(contentEl) {
          router.allowPageChange = true;
          if (!contentEl) return;

          if (typeof contentEl === 'string') {
            $newTabEl.html(contentEl);
          } else {
            $newTabEl.html('');

            if (contentEl.f7Component) {
              contentEl.f7Component.mount(function (componentEl) {
                $newTabEl.append(componentEl);
              });
            } else {
              $newTabEl.append(contentEl);
            }
          }

          $newTabEl[0].f7RouterTabLoaded = true;
          onTabLoaded(contentEl);
        }

        function reject() {
          router.allowPageChange = true;
          return router;
        }

        if (content) {
          resolve(content);
        } else if (el) {
          resolve(el);
        } else if (component || componentUrl) {
          // Load from component (F7/Vue/React/...)
          try {
            router.tabComponentLoader({
              tabEl: $newTabEl[0],
              component: component,
              componentUrl: componentUrl,
              options: loadTabOptions,
              resolve: resolve,
              reject: reject
            });
          } catch (err) {
            router.allowPageChange = true;
            throw err;
          }
        } else if (url) {
          // Load using XHR
          if (router.xhrAbortController) {
            router.xhrAbortController.abort();
            router.xhrAbortController = false;
          }

          router.xhrRequest(url, loadTabOptions).then(function (tabContent) {
            resolve(tabContent);
          }).catch(function () {
            router.allowPageChange = true;
          });
        }
      }

      var hasContentLoadProp;
      'url content component el componentUrl'.split(' ').forEach(function (tabLoadProp) {
        if (tabRoute[tabLoadProp]) {
          var _loadTab;

          hasContentLoadProp = true;
          loadTab((_loadTab = {}, _loadTab[tabLoadProp] = tabRoute[tabLoadProp], _loadTab), options);
        }
      }); // Async

      function asyncResolve(resolveParams, resolveOptions) {
        loadTab(resolveParams, extend$1(options, resolveOptions));
      }

      function asyncReject() {
        router.allowPageChange = true;
      }

      if (tabRoute.async) {
        tabRoute.async.call(router, {
          router: router,
          to: currentRoute,
          from: previousRoute,
          resolve: asyncResolve,
          reject: asyncReject,
          app: router.app
        });
      } else if (tabRoute.asyncComponent) {
        asyncComponent(router, tabRoute.asyncComponent, asyncResolve, asyncReject);
      } else if (!hasContentLoadProp) {
        router.allowPageChange = true;
      }

      return router;
    }

    function tabRemove($oldTabEl, $newTabEl, tabRoute) {
      var router = this;
      var hasTabComponentChild;

      if ($oldTabEl[0]) {
        $oldTabEl[0].f7RouterTabLoaded = false;
        delete $oldTabEl[0].f7RouterTabLoaded;
      }

      $oldTabEl.children().each(function (tabChild) {
        if (tabChild.f7Component) {
          hasTabComponentChild = true;
          $(tabChild).trigger('tab:beforeremove', tabRoute);
          tabChild.f7Component.destroy();
        }
      });

      if (!hasTabComponentChild) {
        $oldTabEl.trigger('tab:beforeremove', tabRoute);
      }

      router.emit('tabBeforeRemove', $oldTabEl[0], $newTabEl[0], tabRoute);
      router.removeTabContent($oldTabEl[0], tabRoute);
    }

    function modalLoad(modalType, route, loadOptions, direction) {
      if (loadOptions === void 0) {
        loadOptions = {};
      }

      var router = this;
      var app = router.app;
      var isPanel = modalType === 'panel';
      var modalOrPanel = isPanel ? 'panel' : 'modal';
      var options = extend$1({
        animate: router.params.animate,
        browserHistory: true,
        history: true,
        on: {},
        once: {}
      }, loadOptions);
      var modalParams = extend$1({}, route.route[modalType]);
      var modalRoute = route.route;

      var routeCallback = function routeCallback(modal, name) {
        var on = options.on,
            once = options.once;
        var callback;

        if (name === 'open') {
          callback = on.modalOpen || once.modalOpen || on.panelOpen || once.panelOpen;
        }

        if (name === 'close') {
          callback = on.modalClose || once.modalClose || on.panelClose || once.panelClose;
        }

        if (name === 'closed') {
          callback = on.modalClosed || once.modalClosed || on.panelClosed || once.panelClosed;
        }

        if (callback) callback(modal);
      };

      function onModalLoaded() {
        // Create Modal
        var modal = app[modalType].create(modalParams);
        modalRoute.modalInstance = modal;
        var hasEl = modal.el;

        function closeOnSwipeBack() {
          modal.close();
        }

        modal.on(modalOrPanel + "Open", function () {
          if (!hasEl) {
            // Remove theme elements
            router.removeThemeElements(modal.el); // Emit events

            modal.$el.trigger(modalType.toLowerCase() + ":init " + modalType.toLowerCase() + ":mounted", route, modal);
            router.emit((!isPanel ? 'modalInit' : '') + " " + modalType + "Init " + modalType + "Mounted", modal.el, route, modal);
          }

          router.once('swipeBackMove', closeOnSwipeBack);
          routeCallback(modal, 'open');
        });
        modal.on(modalOrPanel + "Close", function () {
          router.off('swipeBackMove', closeOnSwipeBack);

          if (!modal.closeByRouter) {
            router.back();
          }

          routeCallback(modal, 'close');
        });
        modal.on(modalOrPanel + "Closed", function () {
          modal.$el.trigger(modalType.toLowerCase() + ":beforeremove", route, modal);
          modal.emit("" + (!isPanel ? 'modalBeforeRemove ' : '') + modalType + "BeforeRemove", modal.el, route, modal);
          var modalComponent = modal.el.f7Component;
          routeCallback(modal, 'closed');

          if (modalComponent) {
            modalComponent.destroy();
          }

          nextTick$1(function () {
            if (modalComponent || modalParams.component || modalParams.asyncComponent) {
              router.removeModal(modal.el);
            }

            modal.destroy();
            delete modal.route;
            delete modalRoute.modalInstance;
          });
        });

        if (options.route) {
          // Update Browser History
          if (router.params.browserHistory && options.browserHistory) {
            History$2.push(router.view.id, {
              url: options.route.url,
              modal: modalType
            }, (router.params.browserHistoryRoot || '') + router.params.browserHistorySeparator + options.route.url);
          } // Set Route


          if (options.route !== router.currentRoute) {
            modal.route = extend$1(options.route, {
              modal: modal
            });
            router.currentRoute = modal.route;
          } // Update Router History


          if (options.history && !options.reloadCurrent) {
            router.history.push(options.route.url);
            router.saveHistory();
          }
        }

        if (hasEl) {
          // Remove theme elements
          router.removeThemeElements(modal.el); // Emit events

          modal.$el.trigger(modalType.toLowerCase() + ":init " + modalType.toLowerCase() + ":mounted", route, modal);
          router.emit(modalOrPanel + "Init " + modalType + "Init " + modalType + "Mounted", modal.el, route, modal);
        } // Open


        modal.open(options.animate === false || options.animate === true ? options.animate : undefined);
      } // Load Modal Content


      function loadModal(loadModalParams, loadModalOptions) {
        // Load Modal Props
        var url = loadModalParams.url,
            content = loadModalParams.content,
            component = loadModalParams.component,
            componentUrl = loadModalParams.componentUrl; // Component/Template Callbacks

        function resolve(contentEl) {
          if (contentEl) {
            if (typeof contentEl === 'string') {
              modalParams.content = contentEl;
            } else if (contentEl.f7Component) {
              contentEl.f7Component.mount(function (componentEl) {
                modalParams.el = componentEl;
                app.$el.append(componentEl);
              });
            } else {
              modalParams.el = contentEl;
            }

            onModalLoaded();
          }
        }

        function reject() {
          router.allowPageChange = true;
          return router;
        }

        if (content) {
          resolve(content);
        } else if (component || componentUrl) {
          // Load from component (F7/Vue/React/...)
          try {
            router.modalComponentLoader({
              rootEl: app.el,
              component: component,
              componentUrl: componentUrl,
              options: loadModalOptions,
              resolve: resolve,
              reject: reject
            });
          } catch (err) {
            router.allowPageChange = true;
            throw err;
          }
        } else if (url) {
          // Load using XHR
          if (router.xhrAbortController) {
            router.xhrAbortController.abort();
            router.xhrAbortController = false;
          }

          router.xhrRequest(url, loadModalOptions).then(function (modalContent) {
            modalParams.content = modalContent;
            onModalLoaded();
          }).catch(function () {
            router.allowPageChange = true;
          });
        } else {
          onModalLoaded();
        }
      }

      var foundLoadProp;
      'url content component el componentUrl template'.split(' ').forEach(function (modalLoadProp) {
        if (modalParams[modalLoadProp] && !foundLoadProp) {
          var _loadModal;

          foundLoadProp = true;
          loadModal((_loadModal = {}, _loadModal[modalLoadProp] = modalParams[modalLoadProp], _loadModal), options);
        }
      });

      if (!foundLoadProp && modalType === 'actions') {
        onModalLoaded();
      } // Async


      function asyncResolve(resolveParams, resolveOptions) {
        loadModal(resolveParams, extend$1(options, resolveOptions));
      }

      function asyncReject() {
        router.allowPageChange = true;
      }

      if (modalParams.async) {
        modalParams.async.call(router, {
          router: router,
          to: options.route,
          from: router.currentRoute,
          resolve: asyncResolve,
          reject: asyncReject,
          direction: direction,
          app: app
        });
      }

      if (modalParams.asyncComponent) {
        asyncComponent(router, modalParams.asyncComponent, asyncResolve, asyncReject);
      }

      return router;
    }

    function modalRemove(modal) {
      extend$1(modal, {
        closeByRouter: true
      });
      modal.close();
    }

    function backward(router, el, backwardOptions) {
      var device = getDevice$1();
      var document = getDocument();
      var $el = $(el);
      var app = router.app;
      var view = router.view;
      var options = extend$1({
        animate: router.params.animate,
        browserHistory: true,
        replaceState: false
      }, backwardOptions);
      var masterDetailEnabled = router.params.masterDetailBreakpoint > 0;
      var isMaster = masterDetailEnabled && options.route && options.route.route && (options.route.route.master === true || typeof options.route.route.master === 'function' && options.route.route.master(app, router));
      var masterPageEl;
      var masterPageRemoved;
      var dynamicNavbar = router.dynamicNavbar;
      var $newPage = $el;
      var $oldPage = router.$el.children('.page-current');
      var initialPreload = $oldPage.length === 0 && options.preload;
      var currentIsMaster = masterDetailEnabled && $oldPage.hasClass('page-master');

      if ($newPage.length) {
        // Remove theme elements
        router.removeThemeElements($newPage);
      }

      var $navbarsEl;
      var $newNavbarEl;
      var $oldNavbarEl;

      if (dynamicNavbar) {
        $newNavbarEl = $newPage.children('.navbar');
        $navbarsEl = router.$navbarsEl;

        if ($newNavbarEl.length === 0 && $newPage[0] && $newPage[0].f7Page) {
          // Try from pageData
          $newNavbarEl = $newPage[0].f7Page.$navbarEl;
        }

        $oldNavbarEl = $navbarsEl.find('.navbar-current');
      }

      router.allowPageChange = false;

      if ($newPage.length === 0 || $oldPage.length === 0 && !options.preload) {
        router.allowPageChange = true;
        return router;
      } // Remove theme elements


      router.removeThemeElements($newPage); // Save Keep Alive Cache

      if (options.route && options.route.route && options.route.route.keepAlive && !options.route.route.keepAliveData) {
        options.route.route.keepAliveData = {
          pageEl: $el[0]
        };
      } // Pages In View


      var isDetail;
      var isDetailRoot;

      if (masterDetailEnabled) {
        var $pagesInView = router.$el.children('.page:not(.stacked)').filter(function (pageInView) {
          return pageInView !== $newPage[0];
        }); // Find Detail' master page

        for (var i = 0; i < $pagesInView.length; i += 1) {
          if (!masterPageEl && $pagesInView[i].classList.contains('page-master')) {
            masterPageEl = $pagesInView[i];
            continue; // eslint-disable-line
          }
        }

        isDetail = !isMaster && masterPageEl && router.history.indexOf(options.route.url) > router.history.indexOf(masterPageEl.f7Page.route.url);

        if (!isDetail && !isMaster && masterPageEl && masterPageEl.f7Page && options.route.route.masterRoute) {
          isDetail = options.route.route.masterRoute.path === masterPageEl.f7Page.route.route.path;
        }
      }

      if (isDetail && masterPageEl && masterPageEl.f7Page) {
        isDetailRoot = router.history.indexOf(options.route.url) - router.history.indexOf(masterPageEl.f7Page.route.url) === 1;
      } // New Page


      $newPage.addClass("page-" + (initialPreload ? 'current' : 'previous') + (isMaster ? ' page-master' : '') + (isDetail ? ' page-master-detail' : '') + (isDetailRoot ? ' page-master-detail-root' : '')).removeClass('stacked').removeAttr('aria-hidden').trigger('page:unstack').trigger('page:position', {
        position: initialPreload ? 'current' : 'previous'
      });
      router.emit('pageUnstack', $newPage[0]);
      router.emit('pagePosition', $newPage[0], initialPreload ? 'current' : 'previous');

      if (isMaster || isDetail) {
        $newPage.trigger('page:role', {
          role: isMaster ? 'master' : 'detail',
          root: !!isDetailRoot
        });
        router.emit('pageRole', $newPage[0], {
          role: isMaster ? 'master' : 'detail',
          detailRoot: !!isDetailRoot
        });
      }

      if (dynamicNavbar && $newNavbarEl.length > 0) {
        $newNavbarEl.addClass("navbar-" + (initialPreload ? 'current' : 'previous') + (isMaster ? ' navbar-master' : '') + (isDetail ? ' navbar-master-detail' : '') + (isDetailRoot ? ' navbar-master-detail-root' : '')).removeClass('stacked').removeAttr('aria-hidden');
        $newNavbarEl.trigger('navbar:position', {
          position: initialPreload ? 'current' : 'previous'
        });
        router.emit('navbarPosition', $newNavbarEl[0], initialPreload ? 'current' : 'previous');

        if (isMaster || isDetailRoot) {
          router.emit('navbarRole', $newNavbarEl[0], {
            role: isMaster ? 'master' : 'detail',
            detailRoot: !!isDetailRoot
          });
        }
      } // Remove previous page in case of "forced"


      var backIndex;

      if (options.force) {
        if ($oldPage.prev('.page-previous:not(.stacked)').length > 0 || $oldPage.prev('.page-previous').length === 0) {
          if (router.history.indexOf(options.route.url) >= 0) {
            backIndex = router.history.length - router.history.indexOf(options.route.url) - 1;
            router.history = router.history.slice(0, router.history.indexOf(options.route.url) + 2);
            view.history = router.history;
          } else if (router.history[[router.history.length - 2]]) {
            router.history[router.history.length - 2] = options.route.url;
          } else {
            router.history.unshift(router.url);
          }

          if (backIndex && router.params.stackPages) {
            $oldPage.prevAll('.page-previous').each(function (pageToRemove) {
              var $pageToRemove = $(pageToRemove);
              var $navbarToRemove;

              if (dynamicNavbar) {
                // $navbarToRemove = $oldNavbarEl.prevAll('.navbar-previous').eq(index);
                $navbarToRemove = $(app.navbar.getElByPage($pageToRemove));
              }

              if ($pageToRemove[0] !== $newPage[0] && $pageToRemove.index() > $newPage.index()) {
                if (router.initialPages.indexOf($pageToRemove[0]) >= 0) {
                  $pageToRemove.addClass('stacked');
                  $pageToRemove.trigger('page:stack');
                  router.emit('pageStack', $pageToRemove[0]);

                  if (dynamicNavbar) {
                    $navbarToRemove.addClass('stacked');
                  }
                } else {
                  router.pageCallback('beforeRemove', $pageToRemove, $navbarToRemove, 'previous', undefined, options);

                  if ($pageToRemove[0] === masterPageEl) {
                    masterPageRemoved = true;
                  }

                  router.removePage($pageToRemove);

                  if (dynamicNavbar && $navbarToRemove.length > 0) {
                    router.removeNavbar($navbarToRemove);
                  }
                }
              }
            });
          } else {
            var $pageToRemove = $oldPage.prev('.page-previous:not(.stacked)');
            var $navbarToRemove;

            if (dynamicNavbar) {
              // $navbarToRemove = $oldNavbarEl.prev('.navbar-inner:not(.stacked)');
              $navbarToRemove = $(app.navbar.getElByPage($pageToRemove));
            }

            if (router.params.stackPages && router.initialPages.indexOf($pageToRemove[0]) >= 0) {
              $pageToRemove.addClass('stacked');
              $pageToRemove.trigger('page:stack');
              router.emit('pageStack', $pageToRemove[0]);
              $navbarToRemove.addClass('stacked');
            } else if ($pageToRemove.length > 0) {
              router.pageCallback('beforeRemove', $pageToRemove, $navbarToRemove, 'previous', undefined, options);

              if ($pageToRemove[0] === masterPageEl) {
                masterPageRemoved = true;
              }

              router.removePage($pageToRemove);

              if (dynamicNavbar && $navbarToRemove.length) {
                router.removeNavbar($navbarToRemove);
              }
            }
          }
        }
      } // Insert new page


      var newPageInDom = $newPage.parents(document).length > 0;
      var f7Component = $newPage[0].f7Component;

      function insertPage() {
        if (initialPreload) {
          if (!newPageInDom && f7Component) {
            f7Component.mount(function (componentEl) {
              router.$el.append(componentEl);
            });
          } else {
            router.$el.append($newPage);
          }
        }

        if ($newPage.next($oldPage).length === 0) {
          if (!newPageInDom && f7Component) {
            f7Component.mount(function (componentEl) {
              $(componentEl).insertBefore($oldPage);
            });
          } else {
            $newPage.insertBefore($oldPage);
          }
        }

        if (dynamicNavbar && $newNavbarEl.length) {
          if ($newNavbarEl.find('.title-large').length) {
            $newNavbarEl.addClass('navbar-large');
          }

          $newNavbarEl.insertBefore($oldNavbarEl);

          if ($oldNavbarEl.length > 0) {
            $newNavbarEl.insertBefore($oldNavbarEl);
          } else {
            if (!router.$navbarsEl.parents(document).length) {
              router.$el.prepend(router.$navbarsEl);
            }

            $navbarsEl.append($newNavbarEl);
          }
        }

        if (!newPageInDom) {
          router.pageCallback('mounted', $newPage, $newNavbarEl, 'previous', 'current', options, $oldPage);
        } else if (options.route && options.route.route && options.route.route.keepAlive && !$newPage[0].f7PageMounted) {
          $newPage[0].f7PageMounted = true;
          router.pageCallback('mounted', $newPage, $newNavbarEl, 'previous', 'current', options, $oldPage);
        }
      }

      if (options.preload) {
        // Insert Page
        insertPage(); // Tab route

        if (options.route.route.tab) {
          router.tabLoad(options.route.route.tab, extend$1({}, options, {
            history: false,
            browserHistory: false,
            preload: true
          }));
        }

        if (isMaster) {
          $newPage.removeClass('page-master-stacked').trigger('page:masterunstack');
          router.emit('pageMasterUnstack', $newPage[0]);

          if (dynamicNavbar) {
            $(app.navbar.getElByPage($newPage)).removeClass('navbar-master-stacked');
            router.emit('navbarMasterUnstack', app.navbar.getElByPage($newPage));
          }
        } // Page init and before init events


        router.pageCallback('init', $newPage, $newNavbarEl, 'previous', 'current', options, $oldPage);

        if (initialPreload) {
          router.pageCallback('beforeIn', $newPage, $newNavbarEl, 'current', undefined, options);
          router.pageCallback('afterIn', $newPage, $newNavbarEl, 'current', undefined, options);
        }

        var $previousPages = $newPage.prevAll('.page-previous:not(.stacked):not(.page-master)');

        if ($previousPages.length > 0) {
          $previousPages.each(function (pageToRemove) {
            var $pageToRemove = $(pageToRemove);
            var $navbarToRemove;

            if (dynamicNavbar) {
              // $navbarToRemove = $newNavbarEl.prevAll('.navbar-previous:not(.stacked)').eq(index);
              $navbarToRemove = $(app.navbar.getElByPage($pageToRemove));
            }

            if (router.params.stackPages && router.initialPages.indexOf(pageToRemove) >= 0) {
              $pageToRemove.addClass('stacked');
              $pageToRemove.trigger('page:stack');
              router.emit('pageStack', $pageToRemove[0]);

              if (dynamicNavbar) {
                $navbarToRemove.addClass('stacked');
              }
            } else {
              router.pageCallback('beforeRemove', $pageToRemove, $navbarToRemove, 'previous', undefined);
              router.removePage($pageToRemove);

              if (dynamicNavbar && $navbarToRemove.length) {
                router.removeNavbar($navbarToRemove);
              }
            }
          });
        }

        router.allowPageChange = true;
        return router;
      } // History State


      if (!(device.ie || device.edge || device.firefox && !device.ios)) {
        if (router.params.browserHistory && options.browserHistory) {
          if (options.replaceState) {
            var browserHistoryRoot = router.params.browserHistoryRoot || '';
            History$2.replace(view.id, {
              url: options.route.url
            }, browserHistoryRoot + router.params.browserHistorySeparator + options.route.url);
          } else if (backIndex) {
            History$2.go(-backIndex);
          } else {
            History$2.back();
          }
        }
      } // Update History


      if (options.replaceState) {
        router.history[router.history.length - 1] = options.route.url;
      } else {
        if (router.history.length === 1) {
          router.history.unshift(router.url);
        }

        router.history.pop();
      }

      router.saveHistory(); // Current Page & Navbar

      router.currentPageEl = $newPage[0];

      if (dynamicNavbar && $newNavbarEl.length) {
        router.currentNavbarEl = $newNavbarEl[0];
      } else {
        delete router.currentNavbarEl;
      } // Current Route


      router.currentRoute = options.route; // History State

      if (device.ie || device.edge || device.firefox && !device.ios) {
        if (router.params.browserHistory && options.browserHistory) {
          if (options.replaceState) {
            var _browserHistoryRoot = router.params.browserHistoryRoot || '';

            History$2.replace(view.id, {
              url: options.route.url
            }, _browserHistoryRoot + router.params.browserHistorySeparator + options.route.url);
          } else if (backIndex) {
            History$2.go(-backIndex);
          } else {
            History$2.back();
          }
        }
      } // Insert Page


      insertPage(); // Load Tab

      if (options.route.route.tab) {
        router.tabLoad(options.route.route.tab, extend$1({}, options, {
          history: false,
          browserHistory: false
        }));
      } // Check master detail


      if (masterDetailEnabled && (currentIsMaster || masterPageRemoved)) {
        view.checkMasterDetailBreakpoint(false);
      } // Page init and before init events


      router.pageCallback('init', $newPage, $newNavbarEl, 'previous', 'current', options, $oldPage); // Before animation callback

      router.pageCallback('beforeOut', $oldPage, $oldNavbarEl, 'current', 'next', options);
      router.pageCallback('beforeIn', $newPage, $newNavbarEl, 'previous', 'current', options); // Animation

      function afterAnimation() {
        // Set classes
        router.setPagePosition($newPage, 'current', false);
        router.setPagePosition($oldPage, 'next', true);

        if (dynamicNavbar) {
          router.setNavbarPosition($newNavbarEl, 'current', false);
          router.setNavbarPosition($oldNavbarEl, 'next', true);
        } // After animation event


        router.pageCallback('afterOut', $oldPage, $oldNavbarEl, 'current', 'next', options);
        router.pageCallback('afterIn', $newPage, $newNavbarEl, 'previous', 'current', options); // Remove Old Page

        if (router.params.stackPages && router.initialPages.indexOf($oldPage[0]) >= 0) {
          $oldPage.addClass('stacked');
          $oldPage.trigger('page:stack');
          router.emit('pageStack', $oldPage[0]);

          if (dynamicNavbar) {
            $oldNavbarEl.addClass('stacked');
          }
        } else {
          router.pageCallback('beforeRemove', $oldPage, $oldNavbarEl, 'next', undefined, options);
          router.removePage($oldPage);

          if (dynamicNavbar && $oldNavbarEl.length) {
            router.removeNavbar($oldNavbarEl);
          }
        }

        router.allowPageChange = true;
        router.emit('routeChanged', router.currentRoute, router.previousRoute, router); // Preload previous page

        var preloadPreviousPage = router.params.preloadPreviousPage || router.params[app.theme + "SwipeBack"];

        if (preloadPreviousPage && router.history[router.history.length - 2] && !isMaster) {
          router.back(router.history[router.history.length - 2], {
            preload: true
          });
        }

        if (router.params.browserHistory) {
          History$2.clearRouterQueue();
        }
      }

      function setPositionClasses() {
        router.setPagePosition($oldPage, 'current');
        router.setPagePosition($newPage, 'previous', false);

        if (dynamicNavbar) {
          router.setNavbarPosition($oldNavbarEl, 'current');
          router.setNavbarPosition($newNavbarEl, 'previous', false);
        }
      }

      if (options.animate && !(currentIsMaster && app.width >= router.params.masterDetailBreakpoint)) {
        var transition = router.params.transition;

        if ($oldPage[0] && $oldPage[0].f7PageTransition) {
          transition = $oldPage[0].f7PageTransition;
          delete $oldPage[0].f7PageTransition;
        }

        if (options.transition) transition = options.transition;

        if (!transition && router.previousRoute && router.previousRoute.route) {
          transition = router.previousRoute.route.transition;
        }

        if (!transition && router.previousRoute && router.previousRoute.route && router.previousRoute.route.options) {
          transition = router.previousRoute.route.options.transition;
        }

        setPositionClasses();
        router.animate($oldPage, $newPage, $oldNavbarEl, $newNavbarEl, 'backward', transition, function () {
          afterAnimation();
        });
      } else {
        afterAnimation();
      }

      return router;
    }

    function loadBack(router, backParams, backOptions, ignorePageChange) {
      if (!router.allowPageChange && !ignorePageChange) return router;
      var params = backParams;
      var options = backOptions;
      var url = params.url,
          content = params.content,
          el = params.el,
          pageName = params.pageName,
          component = params.component,
          componentUrl = params.componentUrl;

      if (options.route.url && router.url === options.route.url && !(options.reloadCurrent || options.reloadPrevious) && !router.params.allowDuplicateUrls) {
        return false;
      }

      if (!options.route && url) {
        options.route = router.parseRouteUrl(url);
      } // Component Callbacks


      function resolve(pageEl, newOptions) {
        return backward(router, pageEl, extend$1(options, newOptions));
      }

      function reject() {
        router.allowPageChange = true;
        return router;
      }

      if (url || componentUrl || component) {
        router.allowPageChange = false;
      } // Proceed


      if (content) {
        backward(router, router.getPageEl(content), options);
      } else if (el) {
        // Load page from specified HTMLElement or by page name in pages container
        backward(router, router.getPageEl(el), options);
      } else if (pageName) {
        // Load page by page name in pages container
        backward(router, router.$el.children(".page[data-name=\"" + pageName + "\"]").eq(0), options);
      } else if (component || componentUrl) {
        // Load from component (F7/Vue/React/...)
        try {
          router.pageComponentLoader({
            routerEl: router.el,
            component: component,
            componentUrl: componentUrl,
            options: options,
            resolve: resolve,
            reject: reject
          });
        } catch (err) {
          router.allowPageChange = true;
          throw err;
        }
      } else if (url) {
        // Load using XHR
        if (router.xhrAbortController) {
          router.xhrAbortController.abort();
          router.xhrAbortController = false;
        }

        router.xhrRequest(url, options).then(function (pageContent) {
          backward(router, router.getPageEl(pageContent), options);
        }).catch(function () {
          router.allowPageChange = true;
        });
      }

      return router;
    }

    function back() {
      var router = this;
      var device = getDevice$1();
      if (router.swipeBackActive) return router;
      var navigateUrl;
      var navigateOptions;
      var route;

      if (typeof (arguments.length <= 0 ? undefined : arguments[0]) === 'object') {
        navigateOptions = (arguments.length <= 0 ? undefined : arguments[0]) || {};
      } else {
        navigateUrl = arguments.length <= 0 ? undefined : arguments[0];
        navigateOptions = (arguments.length <= 1 ? undefined : arguments[1]) || {};
      }

      var _navigateOptions = navigateOptions,
          name = _navigateOptions.name,
          params = _navigateOptions.params,
          query = _navigateOptions.query;

      if (name) {
        navigateUrl = router.generateUrl({
          name: name,
          params: params,
          query: query
        });

        if (navigateUrl) {
          return router.back(navigateUrl, extend$1({}, navigateOptions, {
            name: null,
            params: null,
            query: null
          }));
        }

        return router;
      }

      var app = router.app;
      appRouterCheck(router, 'back');
      var currentRouteIsModal = router.currentRoute.modal;
      var modalType;

      if (!currentRouteIsModal) {
        'popup popover sheet loginScreen actions customModal panel'.split(' ').forEach(function (modalLoadProp) {
          if (router.currentRoute.route[modalLoadProp]) {
            currentRouteIsModal = true;
            modalType = modalLoadProp;
          }
        });
      }

      if (currentRouteIsModal && !navigateOptions.preload) {
        var modalToClose = router.currentRoute.modal || router.currentRoute.route.modalInstance || app[modalType].get();
        var previousUrl = router.history[router.history.length - 2];
        var previousRoute; // check if previous route is modal too

        if (modalToClose && modalToClose.$el) {
          var prevOpenedModals = modalToClose.$el.prevAll('.modal-in');

          if (prevOpenedModals.length && prevOpenedModals[0].f7Modal) {
            var modalEl = prevOpenedModals[0]; // check if current router not inside of the modalEl

            if (!router.$el.parents(modalEl).length) {
              previousRoute = modalEl.f7Modal.route;
            }
          }
        }

        if (!previousRoute) {
          previousRoute = router.findMatchingRoute(previousUrl);
        }

        if (!previousRoute && previousUrl) {
          previousRoute = {
            url: previousUrl,
            path: previousUrl.split('?')[0],
            query: parseUrlQuery(previousUrl),
            route: {
              path: previousUrl.split('?')[0],
              url: previousUrl
            }
          };
        }

        if (!navigateUrl || navigateUrl.replace(/[# ]/g, '').trim().length === 0) {
          if (!previousRoute || !modalToClose) {
            return router;
          }
        }

        var forceOtherUrl = navigateOptions.force && previousRoute && navigateUrl;

        if (previousRoute && modalToClose) {
          var isBrokenBrowserHistory = device.ie || device.edge || device.firefox && !device.ios;
          var needHistoryBack = router.params.browserHistory && navigateOptions.browserHistory !== false;
          var currentRouteWithoutBrowserHistory = router.currentRoute && router.currentRoute.route && router.currentRoute.route.options && router.currentRoute.route.options.browserHistory === false;

          if (needHistoryBack && !isBrokenBrowserHistory && !currentRouteWithoutBrowserHistory) {
            History$2.back();
          }

          router.currentRoute = previousRoute;
          router.history.pop();
          router.saveHistory();

          if (needHistoryBack && isBrokenBrowserHistory && !currentRouteWithoutBrowserHistory) {
            History$2.back();
          }

          router.modalRemove(modalToClose);

          if (forceOtherUrl) {
            router.navigate(navigateUrl, {
              reloadCurrent: true
            });
          }
        } else if (modalToClose) {
          router.modalRemove(modalToClose);

          if (navigateUrl) {
            router.navigate(navigateUrl, {
              reloadCurrent: true
            });
          }
        }

        return router;
      }

      var $previousPage = router.$el.children('.page-current').prevAll('.page-previous:not(.page-master)').eq(0);
      var skipMaster;

      if (router.params.masterDetailBreakpoint > 0) {
        var classes = [];
        router.$el.children('.page').each(function (pageEl) {
          classes.push(pageEl.className);
        });
        var $previousMaster = router.$el.children('.page-current').prevAll('.page-master').eq(0);

        if ($previousMaster.length) {
          var expectedPreviousPageUrl = router.history[router.history.length - 2];
          var expectedPreviousPageRoute = router.findMatchingRoute(expectedPreviousPageUrl);

          if (expectedPreviousPageRoute && $previousMaster[0].f7Page && expectedPreviousPageRoute.route === $previousMaster[0].f7Page.route.route) {
            $previousPage = $previousMaster;

            if (!navigateOptions.preload) {
              skipMaster = app.width >= router.params.masterDetailBreakpoint;
            }
          }
        }
      }

      if (!navigateOptions.force && $previousPage.length && !skipMaster) {
        if (router.params.browserHistory && $previousPage[0].f7Page && router.history[router.history.length - 2] !== $previousPage[0].f7Page.route.url) {
          router.back(router.history[router.history.length - 2], extend$1(navigateOptions, {
            force: true
          }));
          return router;
        }

        var previousPageRoute = $previousPage[0].f7Page.route;
        processRouteQueue.call(router, previousPageRoute, router.currentRoute, function () {
          loadBack(router, {
            el: $previousPage
          }, extend$1(navigateOptions, {
            route: previousPageRoute
          }));
        }, function () {}, 'backward');
        return router;
      } // Navigate URL


      if (navigateUrl === '#') {
        navigateUrl = undefined;
      }

      if (navigateUrl && navigateUrl[0] !== '/' && navigateUrl.indexOf('#') !== 0) {
        navigateUrl = ((router.path || '/') + navigateUrl).replace('//', '/');
      }

      if (!navigateUrl && router.history.length > 1) {
        navigateUrl = router.history[router.history.length - 2];
      }

      if (skipMaster && !navigateOptions.force && router.history[router.history.length - 3]) {
        return router.back(router.history[router.history.length - 3], extend$1({}, navigateOptions || {}, {
          force: true,
          animate: false
        }));
      }

      if (skipMaster && !navigateOptions.force) {
        return router;
      } // Find route to load


      route = router.findMatchingRoute(navigateUrl);

      if (!route) {
        if (navigateUrl) {
          route = {
            url: navigateUrl,
            path: navigateUrl.split('?')[0],
            query: parseUrlQuery(navigateUrl),
            route: {
              path: navigateUrl.split('?')[0],
              url: navigateUrl
            }
          };
        }
      }

      if (!route) {
        return router;
      }

      if (route.route.redirect) {
        return redirect.call(router, 'backward', route, navigateOptions);
      }

      var options = {};

      if (route.route.options) {
        extend$1(options, route.route.options, navigateOptions);
      } else {
        extend$1(options, navigateOptions);
      }

      options.route = route;
      var backForceLoaded;

      if (options.force && router.params.stackPages) {
        router.$el.children('.page-previous.stacked').each(function (pageEl) {
          if (pageEl.f7Page && pageEl.f7Page.route && pageEl.f7Page.route.url === route.url) {
            backForceLoaded = true;
            loadBack(router, {
              el: pageEl
            }, options);
          }
        });

        if (backForceLoaded) {
          return router;
        }
      }

      function resolve() {
        var routerLoaded = false;

        if (route.route.keepAlive && route.route.keepAliveData) {
          loadBack(router, {
            el: route.route.keepAliveData.pageEl
          }, options);
          routerLoaded = true;
        }

        'url content component pageName el componentUrl'.split(' ').forEach(function (pageLoadProp) {
          if (route.route[pageLoadProp] && !routerLoaded) {
            var _loadBack;

            routerLoaded = true;
            loadBack(router, (_loadBack = {}, _loadBack[pageLoadProp] = route.route[pageLoadProp], _loadBack), options);
          }
        });
        if (routerLoaded) return; // Async

        function asyncResolve(resolveParams, resolveOptions) {
          router.allowPageChange = false;
          loadBack(router, resolveParams, extend$1(options, resolveOptions), true);
        }

        function asyncReject() {
          router.allowPageChange = true;
        }

        if (route.route.async) {
          router.allowPageChange = false;
          route.route.async.call(router, {
            router: router,
            to: route,
            from: router.currentRoute,
            resolve: asyncResolve,
            reject: asyncReject,
            direction: 'backward',
            app: app
          });
        }

        if (route.route.asyncComponent) {
          asyncComponent(router, route.route.asyncComponent, asyncResolve, asyncReject);
        }
      }

      function reject() {
        router.allowPageChange = true;
      }

      if (options.preload) {
        resolve();
      } else {
        processRouteQueue.call(router, route, router.currentRoute, function () {
          if (route.route.modules) {
            app.loadModules(Array.isArray(route.route.modules) ? route.route.modules : [route.route.modules]).then(function () {
              resolve();
            }).catch(function () {
              reject();
            });
          } else {
            resolve();
          }
        }, function () {
          reject();
        }, 'backward');
      } // Return Router


      return router;
    }

    function clearPreviousPages(router) {
      appRouterCheck(router, 'clearPreviousPages');
      var app = router.app;
      var dynamicNavbar = router.dynamicNavbar;
      var $pagesToRemove = router.$el.children('.page').filter(function (pageInView) {
        if (router.currentRoute && (router.currentRoute.modal || router.currentRoute.panel)) return true;
        return pageInView !== router.currentPageEl;
      });
      $pagesToRemove.each(function (pageEl) {
        var $oldPageEl = $(pageEl);
        var $oldNavbarEl = $(app.navbar.getElByPage($oldPageEl));

        if (router.params.stackPages && router.initialPages.indexOf($oldPageEl[0]) >= 0) {
          $oldPageEl.addClass('stacked');

          if (dynamicNavbar) {
            $oldNavbarEl.addClass('stacked');
          }
        } else {
          // Page remove event
          router.pageCallback('beforeRemove', $oldPageEl, $oldNavbarEl, 'previous', undefined, {});
          router.removePage($oldPageEl);

          if (dynamicNavbar && $oldNavbarEl.length) {
            router.removeNavbar($oldNavbarEl);
          }
        }
      });
    }

    function clearPreviousHistory() {
      var router = this;
      appRouterCheck(router, 'clearPreviousHistory');
      var url = router.history[router.history.length - 1];
      clearPreviousPages(router);
      router.history = [url];
      router.view.history = [url];
      router.saveHistory();
    }
     // eslint-disable-line

    var Router = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(Router, _Framework7Class);

      function Router(app, view) {
        var _this;

        _this = _Framework7Class.call(this, {}, [typeof view === 'undefined' ? app : view]) || this;

        var router = _assertThisInitialized(_this); // Is App Router


        router.isAppRouter = typeof view === 'undefined';

        if (router.isAppRouter) {
          // App Router
          extend$1(false, router, {
            app: app,
            params: app.params.view,
            routes: app.routes || [],
            cache: app.cache
          });
        } else {
          // View Router
          extend$1(false, router, {
            app: app,
            view: view,
            viewId: view.id,
            id: view.params.routerId,
            params: view.params,
            routes: view.routes,
            history: view.history,
            scrollHistory: view.scrollHistory,
            cache: app.cache,
            dynamicNavbar: app.theme === 'ios' && view.params.iosDynamicNavbar,
            initialPages: [],
            initialNavbars: []
          });
        } // Install Modules


        router.useModules(); // AllowPageChage

        router.allowPageChange = true; // Current Route

        var currentRoute = {};
        var previousRoute = {};
        Object.defineProperty(router, 'currentRoute', {
          enumerable: true,
          configurable: true,
          set: function set(newRoute) {
            if (newRoute === void 0) {
              newRoute = {};
            }

            previousRoute = extend$1({}, currentRoute);
            currentRoute = newRoute;
            if (!currentRoute) return;
            router.url = currentRoute.url;
            router.emit('routeChange', newRoute, previousRoute, router);
          },
          get: function get() {
            return currentRoute;
          }
        });
        Object.defineProperty(router, 'previousRoute', {
          enumerable: true,
          configurable: true,
          get: function get() {
            return previousRoute;
          },
          set: function set(newRoute) {
            previousRoute = newRoute;
          }
        });
        return router || _assertThisInitialized(_this);
      }

      var _proto = Router.prototype;

      _proto.mount = function mount() {
        var router = this;
        var view = router.view;
        var document = getDocument();
        extend$1(false, router, {
          tempDom: document.createElement('div'),
          $el: view.$el,
          el: view.el,
          $navbarsEl: view.$navbarsEl,
          navbarsEl: view.navbarsEl
        });
        router.emit('local::mount routerMount', router);
      };

      _proto.animatableNavElements = function animatableNavElements($newNavbarEl, $oldNavbarEl, toLarge, fromLarge, direction) {
        var router = this;
        var dynamicNavbar = router.dynamicNavbar;
        var animateIcon = router.params.iosAnimateNavbarBackIcon;
        var newNavEls;
        var oldNavEls;

        function animatableNavEl($el, $navbarInner) {
          var isSliding = $el.hasClass('sliding') || $navbarInner.hasClass('sliding');
          var isSubnavbar = $el.hasClass('subnavbar');
          var needsOpacityTransition = isSliding ? !isSubnavbar : true;
          var $iconEl = $el.find('.back .icon');
          var isIconLabel;

          if (isSliding && animateIcon && $el.hasClass('left') && $iconEl.length > 0 && $iconEl.next('span').length) {
            $el = $iconEl.next('span'); // eslint-disable-line

            isIconLabel = true;
          }

          return {
            $el: $el,
            isIconLabel: isIconLabel,
            leftOffset: $el[0].f7NavbarLeftOffset,
            rightOffset: $el[0].f7NavbarRightOffset,
            isSliding: isSliding,
            isSubnavbar: isSubnavbar,
            needsOpacityTransition: needsOpacityTransition
          };
        }

        if (dynamicNavbar) {
          newNavEls = [];
          oldNavEls = [];
          $newNavbarEl.children('.navbar-inner').children('.left, .right, .title, .subnavbar').each(function (navEl) {
            var $navEl = $(navEl);
            if ($navEl.hasClass('left') && fromLarge && direction === 'forward') return;
            if ($navEl.hasClass('title') && toLarge) return;
            newNavEls.push(animatableNavEl($navEl, $newNavbarEl.children('.navbar-inner')));
          });

          if (!($oldNavbarEl.hasClass('navbar-master') && router.params.masterDetailBreakpoint > 0 && router.app.width >= router.params.masterDetailBreakpoint)) {
            $oldNavbarEl.children('.navbar-inner').children('.left, .right, .title, .subnavbar').each(function (navEl) {
              var $navEl = $(navEl);
              if ($navEl.hasClass('left') && toLarge && !fromLarge && direction === 'forward') return;
              if ($navEl.hasClass('left') && toLarge && direction === 'backward') return;

              if ($navEl.hasClass('title') && fromLarge) {
                return;
              }

              oldNavEls.push(animatableNavEl($navEl, $oldNavbarEl.children('.navbar-inner')));
            });
          }

          [oldNavEls, newNavEls].forEach(function (navEls) {
            navEls.forEach(function (navEl) {
              var n = navEl;
              var isSliding = navEl.isSliding,
                  $el = navEl.$el;
              var otherEls = navEls === oldNavEls ? newNavEls : oldNavEls;
              if (!(isSliding && $el.hasClass('title') && otherEls)) return;
              otherEls.forEach(function (otherNavEl) {
                if (otherNavEl.isIconLabel) {
                  var iconTextEl = otherNavEl.$el[0];
                  n.leftOffset += iconTextEl ? iconTextEl.offsetLeft || 0 : 0;
                }
              });
            });
          });
        }

        return {
          newNavEls: newNavEls,
          oldNavEls: oldNavEls
        };
      };

      _proto.animate = function animate($oldPageEl, $newPageEl, $oldNavbarEl, $newNavbarEl, direction, transition, callback) {
        var router = this;

        if (router.params.animateCustom) {
          router.params.animateCustom.apply(router, [$oldPageEl, $newPageEl, $oldNavbarEl, $newNavbarEl, direction, callback]);
          return;
        }

        var dynamicNavbar = router.dynamicNavbar;
        var ios = router.app.theme === 'ios';

        if (transition) {
          var routerCustomTransitionClass = "router-transition-custom router-transition-" + transition + "-" + direction; // Animate

          var onCustomTransitionDone = function onCustomTransitionDone() {
            router.$el.removeClass(routerCustomTransitionClass);

            if (dynamicNavbar && router.$navbarsEl.length) {
              if ($newNavbarEl) {
                router.$navbarsEl.prepend($newNavbarEl);
              }

              if ($oldNavbarEl) {
                router.$navbarsEl.prepend($oldNavbarEl);
              }
            }

            if (callback) callback();
          };

          (direction === 'forward' ? $newPageEl : $oldPageEl).animationEnd(onCustomTransitionDone);

          if (dynamicNavbar) {
            if ($newNavbarEl && $newPageEl) {
              router.setNavbarPosition($newNavbarEl, '');
              $newNavbarEl.removeClass('navbar-next navbar-previous navbar-current');
              $newPageEl.prepend($newNavbarEl);
            }

            if ($oldNavbarEl && $oldPageEl) {
              router.setNavbarPosition($oldNavbarEl, '');
              $oldNavbarEl.removeClass('navbar-next navbar-previous navbar-current');
              $oldPageEl.prepend($oldNavbarEl);
            }
          }

          router.$el.addClass(routerCustomTransitionClass);
          return;
        } // Router Animation class


        var routerTransitionClass = "router-transition-" + direction + " router-transition";
        var newNavEls;
        var oldNavEls;
        var fromLarge;
        var toLarge;
        var toDifferent;
        var oldIsLarge;
        var newIsLarge;

        if (ios && dynamicNavbar) {
          var betweenMasterAndDetail = router.params.masterDetailBreakpoint > 0 && router.app.width >= router.params.masterDetailBreakpoint && ($oldNavbarEl.hasClass('navbar-master') && $newNavbarEl.hasClass('navbar-master-detail') || $oldNavbarEl.hasClass('navbar-master-detail') && $newNavbarEl.hasClass('navbar-master'));

          if (!betweenMasterAndDetail) {
            oldIsLarge = $oldNavbarEl && $oldNavbarEl.hasClass('navbar-large');
            newIsLarge = $newNavbarEl && $newNavbarEl.hasClass('navbar-large');
            fromLarge = oldIsLarge && !$oldNavbarEl.hasClass('navbar-large-collapsed');
            toLarge = newIsLarge && !$newNavbarEl.hasClass('navbar-large-collapsed');
            toDifferent = fromLarge && !toLarge || toLarge && !fromLarge;
          }

          var navEls = router.animatableNavElements($newNavbarEl, $oldNavbarEl, toLarge, fromLarge, direction);
          newNavEls = navEls.newNavEls;
          oldNavEls = navEls.oldNavEls;
        }

        function animateNavbars(progress) {
          if (!(ios && dynamicNavbar)) return;

          if (progress === 1) {
            if (toLarge) {
              $newNavbarEl.addClass('router-navbar-transition-to-large');
              $oldNavbarEl.addClass('router-navbar-transition-to-large');
            }

            if (fromLarge) {
              $newNavbarEl.addClass('router-navbar-transition-from-large');
              $oldNavbarEl.addClass('router-navbar-transition-from-large');
            }
          }

          newNavEls.forEach(function (navEl) {
            var $el = navEl.$el;
            var offset = direction === 'forward' ? navEl.rightOffset : navEl.leftOffset;

            if (navEl.isSliding) {
              if (navEl.isSubnavbar && newIsLarge) {
                // prettier-ignore
                $el[0].style.setProperty('transform', "translate3d(" + offset * (1 - progress) + "px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)", 'important');
              } else {
                $el.transform("translate3d(" + offset * (1 - progress) + "px,0,0)");
              }
            }
          });
          oldNavEls.forEach(function (navEl) {
            var $el = navEl.$el;
            var offset = direction === 'forward' ? navEl.leftOffset : navEl.rightOffset;

            if (navEl.isSliding) {
              if (navEl.isSubnavbar && oldIsLarge) {
                $el.transform("translate3d(" + offset * progress + "px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)");
              } else {
                $el.transform("translate3d(" + offset * progress + "px,0,0)");
              }
            }
          });
        } // AnimationEnd Callback


        function onDone() {
          if (router.dynamicNavbar) {
            if ($newNavbarEl) {
              $newNavbarEl.removeClass('router-navbar-transition-to-large router-navbar-transition-from-large');
              $newNavbarEl.addClass('navbar-no-title-large-transition');
              nextFrame$1(function () {
                $newNavbarEl.removeClass('navbar-no-title-large-transition');
              });
            }

            if ($oldNavbarEl) {
              $oldNavbarEl.removeClass('router-navbar-transition-to-large router-navbar-transition-from-large');
            }

            if ($newNavbarEl.hasClass('sliding') || $newNavbarEl.children('.navbar-inner.sliding').length) {
              $newNavbarEl.find('.title, .left, .right, .left .icon, .subnavbar').transform('');
            } else {
              $newNavbarEl.find('.sliding').transform('');
            }

            if ($oldNavbarEl.hasClass('sliding') || $oldNavbarEl.children('.navbar-inner.sliding').length) {
              $oldNavbarEl.find('.title, .left, .right, .left .icon, .subnavbar').transform('');
            } else {
              $oldNavbarEl.find('.sliding').transform('');
            }
          }

          router.$el.removeClass(routerTransitionClass);
          if (callback) callback();
        }

        (direction === 'forward' ? $newPageEl : $oldPageEl).animationEnd(function () {
          onDone();
        }); // Animate

        if (dynamicNavbar) {
          // Prepare Navbars
          animateNavbars(0);
          nextFrame$1(function () {
            // Add class, start animation
            router.$el.addClass(routerTransitionClass);

            if (toDifferent) {
              // eslint-disable-next-line
              router.el._clientLeft = router.el.clientLeft;
            }

            animateNavbars(1);
          });
        } else {
          // Add class, start animation
          router.$el.addClass(routerTransitionClass);
        }
      };

      _proto.removeModal = function removeModal(modalEl) {
        var router = this;
        router.removeEl(modalEl);
      } // eslint-disable-next-line
      ;

      _proto.removeTabContent = function removeTabContent(tabEl) {
        var $tabEl = $(tabEl);
        $tabEl.html('');
      };

      _proto.removeNavbar = function removeNavbar(el) {
        var router = this;
        router.removeEl(el);
      };

      _proto.removePage = function removePage(el) {
        var $el = $(el);
        var f7Page = $el && $el[0] && $el[0].f7Page;
        var router = this;

        if (f7Page && f7Page.route && f7Page.route.route && f7Page.route.route.keepAlive) {
          $el.remove();
          return;
        }

        router.removeEl(el);
      };

      _proto.removeEl = function removeEl(el) {
        if (!el) return;
        var router = this;
        var $el = $(el);
        if ($el.length === 0) return;
        $el.find('.tab').each(function (tabEl) {
          $(tabEl).children().each(function (tabChild) {
            if (tabChild.f7Component) {
              $(tabChild).trigger('tab:beforeremove');
              tabChild.f7Component.destroy();
            }
          });
        });

        if ($el[0].f7Component && $el[0].f7Component.destroy) {
          $el[0].f7Component.destroy();
        }

        if (!router.params.removeElements) {
          return;
        }

        if (router.params.removeElementsWithTimeout) {
          setTimeout(function () {
            $el.remove();
          }, router.params.removeElementsTimeout);
        } else {
          $el.remove();
        }
      };

      _proto.getPageEl = function getPageEl(content) {
        var router = this;

        if (typeof content === 'string') {
          router.tempDom.innerHTML = content;
        } else {
          if ($(content).hasClass('page')) {
            return content;
          }

          router.tempDom.innerHTML = '';
          $(router.tempDom).append(content);
        }

        return router.findElement('.page', router.tempDom);
      };

      _proto.findElement = function findElement(stringSelector, container, notStacked) {
        var router = this;
        var view = router.view;
        var app = router.app; // Modals Selector

        var modalsSelector = '.popup, .dialog, .popover, .actions-modal, .sheet-modal, .login-screen, .page';
        var $container = $(container);
        var selector = stringSelector;
        if (notStacked) selector += ':not(.stacked)';
        var found = $container.find(selector).filter(function (el) {
          return $(el).parents(modalsSelector).length === 0;
        });

        if (found.length > 1) {
          if (typeof view.selector === 'string') {
            // Search in related view
            found = $container.find(view.selector + " " + selector);
          }

          if (found.length > 1) {
            // Search in main view
            found = $container.find("." + app.params.viewMainClass + " " + selector);
          }
        }

        if (found.length === 1) return found; // Try to find not stacked

        if (!notStacked) found = router.findElement(selector, $container, true);
        if (found && found.length === 1) return found;
        if (found && found.length > 1) return $(found[0]);
        return undefined;
      };

      _proto.flattenRoutes = function flattenRoutes(routes) {
        if (routes === void 0) {
          routes = this.routes;
        }

        var router = this;
        var flattenedRoutes = [];
        routes.forEach(function (route) {
          var hasTabRoutes = false;

          if ('tabs' in route && route.tabs) {
            var mergedPathsRoutes = route.tabs.map(function (tabRoute) {
              var tRoute = extend$1({}, route, {
                path: (route.path + "/" + tabRoute.path).replace('///', '/').replace('//', '/'),
                parentPath: route.path,
                tab: tabRoute
              });
              delete tRoute.tabs;
              delete tRoute.routes;
              return tRoute;
            });
            hasTabRoutes = true;
            flattenedRoutes = flattenedRoutes.concat(router.flattenRoutes(mergedPathsRoutes));
          }

          if ('detailRoutes' in route) {
            var _mergedPathsRoutes = route.detailRoutes.map(function (detailRoute) {
              var dRoute = extend$1({}, detailRoute);
              dRoute.masterRoute = route;
              dRoute.masterRoutePath = route.path;
              return dRoute;
            });

            flattenedRoutes = flattenedRoutes.concat(route, router.flattenRoutes(_mergedPathsRoutes));
          }

          if ('routes' in route) {
            var _mergedPathsRoutes2 = route.routes.map(function (childRoute) {
              var cRoute = extend$1({}, childRoute);
              cRoute.path = (route.path + "/" + cRoute.path).replace('///', '/').replace('//', '/');
              return cRoute;
            });

            if (hasTabRoutes) {
              flattenedRoutes = flattenedRoutes.concat(router.flattenRoutes(_mergedPathsRoutes2));
            } else {
              flattenedRoutes = flattenedRoutes.concat(route, router.flattenRoutes(_mergedPathsRoutes2));
            }
          }

          if (!('routes' in route) && !('tabs' in route && route.tabs) && !('detailRoutes' in route)) {
            flattenedRoutes.push(route);
          }
        });
        return flattenedRoutes;
      } // eslint-disable-next-line
      ;

      _proto.parseRouteUrl = function parseRouteUrl(url) {
        if (!url) return {};
        var query = parseUrlQuery(url);
        var hash = url.split('#')[1];
        var params = {};
        var path = url.split('#')[0].split('?')[0];
        return {
          query: query,
          hash: hash,
          params: params,
          url: url,
          path: path
        };
      };

      _proto.generateUrl = function generateUrl(parameters) {
        if (parameters === void 0) {
          parameters = {};
        }

        if (typeof parameters === 'string') {
          return parameters;
        }

        var _parameters = parameters,
            name = _parameters.name,
            path = _parameters.path,
            params = _parameters.params,
            query = _parameters.query;

        if (!name && !path) {
          throw new Error('Framework7: "name" or "path" parameter is required');
        }

        var router = this;
        var route = name ? router.findRouteByKey('name', name) : router.findRouteByKey('path', path);

        if (!route) {
          if (name) {
            throw new Error("Framework7: route with name \"" + name + "\" not found");
          } else {
            throw new Error("Framework7: route with path \"" + path + "\" not found");
          }
        }

        var url = router.constructRouteUrl(route, {
          params: params,
          query: query
        });

        if (!url) {
          throw new Error("Framework7: can't construct URL for route with name \"" + name + "\"");
        }

        return url;
      } // eslint-disable-next-line
      ;

      _proto.constructRouteUrl = function constructRouteUrl(route, _temp) {
        var _ref = _temp === void 0 ? {} : _temp,
            params = _ref.params,
            query = _ref.query;

        var path = route.path;
        var toUrl = compile(path);
        var url;

        try {
          url = toUrl(params || {});
        } catch (error) {
          throw new Error("Framework7: error constructing route URL from passed params:\nRoute: " + path + "\n" + error.toString());
        }

        if (query) {
          if (typeof query === 'string') url += "?" + query;else if (Object.keys(query).length) url += "?" + serializeObject(query);
        }

        return url;
      };

      _proto.findTabRouteUrl = function findTabRouteUrl(tabEl) {
        var router = this;
        var $tabEl = $(tabEl);
        var parentPath = router.currentRoute.route.parentPath;
        var tabId = $tabEl.attr('id');
        var flattenedRoutes = router.flattenRoutes(router.routes);
        var foundTabRouteUrl;
        flattenedRoutes.forEach(function (route) {
          if (route.parentPath === parentPath && route.tab && route.tab.id === tabId) {
            if (router.currentRoute.params && Object.keys(router.currentRoute.params).length > 0) {
              foundTabRouteUrl = router.constructRouteUrl(route, {
                params: router.currentRoute.params,
                query: router.currentRoute.query
              });
            } else {
              foundTabRouteUrl = route.path;
            }
          }
        });
        return foundTabRouteUrl;
      };

      _proto.findRouteByKey = function findRouteByKey(key, value) {
        var router = this;
        var routes = router.routes;
        var flattenedRoutes = router.flattenRoutes(routes);
        var matchingRoute;
        flattenedRoutes.forEach(function (route) {
          if (matchingRoute) return;

          if (route[key] === value) {
            matchingRoute = route;
          }
        });
        return matchingRoute;
      };

      _proto.findMatchingRoute = function findMatchingRoute(url) {
        if (!url) return undefined;
        var router = this;
        var routes = router.routes;
        var flattenedRoutes = router.flattenRoutes(routes);

        var _router$parseRouteUrl = router.parseRouteUrl(url),
            path = _router$parseRouteUrl.path,
            query = _router$parseRouteUrl.query,
            hash = _router$parseRouteUrl.hash,
            params = _router$parseRouteUrl.params;

        var matchingRoute;
        flattenedRoutes.forEach(function (route) {
          if (matchingRoute) return;
          var keys = [];
          var pathsToMatch = [route.path];

          if (route.alias) {
            if (typeof route.alias === 'string') pathsToMatch.push(route.alias);else if (Array.isArray(route.alias)) {
              route.alias.forEach(function (aliasPath) {
                pathsToMatch.push(aliasPath);
              });
            }
          }

          var matched;
          pathsToMatch.forEach(function (pathToMatch) {
            if (matched) return;
            matched = pathToRegexp(pathToMatch, keys).exec(path);
          });

          if (matched) {
            keys.forEach(function (keyObj, index) {
              if (typeof keyObj.name === 'number') return;
              var paramValue = matched[index + 1];

              if (typeof paramValue === 'undefined' || paramValue === null) {
                params[keyObj.name] = paramValue;
              } else {
                params[keyObj.name] = decodeURIComponent(paramValue);
              }
            });
            var parentPath;

            if (route.parentPath) {
              parentPath = path.split('/').slice(0, route.parentPath.split('/').length - 1).join('/');
            }

            matchingRoute = {
              query: query,
              hash: hash,
              params: params,
              url: url,
              path: path,
              parentPath: parentPath,
              route: route,
              name: route.name
            };
          }
        });
        return matchingRoute;
      } // eslint-disable-next-line
      ;

      _proto.replaceRequestUrlParams = function replaceRequestUrlParams(url, options) {
        if (url === void 0) {
          url = '';
        }

        if (options === void 0) {
          options = {};
        }

        var compiledUrl = url;

        if (typeof compiledUrl === 'string' && compiledUrl.indexOf('{{') >= 0 && options && options.route && options.route.params && Object.keys(options.route.params).length) {
          Object.keys(options.route.params).forEach(function (paramName) {
            var regExp = new RegExp("{{" + paramName + "}}", 'g');
            compiledUrl = compiledUrl.replace(regExp, options.route.params[paramName] || '');
          });
        }

        return compiledUrl;
      };

      _proto.removeFromXhrCache = function removeFromXhrCache(url) {
        var router = this;
        var xhrCache = router.cache.xhr;
        var index = false;

        for (var i = 0; i < xhrCache.length; i += 1) {
          if (xhrCache[i].url === url) index = i;
        }

        if (index !== false) xhrCache.splice(index, 1);
      };

      _proto.xhrRequest = function xhrRequest(requestUrl, options) {
        var router = this;
        var params = router.params;
        var ignoreCache = options.ignoreCache;
        var url = requestUrl;
        var hasQuery = url.indexOf('?') >= 0;

        if (params.passRouteQueryToRequest && options && options.route && options.route.query && Object.keys(options.route.query).length) {
          url += "" + (hasQuery ? '&' : '?') + serializeObject(options.route.query);
          hasQuery = true;
        }

        if (params.passRouteParamsToRequest && options && options.route && options.route.params && Object.keys(options.route.params).length) {
          url += "" + (hasQuery ? '&' : '?') + serializeObject(options.route.params);
          hasQuery = true;
        }

        if (url.indexOf('{{') >= 0) {
          url = router.replaceRequestUrlParams(url, options);
        } // should we ignore get params or not


        if (params.xhrCacheIgnoreGetParameters && url.indexOf('?') >= 0) {
          url = url.split('?')[0];
        }

        return new Promise(function (resolve, reject) {
          if (params.xhrCache && !ignoreCache && url.indexOf('nocache') < 0 && params.xhrCacheIgnore.indexOf(url) < 0) {
            for (var i = 0; i < router.cache.xhr.length; i += 1) {
              var cachedUrl = router.cache.xhr[i];

              if (cachedUrl.url === url) {
                // Check expiration
                if (now$1() - cachedUrl.time < params.xhrCacheDuration) {
                  // Load from cache
                  resolve(cachedUrl.content);
                  return;
                }
              }
            }
          }

          router.xhrAbortController = router.app.request.abortController();
          router.app.request({
            abortController: router.xhrAbortController,
            url: url,
            method: 'GET',
            beforeSend: function beforeSend(xhr) {
              router.emit('routerAjaxStart', xhr, options);
            },
            complete: function complete(xhr, status) {
              router.emit('routerAjaxComplete', xhr);

              if (status !== 'error' && status !== 'timeout' && xhr.status >= 200 && xhr.status < 300 || xhr.status === 0) {
                if (params.xhrCache && xhr.responseText !== '') {
                  router.removeFromXhrCache(url);
                  router.cache.xhr.push({
                    url: url,
                    time: now$1(),
                    content: xhr.responseText
                  });
                }

                router.emit('routerAjaxSuccess', xhr, options);
                resolve(xhr.responseText);
              } else {
                router.emit('routerAjaxError', xhr, options);
                reject(xhr);
              }
            },
            error: function error(xhr) {
              router.emit('routerAjaxError', xhr, options);
              reject(xhr);
            }
          });
        });
      };

      _proto.setNavbarPosition = function setNavbarPosition($el, position, ariaHidden) {
        var router = this;
        $el.removeClass('navbar-previous navbar-current navbar-next');

        if (position) {
          $el.addClass("navbar-" + position);
        }

        if (ariaHidden === false) {
          $el.removeAttr('aria-hidden');
        } else if (ariaHidden === true) {
          $el.attr('aria-hidden', 'true');
        }

        $el.trigger('navbar:position', {
          position: position
        });
        router.emit('navbarPosition', $el[0], position);
      };

      _proto.setPagePosition = function setPagePosition($el, position, ariaHidden) {
        var router = this;
        $el.removeClass('page-previous page-current page-next');
        $el.addClass("page-" + position);

        if (ariaHidden === false) {
          $el.removeAttr('aria-hidden');
        } else if (ariaHidden === true) {
          $el.attr('aria-hidden', 'true');
        }

        $el.trigger('page:position', {
          position: position
        });
        router.emit('pagePosition', $el[0], position);
      } // Remove theme elements
      ;

      _proto.removeThemeElements = function removeThemeElements(el) {
        var router = this;
        var theme = router.app.theme;
        var toRemove;

        if (theme === 'ios') {
          toRemove = '.md-only, .aurora-only, .if-md, .if-aurora, .if-not-ios, .not-ios';
        } else if (theme === 'md') {
          toRemove = '.ios-only, .aurora-only, .if-ios, .if-aurora, .if-not-md, .not-md';
        } else if (theme === 'aurora') {
          toRemove = '.ios-only, .md-only, .if-ios, .if-md, .if-not-aurora, .not-aurora';
        }

        $(el).find(toRemove).remove();
      };

      _proto.getPageData = function getPageData(pageEl, navbarEl, from, to, route, pageFromEl) {
        if (route === void 0) {
          route = {};
        }

        var router = this;
        var $pageEl = $(pageEl).eq(0);
        var $navbarEl = $(navbarEl).eq(0);
        var currentPage = $pageEl[0].f7Page || {};
        var direction;
        var pageFrom;
        if (from === 'next' && to === 'current' || from === 'current' && to === 'previous') direction = 'forward';
        if (from === 'current' && to === 'next' || from === 'previous' && to === 'current') direction = 'backward';

        if (currentPage && !currentPage.fromPage) {
          var $pageFromEl = $(pageFromEl);

          if ($pageFromEl.length) {
            pageFrom = $pageFromEl[0].f7Page;
          }
        }

        pageFrom = currentPage.pageFrom || pageFrom;

        if (pageFrom && pageFrom.pageFrom) {
          pageFrom.pageFrom = null;
        }

        var page = {
          app: router.app,
          view: router.view,
          router: router,
          $el: $pageEl,
          el: $pageEl[0],
          $pageEl: $pageEl,
          pageEl: $pageEl[0],
          $navbarEl: $navbarEl,
          navbarEl: $navbarEl[0],
          name: $pageEl.attr('data-name'),
          position: from,
          from: from,
          to: to,
          direction: direction,
          route: currentPage.route ? currentPage.route : route,
          pageFrom: pageFrom
        };
        $pageEl[0].f7Page = page;
        return page;
      } // Callbacks
      ;

      _proto.pageCallback = function pageCallback(callback, pageEl, navbarEl, from, to, options, pageFromEl) {
        if (options === void 0) {
          options = {};
        }

        if (!pageEl) return;
        var router = this;
        var $pageEl = $(pageEl);
        if (!$pageEl.length) return;
        var $navbarEl = $(navbarEl);
        var _options = options,
            route = _options.route;
        var restoreScrollTopOnBack = router.params.restoreScrollTopOnBack && !(router.params.masterDetailBreakpoint > 0 && $pageEl.hasClass('page-master') && router.app.width >= router.params.masterDetailBreakpoint);
        var keepAlive = $pageEl[0].f7Page && $pageEl[0].f7Page.route && $pageEl[0].f7Page.route.route && $pageEl[0].f7Page.route.route.keepAlive;

        if (callback === 'beforeRemove' && keepAlive) {
          callback = 'beforeUnmount'; // eslint-disable-line
        }

        var camelName = "page" + (callback[0].toUpperCase() + callback.slice(1, callback.length));
        var colonName = "page:" + callback.toLowerCase();
        var page = {};

        if (callback === 'beforeRemove' && $pageEl[0].f7Page) {
          page = extend$1($pageEl[0].f7Page, {
            from: from,
            to: to,
            position: from
          });
        } else {
          page = router.getPageData($pageEl[0], $navbarEl[0], from, to, route, pageFromEl);
        }

        page.swipeBack = !!options.swipeBack;

        var _ref2 = options.route ? options.route.route : {},
            _ref2$on = _ref2.on,
            on = _ref2$on === void 0 ? {} : _ref2$on,
            _ref2$once = _ref2.once,
            once = _ref2$once === void 0 ? {} : _ref2$once;

        if (options.on) {
          extend$1(on, options.on);
        }

        if (options.once) {
          extend$1(once, options.once);
        }

        function attachEvents() {
          if ($pageEl[0].f7RouteEventsAttached) return;
          $pageEl[0].f7RouteEventsAttached = true;

          if (on && Object.keys(on).length > 0) {
            $pageEl[0].f7RouteEventsOn = on;
            Object.keys(on).forEach(function (eventName) {
              on[eventName] = on[eventName].bind(router);
              $pageEl.on(eventNameToColonCase(eventName), on[eventName]);
            });
          }

          if (once && Object.keys(once).length > 0) {
            $pageEl[0].f7RouteEventsOnce = once;
            Object.keys(once).forEach(function (eventName) {
              once[eventName] = once[eventName].bind(router);
              $pageEl.once(eventNameToColonCase(eventName), once[eventName]);
            });
          }
        }

        function detachEvents() {
          if (!$pageEl[0].f7RouteEventsAttached) return;

          if ($pageEl[0].f7RouteEventsOn) {
            Object.keys($pageEl[0].f7RouteEventsOn).forEach(function (eventName) {
              $pageEl.off(eventNameToColonCase(eventName), $pageEl[0].f7RouteEventsOn[eventName]);
            });
          }

          if ($pageEl[0].f7RouteEventsOnce) {
            Object.keys($pageEl[0].f7RouteEventsOnce).forEach(function (eventName) {
              $pageEl.off(eventNameToColonCase(eventName), $pageEl[0].f7RouteEventsOnce[eventName]);
            });
          }

          $pageEl[0].f7RouteEventsAttached = null;
          $pageEl[0].f7RouteEventsOn = null;
          $pageEl[0].f7RouteEventsOnce = null;
          delete $pageEl[0].f7RouteEventsAttached;
          delete $pageEl[0].f7RouteEventsOn;
          delete $pageEl[0].f7RouteEventsOnce;
        }

        if (callback === 'mounted') {
          attachEvents();
        }

        if (callback === 'init') {
          if (restoreScrollTopOnBack && (from === 'previous' || !from) && to === 'current' && router.scrollHistory[page.route.url] && !$pageEl.hasClass('no-restore-scroll')) {
            var $pageContent = $pageEl.find('.page-content');

            if ($pageContent.length > 0) {
              // eslint-disable-next-line
              $pageContent = $pageContent.filter(function (pageContentEl) {
                return $(pageContentEl).parents('.tab:not(.tab-active)').length === 0 && !$(pageContentEl).is('.tab:not(.tab-active)');
              });
            }

            $pageContent.scrollTop(router.scrollHistory[page.route.url]);
          }

          attachEvents();

          if ($pageEl[0].f7PageInitialized) {
            $pageEl.trigger('page:reinit', page);
            router.emit('pageReinit', page);
            return;
          }

          $pageEl[0].f7PageInitialized = true;
        }

        if (restoreScrollTopOnBack && callback === 'beforeOut' && from === 'current' && to === 'previous') {
          // Save scroll position
          var _$pageContent = $pageEl.find('.page-content');

          if (_$pageContent.length > 0) {
            // eslint-disable-next-line
            _$pageContent = _$pageContent.filter(function (pageContentEl) {
              return $(pageContentEl).parents('.tab:not(.tab-active)').length === 0 && !$(pageContentEl).is('.tab:not(.tab-active)');
            });
          }

          router.scrollHistory[page.route.url] = _$pageContent.scrollTop();
        }

        if (restoreScrollTopOnBack && callback === 'beforeOut' && from === 'current' && to === 'next') {
          // Delete scroll position
          delete router.scrollHistory[page.route.url];
        }

        $pageEl.trigger(colonName, page);
        router.emit(camelName, page);

        if (callback === 'beforeRemove' || callback === 'beforeUnmount') {
          detachEvents();

          if (!keepAlive) {
            if ($pageEl[0].f7Page && $pageEl[0].f7Page.navbarEl) {
              delete $pageEl[0].f7Page.navbarEl.f7Page;
            }

            $pageEl[0].f7Page = null;
          }
        }
      };

      _proto.saveHistory = function saveHistory() {
        var router = this;
        var window = getWindow();
        router.view.history = router.history;

        if (router.params.browserHistory && router.params.browserHistoryStoreHistory && window.localStorage) {
          window.localStorage["f7router-" + router.view.id + "-history"] = JSON.stringify(router.history);
        }
      };

      _proto.restoreHistory = function restoreHistory() {
        var router = this;
        var window = getWindow();

        if (router.params.browserHistory && router.params.browserHistoryStoreHistory && window.localStorage && window.localStorage["f7router-" + router.view.id + "-history"]) {
          router.history = JSON.parse(window.localStorage["f7router-" + router.view.id + "-history"]);
          router.view.history = router.history;
        }
      };

      _proto.clearHistory = function clearHistory() {
        var router = this;
        router.history = [];
        if (router.view) router.view.history = [];
        router.saveHistory();
      };

      _proto.updateCurrentUrl = function updateCurrentUrl(newUrl) {
        var router = this;
        appRouterCheck(router, 'updateCurrentUrl'); // Update history

        if (router.history.length) {
          router.history[router.history.length - 1] = newUrl;
        } else {
          router.history.push(newUrl);
        } // Update current route params


        var _router$parseRouteUrl2 = router.parseRouteUrl(newUrl),
            query = _router$parseRouteUrl2.query,
            hash = _router$parseRouteUrl2.hash,
            params = _router$parseRouteUrl2.params,
            url = _router$parseRouteUrl2.url,
            path = _router$parseRouteUrl2.path;

        if (router.currentRoute) {
          extend$1(router.currentRoute, {
            query: query,
            hash: hash,
            params: params,
            url: url,
            path: path
          });
        }

        if (router.params.browserHistory) {
          var browserHistoryRoot = router.params.browserHistoryRoot || '';
          History$2.replace(router.view.id, {
            url: newUrl
          }, browserHistoryRoot + router.params.browserHistorySeparator + newUrl);
        } // Save History


        router.saveHistory();
        router.emit('routeUrlUpdate', router.currentRoute, router);
      };

      _proto.getInitialUrl = function getInitialUrl() {
        var router = this;

        if (router.initialUrl) {
          return {
            initialUrl: router.initialUrl,
            historyRestored: router.historyRestored
          };
        }

        var app = router.app,
            view = router.view;
        var document = getDocument();
        var window = getWindow();
        var location = app.params.url && typeof app.params.url === 'string' && typeof URL !== 'undefined' ? new URL(app.params.url) : document.location;
        var initialUrl = router.params.url;
        var documentUrl = location.href.split(location.origin)[1];
        var historyRestored;
        var _router$params = router.params,
            browserHistory = _router$params.browserHistory,
            browserHistoryOnLoad = _router$params.browserHistoryOnLoad,
            browserHistorySeparator = _router$params.browserHistorySeparator;
        var browserHistoryRoot = router.params.browserHistoryRoot;

        if ((window.cordova || window.Capacitor && window.Capacitor.isNative) && browserHistory && !browserHistorySeparator && !browserHistoryRoot && location.pathname.indexOf('index.html')) {
          // eslint-disable-next-line
          console.warn('Framework7: wrong or not complete browserHistory configuration, trying to guess browserHistoryRoot');
          browserHistoryRoot = location.pathname.split('index.html')[0];
        }

        if (!browserHistory || !browserHistoryOnLoad) {
          if (!initialUrl) {
            initialUrl = documentUrl;
          }

          if (location.search && initialUrl.indexOf('?') < 0) {
            initialUrl += location.search;
          }

          if (location.hash && initialUrl.indexOf('#') < 0) {
            initialUrl += location.hash;
          }
        } else {
          if (browserHistoryRoot && documentUrl.indexOf(browserHistoryRoot) >= 0) {
            documentUrl = documentUrl.split(browserHistoryRoot)[1];
            if (documentUrl === '') documentUrl = '/';
          }

          if (browserHistorySeparator.length > 0 && documentUrl.indexOf(browserHistorySeparator) >= 0) {
            initialUrl = documentUrl.split(browserHistorySeparator)[1];
          } else {
            initialUrl = documentUrl;
          }

          router.restoreHistory();

          if (router.history.indexOf(initialUrl) >= 0) {
            router.history = router.history.slice(0, router.history.indexOf(initialUrl) + 1);
          } else if (router.params.url === initialUrl) {
            router.history = [initialUrl];
          } else if (History$2.state && History$2.state[view.id] && History$2.state[view.id].url === router.history[router.history.length - 1]) {
            initialUrl = router.history[router.history.length - 1];
          } else {
            router.history = [documentUrl.split(browserHistorySeparator)[0] || '/', initialUrl];
          }

          if (router.history.length > 1) {
            historyRestored = true;
          } else {
            router.history = [];
          }

          router.saveHistory();
        }

        router.initialUrl = initialUrl;
        router.historyRestored = historyRestored;
        return {
          initialUrl: initialUrl,
          historyRestored: historyRestored
        };
      };

      _proto.init = function init() {
        var router = this;
        var app = router.app,
            view = router.view;
        var document = getDocument();
        router.mount();

        var _router$getInitialUrl = router.getInitialUrl(),
            initialUrl = _router$getInitialUrl.initialUrl,
            historyRestored = _router$getInitialUrl.historyRestored; // Init Swipeback


        if (view && router.params.iosSwipeBack && app.theme === 'ios' || view && router.params.mdSwipeBack && app.theme === 'md' || view && router.params.auroraSwipeBack && app.theme === 'aurora') {
          SwipeBack(router);
        }

        var _router$params2 = router.params,
            browserHistory = _router$params2.browserHistory,
            browserHistoryOnLoad = _router$params2.browserHistoryOnLoad,
            browserHistoryAnimateOnLoad = _router$params2.browserHistoryAnimateOnLoad,
            browserHistoryInitialMatch = _router$params2.browserHistoryInitialMatch;
        var currentRoute;

        if (router.history.length > 1) {
          // Will load page
          var initUrl = browserHistoryInitialMatch ? initialUrl : router.history[0];
          currentRoute = router.findMatchingRoute(initUrl);

          if (!currentRoute) {
            currentRoute = extend$1(router.parseRouteUrl(initUrl), {
              route: {
                url: initUrl,
                path: initUrl.split('?')[0]
              }
            });
          }
        } else {
          // Don't load page
          currentRoute = router.findMatchingRoute(initialUrl);

          if (!currentRoute) {
            currentRoute = extend$1(router.parseRouteUrl(initialUrl), {
              route: {
                url: initialUrl,
                path: initialUrl.split('?')[0]
              }
            });
          }
        }

        if (router.params.stackPages) {
          router.$el.children('.page').each(function (pageEl) {
            var $pageEl = $(pageEl);
            router.initialPages.push($pageEl[0]);

            if (router.dynamicNavbar && $pageEl.children('.navbar').length > 0) {
              router.initialNavbars.push($pageEl.children('.navbar')[0]);
            }
          });
        }

        if (router.$el.children('.page:not(.stacked)').length === 0 && initialUrl && router.params.loadInitialPage) {
          // No pages presented in DOM, reload new page
          router.navigate(initialUrl, {
            initial: true,
            reloadCurrent: true,
            browserHistory: false,
            animate: false,
            once: {
              modalOpen: function modalOpen() {
                if (!historyRestored) return;
                var preloadPreviousPage = router.params.preloadPreviousPage || router.params[app.theme + "SwipeBack"];

                if (preloadPreviousPage && router.history.length > 1) {
                  router.back({
                    preload: true
                  });
                }
              },
              pageAfterIn: function pageAfterIn() {
                if (!historyRestored) return;
                var preloadPreviousPage = router.params.preloadPreviousPage || router.params[app.theme + "SwipeBack"];

                if (preloadPreviousPage && router.history.length > 1) {
                  router.back({
                    preload: true
                  });
                }
              }
            }
          });
        } else if (router.$el.children('.page:not(.stacked)').length) {
          // Init current DOM page
          var hasTabRoute;
          router.currentRoute = currentRoute;
          router.$el.children('.page:not(.stacked)').each(function (pageEl) {
            var $pageEl = $(pageEl);
            var $navbarEl;
            router.setPagePosition($pageEl, 'current');

            if (router.dynamicNavbar) {
              $navbarEl = $pageEl.children('.navbar');

              if ($navbarEl.length > 0) {
                if (!router.$navbarsEl.parents(document).length) {
                  router.$el.prepend(router.$navbarsEl);
                }

                router.setNavbarPosition($navbarEl, 'current');
                router.$navbarsEl.append($navbarEl);

                if ($navbarEl.children('.title-large').length) {
                  $navbarEl.addClass('navbar-large');
                }

                $pageEl.children('.navbar').remove();
              } else {
                router.$navbarsEl.addClass('navbar-hidden');

                if ($navbarEl.children('.title-large').length) {
                  router.$navbarsEl.addClass('navbar-hidden navbar-large-hidden');
                }
              }
            }

            if (router.currentRoute && router.currentRoute.route && (router.currentRoute.route.master === true || typeof router.currentRoute.route.master === 'function' && router.currentRoute.route.master(app, router)) && router.params.masterDetailBreakpoint > 0) {
              $pageEl.addClass('page-master');
              $pageEl.trigger('page:role', {
                role: 'master'
              });

              if ($navbarEl && $navbarEl.length) {
                $navbarEl.addClass('navbar-master');
              }

              view.checkMasterDetailBreakpoint();
            }

            var initOptions = {
              route: router.currentRoute
            };

            if (router.currentRoute && router.currentRoute.route && router.currentRoute.route.options) {
              extend$1(initOptions, router.currentRoute.route.options);
            }

            router.currentPageEl = $pageEl[0];

            if (router.dynamicNavbar && $navbarEl.length) {
              router.currentNavbarEl = $navbarEl[0];
            }

            router.removeThemeElements($pageEl);

            if (router.dynamicNavbar && $navbarEl.length) {
              router.removeThemeElements($navbarEl);
            }

            if (initOptions.route.route.tab) {
              hasTabRoute = true;
              router.tabLoad(initOptions.route.route.tab, extend$1({}, initOptions));
            }

            router.pageCallback('init', $pageEl, $navbarEl, 'current', undefined, initOptions);
            router.pageCallback('beforeIn', $pageEl, $navbarEl, 'current', undefined, initOptions);
            router.pageCallback('afterIn', $pageEl, $navbarEl, 'current', undefined, initOptions);
          });

          if (historyRestored) {
            if (browserHistoryInitialMatch) {
              var preloadPreviousPage = router.params.preloadPreviousPage || router.params[app.theme + "SwipeBack"];

              if (preloadPreviousPage && router.history.length > 1) {
                router.back({
                  preload: true
                });
              }
            } else {
              router.navigate(initialUrl, {
                initial: true,
                browserHistory: false,
                history: false,
                animate: browserHistoryAnimateOnLoad,
                once: {
                  pageAfterIn: function pageAfterIn() {
                    var preloadPreviousPage = router.params.preloadPreviousPage || router.params[app.theme + "SwipeBack"];

                    if (preloadPreviousPage && router.history.length > 2) {
                      router.back({
                        preload: true
                      });
                    }
                  }
                }
              });
            }
          }

          if (!historyRestored && !hasTabRoute) {
            router.history.push(initialUrl);
            router.saveHistory();
          }
        }

        if (initialUrl && browserHistory && browserHistoryOnLoad && (!History$2.state || !History$2.state[view.id])) {
          History$2.initViewState(view.id, {
            url: initialUrl
          });
        }

        router.emit('local::init routerInit', router);
      };

      _proto.destroy = function destroy() {
        var router = this;
        router.emit('local::destroy routerDestroy', router); // Delete props & methods

        Object.keys(router).forEach(function (routerProp) {
          router[routerProp] = null;
          delete router[routerProp];
        });
        router = null;
      };

      return Router;
    }(Framework7Class); // Load


    Router.prototype.navigate = navigate;
    Router.prototype.refreshPage = refreshPage; // Tab

    Router.prototype.tabLoad = tabLoad;
    Router.prototype.tabRemove = tabRemove; // Modal

    Router.prototype.modalLoad = modalLoad;
    Router.prototype.modalRemove = modalRemove; // Back

    Router.prototype.back = back; // Clear history

    Router.prototype.clearPreviousHistory = clearPreviousHistory;

    var RouterModule = {
      name: 'router',
      static: {
        Router: Router
      },
      instance: {
        cache: {
          xhr: [],
          templates: [],
          components: []
        }
      },
      create: function create() {
        var instance = this;

        if (instance.app) {
          // View Router
          if (instance.params.router) {
            instance.router = new Router(instance.app, instance);
          }
        } else {
          // App Router
          instance.router = new Router(instance);
        }
      }
    };

    function resizableView(view) {
      var app = view.app;
      var support = getSupport$1();
      if (view.resizableInitialized) return;
      extend$1(view, {
        resizable: true,
        resizableWidth: null,
        resizableInitialized: true
      });
      var $htmlEl = $('html');
      var $el = view.$el;
      if (!$el) return;
      var $resizeHandlerEl;
      var isTouched;
      var isMoved;
      var touchesStart = {};
      var touchesDiff;
      var width;
      var minWidth;
      var maxWidth;

      function transformCSSWidth(v) {
        if (!v) return null;

        if (v.indexOf('%') >= 0 || v.indexOf('vw') >= 0) {
          return parseInt(v, 10) / 100 * app.width;
        }

        var newV = parseInt(v, 10);
        if (Number.isNaN(newV)) return null;
        return newV;
      }

      function isResizable() {
        return view.resizable && $el.hasClass('view-resizable') && $el.hasClass('view-master-detail');
      }

      function handleTouchStart(e) {
        if (!isResizable()) return;
        touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
        touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
        isMoved = false;
        isTouched = true;
        var $pageMasterEl = $el.children('.page-master');
        minWidth = transformCSSWidth($pageMasterEl.css('min-width'));
        maxWidth = transformCSSWidth($pageMasterEl.css('max-width'));
      }

      function handleTouchMove(e) {
        if (!isTouched) return;
        e.f7PreventSwipePanel = true;
        var pageX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;

        if (!isMoved) {
          width = $resizeHandlerEl[0].offsetLeft + $resizeHandlerEl[0].offsetWidth;
          $el.addClass('view-resizing');
          $htmlEl.css('cursor', 'col-resize');
        }

        isMoved = true;
        e.preventDefault();
        touchesDiff = pageX - touchesStart.x;
        var newWidth = width + touchesDiff;

        if (minWidth && !Number.isNaN(minWidth)) {
          newWidth = Math.max(newWidth, minWidth);
        }

        if (maxWidth && !Number.isNaN(maxWidth)) {
          newWidth = Math.min(newWidth, maxWidth);
        }

        newWidth = Math.min(Math.max(newWidth, 0), app.width);
        view.resizableWidth = newWidth;
        $htmlEl[0].style.setProperty('--f7-page-master-width', newWidth + "px");
        $el.trigger('view:resize', newWidth);
        view.emit('local::resize viewResize', view, newWidth);
      }

      function handleTouchEnd() {
        $('html').css('cursor', '');

        if (!isTouched || !isMoved) {
          isTouched = false;
          isMoved = false;
          return;
        }

        isTouched = false;
        isMoved = false;
        $htmlEl[0].style.setProperty('--f7-page-master-width', view.resizableWidth + "px");
        $el.removeClass('view-resizing');
      }

      function handleResize() {
        if (!view.resizableWidth) return;
        minWidth = transformCSSWidth($resizeHandlerEl.css('min-width'));
        maxWidth = transformCSSWidth($resizeHandlerEl.css('max-width'));

        if (minWidth && !Number.isNaN(minWidth) && view.resizableWidth < minWidth) {
          view.resizableWidth = Math.max(view.resizableWidth, minWidth);
        }

        if (maxWidth && !Number.isNaN(maxWidth) && view.resizableWidth > maxWidth) {
          view.resizableWidth = Math.min(view.resizableWidth, maxWidth);
        }

        view.resizableWidth = Math.min(Math.max(view.resizableWidth, 0), app.width);
        $htmlEl[0].style.setProperty('--f7-page-master-width', view.resizableWidth + "px");
      }

      $resizeHandlerEl = view.$el.children('.view-resize-handler');

      if (!$resizeHandlerEl.length) {
        view.$el.append('<div class="view-resize-handler"></div>');
        $resizeHandlerEl = view.$el.children('.view-resize-handler');
      }

      view.$resizeHandlerEl = $resizeHandlerEl;
      $el.addClass('view-resizable'); // Add Events

      var passive = support.passiveListener ? {
        passive: true
      } : false;
      view.$el.on(app.touchEvents.start, '.view-resize-handler', handleTouchStart, passive);
      app.on('touchmove:active', handleTouchMove);
      app.on('touchend:passive', handleTouchEnd);
      app.on('resize', handleResize);
      view.on('beforeOpen', handleResize);
      view.once('viewDestroy', function () {
        $el.removeClass('view-resizable');
        view.$resizeHandlerEl.remove();
        view.$el.off(app.touchEvents.start, '.view-resize-handler', handleTouchStart, passive);
        app.off('touchmove:active', handleTouchMove);
        app.off('touchend:passive', handleTouchEnd);
        app.off('resize', handleResize);
        view.off('beforeOpen', handleResize);
      });
    }

    var View$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(View, _Framework7Class);

      function View(app, el, viewParams) {
        var _this;

        if (viewParams === void 0) {
          viewParams = {};
        }

        _this = _Framework7Class.call(this, viewParams, [app]) || this;

        var view = _assertThisInitialized(_this);

        var ssr = view.params.routerId;
        var defaults = {
          routes: [],
          routesAdd: []
        };

        if (!ssr) {
          var $el = $(el);

          if (!$el.length) {
            var message = "Framework7: can't create a View instance because ";
            message += typeof el === 'string' ? "the selector \"" + el + "\" didn't match any element" : 'el must be an HTMLElement or Dom7 object';
            throw new Error(message);
          }
        } // Default View params


        view.params = extend$1({
          el: el
        }, defaults, app.params.view, viewParams); // Routes

        if (view.params.routes.length > 0) {
          view.routes = view.params.routes;
        } else {
          view.routes = [].concat(app.routes, view.params.routesAdd);
        } // View Props


        extend$1(false, view, {
          app: app,
          name: view.params.name,
          main: view.params.main,
          history: [],
          scrollHistory: {}
        }); // Install Modules

        view.useModules(); // Add to app

        app.views.push(view);

        if (view.main) {
          app.views.main = view;
        }

        if (view.name) {
          app.views[view.name] = view;
        } // Index


        view.index = app.views.indexOf(view); // View ID

        var viewId;

        if (view.name) {
          viewId = "view_" + view.name;
        } else if (view.main) {
          viewId = 'view_main';
        } else {
          viewId = "view_" + view.index;
        }

        view.id = viewId;

        if (!view.params.init) {
          return view || _assertThisInitialized(_this);
        } // Init View


        if (app.initialized) {
          view.init();
        } else {
          app.on('init', function () {
            view.init();
          });
        }

        return view || _assertThisInitialized(_this);
      }

      var _proto = View.prototype;

      _proto.destroy = function destroy() {
        var view = this;
        var app = view.app;
        view.$el.trigger('view:beforedestroy');
        view.emit('local::beforeDestroy viewBeforeDestroy', view);
        app.off('resize', view.checkMasterDetailBreakpoint);

        if (view.main) {
          app.views.main = null;
          delete app.views.main;
        } else if (view.name) {
          app.views[view.name] = null;
          delete app.views[view.name];
        }

        view.$el[0].f7View = null;
        delete view.$el[0].f7View;
        app.views.splice(app.views.indexOf(view), 1); // Destroy Router

        if (view.params.router && view.router) {
          view.router.destroy();
        }

        view.emit('local::destroy viewDestroy', view); // Delete props & methods

        Object.keys(view).forEach(function (viewProp) {
          view[viewProp] = null;
          delete view[viewProp];
        });
        view = null;
      };

      _proto.checkMasterDetailBreakpoint = function checkMasterDetailBreakpoint(force) {
        var view = this;
        var app = view.app;
        var wasMasterDetail = view.$el.hasClass('view-master-detail');
        var isMasterDetail = app.width >= view.params.masterDetailBreakpoint && view.$el.children('.page-master').length;

        if (typeof force === 'undefined' && isMasterDetail || force === true) {
          view.$el.addClass('view-master-detail');

          if (!wasMasterDetail) {
            view.emit('local::masterDetailBreakpoint viewMasterDetailBreakpoint', view);
            view.$el.trigger('view:masterDetailBreakpoint');
          }
        } else {
          view.$el.removeClass('view-master-detail');

          if (wasMasterDetail) {
            view.emit('local::masterDetailBreakpoint viewMasterDetailBreakpoint', view);
            view.$el.trigger('view:masterDetailBreakpoint');
          }
        }
      };

      _proto.initMasterDetail = function initMasterDetail() {
        var view = this;
        var app = view.app;
        view.checkMasterDetailBreakpoint = view.checkMasterDetailBreakpoint.bind(view);
        view.checkMasterDetailBreakpoint();

        if (view.params.masterDetailResizable) {
          resizableView(view);
        }

        app.on('resize', view.checkMasterDetailBreakpoint);
      };

      _proto.mount = function mount(viewEl) {
        var view = this;
        var app = view.app;
        var el = view.params.el || viewEl;
        var $el = $(el); // Selector

        var selector;
        if (typeof el === 'string') selector = el;else {
          // Supposed to be HTMLElement or Dom7
          selector = ($el.attr('id') ? "#" + $el.attr('id') : '') + ($el.attr('class') ? "." + $el.attr('class').replace(/ /g, '.').replace('.active', '') : '');
        } // DynamicNavbar

        var $navbarsEl;

        if (app.theme === 'ios' && view.params.iosDynamicNavbar) {
          $navbarsEl = $el.children('.navbars').eq(0);

          if ($navbarsEl.length === 0) {
            $navbarsEl = $('<div class="navbars"></div>');
          }
        }

        extend$1(view, {
          $el: $el,
          el: $el[0],
          main: view.main || $el.hasClass('view-main'),
          $navbarsEl: $navbarsEl,
          navbarsEl: $navbarsEl ? $navbarsEl[0] : undefined,
          selector: selector
        });

        if (view.main) {
          app.views.main = view;
        } // Save in DOM


        if ($el && $el[0]) {
          $el[0].f7View = view;
        }

        view.emit('local::mount viewMount', view);
      };

      _proto.init = function init(viewEl) {
        var view = this;
        view.mount(viewEl);

        if (view.params.router) {
          if (view.params.masterDetailBreakpoint > 0) {
            view.initMasterDetail();
          }

          view.router.init();
          view.$el.trigger('view:init');
          view.emit('local::init viewInit', view);
        }
      };

      return View;
    }(Framework7Class); // Use Router


    View$1.use(RouterModule);

    function initClicks(app) {
      function handleClicks(e) {
        var window = getWindow();
        var $clickedEl = $(e.target);
        var $clickedLinkEl = $clickedEl.closest('a');
        var isLink = $clickedLinkEl.length > 0;
        var url = isLink && $clickedLinkEl.attr('href'); // Check if link is external

        if (isLink) {
          if ($clickedLinkEl.is(app.params.clicks.externalLinks) || // eslint-disable-next-line
          url && url.indexOf('javascript:') >= 0) {
            var target = $clickedLinkEl.attr('target');

            if (url && window.cordova && window.cordova.InAppBrowser && (target === '_system' || target === '_blank')) {
              e.preventDefault();
              window.cordova.InAppBrowser.open(url, target);
            } else if (url && window.Capacitor && window.Capacitor.Plugins && window.Capacitor.Plugins.Browser && (target === '_system' || target === '_blank')) {
              e.preventDefault();
              window.Capacitor.Plugins.Browser.open({
                url: url
              });
            }

            return;
          }
        } // Modules Clicks


        Object.keys(app.modules).forEach(function (moduleName) {
          var moduleClicks = app.modules[moduleName].clicks;
          if (!moduleClicks) return;
          if (e.preventF7Router) return;
          Object.keys(moduleClicks).forEach(function (clickSelector) {
            var matchingClickedElement = $clickedEl.closest(clickSelector).eq(0);

            if (matchingClickedElement.length > 0) {
              moduleClicks[clickSelector].call(app, matchingClickedElement, matchingClickedElement.dataset(), e);
            }
          });
        }); // Load Page

        var clickedLinkData = {};

        if (isLink) {
          e.preventDefault();
          clickedLinkData = $clickedLinkEl.dataset();
        }

        clickedLinkData.clickedEl = $clickedLinkEl[0]; // Prevent Router

        if (e.preventF7Router) return;
        if ($clickedLinkEl.hasClass('prevent-router') || $clickedLinkEl.hasClass('router-prevent')) return;
        var validUrl = url && url.length > 0 && url[0] !== '#';

        if (validUrl || $clickedLinkEl.hasClass('back')) {
          var view;

          if (clickedLinkData.view && clickedLinkData.view === 'current') {
            view = app.views.current;
          } else if (clickedLinkData.view) {
            view = $(clickedLinkData.view)[0].f7View;
          } else {
            view = $clickedEl.parents('.view')[0] && $clickedEl.parents('.view')[0].f7View;

            if (!$clickedLinkEl.hasClass('back') && view && view.params.linksView) {
              if (typeof view.params.linksView === 'string') view = $(view.params.linksView)[0].f7View;else if (view.params.linksView instanceof View$1) view = view.params.linksView;
            }
          }

          if (!view) {
            if (app.views.main) view = app.views.main;
          }

          if (!view || !view.router) return;

          if ($clickedLinkEl[0].f7RouteProps) {
            clickedLinkData.props = $clickedLinkEl[0].f7RouteProps;
          }

          if ($clickedLinkEl.hasClass('back')) view.router.back(url, clickedLinkData);else view.router.navigate(url, clickedLinkData);
        }
      }

      app.on('click', handleClicks);
    }

    var ClicksModule = {
      name: 'clicks',
      params: {
        clicks: {
          // External Links
          externalLinks: '.external'
        }
      },
      on: {
        init: function init() {
          var app = this;
          initClicks(app);
        }
      }
    };

    var RouterComponentLoaderModule = {
      name: 'routerComponentLoader',
      proto: {
        componentLoader: function componentLoader(component, componentUrl, options, resolve, reject) {
          if (options === void 0) {
            options = {};
          }

          var router = this;
          var app = router.app;
          var url = typeof component === 'string' ? component : componentUrl;
          var compiledUrl = router.replaceRequestUrlParams(url, options);

          function compile(componentFunction) {
            var context = options.context || {};
            if (typeof context === 'function') context = context.call(router);else if (typeof context === 'string') {
              try {
                context = JSON.parse(context);
              } catch (err) {
                reject(err);
                throw err;
              }
            }
            var componentContext = merge({}, context, {
              f7route: options.route,
              f7router: router
            });
            var componentProps = merge(options.route ? options.route.params || {} : {}, options.props || {}, options.routeProps || {});
            var componentEl;
            var componentRoot;

            if (options.componentOptions && options.componentOptions.el) {
              componentEl = options.componentOptions.el;
            }

            if (options.componentOptions && options.componentOptions.root) {
              componentRoot = options.componentOptions.root;
            }

            app.component.create(componentFunction, componentProps, {
              context: componentContext,
              el: componentEl,
              root: componentRoot
            }).then(function (createdComponent) {
              resolve(createdComponent.el);
            }).catch(function (err) {
              reject(err);
              throw new Error(err);
            });
          }

          var cachedComponent;

          if (compiledUrl && router.params.componentCache) {
            router.cache.components.forEach(function (cached) {
              if (cached.url === compiledUrl) cachedComponent = cached.component;
            });
          }

          if (compiledUrl && cachedComponent) {
            compile(cachedComponent);
          } else if (compiledUrl && !cachedComponent) {
            // Load via XHR
            if (router.xhrAbortController) {
              router.xhrAbortController.abort();
              router.xhrAbortController = false;
            }

            router.xhrRequest(url, options).then(function (loadedComponent) {
              var parsedComponent = app.component.parse(loadedComponent);

              if (router.params.componentCache) {
                router.cache.components.push({
                  url: compiledUrl,
                  component: parsedComponent
                });
              }

              compile(parsedComponent);
            }).catch(function (err) {
              reject();
              throw err;
            });
          } else {
            compile(component);
          }
        },
        modalComponentLoader: function modalComponentLoader(_temp) {
          var _ref = _temp === void 0 ? {} : _temp,
              component = _ref.component,
              componentUrl = _ref.componentUrl,
              options = _ref.options,
              resolve = _ref.resolve,
              reject = _ref.reject;

          var router = this;
          router.componentLoader(component, componentUrl, options, function (el) {
            resolve(el);
          }, reject);
        },
        tabComponentLoader: function tabComponentLoader(_temp2) {
          var _ref2 = _temp2 === void 0 ? {} : _temp2,
              component = _ref2.component,
              componentUrl = _ref2.componentUrl,
              options = _ref2.options,
              resolve = _ref2.resolve,
              reject = _ref2.reject;

          var router = this;
          router.componentLoader(component, componentUrl, options, function (el) {
            resolve(el);
          }, reject);
        },
        pageComponentLoader: function pageComponentLoader(_temp3) {
          var _ref3 = _temp3 === void 0 ? {} : _temp3,
              component = _ref3.component,
              componentUrl = _ref3.componentUrl,
              options = _ref3.options,
              resolve = _ref3.resolve,
              reject = _ref3.reject;

          var router = this;
          router.componentLoader(component, componentUrl, options, function (el, newOptions) {
            if (newOptions === void 0) {
              newOptions = {};
            }

            resolve(el, newOptions);
          }, reject);
        }
      }
    };

    var n = function n(t, s, r, e) {
      var u;
      s[0] = 0;

      for (var h = 1; h < s.length; h++) {
        var p = s[h++],
            a = s[h] ? (s[0] |= p ? 1 : 2, r[s[h++]]) : s[++h];
        3 === p ? e[0] = a : 4 === p ? e[1] = Object.assign(e[1] || {}, a) : 5 === p ? (e[1] = e[1] || {})[s[++h]] = a : 6 === p ? e[1][s[++h]] += a + "" : p ? (u = t.apply(a, n(t, a, r, ["", null])), e.push(u), a[0] ? s[0] |= 2 : (s[h - 2] = 0, s[h] = u)) : e.push(a);
      }

      return e;
    },
        t = new Map();

    function htm (s) {
      var r = t.get(this);
      return r || (r = new Map(), t.set(this, r)), (r = n(this, r.get(s) || (r.set(s, r = function (n) {
        for (var t, s, r = 1, e = "", u = "", h = [0], p = function p(n) {
          1 === r && (n || (e = e.replace(/^\s*\n\s*|\s*\n\s*$/g, ""))) ? h.push(0, n, e) : 3 === r && (n || e) ? (h.push(3, n, e), r = 2) : 2 === r && "..." === e && n ? h.push(4, n, 0) : 2 === r && e && !n ? h.push(5, 0, !0, e) : r >= 5 && ((e || !n && 5 === r) && (h.push(r, 0, e, s), r = 6), n && (h.push(r, n, 0, s), r = 6)), e = "";
        }, a = 0; a < n.length; a++) {
          a && (1 === r && p(), p(a));

          for (var l = 0; l < n[a].length; l++) {
            t = n[a][l], 1 === r ? "<" === t ? (p(), h = [h], r = 3) : e += t : 4 === r ? "--" === e && ">" === t ? (r = 1, e = "") : e = t + e[0] : u ? t === u ? u = "" : e += t : '"' === t || "'" === t ? u = t : ">" === t ? (p(), r = 1) : r && ("=" === t ? (r = 5, s = e, e = "") : "/" === t && (r < 5 || ">" === n[a][l + 1]) ? (p(), 3 === r && (h = h[0]), r = h, (h = h[0]).push(2, 0, r), r = 0) : " " === t || "\t" === t || "\n" === t || "\r" === t ? (p(), r = 2) : e += t), 3 === r && "!--" === e && (r = 4, h = h[0]);
          }
        }

        return p(), h;
      }(s)), r), arguments, [])).length > 1 ? r : r[0];
    }

    var ignoreChildren$1 = [false, null, '', undefined];

    var h$1 = function h(type, props) {
      for (var _len = arguments.length, children = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        children[_key - 2] = arguments[_key];
      }

      return {
        type: type,
        props: props || {},
        children: flattenArray(children.filter(function (child) {
          return ignoreChildren$1.indexOf(child) < 0;
        }))
      };
    };

    var $h = htm.bind(h$1);

    function vnode(sel, data, children, text, elm) {
      var key = data === undefined ? undefined : data.key;
      return {
        sel: sel,
        data: data,
        children: children,
        text: text,
        elm: elm,
        key: key
      };
    }

    var array = Array.isArray;
    function primitive(s) {
      return typeof s === 'string' || typeof s === 'number';
    }

    function addNS(data, children, sel) {
      data.ns = 'http://www.w3.org/2000/svg';

      if (sel !== 'foreignObject' && children !== undefined) {
        for (var i = 0; i < children.length; ++i) {
          var childData = children[i].data;

          if (childData !== undefined) {
            addNS(childData, children[i].children, children[i].sel);
          }
        }
      }
    }

    function h(sel, b, c) {
      var data = {},
          children,
          text,
          i;

      if (c !== undefined) {
        data = b;

        if (array(c)) {
          children = c;
        } else if (primitive(c)) {
          text = c;
        } else if (c && c.sel) {
          children = [c];
        }
      } else if (b !== undefined) {
        if (array(b)) {
          children = b;
        } else if (primitive(b)) {
          text = b;
        } else if (b && b.sel) {
          children = [b];
        } else {
          data = b;
        }
      }

      if (array(children)) {
        for (i = 0; i < children.length; ++i) {
          if (primitive(children[i])) children[i] = vnode(undefined, undefined, undefined, children[i], undefined);
        }
      }

      if (sel[0] === 's' && sel[1] === 'v' && sel[2] === 'g' && (sel.length === 3 || sel[3] === '.' || sel[3] === '#')) {
        addNS(data, children, sel);
      }

      return vnode(sel, data, children, text, undefined);
    }
    ;

    var customComponents = {};

    var SELF_CLOSING = 'area base br col command embed hr img input keygen link menuitem meta param source track wbr'.split(' ');
    var PROPS_ATTRS = 'hidden checked disabled readonly selected autofocus autoplay required multiple value indeterminate routeProps innerHTML'.split(' ');
    var BOOLEAN_PROPS = 'hidden checked disabled readonly selected autofocus autoplay required multiple readOnly indeterminate'.split(' ');

    var getTagName = function getTagName(treeNode) {
      return typeof treeNode.type === 'function' ? treeNode.type.name || 'CustomComponent' : treeNode.type;
    };

    var toCamelCase = function toCamelCase(name) {
      return name.split('-').map(function (word, index) {
        if (index === 0) return word.toLowerCase();
        return word[0].toUpperCase() + word.substr(1);
      }).join('');
    };

    var propsFromAttrs = function propsFromAttrs() {
      var context = {};

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      args.forEach(function (obj) {
        if (obj === void 0) {
          obj = {};
        }

        Object.keys(obj).forEach(function (key) {
          context[toCamelCase(key)] = obj[key];
        });
      });
      return context;
    };

    var createCustomComponent = function createCustomComponent(_ref) {
      var f7 = _ref.f7,
          treeNode = _ref.treeNode,
          vnode = _ref.vnode,
          data = _ref.data;
      var component = typeof treeNode.type === 'function' ? treeNode.type : customComponents[treeNode.type];
      f7.component.create(component, propsFromAttrs(data.attrs || {}, data.props || {}), {
        el: vnode.elm,
        children: treeNode.children
      }).then(function (c) {
        if (vnode.data && vnode.data.on && c && c.$el) {
          Object.keys(vnode.data.on).forEach(function (eventName) {
            c.$el.on(eventName, vnode.data.on[eventName]);
          });
        } // eslint-disable-next-line


        vnode.elm.__component__ = c;
      });
    };

    var updateCustomComponent = function updateCustomComponent(vnode) {
      // eslint-disable-next-line
      var component = vnode && vnode.elm && vnode.elm.__component__;
      if (!component) return;
      var newProps = propsFromAttrs(vnode.data.attrs || {}, vnode.data.props || {});
      component.children = vnode.data.treeNode.children;
      Object.assign(component.props, newProps);
      component.update();
    };

    var destroyCustomComponent = function destroyCustomComponent(vnode) {
      // eslint-disable-next-line
      var component = vnode && vnode.elm && vnode.elm.__component__;

      if (component) {
        var el = component.el,
            $el = component.$el;

        if (vnode.data && vnode.data.on && $el) {
          Object.keys(vnode.data.on).forEach(function (eventName) {
            $el.off(eventName, vnode.data.on[eventName]);
          });
        }

        if (component.destroy) component.destroy();
        if (el && el.parentNode) el.parentNode.removeChild(el);
        delete vnode.elm.__component__; // eslint-disable-line
      }
    };

    var isCustomComponent = function isCustomComponent(treeNodeType) {
      return typeof treeNodeType === 'function' || treeNodeType && treeNodeType.indexOf('-') > 0 && customComponents[treeNodeType];
    };

    function getHooks(treeNode, data, f7, initial, isRoot) {
      var hooks = {};
      var insert = [];
      var destroy = [];
      var update = [];
      var postpatch = [];
      var isFakeElement = false;
      var tagName = getTagName(treeNode);

      if (data && data.attrs && data.attrs.component) {
        // eslint-disable-next-line
        data.attrs.component, _readOnlyError("tagName");
        delete data.attrs.component;
        isFakeElement = true;
      }

      var isCustom = isCustomComponent(treeNode.type);

      if (isCustom) {
        insert.push(function (vnode) {
          if (vnode.sel !== tagName && !isFakeElement) return;
          createCustomComponent({
            f7: f7,
            treeNode: treeNode,
            vnode: vnode,
            data: data
          });
        });
        destroy.push(function (vnode) {
          destroyCustomComponent(vnode);
        });
        update.push(function (oldVnode, vnode) {
          updateCustomComponent(vnode);
        });
      }

      if (!isCustom) {
        if (!data || !data.attrs || !data.attrs.class) return hooks;
        var classNames = data.attrs.class;
        classNames.split(' ').forEach(function (className) {
          if (!initial) {
            insert.push.apply(insert, f7.getVnodeHooks('insert', className));
          }

          destroy.push.apply(destroy, f7.getVnodeHooks('destroy', className));
          update.push.apply(update, f7.getVnodeHooks('update', className));
          postpatch.push.apply(postpatch, f7.getVnodeHooks('postpatch', className));
        });
      }

      if (isRoot && !initial) {
        postpatch.push(function (oldVnode, vnode) {
          var vn = vnode || oldVnode;
          if (!vn) return;

          if (vn.data && vn.data.component) {
            vn.data.component.hook('onUpdated');
          }
        });
      }

      if (insert.length === 0 && destroy.length === 0 && update.length === 0 && postpatch.length === 0) {
        return hooks;
      }

      if (insert.length) {
        hooks.insert = function (vnode) {
          insert.forEach(function (f) {
            return f(vnode);
          });
        };
      }

      if (destroy.length) {
        hooks.destroy = function (vnode) {
          destroy.forEach(function (f) {
            return f(vnode);
          });
        };
      }

      if (update.length) {
        hooks.update = function (oldVnode, vnode) {
          update.forEach(function (f) {
            return f(oldVnode, vnode);
          });
        };
      }

      if (postpatch.length) {
        hooks.postpatch = function (oldVnode, vnode) {
          postpatch.forEach(function (f) {
            return f(oldVnode, vnode);
          });
        };
      }

      return hooks;
    }

    var getEventHandler = function getEventHandler(eventHandler, _temp) {
      var _ref2 = _temp === void 0 ? {} : _temp,
          stop = _ref2.stop,
          prevent = _ref2.prevent,
          once = _ref2.once;

      var fired = false;

      function handler() {
        var e = arguments.length <= 0 ? undefined : arguments[0];
        if (once && fired) return;
        if (stop) e.stopPropagation();
        if (prevent) e.preventDefault();
        fired = true;
        eventHandler.apply(void 0, arguments);
      }

      return handler;
    };

    var getData = function getData(treeNode, component, f7, initial, isRoot) {
      var data = {
        component: component,
        treeNode: treeNode
      };
      var tagName = getTagName(treeNode);
      Object.keys(treeNode.props).forEach(function (attrName) {
        var attrValue = treeNode.props[attrName];
        if (typeof attrValue === 'undefined') return;

        if (PROPS_ATTRS.indexOf(attrName) >= 0) {
          // Props
          if (!data.props) data.props = {};

          if (attrName === 'readonly') {
            // eslint-disable-next-line
            attrName = 'readOnly';
          }

          if (attrName === 'routeProps') {
            // eslint-disable-next-line
            attrName = 'f7RouteProps';
          }

          if (tagName === 'option' && attrName === 'value') {
            if (!data.attrs) data.attrs = {};
            data.attrs.value = attrValue;
          }

          if (BOOLEAN_PROPS.indexOf(attrName) >= 0) {
            // eslint-disable-next-line
            data.props[attrName] = attrValue === false ? false : true;
          } else {
            data.props[attrName] = attrValue;
          }
        } else if (attrName === 'key') {
          // Key
          data.key = attrValue;
        } else if (attrName.indexOf('@') === 0 || attrName.indexOf('on') === 0 && attrName.length > 2) {
          // Events
          if (!data.on) data.on = {};
          var eventName = attrName.indexOf('@') === 0 ? attrName.substr(1) : eventNameToColonCase(attrName.substr(2));
          var stop = false;
          var prevent = false;
          var once = false;

          if (eventName.indexOf('.') >= 0) {
            eventName.split('.').forEach(function (eventNamePart, eventNameIndex) {
              if (eventNameIndex === 0) eventName = eventNamePart;else {
                if (eventNamePart === 'stop') stop = true;
                if (eventNamePart === 'prevent') prevent = true;
                if (eventNamePart === 'once') once = true;
              }
            });
          }

          data.on[eventName] = getEventHandler(attrValue, {
            stop: stop,
            prevent: prevent,
            once: once
          });
        } else if (attrName === 'style') {
          // Style
          if (typeof attrValue !== 'string') {
            data.style = attrValue;
          } else {
            if (!data.attrs) data.attrs = {};
            data.attrs.style = attrValue;
          }
        } else {
          // Rest of attribures
          if (!data.attrs) data.attrs = {};
          data.attrs[attrName] = attrValue; // ID -> Key

          if (attrName === 'id' && !data.key && !isRoot) {
            data.key = attrValue;
          }
        }
      });
      var hooks = getHooks(treeNode, data, f7, initial, isRoot);

      hooks.prepatch = function (oldVnode, vnode) {
        if (!oldVnode || !vnode) return;

        if (oldVnode && oldVnode.data && oldVnode.data.props) {
          Object.keys(oldVnode.data.props).forEach(function (key) {
            if (BOOLEAN_PROPS.indexOf(key) < 0) return;
            if (!vnode.data) vnode.data = {};
            if (!vnode.data.props) vnode.data.props = {};

            if (oldVnode.data.props[key] === true && !(key in vnode.data.props)) {
              vnode.data.props[key] = false;
            }
          });
        }
      };

      data.hook = hooks;
      return data;
    };

    var getChildren = function getChildren(treeNode, component, f7, initial) {
      if (treeNode && treeNode.type && SELF_CLOSING.indexOf(treeNode.type) >= 0) {
        return [];
      }

      var children = [];
      var nodes = treeNode.children;

      for (var i = 0; i < nodes.length; i += 1) {
        var childNode = nodes[i];
        var child = treeNodeToVNode(childNode, component, f7, initial, false);

        if (Array.isArray(child)) {
          children.push.apply(children, child);
        } else if (child) {
          children.push(child);
        }
      }

      return children;
    };

    var getSlots = function getSlots(treeNode, component, f7, initial) {
      var slotName = treeNode.props.name || 'default';
      var slotNodes = (component.children || []).filter(function (childTreeNode) {
        var childSlotName = 'default';

        if (childTreeNode.props) {
          childSlotName = childTreeNode.props.slot || 'default';
        }

        return childSlotName === slotName;
      });

      if (slotNodes.length === 0) {
        return getChildren(treeNode, component, f7, initial);
      }

      return slotNodes.map(function (subTreeNode) {
        return treeNodeToVNode(subTreeNode, component, f7, initial);
      });
    };

    var isTreeNode = function isTreeNode(treeNode) {
      return isObject$1(treeNode) && 'props' in treeNode && 'type' in treeNode && 'children' in treeNode;
    };

    var treeNodeToVNode = function treeNodeToVNode(treeNode, component, f7, initial, isRoot) {
      if (!isTreeNode(treeNode)) {
        return String(treeNode);
      }

      if (treeNode.type === 'slot') {
        return getSlots(treeNode, component, f7, initial);
      }

      var data = getData(treeNode, component, f7, initial, isRoot);
      var children = isCustomComponent(treeNode.type) ? [] : getChildren(treeNode, component, f7, initial);
      return h(getTagName(treeNode), data, children);
    };

    function vdom(tree, component, initial) {
      if (tree === void 0) {
        tree = {};
      }

      return treeNodeToVNode(tree, component, component.f7, initial, true);
    }

    function createElement(tagName) {
      return document.createElement(tagName);
    }

    function createElementNS(namespaceURI, qualifiedName) {
      return document.createElementNS(namespaceURI, qualifiedName);
    }

    function createTextNode(text) {
      return document.createTextNode(text);
    }

    function createComment(text) {
      return document.createComment(text);
    }

    function insertBefore(parentNode, newNode, referenceNode) {
      if (referenceNode && referenceNode.parentNode !== parentNode) {
        if (referenceNode.__component__) referenceNode = referenceNode.__component__.el;
      }

      parentNode.insertBefore(newNode, referenceNode);
    }

    function removeChild(node, child) {
      if (!node) return;
      node.removeChild(child);
    }

    function appendChild(node, child) {
      node.appendChild(child);
    }

    function parentNode(node) {
      return node.parentNode;
    }

    function nextSibling(node) {
      return node.nextSibling;
    }

    function tagName(elm) {
      return elm.tagName;
    }

    function setTextContent(node, text) {
      node.textContent = text;
    }

    function getTextContent(node) {
      return node.textContent;
    }

    function isElement(node) {
      return node.nodeType === 1;
    }

    function isText(node) {
      return node.nodeType === 3;
    }

    function isComment(node) {
      return node.nodeType === 8;
    }

    var htmlDomApi = {
      createElement: createElement,
      createElementNS: createElementNS,
      createTextNode: createTextNode,
      createComment: createComment,
      insertBefore: insertBefore,
      removeChild: removeChild,
      appendChild: appendChild,
      parentNode: parentNode,
      nextSibling: nextSibling,
      tagName: tagName,
      setTextContent: setTextContent,
      getTextContent: getTextContent,
      isElement: isElement,
      isText: isText,
      isComment: isComment
    };

    function copyToThunk(vnode, thunk) {
      thunk.elm = vnode.elm;
      vnode.data.fn = thunk.data.fn;
      vnode.data.args = thunk.data.args;
      thunk.data = vnode.data;
      thunk.children = vnode.children;
      thunk.text = vnode.text;
      thunk.elm = vnode.elm;
    }

    function init$1(thunk) {
      var cur = thunk.data;
      var vnode = cur.fn.apply(undefined, cur.args);
      copyToThunk(vnode, thunk);
    }

    function prepatch(oldVnode, thunk) {
      var i,
          old = oldVnode.data,
          cur = thunk.data;
      var oldArgs = old.args,
          args = cur.args;

      if (old.fn !== cur.fn || oldArgs.length !== args.length) {
        copyToThunk(cur.fn.apply(undefined, args), thunk);
        return;
      }

      for (i = 0; i < args.length; ++i) {
        if (oldArgs[i] !== args[i]) {
          copyToThunk(cur.fn.apply(undefined, args), thunk);
          return;
        }
      }

      copyToThunk(oldVnode, thunk);
    }

    var thunk = function thunk(sel, key, fn, args) {
      if (args === undefined) {
        args = fn;
        fn = key;
        key = undefined;
      }

      return h(sel, {
        key: key,
        hook: {
          init: init$1,
          prepatch: prepatch
        },
        fn: fn,
        args: args
      });
    };

    function isUndef(s) {
      return s === undefined;
    }

    function isDef(s) {
      return s !== undefined;
    }

    var emptyNode = vnode('', {}, [], undefined, undefined);

    function sameVnode(vnode1, vnode2) {
      return vnode1.key === vnode2.key && vnode1.sel === vnode2.sel;
    }

    function isVnode(vnode) {
      return vnode.sel !== undefined;
    }

    function createKeyToOldIdx(children, beginIdx, endIdx) {
      var i,
          map = {},
          key,
          ch;

      for (i = beginIdx; i <= endIdx; ++i) {
        ch = children[i];

        if (ch != null) {
          key = ch.key;
          if (key !== undefined) map[key] = i;
        }
      }

      return map;
    }

    var hooks = ['create', 'update', 'remove', 'destroy', 'pre', 'post'];
    function init(modules, domApi) {
      var i,
          j,
          cbs = {};
      var api = domApi !== undefined ? domApi : htmlDomApi;

      for (i = 0; i < hooks.length; ++i) {
        cbs[hooks[i]] = [];

        for (j = 0; j < modules.length; ++j) {
          var hook = modules[j][hooks[i]];

          if (hook !== undefined) {
            cbs[hooks[i]].push(hook);
          }
        }
      }

      function emptyNodeAt(elm) {
        var id = elm.id ? '#' + elm.id : '';
        var c = elm.className ? '.' + elm.className.split(' ').join('.') : '';
        return vnode(api.tagName(elm).toLowerCase() + id + c, {}, [], undefined, elm);
      }

      function createRmCb(childElm, listeners) {
        return function rmCb() {
          if (--listeners === 0) {
            var parent_1 = api.parentNode(childElm);
            api.removeChild(parent_1, childElm);
          }
        };
      }

      function createElm(vnode, insertedVnodeQueue) {
        var i,
            data = vnode.data;

        if (data !== undefined) {
          if (isDef(i = data.hook) && isDef(i = i.init)) {
            i(vnode);
            data = vnode.data;
          }
        }

        var children = vnode.children,
            sel = vnode.sel;

        if (sel === '!') {
          if (isUndef(vnode.text)) {
            vnode.text = '';
          }

          vnode.elm = api.createComment(vnode.text);
        } else if (sel !== undefined) {
          // Parse selector
          var hashIdx = sel.indexOf('#');
          var dotIdx = sel.indexOf('.', hashIdx);
          var hash = hashIdx > 0 ? hashIdx : sel.length;
          var dot = dotIdx > 0 ? dotIdx : sel.length;
          var tag = hashIdx !== -1 || dotIdx !== -1 ? sel.slice(0, Math.min(hash, dot)) : sel;
          var elm = vnode.elm = isDef(data) && isDef(i = data.ns) ? api.createElementNS(i, tag) : api.createElement(tag);
          if (hash < dot) elm.setAttribute('id', sel.slice(hash + 1, dot));
          if (dotIdx > 0) elm.setAttribute('class', sel.slice(dot + 1).replace(/\./g, ' '));

          for (i = 0; i < cbs.create.length; ++i) {
            cbs.create[i](emptyNode, vnode);
          }

          if (array(children)) {
            for (i = 0; i < children.length; ++i) {
              var ch = children[i];

              if (ch != null) {
                api.appendChild(elm, createElm(ch, insertedVnodeQueue));
              }
            }
          } else if (primitive(vnode.text)) {
            api.appendChild(elm, api.createTextNode(vnode.text));
          }

          i = vnode.data.hook; // Reuse variable

          if (isDef(i)) {
            if (i.create) i.create(emptyNode, vnode);
            if (i.insert) insertedVnodeQueue.push(vnode);
          }
        } else {
          vnode.elm = api.createTextNode(vnode.text);
        }

        return vnode.elm;
      }

      function addVnodes(parentElm, before, vnodes, startIdx, endIdx, insertedVnodeQueue) {
        for (; startIdx <= endIdx; ++startIdx) {
          var ch = vnodes[startIdx];

          if (ch != null) {
            api.insertBefore(parentElm, createElm(ch, insertedVnodeQueue), before);
          }
        }
      }

      function invokeDestroyHook(vnode) {
        var i,
            j,
            data = vnode.data;

        if (data !== undefined) {
          if (isDef(i = data.hook) && isDef(i = i.destroy)) i(vnode);

          for (i = 0; i < cbs.destroy.length; ++i) {
            cbs.destroy[i](vnode);
          }

          if (vnode.children !== undefined) {
            for (j = 0; j < vnode.children.length; ++j) {
              i = vnode.children[j];

              if (i != null && typeof i !== "string") {
                invokeDestroyHook(i);
              }
            }
          }
        }
      }

      function removeVnodes(parentElm, vnodes, startIdx, endIdx) {
        for (; startIdx <= endIdx; ++startIdx) {
          var i_1 = void 0,
              listeners = void 0,
              rm = void 0,
              ch = vnodes[startIdx];

          if (ch != null) {
            if (isDef(ch.sel)) {
              invokeDestroyHook(ch);
              listeners = cbs.remove.length + 1;
              rm = createRmCb(ch.elm, listeners);

              for (i_1 = 0; i_1 < cbs.remove.length; ++i_1) {
                cbs.remove[i_1](ch, rm);
              }

              if (isDef(i_1 = ch.data) && isDef(i_1 = i_1.hook) && isDef(i_1 = i_1.remove)) {
                i_1(ch, rm);
              } else {
                rm();
              }
            } else {
              api.removeChild(parentElm, ch.elm);
            }
          }
        }
      }

      function updateChildren(parentElm, oldCh, newCh, insertedVnodeQueue) {
        var oldStartIdx = 0,
            newStartIdx = 0;
        var oldEndIdx = oldCh.length - 1;
        var oldStartVnode = oldCh[0];
        var oldEndVnode = oldCh[oldEndIdx];
        var newEndIdx = newCh.length - 1;
        var newStartVnode = newCh[0];
        var newEndVnode = newCh[newEndIdx];
        var oldKeyToIdx;
        var idxInOld;
        var elmToMove;
        var before;

        while (oldStartIdx <= oldEndIdx && newStartIdx <= newEndIdx) {
          if (oldStartVnode == null) {
            oldStartVnode = oldCh[++oldStartIdx]; // Vnode might have been moved left
          } else if (oldEndVnode == null) {
            oldEndVnode = oldCh[--oldEndIdx];
          } else if (newStartVnode == null) {
            newStartVnode = newCh[++newStartIdx];
          } else if (newEndVnode == null) {
            newEndVnode = newCh[--newEndIdx];
          } else if (sameVnode(oldStartVnode, newStartVnode)) {
            patchVnode(oldStartVnode, newStartVnode, insertedVnodeQueue);
            oldStartVnode = oldCh[++oldStartIdx];
            newStartVnode = newCh[++newStartIdx];
          } else if (sameVnode(oldEndVnode, newEndVnode)) {
            patchVnode(oldEndVnode, newEndVnode, insertedVnodeQueue);
            oldEndVnode = oldCh[--oldEndIdx];
            newEndVnode = newCh[--newEndIdx];
          } else if (sameVnode(oldStartVnode, newEndVnode)) {
            patchVnode(oldStartVnode, newEndVnode, insertedVnodeQueue);
            api.insertBefore(parentElm, oldStartVnode.elm, api.nextSibling(oldEndVnode.elm));
            oldStartVnode = oldCh[++oldStartIdx];
            newEndVnode = newCh[--newEndIdx];
          } else if (sameVnode(oldEndVnode, newStartVnode)) {
            patchVnode(oldEndVnode, newStartVnode, insertedVnodeQueue);
            api.insertBefore(parentElm, oldEndVnode.elm, oldStartVnode.elm);
            oldEndVnode = oldCh[--oldEndIdx];
            newStartVnode = newCh[++newStartIdx];
          } else {
            if (oldKeyToIdx === undefined) {
              oldKeyToIdx = createKeyToOldIdx(oldCh, oldStartIdx, oldEndIdx);
            }

            idxInOld = oldKeyToIdx[newStartVnode.key];

            if (isUndef(idxInOld)) {
              api.insertBefore(parentElm, createElm(newStartVnode, insertedVnodeQueue), oldStartVnode.elm);
              newStartVnode = newCh[++newStartIdx];
            } else {
              elmToMove = oldCh[idxInOld];

              if (elmToMove.sel !== newStartVnode.sel) {
                api.insertBefore(parentElm, createElm(newStartVnode, insertedVnodeQueue), oldStartVnode.elm);
              } else {
                patchVnode(elmToMove, newStartVnode, insertedVnodeQueue);
                oldCh[idxInOld] = undefined;
                api.insertBefore(parentElm, elmToMove.elm, oldStartVnode.elm);
              }

              newStartVnode = newCh[++newStartIdx];
            }
          }
        }

        if (oldStartIdx <= oldEndIdx || newStartIdx <= newEndIdx) {
          if (oldStartIdx > oldEndIdx) {
            before = newCh[newEndIdx + 1] == null ? null : newCh[newEndIdx + 1].elm;
            addVnodes(parentElm, before, newCh, newStartIdx, newEndIdx, insertedVnodeQueue);
          } else {
            removeVnodes(parentElm, oldCh, oldStartIdx, oldEndIdx);
          }
        }
      }

      function patchVnode(oldVnode, vnode, insertedVnodeQueue) {
        var i, hook;

        if (isDef(i = vnode.data) && isDef(hook = i.hook) && isDef(i = hook.prepatch)) {
          i(oldVnode, vnode);
        }

        var elm = vnode.elm = oldVnode.elm;
        var oldCh = oldVnode.children;
        var ch = vnode.children;
        if (oldVnode === vnode) return;

        if (vnode.data !== undefined) {
          for (i = 0; i < cbs.update.length; ++i) {
            cbs.update[i](oldVnode, vnode);
          }

          i = vnode.data.hook;
          if (isDef(i) && isDef(i = i.update)) i(oldVnode, vnode);
        }

        if (isUndef(vnode.text)) {
          if (isDef(oldCh) && isDef(ch)) {
            if (oldCh !== ch) updateChildren(elm, oldCh, ch, insertedVnodeQueue);
          } else if (isDef(ch)) {
            if (isDef(oldVnode.text)) api.setTextContent(elm, '');
            addVnodes(elm, null, ch, 0, ch.length - 1, insertedVnodeQueue);
          } else if (isDef(oldCh)) {
            removeVnodes(elm, oldCh, 0, oldCh.length - 1);
          } else if (isDef(oldVnode.text)) {
            api.setTextContent(elm, '');
          }
        } else if (oldVnode.text !== vnode.text) {
          api.setTextContent(elm, vnode.text);
        }

        if (isDef(hook) && isDef(i = hook.postpatch)) {
          i(oldVnode, vnode);
        }
      }

      return function patch(oldVnode, vnode) {
        var i, elm, parent;
        var insertedVnodeQueue = [];

        for (i = 0; i < cbs.pre.length; ++i) {
          cbs.pre[i]();
        }

        if (!isVnode(oldVnode)) {
          oldVnode = emptyNodeAt(oldVnode);
        }

        if (sameVnode(oldVnode, vnode)) {
          patchVnode(oldVnode, vnode, insertedVnodeQueue);
        } else {
          elm = oldVnode.elm;
          parent = api.parentNode(elm);
          createElm(vnode, insertedVnodeQueue);

          if (parent !== null) {
            api.insertBefore(parent, vnode.elm, api.nextSibling(elm));
            removeVnodes(parent, [oldVnode], 0, 0);
          }
        }

        for (i = 0; i < insertedVnodeQueue.length; ++i) {
          insertedVnodeQueue[i].data.hook.insert(insertedVnodeQueue[i]);
        }

        for (i = 0; i < cbs.post.length; ++i) {
          cbs.post[i]();
        }

        return vnode;
      };
    }

    var xlinkNS = 'http://www.w3.org/1999/xlink';
    var xmlNS = 'http://www.w3.org/XML/1998/namespace';
    var colonChar = 58;
    var xChar = 120;

    function updateAttrs(oldVnode, vnode) {
      var key,
          elm = vnode.elm,
          oldAttrs = oldVnode.data.attrs,
          attrs = vnode.data.attrs;
      if (!oldAttrs && !attrs) return;
      if (oldAttrs === attrs) return;
      oldAttrs = oldAttrs || {};
      attrs = attrs || {}; // update modified attributes, add new attributes

      for (key in attrs) {
        var cur = attrs[key];
        var old = oldAttrs[key];

        if (old !== cur) {
          if (cur === true) {
            elm.setAttribute(key, "");
          } else if (cur === false) {
            elm.removeAttribute(key);
          } else {
            if (key.charCodeAt(0) !== xChar) {
              elm.setAttribute(key, cur);
            } else if (key.charCodeAt(3) === colonChar) {
              // Assume xml namespace
              elm.setAttributeNS(xmlNS, key, cur);
            } else if (key.charCodeAt(5) === colonChar) {
              // Assume xlink namespace
              elm.setAttributeNS(xlinkNS, key, cur);
            } else {
              elm.setAttribute(key, cur);
            }
          }
        }
      } // remove removed attributes
      // use `in` operator since the previous `for` iteration uses it (.i.e. add even attributes with undefined value)
      // the other option is to remove all attributes with value == undefined


      for (key in oldAttrs) {
        if (!(key in attrs)) {
          elm.removeAttribute(key);
        }
      }
    }

    var attributesModule = {
      create: updateAttrs,
      update: updateAttrs
    };

    function updateProps(oldVnode, vnode) {
      var key,
          cur,
          old,
          elm = vnode.elm,
          oldProps = oldVnode.data.props,
          props = vnode.data.props;
      if (!oldProps && !props) return;
      if (oldProps === props) return;
      oldProps = oldProps || {};
      props = props || {};

      for (key in oldProps) {
        if (!props[key]) {
          delete elm[key];
        }
      }

      for (key in props) {
        cur = props[key];
        old = oldProps[key];

        if (old !== cur && (key !== 'value' || elm[key] !== cur)) {
          elm[key] = cur;
        }
      }
    }

    var propsModule = {
      create: updateProps,
      update: updateProps
    };

    var raf = typeof window !== 'undefined' && window.requestAnimationFrame || setTimeout;

    var nextFrame = function nextFrame(fn) {
      raf(function () {
        raf(fn);
      });
    };

    function setNextFrame(obj, prop, val) {
      nextFrame(function () {
        obj[prop] = val;
      });
    }

    function updateStyle(oldVnode, vnode) {
      var cur,
          name,
          elm = vnode.elm,
          oldStyle = oldVnode.data.style,
          style = vnode.data.style;
      if (!oldStyle && !style) return;
      if (oldStyle === style) return;
      oldStyle = oldStyle || {};
      style = style || {};
      var oldHasDel = ('delayed' in oldStyle);

      for (name in oldStyle) {
        if (!style[name]) {
          if (name[0] === '-' && name[1] === '-') {
            elm.style.removeProperty(name);
          } else {
            elm.style[name] = '';
          }
        }
      }

      for (name in style) {
        cur = style[name];

        if (name === 'delayed' && style.delayed) {
          for (var name2 in style.delayed) {
            cur = style.delayed[name2];

            if (!oldHasDel || cur !== oldStyle.delayed[name2]) {
              setNextFrame(elm.style, name2, cur);
            }
          }
        } else if (name !== 'remove' && cur !== oldStyle[name]) {
          if (name[0] === '-' && name[1] === '-') {
            elm.style.setProperty(name, cur);
          } else {
            elm.style[name] = cur;
          }
        }
      }
    }

    function applyDestroyStyle(vnode) {
      var style,
          name,
          elm = vnode.elm,
          s = vnode.data.style;
      if (!s || !(style = s.destroy)) return;

      for (name in style) {
        elm.style[name] = style[name];
      }
    }

    function applyRemoveStyle(vnode, rm) {
      var s = vnode.data.style;

      if (!s || !s.remove) {
        rm();
        return;
      }

      var name,
          elm = vnode.elm,
          i = 0,
          compStyle,
          style = s.remove,
          amount = 0,
          applied = [];

      for (name in style) {
        applied.push(name);
        elm.style[name] = style[name];
      }

      compStyle = getComputedStyle(elm);
      var props = compStyle['transition-property'].split(', ');

      for (; i < props.length; ++i) {
        if (applied.indexOf(props[i]) !== -1) amount++;
      }

      elm.addEventListener('transitionend', function (ev) {
        if (ev.target === elm) --amount;
        if (amount === 0) rm();
      });
    }

    var styleModule = {
      create: updateStyle,
      update: updateStyle,
      destroy: applyDestroyStyle,
      remove: applyRemoveStyle
    };

    function invokeHandler(handler, event, args) {
      if (typeof handler === 'function') {
        // call function handler
        handler.apply(void 0, [event].concat(args));
      }
    }

    function handleEvent(event, args, vnode) {
      var name = event.type;
      var on = vnode.data.on; // call event handler(s) if exists

      if (on && on[name]) {
        invokeHandler(on[name], event, args, vnode);
      }
    }

    function createListener() {
      return function handler(event) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        handleEvent(event, args, handler.vnode);
      };
    }

    function updateEvents(oldVnode, vnode) {
      var oldOn = oldVnode.data.on;
      var oldListener = oldVnode.listener;
      var oldElm = oldVnode.elm;
      var on = vnode && vnode.data.on;
      var elm = vnode && vnode.elm; // optimization for reused immutable handlers

      if (oldOn === on) {
        return;
      } // remove existing listeners which no longer used


      if (oldOn && oldListener) {
        // if element changed or deleted we remove all existing listeners unconditionally
        if (!on) {
          Object.keys(oldOn).forEach(function (name) {
            $(oldElm).off(name, oldListener);
          });
        } else {
          Object.keys(oldOn).forEach(function (name) {
            if (!on[name]) {
              $(oldElm).off(name, oldListener);
            }
          });
        }
      } // add new listeners which has not already attached


      if (on) {
        // reuse existing listener or create new
        var listener = oldVnode.listener || createListener();
        vnode.listener = listener; // update vnode for listener

        listener.vnode = vnode; // if element changed or added we add all needed listeners unconditionally

        if (!oldOn) {
          Object.keys(on).forEach(function (name) {
            $(elm).on(name, listener);
          });
        } else {
          Object.keys(on).forEach(function (name) {
            if (!oldOn[name]) {
              $(elm).on(name, listener);
            }
          });
        }
      }
    }

    var eventListenersModule = {
      create: updateEvents,
      update: updateEvents,
      destroy: updateEvents
    };

    /* eslint import/no-named-as-default: off */
    var patch = init([attributesModule, propsModule, styleModule, eventListenersModule]);

    /* eslint no-underscore-dangle: "off" */

    var Component = /*#__PURE__*/function () {
      function Component(app, component, props, _temp) {
        var _this = this;

        if (props === void 0) {
          props = {};
        }

        var _ref = _temp === void 0 ? {} : _temp,
            el = _ref.el,
            context = _ref.context,
            children = _ref.children;

        var document = getDocument();
        merge(this, {
          f7: app,
          props: props || {},
          context: context || {},
          id: component.id || id(),
          children: children || [],
          theme: {
            ios: app.theme === 'ios',
            md: app.theme === 'md',
            aurora: app.theme === 'aurora'
          },
          style: component.style,
          __updateQueue: [],
          __eventHandlers: [],
          __onceEventHandlers: [],
          __onBeforeMount: [],
          __onMounted: [],
          __onBeforeUpdate: [],
          __onUpdated: [],
          __onBeforeUnmount: [],
          __onUnmounted: []
        });

        var createComponent = function createComponent() {
          return component(_this.props, _this.getComponentContext(true));
        };

        var getRenderFuncion = function getRenderFuncion(componentResult) {
          return new Promise(function (resolve, reject) {
            if (typeof componentResult === 'function') {
              resolve(componentResult);
            } else if (componentResult instanceof Promise) {
              componentResult.then(function (render) {
                resolve(render);
              }).catch(function (err) {
                reject(err);
              });
            } else {
              reject(new Error('Framework7: Component render function is not a "function" type. Didn\'t you forget to "return $render"?'));
            }
          });
        };

        return new Promise(function (resolve, reject) {
          var componentResult = createComponent();
          getRenderFuncion(componentResult).then(function (render) {
            _this.renderFunction = render;

            var tree = _this.render();

            if (el) {
              _this.vnode = vdom(tree, _this, true);

              if (_this.style) {
                _this.styleEl = document.createElement('style');
                _this.styleEl.innerHTML = _this.style;
              }

              _this.el = el;
              patch(_this.el, _this.vnode);
              _this.el = _this.vnode.elm;
              _this.$el = $(_this.el);

              _this.attachEvents();

              _this.el.f7Component = _this;

              _this.mount();

              resolve(_this);
              return;
            } // Make Dom


            if (tree) {
              _this.vnode = vdom(tree, _this, true);
              _this.el = document.createElement(_this.vnode.sel || 'div');
              patch(_this.el, _this.vnode);
              _this.$el = $(_this.el);
            }

            if (_this.style) {
              _this.styleEl = document.createElement('style');
              _this.styleEl.innerHTML = _this.style;
            }

            _this.attachEvents();

            if (_this.el) {
              _this.el.f7Component = _this;
            }

            resolve(_this);
          }).catch(function (err) {
            reject(err);
          });
        });
      }

      var _proto = Component.prototype;

      _proto.on = function on(eventName, handler) {
        if (!this.__eventHandlers) return;

        this.__eventHandlers.push({
          eventName: eventName,
          handler: handler
        });
      };

      _proto.once = function once(eventName, handler) {
        if (!this.__eventHandlers) return;

        this.__onceEventHandlers.push({
          eventName: eventName,
          handler: handler
        });
      };

      _proto.getComponentRef = function getComponentRef() {
        var self = this;
        return function (initialValue) {
          var value = initialValue;
          var obj = {};
          Object.defineProperty(obj, 'value', {
            get: function get() {
              return value;
            },
            set: function set(v) {
              value = v;
              self.update();
            }
          });
          return obj;
        };
      };

      _proto.getComponentStore = function getComponentStore() {
        var _this2 = this;

        var _this$f7$store = this.f7.store,
            state = _this$f7$store.state,
            _gettersPlain = _this$f7$store._gettersPlain,
            dispatch = _this$f7$store.dispatch;
        var $store = {
          state: state,
          dispatch: dispatch
        };
        $store.getters = new Proxy(_gettersPlain, {
          get: function get(target, prop) {
            var obj = target[prop];

            var callback = function callback(v) {
              obj.value = v;

              _this2.update();
            };

            obj.onUpdated(callback);
            return obj;
          }
        });
        return $store;
      };

      _proto.getComponentContext = function getComponentContext(includeHooks) {
        var _this3 = this;

        var ctx = {
          $f7route: this.context.f7route,
          $f7router: this.context.f7router,
          $h: $h,
          $: $,
          $id: this.id,
          $f7: this.f7,
          $f7ready: this.f7ready.bind(this),
          $theme: this.theme,
          $tick: this.tick.bind(this),
          $update: this.update.bind(this),
          $emit: this.emit.bind(this),
          $store: this.getComponentStore(),
          $ref: this.getComponentRef(),
          $el: {}
        };
        Object.defineProperty(ctx.$el, 'value', {
          get: function get() {
            return _this3.$el;
          }
        });
        if (includeHooks) Object.assign(ctx, {
          $on: this.on.bind(this),
          $once: this.once.bind(this),
          $onBeforeMount: function $onBeforeMount(handler) {
            return _this3.__onBeforeMount.push(handler);
          },
          $onMounted: function $onMounted(handler) {
            return _this3.__onMounted.push(handler);
          },
          $onBeforeUpdate: function $onBeforeUpdate(handler) {
            return _this3.__onBeforeUpdate.push(handler);
          },
          $onUpdated: function $onUpdated(handler) {
            return _this3.__onUpdated.push(handler);
          },
          $onBeforeUnmount: function $onBeforeUnmount(handler) {
            return _this3.__onBeforeUnmount.push(handler);
          },
          $onUnmounted: function $onUnmounted(handler) {
            return _this3.__onUnmounted.push(handler);
          }
        });
        return ctx;
      };

      _proto.render = function render() {
        return this.renderFunction(this.getComponentContext());
      };

      _proto.emit = function emit(name, data) {
        if (!this.el) return;
        this.$el.trigger(name, data);
      };

      _proto.attachEvents = function attachEvents() {
        var $el = this.$el;
        if (!this.__eventHandlers) return;

        this.__eventHandlers.forEach(function (_ref2) {
          var eventName = _ref2.eventName,
              handler = _ref2.handler;
          $el.on(eventNameToColonCase(eventName), handler);
        });

        this.__onceEventHandlers.forEach(function (_ref3) {
          var eventName = _ref3.eventName,
              handler = _ref3.handler;
          $el.once(eventNameToColonCase(eventName), handler);
        });
      };

      _proto.detachEvents = function detachEvents() {
        var $el = this.$el;
        if (!this.__eventHandlers) return;

        this.__eventHandlers.forEach(function (_ref4) {
          var eventName = _ref4.eventName,
              handler = _ref4.handler;
          $el.on(eventNameToColonCase(eventName), handler);
        });

        this.__onceEventHandlers.forEach(function (_ref5) {
          var eventName = _ref5.eventName,
              handler = _ref5.handler;
          $el.once(eventNameToColonCase(eventName), handler);
        });
      };

      _proto.startUpdateQueue = function startUpdateQueue() {
        var _this4 = this;

        var window = getWindow();
        if (this.__requestAnimationFrameId) return;

        var update = function update() {
          _this4.hook('onBeforeUpdate');

          var tree = _this4.render(); // Make Dom


          if (tree) {
            var newVNode = vdom(tree, _this4, false);
            _this4.vnode = patch(_this4.vnode, newVNode);
          }
        };

        this.__requestAnimationFrameId = window.requestAnimationFrame(function () {
          if (_this4.__updateIsPending) update();
          var resolvers = [].concat(_this4.__updateQueue);
          _this4.__updateQueue = [];
          _this4.__updateIsPending = false;
          window.cancelAnimationFrame(_this4.__requestAnimationFrameId);
          delete _this4.__requestAnimationFrameId;
          delete _this4.__updateIsPending;
          resolvers.forEach(function (resolver) {
            return resolver();
          });
          resolvers = [];
        });
      };

      _proto.tick = function tick(callback) {
        var _this5 = this;

        return new Promise(function (resolve) {
          function resolver() {
            resolve();
            if (callback) callback();
          }

          _this5.__updateQueue.push(resolver);

          _this5.startUpdateQueue();
        });
      };

      _proto.update = function update(callback) {
        var _this6 = this;

        if (this.__destroyed) return new Promise(function () {});
        return new Promise(function (resolve) {
          var resolver = function resolver() {
            resolve();
            if (callback) callback();
          };

          _this6.__updateIsPending = true;

          _this6.__updateQueue.push(resolver);

          _this6.startUpdateQueue();
        });
      };

      _proto.setState = function setState(callback) {
        return this.update(callback);
      };

      _proto.f7ready = function f7ready(callback) {
        var _this7 = this;

        if (this.f7.initialized) {
          callback(this.f7);
          return;
        }

        this.f7.once('init', function () {
          callback(_this7.f7);
        });
      };

      _proto.mount = function mount(mountMethod) {
        this.hook('onBeforeMount', this.$el);
        if (this.styleEl) $('head').append(this.styleEl);
        if (mountMethod) mountMethod(this.el);
        this.hook('onMounted', this.$el);
      };

      _proto.destroy = function destroy() {
        if (this.__destroyed) return;
        var window = getWindow();
        this.hook('onBeforeUnmount');
        if (this.styleEl) $(this.styleEl).remove();
        this.detachEvents();
        this.hook('onUnmounted'); // Delete component instance

        if (this.el && this.el.f7Component) {
          this.el.f7Component = null;
          delete this.el.f7Component;
        } // Patch with empty node


        if (this.vnode) {
          this.vnode = patch(this.vnode, {
            sel: this.vnode.sel,
            data: {}
          });
        } // Clear update queue


        window.cancelAnimationFrame(this.__requestAnimationFrameId);
        this.__updateQueue = [];
        this.__eventHandlers = [];
        this.__onceEventHandlers = [];
        this.__onBeforeMount = [];
        this.__onMounted = [];
        this.__onBeforeUpdate = [];
        this.__onUpdated = [];
        this.__onBeforeUnmount = [];
        this.__onUnmounted = []; // Delete all props

        deleteProps$1(this);
        this.__destroyed = true;
      };

      _proto.hook = function hook(name) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        if (this.__destroyed) return;
        this["__" + name].forEach(function (handler) {
          handler.apply(void 0, args);
        });
      };

      return Component;
    }();

    function parseComponent(componentString) {
      var window = getWindow();
      var document = getDocument();
      var componentId = id();
      var callbackCreateName = "f7_component_create_callback_" + componentId; // Template

      var template;
      var hasTemplate = componentString.match(/<template([ ]?)([a-z0-9-]*)>/);

      if (hasTemplate) {
        template = componentString.split(/<template[ ]?[a-z0-9-]*>/).filter(function (item, index) {
          return index > 0;
        }).join('<template>').split('</template>').filter(function (item, index, arr) {
          return index < arr.length - 1;
        }).join('</template>').replace(/{{#raw}}([ \n]*)<template/g, '{{#raw}}<template').replace(/\/template>([ \n]*){{\/raw}}/g, '/template>{{/raw}}').replace(/([ \n])<template/g, '$1{{#raw}}<template').replace(/\/template>([ \n])/g, '/template>{{/raw}}$1');
      } // Parse Styles


      var style = null;

      if (componentString.indexOf('<style>') >= 0) {
        style = componentString.split('<style>')[1].split('</style>')[0];
      }

      if (componentString.indexOf('<style scoped>') >= 0) {
        style = componentString.split('<style scoped>')[1].split('</style>')[0];
      } // Parse Script


      var scriptContent;

      if (componentString.indexOf('<script>') >= 0) {
        var scripts = componentString.split('<script>');
        scriptContent = scripts[scripts.length - 1].split('</script>')[0].trim();
      } else {
        scriptContent = 'return () => {return $render}';
      }

      if (!scriptContent || !scriptContent.trim()) scriptContent = 'return () => {return $render}'; // Parse Template

      if (template) {
        scriptContent = scriptContent.replace('$render', "function ($$ctx) {\n          var $ = $$ctx.$$;\n          var $h = $$ctx.$h;\n          var $root = $$ctx.$root;\n          var $f7 = $$ctx.$f7;\n          var $f7route = $$ctx.$f7route;\n          var $f7router = $$ctx.$f7router;\n          var $theme = $$ctx.$theme;\n          var $update = $$ctx.$update;\n          var $store = $$ctx.$store;\n          var $ref = $$ctx.$ref;\n\n          return $h`" + template + "`\n        }\n        ").replace(/export default/g, 'return');
      } // Execute Script


      scriptContent = "window." + callbackCreateName + " = function () {" + scriptContent + "}"; // Insert Script El

      var scriptEl = document.createElement('script');
      scriptEl.innerHTML = scriptContent;
      $('head').append(scriptEl);
      var component = window[callbackCreateName](); // Remove Script El

      $(scriptEl).remove();
      window[callbackCreateName] = null;
      delete window[callbackCreateName]; // Assign Style

      if (style) {
        component.style = style;
      } // Component ID


      component.id = componentId;
      return component;
    }

    var ignoreChildren = [false, null, '', undefined];

    var $jsx$1 = function $jsx(type, props) {
      for (var _len = arguments.length, children = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        children[_key - 2] = arguments[_key];
      }

      var flatChildren = flattenArray((children || []).filter(function (child) {
        return ignoreChildren.indexOf(child) < 0;
      }));

      if (type === 'Fragment') {
        return flatChildren;
      }

      return {
        type: type,
        props: props || {},
        children: flatChildren
      };
    };

    function registerComponent(tagName, component) {
      customComponents[tagName] = component;
    }

    function unregisterComponent(tagName) {
      delete customComponents[tagName];
    }
    var ComponentModule = {
      name: 'component',
      static: {
        Component: Component,
        registerComponent: registerComponent,
        unregisterComponent: unregisterComponent
      },
      create: function create() {
        var app = this;
        app.component = {
          registerComponent: registerComponent,
          unregisterComponent: unregisterComponent,
          parse: function parse(componentString) {
            return parseComponent(componentString);
          },
          create: function create(component, props, _ref) {
            var root = _ref.root,
                el = _ref.el,
                context = _ref.context,
                children = _ref.children;
            return new Component(app, component, props, {
              root: root,
              el: el,
              context: context,
              children: children
            });
          }
        };
      }
    };

    var HistoryModule = {
      name: 'history',
      static: {
        history: History$2
      },
      on: {
        init: function init() {
          History$2.init(this);
        }
      }
    };

    var SW = {
      registrations: [],
      register: function register(path, scope) {
        var app = this;
        var window = getWindow();

        if (!('serviceWorker' in window.navigator) || !app.serviceWorker.container) {
          return new Promise(function (resolve, reject) {
            reject(new Error('Service worker is not supported'));
          });
        }

        return new Promise(function (resolve, reject) {
          app.serviceWorker.container.register(path, scope ? {
            scope: scope
          } : {}).then(function (reg) {
            SW.registrations.push(reg);
            app.emit('serviceWorkerRegisterSuccess', reg);
            resolve(reg);
          }).catch(function (error) {
            app.emit('serviceWorkerRegisterError', error);
            reject(error);
          });
        });
      },
      unregister: function unregister(registration) {
        var app = this;
        var window = getWindow();

        if (!('serviceWorker' in window.navigator) || !app.serviceWorker.container) {
          return new Promise(function (resolve, reject) {
            reject(new Error('Service worker is not supported'));
          });
        }

        var registrations;
        if (!registration) registrations = SW.registrations;else if (Array.isArray(registration)) registrations = registration;else registrations = [registration];
        return Promise.all(registrations.map(function (reg) {
          return new Promise(function (resolve, reject) {
            reg.unregister().then(function () {
              if (SW.registrations.indexOf(reg) >= 0) {
                SW.registrations.splice(SW.registrations.indexOf(reg), 1);
              }

              app.emit('serviceWorkerUnregisterSuccess', reg);
              resolve();
            }).catch(function (error) {
              app.emit('serviceWorkerUnregisterError', reg, error);
              reject(error);
            });
          });
        }));
      }
    };
    var ServiceWorkerModule = {
      name: 'sw',
      params: {
        serviceWorker: {
          path: undefined,
          scope: undefined
        }
      },
      create: function create() {
        var app = this;
        var window = getWindow();
        extend$1(app, {
          serviceWorker: {
            container: 'serviceWorker' in window.navigator ? window.navigator.serviceWorker : undefined,
            registrations: SW.registrations,
            register: SW.register.bind(app),
            unregister: SW.unregister.bind(app)
          }
        });
      },
      on: {
        init: function init() {
          var window = getWindow();
          if (!('serviceWorker' in window.navigator)) return;
          var app = this;
          if (app.device.cordova || window.Capacitor && window.Capacitor.isNative) return;
          if (!app.serviceWorker.container) return;
          var paths = app.params.serviceWorker.path;
          var scope = app.params.serviceWorker.scope;
          if (!paths || Array.isArray(paths) && !paths.length) return;
          var toRegister = Array.isArray(paths) ? paths : [paths];
          toRegister.forEach(function (path) {
            app.serviceWorker.register(path, scope);
          });
        }
      }
    };

    function createStore(storeParams) {
      if (storeParams === void 0) {
        storeParams = {};
      }

      var store = {
        __store: true
      };

      var originalState = _extends$j({}, storeParams.state || {});

      var actions = _extends$j({}, storeParams.actions || {});

      var getters = _extends$j({}, storeParams.getters || {});

      var state = extend$1({}, originalState);
      var propsQueue = [];
      var gettersDependencies = {};
      var gettersCallbacks = {};
      Object.keys(getters).forEach(function (getterKey) {
        gettersDependencies[getterKey] = [];
        gettersCallbacks[getterKey] = [];
      });

      var getGetterValue = function getGetterValue(getterKey) {
        return getters[getterKey]({
          state: store.state
        });
      };

      var addGetterDependencies = function addGetterDependencies(getterKey, deps) {
        if (!gettersDependencies[getterKey]) gettersDependencies[getterKey] = [];
        deps.forEach(function (dep) {
          if (gettersDependencies[getterKey].indexOf(dep) < 0) {
            gettersDependencies[getterKey].push(dep);
          }
        });
      };

      var addGetterCallback = function addGetterCallback(getterKey, callback) {
        if (!gettersCallbacks[getterKey]) gettersCallbacks[getterKey] = [];
        gettersCallbacks[getterKey].push(callback);
      };

      var runGetterCallbacks = function runGetterCallbacks(stateKey) {
        var keys = Object.keys(gettersDependencies).filter(function (getterKey) {
          return gettersDependencies[getterKey].indexOf(stateKey) >= 0;
        });
        keys.forEach(function (getterKey) {
          if (!gettersCallbacks[getterKey] || !gettersCallbacks[getterKey].length) return;
          gettersCallbacks[getterKey].forEach(function (callback) {
            callback(getGetterValue(getterKey));
          });
        });
      };

      var removeGetterCallback = function removeGetterCallback(callback) {
        Object.keys(gettersCallbacks).forEach(function (stateKey) {
          var callbacks = gettersCallbacks[stateKey];

          if (callbacks.indexOf(callback) >= 0) {
            callbacks.splice(callbacks.indexOf(callback), 1);
          }
        });
      }; // eslint-disable-next-line


      store.__removeCallback = function (callback) {
        removeGetterCallback(callback);
      };

      var getterValue = function getterValue(getterKey, addCallback) {
        if (addCallback === void 0) {
          addCallback = true;
        }

        if (getterKey === 'constructor') return undefined;
        propsQueue = [];
        var value = getGetterValue(getterKey);
        addGetterDependencies(getterKey, propsQueue);

        var onUpdated = function onUpdated(callback) {
          addGetterCallback(getterKey, callback);
        };

        var obj = {
          value: value,
          onUpdated: onUpdated
        };

        if (!addCallback) {
          return obj;
        }

        var callback = function callback(v) {
          obj.value = v;
        };

        obj.__callback = callback;
        addGetterCallback(getterKey, callback); // eslint-disable-next-line

        return obj;
      };

      store.state = new Proxy(state, {
        set: function set(target, prop, value) {
          target[prop] = value;
          runGetterCallbacks(prop);
          return true;
        },
        get: function get(target, prop) {
          propsQueue.push(prop);
          return target[prop];
        }
      });
      store.getters = new Proxy(getters, {
        set: function set() {
          return false;
        },
        get: function get(target, prop) {
          if (!target[prop]) {
            return undefined;
          }

          return getterValue(prop, true);
        }
      });
      store._gettersPlain = new Proxy(getters, {
        set: function set() {
          return false;
        },
        get: function get(target, prop) {
          if (!target[prop]) {
            return undefined;
          }

          return getterValue(prop, false);
        }
      });

      store.dispatch = function (actionName, data) {
        return new Promise(function (resolve, reject) {
          if (!actions[actionName]) {
            reject();
            throw new Error("Framework7: Store action \"" + actionName + "\" is not found");
          }

          var result = actions[actionName]({
            state: store.state,
            dispatch: store.dispatch
          }, data);
          resolve(result);
        });
      };

      return store;
    }

    var StoreModule = {
      name: 'store',
      static: {
        createStore: createStore
      },
      proto: {
        createStore: createStore
      }
    };

    var isCapacitor = function isCapacitor() {
      var window = getWindow();
      return window.Capacitor && window.Capacitor.isNative && window.Capacitor.Plugins && window.Capacitor.Plugins.StatusBar;
    };

    var Statusbar = {
      hide: function hide() {
        var window = getWindow();
        var device = getDevice$1();

        if (device.cordova && window.StatusBar) {
          window.StatusBar.hide();
        }

        if (isCapacitor()) {
          window.Capacitor.Plugins.StatusBar.hide();
        }
      },
      show: function show() {
        var window = getWindow();
        var device = getDevice$1();

        if (device.cordova && window.StatusBar) {
          window.StatusBar.show();
        }

        if (isCapacitor()) {
          window.Capacitor.Plugins.StatusBar.show();
        }
      },
      onClick: function onClick() {
        var app = this;
        var pageContent;

        if ($('.popup.modal-in').length > 0) {
          // Check for opened popup
          pageContent = $('.popup.modal-in').find('.page:not(.page-previous):not(.page-next):not(.cached)').find('.page-content');
        } else if ($('.panel.panel-in').length > 0) {
          // Check for opened panel
          pageContent = $('.panel.panel-in').find('.page:not(.page-previous):not(.page-next):not(.cached)').find('.page-content');
        } else if ($('.views > .view.tab-active').length > 0) {
          // View in tab bar app layout
          pageContent = $('.views > .view.tab-active').find('.page:not(.page-previous):not(.page-next):not(.cached)').find('.page-content');
        } else if ($('.views').length > 0) {
          pageContent = $('.views').find('.page:not(.page-previous):not(.page-next):not(.cached)').find('.page-content');
        } else {
          pageContent = app.$el.children('.view').find('.page:not(.page-previous):not(.page-next):not(.cached)').find('.page-content');
        }

        if (pageContent && pageContent.length > 0) {
          // Check for tab
          if (pageContent.hasClass('tab')) {
            pageContent = pageContent.parent('.tabs').children('.page-content.tab-active');
          }

          if (pageContent.length > 0) pageContent.scrollTop(0, 300);
        }
      },
      setTextColor: function setTextColor(color) {
        var window = getWindow();
        var device = getDevice$1();

        if (device.cordova && window.StatusBar) {
          if (color === 'white') {
            window.StatusBar.styleLightContent();
          } else {
            window.StatusBar.styleDefault();
          }
        }

        if (isCapacitor()) {
          if (color === 'white') {
            window.Capacitor.Plugins.StatusBar.setStyle({
              style: 'DARK'
            });
          } else {
            window.Capacitor.Plugins.StatusBar.setStyle({
              style: 'LIGHT'
            });
          }
        }
      },
      setBackgroundColor: function setBackgroundColor(color) {
        var window = getWindow();
        var device = getDevice$1();

        if (device.cordova && window.StatusBar) {
          window.StatusBar.backgroundColorByHexString(color);
        }

        if (isCapacitor()) {
          window.Capacitor.Plugins.StatusBar.setBackgroundColor({
            color: color
          });
        }
      },
      isVisible: function isVisible() {
        var window = getWindow();
        var device = getDevice$1();
        return new Promise(function (resolve) {
          if (device.cordova && window.StatusBar) {
            resolve(window.StatusBar.isVisible);
          }

          if (isCapacitor()) {
            window.Capacitor.Plugins.StatusBar.getInfo().then(function (info) {
              resolve(info.visible);
            });
          }

          resolve(false);
        });
      },
      overlaysWebView: function overlaysWebView(overlays) {
        if (overlays === void 0) {
          overlays = true;
        }

        var window = getWindow();
        var device = getDevice$1();

        if (device.cordova && window.StatusBar) {
          window.StatusBar.overlaysWebView(overlays);
        }

        if (isCapacitor()) {
          window.Capacitor.Plugins.StatusBar.setOverlaysWebView({
            overlay: overlays
          });
        }
      },
      init: function init() {
        var app = this;
        var window = getWindow();
        var device = getDevice$1();
        var params = app.params.statusbar;
        if (!params.enabled) return;
        var isCordova = device.cordova && window.StatusBar;
        var isCap = isCapacitor();

        if (isCordova || isCap) {
          if (params.scrollTopOnClick) {
            $(window).on('statusTap', Statusbar.onClick.bind(app));
          }

          if (device.ios) {
            if (params.iosOverlaysWebView) {
              Statusbar.overlaysWebView(true);
            } else {
              Statusbar.overlaysWebView(false);
            }

            if (params.iosTextColor === 'white') {
              Statusbar.setTextColor('white');
            } else {
              Statusbar.setTextColor('black');
            }
          }

          if (device.android) {
            if (params.androidOverlaysWebView) {
              Statusbar.overlaysWebView(true);
            } else {
              Statusbar.overlaysWebView(false);
            }

            if (params.androidTextColor === 'white') {
              Statusbar.setTextColor('white');
            } else {
              Statusbar.setTextColor('black');
            }
          }
        }

        if (params.iosBackgroundColor && device.ios) {
          Statusbar.setBackgroundColor(params.iosBackgroundColor);
        }

        if (params.androidBackgroundColor && device.android) {
          Statusbar.setBackgroundColor(params.androidBackgroundColor);
        }
      }
    };
    var Statusbar$1 = {
      name: 'statusbar',
      params: {
        statusbar: {
          enabled: true,
          scrollTopOnClick: true,
          iosOverlaysWebView: true,
          iosTextColor: 'black',
          iosBackgroundColor: null,
          androidOverlaysWebView: false,
          androidTextColor: 'black',
          androidBackgroundColor: null
        }
      },
      create: function create() {
        var app = this;
        bindMethods(app, {
          statusbar: Statusbar
        });
      },
      on: {
        init: function init() {
          var app = this;
          Statusbar.init.call(app);
        }
      }
    };

    function getCurrentView(app) {
      var $popoverView = $('.popover.modal-in .view');
      var $popupView = $('.popup.modal-in .view');
      var $panelView = $('.panel.panel-in .view');
      var $viewsEl = $('.views');
      if ($viewsEl.length === 0) $viewsEl = app.$el; // Find active view as tab

      var $viewEl = $viewsEl.children('.view');

      if ($viewEl.length === 0) {
        $viewEl = $viewsEl.children('.tabs').children('.view');
      } // Propably in tabs or split view


      if ($viewEl.length > 1) {
        if ($viewEl.hasClass('tab')) {
          // Tabs
          $viewEl = $viewsEl.children('.view.tab-active');

          if ($viewEl.length === 0) {
            $viewEl = $viewsEl.children('.tabs').children('.view.tab-active');
          }
        } else {// Split View, leave appView intact
        }
      }

      if ($popoverView.length > 0 && $popoverView[0].f7View) return $popoverView[0].f7View;
      if ($popupView.length > 0 && $popupView[0].f7View) return $popupView[0].f7View;
      if ($panelView.length > 0 && $panelView[0].f7View) return $panelView[0].f7View;

      if ($viewEl.length > 0) {
        if ($viewEl.length === 1 && $viewEl[0].f7View) return $viewEl[0].f7View;

        if ($viewEl.length > 1) {
          return app.views.main;
        }
      }

      return undefined;
    }

    var View = {
      name: 'view',
      params: {
        view: {
          init: true,
          name: undefined,
          main: false,
          router: true,
          linksView: null,
          stackPages: false,
          xhrCache: true,
          xhrCacheIgnore: [],
          xhrCacheIgnoreGetParameters: false,
          xhrCacheDuration: 1000 * 60 * 10,
          // Ten minutes
          componentCache: true,
          preloadPreviousPage: true,
          allowDuplicateUrls: false,
          reloadPages: false,
          reloadDetail: false,
          masterDetailBreakpoint: 0,
          masterDetailResizable: false,
          removeElements: true,
          removeElementsWithTimeout: false,
          removeElementsTimeout: 0,
          restoreScrollTopOnBack: true,
          unloadTabContent: true,
          passRouteQueryToRequest: true,
          passRouteParamsToRequest: false,
          loadInitialPage: true,
          // Swipe Back
          iosSwipeBack: true,
          iosSwipeBackAnimateShadow: true,
          iosSwipeBackAnimateOpacity: true,
          iosSwipeBackActiveArea: 30,
          iosSwipeBackThreshold: 0,
          mdSwipeBack: false,
          mdSwipeBackAnimateShadow: true,
          mdSwipeBackAnimateOpacity: false,
          mdSwipeBackActiveArea: 30,
          mdSwipeBackThreshold: 0,
          auroraSwipeBack: false,
          auroraSwipeBackAnimateShadow: false,
          auroraSwipeBackAnimateOpacity: true,
          auroraSwipeBackActiveArea: 30,
          auroraSwipeBackThreshold: 0,
          // Push State
          browserHistory: false,
          browserHistoryRoot: undefined,
          browserHistoryAnimate: true,
          browserHistoryAnimateOnLoad: false,
          browserHistorySeparator: '#!',
          browserHistoryOnLoad: true,
          browserHistoryInitialMatch: false,
          browserHistoryStoreHistory: true,
          // Animate Pages
          animate: true,
          // iOS Dynamic Navbar
          iosDynamicNavbar: true,
          // Animate iOS Navbar Back Icon
          iosAnimateNavbarBackIcon: true,
          // Delays
          iosPageLoadDelay: 0,
          mdPageLoadDelay: 0,
          auroraPageLoadDelay: 0,
          // Routes hooks
          routesBeforeEnter: null,
          routesBeforeLeave: null
        }
      },
      static: {
        View: View$1
      },
      create: function create() {
        var app = this;
        extend$1(app, {
          views: extend$1([], {
            create: function create(el, params) {
              return new View$1(app, el, params);
            },
            get: function get(viewEl) {
              var $viewEl = $(viewEl);
              if ($viewEl.length && $viewEl[0].f7View) return $viewEl[0].f7View;
              return undefined;
            }
          })
        });
        Object.defineProperty(app.views, 'current', {
          enumerable: true,
          configurable: true,
          get: function get() {
            return getCurrentView(app);
          }
        }); // Alias

        app.view = app.views;
      },
      on: {
        init: function init() {
          var app = this;
          $('.view-init').each(function (viewEl) {
            if (viewEl.f7View) return;
            var viewParams = $(viewEl).dataset();
            app.views.create(viewEl, viewParams);
          });
        },
        'modalOpen panelOpen': function onOpen(instance) {
          var app = this;
          instance.$el.find('.view-init').each(function (viewEl) {
            if (viewEl.f7View) return;
            var viewParams = $(viewEl).dataset();
            app.views.create(viewEl, viewParams);
          });
        },
        'modalBeforeDestroy panelBeforeDestroy': function onClose(instance) {
          if (!instance || !instance.$el) return;
          instance.$el.find('.view-init').each(function (viewEl) {
            var view = viewEl.f7View;
            if (!view) return;
            view.destroy();
          });
        }
      },
      vnode: {
        'view-init': {
          insert: function insert(vnode) {
            var app = this;
            var viewEl = vnode.elm;
            if (viewEl.f7View) return;
            var viewParams = $(viewEl).dataset();
            app.views.create(viewEl, viewParams);
          },
          destroy: function destroy(vnode) {
            var viewEl = vnode.elm;
            var view = viewEl.f7View;
            if (!view) return;
            view.destroy();
          }
        }
      }
    };

    var Navbar = {
      size: function size(el) {
        var app = this;
        var $el = $(el);

        if ($el.hasClass('navbars')) {
          $el = $el.children('.navbar').each(function (navbarEl) {
            app.navbar.size(navbarEl);
          });
          return;
        }

        var $innerEl = $el.children('.navbar-inner');
        if (!$innerEl.length) return;
        var needCenterTitle = $innerEl.hasClass('navbar-inner-centered-title') || app.params.navbar[app.theme + "CenterTitle"];
        var needLeftTitle = app.theme === 'ios' && !app.params.navbar[app.theme + "CenterTitle"];
        if (!needCenterTitle && !needLeftTitle) return;

        if ($el.hasClass('stacked') || $el.parents('.stacked').length > 0 || $el.parents('.tab:not(.tab-active)').length > 0 || $el.parents('.popup:not(.modal-in)').length > 0) {
          return;
        }

        if (app.theme !== 'ios' && app.params.navbar[app.theme + "CenterTitle"]) {
          $innerEl.addClass('navbar-inner-centered-title');
        }

        if (app.theme === 'ios' && !app.params.navbar.iosCenterTitle) {
          $innerEl.addClass('navbar-inner-left-title');
        }

        var $viewEl = $el.parents('.view').eq(0);
        var left = app.rtl ? $innerEl.children('.right') : $innerEl.children('.left');
        var right = app.rtl ? $innerEl.children('.left') : $innerEl.children('.right');
        var title = $innerEl.children('.title');
        var subnavbar = $innerEl.children('.subnavbar');
        var noLeft = left.length === 0;
        var noRight = right.length === 0;
        var leftWidth = noLeft ? 0 : left.outerWidth(true);
        var rightWidth = noRight ? 0 : right.outerWidth(true);
        var titleWidth = title.outerWidth(true);
        var navbarStyles = $innerEl.styles();
        var navbarWidth = $innerEl[0].offsetWidth;
        var navbarInnerWidth = navbarWidth - parseInt(navbarStyles.paddingLeft, 10) - parseInt(navbarStyles.paddingRight, 10);
        var isPrevious = $el.hasClass('navbar-previous');
        var sliding = $innerEl.hasClass('sliding');
        var router;
        var dynamicNavbar;

        if ($viewEl.length > 0 && $viewEl[0].f7View) {
          router = $viewEl[0].f7View.router;
          dynamicNavbar = router && router.dynamicNavbar;
        }

        var currLeft;
        var diff;

        if (noRight) {
          currLeft = navbarInnerWidth - titleWidth;
        }

        if (noLeft) {
          currLeft = 0;
        }

        if (!noLeft && !noRight) {
          currLeft = (navbarInnerWidth - rightWidth - titleWidth + leftWidth) / 2;
        }

        var requiredLeft = (navbarInnerWidth - titleWidth) / 2;

        if (navbarInnerWidth - leftWidth - rightWidth > titleWidth) {
          if (requiredLeft < leftWidth) {
            requiredLeft = leftWidth;
          }

          if (requiredLeft + titleWidth > navbarInnerWidth - rightWidth) {
            requiredLeft = navbarInnerWidth - rightWidth - titleWidth;
          }

          diff = requiredLeft - currLeft;
        } else {
          diff = 0;
        } // RTL inverter


        var inverter = app.rtl ? -1 : 1;

        if (dynamicNavbar && app.theme === 'ios') {
          if (title.hasClass('sliding') || title.length > 0 && sliding) {
            var titleLeftOffset = -(currLeft + diff) * inverter;
            var titleRightOffset = (navbarInnerWidth - currLeft - diff - titleWidth) * inverter;

            if (isPrevious) {
              if (router && router.params.iosAnimateNavbarBackIcon) {
                var activeNavbarBackLink = $el.parent().find('.navbar-current').children('.left.sliding').find('.back .icon ~ span');

                if (activeNavbarBackLink.length > 0) {
                  titleLeftOffset += activeNavbarBackLink[0].offsetLeft;
                }
              }
            }

            title[0].f7NavbarLeftOffset = titleLeftOffset;
            title[0].f7NavbarRightOffset = titleRightOffset;
          }

          if (!noLeft && (left.hasClass('sliding') || sliding)) {
            if (app.rtl) {
              left[0].f7NavbarLeftOffset = -(navbarInnerWidth - left[0].offsetWidth) / 2 * inverter;
              left[0].f7NavbarRightOffset = leftWidth * inverter;
            } else {
              left[0].f7NavbarLeftOffset = -leftWidth;
              left[0].f7NavbarRightOffset = (navbarInnerWidth - left[0].offsetWidth) / 2;

              if (router && router.params.iosAnimateNavbarBackIcon && left.find('.back .icon').length > 0) {
                if (left.find('.back .icon ~ span').length) {
                  var leftOffset = left[0].f7NavbarLeftOffset;
                  var rightOffset = left[0].f7NavbarRightOffset;
                  left[0].f7NavbarLeftOffset = 0;
                  left[0].f7NavbarRightOffset = 0;
                  left.find('.back .icon ~ span')[0].f7NavbarLeftOffset = leftOffset;
                  left.find('.back .icon ~ span')[0].f7NavbarRightOffset = rightOffset - left.find('.back .icon')[0].offsetWidth;
                }
              }
            }
          }

          if (!noRight && (right.hasClass('sliding') || sliding)) {
            if (app.rtl) {
              right[0].f7NavbarLeftOffset = -rightWidth * inverter;
              right[0].f7NavbarRightOffset = (navbarInnerWidth - right[0].offsetWidth) / 2 * inverter;
            } else {
              right[0].f7NavbarLeftOffset = -(navbarInnerWidth - right[0].offsetWidth) / 2;
              right[0].f7NavbarRightOffset = rightWidth;
            }
          }

          if (subnavbar.length && (subnavbar.hasClass('sliding') || sliding)) {
            subnavbar[0].f7NavbarLeftOffset = app.rtl ? subnavbar[0].offsetWidth : -subnavbar[0].offsetWidth;
            subnavbar[0].f7NavbarRightOffset = -subnavbar[0].f7NavbarLeftOffset;
          }
        } // Center title


        if (needCenterTitle) {
          var titleLeft = diff;
          if (app.rtl && noLeft && noRight && title.length > 0) titleLeft = -titleLeft;
          title.css({
            left: titleLeft + "px"
          });
        }
      },
      hide: function hide(el, animate, hideStatusbar, hideOnlyCurrent) {
        if (animate === void 0) {
          animate = true;
        }

        if (hideStatusbar === void 0) {
          hideStatusbar = false;
        }

        if (hideOnlyCurrent === void 0) {
          hideOnlyCurrent = false;
        }

        var app = this;
        var $el = $(el);
        var isDynamic = $el.hasClass('navbar') && $el.parent('.navbars').length && !hideOnlyCurrent;
        if (isDynamic) $el = $el.parents('.navbars');
        if (!$el.length) return;
        if ($el.hasClass('navbar-hidden')) return;
        var className = "navbar-hidden" + (animate ? ' navbar-transitioning' : '');
        var currentIsLarge = isDynamic ? $el.find('.navbar-current .title-large').length : $el.find('.title-large').length;

        if (currentIsLarge) {
          className += ' navbar-large-hidden';
        }

        if (hideStatusbar) {
          className += ' navbar-hidden-statusbar';
        }

        $el.transitionEnd(function () {
          $el.removeClass('navbar-transitioning');
        });
        $el.addClass(className);

        if (isDynamic) {
          $el.children('.navbar').each(function (subEl) {
            $(subEl).trigger('navbar:hide');
            app.emit('navbarHide', subEl);
          });
        } else {
          $el.trigger('navbar:hide');
          app.emit('navbarHide', $el[0]);
        }
      },
      show: function show(el, animate, hideOnlyCurrent) {
        if (el === void 0) {
          el = '.navbar-hidden';
        }

        if (animate === void 0) {
          animate = true;
        }

        if (hideOnlyCurrent === void 0) {
          hideOnlyCurrent = false;
        }

        var app = this;
        var $el = $(el);
        var isDynamic = $el.hasClass('navbar') && $el.parent('.navbars').length && !hideOnlyCurrent;
        if (isDynamic) $el = $el.parents('.navbars');
        if (!$el.length) return;
        if (!$el.hasClass('navbar-hidden')) return;

        if (animate) {
          $el.addClass('navbar-transitioning');
          $el.transitionEnd(function () {
            $el.removeClass('navbar-transitioning');
          });
        }

        $el.removeClass('navbar-hidden navbar-large-hidden navbar-hidden-statusbar');

        if (isDynamic) {
          $el.children('.navbar').each(function (subEl) {
            $(subEl).trigger('navbar:show');
            app.emit('navbarShow', subEl);
          });
        } else {
          $el.trigger('navbar:show');
          app.emit('navbarShow', $el[0]);
        }
      },
      getElByPage: function getElByPage(page) {
        var $pageEl;
        var $navbarEl;
        var pageData;

        if (page.$navbarEl || page.$el) {
          pageData = page;
          $pageEl = page.$el;
        } else {
          $pageEl = $(page);
          if ($pageEl.length > 0) pageData = $pageEl[0].f7Page;
        }

        if (pageData && pageData.$navbarEl && pageData.$navbarEl.length > 0) {
          $navbarEl = pageData.$navbarEl;
        } else if ($pageEl) {
          $navbarEl = $pageEl.children('.navbar');
        }

        if (!$navbarEl || $navbarEl && $navbarEl.length === 0) return undefined;
        return $navbarEl[0];
      },
      getPageByEl: function getPageByEl(navbarEl) {
        var $navbarEl = $(navbarEl);

        if ($navbarEl.parents('.page').length) {
          return $navbarEl.parents('.page')[0];
        }

        var pageEl;
        $navbarEl.parents('.view').find('.page').each(function (el) {
          if (el && el.f7Page && el.f7Page.navbarEl && $navbarEl[0] === el.f7Page.navbarEl) {
            pageEl = el;
          }
        });
        return pageEl;
      },
      collapseLargeTitle: function collapseLargeTitle(navbarEl) {
        var app = this;
        var $navbarEl = $(navbarEl);

        if ($navbarEl.hasClass('navbars')) {
          $navbarEl = $navbarEl.find('.navbar');

          if ($navbarEl.length > 1) {
            $navbarEl = $(navbarEl).find('.navbar-large.navbar-current');
          }

          if ($navbarEl.length > 1 || !$navbarEl.length) {
            return;
          }
        }

        var $pageEl = $(app.navbar.getPageByEl($navbarEl));
        $navbarEl.addClass('navbar-large-collapsed');
        $pageEl.eq(0).addClass('page-with-navbar-large-collapsed').trigger('page:navbarlargecollapsed');
        app.emit('pageNavbarLargeCollapsed', $pageEl[0]);
        $navbarEl.trigger('navbar:collapse');
        app.emit('navbarCollapse', $navbarEl[0]);
      },
      expandLargeTitle: function expandLargeTitle(navbarEl) {
        var app = this;
        var $navbarEl = $(navbarEl);

        if ($navbarEl.hasClass('navbars')) {
          $navbarEl = $navbarEl.find('.navbar-large');

          if ($navbarEl.length > 1) {
            $navbarEl = $(navbarEl).find('.navbar-large.navbar-current');
          }

          if ($navbarEl.length > 1 || !$navbarEl.length) {
            return;
          }
        }

        var $pageEl = $(app.navbar.getPageByEl($navbarEl));
        $navbarEl.removeClass('navbar-large-collapsed');
        $pageEl.eq(0).removeClass('page-with-navbar-large-collapsed').trigger('page:navbarlargeexpanded');
        app.emit('pageNavbarLargeExpanded', $pageEl[0]);
        $navbarEl.trigger('navbar:expand');
        app.emit('navbarExpand', $navbarEl[0]);
      },
      toggleLargeTitle: function toggleLargeTitle(navbarEl) {
        var app = this;
        var $navbarEl = $(navbarEl);

        if ($navbarEl.hasClass('navbars')) {
          $navbarEl = $navbarEl.find('.navbar-large');

          if ($navbarEl.length > 1) {
            $navbarEl = $(navbarEl).find('.navbar-large.navbar-current');
          }

          if ($navbarEl.length > 1 || !$navbarEl.length) {
            return;
          }
        }

        if ($navbarEl.hasClass('navbar-large-collapsed')) {
          app.navbar.expandLargeTitle($navbarEl);
        } else {
          app.navbar.collapseLargeTitle($navbarEl);
        }
      },
      initNavbarOnScroll: function initNavbarOnScroll(pageEl, navbarEl, needHide, needCollapse, needTransparent) {
        var app = this;
        var support = getSupport$1();
        var $pageEl = $(pageEl);
        var $navbarEl = $(navbarEl);
        var $titleLargeEl = $navbarEl.find('.title-large');
        var isLarge = $titleLargeEl.length || $navbarEl.hasClass('.navbar-large');
        var navbarHideHeight = 44;
        var snapPageScrollToLargeTitle = app.params.navbar.snapPageScrollToLargeTitle;
        var snapPageScrollToTransparentNavbar = app.params.navbar.snapPageScrollToTransparentNavbar;
        var previousScrollTop;
        var currentScrollTop;
        var scrollHeight;
        var offsetHeight;
        var reachEnd;
        var action;
        var navbarHidden;
        var navbarCollapsed;
        var navbarTitleLargeHeight;
        var navbarOffsetHeight;

        if (needCollapse || needHide && isLarge) {
          navbarTitleLargeHeight = $navbarEl.css('--f7-navbar-large-title-height');

          if (navbarTitleLargeHeight && navbarTitleLargeHeight.indexOf('px') >= 0) {
            navbarTitleLargeHeight = parseInt(navbarTitleLargeHeight, 10);

            if (Number.isNaN(navbarTitleLargeHeight) && $titleLargeEl.length) {
              navbarTitleLargeHeight = $titleLargeEl[0].offsetHeight;
            } else if (Number.isNaN(navbarTitleLargeHeight)) {
              if (app.theme === 'ios') navbarTitleLargeHeight = 52;else if (app.theme === 'md') navbarTitleLargeHeight = 48;else if (app.theme === 'aurora') navbarTitleLargeHeight = 38;
            }
          } else if ($titleLargeEl.length) {
            navbarTitleLargeHeight = $titleLargeEl[0].offsetHeight;
          } else {
            // eslint-disable-next-line
            if (app.theme === 'ios') navbarTitleLargeHeight = 52;else if (app.theme === 'md') navbarTitleLargeHeight = 48;else if (app.theme === 'aurora') navbarTitleLargeHeight = 38;
          }
        }

        if (needHide && isLarge) {
          navbarHideHeight += navbarTitleLargeHeight;
        }

        var scrollChanged;
        var scrollContent;
        var scrollTimeoutId;
        var touchEndTimeoutId;
        var touchSnapTimeout = 70;
        var desktopSnapTimeout = 300;

        function calcScrollableDistance() {
          $pageEl.find('.page-content').each(function (pageContentEl) {
            pageContentEl.f7ScrollableDistance = pageContentEl.scrollHeight - pageContentEl.offsetHeight;
          });
        }

        function snapLargeNavbar() {
          var inSearchbarExpanded = $navbarEl.hasClass('with-searchbar-expandable-enabled');
          if (inSearchbarExpanded) return;
          if (!scrollContent || currentScrollTop < 0) return;

          if (currentScrollTop >= navbarTitleLargeHeight / 2 && currentScrollTop < navbarTitleLargeHeight) {
            $(scrollContent).scrollTop(navbarTitleLargeHeight, 100);
          } else if (currentScrollTop < navbarTitleLargeHeight) {
            $(scrollContent).scrollTop(0, 200);
          }
        }

        function snapTransparentNavbar() {
          var inSearchbarExpanded = $navbarEl.hasClass('with-searchbar-expandable-enabled');
          if (inSearchbarExpanded) return;
          if (!scrollContent || currentScrollTop < 0) return;

          if (currentScrollTop >= navbarOffsetHeight / 2 && currentScrollTop < navbarOffsetHeight) {
            $(scrollContent).scrollTop(navbarOffsetHeight, 100);
          } else if (currentScrollTop < navbarOffsetHeight) {
            $(scrollContent).scrollTop(0, 200);
          }
        }

        function handleNavbarTransparent() {
          var isHidden = $navbarEl.hasClass('navbar-hidden') || $navbarEl.parent('.navbars').hasClass('navbar-hidden');
          var inSearchbarExpanded = $navbarEl.hasClass('with-searchbar-expandable-enabled');
          if (inSearchbarExpanded || isHidden) return;

          if (!navbarOffsetHeight) {
            navbarOffsetHeight = navbarEl.offsetHeight;
          }

          var opacity = currentScrollTop / navbarOffsetHeight;
          var notTransparent = $navbarEl.hasClass('navbar-transparent-visible');
          opacity = Math.max(Math.min(opacity, 1), 0);

          if (notTransparent && opacity === 1 || !notTransparent && opacity === 0) {
            $navbarEl.find('.navbar-bg, .title').css('opacity', '');
            return;
          }

          if (notTransparent && opacity === 0) {
            $navbarEl.trigger('navbar:transparenthide');
            app.emit('navbarTransparentHide', $navbarEl[0]);
            $navbarEl.removeClass('navbar-transparent-visible');
            $navbarEl.find('.navbar-bg, .title').css('opacity', '');
            return;
          }

          if (!notTransparent && opacity === 1) {
            $navbarEl.trigger('navbar:transparentshow');
            app.emit('navbarTransparentShow', $navbarEl[0]);
            $navbarEl.addClass('navbar-transparent-visible');
            $navbarEl.find('.navbar-bg, .title').css('opacity', '');
            return;
          }

          $navbarEl.find('.navbar-bg, .title').css('opacity', opacity);

          if (snapPageScrollToTransparentNavbar) {
            if (!support.touch) {
              clearTimeout(scrollTimeoutId);
              scrollTimeoutId = setTimeout(function () {
                snapTransparentNavbar();
              }, desktopSnapTimeout);
            } else if (touchEndTimeoutId) {
              clearTimeout(touchEndTimeoutId);
              touchEndTimeoutId = null;
              touchEndTimeoutId = setTimeout(function () {
                snapTransparentNavbar();
                clearTimeout(touchEndTimeoutId);
                touchEndTimeoutId = null;
              }, touchSnapTimeout);
            }
          }
        }

        var previousCollapseProgress = null;
        var collapseProgress = null;

        function handleLargeNavbarCollapse(pageContentEl) {
          var isHidden = $navbarEl.hasClass('navbar-hidden') || $navbarEl.parent('.navbars').hasClass('navbar-hidden');
          if (isHidden) return;
          var isLargeTransparent = $navbarEl.hasClass('navbar-large-transparent') || $navbarEl.hasClass('navbar-large') && $navbarEl.hasClass('navbar-transparent');
          previousCollapseProgress = collapseProgress;
          var scrollableDistance = Math.min(navbarTitleLargeHeight, pageContentEl.f7ScrollableDistance || navbarTitleLargeHeight);
          collapseProgress = Math.min(Math.max(currentScrollTop / scrollableDistance, 0), 1);
          var previousCollapseWasInMiddle = previousCollapseProgress > 0 && previousCollapseProgress < 1;
          var inSearchbarExpanded = $navbarEl.hasClass('with-searchbar-expandable-enabled');
          if (inSearchbarExpanded) return;
          navbarCollapsed = $navbarEl.hasClass('navbar-large-collapsed');

          if (collapseProgress === 0 && navbarCollapsed) {
            app.navbar.expandLargeTitle($navbarEl[0]);
          } else if (collapseProgress === 1 && !navbarCollapsed) {
            app.navbar.collapseLargeTitle($navbarEl[0]);
          }

          if (collapseProgress === 0 && navbarCollapsed || collapseProgress === 0 && previousCollapseWasInMiddle || collapseProgress === 1 && !navbarCollapsed || collapseProgress === 1 && previousCollapseWasInMiddle) {
            if (app.theme === 'md') {
              $navbarEl.find('.navbar-inner').css('overflow', '');
            }

            $navbarEl.find('.title').css('opacity', '');
            $navbarEl.find('.title-large-text, .subnavbar').css('transform', '');

            if (isLargeTransparent) {
              $navbarEl.find('.navbar-bg').css('opacity', '');
            } else {
              $navbarEl.find('.navbar-bg').css('transform', '');
            }
          } else if (collapseProgress > 0 && collapseProgress < 1) {
            if (app.theme === 'md') {
              $navbarEl.find('.navbar-inner').css('overflow', 'visible');
            }

            $navbarEl.find('.title').css('opacity', collapseProgress);
            $navbarEl.find('.title-large-text, .subnavbar').css('transform', "translate3d(0px, " + -1 * collapseProgress * navbarTitleLargeHeight + "px, 0)");

            if (isLargeTransparent) {
              $navbarEl.find('.navbar-bg').css('opacity', collapseProgress);
            } else {
              $navbarEl.find('.navbar-bg').css('transform', "translate3d(0px, " + -1 * collapseProgress * navbarTitleLargeHeight + "px, 0)");
            }
          }

          if (snapPageScrollToLargeTitle) {
            if (!support.touch) {
              clearTimeout(scrollTimeoutId);
              scrollTimeoutId = setTimeout(function () {
                snapLargeNavbar();
              }, desktopSnapTimeout);
            } else if (touchEndTimeoutId) {
              clearTimeout(touchEndTimeoutId);
              touchEndTimeoutId = null;
              touchEndTimeoutId = setTimeout(function () {
                snapLargeNavbar();
                clearTimeout(touchEndTimeoutId);
                touchEndTimeoutId = null;
              }, touchSnapTimeout);
            }
          }
        }

        function handleTitleHideShow() {
          if ($pageEl.hasClass('page-with-card-opened')) return;
          scrollHeight = scrollContent.scrollHeight;
          offsetHeight = scrollContent.offsetHeight;
          reachEnd = currentScrollTop + offsetHeight >= scrollHeight;
          navbarHidden = $navbarEl.hasClass('navbar-hidden') || $navbarEl.parent('.navbars').hasClass('navbar-hidden');

          if (reachEnd) {
            if (app.params.navbar.showOnPageScrollEnd) {
              action = 'show';
            }
          } else if (previousScrollTop > currentScrollTop) {
            if (app.params.navbar.showOnPageScrollTop || currentScrollTop <= navbarHideHeight) {
              action = 'show';
            } else {
              action = 'hide';
            }
          } else if (currentScrollTop > navbarHideHeight) {
            action = 'hide';
          } else {
            action = 'show';
          }

          if (action === 'show' && navbarHidden) {
            app.navbar.show($navbarEl, true, true);
            navbarHidden = false;
          } else if (action === 'hide' && !navbarHidden) {
            app.navbar.hide($navbarEl, true, false, true);
            navbarHidden = true;
          }

          previousScrollTop = currentScrollTop;
        }

        function handleScroll(e) {
          scrollContent = this;

          if (e && e.target && e.target !== scrollContent) {
            return;
          }

          currentScrollTop = scrollContent.scrollTop;
          scrollChanged = currentScrollTop;

          if (needCollapse) {
            handleLargeNavbarCollapse(scrollContent);
          } else if (needTransparent) {
            handleNavbarTransparent();
          }

          if ($pageEl.hasClass('page-previous')) return;

          if (needHide) {
            handleTitleHideShow();
          }
        }

        function handeTouchStart() {
          scrollChanged = false;
        }

        function handleTouchEnd() {
          clearTimeout(touchEndTimeoutId);
          touchEndTimeoutId = null;
          touchEndTimeoutId = setTimeout(function () {
            if (scrollChanged !== false) {
              if (needTransparent && !needCollapse) {
                snapTransparentNavbar();
              } else {
                snapLargeNavbar();
              }

              clearTimeout(touchEndTimeoutId);
              touchEndTimeoutId = null;
            }
          }, touchSnapTimeout);
        }

        $pageEl.on('scroll', '.page-content', handleScroll, true);

        if (support.touch && (needCollapse && snapPageScrollToLargeTitle || needTransparent && snapPageScrollToTransparentNavbar)) {
          app.on('touchstart:passive', handeTouchStart);
          app.on('touchend:passive', handleTouchEnd);
        }

        calcScrollableDistance();

        if (needCollapse || needTransparent) {
          $pageEl.find('.page-content').each(function (pageContentEl) {
            if (pageContentEl.scrollTop > 0) handleScroll.call(pageContentEl);
          });
        }

        app.on('resize', calcScrollableDistance);

        $pageEl[0].f7DetachNavbarScrollHandlers = function f7DetachNavbarScrollHandlers() {
          app.off('resize', calcScrollableDistance);
          delete $pageEl[0].f7DetachNavbarScrollHandlers;
          $pageEl.off('scroll', '.page-content', handleScroll, true);

          if (support.touch && (needCollapse && snapPageScrollToLargeTitle || needTransparent && snapPageScrollToTransparentNavbar)) {
            app.off('touchstart:passive', handeTouchStart);
            app.off('touchend:passive', handleTouchEnd);
          }
        };
      }
    };
    var Navbar$1 = {
      name: 'navbar',
      create: function create() {
        var app = this;
        bindMethods(app, {
          navbar: Navbar
        });
      },
      params: {
        navbar: {
          scrollTopOnTitleClick: true,
          iosCenterTitle: true,
          mdCenterTitle: false,
          auroraCenterTitle: true,
          hideOnPageScroll: false,
          showOnPageScrollEnd: true,
          showOnPageScrollTop: true,
          collapseLargeTitleOnScroll: true,
          snapPageScrollToLargeTitle: true,
          snapPageScrollToTransparentNavbar: true
        }
      },
      on: {
        'panelBreakpoint panelCollapsedBreakpoint panelResize viewResize resize viewMasterDetailBreakpoint': function onPanelResize() {
          var app = this;
          $('.navbar').each(function (navbarEl) {
            app.navbar.size(navbarEl);
          });
        },
        pageBeforeRemove: function pageBeforeRemove(page) {
          if (page.$el[0].f7DetachNavbarScrollHandlers) {
            page.$el[0].f7DetachNavbarScrollHandlers();
          }
        },
        pageBeforeIn: function pageBeforeIn(page) {
          var app = this;
          if (app.theme !== 'ios') return;
          var $navbarsEl;
          var view = page.$el.parents('.view')[0].f7View;
          var navbarEl = app.navbar.getElByPage(page);

          if (!navbarEl) {
            $navbarsEl = page.$el.parents('.view').children('.navbars');
          } else {
            $navbarsEl = $(navbarEl).parents('.navbars');
          }

          if (page.$el.hasClass('no-navbar') || view.router.dynamicNavbar && !navbarEl) {
            var animate = !!(page.pageFrom && page.router.history.length > 0);
            app.navbar.hide($navbarsEl, animate);
          } else {
            app.navbar.show($navbarsEl);
          }
        },
        pageReinit: function pageReinit(page) {
          var app = this;
          var $navbarEl = $(app.navbar.getElByPage(page));
          if (!$navbarEl || $navbarEl.length === 0) return;
          app.navbar.size($navbarEl);
        },
        pageInit: function pageInit(page) {
          var app = this;
          var $navbarEl = $(app.navbar.getElByPage(page));
          if (!$navbarEl || $navbarEl.length === 0) return; // Size

          app.navbar.size($navbarEl); // Need Collapse On Scroll

          var needCollapseOnScrollHandler;

          if ($navbarEl.find('.title-large').length > 0) {
            $navbarEl.addClass('navbar-large');
          }

          if ($navbarEl.hasClass('navbar-large')) {
            if (app.params.navbar.collapseLargeTitleOnScroll) needCollapseOnScrollHandler = true;
            page.$el.addClass('page-with-navbar-large');
          } // Need transparent on scroll


          var needTransparentOnScroll;

          if (!needCollapseOnScrollHandler && $navbarEl.hasClass('navbar-transparent')) {
            needTransparentOnScroll = true;
          } // Need Hide On Scroll


          var needHideOnScrollHandler;

          if (app.params.navbar.hideOnPageScroll || page.$el.find('.hide-navbar-on-scroll').length || page.$el.hasClass('hide-navbar-on-scroll') || page.$el.find('.hide-bars-on-scroll').length || page.$el.hasClass('hide-bars-on-scroll')) {
            if (page.$el.find('.keep-navbar-on-scroll').length || page.$el.hasClass('keep-navbar-on-scroll') || page.$el.find('.keep-bars-on-scroll').length || page.$el.hasClass('keep-bars-on-scroll')) {
              needHideOnScrollHandler = false;
            } else {
              needHideOnScrollHandler = true;
            }
          }

          if (needCollapseOnScrollHandler || needHideOnScrollHandler || needTransparentOnScroll) {
            app.navbar.initNavbarOnScroll(page.el, $navbarEl[0], needHideOnScrollHandler, needCollapseOnScrollHandler, needTransparentOnScroll);
          }
        },
        'panelOpen panelSwipeOpen modalOpen': function onPanelModalOpen(instance) {
          var app = this;
          instance.$el.find('.navbar:not(.navbar-previous):not(.stacked)').each(function (navbarEl) {
            app.navbar.size(navbarEl);
          });
        },
        tabShow: function tabShow(tabEl) {
          var app = this;
          $(tabEl).find('.navbar:not(.navbar-previous):not(.stacked)').each(function (navbarEl) {
            app.navbar.size(navbarEl);
          });
        }
      },
      clicks: {
        '.navbar .title': function onTitleClick($clickedEl, clickedData, e) {
          var app = this;
          if (!app.params.navbar.scrollTopOnTitleClick) return;

          if ($(e.target).closest('a, button').length > 0) {
            return;
          }

          var $pageContentEl; // Find active page

          var $navbarEl = $clickedEl.parents('.navbar');
          var $navbarsEl = $navbarEl.parents('.navbars'); // Static Layout

          $pageContentEl = $navbarEl.parents('.page-content');

          if ($pageContentEl.length === 0) {
            // Fixed Layout
            if ($navbarEl.parents('.page').length > 0) {
              $pageContentEl = $navbarEl.parents('.page').find('.page-content');
            } // Through Layout iOS


            if ($pageContentEl.length === 0 && $navbarsEl.length) {
              if ($navbarsEl.nextAll('.page-current:not(.stacked)').length > 0) {
                $pageContentEl = $navbarsEl.nextAll('.page-current:not(.stacked)').find('.page-content');
              }
            } // Through Layout


            if ($pageContentEl.length === 0) {
              if ($navbarEl.nextAll('.page-current:not(.stacked)').length > 0) {
                $pageContentEl = $navbarEl.nextAll('.page-current:not(.stacked)').find('.page-content');
              }
            }
          }

          if ($pageContentEl && $pageContentEl.length > 0) {
            // Check for tab
            if ($pageContentEl.hasClass('tab')) {
              $pageContentEl = $pageContentEl.parent('.tabs').children('.page-content.tab-active');
            }

            if ($pageContentEl.length > 0) $pageContentEl.scrollTop(0, 300);
          }
        }
      },
      vnode: {
        navbar: {
          postpatch: function postpatch(vnode) {
            var app = this;
            app.navbar.size(vnode.elm);
          }
        }
      }
    };

    var Toolbar = {
      setHighlight: function setHighlight(tabbarEl) {
        var app = this;
        var $tabbarEl = $(tabbarEl);
        if (app.theme === 'ios' && !$tabbarEl.hasClass('tabbar-highlight')) return;
        if ($tabbarEl.length === 0 || !($tabbarEl.hasClass('tabbar') || $tabbarEl.hasClass('tabbar-labels'))) return;
        var $highlightEl = $tabbarEl.find('.tab-link-highlight');
        var tabLinksCount = $tabbarEl.find('.tab-link').length;

        if (tabLinksCount === 0) {
          $highlightEl.remove();
          return;
        }

        if ($highlightEl.length === 0) {
          $tabbarEl.children('.toolbar-inner').append('<span class="tab-link-highlight"></span>');
          $highlightEl = $tabbarEl.find('.tab-link-highlight');
        } else if ($highlightEl.next().length) {
          $tabbarEl.children('.toolbar-inner').append($highlightEl);
        }

        var $activeLink = $tabbarEl.find('.tab-link-active');
        var highlightWidth;
        var highlightTranslate;

        if ($tabbarEl.hasClass('tabbar-scrollable') && $activeLink && $activeLink[0]) {
          highlightWidth = $activeLink[0].offsetWidth + "px";
          highlightTranslate = $activeLink[0].offsetLeft + "px";
        } else {
          var activeIndex = $activeLink.index();
          highlightWidth = 100 / tabLinksCount + "%";
          highlightTranslate = (app.rtl ? -activeIndex : activeIndex) * 100 + "%";
        }

        nextFrame$1(function () {
          $highlightEl.css('width', highlightWidth).transform("translate3d(" + highlightTranslate + ",0,0)");
        });
      },
      init: function init(tabbarEl) {
        var app = this;
        app.toolbar.setHighlight(tabbarEl);
      },
      hide: function hide(el, animate) {
        if (animate === void 0) {
          animate = true;
        }

        var app = this;
        var $el = $(el);
        if ($el.hasClass('toolbar-hidden')) return;
        var className = "toolbar-hidden" + (animate ? ' toolbar-transitioning' : '');
        $el.transitionEnd(function () {
          $el.removeClass('toolbar-transitioning');
        });
        $el.addClass(className);
        $el.trigger('toolbar:hide');
        app.emit('toolbarHide', $el[0]);
      },
      show: function show(el, animate) {
        if (animate === void 0) {
          animate = true;
        }

        var app = this;
        var $el = $(el);
        if (!$el.hasClass('toolbar-hidden')) return;

        if (animate) {
          $el.addClass('toolbar-transitioning');
          $el.transitionEnd(function () {
            $el.removeClass('toolbar-transitioning');
          });
        }

        $el.removeClass('toolbar-hidden');
        $el.trigger('toolbar:show');
        app.emit('toolbarShow', $el[0]);
      },
      initToolbarOnScroll: function initToolbarOnScroll(pageEl) {
        var app = this;
        var $pageEl = $(pageEl);
        var $toolbarEl = $pageEl.parents('.view').children('.toolbar');

        if ($toolbarEl.length === 0) {
          $toolbarEl = $pageEl.find('.toolbar');
        }

        if ($toolbarEl.length === 0) {
          $toolbarEl = $pageEl.parents('.views').children('.tabbar, .tabbar-labels');
        }

        if ($toolbarEl.length === 0) {
          return;
        }

        var previousScrollTop;
        var currentScrollTop;
        var scrollHeight;
        var offsetHeight;
        var reachEnd;
        var action;
        var toolbarHidden;

        function handleScroll(e) {
          if ($pageEl.hasClass('page-with-card-opened')) return;
          if ($pageEl.hasClass('page-previous')) return;
          var scrollContent = this;

          if (e && e.target && e.target !== scrollContent) {
            return;
          }

          currentScrollTop = scrollContent.scrollTop;
          scrollHeight = scrollContent.scrollHeight;
          offsetHeight = scrollContent.offsetHeight;
          reachEnd = currentScrollTop + offsetHeight >= scrollHeight;
          toolbarHidden = $toolbarEl.hasClass('toolbar-hidden');

          if (reachEnd) {
            if (app.params.toolbar.showOnPageScrollEnd) {
              action = 'show';
            }
          } else if (previousScrollTop > currentScrollTop) {
            if (app.params.toolbar.showOnPageScrollTop || currentScrollTop <= 44) {
              action = 'show';
            } else {
              action = 'hide';
            }
          } else if (currentScrollTop > 44) {
            action = 'hide';
          } else {
            action = 'show';
          }

          if (action === 'show' && toolbarHidden) {
            app.toolbar.show($toolbarEl);
            toolbarHidden = false;
          } else if (action === 'hide' && !toolbarHidden) {
            app.toolbar.hide($toolbarEl);
            toolbarHidden = true;
          }

          previousScrollTop = currentScrollTop;
        }

        $pageEl.on('scroll', '.page-content', handleScroll, true);
        $pageEl[0].f7ScrollToolbarHandler = handleScroll;
      }
    };
    var Toolbar$1 = {
      name: 'toolbar',
      create: function create() {
        var app = this;
        bindMethods(app, {
          toolbar: Toolbar
        });
      },
      params: {
        toolbar: {
          hideOnPageScroll: false,
          showOnPageScrollEnd: true,
          showOnPageScrollTop: true
        }
      },
      on: {
        pageBeforeRemove: function pageBeforeRemove(page) {
          if (page.$el[0].f7ScrollToolbarHandler) {
            page.$el.off('scroll', '.page-content', page.$el[0].f7ScrollToolbarHandler, true);
          }
        },
        pageBeforeIn: function pageBeforeIn(page) {
          var app = this;
          var $toolbarEl = page.$el.parents('.view').children('.toolbar');

          if ($toolbarEl.length === 0) {
            $toolbarEl = page.$el.parents('.views').children('.tabbar, .tabbar-labels');
          }

          if ($toolbarEl.length === 0) {
            $toolbarEl = page.$el.find('.toolbar');
          }

          if ($toolbarEl.length === 0) {
            return;
          }

          if (page.$el.hasClass('no-toolbar')) {
            app.toolbar.hide($toolbarEl);
          } else {
            app.toolbar.show($toolbarEl);
          }
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.tabbar, .tabbar-labels').each(function (tabbarEl) {
            app.toolbar.init(tabbarEl);
          });

          if (app.params.toolbar.hideOnPageScroll || page.$el.find('.hide-toolbar-on-scroll').length || page.$el.hasClass('hide-toolbar-on-scroll') || page.$el.find('.hide-bars-on-scroll').length || page.$el.hasClass('hide-bars-on-scroll')) {
            if (page.$el.find('.keep-toolbar-on-scroll').length || page.$el.hasClass('keep-toolbar-on-scroll') || page.$el.find('.keep-bars-on-scroll').length || page.$el.hasClass('keep-bars-on-scroll')) {
              return;
            }

            app.toolbar.initToolbarOnScroll(page.el);
          }
        },
        init: function init() {
          var app = this;
          app.$el.find('.tabbar, .tabbar-labels').each(function (tabbarEl) {
            app.toolbar.init(tabbarEl);
          });
        }
      },
      vnode: {
        tabbar: {
          insert: function insert(vnode) {
            var app = this;
            app.toolbar.init(vnode.elm);
          }
        }
      }
    };

    var Subnavbar = {
      name: 'subnavbar',
      on: {
        pageInit: function pageInit(page) {
          if (page.$navbarEl && page.$navbarEl.length && page.$navbarEl.find('.subnavbar').length) {
            page.$el.addClass('page-with-subnavbar');
          }

          var $innerSubnavbars = page.$el.find('.subnavbar').filter(function (subnavbarEl) {
            return $(subnavbarEl).parents('.page')[0] === page.$el[0];
          });

          if ($innerSubnavbars.length) {
            page.$el.addClass('page-with-subnavbar');
          }
        }
      }
    };

    var TouchRipple$1 = /*#__PURE__*/function () {
      function TouchRipple(app, $el, x, y) {
        var ripple = this;
        if (!$el) return undefined;

        var _$el$0$getBoundingCli = $el[0].getBoundingClientRect(),
            left = _$el$0$getBoundingCli.left,
            top = _$el$0$getBoundingCli.top,
            width = _$el$0$getBoundingCli.width,
            height = _$el$0$getBoundingCli.height;

        var center = {
          x: x - left,
          y: y - top
        };
        var diameter = Math.max(Math.pow(Math.pow(height, 2) + Math.pow(width, 2), 0.5), 48);
        var isInset = false;
        var insetElements = app.params.touch.touchRippleInsetElements || '';

        if (insetElements && $el.is(insetElements)) {
          isInset = true;
        }

        if (isInset) {
          diameter = Math.max(Math.min(width, height), 48);
        }

        if (!isInset && $el.css('overflow') === 'hidden') {
          var distanceFromCenter = Math.pow(Math.pow(center.x - width / 2, 2) + Math.pow(center.y - height / 2, 2), 0.5);
          var scale = (diameter / 2 + distanceFromCenter) / (diameter / 2);
          ripple.rippleTransform = "translate3d(0px, 0px, 0) scale(" + scale + ")";
        } else {
          // prettier-ignore
          ripple.rippleTransform = "translate3d(" + (-center.x + width / 2) + "px, " + (-center.y + height / 2) + "px, 0) scale(1)";
        }

        if (isInset) {
          $el.addClass('ripple-inset');
        }

        ripple.$rippleWaveEl = $("<div class=\"ripple-wave\" style=\"width: " + diameter + "px; height: " + diameter + "px; margin-top:-" + diameter / 2 + "px; margin-left:-" + diameter / 2 + "px; left:" + center.x + "px; top:" + center.y + "px; --f7-ripple-transform: " + ripple.rippleTransform + "\"></div>");
        $el.prepend(ripple.$rippleWaveEl);
        ripple.$rippleWaveEl.animationEnd(function () {
          if (!ripple.$rippleWaveEl) return;
          if (ripple.$rippleWaveEl.hasClass('ripple-wave-out')) return;
          ripple.$rippleWaveEl.addClass('ripple-wave-in');

          if (ripple.shouldBeRemoved) {
            ripple.out();
          }
        });
        return ripple;
      }

      var _proto = TouchRipple.prototype;

      _proto.destroy = function destroy() {
        var ripple = this;

        if (ripple.$rippleWaveEl) {
          ripple.$rippleWaveEl.remove();
        }

        Object.keys(ripple).forEach(function (key) {
          ripple[key] = null;
          delete ripple[key];
        });
        ripple = null;
      };

      _proto.out = function out() {
        var ripple = this;
        var $rippleWaveEl = this.$rippleWaveEl;
        clearTimeout(ripple.removeTimeout);
        $rippleWaveEl.addClass('ripple-wave-out');
        ripple.removeTimeout = setTimeout(function () {
          ripple.destroy();
        }, 300);
        $rippleWaveEl.animationEnd(function () {
          clearTimeout(ripple.removeTimeout);
          ripple.destroy();
        });
      };

      _proto.remove = function remove() {
        var ripple = this;
        if (ripple.shouldBeRemoved) return;
        ripple.removeTimeout = setTimeout(function () {
          ripple.destroy();
        }, 400);
        ripple.shouldBeRemoved = true;

        if (ripple.$rippleWaveEl.hasClass('ripple-wave-in')) {
          ripple.out();
        }
      };

      return TouchRipple;
    }();

    var TouchRipple = {
      name: 'touch-ripple',
      static: {
        TouchRipple: TouchRipple$1
      },
      create: function create() {
        var app = this;
        app.touchRipple = {
          create: function create() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            return _construct(TouchRipple$1, args);
          }
        };
      }
    };

    var openedModals = [];
    var dialogsQueue = [];

    function clearDialogsQueue() {
      if (dialogsQueue.length === 0) return;
      var dialog = dialogsQueue.shift();
      dialog.open();
    }

    var Modal$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(Modal, _Framework7Class);

      function Modal(app, params) {
        var _this;

        _this = _Framework7Class.call(this, params, [app]) || this;

        var modal = _assertThisInitialized(_this);

        var defaults = {}; // Extend defaults with modules params

        modal.useModulesParams(defaults);
        modal.params = extend$1(defaults, params);
        modal.opened = false;
        var $containerEl = modal.params.containerEl ? $(modal.params.containerEl).eq(0) : app.$el;
        if (!$containerEl.length) $containerEl = app.$el;
        modal.$containerEl = $containerEl;
        modal.containerEl = $containerEl[0]; // Install Modules

        modal.useModules();
        return _assertThisInitialized(_this) || _assertThisInitialized(_this);
      }

      var _proto = Modal.prototype;

      _proto.onOpen = function onOpen() {
        var modal = this;
        modal.opened = true;
        openedModals.push(modal);
        $('html').addClass("with-modal-" + modal.type.toLowerCase());
        modal.$el.trigger("modal:open " + modal.type.toLowerCase() + ":open");
        modal.emit("local::open modalOpen " + modal.type + "Open", modal);
      };

      _proto.onOpened = function onOpened() {
        var modal = this;
        modal.$el.trigger("modal:opened " + modal.type.toLowerCase() + ":opened");
        modal.emit("local::opened modalOpened " + modal.type + "Opened", modal);
      };

      _proto.onClose = function onClose() {
        var modal = this;
        modal.opened = false;
        if (!modal.type || !modal.$el) return;
        openedModals.splice(openedModals.indexOf(modal), 1);
        $('html').removeClass("with-modal-" + modal.type.toLowerCase());
        modal.$el.trigger("modal:close " + modal.type.toLowerCase() + ":close");
        modal.emit("local::close modalClose " + modal.type + "Close", modal);
      };

      _proto.onClosed = function onClosed() {
        var modal = this;
        if (!modal.type || !modal.$el) return;
        modal.$el.removeClass('modal-out');
        modal.$el.hide();
        modal.$el.trigger("modal:closed " + modal.type.toLowerCase() + ":closed");
        modal.emit("local::closed modalClosed " + modal.type + "Closed", modal);
      };

      _proto.open = function open(animateModal) {
        var modal = this;
        var document = getDocument();
        var app = modal.app;
        var $el = modal.$el;
        var $backdropEl = modal.$backdropEl;
        var type = modal.type;
        var animate = true;
        if (typeof animateModal !== 'undefined') animate = animateModal;else if (typeof modal.params.animate !== 'undefined') {
          animate = modal.params.animate;
        }

        if (!$el || $el.hasClass('modal-in')) {
          if (animateModal === false && $el[0] && type !== 'dialog') {
            $el[0].style.display = 'block';
          }

          return modal;
        }

        if (type === 'dialog' && app.params.modal.queueDialogs) {
          var pushToQueue;

          if ($('.dialog.modal-in').length > 0) {
            pushToQueue = true;
          } else if (openedModals.length > 0) {
            openedModals.forEach(function (openedModal) {
              if (openedModal.type === 'dialog') pushToQueue = true;
            });
          }

          if (pushToQueue) {
            dialogsQueue.push(modal);
            return modal;
          }
        }

        var $modalParentEl = $el.parent();
        var wasInDom = $el.parents(document).length > 0;

        if (!$modalParentEl.is(modal.$containerEl)) {
          modal.$containerEl.append($el);
          modal.once(type + "Closed", function () {
            if (wasInDom) {
              $modalParentEl.append($el);
            } else {
              $el.remove();
            }
          });
        } // Show Modal


        $el.show();
        /* eslint no-underscore-dangle: ["error", { "allow": ["_clientLeft"] }] */

        modal._clientLeft = $el[0].clientLeft; // Modal

        function transitionEnd() {
          if ($el.hasClass('modal-out')) {
            modal.onClosed();
          } else if ($el.hasClass('modal-in')) {
            modal.onOpened();
          }
        }

        if (animate) {
          if ($backdropEl) {
            $backdropEl.removeClass('not-animated');
            $backdropEl.addClass('backdrop-in');
          }

          $el.animationEnd(function () {
            transitionEnd();
          });
          $el.transitionEnd(function () {
            transitionEnd();
          });
          $el.removeClass('modal-out not-animated').addClass('modal-in');
          modal.onOpen();
        } else {
          if ($backdropEl) {
            $backdropEl.addClass('backdrop-in not-animated');
          }

          $el.removeClass('modal-out').addClass('modal-in not-animated');
          modal.onOpen();
          modal.onOpened();
        }

        return modal;
      };

      _proto.close = function close(animateModal) {
        var modal = this;
        var $el = modal.$el;
        var $backdropEl = modal.$backdropEl;
        var animate = true;
        if (typeof animateModal !== 'undefined') animate = animateModal;else if (typeof modal.params.animate !== 'undefined') {
          animate = modal.params.animate;
        }

        if (!$el || !$el.hasClass('modal-in')) {
          if (dialogsQueue.indexOf(modal) >= 0) {
            dialogsQueue.splice(dialogsQueue.indexOf(modal), 1);
          }

          return modal;
        } // backdrop


        if ($backdropEl) {
          var needToHideBackdrop = true;

          if (modal.type === 'popup') {
            modal.$el.prevAll('.popup.modal-in').add(modal.$el.nextAll('.popup.modal-in')).each(function (popupEl) {
              var popupInstance = popupEl.f7Modal;
              if (!popupInstance) return;

              if (popupInstance.params.closeByBackdropClick && popupInstance.params.backdrop && popupInstance.backdropEl === modal.backdropEl) {
                needToHideBackdrop = false;
              }
            });
          }

          if (needToHideBackdrop) {
            $backdropEl[animate ? 'removeClass' : 'addClass']('not-animated');
            $backdropEl.removeClass('backdrop-in');
          }
        } // Modal


        $el[animate ? 'removeClass' : 'addClass']('not-animated');

        function transitionEnd() {
          if ($el.hasClass('modal-out')) {
            modal.onClosed();
          } else if ($el.hasClass('modal-in')) {
            modal.onOpened();
          }
        }

        if (animate) {
          $el.animationEnd(function () {
            transitionEnd();
          });
          $el.transitionEnd(function () {
            transitionEnd();
          });
          $el.removeClass('modal-in').addClass('modal-out'); // Emit close

          modal.onClose();
        } else {
          $el.addClass('not-animated').removeClass('modal-in').addClass('modal-out'); // Emit close

          modal.onClose();
          modal.onClosed();
        }

        if (modal.type === 'dialog') {
          clearDialogsQueue();
        }

        return modal;
      };

      _proto.destroy = function destroy() {
        var modal = this;
        if (modal.destroyed) return;
        modal.emit("local::beforeDestroy modalBeforeDestroy " + modal.type + "BeforeDestroy", modal);

        if (modal.$el) {
          modal.$el.trigger("modal:beforedestroy " + modal.type.toLowerCase() + ":beforedestroy");

          if (modal.$el.length && modal.$el[0].f7Modal) {
            delete modal.$el[0].f7Modal;
          }
        }

        deleteProps$1(modal);
        modal.destroyed = true;
      };

      return Modal;
    }(Framework7Class);

    var CustomModal = /*#__PURE__*/function (_Modal) {
      _inheritsLoose(CustomModal, _Modal);

      function CustomModal(app, params) {
        var _this;

        var extendedParams = extend$1({
          backdrop: true,
          closeByBackdropClick: true,
          on: {}
        }, params); // Extends with open/close Modal methods;

        _this = _Modal.call(this, app, extendedParams) || this;

        var customModal = _assertThisInitialized(_this);

        customModal.params = extendedParams; // Find Element

        var $el;

        if (!customModal.params.el) {
          $el = $(customModal.params.content);
        } else {
          $el = $(customModal.params.el);
        }

        if ($el && $el.length > 0 && $el[0].f7Modal) {
          return $el[0].f7Modal || _assertThisInitialized(_this);
        }

        if ($el.length === 0) {
          return customModal.destroy() || _assertThisInitialized(_this);
        }

        var $backdropEl;

        if (customModal.params.backdrop) {
          $backdropEl = app.$el.children('.custom-modal-backdrop');

          if ($backdropEl.length === 0) {
            $backdropEl = $('<div class="custom-modal-backdrop"></div>');
            app.$el.append($backdropEl);
          }
        }

        function handleClick(e) {
          if (!customModal || customModal.destroyed) return;

          if ($backdropEl && e.target === $backdropEl[0]) {
            customModal.close();
          }
        }

        customModal.on('customModalOpened', function () {
          if (customModal.params.closeByBackdropClick && customModal.params.backdrop) {
            app.on('click', handleClick);
          }
        });
        customModal.on('customModalClose', function () {
          if (customModal.params.closeByBackdropClick && customModal.params.backdrop) {
            app.off('click', handleClick);
          }
        });
        extend$1(customModal, {
          app: app,
          $el: $el,
          el: $el[0],
          $backdropEl: $backdropEl,
          backdropEl: $backdropEl && $backdropEl[0],
          type: 'customModal'
        });
        $el[0].f7Modal = customModal;
        return customModal || _assertThisInitialized(_this);
      }

      return CustomModal;
    }(Modal$1);

    var Modal = {
      name: 'modal',
      static: {
        Modal: Modal$1,
        CustomModal: CustomModal
      },
      create: function create() {
        var app = this;
        app.customModal = {
          create: function create(params) {
            return new CustomModal(app, params);
          }
        };
      },
      params: {
        modal: {
          queueDialogs: true
        }
      }
    };

    var Appbar = {
      name: 'appbar'
    };

    /* eslint-disable prefer-rest-params */
    var $jsx = function $jsx(tag, props) {
      var attrs = props || {};

      for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        args[_key - 2] = arguments[_key];
      }

      var children = args || [];
      var attrsString = Object.keys(attrs).map(function (attr) {
        if (attr[0] === '_') {
          if (attrs[attr]) return attr.replace('_', '');
          return '';
        }

        return attr + "=\"" + attrs[attr] + "\"";
      }).filter(function (attr) {
        return !!attr;
      }).join(' ');

      if (['path', 'img', 'circle', 'polygon', 'line', 'input'].indexOf(tag) >= 0) {
        return ("<" + tag + " " + attrsString + " />").trim();
      }

      var childrenContent = children.filter(function (c) {
        return !!c;
      }).map(function (c) {
        return Array.isArray(c) ? c.join('') : c;
      }).join('');
      return ("<" + tag + " " + attrsString + ">" + childrenContent + "</" + tag + ">").trim();
    };

    var Dialog$1 = /*#__PURE__*/function (_Modal) {
      _inheritsLoose(Dialog, _Modal);

      function Dialog(app, params) {
        var _this;

        var extendedParams = extend$1({
          title: app.params.dialog.title,
          text: undefined,
          content: '',
          buttons: [],
          verticalButtons: false,
          onClick: undefined,
          cssClass: undefined,
          destroyOnClose: false,
          on: {}
        }, params);

        if (typeof extendedParams.closeByBackdropClick === 'undefined') {
          extendedParams.closeByBackdropClick = app.params.dialog.closeByBackdropClick;
        }

        if (typeof extendedParams.backdrop === 'undefined') {
          extendedParams.backdrop = app.params.dialog.backdrop;
        } // Extends with open/close Modal methods;


        _this = _Modal.call(this, app, extendedParams) || this;

        var dialog = _assertThisInitialized(_this);

        var device = getDevice$1();
        var document = getDocument();
        var title = extendedParams.title,
            text = extendedParams.text,
            content = extendedParams.content,
            buttons = extendedParams.buttons,
            verticalButtons = extendedParams.verticalButtons,
            cssClass = extendedParams.cssClass,
            backdrop = extendedParams.backdrop;
        dialog.params = extendedParams; // Find Element

        var $el;

        if (!dialog.params.el) {
          var dialogClasses = ['dialog'];
          if (buttons.length === 0) dialogClasses.push('dialog-no-buttons');
          if (buttons.length > 0) dialogClasses.push("dialog-buttons-" + buttons.length);
          if (verticalButtons) dialogClasses.push('dialog-buttons-vertical');
          if (cssClass) dialogClasses.push(cssClass);
          var buttonsHTML = '';

          if (buttons.length > 0) {
            buttonsHTML = $jsx("div", {
              class: "dialog-buttons"
            }, buttons.map(function (button) {
              return $jsx("span", {
                class: "dialog-button" + (button.bold ? ' dialog-button-bold' : '') + (button.color ? " color-" + button.color : '') + (button.cssClass ? " " + button.cssClass : '')
              }, button.text);
            }));
          }

          var dialogHtml = $jsx("div", {
            class: dialogClasses.join(' ')
          }, $jsx("div", {
            class: "dialog-inner"
          }, title && $jsx("div", {
            class: "dialog-title"
          }, title), text && $jsx("div", {
            class: "dialog-text"
          }, text), content), buttonsHTML);
          $el = $(dialogHtml);
        } else {
          $el = $(dialog.params.el);
        }

        if ($el && $el.length > 0 && $el[0].f7Modal) {
          return $el[0].f7Modal || _assertThisInitialized(_this);
        }

        if ($el.length === 0) {
          return dialog.destroy() || _assertThisInitialized(_this);
        }

        var $backdropEl;

        if (backdrop) {
          $backdropEl = app.$el.children('.dialog-backdrop');

          if ($backdropEl.length === 0) {
            $backdropEl = $('<div class="dialog-backdrop"></div>');
            app.$el.append($backdropEl);
          }
        } // Assign events


        function buttonOnClick(e) {
          var buttonEl = this;
          var index = $(buttonEl).index();
          var button = buttons[index];
          if (button.onClick) button.onClick(dialog, e);
          if (dialog.params.onClick) dialog.params.onClick(dialog, index);
          if (button.close !== false) dialog.close();
        }

        var addKeyboardHander;

        function onKeyDown(e) {
          var keyCode = e.keyCode;
          buttons.forEach(function (button, index) {
            if (button.keyCodes && button.keyCodes.indexOf(keyCode) >= 0) {
              if (document.activeElement) document.activeElement.blur();
              if (button.onClick) button.onClick(dialog, e);
              if (dialog.params.onClick) dialog.params.onClick(dialog, index);
              if (button.close !== false) dialog.close();
            }
          });
        }

        if (buttons && buttons.length > 0) {
          dialog.on('open', function () {
            $el.find('.dialog-button').each(function (buttonEl, index) {
              var button = buttons[index];
              if (button.keyCodes) addKeyboardHander = true;
              $(buttonEl).on('click', buttonOnClick);
            });

            if (addKeyboardHander && !device.ios && !device.android && !device.cordova && !device.capacitor) {
              $(document).on('keydown', onKeyDown);
            }
          });
          dialog.on('close', function () {
            $el.find('.dialog-button').each(function (buttonEl) {
              $(buttonEl).off('click', buttonOnClick);
            });

            if (addKeyboardHander && !device.ios && !device.android && !device.cordova && !device.capacitor) {
              $(document).off('keydown', onKeyDown);
            }

            addKeyboardHander = false;
          });
        }

        extend$1(dialog, {
          app: app,
          $el: $el,
          el: $el[0],
          $backdropEl: $backdropEl,
          backdropEl: $backdropEl && $backdropEl[0],
          type: 'dialog',
          setProgress: function setProgress(progress, duration) {
            app.progressbar.set($el.find('.progressbar'), progress, duration);
            return dialog;
          },
          setText: function setText(newText) {
            var $textEl = $el.find('.dialog-text');

            if ($textEl.length === 0) {
              $textEl = $('<div class="dialog-text"></div>');

              if (typeof title !== 'undefined') {
                $textEl.insertAfter($el.find('.dialog-title'));
              } else {
                $el.find('.dialog-inner').prepend($textEl);
              }
            }

            $textEl.html(newText);
            dialog.params.text = newText;
            return dialog;
          },
          setTitle: function setTitle(newTitle) {
            var $titleEl = $el.find('.dialog-title');

            if ($titleEl.length === 0) {
              $titleEl = $('<div class="dialog-title"></div>');
              $el.find('.dialog-inner').prepend($titleEl);
            }

            $titleEl.html(newTitle);
            dialog.params.title = newTitle;
            return dialog;
          }
        });

        function handleClick(e) {
          var target = e.target;
          var $target = $(target);

          if ($target.closest(dialog.el).length === 0) {
            if (dialog.params.closeByBackdropClick && dialog.backdropEl && dialog.backdropEl === target) {
              dialog.close();
            }
          }
        }

        dialog.on('opened', function () {
          if (dialog.params.closeByBackdropClick) {
            app.on('click', handleClick);
          }
        });
        dialog.on('close', function () {
          if (dialog.params.closeByBackdropClick) {
            app.off('click', handleClick);
          }
        });
        $el[0].f7Modal = dialog;

        if (dialog.params.destroyOnClose) {
          dialog.once('closed', function () {
            setTimeout(function () {
              dialog.destroy();
            }, 0);
          });
        }

        return dialog || _assertThisInitialized(_this);
      }

      return Dialog;
    }(Modal$1);

    var Dialog = {
      name: 'dialog',
      params: {
        dialog: {
          title: undefined,
          buttonOk: 'OK',
          buttonCancel: 'Cancel',
          usernamePlaceholder: 'Username',
          passwordPlaceholder: 'Password',
          preloaderTitle: 'Loading... ',
          progressTitle: 'Loading... ',
          backdrop: true,
          closeByBackdropClick: false,
          destroyPredefinedDialogs: true,
          keyboardActions: true,
          autoFocus: true
        }
      },
      static: {
        Dialog: Dialog$1
      },
      create: function create() {
        var app = this;

        function defaultDialogTitle() {
          return app.params.dialog.title || app.name;
        }

        var destroyOnClose = app.params.dialog.destroyPredefinedDialogs;
        var keyboardActions = app.params.dialog.keyboardActions;
        var autoFocus = app.params.dialog.autoFocus;
        var autoFocusHandler = autoFocus ? {
          on: {
            opened: function opened(dialog) {
              dialog.$el.find('input').eq(0).focus();
            }
          }
        } : {};
        app.dialog = extend$1(ModalMethods({
          app: app,
          constructor: Dialog$1,
          defaultSelector: '.dialog.modal-in'
        }), {
          // Shortcuts
          alert: function alert() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            var text = args[0],
                title = args[1],
                callbackOk = args[2];

            if (args.length === 2 && typeof args[1] === 'function') {
              text = args[0];
              callbackOk = args[1];
              title = args[2];
            }

            return new Dialog$1(app, {
              title: typeof title === 'undefined' ? defaultDialogTitle() : title,
              text: text,
              buttons: [{
                text: app.params.dialog.buttonOk,
                bold: true,
                onClick: callbackOk,
                keyCodes: keyboardActions ? [13, 27] : null
              }],
              destroyOnClose: destroyOnClose
            }).open();
          },
          prompt: function prompt() {
            for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
              args[_key2] = arguments[_key2];
            }

            var text = args[0],
                title = args[1],
                callbackOk = args[2],
                callbackCancel = args[3],
                defaultValue = args[4];

            if (typeof args[1] === 'function') {
              text = args[0];
              callbackOk = args[1];
              callbackCancel = args[2];
              defaultValue = args[3];
              title = args[4];
            }

            defaultValue = typeof defaultValue === 'undefined' || defaultValue === null ? '' : defaultValue;
            return new Dialog$1(app, _extends$j({
              title: typeof title === 'undefined' ? defaultDialogTitle() : title,
              text: text,
              content: "<div class=\"dialog-input-field input\"><input type=\"text\" class=\"dialog-input\" value=\"" + defaultValue + "\"></div>",
              buttons: [{
                text: app.params.dialog.buttonCancel,
                keyCodes: keyboardActions ? [27] : null,
                color: app.theme === 'aurora' ? 'gray' : null
              }, {
                text: app.params.dialog.buttonOk,
                bold: true,
                keyCodes: keyboardActions ? [13] : null
              }],
              onClick: function onClick(dialog, index) {
                var inputValue = dialog.$el.find('.dialog-input').val();
                if (index === 0 && callbackCancel) callbackCancel(inputValue);
                if (index === 1 && callbackOk) callbackOk(inputValue);
              },
              destroyOnClose: destroyOnClose
            }, autoFocusHandler)).open();
          },
          confirm: function confirm() {
            for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
              args[_key3] = arguments[_key3];
            }

            var text = args[0],
                title = args[1],
                callbackOk = args[2],
                callbackCancel = args[3];

            if (typeof args[1] === 'function') {
              text = args[0];
              callbackOk = args[1];
              callbackCancel = args[2];
              title = args[3];
            }

            return new Dialog$1(app, {
              title: typeof title === 'undefined' ? defaultDialogTitle() : title,
              text: text,
              buttons: [{
                text: app.params.dialog.buttonCancel,
                onClick: callbackCancel,
                keyCodes: keyboardActions ? [27] : null,
                color: app.theme === 'aurora' ? 'gray' : null
              }, {
                text: app.params.dialog.buttonOk,
                bold: true,
                onClick: callbackOk,
                keyCodes: keyboardActions ? [13] : null
              }],
              destroyOnClose: destroyOnClose
            }).open();
          },
          login: function login() {
            for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
              args[_key4] = arguments[_key4];
            }

            var text = args[0],
                title = args[1],
                callbackOk = args[2],
                callbackCancel = args[3];

            if (typeof args[1] === 'function') {
              text = args[0];
              callbackOk = args[1];
              callbackCancel = args[2];
              title = args[3];
            }

            return new Dialog$1(app, _extends$j({
              title: typeof title === 'undefined' ? defaultDialogTitle() : title,
              text: text,
              // prettier-ignore
              content: "\n              <div class=\"dialog-input-field dialog-input-double input\">\n                <input type=\"text\" name=\"dialog-username\" placeholder=\"" + app.params.dialog.usernamePlaceholder + "\" class=\"dialog-input\">\n              </div>\n              <div class=\"dialog-input-field dialog-input-double input\">\n                <input type=\"password\" name=\"dialog-password\" placeholder=\"" + app.params.dialog.passwordPlaceholder + "\" class=\"dialog-input\">\n              </div>",
              buttons: [{
                text: app.params.dialog.buttonCancel,
                keyCodes: keyboardActions ? [27] : null,
                color: app.theme === 'aurora' ? 'gray' : null
              }, {
                text: app.params.dialog.buttonOk,
                bold: true,
                keyCodes: keyboardActions ? [13] : null
              }],
              onClick: function onClick(dialog, index) {
                var username = dialog.$el.find('[name="dialog-username"]').val();
                var password = dialog.$el.find('[name="dialog-password"]').val();
                if (index === 0 && callbackCancel) callbackCancel(username, password);
                if (index === 1 && callbackOk) callbackOk(username, password);
              },
              destroyOnClose: destroyOnClose
            }, autoFocusHandler)).open();
          },
          password: function password() {
            for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
              args[_key5] = arguments[_key5];
            }

            var text = args[0],
                title = args[1],
                callbackOk = args[2],
                callbackCancel = args[3];

            if (typeof args[1] === 'function') {
              text = args[0];
              callbackOk = args[1];
              callbackCancel = args[2];
              title = args[3];
            }

            return new Dialog$1(app, _extends$j({
              title: typeof title === 'undefined' ? defaultDialogTitle() : title,
              text: text,
              // prettier-ignore
              content: "\n              <div class=\"dialog-input-field input\">\n                <input type=\"password\" name=\"dialog-password\" placeholder=\"" + app.params.dialog.passwordPlaceholder + "\" class=\"dialog-input\">\n              </div>",
              buttons: [{
                text: app.params.dialog.buttonCancel,
                keyCodes: keyboardActions ? [27] : null,
                color: app.theme === 'aurora' ? 'gray' : null
              }, {
                text: app.params.dialog.buttonOk,
                bold: true,
                keyCodes: keyboardActions ? [13] : null
              }],
              onClick: function onClick(dialog, index) {
                var password = dialog.$el.find('[name="dialog-password"]').val();
                if (index === 0 && callbackCancel) callbackCancel(password);
                if (index === 1 && callbackOk) callbackOk(password);
              },
              destroyOnClose: destroyOnClose
            }, autoFocusHandler)).open();
          },
          preloader: function preloader(title, color) {
            var preloaders = {
              iosPreloaderContent: iosPreloaderContent,
              mdPreloaderContent: mdPreloaderContent,
              auroraPreloaderContent: auroraPreloaderContent
            };
            var preloaderInner = preloaders[app.theme + "PreloaderContent"] || '';
            return new Dialog$1(app, {
              title: typeof title === 'undefined' || title === null ? app.params.dialog.preloaderTitle : title,
              // prettier-ignore
              content: "<div class=\"preloader" + (color ? " color-" + color : '') + "\">" + preloaderInner + "</div>",
              cssClass: 'dialog-preloader',
              destroyOnClose: destroyOnClose
            }).open();
          },
          progress: function progress() {
            for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
              args[_key6] = arguments[_key6];
            }

            var title = args[0],
                progress = args[1],
                color = args[2];

            if (args.length === 2) {
              if (typeof args[0] === 'number') {
                progress = args[0];
                color = args[1];
                title = args[2];
              } else if (typeof args[0] === 'string' && typeof args[1] === 'string') {
                title = args[0];
                color = args[1];
                progress = args[2];
              }
            } else if (args.length === 1) {
              if (typeof args[0] === 'number') {
                progress = args[0];
                title = args[1];
                color = args[2];
              }
            }

            var infinite = typeof progress === 'undefined';
            var dialog = new Dialog$1(app, {
              title: typeof title === 'undefined' ? app.params.dialog.progressTitle : title,
              cssClass: 'dialog-progress',
              // prettier-ignore
              content: "\n              <div class=\"progressbar" + (infinite ? '-infinite' : '') + (color ? " color-" + color : '') + "\">\n                " + (!infinite ? '<span></span>' : '') + "\n              </div>\n            ",
              destroyOnClose: destroyOnClose
            });
            if (!infinite) dialog.setProgress(progress);
            return dialog.open();
          }
        });
      }
    };

    var Popup$1 = /*#__PURE__*/function (_Modal) {
      _inheritsLoose(Popup, _Modal);

      function Popup(app, params) {
        var _this;

        var extendedParams = extend$1({
          on: {}
        }, app.params.popup, params); // Extends with open/close Modal methods;

        _this = _Modal.call(this, app, extendedParams) || this;

        var popup = _assertThisInitialized(_this);

        var window = getWindow();
        var document = getDocument();
        var support = getSupport$1();
        var device = getDevice$1();
        popup.params = extendedParams; // Find Element

        var $el;

        if (!popup.params.el) {
          $el = $(popup.params.content).filter(function (node) {
            return node.nodeType === 1;
          }).eq(0);
        } else {
          $el = $(popup.params.el).eq(0);
        }

        if ($el && $el.length > 0 && $el[0].f7Modal) {
          return $el[0].f7Modal || _assertThisInitialized(_this);
        }

        if ($el.length === 0) {
          return popup.destroy() || _assertThisInitialized(_this);
        }

        var $backdropEl;

        if (popup.params.backdrop && popup.params.backdropEl) {
          $backdropEl = $(popup.params.backdropEl);
        } else if (popup.params.backdrop) {
          $backdropEl = popup.$containerEl.children('.popup-backdrop');

          if ($backdropEl.length === 0) {
            $backdropEl = $('<div class="popup-backdrop"></div>');
            popup.$containerEl.append($backdropEl);
          }
        }

        extend$1(popup, {
          app: app,
          push: $el.hasClass('popup-push') || popup.params.push,
          $el: $el,
          el: $el[0],
          $backdropEl: $backdropEl,
          backdropEl: $backdropEl && $backdropEl[0],
          type: 'popup',
          $htmlEl: $('html')
        });

        if (popup.params.push) {
          $el.addClass('popup-push');
        }

        function handleClick(e) {
          var target = e.target;
          var $target = $(target);
          var keyboardOpened = !device.desktop && device.cordova && (window.Keyboard && window.Keyboard.isVisible || window.cordova.plugins && window.cordova.plugins.Keyboard && window.cordova.plugins.Keyboard.isVisible);
          if (keyboardOpened) return;

          if ($target.closest(popup.el).length === 0) {
            if (popup.params && popup.params.closeByBackdropClick && popup.params.backdrop && popup.backdropEl && popup.backdropEl === target) {
              var needToClose = true;
              popup.$el.nextAll('.popup.modal-in').each(function (popupEl) {
                var popupInstance = popupEl.f7Modal;
                if (!popupInstance) return;

                if (popupInstance.params.closeByBackdropClick && popupInstance.params.backdrop && popupInstance.backdropEl === popup.backdropEl) {
                  needToClose = false;
                }
              });

              if (needToClose) {
                popup.close();
              }
            }
          }
        }

        function onKeyDown(e) {
          var keyCode = e.keyCode;

          if (keyCode === 27 && popup.params.closeOnEscape) {
            popup.close();
          }
        }

        var pushOffset;
        var isPush;

        function pushViewScale(offset) {
          return (app.height - offset * 2) / app.height;
        }

        var allowSwipeToClose = true;
        var isTouched = false;
        var startTouch;
        var currentTouch;
        var isScrolling;
        var touchStartTime;
        var touchesDiff;
        var isMoved = false;
        var pageContentEl;
        var pageContentScrollTop;
        var pageContentOffsetHeight;
        var pageContentScrollHeight;
        var popupHeight;
        var $pushEl;

        function handleTouchStart(e) {
          if (isTouched || !allowSwipeToClose || !popup.params.swipeToClose) return;

          if (popup.params.swipeHandler && $(e.target).closest(popup.params.swipeHandler).length === 0) {
            return;
          }

          isTouched = true;
          isMoved = false;
          startTouch = {
            x: e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX,
            y: e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY
          };
          touchStartTime = now$1();
          isScrolling = undefined;

          if (!popup.params.swipeHandler && e.type === 'touchstart') {
            pageContentEl = $(e.target).closest('.page-content')[0];
          }
        }

        function handleTouchMove(e) {
          if (!isTouched) return;
          currentTouch = {
            x: e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX,
            y: e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY
          };

          if (typeof isScrolling === 'undefined') {
            isScrolling = !!(isScrolling || Math.abs(currentTouch.x - startTouch.x) > Math.abs(currentTouch.y - startTouch.y));
          }

          if (isScrolling) {
            isTouched = false;
            isMoved = false;
            return;
          }

          touchesDiff = startTouch.y - currentTouch.y;

          if (isPush && pushOffset && touchesDiff > 0) {
            touchesDiff = 0;
          }

          var direction = touchesDiff < 0 ? 'to-bottom' : 'to-top';
          $el.transition(0);

          if (typeof popup.params.swipeToClose === 'string' && direction !== popup.params.swipeToClose) {
            $el.transform('');
            $el.transition('');
            return;
          }

          if (!isMoved) {
            if (isPush && pushOffset) {
              popupHeight = $el[0].offsetHeight;
              $pushEl = $el.prevAll('.popup.modal-in').eq(0);

              if ($pushEl.length === 0) {
                $pushEl = app.$el.children('.view, .views');
              }
            }

            if (pageContentEl) {
              pageContentScrollTop = pageContentEl.scrollTop;
              pageContentScrollHeight = pageContentEl.scrollHeight;
              pageContentOffsetHeight = pageContentEl.offsetHeight;

              if (!(pageContentScrollHeight === pageContentOffsetHeight) && !(direction === 'to-bottom' && pageContentScrollTop === 0) && !(direction === 'to-top' && pageContentScrollTop === pageContentScrollHeight - pageContentOffsetHeight)) {
                $el.transform('');
                $el.transition('');
                isTouched = false;
                isMoved = false;
                return;
              }
            }

            isMoved = true;
            popup.emit('local::swipeStart popupSwipeStart', popup);
            popup.$el.trigger('popup:swipestart');
          } else {
            popup.emit('local::swipeMove popupSwipeMove', popup);
            popup.$el.trigger('popup:swipemove');
          }

          e.preventDefault();

          if (isPush && pushOffset) {
            var pushProgress = 1 - Math.abs(touchesDiff / popupHeight);
            var scale = 1 - (1 - pushViewScale(pushOffset)) * pushProgress;

            if ($pushEl.hasClass('popup')) {
              if ($pushEl.hasClass('popup-push')) {
                $pushEl.transition(0).forEach(function (el) {
                  el.style.setProperty('transform', "translate3d(0, calc(-1 * " + pushProgress + " * (var(--f7-popup-push-offset) + 10px)) , 0px) scale(" + scale + ")", 'important');
                });
              } else {
                $pushEl.transition(0).forEach(function (el) {
                  el.style.setProperty('transform', "translate3d(0, 0px , 0px) scale(" + scale + ")", 'important');
                });
              }
            } else {
              $pushEl.transition(0).forEach(function (el) {
                el.style.setProperty('transform', "translate3d(0,0,0) scale(" + scale + ")", 'important');
              });
            }
          }

          $el.transition(0).transform("translate3d(0," + -touchesDiff + "px,0)");
        }

        function handleTouchEnd() {
          isTouched = false;

          if (!isMoved) {
            return;
          }

          popup.emit('local::swipeEnd popupSwipeEnd', popup);
          popup.$el.trigger('popup:swipeend');
          isMoved = false;
          allowSwipeToClose = false;
          $el.transition('');

          if (isPush && pushOffset) {
            $pushEl.transition('').transform('');
          }

          var direction = touchesDiff <= 0 ? 'to-bottom' : 'to-top';

          if (typeof popup.params.swipeToClose === 'string' && direction !== popup.params.swipeToClose) {
            $el.transform('');
            allowSwipeToClose = true;
            return;
          }

          var diff = Math.abs(touchesDiff);
          var timeDiff = new Date().getTime() - touchStartTime;

          if (timeDiff < 300 && diff > 20 || timeDiff >= 300 && diff > 100) {
            nextTick$1(function () {
              if (direction === 'to-bottom') {
                $el.addClass('swipe-close-to-bottom');
              } else {
                $el.addClass('swipe-close-to-top');
              }

              $el.transform('');
              popup.emit('local::swipeclose popupSwipeClose', popup);
              popup.$el.trigger('popup:swipeclose');
              popup.close();
              allowSwipeToClose = true;
            });
            return;
          }

          allowSwipeToClose = true;
          $el.transform('');
        }

        var passive = support.passiveListener ? {
          passive: true
        } : false;

        if (popup.params.swipeToClose) {
          $el.on(app.touchEvents.start, handleTouchStart, passive);
          app.on('touchmove', handleTouchMove);
          app.on('touchend:passive', handleTouchEnd);
          popup.once('popupDestroy', function () {
            $el.off(app.touchEvents.start, handleTouchStart, passive);
            app.off('touchmove', handleTouchMove);
            app.off('touchend:passive', handleTouchEnd);
          });
        }

        var hasPreviousPushPopup;

        var updatePushOffset = function updatePushOffset() {
          var wasPush = isPush;

          if (popup.push) {
            isPush = popup.push && (app.width < 630 || app.height < 630 || $el.hasClass('popup-tablet-fullscreen'));
          }

          if (isPush && !wasPush) {
            // eslint-disable-next-line
            setPushOffset();
          } else if (isPush && wasPush) {
            popup.$htmlEl[0].style.setProperty('--f7-popup-push-scale', pushViewScale(pushOffset));
          } else if (!isPush && wasPush) {
            popup.$htmlEl.removeClass('with-modal-popup-push');
            popup.$htmlEl[0].style.removeProperty('--f7-popup-push-scale');
          }
        };

        var setPushOffset = function setPushOffset() {
          app.off('resize', updatePushOffset);

          if (popup.push) {
            isPush = popup.push && (app.width < 630 || app.height < 630 || $el.hasClass('popup-tablet-fullscreen'));
          }

          if (isPush) {
            pushOffset = parseInt($el.css('--f7-popup-push-offset'), 10);
            if (Number.isNaN(pushOffset)) pushOffset = 0;

            if (pushOffset) {
              $el.addClass('popup-push');
              popup.$htmlEl.addClass('with-modal-popup-push');
              popup.$htmlEl[0].style.setProperty('--f7-popup-push-scale', pushViewScale(pushOffset));
            }
          }

          app.on('resize', updatePushOffset);
        };

        popup.on('open', function () {
          hasPreviousPushPopup = false;

          if (popup.params.closeOnEscape) {
            $(document).on('keydown', onKeyDown);
          }

          $el.prevAll('.popup.modal-in').addClass('popup-behind');
          setPushOffset();
        });
        popup.on('opened', function () {
          $el.removeClass('swipe-close-to-bottom swipe-close-to-top');

          if (popup.params.closeByBackdropClick) {
            app.on('click', handleClick);
          }
        });
        popup.on('close', function () {
          hasPreviousPushPopup = popup.$el.prevAll('.popup-push.modal-in').length > 0;

          if (popup.params.closeOnEscape) {
            $(document).off('keydown', onKeyDown);
          }

          if (popup.params.closeByBackdropClick) {
            app.off('click', handleClick);
          }

          $el.prevAll('.popup.modal-in').eq(0).removeClass('popup-behind');

          if (isPush && pushOffset && !hasPreviousPushPopup) {
            popup.$htmlEl.removeClass('with-modal-popup-push');
            popup.$htmlEl.addClass('with-modal-popup-push-closing');
          }

          app.off('resize', updatePushOffset);
        });
        popup.on('closed', function () {
          $el.removeClass('popup-behind');

          if (isPush && pushOffset && !hasPreviousPushPopup) {
            popup.$htmlEl.removeClass('with-modal-popup-push-closing');
            popup.$htmlEl[0].style.removeProperty('--f7-popup-push-scale');
          }
        });
        $el[0].f7Modal = popup;
        return popup || _assertThisInitialized(_this);
      }

      return Popup;
    }(Modal$1);

    var Popup = {
      name: 'popup',
      params: {
        popup: {
          backdrop: true,
          backdropEl: undefined,
          closeByBackdropClick: true,
          closeOnEscape: false,
          swipeToClose: false,
          swipeHandler: null,
          push: false,
          containerEl: null
        }
      },
      static: {
        Popup: Popup$1
      },
      create: function create() {
        var app = this;
        app.popup = ModalMethods({
          app: app,
          constructor: Popup$1,
          defaultSelector: '.popup.modal-in',
          parentSelector: '.popup'
        });
      },
      clicks: {
        '.popup-open': function openPopup($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.popup.open(data.popup, data.animate, $clickedEl);
        },
        '.popup-close': function closePopup($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.popup.close(data.popup, data.animate, $clickedEl);
        }
      }
    };

    var LoginScreen$1 = /*#__PURE__*/function (_Modal) {
      _inheritsLoose(LoginScreen, _Modal);

      function LoginScreen(app, params) {
        var _this;

        var extendedParams = extend$1({
          on: {}
        }, params); // Extends with open/close Modal methods;

        _this = _Modal.call(this, app, extendedParams) || this;

        var loginScreen = _assertThisInitialized(_this);

        loginScreen.params = extendedParams; // Find Element

        var $el;

        if (!loginScreen.params.el) {
          $el = $(loginScreen.params.content).filter(function (node) {
            return node.nodeType === 1;
          }).eq(0);
        } else {
          $el = $(loginScreen.params.el).eq(0);
        }

        if ($el && $el.length > 0 && $el[0].f7Modal) {
          return $el[0].f7Modal || _assertThisInitialized(_this);
        }

        if ($el.length === 0) {
          return loginScreen.destroy() || _assertThisInitialized(_this);
        }

        extend$1(loginScreen, {
          app: app,
          $el: $el,
          el: $el[0],
          type: 'loginScreen'
        });
        $el[0].f7Modal = loginScreen;
        return loginScreen || _assertThisInitialized(_this);
      }

      return LoginScreen;
    }(Modal$1);

    var LoginScreen = {
      name: 'loginScreen',
      static: {
        LoginScreen: LoginScreen$1
      },
      create: function create() {
        var app = this;
        app.loginScreen = ModalMethods({
          app: app,
          constructor: LoginScreen$1,
          defaultSelector: '.login-screen.modal-in'
        });
      },
      clicks: {
        '.login-screen-open': function openLoginScreen($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.loginScreen.open(data.loginScreen, data.animate, $clickedEl);
        },
        '.login-screen-close': function closeLoginScreen($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.loginScreen.close(data.loginScreen, data.animate, $clickedEl);
        }
      }
    };

    var Popover$1 = /*#__PURE__*/function (_Modal) {
      _inheritsLoose(Popover, _Modal);

      function Popover(app, params) {
        var _this;

        var extendedParams = extend$1({
          on: {}
        }, app.params.popover, params); // Extends with open/close Modal methods;

        _this = _Modal.call(this, app, extendedParams) || this;

        var popover = _assertThisInitialized(_this);

        var device = getDevice$1();
        var window = getWindow();
        var document = getDocument();
        popover.params = extendedParams; // Find Element

        var $el;

        if (!popover.params.el) {
          $el = $(popover.params.content).filter(function (node) {
            return node.nodeType === 1;
          }).eq(0);
        } else {
          $el = $(popover.params.el).eq(0);
        }

        if ($el && $el.length > 0 && $el[0].f7Modal) {
          return $el[0].f7Modal || _assertThisInitialized(_this);
        } // Find Target


        var $targetEl = $(popover.params.targetEl).eq(0);

        if ($el.length === 0) {
          return popover.destroy() || _assertThisInitialized(_this);
        } // Backdrop


        var $backdropEl;

        if (popover.params.backdrop && popover.params.backdropEl) {
          $backdropEl = $(popover.params.backdropEl);
        } else if (popover.params.backdrop) {
          $backdropEl = popover.$containerEl.children('.popover-backdrop');

          if ($backdropEl.length === 0) {
            $backdropEl = $('<div class="popover-backdrop"></div>');
            popover.$containerEl.append($backdropEl);
          }
        } // Find Angle


        var $angleEl;

        if ($el.find('.popover-angle').length === 0) {
          $angleEl = $('<div class="popover-angle"></div>');
          $el.prepend($angleEl);
        } else {
          $angleEl = $el.find('.popover-angle');
        } // Open


        var originalOpen = popover.open;
        extend$1(popover, {
          app: app,
          $el: $el,
          el: $el[0],
          $targetEl: $targetEl,
          targetEl: $targetEl[0],
          $angleEl: $angleEl,
          angleEl: $angleEl[0],
          $backdropEl: $backdropEl,
          backdropEl: $backdropEl && $backdropEl[0],
          type: 'popover',
          open: function open() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            var targetEl = args[0],
                animate = args[1];

            if (typeof args[0] === 'boolean') {
              animate = args[0];
              targetEl = args[1];
            }

            if (targetEl) {
              popover.$targetEl = $(targetEl);
              popover.targetEl = popover.$targetEl[0];
            }

            return originalOpen.call(popover, animate);
          }
        });

        function handleResize() {
          popover.resize();
        }

        popover.on('popoverOpen', function () {
          popover.resize();
          app.on('resize', handleResize);
          $(window).on('keyboardDidShow keyboardDidHide', handleResize);
          popover.on('popoverClose popoverBeforeDestroy', function () {
            app.off('resize', handleResize);
            $(window).off('keyboardDidShow keyboardDidHide', handleResize);
          });
        });
        var touchStartTarget = null;

        function handleTouchStart(e) {
          touchStartTarget = e.target;
        }

        function handleClick(e) {
          var target = e.target;
          var $target = $(target);
          var keyboardOpened = !device.desktop && device.cordova && (window.Keyboard && window.Keyboard.isVisible || window.cordova.plugins && window.cordova.plugins.Keyboard && window.cordova.plugins.Keyboard.isVisible);
          if (keyboardOpened) return;

          if ($target.closest(popover.el).length === 0) {
            if (popover.params.closeByBackdropClick && popover.params.backdrop && popover.backdropEl && popover.backdropEl === target && touchStartTarget === target) {
              popover.close();
            } else if (popover.params.closeByOutsideClick && touchStartTarget === target) {
              popover.close();
            }
          }
        }

        function onKeyDown(e) {
          var keyCode = e.keyCode;

          if (keyCode === 27 && popover.params.closeOnEscape) {
            popover.close();
          }
        }

        if (popover.params.closeOnEscape) {
          popover.on('popoverOpen', function () {
            $(document).on('keydown', onKeyDown);
          });
          popover.on('popoverClose', function () {
            $(document).off('keydown', onKeyDown);
          });
        }

        popover.on('popoverOpened', function () {
          if (popover.params.closeByOutsideClick || popover.params.closeByBackdropClick) {
            app.on('touchstart', handleTouchStart);
            app.on('click', handleClick);
          }
        });
        popover.on('popoverClose', function () {
          if (popover.params.closeByOutsideClick || popover.params.closeByBackdropClick) {
            app.off('touchstart', handleTouchStart);
            app.off('click', handleClick);
          }
        });
        $el[0].f7Modal = popover;
        return popover || _assertThisInitialized(_this);
      }

      var _proto = Popover.prototype;

      _proto.resize = function resize() {
        var popover = this;
        var app = popover.app,
            $el = popover.$el,
            $targetEl = popover.$targetEl,
            $angleEl = popover.$angleEl;
        var _popover$params = popover.params,
            targetX = _popover$params.targetX,
            targetY = _popover$params.targetY;
        $el.css({
          left: '',
          top: ''
        });
        var _ref = [$el.width(), $el.height()],
            width = _ref[0],
            height = _ref[1];
        var angleSize = 0;
        var angleLeft;
        var angleTop;

        if (app.theme === 'ios' || app.theme === 'aurora') {
          $angleEl.removeClass('on-left on-right on-top on-bottom').css({
            left: '',
            top: ''
          });
          angleSize = $angleEl.width() / 2;
        } else {
          $el.removeClass('popover-on-left popover-on-right popover-on-top popover-on-bottom popover-on-middle').css({
            left: '',
            top: ''
          });
        }

        var targetWidth;
        var targetHeight;
        var targetOffsetLeft;
        var targetOffsetTop;
        var safeAreaTop = parseInt($('html').css('--f7-safe-area-top'), 10);
        var safeAreaLeft = parseInt($('html').css('--f7-safe-area-left'), 10);
        var safeAreaRight = parseInt($('html').css('--f7-safe-area-right'), 10);
        if (Number.isNaN(safeAreaTop)) safeAreaTop = 0;
        if (Number.isNaN(safeAreaLeft)) safeAreaLeft = 0;
        if (Number.isNaN(safeAreaRight)) safeAreaRight = 0;

        if ($targetEl && $targetEl.length > 0) {
          targetWidth = $targetEl.outerWidth();
          targetHeight = $targetEl.outerHeight();
          var targetOffset = $targetEl.offset();
          targetOffsetLeft = targetOffset.left - app.left;
          targetOffsetTop = targetOffset.top - app.top;
          var targetParentPage = $targetEl.parents('.page');

          if (targetParentPage.length > 0) {
            targetOffsetTop -= targetParentPage[0].scrollTop;
          }
        } else if (typeof targetX !== 'undefined' && targetY !== 'undefined') {
          targetOffsetLeft = targetX;
          targetOffsetTop = targetY;
          targetWidth = popover.params.targetWidth || 0;
          targetHeight = popover.params.targetHeight || 0;
        }

        var left = 0,
            top = 0,
            diff = 0; // Top Position

        var position = app.theme === 'md' ? 'bottom' : 'top';

        if (app.theme === 'md') {
          if (height < app.height - targetOffsetTop - targetHeight) {
            // On bottom
            position = 'bottom';
            top = targetOffsetTop + targetHeight;
          } else if (height < targetOffsetTop - safeAreaTop) {
            // On top
            top = targetOffsetTop - height;
            position = 'top';
          } else {
            // On middle
            position = 'middle';
            top = targetHeight / 2 + targetOffsetTop - height / 2;
          }

          top = Math.max(8, Math.min(top, app.height - height - 8)); // Horizontal Position

          var hPosition;

          if (targetOffsetLeft < app.width / 2) {
            hPosition = 'right';
            left = position === 'middle' ? targetOffsetLeft + targetWidth : targetOffsetLeft;
          } else {
            hPosition = 'left';
            left = position === 'middle' ? targetOffsetLeft - width : targetOffsetLeft + targetWidth - width;
          }

          left = Math.max(8, Math.min(left, app.width - width - 8 - safeAreaRight), safeAreaLeft);
          $el.addClass("popover-on-" + position + " popover-on-" + hPosition);
        } else {
          // ios and aurora
          if (height + angleSize < targetOffsetTop - safeAreaTop) {
            // On top
            top = targetOffsetTop - height - angleSize;
          } else if (height + angleSize < app.height - targetOffsetTop - targetHeight) {
            // On bottom
            position = 'bottom';
            top = targetOffsetTop + targetHeight + angleSize;
          } else {
            // On middle
            position = 'middle';
            top = targetHeight / 2 + targetOffsetTop - height / 2;
            diff = top;
            top = Math.max(5, Math.min(top, app.height - height - 5));
            diff -= top;
          } // Horizontal Position


          if (position === 'top' || position === 'bottom') {
            left = targetWidth / 2 + targetOffsetLeft - width / 2;
            diff = left;
            left = Math.max(5, Math.min(left, app.width - width - 5));

            if (safeAreaLeft) {
              left = Math.max(left, safeAreaLeft);
            }

            if (safeAreaRight && left + width > app.width - 5 - safeAreaRight) {
              left = app.width - 5 - safeAreaRight - width;
            }

            if (position === 'top') {
              $angleEl.addClass('on-bottom');
            }

            if (position === 'bottom') {
              $angleEl.addClass('on-top');
            }

            diff -= left;
            angleLeft = width / 2 - angleSize + diff;
            angleLeft = Math.max(Math.min(angleLeft, width - angleSize * 2 - 13), 13);
            $angleEl.css({
              left: angleLeft + "px"
            });
          } else if (position === 'middle') {
            left = targetOffsetLeft - width - angleSize;
            $angleEl.addClass('on-right');

            if (left < 5 || left + width + safeAreaRight > app.width || left < safeAreaLeft) {
              if (left < 5) left = targetOffsetLeft + targetWidth + angleSize;
              if (left + width + safeAreaRight > app.width) left = app.width - width - 5 - safeAreaRight;
              if (left < safeAreaLeft) left = safeAreaLeft;
              $angleEl.removeClass('on-right').addClass('on-left');
            }

            angleTop = height / 2 - angleSize + diff;
            angleTop = Math.max(Math.min(angleTop, height - angleSize * 2 - 13), 13);
            $angleEl.css({
              top: angleTop + "px"
            });
          }
        } // Apply Styles


        $el.css({
          top: top + "px",
          left: left + "px"
        });
      };

      return Popover;
    }(Modal$1);

    var Popover = {
      name: 'popover',
      params: {
        popover: {
          backdrop: true,
          backdropEl: undefined,
          closeByBackdropClick: true,
          closeByOutsideClick: true,
          closeOnEscape: false,
          containerEl: null
        }
      },
      static: {
        Popover: Popover$1
      },
      create: function create() {
        var app = this;
        app.popover = extend$1(ModalMethods({
          app: app,
          constructor: Popover$1,
          defaultSelector: '.popover.modal-in'
        }), {
          open: function open(popoverEl, targetEl, animate) {
            var $popoverEl = $(popoverEl);

            if ($popoverEl.length > 1) {
              // check if same popover in other page
              var $targetPage = $(targetEl).parents('.page');

              if ($targetPage.length) {
                $popoverEl.each(function (el) {
                  var $el = $(el);

                  if ($el.parents($targetPage)[0] === $targetPage[0]) {
                    $popoverEl = $el;
                  }
                });
              }
            }

            if ($popoverEl.length > 1) {
              $popoverEl = $popoverEl.eq($popoverEl.length - 1);
            }

            var popover = $popoverEl[0].f7Modal;
            var data = $popoverEl.dataset();

            if (!popover) {
              popover = new Popover$1(app, Object.assign({
                el: $popoverEl,
                targetEl: targetEl
              }, data));
            }

            return popover.open(targetEl, animate);
          }
        });
      },
      clicks: {
        '.popover-open': function openPopover($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.popover.open(data.popover, $clickedEl, data.animate);
        },
        '.popover-close': function closePopover($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.popover.close(data.popover, data.animate, $clickedEl);
        }
      }
    };

    var Actions$1 = /*#__PURE__*/function (_Modal) {
      _inheritsLoose(Actions, _Modal);

      function Actions(app, params) {
        var _this;

        var extendedParams = extend$1({
          on: {}
        }, app.params.actions, params); // Extends with open/close Modal methods;

        _this = _Modal.call(this, app, extendedParams) || this;

        var actions = _assertThisInitialized(_this);

        var device = getDevice$1();
        var window = getWindow();
        var document = getDocument();
        actions.params = extendedParams; // Buttons

        var groups;

        if (actions.params.buttons) {
          groups = actions.params.buttons;
          if (!Array.isArray(groups[0])) groups = [groups];
        }

        actions.groups = groups; // Find Element

        var $el;

        if (actions.params.el) {
          $el = $(actions.params.el).eq(0);
        } else if (actions.params.content) {
          $el = $(actions.params.content).filter(function (node) {
            return node.nodeType === 1;
          }).eq(0);
        } else if (actions.params.buttons) {
          if (actions.params.convertToPopover) {
            actions.popoverHtml = actions.renderPopover();
          }

          actions.actionsHtml = actions.render();
        }

        if ($el && $el.length > 0 && $el[0].f7Modal) {
          return $el[0].f7Modal || _assertThisInitialized(_this);
        }

        if ($el && $el.length === 0 && !(actions.actionsHtml || actions.popoverHtml)) {
          return actions.destroy() || _assertThisInitialized(_this);
        } // Backdrop


        var $backdropEl;

        if (actions.params.backdrop && actions.params.backdropEl) {
          $backdropEl = $(actions.params.backdropEl);
        } else if (actions.params.backdrop) {
          $backdropEl = actions.$containerEl.children('.actions-backdrop');

          if ($backdropEl.length === 0) {
            $backdropEl = $('<div class="actions-backdrop"></div>');
            actions.$containerEl.append($backdropEl);
          }
        }

        var originalOpen = actions.open;
        var originalClose = actions.close;
        var popover;

        function buttonOnClick(e) {
          var $buttonEl = $(this);
          var buttonIndex;
          var groupIndex;

          if ($buttonEl.hasClass('list-button') || $buttonEl.hasClass('item-link')) {
            buttonIndex = $buttonEl.parents('li').index();
            groupIndex = $buttonEl.parents('.list').index();
          } else {
            buttonIndex = $buttonEl.index();
            groupIndex = $buttonEl.parents('.actions-group').index();
          }

          if (typeof groups !== 'undefined') {
            var button = groups[groupIndex][buttonIndex];
            if (button.onClick) button.onClick(actions, e);
            if (actions.params.onClick) actions.params.onClick(actions, e);
            if (button.close !== false) actions.close();
          }
        }

        actions.open = function open(animate) {
          var convertToPopover = false;
          var _actions$params = actions.params,
              targetEl = _actions$params.targetEl,
              targetX = _actions$params.targetX,
              targetY = _actions$params.targetY,
              targetWidth = _actions$params.targetWidth,
              targetHeight = _actions$params.targetHeight;

          if (actions.params.convertToPopover && (targetEl || targetX !== undefined && targetY !== undefined)) {
            // Popover
            if (actions.params.forceToPopover || device.ios && device.ipad || app.width >= 768 || device.desktop && app.theme === 'aurora') {
              convertToPopover = true;
            }
          }

          if (convertToPopover && actions.popoverHtml) {
            popover = app.popover.create({
              containerEl: actions.params.containerEl,
              content: actions.popoverHtml,
              backdrop: actions.params.backdrop,
              targetEl: targetEl,
              targetX: targetX,
              targetY: targetY,
              targetWidth: targetWidth,
              targetHeight: targetHeight,
              on: {
                open: function open() {
                  if (!actions.$el) {
                    actions.$el = popover.$el;
                  }

                  actions.$el.trigger("modal:open " + actions.type.toLowerCase() + ":open");
                  actions.emit("local::open modalOpen " + actions.type + "Open", actions);
                },
                opened: function opened() {
                  if (!actions.$el) {
                    actions.$el = popover.$el;
                  }

                  actions.$el.trigger("modal:opened " + actions.type.toLowerCase() + ":opened");
                  actions.emit("local::opened modalOpened " + actions.type + "Opened", actions);
                },
                close: function close() {
                  if (!actions.$el) {
                    actions.$el = popover.$el;
                  }

                  actions.$el.trigger("modal:close " + actions.type.toLowerCase() + ":close");
                  actions.emit("local::close modalClose " + actions.type + "Close", actions);
                },
                closed: function closed() {
                  if (!actions.$el) {
                    actions.$el = popover.$el;
                  }

                  actions.$el.trigger("modal:closed " + actions.type.toLowerCase() + ":closed");
                  actions.emit("local::closed modalClosed " + actions.type + "Closed", actions);
                }
              }
            });
            popover.open(animate);
            popover.once('popoverOpened', function () {
              popover.$el.find('.list-button, .item-link').each(function (buttonEl) {
                $(buttonEl).on('click', buttonOnClick);
              });
            });
            popover.once('popoverClosed', function () {
              popover.$el.find('.list-button, .item-link').each(function (buttonEl) {
                $(buttonEl).off('click', buttonOnClick);
              });
              nextTick$1(function () {
                popover.destroy();
                popover = undefined;
              });
            });
          } else {
            actions.$el = actions.actionsHtml ? $(actions.actionsHtml) : actions.$el;
            actions.$el[0].f7Modal = actions;

            if (actions.groups) {
              actions.$el.find('.actions-button').each(function (buttonEl) {
                $(buttonEl).on('click', buttonOnClick);
              });
              actions.once('actionsClosed', function () {
                actions.$el.find('.actions-button').each(function (buttonEl) {
                  $(buttonEl).off('click', buttonOnClick);
                });
              });
            }

            actions.el = actions.$el[0];
            originalOpen.call(actions, animate);
          }

          return actions;
        };

        actions.close = function close(animate) {
          if (popover) {
            popover.close(animate);
          } else {
            originalClose.call(actions, animate);
          }

          return actions;
        };

        extend$1(actions, {
          app: app,
          $el: $el,
          el: $el ? $el[0] : undefined,
          $backdropEl: $backdropEl,
          backdropEl: $backdropEl && $backdropEl[0],
          type: 'actions'
        });

        function handleClick(e) {
          var target = e.target;
          var $target = $(target);
          var keyboardOpened = !device.desktop && device.cordova && (window.Keyboard && window.Keyboard.isVisible || window.cordova.plugins && window.cordova.plugins.Keyboard && window.cordova.plugins.Keyboard.isVisible);
          if (keyboardOpened) return;

          if ($target.closest(actions.el).length === 0) {
            if (actions.params.closeByBackdropClick && actions.params.backdrop && actions.backdropEl && actions.backdropEl === target) {
              actions.close();
            } else if (actions.params.closeByOutsideClick) {
              actions.close();
            }
          }
        }

        function onKeyDown(e) {
          var keyCode = e.keyCode;

          if (keyCode === 27 && actions.params.closeOnEscape) {
            actions.close();
          }
        }

        if (actions.params.closeOnEscape) {
          actions.on('open', function () {
            $(document).on('keydown', onKeyDown);
          });
          actions.on('close', function () {
            $(document).off('keydown', onKeyDown);
          });
        }

        actions.on('opened', function () {
          if (actions.params.closeByBackdropClick || actions.params.closeByOutsideClick) {
            app.on('click', handleClick);
          }
        });
        actions.on('close', function () {
          if (actions.params.closeByBackdropClick || actions.params.closeByOutsideClick) {
            app.off('click', handleClick);
          }
        });

        if ($el) {
          $el[0].f7Modal = actions;
        }

        return actions || _assertThisInitialized(_this);
      }

      var _proto = Actions.prototype;

      _proto.render = function render() {
        var actions = this;
        if (actions.params.render) return actions.params.render.call(actions, actions);
        var groups = actions.groups;
        var cssClass = actions.params.cssClass;
        return $jsx("div", {
          class: "actions-modal" + (actions.params.grid ? ' actions-grid' : '') + " " + (cssClass || '')
        }, groups.map(function (group) {
          return $jsx("div", {
            class: "actions-group"
          }, group.map(function (button) {
            var buttonClasses = ["actions-" + (button.label ? 'label' : 'button')];
            var color = button.color,
                bg = button.bg,
                bold = button.bold,
                disabled = button.disabled,
                label = button.label,
                text = button.text,
                icon = button.icon;
            if (color) buttonClasses.push("color-" + color);
            if (bg) buttonClasses.push("bg-color-" + bg);
            if (bold) buttonClasses.push('actions-button-bold');
            if (disabled) buttonClasses.push('disabled');

            if (label) {
              return $jsx("div", {
                class: buttonClasses.join(' ')
              }, text);
            }

            return $jsx("div", {
              class: buttonClasses.join(' ')
            }, icon && $jsx("div", {
              class: "actions-button-media"
            }, icon), $jsx("div", {
              class: "actions-button-text"
            }, text));
          }));
        }));
      };

      _proto.renderPopover = function renderPopover() {
        var actions = this;
        if (actions.params.renderPopover) return actions.params.renderPopover.call(actions, actions);
        var groups = actions.groups;
        var cssClass = actions.params.cssClass;
        return $jsx("div", {
          class: "popover popover-from-actions " + (cssClass || '')
        }, $jsx("div", {
          class: "popover-inner"
        }, groups.map(function (group) {
          return $jsx("div", {
            class: "list"
          }, $jsx("ul", null, group.map(function (button) {
            var itemClasses = [];
            var color = button.color,
                bg = button.bg,
                bold = button.bold,
                disabled = button.disabled,
                label = button.label,
                text = button.text,
                icon = button.icon;
            if (color) itemClasses.push("color-" + color);
            if (bg) itemClasses.push("bg-color-" + bg);
            if (bold) itemClasses.push('popover-from-actions-bold');
            if (disabled) itemClasses.push('disabled');

            if (label) {
              itemClasses.push('popover-from-actions-label');
              return "<li class=\"" + itemClasses.join(' ') + "\">" + text + "</li>";
            }

            if (icon) {
              itemClasses.push('item-link item-content');
              return $jsx("li", null, $jsx("a", {
                class: itemClasses.join(' ')
              }, $jsx("div", {
                class: "item-media"
              }, icon), $jsx("div", {
                class: "item-inner"
              }, $jsx("div", {
                class: "item-title"
              }, text))));
            }

            itemClasses.push('list-button');
            return $jsx("li", null, $jsx("a", {
              class: itemClasses.join(' ')
            }, text));
          })));
        })));
      };

      return Actions;
    }(Modal$1);

    var Actions = {
      name: 'actions',
      params: {
        actions: {
          convertToPopover: true,
          forceToPopover: false,
          backdrop: true,
          backdropEl: undefined,
          cssClass: null,
          closeByBackdropClick: true,
          closeOnEscape: false,
          render: null,
          renderPopover: null,
          containerEl: null
        }
      },
      static: {
        Actions: Actions$1
      },
      create: function create() {
        var app = this;
        app.actions = ModalMethods({
          app: app,
          constructor: Actions$1,
          defaultSelector: '.actions-modal.modal-in'
        });
      },
      clicks: {
        '.actions-open': function openActions($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.actions.open(data.actions, data.animate, $clickedEl);
        },
        '.actions-close': function closeActions($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.actions.close(data.actions, data.animate, $clickedEl);
        }
      }
    };

    var Sheet$1 = /*#__PURE__*/function (_Modal) {
      _inheritsLoose(Sheet, _Modal);

      function Sheet(app, params) {
        var _this;

        var extendedParams = extend$1({
          on: {}
        }, app.params.sheet, params); // Extends with open/close Modal methods;

        _this = _Modal.call(this, app, extendedParams) || this;

        var sheet = _assertThisInitialized(_this);

        var window = getWindow();
        var document = getDocument();
        var support = getSupport$1();
        var device = getDevice$1();
        sheet.params = extendedParams;

        if (typeof sheet.params.backdrop === 'undefined') {
          sheet.params.backdrop = app.theme !== 'ios';
        } // Find Element


        var $el;

        if (!sheet.params.el) {
          $el = $(sheet.params.content).filter(function (node) {
            return node.nodeType === 1;
          }).eq(0);
        } else {
          $el = $(sheet.params.el).eq(0);
        }

        if ($el && $el.length > 0 && $el[0].f7Modal) {
          return $el[0].f7Modal || _assertThisInitialized(_this);
        }

        if ($el.length === 0) {
          return sheet.destroy() || _assertThisInitialized(_this);
        }

        var $backdropEl;

        if (sheet.params.backdrop && sheet.params.backdropEl) {
          $backdropEl = $(sheet.params.backdropEl);
        } else if (sheet.params.backdrop) {
          $backdropEl = sheet.$containerEl.children('.sheet-backdrop');

          if ($backdropEl.length === 0) {
            $backdropEl = $('<div class="sheet-backdrop"></div>');
            sheet.$containerEl.append($backdropEl);
          }
        }

        extend$1(sheet, {
          app: app,
          push: $el.hasClass('sheet-modal-push') || sheet.params.push,
          $el: $el,
          el: $el[0],
          $backdropEl: $backdropEl,
          backdropEl: $backdropEl && $backdropEl[0],
          type: 'sheet',
          $htmlEl: $('html')
        });

        if (sheet.params.push) {
          $el.addClass('sheet-modal-push');
        }

        var $pageContentEl;

        function scrollToElementOnOpen() {
          var $scrollEl = $(sheet.params.scrollToEl).eq(0);
          if ($scrollEl.length === 0) return;
          $pageContentEl = $scrollEl.parents('.page-content');
          if ($pageContentEl.length === 0) return;
          var paddingTop = parseInt($pageContentEl.css('padding-top'), 10);
          var paddingBottom = parseInt($pageContentEl.css('padding-bottom'), 10);
          var pageHeight = $pageContentEl[0].offsetHeight - paddingTop - $el.height();
          var pageScrollHeight = $pageContentEl[0].scrollHeight - paddingTop - $el.height();
          var pageScroll = $pageContentEl.scrollTop();
          var newPaddingBottom;
          var scrollElTop = $scrollEl.offset().top - paddingTop + $scrollEl[0].offsetHeight;

          if (scrollElTop > pageHeight) {
            var scrollTop = pageScroll + scrollElTop - pageHeight;

            if (scrollTop + pageHeight > pageScrollHeight) {
              newPaddingBottom = scrollTop + pageHeight - pageScrollHeight + paddingBottom;

              if (pageHeight === pageScrollHeight) {
                newPaddingBottom = $el.height();
              }

              $pageContentEl.css({
                'padding-bottom': newPaddingBottom + "px"
              });
            }

            $pageContentEl.scrollTop(scrollTop, 300);
          }
        }

        function scrollToElementOnClose() {
          if ($pageContentEl && $pageContentEl.length > 0) {
            $pageContentEl.css({
              'padding-bottom': ''
            });
          }
        }

        function handleClick(e) {
          var target = e.target;
          var $target = $(target);
          var keyboardOpened = !device.desktop && device.cordova && (window.Keyboard && window.Keyboard.isVisible || window.cordova.plugins && window.cordova.plugins.Keyboard && window.cordova.plugins.Keyboard.isVisible);
          if (keyboardOpened) return;

          if ($target.closest(sheet.el).length === 0) {
            if (sheet.params.closeByBackdropClick && sheet.params.backdrop && sheet.backdropEl && sheet.backdropEl === target) {
              sheet.close();
            } else if (sheet.params.closeByOutsideClick) {
              sheet.close();
            }
          }
        }

        function onKeyDown(e) {
          var keyCode = e.keyCode;

          if (keyCode === 27 && sheet.params.closeOnEscape) {
            sheet.close();
          }
        }

        var pushOffset;

        function pushViewScale(offset) {
          return (app.height - offset * 2) / app.height;
        }

        var isTouched = false;
        var startTouch;
        var currentTouch;
        var isScrolling;
        var touchStartTime;
        var touchesDiff;
        var isMoved = false;
        var isTopSheetModal;
        var swipeStepTranslate;
        var startTranslate;
        var currentTranslate;
        var sheetElOffsetHeight;
        var minTranslate;
        var maxTranslate;
        var $pushViewEl;
        var pushBorderRadius;
        var sheetPageContentEl;
        var sheetPageContentScrollTop;
        var sheetPageContentScrollHeight;
        var sheetPageContentOffsetHeight;

        function handleTouchStart(e) {
          if (isTouched || !(sheet.params.swipeToClose || sheet.params.swipeToStep)) return;

          if (sheet.params.swipeHandler && $(e.target).closest(sheet.params.swipeHandler).length === 0) {
            return;
          }

          isTouched = true;
          isMoved = false;
          startTouch = {
            x: e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX,
            y: e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY
          };
          touchStartTime = now$1();
          isScrolling = undefined;
          isTopSheetModal = $el.hasClass('sheet-modal-top');

          if (!sheet.params.swipeHandler && e.type === 'touchstart') {
            sheetPageContentEl = $(e.target).closest('.page-content')[0];
          }
        }

        function handleTouchMove(e) {
          if (!isTouched) return;
          currentTouch = {
            x: e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX,
            y: e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY
          };

          if (typeof isScrolling === 'undefined') {
            isScrolling = !!(isScrolling || Math.abs(currentTouch.x - startTouch.x) > Math.abs(currentTouch.y - startTouch.y));
          }

          if (isScrolling) {
            isTouched = false;
            isMoved = false;
            return;
          }

          touchesDiff = startTouch.y - currentTouch.y;
          var direction = touchesDiff < 0 ? 'to-bottom' : 'to-top';

          if (!isMoved) {
            if (sheetPageContentEl && !$el.hasClass('modal-in-swipe-step')) {
              sheetPageContentScrollTop = sheetPageContentEl.scrollTop;
              sheetPageContentScrollHeight = sheetPageContentEl.scrollHeight;
              sheetPageContentOffsetHeight = sheetPageContentEl.offsetHeight;

              if (!(sheetPageContentScrollHeight === sheetPageContentOffsetHeight) && !(direction === 'to-bottom' && sheetPageContentScrollTop === 0) && !(direction === 'to-top' && sheetPageContentScrollTop === sheetPageContentScrollHeight - sheetPageContentOffsetHeight)) {
                $el.transform('');
                isTouched = false;
                isMoved = false;
                return;
              }
            }

            if (sheet.push && pushOffset) {
              $pushViewEl = app.$el.children('.view, .views');
            }

            sheetElOffsetHeight = $el[0].offsetHeight;
            startTranslate = getTranslate$1($el[0], 'y');

            if (isTopSheetModal) {
              minTranslate = sheet.params.swipeToClose ? -sheetElOffsetHeight : -swipeStepTranslate;
              maxTranslate = 0;
            } else {
              minTranslate = 0;
              maxTranslate = sheet.params.swipeToClose ? sheetElOffsetHeight : swipeStepTranslate;
            }

            isMoved = true;
          }

          currentTranslate = startTranslate - touchesDiff;
          currentTranslate = Math.min(Math.max(currentTranslate, minTranslate), maxTranslate);
          e.preventDefault();

          if (sheet.push && pushOffset) {
            var progress = (currentTranslate - startTranslate) / sheetElOffsetHeight;

            if (sheet.params.swipeToStep) {
              if (isTopSheetModal) {
                progress = currentTranslate / swipeStepTranslate;
              } else {
                progress = 1 - (swipeStepTranslate - currentTranslate) / swipeStepTranslate;
              }
            }

            progress = Math.abs(progress);
            progress = Math.min(Math.max(progress, 0), 1);
            var pushProgress = 1 - progress;
            var scale = 1 - (1 - pushViewScale(pushOffset)) * pushProgress;
            $pushViewEl.transition(0).forEach(function (el) {
              el.style.setProperty('transform', "translate3d(0,0,0) scale(" + scale + ")", 'important');
            });

            if (sheet.params.swipeToStep) {
              $pushViewEl.css('border-radius', pushBorderRadius * pushProgress + "px");
            }
          }

          $el.transition(0).transform("translate3d(0," + currentTranslate + "px,0)");

          if (sheet.params.swipeToStep) {
            var _progress;

            if (isTopSheetModal) {
              _progress = 1 - currentTranslate / swipeStepTranslate;
            } else {
              _progress = (swipeStepTranslate - currentTranslate) / swipeStepTranslate;
            }

            _progress = Math.min(Math.max(_progress, 0), 1);
            $el.trigger('sheet:stepprogress', _progress);
            sheet.emit('local::stepProgress sheetStepProgress', sheet, _progress);
          }
        }

        function handleTouchEnd() {
          isTouched = false;

          if (!isMoved) {
            return;
          }

          isMoved = false;
          $el.transform('').transition('');

          if (sheet.push && pushOffset) {
            $pushViewEl.transition('').transform('');
            $pushViewEl.css('border-radius', '');
          }

          var direction = touchesDiff < 0 ? 'to-bottom' : 'to-top';
          var diff = Math.abs(touchesDiff);
          if (diff === 0 || currentTranslate === startTranslate) return;
          var timeDiff = new Date().getTime() - touchStartTime;

          if (!sheet.params.swipeToStep) {
            if (direction !== (isTopSheetModal ? 'to-top' : 'to-bottom')) {
              return;
            }

            if (timeDiff < 300 && diff > 20 || timeDiff >= 300 && diff > sheetElOffsetHeight / 2) {
              sheet.close();
            }

            return;
          }

          var openDirection = isTopSheetModal ? 'to-bottom' : 'to-top';
          var closeDirection = isTopSheetModal ? 'to-top' : 'to-bottom';
          var absCurrentTranslate = Math.abs(currentTranslate);
          var absSwipeStepTranslate = Math.abs(swipeStepTranslate);

          if (timeDiff < 300 && diff > 10) {
            if (direction === openDirection && absCurrentTranslate < absSwipeStepTranslate) {
              // open step
              $el.removeClass('modal-in-swipe-step');
              $el.trigger('sheet:stepprogress', 1);
              sheet.emit('local::stepProgress sheetStepProgress', sheet, 1);
              sheet.emit('local::_swipeStep', false);
              $el.trigger('sheet:stepopen');
              sheet.emit('local::stepOpen sheetStepOpen', sheet);

              if (sheet.push && pushOffset) {
                sheet.$htmlEl[0].style.setProperty('--f7-sheet-push-scale', pushViewScale(pushOffset));
                $pushViewEl.css('border-radius', '');
              }
            }

            if (direction === closeDirection && absCurrentTranslate > absSwipeStepTranslate) {
              // close sheet
              if (sheet.params.swipeToClose) {
                sheet.close();
              } else {
                // close step
                $el.addClass('modal-in-swipe-step');
                $el.trigger('sheet:stepprogress', 0);
                sheet.emit('local::stepProgress sheetStepProgress', sheet, 0);
                sheet.emit('local::_swipeStep', true);
                $el.trigger('sheet:stepclose');
                sheet.emit('local::stepClose sheetStepClose', sheet);

                if (sheet.push && pushOffset) {
                  sheet.$htmlEl[0].style.removeProperty('--f7-sheet-push-scale');
                  $pushViewEl.css('border-radius', '0px');
                }
              }
            }

            if (direction === closeDirection && absCurrentTranslate <= absSwipeStepTranslate) {
              // close step
              $el.addClass('modal-in-swipe-step');
              $el.trigger('sheet:stepprogress', 0);
              sheet.emit('local::stepProgress sheetStepProgress', sheet, 0);
              sheet.emit('local::_swipeStep', true);
              $el.trigger('sheet:stepclose');
              sheet.emit('local::stepClose sheetStepClose', sheet);

              if (sheet.push && pushOffset) {
                sheet.$htmlEl[0].style.removeProperty('--f7-sheet-push-scale');
                $pushViewEl.css('border-radius', '0px');
              }
            }

            return;
          }

          if (timeDiff >= 300) {
            var stepOpened = !$el.hasClass('modal-in-swipe-step');

            if (!stepOpened) {
              if (absCurrentTranslate < absSwipeStepTranslate / 2) {
                // open step
                $el.removeClass('modal-in-swipe-step');
                $el.trigger('sheet:stepprogress', 1);
                sheet.emit('local::stepProgress sheetStepProgress', sheet, 1);
                sheet.emit('local::_swipeStep', false);
                $el.trigger('sheet:stepopen');
                sheet.emit('local::stepOpen sheetStepOpen', sheet);

                if (sheet.push && pushOffset) {
                  sheet.$htmlEl[0].style.setProperty('--f7-sheet-push-scale', pushViewScale(pushOffset));
                  $pushViewEl.css('border-radius', '');
                }
              } else if (absCurrentTranslate - absSwipeStepTranslate > (sheetElOffsetHeight - absSwipeStepTranslate) / 2) {
                // close sheet
                if (sheet.params.swipeToClose) sheet.close();
              }
            } else if (stepOpened) {
              if (absCurrentTranslate > absSwipeStepTranslate + (sheetElOffsetHeight - absSwipeStepTranslate) / 2) {
                // close sheet
                if (sheet.params.swipeToClose) sheet.close();
              } else if (absCurrentTranslate > absSwipeStepTranslate / 2) {
                // close step
                $el.addClass('modal-in-swipe-step');
                $el.trigger('sheet:stepprogress', 0);
                sheet.emit('local::stepProgress sheetStepProgress', sheet, 0);
                sheet.emit('local::_swipeStep', true);
                $el.trigger('sheet:stepclose');
                sheet.emit('local::stepClose sheetStepClose', sheet);

                if (sheet.push && pushOffset) {
                  sheet.$htmlEl[0].style.removeProperty('--f7-sheet-push-scale');
                  $pushViewEl.css('border-radius', '0px');
                }
              }
            }
          }
        }

        sheet.setSwipeStep = function setSwipeStep(byResize) {
          if (byResize === void 0) {
            byResize = true;
          }

          var $swipeStepEl = $el.find('.sheet-modal-swipe-step').eq(0);
          if (!$swipeStepEl.length) return;

          if ($el.hasClass('sheet-modal-top')) {
            swipeStepTranslate = -($swipeStepEl.offset().top - $el.offset().top + $swipeStepEl[0].offsetHeight);
          } else {
            swipeStepTranslate = $el[0].offsetHeight - ($swipeStepEl.offset().top - $el.offset().top + $swipeStepEl[0].offsetHeight);
          }

          $el[0].style.setProperty('--f7-sheet-swipe-step', swipeStepTranslate + "px");

          if (!byResize) {
            $el.addClass('modal-in-swipe-step');
            sheet.emit('local::_swipeStep', true);
          }
        };

        function onResize() {
          sheet.setSwipeStep(true);
        }

        var passive = support.passiveListener ? {
          passive: true
        } : false;

        if (sheet.params.swipeToClose || sheet.params.swipeToStep) {
          $el.on(app.touchEvents.start, handleTouchStart, passive);
          app.on('touchmove', handleTouchMove);
          app.on('touchend:passive', handleTouchEnd);
          sheet.once('sheetDestroy', function () {
            $el.off(app.touchEvents.start, handleTouchStart, passive);
            app.off('touchmove', handleTouchMove);
            app.off('touchend:passive', handleTouchEnd);
          });
        }

        sheet.on('open', function () {
          if (sheet.params.closeOnEscape) {
            $(document).on('keydown', onKeyDown);
          }

          $el.prevAll('.popup.modal-in').addClass('popup-behind');

          if (sheet.params.swipeToStep) {
            sheet.setSwipeStep(false);
            app.on('resize', onResize);
          }

          if (sheet.params.scrollToEl) {
            scrollToElementOnOpen();
          }

          if (sheet.push) {
            pushOffset = parseInt($el.css('--f7-sheet-push-offset'), 10);
            if (Number.isNaN(pushOffset)) pushOffset = 0;

            if (pushOffset) {
              $el.addClass('sheet-modal-push');
              sheet.$htmlEl.addClass('with-modal-sheet-push');

              if (!sheet.params.swipeToStep) {
                sheet.$htmlEl[0].style.setProperty('--f7-sheet-push-scale', pushViewScale(pushOffset));
              } else {
                $pushViewEl = app.$el.children('.view, .views');
                pushBorderRadius = parseFloat($el.css("border-" + (isTopSheetModal ? 'bottom' : 'top') + "-left-radius"));
                $pushViewEl.css('border-radius', '0px');
              }
            }
          }
        });
        sheet.on('opened', function () {
          if (sheet.params.closeByOutsideClick || sheet.params.closeByBackdropClick) {
            app.on('click', handleClick);
          }
        });
        sheet.on('close', function () {
          if (sheet.params.swipeToStep) {
            $el.removeClass('modal-in-swipe-step');
            sheet.emit('local::_swipeStep', false);
            app.off('resize', onResize);
          }

          if (sheet.params.closeOnEscape) {
            $(document).off('keydown', onKeyDown);
          }

          if (sheet.params.scrollToEl) {
            scrollToElementOnClose();
          }

          if (sheet.params.closeByOutsideClick || sheet.params.closeByBackdropClick) {
            app.off('click', handleClick);
          }

          $el.prevAll('.popup.modal-in').eq(0).removeClass('popup-behind');

          if (sheet.push && pushOffset) {
            sheet.$htmlEl.removeClass('with-modal-sheet-push');
            sheet.$htmlEl.addClass('with-modal-sheet-push-closing');
          }
        });
        sheet.on('closed', function () {
          if (sheet.push && pushOffset) {
            sheet.$htmlEl.removeClass('with-modal-sheet-push-closing');
            sheet.$htmlEl[0].style.removeProperty('--f7-sheet-push-scale');
          }
        });

        sheet.stepOpen = function stepOpen() {
          $el.removeClass('modal-in-swipe-step');
          sheet.emit('local::_swipeStep', false);

          if (sheet.push) {
            if (!pushOffset) {
              pushOffset = parseInt($el.css('--f7-sheet-push-offset'), 10);
              if (Number.isNaN(pushOffset)) pushOffset = 0;
            }

            if (pushOffset) {
              sheet.$htmlEl[0].style.setProperty('--f7-sheet-push-scale', pushViewScale(pushOffset));
            }
          }
        };

        sheet.stepClose = function stepClose() {
          $el.addClass('modal-in-swipe-step');
          sheet.emit('local::_swipeStep', true);

          if (sheet.push) {
            sheet.$htmlEl[0].style.removeProperty('--f7-sheet-push-scale');
          }
        };

        sheet.stepToggle = function stepToggle() {
          $el.toggleClass('modal-in-swipe-step');
          sheet.emit('local::_swipeStep', $el.hasClass('modal-in-swipe-step'));
        };

        $el[0].f7Modal = sheet;
        return sheet || _assertThisInitialized(_this);
      }

      return Sheet;
    }(Modal$1);

    var Sheet = {
      name: 'sheet',
      params: {
        sheet: {
          push: false,
          backdrop: undefined,
          backdropEl: undefined,
          closeByBackdropClick: true,
          closeByOutsideClick: false,
          closeOnEscape: false,
          swipeToClose: false,
          swipeToStep: false,
          swipeHandler: null,
          containerEl: null
        }
      },
      static: {
        Sheet: Sheet$1
      },
      create: function create() {
        var app = this;
        app.sheet = extend$1({}, ModalMethods({
          app: app,
          constructor: Sheet$1,
          defaultSelector: '.sheet-modal.modal-in'
        }), {
          stepOpen: function stepOpen(sheet) {
            var sheetInstance = app.sheet.get(sheet);
            if (sheetInstance && sheetInstance.stepOpen) return sheetInstance.stepOpen();
            return undefined;
          },
          stepClose: function stepClose(sheet) {
            var sheetInstance = app.sheet.get(sheet);
            if (sheetInstance && sheetInstance.stepClose) return sheetInstance.stepClose();
            return undefined;
          },
          stepToggle: function stepToggle(sheet) {
            var sheetInstance = app.sheet.get(sheet);
            if (sheetInstance && sheetInstance.stepToggle) return sheetInstance.stepToggle();
            return undefined;
          }
        });
      },
      clicks: {
        '.sheet-open': function openSheet($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;

          if ($('.sheet-modal.modal-in').length > 0 && data.sheet && $(data.sheet)[0] !== $('.sheet-modal.modal-in')[0]) {
            app.sheet.close('.sheet-modal.modal-in');
          }

          app.sheet.open(data.sheet, data.animate, $clickedEl);
        },
        '.sheet-close': function closeSheet($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.sheet.close(data.sheet, data.animate, $clickedEl);
        }
      }
    };

    var Toast$1 = /*#__PURE__*/function (_Modal) {
      _inheritsLoose(Toast, _Modal);

      function Toast(app, params) {
        var _this;

        var extendedParams = extend$1({
          on: {}
        }, app.params.toast, params); // Extends with open/close Modal methods;

        _this = _Modal.call(this, app, extendedParams) || this;

        var toast = _assertThisInitialized(_this);

        var window = getWindow();
        toast.app = app;
        toast.params = extendedParams;
        var _toast$params = toast.params,
            closeButton = _toast$params.closeButton,
            closeTimeout = _toast$params.closeTimeout;
        var $el;

        if (!toast.params.el) {
          // Find Element
          var toastHtml = toast.render();
          $el = $(toastHtml);
        } else {
          $el = $(toast.params.el);
        }

        if ($el && $el.length > 0 && $el[0].f7Modal) {
          return $el[0].f7Modal || _assertThisInitialized(_this);
        }

        if ($el.length === 0) {
          return toast.destroy() || _assertThisInitialized(_this);
        }

        extend$1(toast, {
          $el: $el,
          el: $el[0],
          type: 'toast'
        });
        $el[0].f7Modal = toast;

        if (closeButton) {
          $el.find('.toast-button').on('click', function () {
            toast.emit('local::closeButtonClick toastCloseButtonClick', toast);
            toast.close();
          });
          toast.on('beforeDestroy', function () {
            $el.find('.toast-button').off('click');
          });
        }

        var timeoutId;
        toast.on('open', function () {
          $('.toast.modal-in').each(function (openedEl) {
            var toastInstance = app.toast.get(openedEl);

            if (openedEl !== toast.el && toastInstance) {
              toastInstance.close();
            }
          });

          if (closeTimeout) {
            timeoutId = nextTick$1(function () {
              toast.close();
            }, closeTimeout);
          }
        });
        toast.on('close', function () {
          window.clearTimeout(timeoutId);
        });

        if (toast.params.destroyOnClose) {
          toast.once('closed', function () {
            setTimeout(function () {
              toast.destroy();
            }, 0);
          });
        }

        return toast || _assertThisInitialized(_this);
      }

      var _proto = Toast.prototype;

      _proto.render = function render() {
        var toast = this;
        if (toast.params.render) return toast.params.render.call(toast, toast);
        var _toast$params2 = toast.params,
            position = _toast$params2.position,
            horizontalPosition = _toast$params2.horizontalPosition,
            cssClass = _toast$params2.cssClass,
            icon = _toast$params2.icon,
            text = _toast$params2.text,
            closeButton = _toast$params2.closeButton,
            closeButtonColor = _toast$params2.closeButtonColor,
            closeButtonText = _toast$params2.closeButtonText;
        var horizontalClass = position === 'top' || position === 'bottom' ? "toast-horizontal-" + horizontalPosition : '';
        return $jsx("div", {
          class: "toast toast-" + position + " " + horizontalClass + " " + (cssClass || '') + " " + (icon ? 'toast-with-icon' : '')
        }, $jsx("div", {
          class: "toast-content"
        }, icon && $jsx("div", {
          class: "toast-icon"
        }, icon), $jsx("div", {
          class: "toast-text"
        }, text), closeButton && !icon && $jsx("a", {
          class: "toast-button button " + (closeButtonColor ? "color-" + closeButtonColor : '')
        }, closeButtonText)));
      };

      return Toast;
    }(Modal$1);

    var Toast = {
      name: 'toast',
      static: {
        Toast: Toast$1
      },
      create: function create() {
        var app = this;
        app.toast = extend$1({}, ModalMethods({
          app: app,
          constructor: Toast$1,
          defaultSelector: '.toast.modal-in'
        }), {
          // Shortcuts
          show: function show(params) {
            extend$1(params, {
              destroyOnClose: true
            });
            return new Toast$1(app, params).open();
          }
        });
      },
      params: {
        toast: {
          icon: null,
          text: null,
          position: 'bottom',
          horizontalPosition: 'left',
          closeButton: false,
          closeButtonColor: null,
          closeButtonText: 'Ok',
          closeTimeout: null,
          cssClass: null,
          render: null,
          containerEl: null
        }
      }
    };

    var Preloader = {
      init: function init(el) {
        var app = this;
        var preloaders = {
          iosPreloaderContent: iosPreloaderContent,
          mdPreloaderContent: mdPreloaderContent,
          auroraPreloaderContent: auroraPreloaderContent
        };
        var $el = $(el);
        if ($el.length === 0 || $el.children('.preloader-inner').length > 0 || $el.children('.preloader-inner-line').length > 0) return;
        $el.append(preloaders[app.theme + "PreloaderContent"]);
      },
      // Modal
      visible: false,
      show: function show(color) {
        if (color === void 0) {
          color = 'white';
        }

        var app = this;
        if (Preloader.visible) return;
        var preloaders = {
          iosPreloaderContent: iosPreloaderContent,
          mdPreloaderContent: mdPreloaderContent,
          auroraPreloaderContent: auroraPreloaderContent
        };
        var preloaderInner = preloaders[app.theme + "PreloaderContent"] || '';
        $('html').addClass('with-modal-preloader'); // prettier-ignore

        app.$el.append("\n      <div class=\"preloader-backdrop\"></div>\n      <div class=\"preloader-modal\">\n        <div class=\"preloader color-" + color + "\">" + preloaderInner + "</div>\n      </div>\n    ");
        Preloader.visible = true;
      },
      showIn: function showIn(el, color) {
        if (color === void 0) {
          color = 'white';
        }

        var app = this;
        var preloaders = {
          iosPreloaderContent: iosPreloaderContent,
          mdPreloaderContent: mdPreloaderContent,
          auroraPreloaderContent: auroraPreloaderContent
        };
        var preloaderInner = preloaders[app.theme + "PreloaderContent"] || '';
        $(el || 'html').addClass('with-modal-preloader'); // prettier-ignore

        $(el || app.$el).append("\n      <div class=\"preloader-backdrop\"></div>\n      <div class=\"preloader-modal\">\n        <div class=\"preloader color-" + color + "\">" + preloaderInner + "</div>\n      </div>\n    ");
      },
      hide: function hide() {
        var app = this;
        if (!Preloader.visible) return;
        $('html').removeClass('with-modal-preloader');
        app.$el.find('.preloader-backdrop, .preloader-modal').remove();
        Preloader.visible = false;
      },
      hideIn: function hideIn(el) {
        var app = this;
        $(el || 'html').removeClass('with-modal-preloader');
        $(el || app.$el).find('.preloader-backdrop, .preloader-modal').remove();
      }
    };
    var Preloader$1 = {
      name: 'preloader',
      create: function create() {
        var app = this;
        bindMethods(app, {
          preloader: Preloader
        });
      },
      on: {
        photoBrowserOpen: function photoBrowserOpen(pb) {
          var app = this;
          pb.$el.find('.preloader').each(function (preloaderEl) {
            app.preloader.init(preloaderEl);
          });
        },
        tabMounted: function tabMounted(tabEl) {
          var app = this;
          $(tabEl).find('.preloader').each(function (preloaderEl) {
            app.preloader.init(preloaderEl);
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.preloader').each(function (preloaderEl) {
            app.preloader.init(preloaderEl);
          });
        }
      },
      vnode: {
        preloader: {
          insert: function insert(vnode) {
            var app = this;
            var preloaderEl = vnode.elm;
            app.preloader.init(preloaderEl);
          }
        }
      }
    };

    var Progressbar = {
      set: function set() {
        var app = this;

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        var el = args[0],
            progress = args[1],
            duration = args[2];

        if (typeof args[0] === 'number') {
          progress = args[0];
          duration = args[1];
          el = app.$el;
        }

        if (typeof progress === 'undefined' || progress === null) return el;
        if (!progress) progress = 0;
        var $el = $(el || app.$el);

        if ($el.length === 0) {
          return el;
        }

        var progressNormalized = Math.min(Math.max(progress, 0), 100);
        var $progressbarEl;
        if ($el.hasClass('progressbar')) $progressbarEl = $el.eq(0);else {
          $progressbarEl = $el.children('.progressbar');
        }

        if ($progressbarEl.length === 0 || $progressbarEl.hasClass('progressbar-infinite')) {
          return $progressbarEl;
        }

        var $progressbarLine = $progressbarEl.children('span');

        if ($progressbarLine.length === 0) {
          $progressbarLine = $('<span></span>');
          $progressbarEl.append($progressbarLine);
        }

        $progressbarLine.transition(typeof duration !== 'undefined' ? duration : '').transform("translate3d(" + (-100 + progressNormalized) + "%,0,0)");
        return $progressbarEl[0];
      },
      show: function show() {
        var app = this; // '.page', 50, 'multi'

        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        var el = args[0],
            progress = args[1],
            color = args[2];
        var type = 'determined';

        if (args.length === 2) {
          if ((typeof args[0] === 'string' || typeof args[0] === 'object') && typeof args[1] === 'string') {
            // '.page', 'multi'
            el = args[0];
            color = args[1];
            progress = args[2];
            type = 'infinite';
          } else if (typeof args[0] === 'number' && typeof args[1] === 'string') {
            // 50, 'multi'
            progress = args[0];
            color = args[1];
            el = app.$el;
          }
        } else if (args.length === 1) {
          if (typeof args[0] === 'number') {
            el = app.$el;
            progress = args[0];
          } else if (typeof args[0] === 'string') {
            type = 'infinite';
            el = app.$el;
            color = args[0];
          }
        } else if (args.length === 0) {
          type = 'infinite';
          el = app.$el;
        }

        var $el = $(el);
        if ($el.length === 0) return undefined;
        var $progressbarEl;

        if ($el.hasClass('progressbar') || $el.hasClass('progressbar-infinite')) {
          $progressbarEl = $el;
        } else {
          $progressbarEl = $el.children('.progressbar:not(.progressbar-out), .progressbar-infinite:not(.progressbar-out)');

          if ($progressbarEl.length === 0) {
            $progressbarEl = $("\n          <span class=\"progressbar" + (type === 'infinite' ? '-infinite' : '') + (color ? " color-" + color : '') + " progressbar-in\">\n            " + (type === 'infinite' ? '' : '<span></span>') + "\n          </span>");
            $el.append($progressbarEl);
          }
        }

        if (typeof progress !== 'undefined') {
          app.progressbar.set($progressbarEl, progress);
        }

        return $progressbarEl[0];
      },
      hide: function hide(el, removeAfterHide) {
        if (removeAfterHide === void 0) {
          removeAfterHide = true;
        }

        var app = this;
        var $el = $(el || app.$el);
        if ($el.length === 0) return undefined;
        var $progressbarEl;

        if ($el.hasClass('progressbar') || $el.hasClass('progressbar-infinite')) {
          $progressbarEl = $el;
        } else {
          $progressbarEl = $el.children('.progressbar, .progressbar-infinite');
        }

        if ($progressbarEl.length === 0 || !$progressbarEl.hasClass('progressbar-in') || $progressbarEl.hasClass('progressbar-out')) {
          return $progressbarEl;
        }

        $progressbarEl.removeClass('progressbar-in').addClass('progressbar-out').animationEnd(function () {
          if (removeAfterHide) {
            $progressbarEl.remove();
          }
        });
        return $progressbarEl;
      }
    };
    var Progressbar$1 = {
      name: 'progressbar',
      create: function create() {
        var app = this;
        bindMethods(app, {
          progressbar: Progressbar
        });
      },
      on: {
        tabMounted: function tabMounted(tabEl) {
          var app = this;
          $(tabEl).find('.progressbar').each(function (progressbarEl) {
            var $progressbarEl = $(progressbarEl);
            app.progressbar.set($progressbarEl, $progressbarEl.attr('data-progress'));
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.progressbar').each(function (progressbarEl) {
            var $progressbarEl = $(progressbarEl);
            app.progressbar.set($progressbarEl, $progressbarEl.attr('data-progress'));
          });
        }
      },
      vnode: {
        progressbar: {
          insert: function insert(vnode) {
            var app = this;
            var el = vnode.elm;
            app.progressbar.set(el, el.getAttribute('data-progress'));
          },
          update: function update(vnode) {
            var app = this;
            var el = vnode.elm;
            app.progressbar.set(el, el.getAttribute('data-progress'));
          }
        }
      }
    };

    var Sortable = {
      init: function init() {
        var app = this;
        var document = getDocument();
        var isTouched;
        var isMoved;
        var touchStartY;
        var touchesDiff;
        var $sortingEl;
        var $sortingItems;
        var $sortableContainer;
        var sortingElHeight;
        var minTop;
        var maxTop;
        var $insertAfterEl;
        var $insertBeforeEl;
        var indexFrom;
        var $pageEl;
        var $pageContentEl;
        var pageHeight;
        var pageOffset;
        var sortingElOffsetLocal;
        var sortingElOffsetTop;
        var initialScrollTop;
        var wasTapHold;

        function handleTouchStart(e, isTapHold) {
          isMoved = false;
          isTouched = true;
          wasTapHold = false;
          touchStartY = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
          $sortingEl = $(e.target).closest('li').eq(0);
          indexFrom = $sortingEl.index();
          $sortableContainer = $sortingEl.parents('.sortable');
          var $listGroup = $sortingEl.parents('.list-group');

          if ($listGroup.length && $listGroup.parents($sortableContainer).length) {
            $sortableContainer = $listGroup;
          }

          $sortingItems = $sortableContainer.children('ul').children('li:not(.disallow-sorting):not(.no-sorting)');
          if (app.panel) app.panel.allowOpen = false;
          if (app.swipeout) app.swipeout.allow = false;

          if (isTapHold) {
            $sortingEl.addClass('sorting');
            $sortableContainer.addClass('sortable-sorting');
            wasTapHold = true;
          }
        }

        function handleTouchMove(e) {
          if (!isTouched || !$sortingEl) return;
          var pageY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

          if (!isMoved) {
            $pageEl = $sortingEl.parents('.page');
            $pageContentEl = $sortingEl.parents('.page-content');
            var paddingTop = parseInt($pageContentEl.css('padding-top'), 10);
            var paddingBottom = parseInt($pageContentEl.css('padding-bottom'), 10);
            initialScrollTop = $pageContentEl[0].scrollTop;
            pageOffset = $pageEl.offset().top + paddingTop;
            pageHeight = $pageEl.height() - paddingTop - paddingBottom;
            $sortingEl.addClass('sorting');
            $sortableContainer.addClass('sortable-sorting');
            sortingElOffsetLocal = $sortingEl[0].offsetTop;
            minTop = $sortingEl[0].offsetTop;
            maxTop = $sortingEl.parent().height() - sortingElOffsetLocal - $sortingEl.height();
            sortingElHeight = $sortingEl[0].offsetHeight;
            sortingElOffsetTop = $sortingEl.offset().top;
          }

          isMoved = true;
          e.preventDefault();
          e.f7PreventSwipePanel = true;
          touchesDiff = pageY - touchStartY;
          var translateScrollOffset = $pageContentEl[0].scrollTop - initialScrollTop;
          var translate = Math.min(Math.max(touchesDiff + translateScrollOffset, -minTop), maxTop);
          $sortingEl.transform("translate3d(0," + translate + "px,0)");
          var scrollAddition = 44;
          var allowScroll = true;

          if (touchesDiff + translateScrollOffset + scrollAddition < -minTop) {
            allowScroll = false;
          }

          if (touchesDiff + translateScrollOffset - scrollAddition > maxTop) {
            allowScroll = false;
          }

          $insertBeforeEl = undefined;
          $insertAfterEl = undefined;
          var scrollDiff;

          if (allowScroll) {
            if (sortingElOffsetTop + touchesDiff + sortingElHeight + scrollAddition > pageOffset + pageHeight) {
              // To Bottom
              scrollDiff = sortingElOffsetTop + touchesDiff + sortingElHeight + scrollAddition - (pageOffset + pageHeight);
            }

            if (sortingElOffsetTop + touchesDiff < pageOffset + scrollAddition) {
              // To Top
              scrollDiff = sortingElOffsetTop + touchesDiff - pageOffset - scrollAddition;
            }

            if (scrollDiff) {
              $pageContentEl[0].scrollTop += scrollDiff;
            }
          }

          $sortingItems.each(function (el) {
            var $currentEl = $(el);
            if ($currentEl[0] === $sortingEl[0]) return;
            var currentElOffset = $currentEl[0].offsetTop;
            var currentElHeight = $currentEl.height();
            var sortingElOffset = sortingElOffsetLocal + translate;
            var currentTranslate;
            var prevTranslate = $currentEl[0].f7Translate;

            if (sortingElOffset >= currentElOffset - currentElHeight / 2 && $sortingEl.index() < $currentEl.index()) {
              currentTranslate = -sortingElHeight;
              $currentEl.transform("translate3d(0, " + currentTranslate + "px,0)");
              $insertAfterEl = $currentEl;
              $insertBeforeEl = undefined;
            } else if (sortingElOffset <= currentElOffset + currentElHeight / 2 && $sortingEl.index() > $currentEl.index()) {
              currentTranslate = sortingElHeight;
              $currentEl[0].f7Translate = currentTranslate;
              $currentEl.transform("translate3d(0, " + currentTranslate + "px,0)");
              $insertAfterEl = undefined;
              if (!$insertBeforeEl) $insertBeforeEl = $currentEl;
            } else {
              currentTranslate = undefined;
              $currentEl.transform('translate3d(0, 0%,0)');
            }

            if (prevTranslate !== currentTranslate) {
              $currentEl.trigger('sortable:move');
              app.emit('sortableMove', $currentEl[0], $sortableContainer[0]);
            }

            $currentEl[0].f7Translate = currentTranslate;
          });
        }

        function handleTouchEnd() {
          if (!isTouched || !isMoved) {
            if (isTouched && !isMoved) {
              if (app.panel) app.panel.allowOpen = true;
              if (app.swipeout) app.swipeout.allow = true;

              if (wasTapHold) {
                $sortingEl.removeClass('sorting');
                $sortableContainer.removeClass('sortable-sorting');
              }
            }

            isTouched = false;
            isMoved = false;
            return;
          }

          if (app.panel) app.panel.allowOpen = true;
          if (app.swipeout) app.swipeout.allow = true;
          $sortingItems.transform('');
          $sortingEl.removeClass('sorting');
          $sortableContainer.removeClass('sortable-sorting');
          var indexTo;
          if ($insertAfterEl) indexTo = $insertAfterEl.index();else if ($insertBeforeEl) indexTo = $insertBeforeEl.index();
          var moveElements = $sortableContainer.dataset().sortableMoveElements;

          if (typeof moveElements === 'undefined') {
            moveElements = app.params.sortable.moveElements;
          }

          if (moveElements) {
            if ($insertAfterEl) {
              $sortingEl.insertAfter($insertAfterEl);
            }

            if ($insertBeforeEl) {
              $sortingEl.insertBefore($insertBeforeEl);
            }
          }

          if (($insertAfterEl || $insertBeforeEl) && $sortableContainer.hasClass('virtual-list')) {
            indexFrom = $sortingEl[0].f7VirtualListIndex;
            if (typeof indexFrom === 'undefined') indexFrom = $sortingEl.attr('data-virtual-list-index');

            if ($insertBeforeEl) {
              indexTo = $insertBeforeEl[0].f7VirtualListIndex;
              if (typeof indexTo === 'undefined') indexTo = $insertBeforeEl.attr('data-virtual-list-index');
            } else {
              indexTo = $insertAfterEl[0].f7VirtualListIndex;
              if (typeof indexTo === 'undefined') indexTo = $insertAfterEl.attr('data-virtual-list-index');
            }

            if (indexTo !== null) indexTo = parseInt(indexTo, 10);else indexTo = undefined;
            var virtualList = $sortableContainer[0].f7VirtualList;
            if (indexFrom) indexFrom = parseInt(indexFrom, 10);
            if (indexTo) indexTo = parseInt(indexTo, 10);
            if (virtualList) virtualList.moveItem(indexFrom, indexTo);
          }

          if (typeof indexTo !== 'undefined' && !Number.isNaN(indexTo) && indexTo !== indexFrom) {
            $sortingEl.trigger('sortable:sort', {
              from: indexFrom,
              to: indexTo
            });
            app.emit('sortableSort', $sortingEl[0], {
              from: indexFrom,
              to: indexTo,
              el: $sortingEl[0]
            }, $sortableContainer[0]);
          }

          $insertBeforeEl = undefined;
          $insertAfterEl = undefined;
          isTouched = false;
          isMoved = false;
        }

        var activeListener = getSupport$1().passiveListener ? {
          passive: false,
          capture: false
        } : false;
        $(document).on(app.touchEvents.start, '.list.sortable .sortable-handler', handleTouchStart, activeListener);
        app.on('touchmove:active', handleTouchMove);
        app.on('touchend:passive', handleTouchEnd);
        $(document).on('taphold', '.sortable-tap-hold', function (e, pointerEvent) {
          handleTouchStart(pointerEvent, true);
        });
      },
      enable: function enable(el) {
        if (el === void 0) {
          el = '.list.sortable';
        }

        var app = this;
        var $el = $(el);
        if ($el.length === 0) return;
        $el.addClass('sortable-enabled');
        $el.trigger('sortable:enable');
        app.emit('sortableEnable', $el[0]);
      },
      disable: function disable(el) {
        if (el === void 0) {
          el = '.list.sortable';
        }

        var app = this;
        var $el = $(el);
        if ($el.length === 0) return;
        $el.removeClass('sortable-enabled');
        $el.trigger('sortable:disable');
        app.emit('sortableDisable', $el[0]);
      },
      toggle: function toggle(el) {
        if (el === void 0) {
          el = '.list.sortable';
        }

        var app = this;
        var $el = $(el);
        if ($el.length === 0) return;

        if ($el.hasClass('sortable-enabled')) {
          app.sortable.disable($el);
        } else {
          app.sortable.enable($el);
        }
      }
    };
    var Sortable$1 = {
      name: 'sortable',
      params: {
        sortable: {
          moveElements: true
        }
      },
      create: function create() {
        var app = this;
        bindMethods(app, {
          sortable: Sortable
        });
      },
      on: {
        init: function init() {
          var app = this;
          if (!app.params.sortable) return;
          app.sortable.init();
        }
      },
      clicks: {
        '.sortable-enable': function enable($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.sortable.enable(data.sortable);
        },
        '.sortable-disable': function disable($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.sortable.disable(data.sortable);
        },
        '.sortable-toggle': function toggle($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.sortable.toggle(data.sortable);
        }
      }
    };

    var Swipeout = {
      init: function init() {
        var app = this;
        var document = getDocument();
        var touchesStart = {};
        var isTouched;
        var isMoved;
        var isScrolling;
        var touchStartTime;
        var touchesDiff;
        var $swipeoutEl;
        var $swipeoutContent;
        var $actionsRight;
        var $actionsLeft;
        var actionsLeftWidth;
        var actionsRightWidth;
        var translate;
        var opened;
        var openedActionsSide;
        var $leftButtons;
        var $rightButtons;
        var direction;
        var $overswipeLeftButton;
        var $overswipeRightButton;
        var overswipeLeft;
        var overswipeRight;

        function handleTouchStart(e) {
          if (!app.swipeout.allow) return;
          isMoved = false;
          isTouched = true;
          isScrolling = undefined;
          touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
          touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
          touchStartTime = new Date().getTime();
          $swipeoutEl = $(this);
        }

        function handleTouchMove(e) {
          if (!isTouched) return;
          var pageX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
          var pageY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

          if (typeof isScrolling === 'undefined') {
            isScrolling = !!(isScrolling || Math.abs(pageY - touchesStart.y) > Math.abs(pageX - touchesStart.x));
          }

          if (isScrolling) {
            isTouched = false;
            return;
          }

          if (!isMoved) {
            if ($('.list.sortable-opened').length > 0) return;
            $swipeoutContent = $swipeoutEl.find('.swipeout-content');
            $actionsRight = $swipeoutEl.find('.swipeout-actions-right');
            $actionsLeft = $swipeoutEl.find('.swipeout-actions-left');
            actionsLeftWidth = null;
            actionsRightWidth = null;
            $leftButtons = null;
            $rightButtons = null;
            $overswipeRightButton = null;
            $overswipeLeftButton = null;

            if ($actionsLeft.length > 0) {
              actionsLeftWidth = $actionsLeft.outerWidth();
              $leftButtons = $actionsLeft.children('a');
              $overswipeLeftButton = $actionsLeft.find('.swipeout-overswipe');
            }

            if ($actionsRight.length > 0) {
              actionsRightWidth = $actionsRight.outerWidth();
              $rightButtons = $actionsRight.children('a');
              $overswipeRightButton = $actionsRight.find('.swipeout-overswipe');
            }

            opened = $swipeoutEl.hasClass('swipeout-opened');

            if (opened) {
              openedActionsSide = $swipeoutEl.find('.swipeout-actions-left.swipeout-actions-opened').length > 0 ? 'left' : 'right';
            }

            $swipeoutEl.removeClass('swipeout-transitioning');

            if (!app.params.swipeout.noFollow) {
              $swipeoutEl.find('.swipeout-actions-opened').removeClass('swipeout-actions-opened');
              $swipeoutEl.removeClass('swipeout-opened');
            }
          }

          isMoved = true;

          if (e.cancelable) {
            e.preventDefault();
          }

          touchesDiff = pageX - touchesStart.x;
          translate = touchesDiff;

          if (opened) {
            if (openedActionsSide === 'right') translate -= actionsRightWidth;else translate += actionsLeftWidth;
          }

          if (translate > 0 && $actionsLeft.length === 0 || translate < 0 && $actionsRight.length === 0) {
            if (!opened) {
              isTouched = false;
              isMoved = false;
              $swipeoutContent.transform('');

              if ($rightButtons && $rightButtons.length > 0) {
                $rightButtons.transform('');
              }

              if ($leftButtons && $leftButtons.length > 0) {
                $leftButtons.transform('');
              }

              return;
            }

            translate = 0;
          }

          if (translate < 0) direction = 'to-left';else if (translate > 0) direction = 'to-right';else if (!direction) direction = 'to-left';
          var buttonOffset;
          var progress;
          e.f7PreventSwipePanel = true;

          if (app.params.swipeout.noFollow) {
            if (opened) {
              if (openedActionsSide === 'right' && touchesDiff > 0) {
                app.swipeout.close($swipeoutEl);
              }

              if (openedActionsSide === 'left' && touchesDiff < 0) {
                app.swipeout.close($swipeoutEl);
              }
            } else {
              if (touchesDiff < 0 && $actionsRight.length > 0) {
                app.swipeout.open($swipeoutEl, 'right');
              }

              if (touchesDiff > 0 && $actionsLeft.length > 0) {
                app.swipeout.open($swipeoutEl, 'left');
              }
            }

            isTouched = false;
            isMoved = false;
            return;
          }

          overswipeLeft = false;
          overswipeRight = false;

          if ($actionsRight.length > 0) {
            // Show right actions
            var buttonTranslate = translate;
            progress = buttonTranslate / actionsRightWidth;

            if (buttonTranslate < -actionsRightWidth) {
              var ratio = buttonTranslate / -actionsRightWidth;
              buttonTranslate = -actionsRightWidth - Math.pow(-buttonTranslate - actionsRightWidth, 0.8);
              translate = buttonTranslate;

              if ($overswipeRightButton.length > 0 && ratio > app.params.swipeout.overswipeRatio) {
                overswipeRight = true;
              }
            }

            if (direction !== 'to-left') {
              progress = 0;
              buttonTranslate = 0;
            }

            $rightButtons.each(function (buttonEl) {
              var $buttonEl = $(buttonEl);

              if (typeof buttonEl.f7SwipeoutButtonOffset === 'undefined') {
                $buttonEl[0].f7SwipeoutButtonOffset = buttonEl.offsetLeft;
              }

              buttonOffset = buttonEl.f7SwipeoutButtonOffset;

              if ($overswipeRightButton.length > 0 && $buttonEl.hasClass('swipeout-overswipe') && direction === 'to-left') {
                $buttonEl.css({
                  left: (overswipeRight ? -buttonOffset : 0) + "px"
                });

                if (overswipeRight) {
                  if (!$buttonEl.hasClass('swipeout-overswipe-active')) {
                    $swipeoutEl.trigger('swipeout:overswipeenter');
                    app.emit('swipeoutOverswipeEnter', $swipeoutEl[0]);
                  }

                  $buttonEl.addClass('swipeout-overswipe-active');
                } else {
                  if ($buttonEl.hasClass('swipeout-overswipe-active')) {
                    $swipeoutEl.trigger('swipeout:overswipeexit');
                    app.emit('swipeoutOverswipeExit', $swipeoutEl[0]);
                  }

                  $buttonEl.removeClass('swipeout-overswipe-active');
                }
              }

              $buttonEl.transform("translate3d(" + (buttonTranslate - buttonOffset * (1 + Math.max(progress, -1))) + "px,0,0)");
            });
          }

          if ($actionsLeft.length > 0) {
            // Show left actions
            var _buttonTranslate = translate;
            progress = _buttonTranslate / actionsLeftWidth;

            if (_buttonTranslate > actionsLeftWidth) {
              var _ratio = _buttonTranslate / actionsRightWidth;

              _buttonTranslate = actionsLeftWidth + Math.pow(_buttonTranslate - actionsLeftWidth, 0.8);
              translate = _buttonTranslate;

              if ($overswipeLeftButton.length > 0 && _ratio > app.params.swipeout.overswipeRatio) {
                overswipeLeft = true;
              }
            }

            if (direction !== 'to-right') {
              _buttonTranslate = 0;
              progress = 0;
            }

            $leftButtons.each(function (buttonEl, index) {
              var $buttonEl = $(buttonEl);

              if (typeof buttonEl.f7SwipeoutButtonOffset === 'undefined') {
                $buttonEl[0].f7SwipeoutButtonOffset = actionsLeftWidth - buttonEl.offsetLeft - buttonEl.offsetWidth;
              }

              buttonOffset = buttonEl.f7SwipeoutButtonOffset;

              if ($overswipeLeftButton.length > 0 && $buttonEl.hasClass('swipeout-overswipe') && direction === 'to-right') {
                $buttonEl.css({
                  left: (overswipeLeft ? buttonOffset : 0) + "px"
                });

                if (overswipeLeft) {
                  if (!$buttonEl.hasClass('swipeout-overswipe-active')) {
                    $swipeoutEl.trigger('swipeout:overswipeenter');
                    app.emit('swipeoutOverswipeEnter', $swipeoutEl[0]);
                  }

                  $buttonEl.addClass('swipeout-overswipe-active');
                } else {
                  if ($buttonEl.hasClass('swipeout-overswipe-active')) {
                    $swipeoutEl.trigger('swipeout:overswipeexit');
                    app.emit('swipeoutOverswipeExit', $swipeoutEl[0]);
                  }

                  $buttonEl.removeClass('swipeout-overswipe-active');
                }
              }

              if ($leftButtons.length > 1) {
                $buttonEl.css('z-index', $leftButtons.length - index);
              }

              $buttonEl.transform("translate3d(" + (_buttonTranslate + buttonOffset * (1 - Math.min(progress, 1))) + "px,0,0)");
            });
          }

          $swipeoutEl.trigger('swipeout', progress);
          app.emit('swipeout', $swipeoutEl[0], progress);
          $swipeoutContent.transform("translate3d(" + translate + "px,0,0)");
        }

        function handleTouchEnd() {
          if (!isTouched || !isMoved) {
            isTouched = false;
            isMoved = false;
            return;
          }

          isTouched = false;
          isMoved = false;
          var timeDiff = new Date().getTime() - touchStartTime;
          var $actions = direction === 'to-left' ? $actionsRight : $actionsLeft;
          var actionsWidth = direction === 'to-left' ? actionsRightWidth : actionsLeftWidth;
          var action;
          var $buttons;
          var i;

          if (timeDiff < 300 && (touchesDiff < -10 && direction === 'to-left' || touchesDiff > 10 && direction === 'to-right') || timeDiff >= 300 && Math.abs(translate) > actionsWidth / 2) {
            action = 'open';
          } else {
            action = 'close';
          }

          if (timeDiff < 300) {
            if (Math.abs(translate) === 0) action = 'close';
            if (Math.abs(translate) === actionsWidth) action = 'open';
          }

          if (action === 'open') {
            Swipeout.el = $swipeoutEl[0];
            $swipeoutEl.trigger('swipeout:open');
            app.emit('swipeoutOpen', $swipeoutEl[0]);
            $swipeoutEl.addClass('swipeout-opened swipeout-transitioning');
            var newTranslate = direction === 'to-left' ? -actionsWidth : actionsWidth;
            $swipeoutContent.transform("translate3d(" + newTranslate + "px,0,0)");
            $actions.addClass('swipeout-actions-opened');
            $buttons = direction === 'to-left' ? $rightButtons : $leftButtons;

            if ($buttons) {
              for (i = 0; i < $buttons.length; i += 1) {
                $($buttons[i]).transform("translate3d(" + newTranslate + "px,0,0)");
              }
            }

            if (overswipeRight) {
              $actionsRight.find('.swipeout-overswipe').trigger('click', 'f7Overswipe');
            }

            if (overswipeLeft) {
              $actionsLeft.find('.swipeout-overswipe').trigger('click', 'f7Overswipe');
            }
          } else {
            $swipeoutEl.trigger('swipeout:close');
            app.emit('swipeoutClose', $swipeoutEl[0]);
            Swipeout.el = undefined;
            $swipeoutEl.addClass('swipeout-transitioning').removeClass('swipeout-opened');
            $swipeoutContent.transform('');
            $actions.removeClass('swipeout-actions-opened');
          }

          var buttonOffset;

          if ($leftButtons && $leftButtons.length > 0 && $leftButtons !== $buttons) {
            $leftButtons.each(function (buttonEl) {
              var $buttonEl = $(buttonEl);
              buttonOffset = buttonEl.f7SwipeoutButtonOffset;

              if (typeof buttonOffset === 'undefined') {
                $buttonEl[0].f7SwipeoutButtonOffset = actionsLeftWidth - buttonEl.offsetLeft - buttonEl.offsetWidth;
              }

              $buttonEl.transform("translate3d(" + buttonOffset + "px,0,0)");
            });
          }

          if ($rightButtons && $rightButtons.length > 0 && $rightButtons !== $buttons) {
            $rightButtons.each(function (buttonEl) {
              var $buttonEl = $(buttonEl);
              buttonOffset = buttonEl.f7SwipeoutButtonOffset;

              if (typeof buttonOffset === 'undefined') {
                $buttonEl[0].f7SwipeoutButtonOffset = buttonEl.offsetLeft;
              }

              $buttonEl.transform("translate3d(" + -buttonOffset + "px,0,0)");
            });
          }

          $swipeoutContent.transitionEnd(function () {
            if (opened && action === 'open' || !opened && action === 'close') return;
            $swipeoutEl.trigger(action === 'open' ? 'swipeout:opened' : 'swipeout:closed');
            app.emit(action === 'open' ? 'swipeoutOpened' : 'swipeoutClosed', $swipeoutEl[0]);
            $swipeoutEl.removeClass('swipeout-transitioning');

            if (opened && action === 'close') {
              if ($actionsRight.length > 0) {
                $rightButtons.transform('');
              }

              if ($actionsLeft.length > 0) {
                $leftButtons.transform('');
              }
            }
          });
        }

        var passiveListener = getSupport$1().passiveListener ? {
          passive: true
        } : false;
        app.on('touchstart', function (e) {
          if (Swipeout.el) {
            var $targetEl = $(e.target);

            if (!($(Swipeout.el).is($targetEl[0]) || $targetEl.parents('.swipeout').is(Swipeout.el) || $targetEl.hasClass('modal-in') || ($targetEl.attr('class') || '').indexOf('-backdrop') > 0 || $targetEl.hasClass('actions-modal') || $targetEl.parents('.actions-modal.modal-in, .dialog.modal-in').length > 0)) {
              app.swipeout.close(Swipeout.el);
            }
          }
        });
        $(document).on(app.touchEvents.start, 'li.swipeout', handleTouchStart, passiveListener);
        app.on('touchmove:active', handleTouchMove);
        app.on('touchend:passive', handleTouchEnd);
      },
      allow: true,
      el: undefined,
      open: function open() {
        var app = this;

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        var el = args[0],
            side = args[1],
            callback = args[2];

        if (typeof args[1] === 'function') {
          el = args[0];
          callback = args[1];
          side = args[2];
        }

        var $el = $(el).eq(0);
        if ($el.length === 0) return;
        if (!$el.hasClass('swipeout') || $el.hasClass('swipeout-opened')) return;

        if (!side) {
          if ($el.find('.swipeout-actions-right').length > 0) side = 'right';else side = 'left';
        }

        var $swipeoutActions = $el.find(".swipeout-actions-" + side);
        var $swipeoutContent = $el.find('.swipeout-content');
        if ($swipeoutActions.length === 0) return;
        $el.trigger('swipeout:open').addClass('swipeout-opened').removeClass('swipeout-transitioning');
        app.emit('swipeoutOpen', $el[0]);
        $swipeoutActions.addClass('swipeout-actions-opened');
        var $buttons = $swipeoutActions.children('a');
        var swipeoutActionsWidth = $swipeoutActions.outerWidth();
        var translate = side === 'right' ? -swipeoutActionsWidth : swipeoutActionsWidth;

        if ($buttons.length > 1) {
          $buttons.each(function (buttonEl, buttonIndex) {
            var $buttonEl = $(buttonEl);

            if (side === 'right') {
              $buttonEl.transform("translate3d(" + -buttonEl.offsetLeft + "px,0,0)");
            } else {
              $buttonEl.css('z-index', $buttons.length - buttonIndex).transform("translate3d(" + (swipeoutActionsWidth - buttonEl.offsetWidth - buttonEl.offsetLeft) + "px,0,0)");
            }
          });
        }

        $el.addClass('swipeout-transitioning');
        $swipeoutContent.transitionEnd(function () {
          $el.trigger('swipeout:opened');
          app.emit('swipeoutOpened', $el[0]);
          if (callback) callback.call($el[0]);
        });
        nextFrame$1(function () {
          $buttons.transform("translate3d(" + translate + "px,0,0)");
          $swipeoutContent.transform("translate3d(" + translate + "px,0,0)");
        });
        Swipeout.el = $el[0];
      },
      close: function close(el, callback) {
        var app = this;
        var $el = $(el).eq(0);
        if ($el.length === 0) return;
        if (!$el.hasClass('swipeout-opened')) return;
        var side = $el.find('.swipeout-actions-opened').hasClass('swipeout-actions-right') ? 'right' : 'left';
        var $swipeoutActions = $el.find('.swipeout-actions-opened').removeClass('swipeout-actions-opened');
        var $buttons = $swipeoutActions.children('a');
        var swipeoutActionsWidth = $swipeoutActions.outerWidth();
        app.swipeout.allow = false;
        $el.trigger('swipeout:close');
        app.emit('swipeoutClose', $el[0]);
        $el.removeClass('swipeout-opened').addClass('swipeout-transitioning');
        var closeTimeout;

        function onSwipeoutClose() {
          app.swipeout.allow = true;
          if ($el.hasClass('swipeout-opened')) return;
          $el.removeClass('swipeout-transitioning');
          $buttons.transform('');
          $el.trigger('swipeout:closed');
          app.emit('swipeoutClosed', $el[0]);
          if (callback) callback.call($el[0]);
          if (closeTimeout) clearTimeout(closeTimeout);
        }

        $el.find('.swipeout-content').transform('').transitionEnd(onSwipeoutClose);
        closeTimeout = setTimeout(onSwipeoutClose, 500);
        $buttons.each(function (buttonEl) {
          var $buttonEl = $(buttonEl);

          if (side === 'right') {
            $buttonEl.transform("translate3d(" + -buttonEl.offsetLeft + "px,0,0)");
          } else {
            $buttonEl.transform("translate3d(" + (swipeoutActionsWidth - buttonEl.offsetWidth - buttonEl.offsetLeft) + "px,0,0)");
          }

          $buttonEl.css({
            left: '0px'
          }).removeClass('swipeout-overswipe-active');
        });
        if (Swipeout.el && Swipeout.el === $el[0]) Swipeout.el = undefined;
      },
      delete: function _delete(el, callback) {
        var app = this;
        var $el = $(el).eq(0);
        if ($el.length === 0) return;
        Swipeout.el = undefined;
        $el.trigger('swipeout:delete');
        app.emit('swipeoutDelete', $el[0]);
        $el.css({
          height: $el.outerHeight() + "px"
        });
        $el.transitionEnd(function () {
          $el.trigger('swipeout:deleted');
          app.emit('swipeoutDeleted', $el[0]);
          if (callback) callback.call($el[0]);

          if ($el.parents('.virtual-list').length > 0) {
            var virtualList = $el.parents('.virtual-list')[0].f7VirtualList;
            var virtualIndex = $el[0].f7VirtualListIndex;
            if (virtualList && typeof virtualIndex !== 'undefined') virtualList.deleteItem(virtualIndex);
          } else if (app.params.swipeout.removeElements) {
            if (app.params.swipeout.removeElementsWithTimeout) {
              setTimeout(function () {
                $el.remove();
              }, app.params.swipeout.removeElementsTimeout);
            } else {
              $el.remove();
            }
          } else {
            $el.removeClass('swipeout-deleting swipeout-transitioning');
          }
        }); // eslint-disable-next-line
        // $el[0]._clientLeft = $el[0].clientLeft;

        nextFrame$1(function () {
          $el.addClass('swipeout-deleting swipeout-transitioning').css({
            height: '0px'
          }).find('.swipeout-content').transform('translate3d(-100%,0,0)');
        });
      }
    };
    var Swipeout$1 = {
      name: 'swipeout',
      params: {
        swipeout: {
          actionsNoFold: false,
          noFollow: false,
          removeElements: true,
          removeElementsWithTimeout: false,
          removeElementsTimeout: 0,
          overswipeRatio: 1.2
        }
      },
      create: function create() {
        var app = this;
        bindMethods(app, {
          swipeout: Swipeout
        });
      },
      clicks: {
        '.swipeout-open': function openSwipeout($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.swipeout.open(data.swipeout, data.side);
        },
        '.swipeout-close': function closeSwipeout($clickedEl) {
          var app = this;
          var $swipeoutEl = $clickedEl.closest('.swipeout');
          if ($swipeoutEl.length === 0) return;
          app.swipeout.close($swipeoutEl);
        },
        '.swipeout-delete': function deleteSwipeout($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          var $swipeoutEl = $clickedEl.closest('.swipeout');
          if ($swipeoutEl.length === 0) return;
          var _data = data,
              confirm = _data.confirm,
              confirmTitle = _data.confirmTitle;

          if (data.confirm) {
            app.dialog.confirm(confirm, confirmTitle, function () {
              app.swipeout.delete($swipeoutEl);
            });
          } else {
            app.swipeout.delete($swipeoutEl);
          }
        }
      },
      on: {
        init: function init() {
          var app = this;
          if (!app.params.swipeout) return;
          app.swipeout.init();
        }
      }
    };

    var Accordion = {
      toggleClicked: function toggleClicked($clickedEl) {
        var app = this;
        var $accordionItemEl = $clickedEl.closest('.accordion-item').eq(0);
        if (!$accordionItemEl.length) $accordionItemEl = $clickedEl.parents('li').eq(0);
        var $accordionContent = $clickedEl.parents('.accordion-item-content').eq(0);

        if ($accordionContent.length) {
          if ($accordionContent.parents($accordionItemEl).length) return;
        }

        if ($clickedEl.parents('li').length > 1 && $clickedEl.parents('li')[0] !== $accordionItemEl[0]) return;
        app.accordion.toggle($accordionItemEl);
      },
      open: function open(el) {
        var app = this;
        var $el = $(el);
        var prevented = false;

        function prevent() {
          prevented = true;
        }

        $el.trigger('accordion:beforeopen', {
          prevent: prevent
        }, prevent);
        app.emit('accordionBeforeOpen', $el[0], prevent);
        if (prevented) return;
        var $list = $el.parents('.accordion-list').eq(0);
        var $contentEl = $el.children('.accordion-item-content');
        $contentEl.removeAttr('aria-hidden');
        if ($contentEl.length === 0) $contentEl = $el.find('.accordion-item-content');
        if ($contentEl.length === 0) return;
        var $openedItem = $list.length > 0 && $el.parent().children('.accordion-item-opened');

        if ($openedItem.length > 0) {
          app.accordion.close($openedItem);
        }

        $contentEl.transitionEnd(function () {
          if ($el.hasClass('accordion-item-opened')) {
            $contentEl.transition(0);
            $contentEl.css('height', 'auto');
            nextFrame$1(function () {
              $contentEl.transition('');
              $el.trigger('accordion:opened');
              app.emit('accordionOpened', $el[0]);
            });
          } else {
            $contentEl.css('height', '');
            $el.trigger('accordion:closed');
            app.emit('accordionClosed', $el[0]);
          }
        });
        $contentEl.css('height', $contentEl[0].scrollHeight + "px");
        $el.trigger('accordion:open');
        $el.addClass('accordion-item-opened');
        app.emit('accordionOpen', $el[0]);
      },
      close: function close(el) {
        var app = this;
        var $el = $(el);
        var prevented = false;

        function prevent() {
          prevented = true;
        }

        $el.trigger('accordion:beforeclose', {
          prevent: prevent
        }, prevent);
        app.emit('accordionBeforeClose', $el[0], prevent);
        if (prevented) return;
        var $contentEl = $el.children('.accordion-item-content');
        if ($contentEl.length === 0) $contentEl = $el.find('.accordion-item-content');
        $el.removeClass('accordion-item-opened');
        $contentEl.attr('aria-hidden', true);
        $contentEl.transition(0);
        $contentEl.css('height', $contentEl[0].scrollHeight + "px"); // Close

        $contentEl.transitionEnd(function () {
          if ($el.hasClass('accordion-item-opened')) {
            $contentEl.transition(0);
            $contentEl.css('height', 'auto');
            nextFrame$1(function () {
              $contentEl.transition('');
              $el.trigger('accordion:opened');
              app.emit('accordionOpened', $el[0]);
            });
          } else {
            $contentEl.css('height', '');
            $el.trigger('accordion:closed');
            app.emit('accordionClosed', $el[0]);
          }
        });
        nextFrame$1(function () {
          $contentEl.transition('');
          $contentEl.css('height', '');
          $el.trigger('accordion:close');
          app.emit('accordionClose', $el[0]);
        });
      },
      toggle: function toggle(el) {
        var app = this;
        var $el = $(el);
        if ($el.length === 0) return;
        if ($el.hasClass('accordion-item-opened')) app.accordion.close(el);else app.accordion.open(el);
      }
    };
    var Accordion$1 = {
      name: 'accordion',
      create: function create() {
        var app = this;
        bindMethods(app, {
          accordion: Accordion
        });
      },
      clicks: {
        '.accordion-item .item-link, .accordion-item-toggle, .links-list.accordion-list > ul > li > a': function open($clickedEl) {
          var app = this;
          Accordion.toggleClicked.call(app, $clickedEl);
        }
      }
    };

    var ContactsList = {
      name: 'contactsList'
    };

    var VirtualList$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(VirtualList, _Framework7Class);

      function VirtualList(app, params) {
        var _this;

        if (params === void 0) {
          params = {};
        }

        _this = _Framework7Class.call(this, params, [app]) || this;

        var vl = _assertThisInitialized(_this);

        var device = getDevice$1();
        var document = getDocument();
        var defaultHeight;

        if (app.theme === 'md') {
          defaultHeight = 48;
        } else if (app.theme === 'ios') {
          defaultHeight = 44;
        } else if (app.theme === 'aurora') {
          defaultHeight = 38;
        }

        var defaults = {
          cols: 1,
          height: defaultHeight,
          cache: true,
          dynamicHeightBufferSize: 1,
          showFilteredItemsOnly: false,
          renderExternal: undefined,
          setListHeight: true,
          searchByItem: undefined,
          searchAll: undefined,
          ul: null,
          createUl: true,
          scrollableParentEl: undefined,
          renderItem: function renderItem(item) {
            return ("\n          <li>\n            <div class=\"item-content\">\n              <div class=\"item-inner\">\n                <div class=\"item-title\">" + item + "</div>\n              </div>\n            </div>\n          </li>\n        ").trim();
          },
          on: {}
        }; // Extend defaults with modules params

        vl.useModulesParams(defaults);
        vl.params = extend$1(defaults, params);

        if (vl.params.height === undefined || !vl.params.height) {
          vl.params.height = defaultHeight;
        }

        vl.$el = $(params.el);
        vl.el = vl.$el[0];
        if (vl.$el.length === 0) return undefined || _assertThisInitialized(_this);
        vl.$el[0].f7VirtualList = vl;
        vl.items = vl.params.items;

        if (vl.params.showFilteredItemsOnly) {
          vl.filteredItems = [];
        }

        if (vl.params.renderItem) {
          vl.renderItem = vl.params.renderItem;
        }

        vl.$pageContentEl = vl.$el.parents('.page-content');
        vl.pageContentEl = vl.$pageContentEl[0];
        vl.$scrollableParentEl = vl.params.scrollableParentEl ? $(vl.params.scrollableParentEl).eq(0) : vl.$pageContentEl;

        if (!vl.$scrollableParentEl.length && vl.$pageContentEl.length) {
          vl.$scrollableParentEl = vl.$pageContentEl;
        }

        vl.scrollableParentEl = vl.$scrollableParentEl[0]; // Bad scroll

        if (typeof vl.params.updatableScroll !== 'undefined') {
          vl.updatableScroll = vl.params.updatableScroll;
        } else {
          vl.updatableScroll = true;

          if (device.ios && device.osVersion.split('.')[0] < 8) {
            vl.updatableScroll = false;
          }
        } // Append <ul>


        var ul = vl.params.ul;
        vl.$ul = ul ? $(vl.params.ul) : vl.$el.children('ul');

        if (vl.$ul.length === 0 && vl.params.createUl) {
          vl.$el.append('<ul></ul>');
          vl.$ul = vl.$el.children('ul');
        }

        vl.ul = vl.$ul[0];
        var $itemsWrapEl;
        if (!vl.ul && !vl.params.createUl) $itemsWrapEl = vl.$el;else $itemsWrapEl = vl.$ul;
        extend$1(vl, {
          $itemsWrapEl: $itemsWrapEl,
          itemsWrapEl: $itemsWrapEl[0],
          // DOM cached items
          domCache: {},
          displayDomCache: {},
          // Temporary DOM Element
          tempDomElement: document.createElement('ul'),
          // Last repain position
          lastRepaintY: null,
          // Fragment
          fragment: document.createDocumentFragment(),
          // Props
          pageHeight: undefined,
          rowsPerScreen: undefined,
          rowsBefore: undefined,
          rowsAfter: undefined,
          rowsToRender: undefined,
          maxBufferHeight: 0,
          listHeight: undefined,
          dynamicHeight: typeof vl.params.height === 'function'
        }); // Install Modules

        vl.useModules(); // Attach events

        var handleScrollBound = vl.handleScroll.bind(vl);
        var handleResizeBound = vl.handleResize.bind(vl);
        var $pageEl;
        var $tabEl;
        var $panelEl;
        var $popupEl;

        vl.attachEvents = function attachEvents() {
          $pageEl = vl.$el.parents('.page').eq(0);
          $tabEl = vl.$el.parents('.tab').filter(function (tabEl) {
            return $(tabEl).parent('.tabs').parent('.tabs-animated-wrap, .tabs-swipeable-wrap').length === 0;
          }).eq(0);
          $panelEl = vl.$el.parents('.panel').eq(0);
          $popupEl = vl.$el.parents('.popup').eq(0);
          vl.$scrollableParentEl.on('scroll', handleScrollBound);
          if ($pageEl.length) $pageEl.on('page:reinit', handleResizeBound);
          if ($tabEl.length) $tabEl.on('tab:show', handleResizeBound);
          if ($panelEl.length) $panelEl.on('panel:open', handleResizeBound);
          if ($popupEl.length) $popupEl.on('popup:open', handleResizeBound);
          app.on('resize', handleResizeBound);
        };

        vl.detachEvents = function attachEvents() {
          vl.$scrollableParentEl.off('scroll', handleScrollBound);
          if ($pageEl.length) $pageEl.off('page:reinit', handleResizeBound);
          if ($tabEl.length) $tabEl.off('tab:show', handleResizeBound);
          if ($panelEl.length) $panelEl.off('panel:open', handleResizeBound);
          if ($popupEl.length) $popupEl.off('popup:open', handleResizeBound);
          app.off('resize', handleResizeBound);
        }; // Init


        vl.init();
        return vl || _assertThisInitialized(_this);
      }

      var _proto = VirtualList.prototype;

      _proto.setListSize = function setListSize() {
        var vl = this;
        var items = vl.filteredItems || vl.items;
        vl.pageHeight = vl.$scrollableParentEl[0].offsetHeight;

        if (vl.dynamicHeight) {
          vl.listHeight = 0;
          vl.heights = [];

          for (var i = 0; i < items.length; i += 1) {
            var itemHeight = vl.params.height(items[i]);
            vl.listHeight += itemHeight;
            vl.heights.push(itemHeight);
          }
        } else {
          vl.listHeight = Math.ceil(items.length / vl.params.cols) * vl.params.height;
          vl.rowsPerScreen = Math.ceil(vl.pageHeight / vl.params.height);
          vl.rowsBefore = vl.params.rowsBefore || vl.rowsPerScreen * 2;
          vl.rowsAfter = vl.params.rowsAfter || vl.rowsPerScreen;
          vl.rowsToRender = vl.rowsPerScreen + vl.rowsBefore + vl.rowsAfter;
          vl.maxBufferHeight = vl.rowsBefore / 2 * vl.params.height;
        }

        if (vl.updatableScroll || vl.params.setListHeight) {
          vl.$itemsWrapEl.css({
            height: vl.listHeight + "px"
          });
        }
      };

      _proto.render = function render(force, forceScrollTop) {
        var vl = this;
        if (force) vl.lastRepaintY = null;
        var scrollTop = -(vl.$el[0].getBoundingClientRect().top - vl.$scrollableParentEl[0].getBoundingClientRect().top);
        if (typeof forceScrollTop !== 'undefined') scrollTop = forceScrollTop;

        if (vl.lastRepaintY === null || Math.abs(scrollTop - vl.lastRepaintY) > vl.maxBufferHeight || !vl.updatableScroll && vl.$scrollableParentEl[0].scrollTop + vl.pageHeight >= vl.$scrollableParentEl[0].scrollHeight) {
          vl.lastRepaintY = scrollTop;
        } else {
          return;
        }

        var items = vl.filteredItems || vl.items;
        var fromIndex;
        var toIndex;
        var heightBeforeFirstItem = 0;
        var heightBeforeLastItem = 0;

        if (vl.dynamicHeight) {
          var itemTop = 0;
          var itemHeight;
          vl.maxBufferHeight = vl.pageHeight;

          for (var j = 0; j < vl.heights.length; j += 1) {
            itemHeight = vl.heights[j];

            if (typeof fromIndex === 'undefined') {
              if (itemTop + itemHeight >= scrollTop - vl.pageHeight * 2 * vl.params.dynamicHeightBufferSize) fromIndex = j;else heightBeforeFirstItem += itemHeight;
            }

            if (typeof toIndex === 'undefined') {
              if (itemTop + itemHeight >= scrollTop + vl.pageHeight * 2 * vl.params.dynamicHeightBufferSize || j === vl.heights.length - 1) toIndex = j + 1;
              heightBeforeLastItem += itemHeight;
            }

            itemTop += itemHeight;
          }

          toIndex = Math.min(toIndex, items.length);
        } else {
          fromIndex = (parseInt(scrollTop / vl.params.height, 10) - vl.rowsBefore) * vl.params.cols;

          if (fromIndex < 0) {
            fromIndex = 0;
          }

          toIndex = Math.min(fromIndex + vl.rowsToRender * vl.params.cols, items.length);
        }

        var topPosition;
        var renderExternalItems = [];
        vl.reachEnd = false;
        var i;

        for (i = fromIndex; i < toIndex; i += 1) {
          var itemEl = void 0; // Define real item index

          var index = vl.items.indexOf(items[i]);
          if (i === fromIndex) vl.currentFromIndex = index;
          if (i === toIndex - 1) vl.currentToIndex = index;

          if (vl.filteredItems) {
            if (vl.items[index] === vl.filteredItems[vl.filteredItems.length - 1]) vl.reachEnd = true;
          } else if (index === vl.items.length - 1) vl.reachEnd = true; // Find items


          if (vl.params.renderExternal) {
            renderExternalItems.push(items[i]);
          } else if (vl.domCache[index]) {
            itemEl = vl.domCache[index];
            itemEl.f7VirtualListIndex = index;
          } else {
            if (vl.renderItem) {
              vl.tempDomElement.innerHTML = vl.renderItem(items[i], index).trim();
            } else {
              vl.tempDomElement.innerHTML = items[i].toString().trim();
            }

            itemEl = vl.tempDomElement.childNodes[0];
            if (vl.params.cache) vl.domCache[index] = itemEl;
            itemEl.f7VirtualListIndex = index;
          } // Set item top position


          if (i === fromIndex) {
            if (vl.dynamicHeight) {
              topPosition = heightBeforeFirstItem;
            } else {
              topPosition = i * vl.params.height / vl.params.cols;
            }
          }

          if (!vl.params.renderExternal) {
            itemEl.style.top = topPosition + "px"; // Before item insert

            vl.emit('local::itemBeforeInsert vlItemBeforeInsert', vl, itemEl, items[i]); // Append item to fragment

            vl.fragment.appendChild(itemEl);
          }
        } // Update list height with not updatable scroll


        if (!vl.updatableScroll) {
          if (vl.dynamicHeight) {
            vl.itemsWrapEl.style.height = heightBeforeLastItem + "px";
          } else {
            vl.itemsWrapEl.style.height = i * vl.params.height / vl.params.cols + "px";
          }
        } // Update list html


        if (vl.params.renderExternal) {
          if (items && items.length === 0) {
            vl.reachEnd = true;
          }
        } else {
          vl.emit('local::beforeClear vlBeforeClear', vl, vl.fragment);
          vl.itemsWrapEl.innerHTML = '';
          vl.emit('local::itemsBeforeInsert vlItemsBeforeInsert', vl, vl.fragment);

          if (items && items.length === 0) {
            vl.reachEnd = true;
            if (vl.params.emptyTemplate) vl.itemsWrapEl.innerHTML = vl.params.emptyTemplate;
          } else {
            vl.itemsWrapEl.appendChild(vl.fragment);
          }

          vl.emit('local::itemsAfterInsert vlItemsAfterInsert', vl, vl.fragment);
        }

        if (typeof forceScrollTop !== 'undefined' && force) {
          vl.$scrollableParentEl.scrollTop(forceScrollTop, 0);
        }

        if (vl.params.renderExternal) {
          vl.params.renderExternal(vl, {
            fromIndex: fromIndex,
            toIndex: toIndex,
            listHeight: vl.listHeight,
            topPosition: topPosition,
            items: renderExternalItems
          });
        }
      } // Filter
      ;

      _proto.filterItems = function filterItems(indexes, resetScrollTop) {
        if (resetScrollTop === void 0) {
          resetScrollTop = true;
        }

        var vl = this;
        vl.filteredItems = [];

        for (var i = 0; i < indexes.length; i += 1) {
          vl.filteredItems.push(vl.items[indexes[i]]);
        }

        if (resetScrollTop) {
          vl.$scrollableParentEl[0].scrollTop = 0;
        }

        vl.update();
      };

      _proto.resetFilter = function resetFilter() {
        var vl = this;

        if (vl.params.showFilteredItemsOnly) {
          vl.filteredItems = [];
        } else {
          vl.filteredItems = null;
          delete vl.filteredItems;
        }

        vl.update();
      };

      _proto.scrollToItem = function scrollToItem(index) {
        var vl = this;
        if (index > vl.items.length) return false;
        var itemTop = 0;

        if (vl.dynamicHeight) {
          for (var i = 0; i < index; i += 1) {
            itemTop += vl.heights[i];
          }
        } else {
          itemTop = index * vl.params.height;
        }

        var listTop = vl.$el[0].offsetTop;
        vl.render(true, listTop + itemTop - parseInt(vl.$scrollableParentEl.css('padding-top'), 10));
        return true;
      };

      _proto.handleScroll = function handleScroll() {
        var vl = this;
        vl.render();
      } // Handle resize event
      ;

      _proto.isVisible = function isVisible() {
        var vl = this;
        return !!(vl.el.offsetWidth || vl.el.offsetHeight || vl.el.getClientRects().length);
      };

      _proto.handleResize = function handleResize() {
        var vl = this;

        if (vl.isVisible()) {
          vl.setListSize();
          vl.render(true);
        }
      } // Append
      ;

      _proto.appendItems = function appendItems(items) {
        var vl = this;

        for (var i = 0; i < items.length; i += 1) {
          vl.items.push(items[i]);
        }

        vl.update();
      };

      _proto.appendItem = function appendItem(item) {
        var vl = this;
        vl.appendItems([item]);
      } // Replace
      ;

      _proto.replaceAllItems = function replaceAllItems(items) {
        var vl = this;
        vl.items = items;
        delete vl.filteredItems;
        vl.domCache = {};
        vl.update();
      };

      _proto.replaceItem = function replaceItem(index, item) {
        var vl = this;
        vl.items[index] = item;
        if (vl.params.cache) delete vl.domCache[index];
        vl.update();
      } // Prepend
      ;

      _proto.prependItems = function prependItems(items) {
        var vl = this;

        for (var i = items.length - 1; i >= 0; i -= 1) {
          vl.items.unshift(items[i]);
        }

        if (vl.params.cache) {
          var newCache = {};
          Object.keys(vl.domCache).forEach(function (cached) {
            newCache[parseInt(cached, 10) + items.length] = vl.domCache[cached];
          });
          vl.domCache = newCache;
        }

        vl.update();
      };

      _proto.prependItem = function prependItem(item) {
        var vl = this;
        vl.prependItems([item]);
      } // Move
      ;

      _proto.moveItem = function moveItem(from, to) {
        var vl = this;
        var fromIndex = from;
        var toIndex = to;
        if (fromIndex === toIndex) return; // remove item from array

        var item = vl.items.splice(fromIndex, 1)[0];

        if (toIndex >= vl.items.length) {
          // Add item to the end
          vl.items.push(item);
          toIndex = vl.items.length - 1;
        } else {
          // Add item to new index
          vl.items.splice(toIndex, 0, item);
        } // Update cache


        if (vl.params.cache) {
          var newCache = {};
          Object.keys(vl.domCache).forEach(function (cached) {
            var cachedIndex = parseInt(cached, 10);
            var leftIndex = fromIndex < toIndex ? fromIndex : toIndex;
            var rightIndex = fromIndex < toIndex ? toIndex : fromIndex;
            var indexShift = fromIndex < toIndex ? -1 : 1;
            if (cachedIndex < leftIndex || cachedIndex > rightIndex) newCache[cachedIndex] = vl.domCache[cachedIndex];
            if (cachedIndex === leftIndex) newCache[rightIndex] = vl.domCache[cachedIndex];
            if (cachedIndex > leftIndex && cachedIndex <= rightIndex) newCache[cachedIndex + indexShift] = vl.domCache[cachedIndex];
          });
          vl.domCache = newCache;
        }

        vl.update();
      } // Insert before
      ;

      _proto.insertItemBefore = function insertItemBefore(index, item) {
        var vl = this;

        if (index === 0) {
          vl.prependItem(item);
          return;
        }

        if (index >= vl.items.length) {
          vl.appendItem(item);
          return;
        }

        vl.items.splice(index, 0, item); // Update cache

        if (vl.params.cache) {
          var newCache = {};
          Object.keys(vl.domCache).forEach(function (cached) {
            var cachedIndex = parseInt(cached, 10);

            if (cachedIndex >= index) {
              newCache[cachedIndex + 1] = vl.domCache[cachedIndex];
            }
          });
          vl.domCache = newCache;
        }

        vl.update();
      } // Delete
      ;

      _proto.deleteItems = function deleteItems(indexes) {
        var vl = this;
        var prevIndex;
        var indexShift = 0;

        var _loop = function _loop(i) {
          var index = indexes[i];

          if (typeof prevIndex !== 'undefined') {
            if (index > prevIndex) {
              indexShift = -i;
            }
          }

          index += indexShift;
          prevIndex = indexes[i]; // Delete item

          var deletedItem = vl.items.splice(index, 1)[0]; // Delete from filtered

          if (vl.filteredItems && vl.filteredItems.indexOf(deletedItem) >= 0) {
            vl.filteredItems.splice(vl.filteredItems.indexOf(deletedItem), 1);
          } // Update cache


          if (vl.params.cache) {
            var newCache = {};
            Object.keys(vl.domCache).forEach(function (cached) {
              var cachedIndex = parseInt(cached, 10);

              if (cachedIndex === index) {
                delete vl.domCache[index];
              } else if (parseInt(cached, 10) > index) {
                newCache[cachedIndex - 1] = vl.domCache[cached];
              } else {
                newCache[cachedIndex] = vl.domCache[cached];
              }
            });
            vl.domCache = newCache;
          }
        };

        for (var i = 0; i < indexes.length; i += 1) {
          _loop(i);
        }

        vl.update();
      };

      _proto.deleteAllItems = function deleteAllItems() {
        var vl = this;
        vl.items = [];
        delete vl.filteredItems;
        if (vl.params.cache) vl.domCache = {};
        vl.update();
      };

      _proto.deleteItem = function deleteItem(index) {
        var vl = this;
        vl.deleteItems([index]);
      } // Clear cache
      ;

      _proto.clearCache = function clearCache() {
        var vl = this;
        vl.domCache = {};
      } // Update Virtual List
      ;

      _proto.update = function update(deleteCache) {
        var vl = this;

        if (deleteCache && vl.params.cache) {
          vl.domCache = {};
        }

        vl.setListSize();
        vl.render(true);
      };

      _proto.init = function init() {
        var vl = this;
        vl.attachEvents();
        vl.setListSize();
        vl.render();
      };

      _proto.destroy = function destroy() {
        var vl = this;
        vl.detachEvents();
        vl.$el[0].f7VirtualList = null;
        delete vl.$el[0].f7VirtualList;
        deleteProps$1(vl);
        vl = null;
      };

      return VirtualList;
    }(Framework7Class);

    var VirtualList = {
      name: 'virtualList',
      static: {
        VirtualList: VirtualList$1
      },
      create: function create() {
        var app = this;
        app.virtualList = ConstructorMethods({
          defaultSelector: '.virtual-list',
          constructor: VirtualList$1,
          app: app,
          domProp: 'f7VirtualList'
        });
      }
    };

    var ListIndex$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(ListIndex, _Framework7Class);

      function ListIndex(app, params) {
        var _this;

        if (params === void 0) {
          params = {};
        }

        _this = _Framework7Class.call(this, params, [app]) || this;

        var index = _assertThisInitialized(_this);

        var defaults = {
          el: null,
          // where to render indexes
          listEl: null,
          // list el to generate indexes
          indexes: 'auto',
          // or array of indexes
          iosItemHeight: 14,
          mdItemHeight: 14,
          auroraItemHeight: 14,
          scrollList: true,
          label: false,
          // eslint-disable-next-line
          renderItem: function renderItem(itemContent, itemIndex) {
            return ("\n          <li>" + itemContent + "</li>\n        ").trim();
          },
          renderSkipPlaceholder: function renderSkipPlaceholder() {
            return '<li class="list-index-skip-placeholder"></li>';
          },
          on: {}
        }; // Extend defaults with modules params

        index.useModulesParams(defaults);
        index.params = extend$1(defaults, params);
        var $el;
        var $listEl;
        var $pageContentEl;
        var $ul;

        if (index.params.el) {
          $el = $(index.params.el);
        } else {
          return index || _assertThisInitialized(_this);
        }

        if ($el[0].f7ListIndex) {
          return $el[0].f7ListIndex || _assertThisInitialized(_this);
        }

        $ul = $el.find('ul');

        if ($ul.length === 0) {
          $ul = $('<ul></ul>');
          $el.append($ul);
        }

        if (index.params.listEl) {
          $listEl = $(index.params.listEl);
        }

        if (index.params.indexes === 'auto' && !$listEl) {
          return index || _assertThisInitialized(_this);
        }

        if ($listEl) {
          $pageContentEl = $listEl.parents('.page-content').eq(0);
        } else {
          $pageContentEl = $el.siblings('.page-content').eq(0);

          if ($pageContentEl.length === 0) {
            $pageContentEl = $el.parents('.page').eq(0).find('.page-content').eq(0);
          }
        }

        $el[0].f7ListIndex = index;
        extend$1(index, {
          app: app,
          $el: $el,
          el: $el && $el[0],
          $ul: $ul,
          ul: $ul && $ul[0],
          $listEl: $listEl,
          listEl: $listEl && $listEl[0],
          $pageContentEl: $pageContentEl,
          pageContentEl: $pageContentEl && $pageContentEl[0],
          indexes: params.indexes,
          height: 0,
          skipRate: 0
        }); // Install Modules

        index.useModules(); // Attach events

        function handleResize() {
          var height = {
            index: index
          };
          index.calcSize();

          if (height !== index.height) {
            index.render();
          }
        }

        function handleClick(e) {
          var $clickedLi = $(e.target).closest('li');
          if (!$clickedLi.length) return;
          var itemIndex = $clickedLi.index();

          if (index.skipRate > 0) {
            var percentage = itemIndex / ($clickedLi.siblings('li').length - 1);
            itemIndex = Math.round((index.indexes.length - 1) * percentage);
          }

          var itemContent = index.indexes[itemIndex];
          index.$el.trigger('listindex:click', {
            content: itemContent,
            index: itemIndex
          });
          index.emit('local::click listIndexClick', index, itemContent, itemIndex);
          index.$el.trigger('listindex:select', {
            content: itemContent,
            index: itemIndex
          });
          index.emit('local::select listIndexSelect', index, itemContent, itemIndex);

          if (index.$listEl && index.params.scrollList) {
            index.scrollListToIndex(itemContent, itemIndex);
          }
        }

        var touchesStart = {};
        var isTouched;
        var isMoved;
        var topPoint;
        var bottomPoint;
        var $labelEl;
        var previousIndex = null;

        function handleTouchStart(e) {
          var $children = $ul.children();
          if (!$children.length) return;
          topPoint = $children[0].getBoundingClientRect().top;
          bottomPoint = $children[$children.length - 1].getBoundingClientRect().top + $children[0].offsetHeight;
          touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
          touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
          isTouched = true;
          isMoved = false;
          previousIndex = null;
        }

        function handleTouchMove(e) {
          if (!isTouched) return;

          if (!isMoved && index.params.label) {
            $labelEl = $('<span class="list-index-label"></span>');
            $el.append($labelEl);
          }

          isMoved = true;
          var pageY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;
          e.preventDefault();
          var percentage = (pageY - topPoint) / (bottomPoint - topPoint);
          percentage = Math.min(Math.max(percentage, 0), 1);
          var itemIndex = Math.round((index.indexes.length - 1) * percentage);
          var itemContent = index.indexes[itemIndex];
          var ulHeight = bottomPoint - topPoint;
          var bubbleBottom = (index.height - ulHeight) / 2 + (1 - percentage) * ulHeight;

          if (itemIndex !== previousIndex) {
            if (index.params.label) {
              $labelEl.html(itemContent).transform("translateY(-" + bubbleBottom + "px)");
            }

            if (index.$listEl && index.params.scrollList) {
              index.scrollListToIndex(itemContent, itemIndex);
            }
          }

          previousIndex = itemIndex;
          index.$el.trigger('listindex:select');
          index.emit('local::select listIndexSelect', index, itemContent, itemIndex);
        }

        function handleTouchEnd() {
          if (!isTouched) return;
          isTouched = false;
          isMoved = false;

          if (index.params.label) {
            if ($labelEl) $labelEl.remove();
            $labelEl = undefined;
          }
        }

        var passiveListener = getSupport$1().passiveListener ? {
          passive: true
        } : false;

        index.attachEvents = function attachEvents() {
          $el.parents('.tab').on('tab:show', handleResize);
          $el.parents('.page').on('page:reinit', handleResize);
          $el.parents('.panel').on('panel:open', handleResize);
          $el.parents('.sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast').on('modal:open', handleResize);
          app.on('resize', handleResize);
          $el.on('click', handleClick);
          $el.on(app.touchEvents.start, handleTouchStart, passiveListener);
          app.on('touchmove:active', handleTouchMove);
          app.on('touchend:passive', handleTouchEnd);
        };

        index.detachEvents = function attachEvents() {
          $el.parents('.tab').off('tab:show', handleResize);
          $el.parents('.page').off('page:reinit', handleResize);
          $el.parents('.panel').off('panel:open', handleResize);
          $el.parents('.sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast').off('modal:open', handleResize);
          app.off('resize', handleResize);
          $el.off('click', handleClick);
          $el.off(app.touchEvents.start, handleTouchStart, passiveListener);
          app.off('touchmove:active', handleTouchMove);
          app.off('touchend:passive', handleTouchEnd);
        }; // Init


        index.init();
        return index || _assertThisInitialized(_this);
      } // eslint-disable-next-line


      var _proto = ListIndex.prototype;

      _proto.scrollListToIndex = function scrollListToIndex(itemContent, itemIndex) {
        var index = this;
        var $listEl = index.$listEl,
            $pageContentEl = index.$pageContentEl,
            app = index.app;
        if (!$listEl || !$pageContentEl || $pageContentEl.length === 0) return index;
        var $scrollToEl;
        $listEl.find('.list-group-title, .item-divider').each(function (el) {
          if ($scrollToEl) return;
          var $el = $(el);

          if ($el.text() === itemContent) {
            $scrollToEl = $el;
          }
        });
        if (!$scrollToEl || $scrollToEl.length === 0) return index;
        var parentTop = $scrollToEl.parent().offset().top;
        var paddingTop = parseInt($pageContentEl.css('padding-top'), 10);
        var scrollTop = $pageContentEl[0].scrollTop;
        var scrollToElTop = $scrollToEl.offset().top;

        if ($pageContentEl.parents('.page-with-navbar-large').length) {
          var navbarInnerEl = app.navbar.getElByPage($pageContentEl.parents('.page-with-navbar-large').eq(0));
          var $titleLargeEl = $(navbarInnerEl).find('.title-large');

          if ($titleLargeEl.length) {
            paddingTop -= $titleLargeEl[0].offsetHeight || 0;
          }
        }

        if (parentTop <= paddingTop) {
          $pageContentEl.scrollTop(parentTop + scrollTop - paddingTop);
        } else {
          $pageContentEl.scrollTop(scrollToElTop + scrollTop - paddingTop);
        }

        return index;
      };

      _proto.renderSkipPlaceholder = function renderSkipPlaceholder() {
        var index = this;
        return index.params.renderSkipPlaceholder.call(index);
      };

      _proto.renderItem = function renderItem(itemContent, itemIndex) {
        var index = this;
        return index.params.renderItem.call(index, itemContent, itemIndex);
      };

      _proto.render = function render() {
        var index = this;
        var $ul = index.$ul,
            indexes = index.indexes,
            skipRate = index.skipRate;
        var wasSkipped;
        var html = indexes.map(function (itemContent, itemIndex) {
          if (itemIndex % skipRate !== 0 && skipRate > 0) {
            wasSkipped = true;
            return '';
          }

          var itemHtml = index.renderItem(itemContent, itemIndex);

          if (wasSkipped) {
            itemHtml = index.renderSkipPlaceholder() + itemHtml;
          }

          wasSkipped = false;
          return itemHtml;
        }).join('');
        $ul.html(html);
        return index;
      };

      _proto.calcSize = function calcSize() {
        var index = this;
        var app = index.app,
            params = index.params,
            el = index.el,
            indexes = index.indexes;
        var height = el.offsetHeight;
        var itemHeight = params[app.theme + "ItemHeight"];
        var maxItems = Math.floor(height / itemHeight);
        var items = indexes.length;
        var skipRate = 0;

        if (items > maxItems) {
          skipRate = Math.ceil((items * 2 - 1) / maxItems);
        }

        index.height = height;
        index.skipRate = skipRate;
        return index;
      };

      _proto.calcIndexes = function calcIndexes() {
        var index = this;

        if (index.params.indexes === 'auto') {
          index.indexes = [];
          index.$listEl.find('.list-group-title, .item-divider').each(function (el) {
            var elContent = $(el).text();

            if (index.indexes.indexOf(elContent) < 0) {
              index.indexes.push(elContent);
            }
          });
        } else {
          index.indexes = index.params.indexes;
        }

        return index;
      };

      _proto.update = function update() {
        var index = this;
        index.calcIndexes();
        index.calcSize();
        index.render();
        return index;
      };

      _proto.init = function init() {
        var index = this;
        index.calcIndexes();
        index.calcSize();
        index.render();
        index.attachEvents();
      };

      _proto.destroy = function destroy() {
        var index = this;
        index.$el.trigger('listindex:beforedestroy', index);
        index.emit('local::beforeDestroy listIndexBeforeDestroy');
        index.detachEvents();

        if (index.$el[0]) {
          index.$el[0].f7ListIndex = null;
          delete index.$el[0].f7ListIndex;
        }

        deleteProps$1(index);
        index = null;
      };

      return ListIndex;
    }(Framework7Class);

    var ListIndex = {
      name: 'listIndex',
      static: {
        ListIndex: ListIndex$1
      },
      create: function create() {
        var app = this;
        app.listIndex = ConstructorMethods({
          defaultSelector: '.list-index',
          constructor: ListIndex$1,
          app: app,
          domProp: 'f7ListIndex'
        });
      },
      on: {
        tabMounted: function tabMounted(tabEl) {
          var app = this;
          $(tabEl).find('.list-index-init').each(function (listIndexEl) {
            var params = extend$1($(listIndexEl).dataset(), {
              el: listIndexEl
            });
            app.listIndex.create(params);
          });
        },
        tabBeforeRemove: function tabBeforeRemove(tabEl) {
          $(tabEl).find('.list-index-init').each(function (listIndexEl) {
            if (listIndexEl.f7ListIndex) listIndexEl.f7ListIndex.destroy();
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.list-index-init').each(function (listIndexEl) {
            var params = extend$1($(listIndexEl).dataset(), {
              el: listIndexEl
            });
            app.listIndex.create(params);
          });
        },
        pageBeforeRemove: function pageBeforeRemove(page) {
          page.$el.find('.list-index-init').each(function (listIndexEl) {
            if (listIndexEl.f7ListIndex) listIndexEl.f7ListIndex.destroy();
          });
        }
      },
      vnode: {
        'list-index-init': {
          insert: function insert(vnode) {
            var app = this;
            var listIndexEl = vnode.elm;
            var params = extend$1($(listIndexEl).dataset(), {
              el: listIndexEl
            });
            app.listIndex.create(params);
          },
          destroy: function destroy(vnode) {
            var listIndexEl = vnode.elm;
            if (listIndexEl.f7ListIndex) listIndexEl.f7ListIndex.destroy();
          }
        }
      }
    };

    var Timeline = {
      name: 'timeline'
    };

    var Tab = {
      show: function show() {
        var app = this;
        var tabEl;
        var tabLinkEl;
        var animate;
        var tabRoute;
        var animatedInit;

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        if (args.length === 1 && args[0] && args[0].constructor === Object) {
          tabEl = args[0].tabEl;
          tabLinkEl = args[0].tabLinkEl;
          animate = args[0].animate;
          tabRoute = args[0].tabRoute;
          animatedInit = args[0].animatedInit;
        } else {
          tabEl = args[0];
          tabLinkEl = args[1];
          animate = args[2];
          tabRoute = args[3];

          if (typeof args[1] === 'boolean') {
            tabEl = args[0];
            animate = args[1];
            tabLinkEl = args[2];
            tabRoute = args[3];

            if (args.length > 2 && tabLinkEl.constructor === Object) {
              tabEl = args[0];
              animate = args[1];
              tabRoute = args[2];
              tabLinkEl = args[3];
            }
          }
        }

        if (typeof animate === 'undefined') animate = true;
        var $newTabEl = $(tabEl);

        if (tabRoute && $newTabEl[0]) {
          $newTabEl[0].f7TabRoute = tabRoute;
        }

        if (!animatedInit && ($newTabEl.length === 0 || $newTabEl.hasClass('tab-active'))) {
          return {
            $newTabEl: $newTabEl,
            newTabEl: $newTabEl[0]
          };
        }

        var $tabLinkEl;
        if (tabLinkEl) $tabLinkEl = $(tabLinkEl);
        var $tabsEl = $newTabEl.parent('.tabs');

        if ($tabsEl.length === 0) {
          return {
            $newTabEl: $newTabEl,
            newTabEl: $newTabEl[0]
          };
        } // Release swipeouts in hidden tabs


        if (app.swipeout) app.swipeout.allowOpen = true; // Animated tabs

        var tabsChangedCallbacks = [];

        function onTabsChanged(callback) {
          tabsChangedCallbacks.push(callback);
        }

        function tabsChanged() {
          tabsChangedCallbacks.forEach(function (callback) {
            callback();
          });
        }

        var animated = false;

        if ($tabsEl.parent().hasClass('tabs-animated-wrap')) {
          $tabsEl.parent()[animate ? 'removeClass' : 'addClass']('not-animated');
          var transitionDuration = parseFloat($tabsEl.css('transition-duration').replace(',', '.'));

          if (animate && transitionDuration) {
            $tabsEl.transitionEnd(tabsChanged);
            animated = true;
          }

          var tabsTranslate = (app.rtl ? $newTabEl.index() : -$newTabEl.index()) * 100;
          $tabsEl.transform("translate3d(" + tabsTranslate + "%,0,0)");
        } // Swipeable tabs


        var swiper;

        if ($tabsEl.parent().hasClass('tabs-swipeable-wrap') && app.swiper) {
          swiper = $tabsEl.parent()[0].swiper;

          if (swiper && swiper.activeIndex !== $newTabEl.index()) {
            animated = true;
            swiper.once('slideChangeTransitionEnd', function () {
              tabsChanged();
            }).slideTo($newTabEl.index(), animate ? undefined : 0);
          } else if (swiper && swiper.animating) {
            animated = true;
            swiper.once('slideChangeTransitionEnd', function () {
              tabsChanged();
            });
          }
        } // Remove active class from old tabs


        var $oldTabEl = $tabsEl.children('.tab-active');
        $oldTabEl.removeClass('tab-active');

        if (!animatedInit && (!swiper || swiper && !swiper.animating || swiper && tabRoute)) {
          if ($oldTabEl.hasClass('view') && $oldTabEl.children('.page').length) {
            $oldTabEl.children('.page').each(function (pageEl) {
              $(pageEl).trigger('page:tabhide');
              app.emit('pageTabHide', pageEl);
            });
          }

          $oldTabEl.trigger('tab:hide');
          app.emit('tabHide', $oldTabEl[0]);
        } // Trigger 'show' event on new tab


        $newTabEl.addClass('tab-active');

        if (!animatedInit && (!swiper || swiper && !swiper.animating || swiper && tabRoute)) {
          if ($newTabEl.hasClass('view') && $newTabEl.children('.page').length) {
            $newTabEl.children('.page').each(function (pageEl) {
              $(pageEl).trigger('page:tabshow');
              app.emit('pageTabShow', pageEl);
            });
          }

          $newTabEl.trigger('tab:show');
          app.emit('tabShow', $newTabEl[0]);
        } // Find related link for new tab


        if (!$tabLinkEl) {
          // Search by id
          if (typeof tabEl === 'string') $tabLinkEl = $(".tab-link[href=\"" + tabEl + "\"]");else $tabLinkEl = $(".tab-link[href=\"#" + $newTabEl.attr('id') + "\"]"); // Search by data-tab

          if (!$tabLinkEl || $tabLinkEl && $tabLinkEl.length === 0) {
            $('[data-tab]').each(function (el) {
              if ($newTabEl.is($(el).attr('data-tab'))) $tabLinkEl = $(el);
            });
          }

          if (tabRoute && (!$tabLinkEl || $tabLinkEl && $tabLinkEl.length === 0)) {
            $tabLinkEl = $("[data-route-tab-id=\"" + tabRoute.route.tab.id + "\"]");

            if ($tabLinkEl.length === 0) {
              $tabLinkEl = $(".tab-link[href=\"" + tabRoute.url + "\"]");
            }
          }

          if ($tabLinkEl.length > 1 && $newTabEl.parents('.page').length) {
            // eslint-disable-next-line
            $tabLinkEl = $tabLinkEl.filter(function (tabLinkElement) {
              return $(tabLinkElement).parents('.page')[0] === $newTabEl.parents('.page')[0];
            });

            if (app.theme === 'ios' && $tabLinkEl.length === 0 && tabRoute) {
              var $pageEl = $newTabEl.parents('.page');
              var $navbarEl = $(app.navbar.getElByPage($pageEl));
              $tabLinkEl = $navbarEl.find("[data-route-tab-id=\"" + tabRoute.route.tab.id + "\"]");

              if ($tabLinkEl.length === 0) {
                $tabLinkEl = $navbarEl.find(".tab-link[href=\"" + tabRoute.url + "\"]");
              }
            }
          }
        }

        if ($tabLinkEl.length > 0) {
          // Find related link for old tab
          var $oldTabLinkEl;

          if ($oldTabEl && $oldTabEl.length > 0) {
            // Search by id
            var oldTabId = $oldTabEl.attr('id');

            if (oldTabId) {
              $oldTabLinkEl = $(".tab-link[href=\"#" + oldTabId + "\"]"); // Search by data-route-tab-id

              if (!$oldTabLinkEl || $oldTabLinkEl && $oldTabLinkEl.length === 0) {
                $oldTabLinkEl = $(".tab-link[data-route-tab-id=\"" + oldTabId + "\"]");
              }
            } // Search by data-tab


            if (!$oldTabLinkEl || $oldTabLinkEl && $oldTabLinkEl.length === 0) {
              $('[data-tab]').each(function (tabLinkElement) {
                if ($oldTabEl.is($(tabLinkElement).attr('data-tab'))) $oldTabLinkEl = $(tabLinkElement);
              });
            }

            if (!$oldTabLinkEl || $oldTabLinkEl && $oldTabLinkEl.length === 0) {
              $oldTabLinkEl = $tabLinkEl.siblings('.tab-link-active');
            }
          } else if (tabRoute) {
            $oldTabLinkEl = $tabLinkEl.siblings('.tab-link-active');
          }

          if ($oldTabLinkEl && $oldTabLinkEl.length > 1 && $oldTabEl && $oldTabEl.parents('.page').length) {
            // eslint-disable-next-line
            $oldTabLinkEl = $oldTabLinkEl.filter(function (tabLinkElement) {
              return $(tabLinkElement).parents('.page')[0] === $oldTabEl.parents('.page')[0];
            });
          }

          if ($oldTabLinkEl && $oldTabLinkEl.length > 0) $oldTabLinkEl.removeClass('tab-link-active'); // Update links' classes

          if ($tabLinkEl && $tabLinkEl.length > 0) {
            $tabLinkEl.addClass('tab-link-active'); // Material Highlight

            var $tabbarEl = $tabLinkEl.parents('.tabbar, .tabbar-labels');
            var hasHighlight = app.toolbar && $tabbarEl.length > 0 && ($tabbarEl.hasClass('tabbar-highlight') || app.theme !== 'ios');

            if (hasHighlight) {
              app.toolbar.setHighlight($tabbarEl);
            }
          }
        }

        return {
          $newTabEl: $newTabEl,
          newTabEl: $newTabEl[0],
          $oldTabEl: $oldTabEl,
          oldTabEl: $oldTabEl[0],
          onTabsChanged: onTabsChanged,
          animated: animated
        };
      }
    };
    var Tabs = {
      name: 'tabs',
      create: function create() {
        var app = this;
        extend$1(app, {
          tab: {
            show: Tab.show.bind(app)
          }
        });
      },
      on: {
        'pageInit tabMounted': function onInit(pageOrTabEl) {
          var $el = $(pageOrTabEl.el || pageOrTabEl);
          var animatedTabEl = $el.find('.tabs-animated-wrap > .tabs > .tab-active')[0];
          if (!animatedTabEl) return;
          var app = this;
          app.tab.show({
            tabEl: animatedTabEl,
            animatedInit: true,
            animate: false
          });
        }
      },
      clicks: {
        '.tab-link': function tabLinkClick($clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          if ($clickedEl.attr('href') && $clickedEl.attr('href').indexOf('#') === 0 || $clickedEl.attr('data-tab')) {
            var app = this;
            app.tab.show({
              tabEl: data.tab || $clickedEl.attr('href'),
              tabLinkEl: $clickedEl,
              animate: data.animate
            });
          }
        }
      }
    };

    function swipePanel(panel) {
      var app = panel.app;

      if (panel.swipeInitialized) {
        return;
      }

      extend$1(panel, {
        swipeable: true,
        swipeInitialized: true
      });
      var params = panel.params;
      var $el = panel.$el,
          $backdropEl = panel.$backdropEl,
          side = panel.side,
          effect = panel.effect;
      var otherPanel;
      var isTouched;
      var isGestureStarted;
      var isMoved;
      var isScrolling;
      var isInterrupted;
      var touchesStart = {};
      var touchStartTime;
      var touchesDiff;
      var translate;
      var backdropOpacity;
      var panelWidth;
      var direction;
      var $viewEl;
      var touchMoves = 0;

      function handleTouchStart(e) {
        if (!panel.swipeable || isGestureStarted) return;
        if (!app.panel.allowOpen || !params.swipe && !params.swipeOnlyClose || isTouched) return;
        if ($('.modal-in:not(.toast):not(.notification), .photo-browser-in').length > 0) return;
        otherPanel = app.panel.get(side === 'left' ? 'right' : 'left') || {};
        var otherPanelOpened = otherPanel.opened && otherPanel.$el && !otherPanel.$el.hasClass('panel-in-breakpoint');

        if (!panel.opened && otherPanelOpened) {
          return;
        }

        if (!params.swipeOnlyClose) {
          if (otherPanelOpened) return;
        }

        if (e.target && e.target.nodeName.toLowerCase() === 'input' && e.target.type === 'range') return;
        if ($(e.target).closest('.range-slider, .tabs-swipeable-wrap, .calendar-months, .no-swipe-panel, .card-opened').length > 0) return;
        touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
        touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;

        if (params.swipeOnlyClose && !panel.opened) {
          return;
        }

        if (params.swipeActiveArea && !panel.opened) {
          if (side === 'left') {
            if (touchesStart.x > params.swipeActiveArea) return;
          }

          if (side === 'right') {
            if (touchesStart.x < app.width - params.swipeActiveArea) return;
          }
        }

        touchMoves = 0;
        $viewEl = $(panel.getViewEl());
        isMoved = false;
        isTouched = true;
        isScrolling = undefined;
        isInterrupted = false;
        touchStartTime = now$1();
        direction = undefined;
      }

      function handleTouchMove(e) {
        if (!isTouched || isGestureStarted || isInterrupted) return;
        touchMoves += 1;
        if (touchMoves < 2) return;

        if (e.f7PreventSwipePanel || app.preventSwipePanelBySwipeBack || app.preventSwipePanel) {
          isTouched = false;
          return;
        }

        var pageX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
        var pageY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

        if (typeof isScrolling === 'undefined') {
          isScrolling = !!(isScrolling || Math.abs(pageY - touchesStart.y) > Math.abs(pageX - touchesStart.x));
        }

        if (isScrolling) {
          isTouched = false;
          return;
        }

        if (!direction) {
          if (pageX > touchesStart.x) {
            direction = 'to-right';
          } else {
            direction = 'to-left';
          }

          if (params.swipeActiveArea > 0 && !panel.opened) {
            if (side === 'left' && touchesStart.x > params.swipeActiveArea) {
              isTouched = false;
              return;
            }

            if (side === 'right' && touchesStart.x < app.width - params.swipeActiveArea) {
              isTouched = false;
              return;
            }
          }

          if ($el.hasClass('panel-in-breakpoint')) {
            isTouched = false;
            return;
          }

          if (side === 'left' && direction === 'to-left' && !$el.hasClass('panel-in') || side === 'right' && direction === 'to-right' && !$el.hasClass('panel-in')) {
            isTouched = false;
            return;
          }
        }

        var threshold = panel.opened ? 0 : -params.swipeThreshold;
        if (side === 'right') threshold = -threshold;

        if (!isMoved) {
          if (!panel.opened) {
            panel.insertToRoot();
            $el.addClass('panel-in-swipe');
            $backdropEl.css('visibility', 'visible');
            $el.trigger('panel:swipeopen');
            panel.emit('local::swipeOpen panelSwipeOpen', panel);
          }

          panelWidth = $el[0].offsetWidth;

          if (effect === 'reveal' && $el.hasClass('panel-in-collapsed')) {
            panelWidth -= parseFloat($viewEl.css("margin-" + side));
          }

          $el.transition(0);
        }

        isMoved = true;

        if (e.cancelable) {
          e.preventDefault();
        }

        touchesDiff = pageX - touchesStart.x + threshold;

        if (side === 'right') {
          if (effect === 'cover' || effect === 'push') {
            translate = touchesDiff + (panel.opened ? 0 : panelWidth);
            if (translate < 0) translate = 0;

            if (translate > panelWidth) {
              translate = panelWidth;
            }
          } else {
            translate = touchesDiff - (panel.opened ? panelWidth : 0);
            if (translate > 0) translate = 0;

            if (translate < -panelWidth) {
              translate = -panelWidth;
            }
          }
        } else {
          translate = touchesDiff + (panel.opened ? panelWidth : 0);
          if (translate < 0) translate = 0;

          if (translate > panelWidth) {
            translate = panelWidth;
          }
        }

        var noFollowProgress = Math.abs(translate / panelWidth);

        if (effect === 'reveal') {
          if (!params.swipeNoFollow) {
            $viewEl.transform("translate3d(" + translate + "px,0,0)").transition(0);
            $backdropEl.transform("translate3d(" + translate + "px,0,0)").transition(0);
          }

          $el.trigger('panel:swipe', Math.abs(translate / panelWidth));
          panel.emit('local::swipe panelSwipe', panel, Math.abs(translate / panelWidth));
        } else {
          if (side === 'left') translate -= panelWidth;

          if (!params.swipeNoFollow) {
            $backdropEl.transition(0);
            backdropOpacity = 1 - Math.abs(translate / panelWidth);
            $backdropEl.css({
              opacity: backdropOpacity
            });
            $el.transform("translate3d(" + translate + "px,0,0)").transition(0);

            if (effect === 'push') {
              var viewTranslate = side === 'left' ? translate + panelWidth : translate - panelWidth;
              $viewEl.transform("translate3d(" + viewTranslate + "px,0,0)").transition(0);
              $backdropEl.transform("translate3d(" + viewTranslate + "px,0,0)").transition(0);
            }
          }

          $el.trigger('panel:swipe', Math.abs(translate / panelWidth));
          panel.emit('local::swipe panelSwipe', panel, Math.abs(translate / panelWidth));
        }

        if (params.swipeNoFollow) {
          var stateChanged = panel.opened && noFollowProgress === 0 || !panel.opened && noFollowProgress === 1;

          if (stateChanged) {
            isInterrupted = true; // eslint-disable-next-line

            handleTouchEnd(e);
          }
        }
      }

      function handleTouchEnd(e) {
        if (!isTouched || !isMoved) {
          isTouched = false;
          isMoved = false;
          return;
        }

        var isGesture = e.type === 'gesturestart' || isGestureStarted;
        isTouched = false;
        isMoved = false;
        var timeDiff = new Date().getTime() - touchStartTime;
        var action;
        var edge = (translate === 0 || Math.abs(translate) === panelWidth) && !params.swipeNoFollow;
        var threshold = params.swipeThreshold || 0;

        if (isGesture) {
          action = 'reset';
        } else if (!panel.opened) {
          if (Math.abs(touchesDiff) < threshold) {
            action = 'reset';
          } else if (effect === 'cover' || effect === 'push') {
            if (translate === 0) {
              action = 'swap'; // open
            } else if (timeDiff < 300 && Math.abs(translate) > 0) {
              action = 'swap'; // open
            } else if (timeDiff >= 300 && Math.abs(translate) < panelWidth / 2) {
              action = 'swap'; // open
            } else {
              action = 'reset'; // close
            }
          } else if (translate === 0) {
            action = 'reset';
          } else if (timeDiff < 300 && Math.abs(translate) > 0 || timeDiff >= 300 && Math.abs(translate) >= panelWidth / 2) {
            action = 'swap';
          } else {
            action = 'reset';
          }
        } else if (effect === 'cover' || effect === 'push') {
          if (translate === 0) {
            action = 'reset'; // open
          } else if (timeDiff < 300 && Math.abs(translate) > 0) {
            action = 'swap'; // open
          } else if (timeDiff >= 300 && Math.abs(translate) < panelWidth / 2) {
            action = 'reset'; // open
          } else {
            action = 'swap'; // close
          }
        } else if (translate === -panelWidth) {
          action = 'reset';
        } else if (timeDiff < 300 && Math.abs(translate) >= 0 || timeDiff >= 300 && Math.abs(translate) <= panelWidth / 2) {
          if (side === 'left' && translate === panelWidth) action = 'reset';else action = 'swap';
        } else {
          action = 'reset';
        }

        if (action === 'swap') {
          if (panel.opened) {
            panel.close(!edge);
          } else {
            panel.open(!edge);
          }
        }

        var removePanelInClass = true;

        if (action === 'reset') {
          if (!panel.opened) {
            if (edge) {
              // edge position
              $el.removeClass('panel-in-swipe');
            } else {
              removePanelInClass = false;
              var target = effect === 'reveal' ? $viewEl : $el;
              panel.setStateClasses('before-closing');
              target.transitionEnd(function () {
                if ($el.hasClass('panel-in')) return;
                $el.removeClass('panel-in-swipe');
                panel.setStateClasses('after-closing');
              });
            }
          }
        }

        if (effect === 'reveal' || effect === 'push') {
          nextFrame$1(function () {
            $viewEl.transition('');
            $viewEl.transform('');
          });
        }

        if (removePanelInClass) {
          $el.removeClass('panel-in-swipe');
        }

        $el.transition('').transform('');
        $backdropEl.transform('').transition('').css({
          opacity: '',
          visibility: ''
        });
      }

      function handleGestureStart(e) {
        isGestureStarted = true;
        handleTouchEnd(e);
      }

      function handleGestureEnd() {
        isGestureStarted = false;
      } // Add Events


      app.on('touchstart:passive', handleTouchStart);
      app.on('touchmove:active', handleTouchMove);
      app.on('touchend:passive', handleTouchEnd);
      app.on('gesturestart', handleGestureStart);
      app.on('gestureend', handleGestureEnd);
      panel.on('panelDestroy', function () {
        app.off('touchstart:passive', handleTouchStart);
        app.off('touchmove:active', handleTouchMove);
        app.off('touchend:passive', handleTouchEnd);
        app.off('gesturestart', handleGestureStart);
        app.off('gestureend', handleGestureEnd);
      });
    }

    function resizablePanel(panel) {
      var app = panel.app;
      var support = getSupport$1();
      if (panel.resizableInitialized) return;
      extend$1(panel, {
        resizable: true,
        resizableWidth: null,
        resizableInitialized: true
      });
      var $htmlEl = $('html');
      var $el = panel.$el,
          $backdropEl = panel.$backdropEl,
          side = panel.side,
          effect = panel.effect;
      if (!$el) return;
      var isTouched;
      var isMoved;
      var touchesStart = {};
      var touchesDiff;
      var panelWidth;
      var $viewEl;
      var panelMinWidth;
      var panelMaxWidth;
      var visibleByBreakpoint;

      function transformCSSWidth(v) {
        if (!v) return null;

        if (v.indexOf('%') >= 0 || v.indexOf('vw') >= 0) {
          return parseInt(v, 10) / 100 * app.width;
        }

        var newV = parseInt(v, 10);
        if (Number.isNaN(newV)) return null;
        return newV;
      }

      function isResizable() {
        return panel.resizable && $el.hasClass('panel-resizable');
      }

      function handleTouchStart(e) {
        if (!isResizable()) return;
        touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
        touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
        isMoved = false;
        isTouched = true;
        panelMinWidth = transformCSSWidth($el.css('min-width'));
        panelMaxWidth = transformCSSWidth($el.css('max-width'));
        visibleByBreakpoint = $el.hasClass('panel-in-breakpoint');
      }

      function handleTouchMove(e) {
        if (!isTouched) return;
        var pageX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;

        if (!isMoved) {
          panelWidth = $el[0].offsetWidth;
          $el.transition(0);
          $el.addClass('panel-resizing');
          $htmlEl.css('cursor', 'col-resize');

          if (effect !== 'cover' || visibleByBreakpoint) {
            $viewEl = $(panel.getViewEl());

            if (panel.$containerEl && panel.$containerEl.hasClass('page')) {
              $viewEl.add(panel.$containerEl.children('.page-content, .tabs, .fab'));
            }
          }

          if (effect !== 'cover' && !visibleByBreakpoint) {
            $backdropEl.transition(0);
            $viewEl.transition(0);
          }
        }

        isMoved = true;
        e.preventDefault();
        touchesDiff = pageX - touchesStart.x;
        var newPanelWidth = side === 'left' ? panelWidth + touchesDiff : panelWidth - touchesDiff;

        if (panelMinWidth && !Number.isNaN(panelMinWidth)) {
          newPanelWidth = Math.max(newPanelWidth, panelMinWidth);
        }

        if (panelMaxWidth && !Number.isNaN(panelMaxWidth)) {
          newPanelWidth = Math.min(newPanelWidth, panelMaxWidth);
        }

        newPanelWidth = Math.min(Math.max(newPanelWidth, 0), app.width);
        panel.resizableWidth = newPanelWidth;
        $el[0].style.width = newPanelWidth + "px";

        if (effect !== 'cover' && !visibleByBreakpoint) {
          if ($viewEl) {
            $viewEl.transform("translate3d(" + (side === 'left' ? newPanelWidth : -newPanelWidth) + "px, 0, 0)");
          }

          if ($backdropEl) {
            $backdropEl.transform("translate3d(" + (side === 'left' ? newPanelWidth : -newPanelWidth) + "px, 0, 0)");
          }
        } else if (visibleByBreakpoint && $viewEl) {
          $viewEl.css("margin-" + side, newPanelWidth + "px");
        }

        $el.trigger('panel:resize', newPanelWidth);
        panel.emit('local::resize panelResize', panel, newPanelWidth);
      }

      function handleTouchEnd() {
        $('html').css('cursor', '');

        if (!isTouched || !isMoved) {
          isTouched = false;
          isMoved = false;
          return;
        }

        isTouched = false;
        isMoved = false;
        $htmlEl[0].style.setProperty("--f7-panel-" + side + "-width", panel.resizableWidth + "px");
        $el[0].style.width = '';

        if (effect !== 'cover' && !visibleByBreakpoint) {
          $viewEl.transform('');
          $backdropEl.transform('');
        }

        $el.removeClass('panel-resizing');
        nextFrame$1(function () {
          $el.transition('');

          if (effect !== 'cover') {
            $backdropEl.transition('');
            if ($viewEl) $viewEl.transition('');
          }
        });
      }

      function handleResize() {
        if (!panel.opened || !panel.resizableWidth) return;
        panelMinWidth = transformCSSWidth($el.css('min-width'));
        panelMaxWidth = transformCSSWidth($el.css('max-width'));

        if (panelMinWidth && !Number.isNaN(panelMinWidth) && panel.resizableWidth < panelMinWidth) {
          panel.resizableWidth = Math.max(panel.resizableWidth, panelMinWidth);
        }

        if (panelMaxWidth && !Number.isNaN(panelMaxWidth) && panel.resizableWidth > panelMaxWidth) {
          panel.resizableWidth = Math.min(panel.resizableWidth, panelMaxWidth);
        }

        panel.resizableWidth = Math.min(Math.max(panel.resizableWidth, 0), app.width);
        $htmlEl[0].style.setProperty("--f7-panel-" + side + "-width", panel.resizableWidth + "px");
      }

      if (panel.$el.find('.panel-resize-handler').length === 0) {
        panel.$el.append('<div class="panel-resize-handler"></div>');
      }

      panel.$resizeHandlerEl = panel.$el.children('.panel-resize-handler');
      $el.addClass('panel-resizable'); // Add Events

      var passive = support.passiveListener ? {
        passive: true
      } : false;
      panel.$el.on(app.touchEvents.start, '.panel-resize-handler', handleTouchStart, passive);
      app.on('touchmove:active', handleTouchMove);
      app.on('touchend:passive', handleTouchEnd);
      app.on('resize', handleResize);
      panel.on('beforeOpen', handleResize);
      panel.once('panelDestroy', function () {
        $el.removeClass('panel-resizable');
        panel.$resizeHandlerEl.remove();
        panel.$el.off(app.touchEvents.start, '.panel-resize-handler', handleTouchStart, passive);
        app.off('touchmove:active', handleTouchMove);
        app.off('touchend:passive', handleTouchEnd);
        app.off('resize', handleResize);
        panel.off('beforeOpen', handleResize);
      });
    }

    var Panel$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(Panel, _Framework7Class);

      function Panel(app, params) {
        var _this;

        if (params === void 0) {
          params = {};
        }

        var extendedParams = extend$1({
          on: {}
        }, app.params.panel, params);
        _this = _Framework7Class.call(this, extendedParams, [app]) || this;

        var panel = _assertThisInitialized(_this);

        panel.params = extendedParams;
        panel.$containerEl = panel.params.containerEl ? $(panel.params.containerEl).eq(0) : app.$el;
        panel.containerEl = panel.$containerEl[0];

        if (!panel.containerEl) {
          panel.$containerEl = app.$el;
          panel.containerEl = app.$el[0];
        }

        var $el;

        if (panel.params.el) {
          $el = $(panel.params.el).eq(0);
        } else if (panel.params.content) {
          $el = $(panel.params.content).filter(function (node) {
            return node.nodeType === 1;
          }).eq(0);
        }

        if ($el.length === 0) return panel || _assertThisInitialized(_this);
        if ($el[0].f7Panel) return $el[0].f7Panel || _assertThisInitialized(_this);
        $el[0].f7Panel = panel;
        var _panel$params = panel.params,
            side = _panel$params.side,
            effect = _panel$params.effect,
            resizable = _panel$params.resizable;
        if (typeof side === 'undefined') side = $el.hasClass('panel-left') ? 'left' : 'right';
        if (typeof effect === 'undefined') // eslint-disable-next-line
          effect = $el.hasClass('panel-cover') ? 'cover' : $el.hasClass('panel-push') ? 'push' : 'reveal';
        if (typeof resizable === 'undefined') resizable = $el.hasClass('panel-resizable');
        var $backdropEl;

        if (panel.params.backdrop && panel.params.backdropEl) {
          $backdropEl = $(panel.params.backdropEl);
        } else if (panel.params.backdrop) {
          $backdropEl = panel.$containerEl.children('.panel-backdrop');

          if ($backdropEl.length === 0) {
            $backdropEl = $('<div class="panel-backdrop"></div>');
            panel.$containerEl.prepend($backdropEl);
          }
        }

        extend$1(panel, {
          app: app,
          side: side,
          effect: effect,
          resizable: resizable,
          $el: $el,
          el: $el[0],
          opened: false,
          $backdropEl: $backdropEl,
          backdropEl: $backdropEl && $backdropEl[0]
        }); // Install Modules

        panel.useModules(); // Init

        panel.init();
        return panel || _assertThisInitialized(_this);
      }

      var _proto = Panel.prototype;

      _proto.getViewEl = function getViewEl() {
        var panel = this;
        var viewEl;

        if (panel.$containerEl.children('.views').length > 0) {
          viewEl = panel.$containerEl.children('.views')[0];
        } else {
          viewEl = panel.$containerEl.children('.view')[0];
        }

        return viewEl;
      };

      _proto.setStateClasses = function setStateClasses(state) {
        var panel = this;
        var side = panel.side,
            el = panel.el;
        var viewEl = panel.getViewEl();
        var panelInView = viewEl && viewEl.contains(el);
        var $targetEl = !viewEl || panelInView ? panel.$containerEl : $('html');

        if (state === 'open') {
          $targetEl.addClass("with-panel with-panel-" + panel.side + "-" + panel.effect);
        }

        if (state === 'before-closing') {
          $targetEl.addClass('with-panel-closing');
        }

        if (state === 'closing') {
          $targetEl.addClass('with-panel-closing');
          $targetEl.removeClass("with-panel with-panel-" + panel.side + "-" + panel.effect);
        }

        if (state === 'after-closing') {
          $targetEl.removeClass('with-panel-closing');
        }

        if (state === 'closed') {
          $targetEl.removeClass("with-panel-" + side + "-reveal with-panel-" + side + "-cover with-panel-" + side + "-push with-panel");
        }
      };

      _proto.enableVisibleBreakpoint = function enableVisibleBreakpoint() {
        var panel = this;
        panel.visibleBreakpointDisabled = false;
        panel.setVisibleBreakpoint();
        return panel;
      };

      _proto.disableVisibleBreakpoint = function disableVisibleBreakpoint() {
        var panel = this;
        panel.visibleBreakpointDisabled = true;
        panel.setVisibleBreakpoint();
        return panel;
      };

      _proto.toggleVisibleBreakpoint = function toggleVisibleBreakpoint() {
        var panel = this;
        panel.visibleBreakpointDisabled = !panel.visibleBreakpointDisabled;
        panel.setVisibleBreakpoint();
        return panel;
      };

      _proto.setVisibleBreakpoint = function setVisibleBreakpoint(emitEvents) {
        if (emitEvents === void 0) {
          emitEvents = true;
        }

        var panel = this;
        var app = panel.app;

        if (!panel.visibleBreakpointResizeHandler) {
          panel.visibleBreakpointResizeHandler = function visibleBreakpointResizeHandler() {
            panel.setVisibleBreakpoint();
          };

          app.on('resize', panel.visibleBreakpointResizeHandler);
        }

        var side = panel.side,
            $el = panel.$el,
            $containerEl = panel.$containerEl,
            params = panel.params,
            visibleBreakpointDisabled = panel.visibleBreakpointDisabled;
        var breakpoint = params.visibleBreakpoint;
        var $viewEl = $(panel.getViewEl());
        var wasVisible = $el.hasClass('panel-in-breakpoint');

        if ($containerEl && $containerEl.hasClass('page')) {
          $viewEl.add($containerEl.children('.page-content, .tabs, .fab'));
        }

        if (app.width >= breakpoint && typeof breakpoint !== 'undefined' && breakpoint !== null && !visibleBreakpointDisabled) {
          if (!wasVisible) {
            var _$viewEl$css;

            panel.setStateClasses('closed');
            $el.addClass('panel-in-breakpoint').removeClass('panel-in panel-in-collapsed');
            panel.onOpen(false);
            panel.onOpened();
            $viewEl.css((_$viewEl$css = {}, _$viewEl$css["margin-" + side] = $el.width() + "px", _$viewEl$css));
            app.allowPanelOpen = true;

            if (emitEvents) {
              panel.emit('local::breakpoint panelBreakpoint', panel);
              panel.$el.trigger('panel:breakpoint');
            }
          } else {
            var _$viewEl$css2;

            $viewEl.css((_$viewEl$css2 = {}, _$viewEl$css2["margin-" + side] = $el.width() + "px", _$viewEl$css2));
          }
        } else if (wasVisible) {
          var _$viewEl$css3;

          $el.removeClass('panel-in-breakpoint panel-in');
          panel.onClose();
          panel.onClosed();
          $viewEl.css((_$viewEl$css3 = {}, _$viewEl$css3["margin-" + side] = '', _$viewEl$css3));

          if (emitEvents) {
            panel.emit('local::breakpoint panelBreakpoint', panel);
            panel.$el.trigger('panel:breakpoint');
          }
        }
      };

      _proto.enableCollapsedBreakpoint = function enableCollapsedBreakpoint() {
        var panel = this;
        panel.collapsedBreakpointDisabled = false;
        panel.setCollapsedBreakpoint();
        return panel;
      };

      _proto.disableCollapsedBreakpoint = function disableCollapsedBreakpoint() {
        var panel = this;
        panel.collapsedBreakpointDisabled = true;
        panel.setCollapsedBreakpoint();
        return panel;
      };

      _proto.toggleCollapsedBreakpoint = function toggleCollapsedBreakpoint() {
        var panel = this;
        panel.collapsedBreakpointDisabled = !panel.collapsedBreakpointDisabled;
        panel.setCollapsedBreakpoint();
        return panel;
      };

      _proto.setCollapsedBreakpoint = function setCollapsedBreakpoint(emitEvents) {
        if (emitEvents === void 0) {
          emitEvents = true;
        }

        var panel = this;
        var app = panel.app;

        if (!panel.collapsedBreakpointResizeHandler) {
          panel.collapsedBreakpointResizeHandler = function collapsedBreakpointResizeHandler() {
            panel.setCollapsedBreakpoint();
          };

          app.on('resize', panel.collapsedBreakpointResizeHandler);
        }

        var $el = panel.$el,
            params = panel.params,
            collapsedBreakpointDisabled = panel.collapsedBreakpointDisabled;
        if ($el.hasClass('panel-in-breakpoint')) return;
        var breakpoint = params.collapsedBreakpoint;
        var wasVisible = $el.hasClass('panel-in-collapsed');

        if (app.width >= breakpoint && typeof breakpoint !== 'undefined' && breakpoint !== null && !collapsedBreakpointDisabled) {
          if (!wasVisible) {
            panel.setStateClasses('closed');
            $el.addClass('panel-in-collapsed').removeClass('panel-in');
            panel.collapsed = true;
            app.allowPanelOpen = true;

            if (emitEvents) {
              panel.emit('local::collapsedBreakpoint panelCollapsedBreakpoint', panel);
              panel.$el.trigger('panel:collapsedbreakpoint');
            }
          }
        } else if (wasVisible) {
          $el.removeClass('panel-in-collapsed panel-in');
          panel.collapsed = false;

          if (emitEvents) {
            panel.emit('local::collapsedBreakpoint panelCollapsedBreakpoint', panel);
            panel.$el.trigger('panel:collapsedbreakpoint');
          }
        }
      };

      _proto.enableResizable = function enableResizable() {
        var panel = this;

        if (panel.resizableInitialized) {
          panel.resizable = true;
          panel.$el.addClass('panel-resizable');
        } else {
          resizablePanel(panel);
        }

        return panel;
      };

      _proto.disableResizable = function disableResizable() {
        var panel = this;
        panel.resizable = false;
        panel.$el.removeClass('panel-resizable');
        return panel;
      };

      _proto.enableSwipe = function enableSwipe() {
        var panel = this;

        if (panel.swipeInitialized) {
          panel.swipeable = true;
        } else {
          swipePanel(panel);
        }

        return panel;
      };

      _proto.disableSwipe = function disableSwipe() {
        var panel = this;
        panel.swipeable = false;
        return panel;
      };

      _proto.onOpen = function onOpen(modifyHtmlClasses) {
        if (modifyHtmlClasses === void 0) {
          modifyHtmlClasses = true;
        }

        var panel = this;
        var app = panel.app;
        panel.opened = true;
        app.panel.allowOpen = false;
        panel.$el.trigger('panel:beforeopen');
        panel.emit('local::beforeOpen panelBeforeOpen', panel);

        if (modifyHtmlClasses) {
          panel.setStateClasses('open');
        }

        panel.$el.trigger('panel:open');
        panel.emit('local::open panelOpen', panel);
      };

      _proto.onOpened = function onOpened() {
        var panel = this;
        var app = panel.app;
        app.panel.allowOpen = true;
        panel.$el.trigger('panel:opened');
        panel.emit('local::opened panelOpened', panel);
      };

      _proto.onClose = function onClose() {
        var panel = this;
        var app = panel.app;
        panel.opened = false;
        app.panel.allowOpen = false;
        panel.$el.trigger('panel:beforeclose');
        panel.emit('local::beforeClose panelBeforeClose', panel);
        panel.setStateClasses('closing');
        panel.$el.trigger('panel:close');
        panel.emit('local::close panelClose', panel);
      };

      _proto.onClosed = function onClosed() {
        var panel = this;
        var app = panel.app;
        app.panel.allowOpen = true;
        panel.setStateClasses('after-closing');
        panel.$el.removeClass('panel-out');

        if (panel.$backdropEl) {
          var otherPanel = app.panel.get('.panel-in');
          var shouldHideBackdrop = !otherPanel || otherPanel && !otherPanel.$backdropEl;

          if (shouldHideBackdrop) {
            panel.$backdropEl.removeClass('panel-backdrop-in');
          }
        }

        panel.$el.trigger('panel:closed');
        panel.emit('local::closed panelClosed', panel);
      };

      _proto.toggle = function toggle(animate) {
        if (animate === void 0) {
          animate = true;
        }

        var panel = this;
        var breakpoint = panel.params.visibleBreakpoint;
        var app = panel.app;

        if (app.width >= breakpoint && typeof breakpoint !== 'undefined' && breakpoint !== null) {
          return panel.toggleVisibleBreakpoint();
        }

        if (panel.opened) panel.close(animate);else panel.open(animate);
        return panel;
      };

      _proto.insertToRoot = function insertToRoot() {
        var panel = this;
        var document = getDocument();
        var $el = panel.$el,
            $backdropEl = panel.$backdropEl,
            $containerEl = panel.$containerEl;
        var $panelParentEl = $el.parent();
        var wasInDom = $el.parents(document).length > 0;

        if (!$panelParentEl.is($containerEl) || $el.prevAll('.views, .view').length) {
          var $insertBeforeEl = $containerEl.children('.panel, .views, .view').eq(0);
          var $insertAfterEl = $containerEl.children('.panel-backdrop').eq(0);

          if ($insertBeforeEl.length) {
            $el.insertBefore($insertBeforeEl);
          } else if ($insertAfterEl) {
            $el.insertBefore($insertAfterEl);
          } else {
            $containerEl.prepend($el);
          }

          if ($backdropEl && $backdropEl.length && (!$backdropEl.parent().is($containerEl) && $backdropEl.nextAll('.panel').length === 0 || $backdropEl.parent().is($containerEl) && $backdropEl.nextAll('.panel').length === 0)) {
            $backdropEl.insertBefore($el);
          }

          panel.once('panelClosed', function () {
            if (wasInDom) {
              $panelParentEl.append($el);
            } else {
              $el.remove();
            }
          });
        }
      };

      _proto.open = function open(animate) {
        if (animate === void 0) {
          animate = true;
        }

        var panel = this;
        var app = panel.app;
        if (!app.panel.allowOpen) return false;
        var effect = panel.effect,
            $el = panel.$el,
            $backdropEl = panel.$backdropEl,
            opened = panel.opened,
            $containerEl = panel.$containerEl;

        if (!$el || $el.hasClass('panel-in')) {
          return panel;
        }

        panel.insertToRoot(); // Ignore if opened

        if (opened || $el.hasClass('panel-in-breakpoint') || $el.hasClass('panel-in')) return false; // Close if some panel is opened

        var otherOpenedPanel = app.panel.get('.panel-in');

        if (otherOpenedPanel && otherOpenedPanel !== panel) {
          otherOpenedPanel.close(animate);
        }

        $el[animate ? 'removeClass' : 'addClass']('not-animated');
        $el.addClass('panel-in');

        if ($backdropEl) {
          $backdropEl.addClass('panel-backdrop-in');
          $backdropEl[animate ? 'removeClass' : 'addClass']('not-animated');
        }

        if (panel.effect === 'cover' || panel.effect === 'push') {
          /* eslint no-underscore-dangle: ["error", { "allow": ["_clientLeft"] }] */
          panel._clientLeft = $el[0].clientLeft;
        } // Transitionend


        var $viewEl = $(panel.getViewEl());

        if ($containerEl && $containerEl.hasClass('page')) {
          $viewEl.add($containerEl.children('.page-content, .tabs'));
        }

        var transitionEndTarget = effect === 'reveal' ? $viewEl : $el;

        function panelTransitionEnd() {
          transitionEndTarget.transitionEnd(function (e) {
            if ($(e.target).is(transitionEndTarget)) {
              if ($el.hasClass('panel-out')) {
                panel.onClosed();
              } else {
                panel.onOpened();
              }
            } else panelTransitionEnd();
          });
        }

        if (animate) {
          if ($backdropEl) {
            $backdropEl.removeClass('not-animated');
          }

          panelTransitionEnd();
          $el.removeClass('panel-out not-animated').addClass('panel-in');
          panel.onOpen();
        } else {
          if ($backdropEl) {
            $backdropEl.addClass('not-animated');
          }

          $el.removeClass('panel-out').addClass('panel-in not-animated');
          panel.onOpen();
          panel.onOpened();
        }

        return true;
      };

      _proto.close = function close(animate) {
        if (animate === void 0) {
          animate = true;
        }

        var panel = this;
        var effect = panel.effect,
            $el = panel.$el,
            $backdropEl = panel.$backdropEl,
            opened = panel.opened,
            $containerEl = panel.$containerEl;
        if (!opened || $el.hasClass('panel-in-breakpoint') || !$el.hasClass('panel-in')) return panel;
        $el[animate ? 'removeClass' : 'addClass']('not-animated');

        if ($backdropEl) {
          $backdropEl[animate ? 'removeClass' : 'addClass']('not-animated');
        }

        var $viewEl = $(panel.getViewEl());

        if ($containerEl && $containerEl.hasClass('page')) {
          $viewEl.add($containerEl.children('.page-content, .tabs'));
        }

        var transitionEndTarget = effect === 'reveal' ? $viewEl : $el;

        function transitionEnd() {
          if ($el.hasClass('panel-out')) {
            panel.onClosed();
          } else if ($el.hasClass('panel-in')) {
            panel.onOpened();
          }

          panel.setStateClasses('after-closing');
        }

        if (animate) {
          transitionEndTarget.transitionEnd(function () {
            transitionEnd();
          });
          $el.removeClass('panel-in').addClass('panel-out'); // Emit close

          panel.onClose();
        } else {
          $el.addClass('not-animated').removeClass('panel-in').addClass('panel-out'); // Emit close

          panel.onClose();
          panel.onClosed();
        }

        return panel;
      };

      _proto.init = function init() {
        var panel = this; // const app = panel.app;

        if (typeof panel.params.visibleBreakpoint !== 'undefined') {
          panel.setVisibleBreakpoint();
        }

        if (typeof panel.params.collapsedBreakpoint !== 'undefined') {
          panel.setCollapsedBreakpoint();
        }

        if (panel.params.swipe) {
          panel.enableSwipe();
        }

        if (panel.resizable) {
          panel.enableResizable();
        }
      };

      _proto.destroy = function destroy() {
        var panel = this;
        var app = panel.app;
        var _panel = panel,
            $containerEl = _panel.$containerEl;

        if (!panel.$el) {
          // Panel already destroyed
          return;
        }

        panel.emit('local::beforeDestroy panelBeforeDestroy', panel);
        panel.$el.trigger('panel:beforedestroy');

        if (panel.visibleBreakpointResizeHandler) {
          app.off('resize', panel.visibleBreakpointResizeHandler);
        }

        if (panel.collapsedBreakpointResizeHandler) {
          app.off('resize', panel.collapsedBreakpointResizeHandler);
        }

        if (panel.$el.hasClass('panel-in-breakpoint') || panel.$el.hasClass('panel-in-collapsed')) {
          var _$viewEl$css4;

          var $viewEl = $(panel.getViewEl());

          if ($containerEl && $containerEl.hasClass('page')) {
            $viewEl.add($containerEl.children('.page-content, .tabs'));
          }

          panel.$el.removeClass('panel-in-breakpoint panel-in-collapsed panel-in');
          $viewEl.css((_$viewEl$css4 = {}, _$viewEl$css4["margin-" + panel.side] = '', _$viewEl$css4));
          panel.emit('local::breakpoint panelBreakpoint', panel);
          panel.$el.trigger('panel:breakpoint');
        }

        panel.$el.trigger('panel:destroy');
        panel.emit('local::destroy panelDestroy', panel);

        if (panel.el) {
          panel.el.f7Panel = null;
          delete panel.el.f7Panel;
        }

        deleteProps$1(panel);
        panel = null;
      };

      return Panel;
    }(Framework7Class);

    var Panel = {
      name: 'panel',
      params: {
        panel: {
          opened: undefined,
          // default based on panel-in class
          side: undefined,
          // default based on panel class
          effect: undefined,
          // default based on panel class
          resizable: undefined,
          // default based on panel-resizable class
          backdrop: true,
          backdropEl: undefined,
          visibleBreakpoint: undefined,
          collapsedBreakpoint: undefined,
          swipe: false,
          // or true
          swipeNoFollow: false,
          // or true
          swipeOnlyClose: false,
          swipeActiveArea: 0,
          swipeThreshold: 0,
          closeByBackdropClick: true,
          containerEl: undefined
        }
      },
      static: {
        Panel: Panel$1
      },
      create: function create() {
        var app = this;
        extend$1(app, {
          panel: {
            allowOpen: true,
            create: function create(params) {
              return new Panel$1(app, params);
            },
            get: function get(el) {
              if (el === void 0) {
                el = '.panel';
              }

              if (el instanceof Panel$1) return el;
              if (el === 'left' || el === 'right') el = ".panel-" + el; // eslint-disable-line

              var $el = $(el);
              if ($el.length === 0 || $el.length > 1) return undefined;
              return $el[0].f7Panel;
            },
            destroy: function destroy(el) {
              if (el === void 0) {
                el = '.panel';
              }

              var panel = app.panel.get(el);
              if (panel && panel.destroy) return panel.destroy();
              return undefined;
            },
            open: function open(el, animate) {
              if (el === void 0) {
                el = '.panel';
              }

              if (el === 'left' || el === 'right') el = ".panel-" + el; // eslint-disable-line

              var panel = app.panel.get(el);
              if (panel && panel.open) return panel.open(animate);

              if (!panel) {
                panel = app.panel.create({
                  el: el
                });
                return panel.open(animate);
              }

              return undefined;
            },
            close: function close(el, animate) {
              if (el === void 0) {
                el = '.panel-in';
              }

              if (el === 'left' || el === 'right') el = ".panel-" + el; // eslint-disable-line

              var panel = app.panel.get(el);
              if (panel && panel.open) return panel.close(animate);

              if (!panel) {
                panel = app.panel.create({
                  el: el
                });
                return panel.close(animate);
              }

              return undefined;
            },
            toggle: function toggle(el, animate) {
              if (el === void 0) {
                el = '.panel';
              }

              if (el === 'left' || el === 'right') el = ".panel-" + el; // eslint-disable-line

              var panel = app.panel.get(el);
              if (panel && panel.toggle) return panel.toggle(animate);

              if (!panel) {
                panel = app.panel.create({
                  el: el
                });
                return panel.toggle(animate);
              }

              return undefined;
            }
          }
        });
      },
      on: {
        init: function init() {
          var app = this;
          $('.panel-init').each(function (panelEl) {
            var params = Object.assign({
              el: panelEl
            }, $(panelEl).dataset() || {});
            app.panel.create(params);
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.panel-init').each(function (panelEl) {
            var params = Object.assign({
              el: panelEl
            }, $(panelEl).dataset() || {});
            app.panel.create(params);
          });
        },
        pageBeforeRemove: function pageBeforeRemove(page) {
          var app = this;
          page.$el.find('.panel-init').each(function (panelEl) {
            var panel = app.panel.get(panelEl);
            if (panel && panel.destroy) panel.destroy();
          });
        }
      },
      vnode: {
        'panel-init': {
          insert: function insert(vnode) {
            var app = this;
            var panelEl = vnode.elm;
            var params = Object.assign({
              el: panelEl
            }, $(panelEl).dataset() || {});
            app.panel.create(params);
          },
          destroy: function destroy(vnode) {
            var app = this;
            var panelEl = vnode.elm;
            var panel = app.panel.get(panelEl);
            if (panel && panel.destroy) panel.destroy();
          }
        }
      },
      clicks: {
        '.panel-open': function open(clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.panel.open(data.panel, data.animate);
        },
        '.panel-close': function close(clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.panel.close(data.panel, data.animate);
        },
        '.panel-toggle': function close(clickedEl, data) {
          if (data === void 0) {
            data = {};
          }

          var app = this;
          app.panel.toggle(data.panel, data.animate);
        },
        '.panel-backdrop': function close() {
          var app = this;
          var $panelEl = $('.panel-in:not(.panel-out)');
          if (!$panelEl.length) return;
          var instance = $panelEl[0] && $panelEl[0].f7Panel;
          $panelEl.trigger('panel:backdrop-click');

          if (instance) {
            instance.emit('backdropClick', instance);
          }

          app.emit('panelBackdropClick', instance || $panelEl[0]);
          if (app.params.panel.closeByBackdropClick) app.panel.close();
        }
      }
    };

    /* eslint no-param-reassign: "off" */
    var CardExpandable = {
      open: function open(cardEl, animate) {
        if (cardEl === void 0) {
          cardEl = '.card-expandable';
        }

        if (animate === void 0) {
          animate = true;
        }

        var app = this;
        var device = getDevice$1();
        var document = getDocument();
        var support = getSupport$1();
        var $cardEl = $(cardEl).eq(0);
        if (!$cardEl || !$cardEl.length) return;
        if ($cardEl.hasClass('card-opened') || $cardEl.hasClass('card-opening') || $cardEl.hasClass('card-closing')) return;
        var $pageEl = $cardEl.parents('.page').eq(0);
        if (!$pageEl.length) return;

        if ($pageEl.find('.card-opened').length) {
          return;
        }

        var prevented;

        function prevent() {
          prevented = true;
        }

        $cardEl.trigger('card:beforeopen', {
          prevent: prevent
        });
        app.emit('cardBeforeOpen', $cardEl[0], prevent);
        if (prevented) return;
        var cardParams = Object.assign({
          animate: animate
        }, app.params.card, $cardEl.dataset());
        var $pageContentEl = $cardEl.parents('.page-content');
        var $backdropEl;

        if ($cardEl.attr('data-backdrop-el')) {
          $backdropEl = $($cardEl.attr('data-backdrop-el'));
        }

        if (!$backdropEl && cardParams.backdrop) {
          $backdropEl = $pageContentEl.find('.card-backdrop');

          if (!$backdropEl.length) {
            $backdropEl = $('<div class="card-backdrop"></div>');
            $pageContentEl.append($backdropEl);
          }
        }

        var $navbarEl;
        var $toolbarEl;

        if (cardParams.hideNavbarOnOpen) {
          $navbarEl = $pageEl.children('.navbar');

          if (!$navbarEl.length) {
            if ($pageEl[0].f7Page) $navbarEl = $pageEl[0].f7Page.$navbarEl;
          }
        }

        if (cardParams.hideToolbarOnOpen) {
          $toolbarEl = $pageEl.children('.toolbar');

          if (!$toolbarEl.length) {
            $toolbarEl = $pageEl.parents('.view').children('.toolbar');
          }

          if (!$toolbarEl.length) {
            $toolbarEl = $pageEl.parents('.views').children('.toolbar');
          }
        }

        var currTransform = $cardEl.css('transform');
        var hasTransform;

        if (currTransform && currTransform.match(/[2-9]/)) {
          hasTransform = true;
        }

        var $cardContentEl = $cardEl.children('.card-content');
        var $cardSizeEl = $(document.createElement('div')).addClass('card-expandable-size');
        $cardEl.append($cardSizeEl);
        var cardWidth = $cardEl[0].offsetWidth;
        var cardHeight = $cardEl[0].offsetHeight;
        var pageWidth = $pageEl[0].offsetWidth;
        var pageHeight = $pageEl[0].offsetHeight;
        var maxWidth = $cardSizeEl[0].offsetWidth || pageWidth;
        var maxHeight = $cardSizeEl[0].offsetHeight || pageHeight;
        var statusbarHeight;

        if ($navbarEl && !cardParams.hideStatusbarOnOpen && maxHeight === pageHeight) {
          statusbarHeight = parseInt($navbarEl.css('--f7-safe-area-top'), 10);
          if (Number.isNaN(statusbarHeight)) statusbarHeight = 0;
        }

        if (statusbarHeight) {
          maxHeight -= statusbarHeight;
        }

        var scaleX = maxWidth / cardWidth;
        var scaleY = maxHeight / cardHeight;
        var offset = $cardEl.offset();
        var pageOffset = $pageEl.offset();

        if (statusbarHeight) {
          pageOffset.top += statusbarHeight / 2;
        }

        offset.left -= pageOffset.left;
        var cardLeftOffset;
        var cardTopOffset;

        if (hasTransform) {
          var transformValues = currTransform.replace(/matrix\(|\)/g, '').split(',').map(function (el) {
            return el.trim();
          });

          if (transformValues && transformValues.length > 1) {
            var scale = parseFloat(transformValues[0]);
            cardLeftOffset = offset.left - cardWidth * (1 - scale) / 2;
            cardTopOffset = offset.top - pageOffset.top - cardHeight * (1 - scale) / 2;
            if (app.rtl) cardLeftOffset -= $cardEl[0].scrollLeft;
          } else {
            cardLeftOffset = $cardEl[0].offsetLeft;
            cardTopOffset = $cardEl[0].offsetTop - ($pageContentEl.length ? $pageContentEl[0].scrollTop : 0);
          }
        } else {
          cardLeftOffset = offset.left;
          cardTopOffset = offset.top - pageOffset.top;
          if (app.rtl) cardLeftOffset -= $cardEl[0].scrollLeft;
        }

        cardLeftOffset -= (pageWidth - maxWidth) / 2;
        cardTopOffset -= (pageHeight - maxHeight) / 2;
        var cardRightOffset = maxWidth - cardWidth - cardLeftOffset;

        if (app.rtl) {
          var _ref = [cardRightOffset, cardLeftOffset];
          cardLeftOffset = _ref[0];
          cardRightOffset = _ref[1];
        }

        var cardBottomOffset = maxHeight - cardHeight - cardTopOffset;
        var translateX = (cardRightOffset - cardLeftOffset) / 2;
        var translateY = (cardBottomOffset - cardTopOffset) / 2;

        if (cardParams.hideNavbarOnOpen && $navbarEl && $navbarEl.length) {
          if ($navbarEl.closest('.navbar-hidden').length) {
            // Was hidden
            $cardEl[0].f7KeepNavbarOnClose = true;
          } else {
            delete $cardEl[0].f7KeepNavbarOnClose;
            app.navbar.hide($navbarEl, cardParams.animate, cardParams.hideStatusbarOnOpen, true);
          }
        }

        if (cardParams.hideToolbarOnOpen && $toolbarEl && $toolbarEl.length) {
          if ($toolbarEl.closest('.toolbar-hidden').length) {
            // Was hidden
            $cardEl[0].f7KeepToolbarOnClose = true;
          } else {
            delete $cardEl[0].f7KeepToolbarOnClose;
            app.toolbar.hide($toolbarEl, cardParams.animate);
          }
        }

        if ($backdropEl) {
          $backdropEl.removeClass('card-backdrop-out').addClass('card-backdrop-in');
        }

        $cardEl.removeClass('card-transitioning');

        if (cardParams.animate) {
          $cardEl.addClass('card-opening');
        }

        $cardEl.trigger('card:open');
        app.emit('cardOpen', $cardEl[0]);

        function transitionEnd() {
          $pageEl.addClass('page-with-card-opened');

          if (device.ios && $pageContentEl.length) {
            $pageContentEl.css('height', $pageContentEl[0].offsetHeight + 1 + "px");
            setTimeout(function () {
              $pageContentEl.css('height', '');
            });
          }

          $cardEl.addClass('card-opened');
          $cardEl.removeClass('card-opening');
          $cardEl.trigger('card:opened');
          app.emit('cardOpened', $cardEl[0], $pageEl[0]);
        }

        $cardContentEl.css({
          width: maxWidth + "px",
          height: maxHeight + "px"
        }).transform("translate3d(" + (app.rtl ? cardLeftOffset + translateX : -cardLeftOffset - translateX) + "px, 0px, 0) scale(" + 1 / scaleX + ", " + 1 / scaleY + ")");
        $cardEl.transform("translate3d(" + (app.rtl ? -translateX : translateX) + "px, " + translateY + "px, 0) scale(" + scaleX + ", " + scaleY + ")");

        if (cardParams.animate) {
          $cardEl.transitionEnd(function () {
            transitionEnd();
          });
        } else {
          transitionEnd();
        }

        function onResize() {
          $cardEl.removeClass('card-transitioning');
          cardWidth = $cardEl[0].offsetWidth;
          cardHeight = $cardEl[0].offsetHeight;
          pageWidth = $pageEl[0].offsetWidth;
          pageHeight = $pageEl[0].offsetHeight;
          maxWidth = $cardSizeEl[0].offsetWidth || pageWidth;
          maxHeight = $cardSizeEl[0].offsetHeight || pageHeight;
          statusbarHeight = 0;

          if ($navbarEl && !cardParams.hideStatusbarOnOpen && maxHeight === pageHeight) {
            statusbarHeight = parseInt($navbarEl.css('--f7-safe-area-top'), 10);
            if (Number.isNaN(statusbarHeight)) statusbarHeight = 0;
          }

          if (statusbarHeight) {
            maxHeight -= statusbarHeight;
          }

          scaleX = maxWidth / cardWidth;
          scaleY = maxHeight / cardHeight;
          $cardEl.transform('translate3d(0px, 0px, 0) scale(1)');
          offset = $cardEl.offset();
          pageOffset = $pageEl.offset();

          if (statusbarHeight) {
            pageOffset.top += statusbarHeight / 2;
          }

          offset.left -= pageOffset.left;
          offset.top -= pageOffset.top;
          cardLeftOffset = offset.left - (pageWidth - maxWidth) / 2;
          if (app.rtl) cardLeftOffset -= $cardEl[0].scrollLeft;
          cardTopOffset = offset.top - (pageHeight - maxHeight) / 2;
          cardRightOffset = maxWidth - cardWidth - cardLeftOffset;
          cardBottomOffset = maxHeight - cardHeight - cardTopOffset;

          if (app.rtl) {
            var _ref2 = [cardRightOffset, cardLeftOffset];
            cardLeftOffset = _ref2[0];
            cardRightOffset = _ref2[1];
          }

          translateX = (cardRightOffset - cardLeftOffset) / 2;
          translateY = (cardBottomOffset - cardTopOffset) / 2;
          $cardEl.transform("translate3d(" + (app.rtl ? -translateX : translateX) + "px, " + translateY + "px, 0) scale(" + scaleX + ", " + scaleY + ")");
          $cardContentEl.css({
            width: maxWidth + "px",
            height: maxHeight + "px"
          }).transform("translate3d(" + (app.rtl ? cardLeftOffset + translateX : -cardLeftOffset - translateX) + "px, 0px, 0) scale(" + 1 / scaleX + ", " + 1 / scaleY + ")");
        }

        var cardScrollTop;
        var isTouched;
        var isMoved;
        var touchStartX;
        var touchStartY;
        var touchEndX;
        var touchEndY;
        var isScrolling;
        var progress;
        var isV;
        var isH;
        var $cardScrollableEl;

        function onTouchStart(e) {
          if (!$(e.target).closest($cardEl).length) return;
          if (!$cardEl.hasClass('card-opened')) return;
          $cardScrollableEl = $cardEl.find(cardParams.scrollableEl);

          if ($cardScrollableEl[0] && $cardScrollableEl[0] !== $cardContentEl[0] && !$cardScrollableEl[0].contains(e.target)) {
            cardScrollTop = 0;
          } else {
            cardScrollTop = $cardScrollableEl.scrollTop();
          }

          isTouched = true;
          touchStartX = e.targetTouches[0].pageX;
          touchStartY = e.targetTouches[0].pageY;
          isScrolling = undefined;
          isV = false;
          isH = false;
        }

        function onTouchMove(e) {
          if (!isTouched) return;
          touchEndX = e.targetTouches[0].pageX;
          touchEndY = e.targetTouches[0].pageY;

          if (typeof isScrolling === 'undefined') {
            isScrolling = !!(isScrolling || Math.abs(touchEndY - touchStartY) > Math.abs(touchEndX - touchStartX));
          }

          if (!isH && !isV) {
            if (!isScrolling && e.targetTouches[0].clientX <= 50) {
              isH = true;
            } else {
              isV = true;
            }
          }

          if (!(isH || isV) || isV && cardScrollTop !== 0) {
            isTouched = true;
            isMoved = true;
            return;
          }

          if (!isMoved) {
            $cardEl.removeClass('card-transitioning');
          }

          isMoved = true;
          progress = isV ? Math.max((touchEndY - touchStartY) / 150, 0) : Math.max((touchEndX - touchStartX) / (cardWidth / 2), 0);

          if (progress > 0 && isV || isH) {
            if (isV && device.ios && $cardScrollableEl[0] === $cardContentEl[0]) {
              $cardScrollableEl.css('-webkit-overflow-scrolling', 'auto');
              $cardScrollableEl.scrollTop(0);
            }

            e.preventDefault();
          }

          if (progress > 1) progress = Math.pow(progress, 0.3);

          if (progress > (isV ? 1.3 : 1.1)) {
            isTouched = false;
            isMoved = false;
            app.card.close($cardEl);
          } else {
            $cardEl.transform("translate3d(" + (app.rtl ? -translateX : translateX) + "px, " + translateY + "px, 0) scale(" + scaleX * (1 - progress * 0.2) + ", " + scaleY * (1 - progress * 0.2) + ")");
          }
        }

        function onTouchEnd() {
          if (!isTouched || !isMoved) return;
          isTouched = false;
          isMoved = false;

          if (device.ios) {
            $cardScrollableEl.css('-webkit-overflow-scrolling', '');
          }

          if (progress >= 0.8) {
            app.card.close($cardEl);
          } else {
            $cardEl.addClass('card-transitioning').transform("translate3d(" + (app.rtl ? -translateX : translateX) + "px, " + translateY + "px, 0) scale(" + scaleX + ", " + scaleY + ")");
          }
        }

        $cardEl[0].detachEventHandlers = function detachEventHandlers() {
          app.off('resize', onResize);

          if (support.touch && cardParams.swipeToClose) {
            app.off('touchstart:passive', onTouchStart);
            app.off('touchmove:active', onTouchMove);
            app.off('touchend:passive', onTouchEnd);
          }
        };

        app.on('resize', onResize);

        if (support.touch && cardParams.swipeToClose) {
          app.on('touchstart:passive', onTouchStart);
          app.on('touchmove:active', onTouchMove);
          app.on('touchend:passive', onTouchEnd);
        }
      },
      close: function close(cardEl, animate) {
        if (cardEl === void 0) {
          cardEl = '.card-expandable.card-opened';
        }

        if (animate === void 0) {
          animate = true;
        }

        var app = this;
        var device = getDevice$1();
        var $cardEl = $(cardEl).eq(0);
        if (!$cardEl || !$cardEl.length) return;
        if (!$cardEl.hasClass('card-opened') || $cardEl.hasClass('card-opening') || $cardEl.hasClass('card-closing')) return;
        var $cardContentEl = $cardEl.children('.card-content');
        var $pageContentEl = $cardEl.parents('.page-content');
        var $pageEl = $cardEl.parents('.page').eq(0);
        if (!$pageEl.length) return;
        var cardParams = Object.assign({
          animate: animate
        }, app.params.card, $cardEl.dataset());
        var $cardScrollableEl = $cardEl.find(cardParams.scrollableEl);
        var $navbarEl;
        var $toolbarEl;
        var $backdropEl;

        if ($cardEl.attr('data-backdrop-el')) {
          $backdropEl = $($cardEl.attr('data-backdrop-el'));
        }

        if (cardParams.backdrop) {
          $backdropEl = $cardEl.parents('.page-content').find('.card-backdrop');
        }

        if (cardParams.hideNavbarOnOpen) {
          $navbarEl = $pageEl.children('.navbar');

          if (!$navbarEl.length) {
            if ($pageEl[0].f7Page) $navbarEl = $pageEl[0].f7Page.$navbarEl;
          }

          if ($navbarEl && $navbarEl.length && !$cardEl[0].f7KeepNavbarOnClose) {
            app.navbar.show($navbarEl, cardParams.animate, true);
          }
        }

        if (cardParams.hideToolbarOnOpen) {
          $toolbarEl = $pageEl.children('.toolbar');

          if (!$toolbarEl.length) {
            $toolbarEl = $pageEl.parents('.view').children('.toolbar');
          }

          if (!$toolbarEl.length) {
            $toolbarEl = $pageEl.parents('.views').children('.toolbar');
          }

          if ($toolbarEl && $toolbarEl.length && !$cardEl[0].f7KeepToolbarOnClose) {
            app.toolbar.show($toolbarEl, cardParams.animate);
          }
        }

        $pageEl.removeClass('page-with-card-opened');

        if (device.ios && $pageContentEl.length) {
          $pageContentEl.css('height', $pageContentEl[0].offsetHeight + 1 + "px");
          setTimeout(function () {
            $pageContentEl.css('height', '');
          });
        }

        if ($backdropEl && $backdropEl.length) {
          $backdropEl.removeClass('card-backdrop-in').addClass('card-backdrop-out');
        }

        $cardEl.removeClass('card-opened card-transitioning');

        if (cardParams.animate) {
          $cardEl.addClass('card-closing');
        } else {
          $cardEl.addClass('card-no-transition');
        }

        $cardEl.transform('');
        $cardEl.trigger('card:close');
        app.emit('cardClose', $cardEl[0], $pageEl[0]);
        var animateWidth = $cardEl.hasClass('card-expandable-animate-width');

        function transitionEnd() {
          if (!animateWidth) {
            $cardContentEl.css({
              width: '',
              height: ''
            });
          }

          if ($backdropEl && $backdropEl.length) {
            $backdropEl.removeClass('card-backdrop-in card-backdrop-out');
          }

          $cardEl.removeClass('card-closing card-no-transition');
          $cardEl.trigger('card:closed');
          $cardEl.find('.card-expandable-size').remove();
          app.emit('cardClosed', $cardEl[0], $pageEl[0]);
        }

        if (animateWidth) {
          $cardContentEl.css({
            width: '',
            height: ''
          });
        }

        $cardContentEl.transform('').scrollTop(0, animate ? 300 : 0);

        if ($cardScrollableEl.length && $cardScrollableEl[0] !== $cardContentEl[0]) {
          $cardScrollableEl.scrollTop(0, animate ? 300 : 0);
        }

        if (animate) {
          $cardContentEl.transitionEnd(function () {
            transitionEnd();
          });
        } else {
          transitionEnd();
        }

        if ($cardEl[0].detachEventHandlers) {
          $cardEl[0].detachEventHandlers();
          delete $cardEl[0].detachEventHandlers;
        }
      },
      toggle: function toggle(cardEl, animate) {
        if (cardEl === void 0) {
          cardEl = '.card-expandable';
        }

        var app = this;
        var $cardEl = $(cardEl).eq(0);
        if (!$cardEl.length) return;

        if ($cardEl.hasClass('card-opened')) {
          app.card.close($cardEl, animate);
        } else {
          app.card.open($cardEl, animate);
        }
      }
    };
    var Card = {
      name: 'card',
      params: {
        card: {
          hideNavbarOnOpen: true,
          hideStatusbarOnOpen: true,
          hideToolbarOnOpen: true,
          scrollableEl: '.card-content',
          swipeToClose: true,
          closeByBackdropClick: true,
          backdrop: true
        }
      },
      create: function create() {
        var app = this;
        bindMethods(app, {
          card: CardExpandable
        });
      },
      on: {
        pageBeforeIn: function pageBeforeIn(page) {
          var app = this;

          if (app.params.card.hideNavbarOnOpen && page.navbarEl && page.$el.find('.card-opened.card-expandable').length) {
            app.navbar.hide(page.navbarEl, true, app.params.card.hideStatusbarOnOpen, true);
          }

          if (app.params.card.hideToolbarOnOpen && page.$el.find('.card-opened.card-expandable').length) {
            var $toolbarEl = page.$el.children('.toolbar');

            if (!$toolbarEl.length) {
              $toolbarEl = page.$el.parents('.view').children('.toolbar');
            }

            if (!$toolbarEl.length) {
              $toolbarEl = page.$el.parents('.views').children('.toolbar');
            }

            if ($toolbarEl && $toolbarEl.length) {
              app.toolbar.hide($toolbarEl);
            }
          }
        }
      },
      clicks: {
        '.card-close': function closeCard($clickedEl, data) {
          var app = this;
          app.card.close(data.card, data.animate);
        },
        '.card-open': function closeCard($clickedEl, data) {
          var app = this;
          app.card.open(data.card, data.animate);
        },
        '.card-expandable': function toggleExpandableCard($clickedEl, data, e) {
          var app = this;
          if ($clickedEl.hasClass('card-opened') || $clickedEl.hasClass('card-opening') || $clickedEl.hasClass('card-closing')) return;
          if ($(e.target).closest('.card-prevent-open, .card-close').length) return;
          app.card.open($clickedEl);
        },
        '.card-backdrop-in': function onBackdropClick() {
          var app = this;
          var needToClose = false;
          if (app.params.card.closeByBackdropClick) needToClose = true;
          var $openedCardEl = $('.card-opened');
          if (!$openedCardEl.length) return;

          if ($openedCardEl.attr('data-close-by-backdrop-click') === 'true') {
            needToClose = true;
          } else if ($openedCardEl.attr('data-close-by-backdrop-click') === 'false') {
            needToClose = false;
          }

          if (needToClose) app.card.close($openedCardEl);
        }
      }
    };

    var Chip = {
      name: 'chip'
    };

    var FormData$1 = {
      store: function store(form, data) {
        var app = this;
        var window = getWindow();
        var formId = form;
        var $formEl = $(form);

        if ($formEl.length && $formEl.is('form') && $formEl.attr('id')) {
          formId = $formEl.attr('id');
        } // Store form data in app.formsData


        app.form.data["form-" + formId] = data; // Store form data in local storage also

        window.localStorage["f7form-" + formId] = JSON.stringify(data);
      },
      get: function get(form) {
        var app = this;
        var window = getWindow();
        var formId = form;
        var $formEl = $(form);

        if ($formEl.length && $formEl.is('form') && $formEl.attr('id')) {
          formId = $formEl.attr('id');
        }

        if (window.localStorage["f7form-" + formId]) {
          return JSON.parse(window.localStorage["f7form-" + formId]);
        }

        if (app.form.data["form-" + formId]) {
          return app.form.data["form-" + formId];
        }

        return undefined;
      },
      remove: function remove(form) {
        var app = this;
        var window = getWindow();
        var formId = form;
        var $formEl = $(form);

        if ($formEl.length && $formEl.is('form') && $formEl.attr('id')) {
          formId = $formEl.attr('id');
        } // Delete form data from app.formsData


        if (app.form.data["form-" + formId]) {
          app.form.data["form-" + formId] = '';
          delete app.form.data["form-" + formId];
        } // Delete form data from local storage also


        if (window.localStorage["f7form-" + formId]) {
          window.localStorage["f7form-" + formId] = '';
          window.localStorage.removeItem("f7form-" + formId);
        }
      }
    }; // Form Storage

    var FormStorage = {
      init: function init(formEl) {
        var app = this;
        var $formEl = $(formEl);
        var formId = $formEl.attr('id');
        if (!formId) return;
        var initialData = app.form.getFormData(formId);

        if (initialData) {
          app.form.fillFromData($formEl, initialData);
        }

        function store() {
          var data = app.form.convertToData($formEl);
          if (!data) return;
          app.form.storeFormData(formId, data);
          $formEl.trigger('form:storedata', data);
          app.emit('formStoreData', $formEl[0], data);
        }

        $formEl.on('change submit', store);
      },
      destroy: function destroy(formEl) {
        var $formEl = $(formEl);
        $formEl.off('change submit');
      }
    }; // Form To/From Data

    function formToData(formEl) {
      var app = this;
      var $formEl = $(formEl).eq(0);
      if ($formEl.length === 0) return undefined; // Form data

      var data = {}; // Skip input types

      var skipTypes = ['submit', 'image', 'button', 'file'];
      var skipNames = [];
      $formEl.find('input, select, textarea').each(function (inputEl) {
        var $inputEl = $(inputEl);

        if ($inputEl.hasClass('ignore-store-data') || $inputEl.hasClass('no-store-data')) {
          return;
        }

        var name = $inputEl.attr('name');
        var type = $inputEl.attr('type');
        var tag = inputEl.nodeName.toLowerCase();
        if (skipTypes.indexOf(type) >= 0) return;
        if (skipNames.indexOf(name) >= 0 || !name) return;

        if (tag === 'select' && $inputEl.prop('multiple')) {
          skipNames.push(name);
          data[name] = [];
          $formEl.find("select[name=\"" + name + "\"] option").each(function (el) {
            if (el.selected) data[name].push(el.value);
          });
        } else {
          switch (type) {
            case 'checkbox':
              skipNames.push(name);
              data[name] = [];
              $formEl.find("input[name=\"" + name + "\"]").each(function (el) {
                if (el.checked) data[name].push(el.value);
              });
              break;

            case 'radio':
              skipNames.push(name);
              $formEl.find("input[name=\"" + name + "\"]").each(function (el) {
                if (el.checked) data[name] = el.value;
              });
              break;

            default:
              data[name] = $inputEl.val();
              break;
          }
        }
      });
      $formEl.trigger('form:todata', data);
      app.emit('formToData', $formEl[0], data);
      return data;
    }

    function formFromData(formEl, formData) {
      var app = this;
      var $formEl = $(formEl).eq(0);
      if (!$formEl.length) return;
      var data = formData;
      var formId = $formEl.attr('id');

      if (!data && formId) {
        data = app.form.getFormData(formId);
      }

      if (!data) return; // Skip input types

      var skipTypes = ['submit', 'image', 'button', 'file'];
      var skipNames = [];
      $formEl.find('input, select, textarea').each(function (inputEl) {
        var $inputEl = $(inputEl);

        if ($inputEl.hasClass('ignore-store-data') || $inputEl.hasClass('no-store-data')) {
          return;
        }

        var name = $inputEl.attr('name');
        var type = $inputEl.attr('type');
        var tag = inputEl.nodeName.toLowerCase();
        if (typeof data[name] === 'undefined' || data[name] === null) return;
        if (skipTypes.indexOf(type) >= 0) return;
        if (skipNames.indexOf(name) >= 0 || !name) return;

        if (tag === 'select' && $inputEl.prop('multiple')) {
          skipNames.push(name);
          $formEl.find("select[name=\"" + name + "\"] option").each(function (el) {
            var selectEl = el;
            if (data[name].indexOf(el.value) >= 0) selectEl.selected = true;else selectEl.selected = false;
          });
        } else {
          switch (type) {
            case 'checkbox':
              skipNames.push(name);
              $formEl.find("input[name=\"" + name + "\"]").each(function (el) {
                var checkboxEl = el;
                if (data[name].indexOf(el.value) >= 0) checkboxEl.checked = true;else checkboxEl.checked = false;
              });
              break;

            case 'radio':
              skipNames.push(name);
              $formEl.find("input[name=\"" + name + "\"]").each(function (el) {
                var radioEl = el;
                if (data[name] === el.value) radioEl.checked = true;else radioEl.checked = false;
              });
              break;

            default:
              $inputEl.val(data[name]);
              break;
          }
        }

        if (tag === 'select' || tag === 'input' || tag === 'textarea') {
          $inputEl.trigger('change', 'fromdata');
        }
      });
      $formEl.trigger('form:fromdata', data);
      app.emit('formFromData', $formEl[0], data);
    }

    function initAjaxForm() {
      var app = this;
      var window = getWindow();
      var document = getDocument();

      function onSubmitChange(e, fromData) {
        var $formEl = $(this);
        if (e.type === 'change' && !$formEl.hasClass('form-ajax-submit-onchange')) return;
        if (e.type === 'submit') e.preventDefault();
        if (e.type === 'change' && fromData === 'fromdata') return;
        var method = ($formEl.attr('method') || 'GET').toUpperCase();
        var contentType = $formEl.prop('enctype') || $formEl.attr('enctype');
        var url = $formEl.attr('action');
        if (!url) return;
        var data;

        if (method === 'POST') {
          if (contentType === 'application/x-www-form-urlencoded') {
            data = app.form.convertToData($formEl[0]);
          } else {
            data = new window.FormData($formEl[0]);
          }
        } else {
          data = serializeObject(app.form.convertToData($formEl[0]));
        }

        app.request({
          method: method,
          url: url,
          contentType: contentType,
          data: data,
          beforeSend: function beforeSend(xhr) {
            $formEl.trigger('formajax:beforesend', {
              data: data,
              xhr: xhr
            });
            app.emit('formAjaxBeforeSend', $formEl[0], data, xhr);
          },
          error: function error(xhr) {
            $formEl.trigger('formajax:error', {
              data: data,
              xhr: xhr
            });
            app.emit('formAjaxError', $formEl[0], data, xhr);
          },
          complete: function complete(xhr) {
            $formEl.trigger('formajax:complete', {
              data: data,
              xhr: xhr
            });
            app.emit('formAjaxComplete', $formEl[0], data, xhr);
          },
          success: function success(response, status, xhr) {
            $formEl.trigger('formajax:success', {
              data: data,
              xhr: xhr
            });
            app.emit('formAjaxSuccess', $formEl[0], data, xhr);
          }
        });
      }

      $(document).on('submit change', 'form.form-ajax-submit, form.form-ajax-submit-onchange', onSubmitChange);
    }

    var Form = {
      name: 'form',
      create: function create() {
        var app = this;
        extend$1(app, {
          form: {
            data: {},
            storeFormData: FormData$1.store.bind(app),
            getFormData: FormData$1.get.bind(app),
            removeFormData: FormData$1.remove.bind(app),
            convertToData: formToData.bind(app),
            fillFromData: formFromData.bind(app),
            storage: {
              init: FormStorage.init.bind(app),
              destroy: FormStorage.destroy.bind(app)
            }
          }
        });
      },
      on: {
        init: function init() {
          var app = this;
          initAjaxForm.call(app);
        },
        tabBeforeRemove: function tabBeforeRemove(tabEl) {
          var app = this;
          $(tabEl).find('.form-store-data').each(function (formEl) {
            app.form.storage.destroy(formEl);
          });
        },
        tabMounted: function tabMounted(tabEl) {
          var app = this;
          $(tabEl).find('.form-store-data').each(function (formEl) {
            app.form.storage.init(formEl);
          });
        },
        pageBeforeRemove: function pageBeforeRemove(page) {
          var app = this;
          page.$el.find('.form-store-data').each(function (formEl) {
            app.form.storage.destroy(formEl);
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.form-store-data').each(function (formEl) {
            app.form.storage.init(formEl);
          });
        }
      }
    };

    var Input = {
      ignoreTypes: ['checkbox', 'button', 'submit', 'range', 'radio', 'image'],
      createTextareaResizableShadow: function createTextareaResizableShadow() {
        var document = getDocument();
        var $shadowEl = $(document.createElement('textarea'));
        $shadowEl.addClass('textarea-resizable-shadow');
        $shadowEl.prop({
          disabled: true,
          readonly: true
        });
        Input.textareaResizableShadow = $shadowEl;
      },
      textareaResizableShadow: undefined,
      resizeTextarea: function resizeTextarea(textareaEl) {
        var app = this;
        var window = getWindow();
        var $textareaEl = $(textareaEl);

        if (!Input.textareaResizableShadow) {
          Input.createTextareaResizableShadow();
        }

        var $shadowEl = Input.textareaResizableShadow;
        if (!$textareaEl.length) return;
        if (!$textareaEl.hasClass('resizable')) return;

        if (Input.textareaResizableShadow.parents().length === 0) {
          app.$el.append($shadowEl);
        }

        var styles = window.getComputedStyle($textareaEl[0]);
        'padding-top padding-bottom padding-left padding-right margin-left margin-right margin-top margin-bottom width font-size font-family font-style font-weight line-height font-variant text-transform letter-spacing border box-sizing display'.split(' ').forEach(function (style) {
          var styleValue = styles[style];

          if ('font-size line-height letter-spacing width'.split(' ').indexOf(style) >= 0) {
            styleValue = styleValue.replace(',', '.');
          }

          $shadowEl.css(style, styleValue);
        });
        var currentHeight = $textareaEl[0].clientHeight;
        $shadowEl.val('');
        var initialHeight = $shadowEl[0].scrollHeight;
        $shadowEl.val($textareaEl.val());
        $shadowEl.css('height', 0);
        var scrollHeight = $shadowEl[0].scrollHeight;

        if (currentHeight !== scrollHeight) {
          if (scrollHeight > initialHeight) {
            $textareaEl.css('height', scrollHeight + "px");
          } else if (scrollHeight < currentHeight) {
            $textareaEl.css('height', '');
          }

          if (scrollHeight > initialHeight || scrollHeight < currentHeight) {
            $textareaEl.trigger('textarea:resize', {
              initialHeight: initialHeight,
              currentHeight: currentHeight,
              scrollHeight: scrollHeight
            });
            app.emit('textareaResize', {
              initialHeight: initialHeight,
              currentHeight: currentHeight,
              scrollHeight: scrollHeight
            });
          }
        }
      },
      validate: function validate(inputEl) {
        var $inputEl = $(inputEl);
        if (!$inputEl.length) return true;
        var $itemInputEl = $inputEl.parents('.item-input');
        var $inputWrapEl = $inputEl.parents('.input');

        function unsetReadonly() {
          if ($inputEl[0].f7ValidateReadonly) {
            $inputEl[0].readOnly = false;
          }
        }

        function setReadonly() {
          if ($inputEl[0].f7ValidateReadonly) {
            $inputEl[0].readOnly = true;
          }
        }

        unsetReadonly();
        var validity = $inputEl[0].validity;
        var validationMessage = $inputEl.dataset().errorMessage || $inputEl[0].validationMessage || '';

        if (!validity) {
          setReadonly();
          return true;
        }

        if (!validity.valid) {
          var $errorEl = $inputEl.nextAll('.item-input-error-message, .input-error-message');

          if (validationMessage) {
            if ($errorEl.length === 0) {
              $errorEl = $("<div class=\"" + ($inputWrapEl.length ? 'input-error-message' : 'item-input-error-message') + "\"></div>");
              $errorEl.insertAfter($inputEl);
            }

            $errorEl.text(validationMessage);
          }

          if ($errorEl.length > 0) {
            $itemInputEl.addClass('item-input-with-error-message');
            $inputWrapEl.addClass('input-with-error-message');
          }

          $itemInputEl.addClass('item-input-invalid');
          $inputWrapEl.addClass('input-invalid');
          $inputEl.addClass('input-invalid');
          setReadonly();
          return false;
        }

        $itemInputEl.removeClass('item-input-invalid item-input-with-error-message');
        $inputWrapEl.removeClass('input-invalid input-with-error-message');
        $inputEl.removeClass('input-invalid');
        setReadonly();
        return true;
      },
      validateInputs: function validateInputs(el) {
        var app = this;
        var validates = $(el).find('input, textarea, select').map(function (inputEl) {
          return app.input.validate(inputEl);
        });
        return validates.indexOf(false) < 0;
      },
      focus: function focus(inputEl) {
        var $inputEl = $(inputEl);
        var type = $inputEl.attr('type');
        if (Input.ignoreTypes.indexOf(type) >= 0) return;
        $inputEl.parents('.item-input').addClass('item-input-focused');
        $inputEl.parents('.input').addClass('input-focused');
        $inputEl.addClass('input-focused');
      },
      blur: function blur(inputEl) {
        var $inputEl = $(inputEl);
        $inputEl.parents('.item-input').removeClass('item-input-focused');
        $inputEl.parents('.input').removeClass('input-focused');
        $inputEl.removeClass('input-focused');
      },
      checkEmptyState: function checkEmptyState(inputEl) {
        var app = this;
        var $inputEl = $(inputEl);

        if (!$inputEl.is('input, select, textarea, .item-input [contenteditable]')) {
          $inputEl = $inputEl.find('input, select, textarea, .item-input [contenteditable]').eq(0);
        }

        if (!$inputEl.length) return;
        var isContentEditable = $inputEl[0].hasAttribute('contenteditable');
        var value;

        if (isContentEditable) {
          if ($inputEl.find('.text-editor-placeholder').length) value = '';else value = $inputEl.html();
        } else {
          value = $inputEl.val();
        }

        var $itemInputEl = $inputEl.parents('.item-input');
        var $inputWrapEl = $inputEl.parents('.input');

        if (value && typeof value === 'string' && value.trim() !== '' || Array.isArray(value) && value.length > 0) {
          $itemInputEl.addClass('item-input-with-value');
          $inputWrapEl.addClass('input-with-value');
          $inputEl.addClass('input-with-value');
          $inputEl.trigger('input:notempty');
          app.emit('inputNotEmpty', $inputEl[0]);
        } else {
          $itemInputEl.removeClass('item-input-with-value');
          $inputWrapEl.removeClass('input-with-value');
          $inputEl.removeClass('input-with-value');
          $inputEl.trigger('input:empty');
          app.emit('inputEmpty', $inputEl[0]);
        }
      },
      scrollIntoView: function scrollIntoView(inputEl, duration, centered, force) {
        if (duration === void 0) {
          duration = 0;
        }

        var $inputEl = $(inputEl);
        var $scrollableEl = $inputEl.parents('.page-content, .panel, .card-expandable .card-content').eq(0);

        if (!$scrollableEl.length) {
          return false;
        }

        var contentHeight = $scrollableEl[0].offsetHeight;
        var contentScrollTop = $scrollableEl[0].scrollTop;
        var contentPaddingTop = parseInt($scrollableEl.css('padding-top'), 10);
        var contentPaddingBottom = parseInt($scrollableEl.css('padding-bottom'), 10);
        var contentOffsetTop = $scrollableEl.offset().top - contentScrollTop;
        var inputOffsetTop = $inputEl.offset().top - contentOffsetTop;
        var inputHeight = $inputEl[0].offsetHeight;
        var min = inputOffsetTop + contentScrollTop - contentPaddingTop;
        var max = inputOffsetTop + contentScrollTop - contentHeight + contentPaddingBottom + inputHeight;
        var centeredPosition = min + (max - min) / 2;

        if (contentScrollTop > min) {
          $scrollableEl.scrollTop(centered ? centeredPosition : min, duration);
          return true;
        }

        if (contentScrollTop < max) {
          $scrollableEl.scrollTop(centered ? centeredPosition : max, duration);
          return true;
        }

        if (force) {
          $scrollableEl.scrollTop(centered ? centeredPosition : max, duration);
        }

        return false;
      },
      init: function init() {
        var app = this;
        var device = getDevice$1();
        var window = getWindow();
        var document = getDocument();
        Input.createTextareaResizableShadow();

        function onFocus() {
          var inputEl = this;

          if (app.params.input.scrollIntoViewOnFocus) {
            if (device.android) {
              $(window).once('resize', function () {
                if (document && document.activeElement === inputEl) {
                  app.input.scrollIntoView(inputEl, app.params.input.scrollIntoViewDuration, app.params.input.scrollIntoViewCentered, app.params.input.scrollIntoViewAlways);
                }
              });
            } else {
              app.input.scrollIntoView(inputEl, app.params.input.scrollIntoViewDuration, app.params.input.scrollIntoViewCentered, app.params.input.scrollIntoViewAlways);
            }
          }

          app.input.focus(inputEl);
        }

        function onBlur() {
          var $inputEl = $(this);
          var tag = $inputEl[0].nodeName.toLowerCase();
          app.input.blur($inputEl);

          if ($inputEl.dataset().validate || $inputEl.attr('validate') !== null || $inputEl.attr('data-validate-on-blur') !== null) {
            app.input.validate($inputEl);
          } // Resize textarea


          if (tag === 'textarea' && $inputEl.hasClass('resizable')) {
            if (Input.textareaResizableShadow) Input.textareaResizableShadow.remove();
          }
        }

        function onChange() {
          var $inputEl = $(this);
          var type = $inputEl.attr('type');
          var tag = $inputEl[0].nodeName.toLowerCase();
          var isContentEditable = $inputEl[0].hasAttribute('contenteditable');
          if (Input.ignoreTypes.indexOf(type) >= 0) return; // Check Empty State

          app.input.checkEmptyState($inputEl);
          if (isContentEditable) return; // Check validation

          if ($inputEl.attr('data-validate-on-blur') === null && ($inputEl.dataset().validate || $inputEl.attr('validate') !== null)) {
            app.input.validate($inputEl);
          } // Resize textarea


          if (tag === 'textarea' && $inputEl.hasClass('resizable')) {
            app.input.resizeTextarea($inputEl);
          }
        }

        function onInvalid(e) {
          var $inputEl = $(this);

          if ($inputEl.attr('data-validate-on-blur') === null && ($inputEl.dataset().validate || $inputEl.attr('validate') !== null)) {
            e.preventDefault();
            app.input.validate($inputEl);
          }
        }

        function clearInput() {
          var $clicked = $(this);
          var $inputEl = $clicked.siblings('input, textarea').eq(0);
          var previousValue = $inputEl.val();
          $inputEl.val('').trigger('input change').focus().trigger('input:clear', previousValue);
          app.emit('inputClear', previousValue);
        }

        function preventDefault(e) {
          e.preventDefault();
        }

        $(document).on('click', '.input-clear-button', clearInput);
        $(document).on('mousedown', '.input-clear-button', preventDefault);
        $(document).on('change input', 'input, textarea, select, .item-input [contenteditable]', onChange, true);
        $(document).on('focus', 'input, textarea, select, .item-input [contenteditable]', onFocus, true);
        $(document).on('blur', 'input, textarea, select, .item-input [contenteditable]', onBlur, true);
        $(document).on('invalid', 'input, textarea, select', onInvalid, true);
      }
    };
    var Input$1 = {
      name: 'input',
      params: {
        input: {
          scrollIntoViewOnFocus: undefined,
          scrollIntoViewCentered: false,
          scrollIntoViewDuration: 0,
          scrollIntoViewAlways: false
        }
      },
      create: function create() {
        var app = this;

        if (typeof app.params.input.scrollIntoViewOnFocus === 'undefined') {
          app.params.input.scrollIntoViewOnFocus = getDevice$1().android;
        }

        bindMethods(app, {
          input: Input
        });
      },
      on: {
        init: function init() {
          var app = this;
          app.input.init();
        },
        tabMounted: function tabMounted(tabEl) {
          var app = this;
          var $tabEl = $(tabEl);
          $tabEl.find('.item-input, .input').each(function (itemInputEl) {
            var $itemInputEl = $(itemInputEl);
            $itemInputEl.find('input, select, textarea, [contenteditable]').each(function (inputEl) {
              var $inputEl = $(inputEl);
              if (Input.ignoreTypes.indexOf($inputEl.attr('type')) >= 0) return;
              app.input.checkEmptyState($inputEl);
            });
          });
          $tabEl.find('textarea.resizable').each(function (textareaEl) {
            app.input.resizeTextarea(textareaEl);
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          var $pageEl = page.$el;
          $pageEl.find('.item-input, .input').each(function (itemInputEl) {
            var $itemInputEl = $(itemInputEl);
            $itemInputEl.find('input, select, textarea, [contenteditable]').each(function (inputEl) {
              var $inputEl = $(inputEl);
              if (Input.ignoreTypes.indexOf($inputEl.attr('type')) >= 0) return;
              app.input.checkEmptyState($inputEl);
            });
          });
          $pageEl.find('textarea.resizable').each(function (textareaEl) {
            app.input.resizeTextarea(textareaEl);
          });
        },
        'panelBreakpoint panelCollapsedBreakpoint panelResize panelOpen panelSwipeOpen resize viewMasterDetailBreakpoint': function onPanelOpen(instance) {
          var app = this;

          if (instance && instance.$el) {
            instance.$el.find('textarea.resizable').each(function (textareaEl) {
              app.input.resizeTextarea(textareaEl);
            });
          } else {
            $('textarea.resizable').each(function (textareaEl) {
              app.input.resizeTextarea(textareaEl);
            });
          }
        }
      }
    };

    var Checkbox = {
      name: 'checkbox'
    };

    var Radio = {
      name: 'radio'
    };

    var Toggle$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(Toggle, _Framework7Class);

      function Toggle(app, params) {
        var _this;

        if (params === void 0) {
          params = {};
        }

        _this = _Framework7Class.call(this, params, [app]) || this;

        var toggle = _assertThisInitialized(_this);

        var support = getSupport$1();
        var defaults = {}; // Extend defaults with modules params

        toggle.useModulesParams(defaults);
        toggle.params = extend$1(defaults, params);
        var el = toggle.params.el;
        if (!el) return toggle || _assertThisInitialized(_this);
        var $el = $(el);
        if ($el.length === 0) return toggle || _assertThisInitialized(_this);
        if ($el[0].f7Toggle) return $el[0].f7Toggle || _assertThisInitialized(_this);
        var $inputEl = $el.children('input[type="checkbox"]');
        extend$1(toggle, {
          app: app,
          $el: $el,
          el: $el[0],
          $inputEl: $inputEl,
          inputEl: $inputEl[0],
          disabled: $el.hasClass('disabled') || $inputEl.hasClass('disabled') || $inputEl.attr('disabled') || $inputEl[0].disabled
        });
        Object.defineProperty(toggle, 'checked', {
          enumerable: true,
          configurable: true,
          set: function set(checked) {
            if (!toggle || typeof toggle.$inputEl === 'undefined') return;
            if (toggle.checked === checked) return;
            $inputEl[0].checked = checked;
            toggle.$inputEl.trigger('change');
          },
          get: function get() {
            return $inputEl[0].checked;
          }
        });
        $el[0].f7Toggle = toggle;
        var isTouched;
        var touchesStart = {};
        var isScrolling;
        var touchesDiff;
        var toggleWidth;
        var touchStartTime;
        var touchStartChecked;

        function handleTouchStart(e) {
          if (isTouched || toggle.disabled) return;
          touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
          touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
          touchesDiff = 0;
          isTouched = true;
          isScrolling = undefined;
          touchStartTime = now$1();
          touchStartChecked = toggle.checked;
          toggleWidth = $el[0].offsetWidth;
          nextTick$1(function () {
            if (isTouched) {
              $el.addClass('toggle-active-state');
            }
          });
        }

        function handleTouchMove(e) {
          if (!isTouched || toggle.disabled) return;
          var pageX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
          var pageY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;
          var inverter = app.rtl ? -1 : 1;

          if (typeof isScrolling === 'undefined') {
            isScrolling = !!(isScrolling || Math.abs(pageY - touchesStart.y) > Math.abs(pageX - touchesStart.x));
          }

          if (isScrolling) {
            isTouched = false;
            return;
          }

          e.preventDefault();
          touchesDiff = pageX - touchesStart.x;
          var changed;

          if (touchesDiff * inverter < 0 && Math.abs(touchesDiff) > toggleWidth / 3 && touchStartChecked) {
            changed = true;
          }

          if (touchesDiff * inverter > 0 && Math.abs(touchesDiff) > toggleWidth / 3 && !touchStartChecked) {
            changed = true;
          }

          if (changed) {
            touchesStart.x = pageX;
            toggle.checked = !touchStartChecked;
            touchStartChecked = !touchStartChecked;
          }
        }

        function handleTouchEnd() {
          if (!isTouched || toggle.disabled) {
            if (isScrolling) $el.removeClass('toggle-active-state');
            isTouched = false;
            return;
          }

          var inverter = app.rtl ? -1 : 1;
          isTouched = false;
          $el.removeClass('toggle-active-state');
          var changed;

          if (now$1() - touchStartTime < 300) {
            if (touchesDiff * inverter < 0 && touchStartChecked) {
              changed = true;
            }

            if (touchesDiff * inverter > 0 && !touchStartChecked) {
              changed = true;
            }

            if (changed) {
              toggle.checked = !touchStartChecked;
            }
          }
        }

        function handleInputChange() {
          toggle.$el.trigger('toggle:change');
          toggle.emit('local::change toggleChange', toggle);
        }

        toggle.attachEvents = function attachEvents() {
          var passive = support.passiveListener ? {
            passive: true
          } : false;
          $el.on(app.touchEvents.start, handleTouchStart, passive);
          app.on('touchmove', handleTouchMove);
          app.on('touchend:passive', handleTouchEnd);
          toggle.$inputEl.on('change', handleInputChange);
        };

        toggle.detachEvents = function detachEvents() {
          var passive = support.passiveListener ? {
            passive: true
          } : false;
          $el.off(app.touchEvents.start, handleTouchStart, passive);
          app.off('touchmove', handleTouchMove);
          app.off('touchend:passive', handleTouchEnd);
          toggle.$inputEl.off('change', handleInputChange);
        }; // Install Modules


        toggle.useModules(); // Init

        toggle.init();
        return _this;
      }

      var _proto = Toggle.prototype;

      _proto.toggle = function toggle() {
        var toggle = this;
        toggle.checked = !toggle.checked;
      };

      _proto.init = function init() {
        var toggle = this;
        toggle.attachEvents();
      };

      _proto.destroy = function destroy() {
        var toggle = this;
        toggle.$el.trigger('toggle:beforedestroy');
        toggle.emit('local::beforeDestroy toggleBeforeDestroy', toggle);
        delete toggle.$el[0].f7Toggle;
        toggle.detachEvents();
        deleteProps$1(toggle);
        toggle = null;
      };

      return Toggle;
    }(Framework7Class);

    var Toggle = {
      name: 'toggle',
      create: function create() {
        var app = this;
        app.toggle = ConstructorMethods({
          defaultSelector: '.toggle',
          constructor: Toggle$1,
          app: app,
          domProp: 'f7Toggle'
        });
      },
      static: {
        Toggle: Toggle$1
      },
      on: {
        tabMounted: function tabMounted(tabEl) {
          var app = this;
          $(tabEl).find('.toggle-init').each(function (toggleEl) {
            return app.toggle.create({
              el: toggleEl
            });
          });
        },
        tabBeforeRemove: function tabBeforeRemove(tabEl) {
          $(tabEl).find('.toggle-init').each(function (toggleEl) {
            if (toggleEl.f7Toggle) toggleEl.f7Toggle.destroy();
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.toggle-init').each(function (toggleEl) {
            return app.toggle.create({
              el: toggleEl
            });
          });
        },
        pageBeforeRemove: function pageBeforeRemove(page) {
          page.$el.find('.toggle-init').each(function (toggleEl) {
            if (toggleEl.f7Toggle) toggleEl.f7Toggle.destroy();
          });
        }
      },
      vnode: {
        'toggle-init': {
          insert: function insert(vnode) {
            var app = this;
            var toggleEl = vnode.elm;
            app.toggle.create({
              el: toggleEl
            });
          },
          destroy: function destroy(vnode) {
            var toggleEl = vnode.elm;
            if (toggleEl.f7Toggle) toggleEl.f7Toggle.destroy();
          }
        }
      }
    };

    var Range$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(Range, _Framework7Class);

      function Range(app, params) {
        var _this;

        _this = _Framework7Class.call(this, params, [app]) || this;

        var range = _assertThisInitialized(_this);

        var support = getSupport$1();
        var defaults = {
          el: null,
          inputEl: null,
          dual: false,
          step: 1,
          label: false,
          min: 0,
          max: 100,
          value: 0,
          draggableBar: true,
          vertical: false,
          verticalReversed: false,
          formatLabel: null,
          scale: false,
          scaleSteps: 5,
          scaleSubSteps: 0,
          formatScaleLabel: null,
          limitKnobPosition: app.theme === 'ios'
        }; // Extend defaults with modules params

        range.useModulesParams(defaults);
        range.params = extend$1(defaults, params);
        var el = range.params.el;
        if (!el) return range || _assertThisInitialized(_this);
        var $el = $(el);
        if ($el.length === 0) return range || _assertThisInitialized(_this);
        if ($el[0].f7Range) return $el[0].f7Range || _assertThisInitialized(_this);
        var dataset = $el.dataset();
        'step min max value scaleSteps scaleSubSteps'.split(' ').forEach(function (paramName) {
          if (typeof params[paramName] === 'undefined' && typeof dataset[paramName] !== 'undefined') {
            range.params[paramName] = parseFloat(dataset[paramName]);
          }
        });
        'dual label vertical verticalReversed scale'.split(' ').forEach(function (paramName) {
          if (typeof params[paramName] === 'undefined' && typeof dataset[paramName] !== 'undefined') {
            range.params[paramName] = dataset[paramName];
          }
        });

        if (!range.params.value) {
          if (typeof dataset.value !== 'undefined') range.params.value = dataset.value;

          if (typeof dataset.valueLeft !== 'undefined' && typeof dataset.valueRight !== 'undefined') {
            range.params.value = [parseFloat(dataset.valueLeft), parseFloat(dataset.valueRight)];
          }
        }

        var $inputEl;

        if (!range.params.dual) {
          if (range.params.inputEl) {
            $inputEl = $(range.params.inputEl);
          } else if ($el.find('input[type="range"]').length) {
            $inputEl = $el.find('input[type="range"]').eq(0);
          }
        }

        var _range$params = range.params,
            dual = _range$params.dual,
            step = _range$params.step,
            label = _range$params.label,
            min = _range$params.min,
            max = _range$params.max,
            value = _range$params.value,
            vertical = _range$params.vertical,
            verticalReversed = _range$params.verticalReversed,
            scale = _range$params.scale,
            scaleSteps = _range$params.scaleSteps,
            scaleSubSteps = _range$params.scaleSubSteps,
            limitKnobPosition = _range$params.limitKnobPosition;
        extend$1(range, {
          app: app,
          $el: $el,
          el: $el[0],
          $inputEl: $inputEl,
          inputEl: $inputEl ? $inputEl[0] : undefined,
          dual: dual,
          step: step,
          label: label,
          min: min,
          max: max,
          value: value,
          previousValue: value,
          vertical: vertical,
          verticalReversed: verticalReversed,
          scale: scale,
          scaleSteps: scaleSteps,
          scaleSubSteps: scaleSubSteps,
          limitKnobPosition: limitKnobPosition
        });

        if ($inputEl) {
          'step min max'.split(' ').forEach(function (paramName) {
            if (!params[paramName] && $inputEl.attr(paramName)) {
              range.params[paramName] = parseFloat($inputEl.attr(paramName));
              range[paramName] = parseFloat($inputEl.attr(paramName));
            }
          });

          if (typeof $inputEl.val() !== 'undefined') {
            range.params.value = parseFloat($inputEl.val());
            range.value = parseFloat($inputEl.val());
          }
        } // Dual


        if (range.dual) {
          $el.addClass('range-slider-dual');
        }

        if (range.label) {
          $el.addClass('range-slider-label');
        } // Vertical


        if (range.vertical) {
          $el.addClass('range-slider-vertical');

          if (range.verticalReversed) {
            $el.addClass('range-slider-vertical-reversed');
          }
        } else {
          $el.addClass('range-slider-horizontal');
        } // Check for layout


        var $barEl = $('<div class="range-bar"></div>');
        var $barActiveEl = $('<div class="range-bar-active"></div>');
        $barEl.append($barActiveEl); // Create Knobs
        // prettier-ignore

        var knobHTML = "\n      <div class=\"range-knob-wrap\">\n        <div class=\"range-knob\"></div>\n        " + (range.label ? '<div class="range-knob-label"></div>' : '') + "\n      </div>\n    ";
        var knobs = [$(knobHTML)];

        if (range.dual) {
          knobs.push($(knobHTML));
        }

        $el.append($barEl);
        knobs.forEach(function ($knobEl) {
          $el.append($knobEl);
        }); // Labels

        var labels = [];

        if (range.label) {
          labels.push(knobs[0].find('.range-knob-label'));

          if (range.dual) {
            labels.push(knobs[1].find('.range-knob-label'));
          }
        } // Scale


        var $scaleEl;

        if (range.scale && range.scaleSteps >= 1) {
          $scaleEl = $("\n        <div class=\"range-scale\">\n          " + range.renderScale() + "\n        </div>\n      ");
          $el.append($scaleEl);
        }

        extend$1(range, {
          knobs: knobs,
          labels: labels,
          $barEl: $barEl,
          $barActiveEl: $barActiveEl,
          $scaleEl: $scaleEl
        });
        $el[0].f7Range = range; // Touch Events

        var isTouched;
        var touchesStart = {};
        var isScrolling;
        var rangeOffset;
        var rangeOffsetLeft;
        var rangeOffsetTop;
        var $touchedKnobEl;
        var dualValueIndex;
        var valueChangedByTouch;
        var targetTouchIdentifier;

        function onTouchChange() {
          valueChangedByTouch = true;
        }

        function handleTouchStart(e) {
          if (isTouched) return;

          if (!range.params.draggableBar) {
            if ($(e.target).closest('.range-knob').length === 0) {
              return;
            }
          }

          valueChangedByTouch = false;
          touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
          touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;

          if (e.type === 'touchstart') {
            targetTouchIdentifier = e.targetTouches[0].identifier;
          }

          isTouched = true;
          isScrolling = undefined;
          rangeOffset = $el.offset();
          rangeOffsetLeft = rangeOffset.left;
          rangeOffsetTop = rangeOffset.top;
          var progress;

          if (range.vertical) {
            progress = (touchesStart.y - rangeOffsetTop) / range.rangeHeight;
            if (!range.verticalReversed) progress = 1 - progress;
          } else if (range.app.rtl) {
            progress = (rangeOffsetLeft + range.rangeWidth - touchesStart.x) / range.rangeWidth;
          } else {
            progress = (touchesStart.x - rangeOffsetLeft) / range.rangeWidth;
          }

          var newValue = progress * (range.max - range.min) + range.min;

          if (range.dual) {
            if (Math.abs(range.value[0] - newValue) < Math.abs(range.value[1] - newValue)) {
              dualValueIndex = 0;
              $touchedKnobEl = range.knobs[0];
              newValue = [newValue, range.value[1]];
            } else {
              dualValueIndex = 1;
              $touchedKnobEl = range.knobs[1];
              newValue = [range.value[0], newValue];
            }
          } else {
            $touchedKnobEl = range.knobs[0];
            newValue = progress * (range.max - range.min) + range.min;
          }

          nextTick$1(function () {
            if (isTouched) $touchedKnobEl.addClass('range-knob-active-state');
          }, 70);
          range.on('change', onTouchChange);
          range.setValue(newValue, true);
        }

        function handleTouchMove(e) {
          if (!isTouched) return;
          var pageX;
          var pageY;

          if (e.type === 'touchmove') {
            for (var i = 0; i < e.targetTouches.length; i += 1) {
              if (e.targetTouches[i].identifier === targetTouchIdentifier) {
                pageX = e.targetTouches[i].pageX;
                pageY = e.targetTouches[i].pageY;
              }
            }
          } else {
            pageX = e.pageX;
            pageY = e.pageY;
          }

          if (typeof pageX === 'undefined' && typeof pageY === 'undefined') return;

          if (typeof isScrolling === 'undefined' && !range.vertical) {
            isScrolling = !!(isScrolling || Math.abs(pageY - touchesStart.y) > Math.abs(pageX - touchesStart.x));
          }

          if (isScrolling) {
            isTouched = false;
            return;
          }

          e.preventDefault();
          var progress;

          if (range.vertical) {
            progress = (pageY - rangeOffsetTop) / range.rangeHeight;
            if (!range.verticalReversed) progress = 1 - progress;
          } else if (range.app.rtl) {
            progress = (rangeOffsetLeft + range.rangeWidth - pageX) / range.rangeWidth;
          } else {
            progress = (pageX - rangeOffsetLeft) / range.rangeWidth;
          }

          var newValue = progress * (range.max - range.min) + range.min;

          if (range.dual) {
            var leftValue;
            var rightValue;

            if (dualValueIndex === 0) {
              leftValue = newValue;
              rightValue = range.value[1];

              if (leftValue > rightValue) {
                rightValue = leftValue;
              }
            } else {
              leftValue = range.value[0];
              rightValue = newValue;

              if (rightValue < leftValue) {
                leftValue = rightValue;
              }
            }

            newValue = [leftValue, rightValue];
          }

          range.setValue(newValue, true);
        }

        function handleTouchEnd(e) {
          if (e.type === 'touchend') {
            var touchEnded;

            for (var i = 0; i < e.changedTouches.length; i += 1) {
              if (e.changedTouches[i].identifier === targetTouchIdentifier) touchEnded = true;
            }

            if (!touchEnded) return;
          }

          if (!isTouched) {
            if (isScrolling) $touchedKnobEl.removeClass('range-knob-active-state');
            isTouched = false;
            return;
          }

          range.off('change', onTouchChange);
          isTouched = false;
          $touchedKnobEl.removeClass('range-knob-active-state');

          if (valueChangedByTouch && range.$inputEl && !range.dual) {
            range.$inputEl.trigger('change');
          }

          valueChangedByTouch = false;

          if (typeof range.previousValue !== 'undefined') {
            if (range.dual && (range.previousValue[0] !== range.value[0] || range.previousValue[1] !== range.value[1]) || !range.dual && range.previousValue !== range.value) {
              range.$el.trigger('range:changed', range.value);
              range.emit('local::changed rangeChanged', range, range.value);
            }
          }
        }

        function handleResize() {
          range.calcSize();
          range.layout();
        }

        var parentModals;
        var parentPanel;
        var parentPage;

        range.attachEvents = function attachEvents() {
          var passive = support.passiveListener ? {
            passive: true
          } : false;
          range.$el.on(app.touchEvents.start, handleTouchStart, passive);
          app.on('touchmove', handleTouchMove);
          app.on('touchend:passive', handleTouchEnd);
          app.on('tabShow', handleResize);
          app.on('resize', handleResize);
          parentModals = range.$el.parents('.sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast');
          parentModals.on('modal:open', handleResize);
          parentPanel = range.$el.parents('.panel');
          parentPanel.on('panel:open panel:resize', handleResize);
          parentPage = range.$el.parents('.page').eq(0);
          parentPage.on('page:reinit', handleResize);
        };

        range.detachEvents = function detachEvents() {
          var passive = support.passiveListener ? {
            passive: true
          } : false;
          range.$el.off(app.touchEvents.start, handleTouchStart, passive);
          app.off('touchmove', handleTouchMove);
          app.off('touchend:passive', handleTouchEnd);
          app.off('tabShow', handleResize);
          app.off('resize', handleResize);

          if (parentModals) {
            parentModals.off('modal:open', handleResize);
          }

          if (parentPanel) {
            parentPanel.off('panel:open panel:resize', handleResize);
          }

          if (parentPage) {
            parentPage.off('page:reinit', handleResize);
          }

          parentModals = null;
          parentPanel = null;
          parentPage = null;
        }; // Install Modules


        range.useModules(); // Init

        range.init();
        return range || _assertThisInitialized(_this);
      }

      var _proto = Range.prototype;

      _proto.calcSize = function calcSize() {
        var range = this;

        if (range.vertical) {
          var height = range.$el.outerHeight();
          if (height === 0) return;
          range.rangeHeight = height;
          range.knobHeight = range.knobs[0].outerHeight();
        } else {
          var width = range.$el.outerWidth();
          if (width === 0) return;
          range.rangeWidth = width;
          range.knobWidth = range.knobs[0].outerWidth();
        }
      };

      _proto.layout = function layout() {
        var range = this;
        var app = range.app,
            knobWidth = range.knobWidth,
            knobHeight = range.knobHeight,
            rangeWidth = range.rangeWidth,
            rangeHeight = range.rangeHeight,
            min = range.min,
            max = range.max,
            knobs = range.knobs,
            $barActiveEl = range.$barActiveEl,
            value = range.value,
            label = range.label,
            labels = range.labels,
            vertical = range.vertical,
            verticalReversed = range.verticalReversed,
            limitKnobPosition = range.limitKnobPosition;
        var knobSize = vertical ? knobHeight : knobWidth;
        var rangeSize = vertical ? rangeHeight : rangeWidth; // eslint-disable-next-line

        var positionProperty = vertical ? verticalReversed ? 'top' : 'bottom' : app.rtl ? 'right' : 'left';

        if (range.dual) {
          var _$barActiveEl$css;

          var progress = [(value[0] - min) / (max - min), (value[1] - min) / (max - min)];
          $barActiveEl.css((_$barActiveEl$css = {}, _$barActiveEl$css[positionProperty] = progress[0] * 100 + "%", _$barActiveEl$css[vertical ? 'height' : 'width'] = (progress[1] - progress[0]) * 100 + "%", _$barActiveEl$css));
          knobs.forEach(function ($knobEl, knobIndex) {
            var startPos = rangeSize * progress[knobIndex];

            if (limitKnobPosition) {
              var realStartPos = rangeSize * progress[knobIndex] - knobSize / 2;
              if (realStartPos < 0) startPos = knobSize / 2;
              if (realStartPos + knobSize > rangeSize) startPos = rangeSize - knobSize / 2;
            }

            $knobEl.css(positionProperty, startPos + "px");
            if (label) labels[knobIndex].text(range.formatLabel(value[knobIndex], labels[knobIndex][0]));
          });
        } else {
          var _progress = (value - min) / (max - min);

          $barActiveEl.css(vertical ? 'height' : 'width', _progress * 100 + "%");
          var startPos = rangeSize * _progress;

          if (limitKnobPosition) {
            var realStartPos = rangeSize * _progress - knobSize / 2;
            if (realStartPos < 0) startPos = knobSize / 2;
            if (realStartPos + knobSize > rangeSize) startPos = rangeSize - knobSize / 2;
          }

          knobs[0].css(positionProperty, startPos + "px");
          if (label) labels[0].text(range.formatLabel(value, labels[0][0]));
        }

        if (range.dual && value.indexOf(min) >= 0 || !range.dual && value === min) {
          range.$el.addClass('range-slider-min');
        } else {
          range.$el.removeClass('range-slider-min');
        }

        if (range.dual && value.indexOf(max) >= 0 || !range.dual && value === max) {
          range.$el.addClass('range-slider-max');
        } else {
          range.$el.removeClass('range-slider-max');
        }
      };

      _proto.setValue = function setValue(newValue, byTouchMove) {
        var range = this;
        var step = range.step,
            min = range.min,
            max = range.max;
        var valueChanged;
        var oldValue;

        if (range.dual) {
          oldValue = [range.value[0], range.value[1]];
          var newValues = newValue;
          if (!Array.isArray(newValues)) newValues = [newValue, newValue];

          if (newValue[0] > newValue[1]) {
            newValues = [newValues[0], newValues[0]];
          }

          newValues = newValues.map(function (value) {
            return Math.max(Math.min(Math.round(value / step) * step, max), min);
          });

          if (newValues[0] === range.value[0] && newValues[1] === range.value[1]) {
            return range;
          }

          newValues.forEach(function (value, valueIndex) {
            range.value[valueIndex] = value;
          });
          valueChanged = oldValue[0] !== newValues[0] || oldValue[1] !== newValues[1];
          range.layout();
        } else {
          oldValue = range.value;
          var value = Math.max(Math.min(Math.round(newValue / step) * step, max), min);
          range.value = value;
          range.layout();
          valueChanged = oldValue !== value;
        }

        if (valueChanged) {
          range.previousValue = oldValue;
        } // Events


        if (!valueChanged) return range;
        range.$el.trigger('range:change', range.value);

        if (range.$inputEl && !range.dual) {
          range.$inputEl.val(range.value);

          if (!byTouchMove) {
            range.$inputEl.trigger('input change');
          } else {
            range.$inputEl.trigger('input');
          }
        }

        if (!byTouchMove) {
          range.$el.trigger('range:changed', range.value);
          range.emit('local::changed rangeChanged', range, range.value);
        }

        range.emit('local::change rangeChange', range, range.value);
        return range;
      };

      _proto.getValue = function getValue() {
        return this.value;
      };

      _proto.formatLabel = function formatLabel(value, labelEl) {
        var range = this;
        if (range.params.formatLabel) return range.params.formatLabel.call(range, value, labelEl);
        return value;
      };

      _proto.formatScaleLabel = function formatScaleLabel(value) {
        var range = this;
        if (range.params.formatScaleLabel) return range.params.formatScaleLabel.call(range, value);
        return value;
      };

      _proto.renderScale = function renderScale() {
        var range = this;
        var app = range.app,
            verticalReversed = range.verticalReversed,
            vertical = range.vertical; // eslint-disable-next-line

        var positionProperty = vertical ? verticalReversed ? 'top' : 'bottom' : app.rtl ? 'right' : 'left';
        var html = '';
        Array.from({
          length: range.scaleSteps + 1
        }).forEach(function (scaleEl, index) {
          var scaleStepValue = (range.max - range.min) / range.scaleSteps;
          var scaleValue = range.min + scaleStepValue * index;
          var progress = (scaleValue - range.min) / (range.max - range.min);
          html += "<div class=\"range-scale-step\" style=\"" + positionProperty + ": " + progress * 100 + "%\">" + range.formatScaleLabel(scaleValue) + "</div>";

          if (range.scaleSubSteps && range.scaleSubSteps > 1 && index < range.scaleSteps) {
            Array.from({
              length: range.scaleSubSteps - 1
            }).forEach(function (subStepEl, subIndex) {
              var subStep = scaleStepValue / range.scaleSubSteps;
              var scaleSubValue = scaleValue + subStep * (subIndex + 1);
              var subProgress = (scaleSubValue - range.min) / (range.max - range.min);
              html += "<div class=\"range-scale-step range-scale-substep\" style=\"" + positionProperty + ": " + subProgress * 100 + "%\"></div>";
            });
          }
        });
        return html;
      };

      _proto.updateScale = function updateScale() {
        var range = this;

        if (!range.scale || range.scaleSteps < 1) {
          if (range.$scaleEl) range.$scaleEl.remove();
          delete range.$scaleEl;
          return;
        }

        if (!range.$scaleEl) {
          range.$scaleEl = $('<div class="range-scale"></div>');
          range.$el.append(range.$scaleEl);
        }

        range.$scaleEl.html(range.renderScale());
      };

      _proto.init = function init() {
        var range = this;
        range.calcSize();
        range.layout();
        range.attachEvents();
        return range;
      };

      _proto.destroy = function destroy() {
        var range = this;
        range.$el.trigger('range:beforedestroy');
        range.emit('local::beforeDestroy rangeBeforeDestroy', range);
        delete range.$el[0].f7Range;
        range.detachEvents();
        deleteProps$1(range);
        range = null;
      };

      return Range;
    }(Framework7Class);

    var Range = {
      name: 'range',
      create: function create() {
        var app = this;
        app.range = extend$1(ConstructorMethods({
          defaultSelector: '.range-slider',
          constructor: Range$1,
          app: app,
          domProp: 'f7Range'
        }), {
          getValue: function getValue(el) {
            if (el === void 0) {
              el = '.range-slider';
            }

            var range = app.range.get(el);
            if (range) return range.getValue();
            return undefined;
          },
          setValue: function setValue(el, value) {
            if (el === void 0) {
              el = '.range-slider';
            }

            var range = app.range.get(el);
            if (range) return range.setValue(value);
            return undefined;
          }
        });
      },
      static: {
        Range: Range$1
      },
      on: {
        tabMounted: function tabMounted(tabEl) {
          var app = this;
          $(tabEl).find('.range-slider-init').each(function (rangeEl) {
            return new Range$1(app, {
              el: rangeEl
            });
          });
        },
        tabBeforeRemove: function tabBeforeRemove(tabEl) {
          $(tabEl).find('.range-slider-init').each(function (rangeEl) {
            if (rangeEl.f7Range) rangeEl.f7Range.destroy();
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.range-slider-init').each(function (rangeEl) {
            return new Range$1(app, {
              el: rangeEl
            });
          });
        },
        pageBeforeRemove: function pageBeforeRemove(page) {
          page.$el.find('.range-slider-init').each(function (rangeEl) {
            if (rangeEl.f7Range) rangeEl.f7Range.destroy();
          });
        }
      },
      vnode: {
        'range-slider-init': {
          insert: function insert(vnode) {
            var rangeEl = vnode.elm;
            var app = this;
            app.range.create({
              el: rangeEl
            });
          },
          destroy: function destroy(vnode) {
            var rangeEl = vnode.elm;
            if (rangeEl.f7Range) rangeEl.f7Range.destroy();
          }
        }
      }
    };

    var Stepper$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(Stepper, _Framework7Class);

      function Stepper(app, params) {
        var _this;

        _this = _Framework7Class.call(this, params, [app]) || this;

        var stepper = _assertThisInitialized(_this);

        var defaults = {
          el: null,
          inputEl: null,
          valueEl: null,
          value: 0,
          formatValue: null,
          step: 1,
          min: 0,
          max: 100,
          watchInput: true,
          autorepeat: false,
          autorepeatDynamic: false,
          wraps: false,
          manualInputMode: false,
          decimalPoint: 4,
          buttonsEndInputMode: true
        }; // Extend defaults with modules params

        stepper.useModulesParams(defaults);
        stepper.params = extend$1(defaults, params);

        if (stepper.params.value < stepper.params.min) {
          stepper.params.value = stepper.params.min;
        }

        if (stepper.params.value > stepper.params.max) {
          stepper.params.value = stepper.params.max;
        }

        var el = stepper.params.el;
        if (!el) return stepper || _assertThisInitialized(_this);
        var $el = $(el);
        if ($el.length === 0) return stepper || _assertThisInitialized(_this);
        if ($el[0].f7Stepper) return $el[0].f7Stepper || _assertThisInitialized(_this);
        var $inputEl;

        if (stepper.params.inputEl) {
          $inputEl = $(stepper.params.inputEl);
        } else if ($el.find('.stepper-input-wrap').find('input, textarea').length) {
          $inputEl = $el.find('.stepper-input-wrap').find('input, textarea').eq(0);
        }

        if ($inputEl && $inputEl.length) {
          'step min max'.split(' ').forEach(function (paramName) {
            if (!params[paramName] && $inputEl.attr(paramName)) {
              stepper.params[paramName] = parseFloat($inputEl.attr(paramName));
            }
          });

          var _decimalPoint = parseInt(stepper.params.decimalPoint, 10);

          if (Number.isNaN(_decimalPoint)) {
            stepper.params.decimalPoint = 0;
          } else {
            stepper.params.decimalPoint = _decimalPoint;
          }

          var inputValue = parseFloat($inputEl.val());

          if (typeof params.value === 'undefined' && !Number.isNaN(inputValue) && (inputValue || inputValue === 0)) {
            stepper.params.value = inputValue;
          }
        }

        var $valueEl;

        if (stepper.params.valueEl) {
          $valueEl = $(stepper.params.valueEl);
        } else if ($el.find('.stepper-value').length) {
          $valueEl = $el.find('.stepper-value').eq(0);
        }

        var $buttonPlusEl = $el.find('.stepper-button-plus');
        var $buttonMinusEl = $el.find('.stepper-button-minus');
        var _stepper$params = stepper.params,
            step = _stepper$params.step,
            min = _stepper$params.min,
            max = _stepper$params.max,
            value = _stepper$params.value,
            decimalPoint = _stepper$params.decimalPoint;
        extend$1(stepper, {
          app: app,
          $el: $el,
          el: $el[0],
          $buttonPlusEl: $buttonPlusEl,
          buttonPlusEl: $buttonPlusEl[0],
          $buttonMinusEl: $buttonMinusEl,
          buttonMinusEl: $buttonMinusEl[0],
          $inputEl: $inputEl,
          inputEl: $inputEl ? $inputEl[0] : undefined,
          $valueEl: $valueEl,
          valueEl: $valueEl ? $valueEl[0] : undefined,
          step: step,
          min: min,
          max: max,
          value: value,
          decimalPoint: decimalPoint,
          typeModeChanged: false
        });
        $el[0].f7Stepper = stepper; // Handle Events

        var touchesStart = {};
        var isTouched;
        var isScrolling;
        var preventButtonClick;
        var intervalId;
        var timeoutId;
        var autorepeatAction = null;
        var autorepeatInAction = false;
        var manualInput = false;

        function dynamicRepeat(current, progressions, startsIn, progressionStep, repeatEvery, action) {
          clearTimeout(timeoutId);
          timeoutId = setTimeout(function () {
            if (current === 1) {
              preventButtonClick = true;
              autorepeatInAction = true;
            }

            clearInterval(intervalId);
            action();
            intervalId = setInterval(function () {
              action();
            }, repeatEvery);

            if (current < progressions) {
              dynamicRepeat(current + 1, progressions, startsIn, progressionStep, repeatEvery / 2, action);
            }
          }, current === 1 ? startsIn : progressionStep);
        }

        function onTouchStart(e) {
          if (isTouched) return;

          if (manualInput) {
            return;
          }

          if ($(e.target).closest($buttonPlusEl).length) {
            autorepeatAction = 'increment';
          } else if ($(e.target).closest($buttonMinusEl).length) {
            autorepeatAction = 'decrement';
          }

          if (!autorepeatAction) return;
          touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
          touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
          isTouched = true;
          isScrolling = undefined;
          var progressions = stepper.params.autorepeatDynamic ? 4 : 1;
          dynamicRepeat(1, progressions, 500, 1000, 300, function () {
            stepper[autorepeatAction]();
          });
        }

        function onTouchMove(e) {
          if (!isTouched) return;

          if (manualInput) {
            return;
          }

          var pageX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
          var pageY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

          if (typeof isScrolling === 'undefined' && !autorepeatInAction) {
            isScrolling = !!(isScrolling || Math.abs(pageY - touchesStart.y) > Math.abs(pageX - touchesStart.x));
          }

          var distance = Math.pow(Math.pow(pageX - touchesStart.x, 2) + Math.pow(pageY - touchesStart.y, 2), 0.5);

          if (isScrolling || distance > 20) {
            isTouched = false;
            clearTimeout(timeoutId);
            clearInterval(intervalId);
          }
        }

        function onTouchEnd() {
          clearTimeout(timeoutId);
          clearInterval(intervalId);
          autorepeatAction = null;
          autorepeatInAction = false;
          isTouched = false;
        }

        function onMinusClick() {
          if (manualInput) {
            if (stepper.params.buttonsEndInputMode) {
              manualInput = false;
              stepper.endTypeMode(true);
            }

            return;
          }

          if (preventButtonClick) {
            preventButtonClick = false;
            return;
          }

          stepper.decrement(true);
        }

        function onPlusClick() {
          if (manualInput) {
            if (stepper.params.buttonsEndInputMode) {
              manualInput = false;
              stepper.endTypeMode(true);
            }

            return;
          }

          if (preventButtonClick) {
            preventButtonClick = false;
            return;
          }

          stepper.increment(true);
        }

        function onInputClick(e) {
          if (!e.target.readOnly && stepper.params.manualInputMode) {
            manualInput = true;

            if (typeof e.target.selectionStart === 'number') {
              e.target.selectionStart = e.target.value.length;
              e.target.selectionEnd = e.target.value.length;
            }
          }
        }

        function onInputKey(e) {
          if (e.keyCode === 13 || e.which === 13) {
            e.preventDefault();
            manualInput = false;
            stepper.endTypeMode();
          }
        }

        function onInputBlur() {
          manualInput = false;
          stepper.endTypeMode(true);
        }

        function onInput(e) {
          if (manualInput) {
            stepper.typeValue(e.target.value);
            return;
          }

          if (e.detail && e.detail.sentByF7Stepper) return;
          stepper.setValue(e.target.value, true);
        }

        stepper.attachEvents = function attachEvents() {
          $buttonMinusEl.on('click', onMinusClick);
          $buttonPlusEl.on('click', onPlusClick);

          if (stepper.params.watchInput && $inputEl && $inputEl.length) {
            $inputEl.on('input', onInput);
            $inputEl.on('click', onInputClick);
            $inputEl.on('blur', onInputBlur);
            $inputEl.on('keyup', onInputKey);
          }

          if (stepper.params.autorepeat) {
            app.on('touchstart:passive', onTouchStart);
            app.on('touchmove:active', onTouchMove);
            app.on('touchend:passive', onTouchEnd);
          }
        };

        stepper.detachEvents = function detachEvents() {
          $buttonMinusEl.off('click', onMinusClick);
          $buttonPlusEl.off('click', onPlusClick);

          if (stepper.params.watchInput && $inputEl && $inputEl.length) {
            $inputEl.off('input', onInput);
            $inputEl.off('click', onInputClick);
            $inputEl.off('blur', onInputBlur);
            $inputEl.off('keyup', onInputKey);
          }
        }; // Install Modules


        stepper.useModules(); // Init

        stepper.init();
        return stepper || _assertThisInitialized(_this);
      }

      var _proto = Stepper.prototype;

      _proto.minus = function minus() {
        return this.decrement();
      };

      _proto.plus = function plus() {
        return this.increment();
      };

      _proto.decrement = function decrement() {
        var stepper = this;
        return stepper.setValue(stepper.value - stepper.step, false, true);
      };

      _proto.increment = function increment() {
        var stepper = this;
        return stepper.setValue(stepper.value + stepper.step, false, true);
      };

      _proto.setValue = function setValue(newValue, forceUpdate, withWraps) {
        var stepper = this;
        var step = stepper.step,
            min = stepper.min,
            max = stepper.max;
        var oldValue = stepper.value;
        var value = Math.round(newValue / step) * step;

        if (stepper.params.wraps && withWraps) {
          if (value > max) value = min;
          if (value < min) value = max;
        } else {
          value = Math.max(Math.min(value, max), min);
        }

        if (Number.isNaN(value)) {
          value = oldValue;
        }

        stepper.value = value;
        var valueChanged = oldValue !== value; // Events

        if (!valueChanged && !forceUpdate) return stepper;
        stepper.$el.trigger('stepper:change', stepper.value);
        var formattedValue = stepper.formatValue(stepper.value);

        if (stepper.$inputEl && stepper.$inputEl.length) {
          stepper.$inputEl.val(formattedValue);
          stepper.$inputEl.trigger('input change', {
            sentByF7Stepper: true
          });
        }

        if (stepper.$valueEl && stepper.$valueEl.length) {
          stepper.$valueEl.html(formattedValue);
        }

        stepper.emit('local::change stepperChange', stepper, stepper.value);
        return stepper;
      };

      _proto.endTypeMode = function endTypeMode(noBlur) {
        var stepper = this;
        var min = stepper.min,
            max = stepper.max;
        var value = parseFloat(stepper.value);
        if (Number.isNaN(value)) value = 0;
        value = Math.max(Math.min(value, max), min);
        stepper.value = value;

        if (!stepper.typeModeChanged) {
          if (stepper.$inputEl && stepper.$inputEl.length && !noBlur) {
            stepper.$inputEl.blur();
          }

          return stepper;
        }

        stepper.typeModeChanged = false;
        stepper.$el.trigger('stepper:change', stepper.value);
        var formattedValue = stepper.formatValue(stepper.value);

        if (stepper.$inputEl && stepper.$inputEl.length) {
          stepper.$inputEl.val(formattedValue);
          stepper.$inputEl.trigger('input change', {
            sentByF7Stepper: true
          });
          if (!noBlur) stepper.$inputEl.blur();
        }

        if (stepper.$valueEl && stepper.$valueEl.length) {
          stepper.$valueEl.html(formattedValue);
        }

        stepper.emit('local::change stepperChange', stepper, stepper.value);
        return stepper;
      };

      _proto.typeValue = function typeValue(value) {
        var stepper = this;
        stepper.typeModeChanged = true;
        var inputTxt = String(value);
        if (inputTxt.length === 1 && inputTxt === '-') return stepper;

        if (inputTxt.lastIndexOf('.') + 1 === inputTxt.length || inputTxt.lastIndexOf(',') + 1 === inputTxt.length) {
          if (inputTxt.lastIndexOf('.') !== inputTxt.indexOf('.') || inputTxt.lastIndexOf(',') !== inputTxt.indexOf(',')) {
            inputTxt = inputTxt.slice(0, -1);
            stepper.value = inputTxt;
            stepper.$inputEl.val(stepper.value);
            return stepper;
          }
        } else {
          var newValue = parseFloat(inputTxt.replace(',', '.'));

          if (newValue === 0) {
            stepper.value = inputTxt.replace(',', '.');
            stepper.$inputEl.val(stepper.value);
            return stepper;
          }

          if (Number.isNaN(newValue)) {
            stepper.value = 0;
            stepper.$inputEl.val(stepper.value);
            return stepper;
          }

          var powVal = Math.pow(10, stepper.params.decimalPoint);
          newValue = Math.round(newValue * powVal).toFixed(stepper.params.decimalPoint + 1) / powVal;
          stepper.value = parseFloat(String(newValue).replace(',', '.'));
          stepper.$inputEl.val(stepper.value);
          return stepper;
        }

        stepper.value = inputTxt;
        stepper.$inputEl.val(inputTxt);
        return stepper;
      };

      _proto.getValue = function getValue() {
        return this.value;
      };

      _proto.formatValue = function formatValue(value) {
        var stepper = this;
        if (!stepper.params.formatValue) return value;
        return stepper.params.formatValue.call(stepper, value);
      };

      _proto.init = function init() {
        var stepper = this;
        stepper.attachEvents();

        if (stepper.$valueEl && stepper.$valueEl.length) {
          var formattedValue = stepper.formatValue(stepper.value);
          stepper.$valueEl.html(formattedValue);
        }

        return stepper;
      };

      _proto.destroy = function destroy() {
        var stepper = this;
        stepper.$el.trigger('stepper:beforedestroy');
        stepper.emit('local::beforeDestroy stepperBeforeDestroy', stepper);
        delete stepper.$el[0].f7Stepper;
        stepper.detachEvents();
        deleteProps$1(stepper);
        stepper = null;
      };

      return Stepper;
    }(Framework7Class);

    var Stepper = {
      name: 'stepper',
      create: function create() {
        var app = this;
        app.stepper = extend$1(ConstructorMethods({
          defaultSelector: '.stepper',
          constructor: Stepper$1,
          app: app,
          domProp: 'f7Stepper'
        }), {
          getValue: function getValue(el) {
            if (el === void 0) {
              el = '.stepper';
            }

            var stepper = app.stepper.get(el);
            if (stepper) return stepper.getValue();
            return undefined;
          },
          setValue: function setValue(el, value) {
            if (el === void 0) {
              el = '.stepper';
            }

            var stepper = app.stepper.get(el);
            if (stepper) return stepper.setValue(value);
            return undefined;
          }
        });
      },
      static: {
        Stepper: Stepper$1
      },
      on: {
        tabMounted: function tabMounted(tabEl) {
          var app = this;
          $(tabEl).find('.stepper-init').each(function (stepperEl) {
            var dataset = $(stepperEl).dataset();
            app.stepper.create(extend$1({
              el: stepperEl
            }, dataset || {}));
          });
        },
        tabBeforeRemove: function tabBeforeRemove(tabEl) {
          $(tabEl).find('.stepper-init').each(function (stepperEl) {
            if (stepperEl.f7Stepper) stepperEl.f7Stepper.destroy();
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.stepper-init').each(function (stepperEl) {
            var dataset = $(stepperEl).dataset();
            app.stepper.create(extend$1({
              el: stepperEl
            }, dataset || {}));
          });
        },
        pageBeforeRemove: function pageBeforeRemove(page) {
          page.$el.find('.stepper-init').each(function (stepperEl) {
            if (stepperEl.f7Stepper) stepperEl.f7Stepper.destroy();
          });
        }
      },
      vnode: {
        'stepper-init': {
          insert: function insert(vnode) {
            var app = this;
            var stepperEl = vnode.elm;
            var dataset = $(stepperEl).dataset();
            app.stepper.create(extend$1({
              el: stepperEl
            }, dataset || {}));
          },
          destroy: function destroy(vnode) {
            var stepperEl = vnode.elm;
            if (stepperEl.f7Stepper) stepperEl.f7Stepper.destroy();
          }
        }
      }
    };

    var SmartSelect$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(SmartSelect, _Framework7Class);

      function SmartSelect(app, params) {
        var _this;

        if (params === void 0) {
          params = {};
        }

        _this = _Framework7Class.call(this, params, [app]) || this;

        var ss = _assertThisInitialized(_this);

        var defaults = extend$1({
          on: {}
        }, app.params.smartSelect);

        if (typeof defaults.searchbarDisableButton === 'undefined') {
          defaults.searchbarDisableButton = app.theme !== 'aurora';
        } // Extend defaults with modules params


        ss.useModulesParams(defaults);
        ss.params = extend$1({}, defaults, params);
        ss.app = app;
        var $el = $(ss.params.el).eq(0);
        if ($el.length === 0) return ss || _assertThisInitialized(_this);
        if ($el[0].f7SmartSelect) return $el[0].f7SmartSelect || _assertThisInitialized(_this);
        var $selectEl = $el.find('select').eq(0);
        if ($selectEl.length === 0) return ss || _assertThisInitialized(_this);
        var $valueEl;

        if (ss.params.setValueText) {
          $valueEl = $(ss.params.valueEl);

          if ($valueEl.length === 0) {
            $valueEl = $el.find('.item-after');
          }

          if ($valueEl.length === 0) {
            $valueEl = $('<div class="item-after"></div>');
            $valueEl.insertAfter($el.find('.item-title'));
          }
        } // Url


        var url = params.url;

        if (!url) {
          if ($el.attr('href') && $el.attr('href') !== '#') url = $el.attr('href');else if ($selectEl.attr('name')) url = $selectEl.attr('name').toLowerCase() + "-select/";
        }

        if (!url) url = ss.params.url;
        var multiple = $selectEl[0].multiple;
        var inputType = multiple ? 'checkbox' : 'radio';
        var selectId = id();
        extend$1(ss, {
          $el: $el,
          el: $el[0],
          $selectEl: $selectEl,
          selectEl: $selectEl[0],
          $valueEl: $valueEl,
          valueEl: $valueEl && $valueEl[0],
          url: url,
          multiple: multiple,
          inputType: inputType,
          id: selectId,
          inputName: inputType + "-" + selectId,
          selectName: $selectEl.attr('name'),
          maxLength: $selectEl.attr('maxlength') || params.maxLength
        });
        $el[0].f7SmartSelect = ss; // Events

        function onClick() {
          ss.open();
        }

        function onChange() {
          var value = ss.$selectEl.val();
          ss.$el.trigger('smartselect:change', value);
          ss.emit('local::change smartSelectChange', ss, value);

          if (ss.vl) {
            ss.vl.clearCache();
          }

          ss.setValueText();
        }

        ss.attachEvents = function attachEvents() {
          $el.on('click', onClick);
          $el.on('change', 'select', onChange);
        };

        ss.detachEvents = function detachEvents() {
          $el.off('click', onClick);
          $el.off('change', 'select', onChange);
        };

        function handleInputChange() {
          var optionEl;
          var text;
          var inputEl = this;
          var value = inputEl.value;
          var optionText = [];
          var displayAs;

          if (inputEl.type === 'checkbox') {
            for (var i = 0; i < ss.selectEl.options.length; i += 1) {
              optionEl = ss.selectEl.options[i];

              if (optionEl.value === value) {
                optionEl.selected = inputEl.checked;
              }

              if (optionEl.selected) {
                displayAs = optionEl.dataset ? optionEl.dataset.displayAs : $(optionEl).data('display-value-as');
                text = displayAs && typeof displayAs !== 'undefined' ? displayAs : optionEl.textContent;
                optionText.push(text.trim());
              }
            }

            if (ss.maxLength) {
              ss.checkMaxLength();
            }
          } else {
            optionEl = ss.$selectEl.find("option[value=\"" + value + "\"]")[0];

            if (!optionEl) {
              optionEl = ss.$selectEl.find('option').filter(function (optEl) {
                return optEl.value === value;
              })[0];
            }

            displayAs = optionEl.dataset ? optionEl.dataset.displayAs : $(optionEl).data('display-as');
            text = displayAs && typeof displayAs !== 'undefined' ? displayAs : optionEl.textContent;
            optionText = [text];
            ss.selectEl.value = value;
          }

          ss.$selectEl.trigger('change');

          if (ss.params.setValueText) {
            ss.$valueEl.text(ss.formatValueText(optionText));
          }

          if (ss.params.closeOnSelect && ss.inputType === 'radio') {
            ss.close();
          }
        }

        ss.attachInputsEvents = function attachInputsEvents() {
          ss.$containerEl.on('change', 'input[type="checkbox"], input[type="radio"]', handleInputChange);
        };

        ss.detachInputsEvents = function detachInputsEvents() {
          ss.$containerEl.off('change', 'input[type="checkbox"], input[type="radio"]', handleInputChange);
        }; // Install Modules


        ss.useModules(); // Init

        ss.init();
        return ss || _assertThisInitialized(_this);
      }

      var _proto = SmartSelect.prototype;

      _proto.setValue = function setValue(value) {
        var ss = this;
        var newValue = value;
        var optionText = [];
        var optionEl;
        var displayAs;
        var text;

        if (ss.multiple) {
          if (!Array.isArray(newValue)) newValue = [newValue];

          for (var i = 0; i < ss.selectEl.options.length; i += 1) {
            optionEl = ss.selectEl.options[i];

            if (newValue.indexOf(optionEl.value) >= 0) {
              optionEl.selected = true;
            } else {
              optionEl.selected = false;
            }

            if (optionEl.selected) {
              displayAs = optionEl.dataset ? optionEl.dataset.displayAs : $(optionEl).data('display-value-as');
              text = displayAs && typeof displayAs !== 'undefined' ? displayAs : optionEl.textContent;
              optionText.push(text.trim());
            }
          }
        } else {
          optionEl = ss.$selectEl.find("option[value=\"" + newValue + "\"]")[0];

          if (optionEl) {
            displayAs = optionEl.dataset ? optionEl.dataset.displayAs : $(optionEl).data('display-as');
            text = displayAs && typeof displayAs !== 'undefined' ? displayAs : optionEl.textContent;
            optionText = [text];
          }

          ss.selectEl.value = newValue;
        }

        if (ss.params.setValueText) {
          ss.$valueEl.text(ss.formatValueText(optionText));
        }

        ss.$selectEl.trigger('change');
        return ss;
      };

      _proto.unsetValue = function unsetValue() {
        var ss = this;

        if (ss.params.setValueText) {
          ss.$valueEl.text(ss.formatValueText([]));
        }

        ss.$selectEl.find('option').each(function (optionEl) {
          optionEl.selected = false;
          optionEl.checked = false;
        });
        ss.$selectEl[0].value = null;

        if (ss.$containerEl) {
          ss.$containerEl.find("input[name=\"" + ss.inputName + "\"][type=\"checkbox\"], input[name=\"" + ss.inputName + "\"][type=\"radio\"]").prop('checked', false);
        }

        ss.$selectEl.trigger('change');
      };

      _proto.getValue = function getValue() {
        var ss = this;
        return ss.$selectEl.val();
      };

      _proto.checkMaxLength = function checkMaxLength() {
        var ss = this;
        var $containerEl = ss.$containerEl;

        if (ss.selectEl.selectedOptions.length >= ss.maxLength) {
          $containerEl.find('input[type="checkbox"]').each(function (inputEl) {
            if (!inputEl.checked) {
              $(inputEl).parents('li').addClass('disabled');
            } else {
              $(inputEl).parents('li').removeClass('disabled');
            }
          });
        } else {
          $containerEl.find('.disabled').removeClass('disabled');
        }
      };

      _proto.formatValueText = function formatValueText(values) {
        var ss = this;
        var textValue;

        if (ss.params.formatValueText) {
          textValue = ss.params.formatValueText.call(ss, values, ss);
        } else {
          textValue = values.join(', ');
        }

        return textValue;
      };

      _proto.setValueText = function setValueText(value) {
        var ss = this;
        var valueArray = [];

        if (typeof value !== 'undefined') {
          if (Array.isArray(value)) {
            valueArray = value;
          } else {
            valueArray = [value];
          }
        } else {
          ss.$selectEl.find('option').each(function (optionEl) {
            var $optionEl = $(optionEl);

            if (optionEl.selected) {
              var displayAs = optionEl.dataset ? optionEl.dataset.displayAs : $optionEl.data('display-value-as');

              if (displayAs && typeof displayAs !== 'undefined') {
                valueArray.push(displayAs);
              } else {
                valueArray.push(optionEl.textContent.trim());
              }
            }
          });
        }

        if (ss.params.setValueText) {
          ss.$valueEl.text(ss.formatValueText(valueArray));
        }
      };

      _proto.getItemsData = function getItemsData() {
        var ss = this;
        var theme = ss.app.theme;
        var items = [];
        var previousGroupEl;
        ss.$selectEl.find('option').each(function (optionEl) {
          var $optionEl = $(optionEl);
          var optionData = $optionEl.dataset();
          var optionImage = optionData.optionImage || ss.params.optionImage;
          var optionIcon = optionData.optionIcon || ss.params.optionIcon;
          var optionIconIos = theme === 'ios' && (optionData.optionIconIos || ss.params.optionIconIos);
          var optionIconMd = theme === 'md' && (optionData.optionIconMd || ss.params.optionIconMd);
          var optionIconAurora = theme === 'aurora' && (optionData.optionIconAurora || ss.params.optionIconAurora);
          var optionHasMedia = optionImage || optionIcon || optionIconIos || optionIconMd || optionIconAurora;
          var optionColor = optionData.optionColor;
          var optionClassName = optionData.optionClass || '';
          if ($optionEl[0].disabled) optionClassName += ' disabled';
          var optionGroupEl = $optionEl.parent('optgroup')[0];
          var optionGroupLabel = optionGroupEl && optionGroupEl.label;
          var optionIsLabel = false;

          if (optionGroupEl && optionGroupEl !== previousGroupEl) {
            optionIsLabel = true;
            previousGroupEl = optionGroupEl;
            items.push({
              groupLabel: optionGroupLabel,
              isLabel: optionIsLabel
            });
          }

          items.push({
            value: $optionEl[0].value,
            text: $optionEl[0].textContent.trim(),
            selected: $optionEl[0].selected,
            groupEl: optionGroupEl,
            groupLabel: optionGroupLabel,
            image: optionImage,
            icon: optionIcon,
            iconIos: optionIconIos,
            iconMd: optionIconMd,
            iconAurora: optionIconAurora,
            color: optionColor,
            className: optionClassName,
            disabled: $optionEl[0].disabled,
            id: ss.id,
            hasMedia: optionHasMedia,
            checkbox: ss.inputType === 'checkbox',
            radio: ss.inputType === 'radio',
            inputName: ss.inputName,
            inputType: ss.inputType
          });
        });
        ss.items = items;
        return items;
      };

      _proto.renderSearchbar = function renderSearchbar() {
        var ss = this;
        if (ss.params.renderSearchbar) return ss.params.renderSearchbar.call(ss);
        return $jsx("form", {
          class: "searchbar"
        }, $jsx("div", {
          class: "searchbar-inner"
        }, $jsx("div", {
          class: "searchbar-input-wrap"
        }, $jsx("input", {
          type: "search",
          spellcheck: ss.params.searchbarSpellcheck || 'false',
          placeholder: ss.params.searchbarPlaceholder
        }), $jsx("i", {
          class: "searchbar-icon"
        }), $jsx("span", {
          class: "input-clear-button"
        })), ss.params.searchbarDisableButton && $jsx("span", {
          class: "searchbar-disable-button"
        }, ss.params.searchbarDisableText)));
      };

      _proto.renderItem = function renderItem(item, index) {
        var ss = this;
        if (ss.params.renderItem) return ss.params.renderItem.call(ss, item, index);

        function getIconContent(iconValue) {
          if (iconValue === void 0) {
            iconValue = '';
          }

          if (iconValue.indexOf(':') >= 0) {
            return iconValue.split(':')[1];
          }

          return '';
        }

        function getIconClass(iconValue) {
          if (iconValue === void 0) {
            iconValue = '';
          }

          if (iconValue.indexOf(':') >= 0) {
            var className = iconValue.split(':')[0];
            if (className === 'f7') className = 'f7-icons';
            if (className === 'material') className = 'material-icons';
            return className;
          }

          return iconValue;
        }

        var itemHtml;

        if (item.isLabel) {
          itemHtml = "<li class=\"item-divider\">" + item.groupLabel + "</li>";
        } else {
          var selected = item.selected;
          var disabled;

          if (ss.params.virtualList) {
            var ssValue = ss.getValue();
            selected = ss.multiple ? ssValue.indexOf(item.value) >= 0 : ssValue === item.value;

            if (ss.multiple) {
              disabled = ss.multiple && !selected && ssValue.length === parseInt(ss.maxLength, 10);
            }
          }

          var icon = item.icon,
              iconIos = item.iconIos,
              iconMd = item.iconMd,
              iconAurora = item.iconAurora;
          var hasIcon = icon || iconIos || iconMd || iconAurora;
          var iconContent = getIconContent(icon || iconIos || iconMd || iconAurora || '');
          var iconClass = getIconClass(icon || iconIos || iconMd || iconAurora || '');
          itemHtml = $jsx("li", {
            class: "" + (item.className || '') + (disabled ? ' disabled' : '')
          }, $jsx("label", {
            class: "item-" + item.inputType + " item-content"
          }, $jsx("input", {
            type: item.inputType,
            name: item.inputName,
            value: item.value,
            _checked: selected
          }), $jsx("i", {
            class: "icon icon-" + item.inputType
          }), item.hasMedia && $jsx("div", {
            class: "item-media"
          }, hasIcon && $jsx("i", {
            class: "icon " + iconClass
          }, iconContent), item.image && $jsx("img", {
            src: item.image
          })), $jsx("div", {
            class: "item-inner"
          }, $jsx("div", {
            class: "item-title" + (item.color ? " text-color-" + item.color : '')
          }, item.text))));
        }

        return itemHtml;
      };

      _proto.renderItems = function renderItems() {
        var ss = this;
        if (ss.params.renderItems) return ss.params.renderItems.call(ss, ss.items);
        var itemsHtml = "\n      " + ss.items.map(function (item, index) {
          return "" + ss.renderItem(item, index);
        }).join('') + "\n    ";
        return itemsHtml;
      };

      _proto.renderPage = function renderPage() {
        var ss = this;
        if (ss.params.renderPage) return ss.params.renderPage.call(ss, ss.items);
        var pageTitle = ss.params.pageTitle;

        if (typeof pageTitle === 'undefined') {
          var $itemTitleEl = ss.$el.find('.item-title');
          pageTitle = $itemTitleEl.length ? $itemTitleEl.text().trim() : '';
        }

        var cssClass = ss.params.cssClass;
        return $jsx("div", {
          class: "page smart-select-page " + cssClass,
          "data-name": "smart-select-page",
          "data-select-name": ss.selectName
        }, $jsx("div", {
          class: "navbar " + (ss.params.navbarColorTheme ? "color-" + ss.params.navbarColorTheme : '')
        }, $jsx("div", {
          class: "navbar-bg"
        }), $jsx("div", {
          class: "navbar-inner sliding " + (ss.params.navbarColorTheme ? "color-" + ss.params.navbarColorTheme : '')
        }, $jsx("div", {
          class: "left"
        }, $jsx("a", {
          class: "link back"
        }, $jsx("i", {
          class: "icon icon-back"
        }), $jsx("span", {
          class: "if-not-md"
        }, ss.params.pageBackLinkText))), pageTitle && $jsx("div", {
          class: "title"
        }, pageTitle), ss.params.searchbar && $jsx("div", {
          class: "subnavbar"
        }, ss.renderSearchbar()))), ss.params.searchbar && $jsx("div", {
          class: "searchbar-backdrop"
        }), $jsx("div", {
          class: "page-content"
        }, $jsx("div", {
          class: "list smart-select-list-" + ss.id + " " + (ss.params.virtualList ? ' virtual-list' : '') + " " + (ss.params.formColorTheme ? "color-" + ss.params.formColorTheme : '')
        }, $jsx("ul", null, !ss.params.virtualList && ss.renderItems(ss.items)))));
      };

      _proto.renderPopup = function renderPopup() {
        var ss = this;
        if (ss.params.renderPopup) return ss.params.renderPopup.call(ss, ss.items);
        var pageTitle = ss.params.pageTitle;

        if (typeof pageTitle === 'undefined') {
          var $itemTitleEl = ss.$el.find('.item-title');
          pageTitle = $itemTitleEl.length ? $itemTitleEl.text().trim() : '';
        }

        var cssClass = ss.params.cssClass || '';
        return $jsx("div", {
          class: "popup smart-select-popup " + cssClass + " " + (ss.params.popupTabletFullscreen ? 'popup-tablet-fullscreen' : ''),
          "data-select-name": ss.selectName
        }, $jsx("div", {
          class: "view"
        }, $jsx("div", {
          class: "page smart-select-page " + (ss.params.searchbar ? 'page-with-subnavbar' : ''),
          "data-name": "smart-select-page"
        }, $jsx("div", {
          class: "navbar " + (ss.params.navbarColorTheme ? "color-" + ss.params.navbarColorTheme : '')
        }, $jsx("div", {
          class: "navbar-bg"
        }), $jsx("div", {
          class: "navbar-inner sliding"
        }, pageTitle && $jsx("div", {
          class: "title"
        }, pageTitle), $jsx("div", {
          class: "right"
        }, $jsx("a", {
          class: "link popup-close",
          "data-popup": ".smart-select-popup[data-select-name='" + ss.selectName + "']"
        }, ss.params.popupCloseLinkText)), ss.params.searchbar && $jsx("div", {
          class: "subnavbar"
        }, ss.renderSearchbar()))), ss.params.searchbar && $jsx("div", {
          class: "searchbar-backdrop"
        }), $jsx("div", {
          class: "page-content"
        }, $jsx("div", {
          class: "list smart-select-list-" + ss.id + " " + (ss.params.virtualList ? ' virtual-list' : '') + " " + (ss.params.formColorTheme ? "color-" + ss.params.formColorTheme : '')
        }, $jsx("ul", null, !ss.params.virtualList && ss.renderItems(ss.items)))))));
      };

      _proto.renderSheet = function renderSheet() {
        var ss = this;
        if (ss.params.renderSheet) return ss.params.renderSheet.call(ss, ss.items);
        var cssClass = ss.params.cssClass; // prettier-ignore

        return $jsx("div", {
          class: "sheet-modal smart-select-sheet " + cssClass,
          "data-select-name": ss.selectName
        }, $jsx("div", {
          class: "toolbar toolbar-top " + (ss.params.toolbarColorTheme ? "color-" + ss.params.toolbarColorTheme : '')
        }, $jsx("div", {
          class: "toolbar-inner"
        }, $jsx("div", {
          class: "left"
        }), $jsx("div", {
          class: "right"
        }, $jsx("a", {
          class: "link sheet-close"
        }, ss.params.sheetCloseLinkText)))), $jsx("div", {
          class: "sheet-modal-inner"
        }, $jsx("div", {
          class: "page-content"
        }, $jsx("div", {
          class: "list smart-select-list-" + ss.id + " " + (ss.params.virtualList ? ' virtual-list' : '') + " " + (ss.params.formColorTheme ? "color-" + ss.params.formColorTheme : '')
        }, $jsx("ul", null, !ss.params.virtualList && ss.renderItems(ss.items))))));
      };

      _proto.renderPopover = function renderPopover() {
        var ss = this;
        if (ss.params.renderPopover) return ss.params.renderPopover.call(ss, ss.items);
        var cssClass = ss.params.cssClass; // prettier-ignore

        return $jsx("div", {
          class: "popover smart-select-popover " + cssClass,
          "data-select-name": ss.selectName
        }, $jsx("div", {
          class: "popover-inner"
        }, $jsx("div", {
          class: "list smart-select-list-" + ss.id + " " + (ss.params.virtualList ? ' virtual-list' : '') + " " + (ss.params.formColorTheme ? "color-" + ss.params.formColorTheme : '')
        }, $jsx("ul", null, !ss.params.virtualList && ss.renderItems(ss.items)))));
      };

      _proto.scrollToSelectedItem = function scrollToSelectedItem() {
        var ss = this;
        var params = ss.params,
            $containerEl = ss.$containerEl;
        if (!ss.opened) return ss;

        if (params.virtualList) {
          var selectedIndex;
          ss.vl.items.forEach(function (item, index) {
            if (typeof selectedIndex === 'undefined' && item.selected) {
              selectedIndex = index;
            }
          });

          if (typeof selectedIndex !== 'undefined') {
            ss.vl.scrollToItem(selectedIndex);
          }
        } else {
          var $selectedItemEl = $containerEl.find('input:checked').parents('li');
          if (!$selectedItemEl.length) return ss;
          var $scrollableEl = $containerEl.find('.page-content, .popover-inner');
          if (!$scrollableEl.length) return ss;
          $scrollableEl.scrollTop($selectedItemEl.offset().top - $scrollableEl.offset().top - parseInt($scrollableEl.css('padding-top'), 10));
        }

        return ss;
      };

      _proto.onOpen = function onOpen(type, containerEl) {
        var ss = this;
        var app = ss.app;
        var $containerEl = $(containerEl);
        ss.$containerEl = $containerEl;
        ss.openedIn = type;
        ss.opened = true; // Init VL

        if (ss.params.virtualList) {
          ss.vl = app.virtualList.create({
            el: $containerEl.find('.virtual-list'),
            items: ss.items,
            renderItem: ss.renderItem.bind(ss),
            height: ss.params.virtualListHeight,
            searchByItem: function searchByItem(query, item) {
              if (item.text && item.text.toLowerCase().indexOf(query.trim().toLowerCase()) >= 0) return true;
              return false;
            }
          });
        }

        if (ss.params.scrollToSelectedItem) {
          ss.scrollToSelectedItem();
        } // Init SB


        if (ss.params.searchbar) {
          var $searchbarEl = $containerEl.find('.searchbar');

          if (type === 'page' && app.theme === 'ios') {
            $searchbarEl = $(app.navbar.getElByPage($containerEl)).find('.searchbar');
          }

          if (ss.params.appendSearchbarNotFound && (type === 'page' || type === 'popup')) {
            var $notFoundEl = null;

            if (typeof ss.params.appendSearchbarNotFound === 'string') {
              $notFoundEl = $("<div class=\"block searchbar-not-found\">" + ss.params.appendSearchbarNotFound + "</div>");
            } else if (typeof ss.params.appendSearchbarNotFound === 'boolean') {
              $notFoundEl = $('<div class="block searchbar-not-found">Nothing found</div>');
            } else {
              $notFoundEl = ss.params.appendSearchbarNotFound;
            }

            if ($notFoundEl) {
              $containerEl.find('.page-content').append($notFoundEl[0]);
            }
          }

          var searchbarParams = extend$1({
            el: $searchbarEl,
            backdropEl: $containerEl.find('.searchbar-backdrop'),
            searchContainer: ".smart-select-list-" + ss.id,
            searchIn: '.item-title'
          }, typeof ss.params.searchbar === 'object' ? ss.params.searchbar : {});
          ss.searchbar = app.searchbar.create(searchbarParams);
        } // Check for max length


        if (ss.maxLength) {
          ss.checkMaxLength();
        } // Close on select


        if (ss.params.closeOnSelect) {
          ss.$containerEl.find("input[type=\"radio\"][name=\"" + ss.inputName + "\"]:checked").parents('label').once('click', function () {
            ss.close();
          });
        } // Attach input events


        ss.attachInputsEvents();
        ss.$el.trigger('smartselect:open');
        ss.emit('local::open smartSelectOpen', ss);
      };

      _proto.onOpened = function onOpened() {
        var ss = this;
        ss.$el.trigger('smartselect:opened');
        ss.emit('local::opened smartSelectOpened', ss);
      };

      _proto.onClose = function onClose() {
        var ss = this;
        if (ss.destroyed) return; // Destroy VL

        if (ss.vl && ss.vl.destroy) {
          ss.vl.destroy();
          ss.vl = null;
          delete ss.vl;
        } // Destroy SB


        if (ss.searchbar && ss.searchbar.destroy) {
          ss.searchbar.destroy();
          ss.searchbar = null;
          delete ss.searchbar;
        } // Detach events


        ss.detachInputsEvents();
        ss.$el.trigger('smartselect:close');
        ss.emit('local::close smartSelectClose', ss);
      };

      _proto.onClosed = function onClosed() {
        var ss = this;
        if (ss.destroyed) return;
        ss.opened = false;
        ss.$containerEl = null;
        delete ss.$containerEl;
        ss.$el.trigger('smartselect:closed');
        ss.emit('local::closed smartSelectClosed', ss);
      };

      _proto.openPage = function openPage() {
        var ss = this;
        if (ss.opened) return ss;
        ss.getItemsData();
        var pageHtml = ss.renderPage(ss.items);
        ss.view.router.navigate({
          url: ss.url,
          route: {
            content: pageHtml,
            path: ss.url,
            on: {
              pageBeforeIn: function pageBeforeIn(e, page) {
                ss.onOpen('page', page.el);
              },
              pageAfterIn: function pageAfterIn(e, page) {
                ss.onOpened('page', page.el);
              },
              pageBeforeOut: function pageBeforeOut(e, page) {
                ss.onClose('page', page.el);
              },
              pageAfterOut: function pageAfterOut(e, page) {
                ss.onClosed('page', page.el);
              }
            }
          }
        });
        return ss;
      };

      _proto.openPopup = function openPopup() {
        var ss = this;
        if (ss.opened) return ss;
        ss.getItemsData();
        var popupHtml = ss.renderPopup(ss.items);
        var popupParams = {
          content: popupHtml,
          push: ss.params.popupPush,
          swipeToClose: ss.params.popupSwipeToClose,
          on: {
            popupOpen: function popupOpen(popup) {
              ss.onOpen('popup', popup.el);
            },
            popupOpened: function popupOpened(popup) {
              ss.onOpened('popup', popup.el);
            },
            popupClose: function popupClose(popup) {
              ss.onClose('popup', popup.el);
            },
            popupClosed: function popupClosed(popup) {
              ss.onClosed('popup', popup.el);
            }
          }
        };

        if (ss.params.routableModals && ss.view) {
          ss.view.router.navigate({
            url: ss.url,
            route: {
              path: ss.url,
              popup: popupParams
            }
          });
        } else {
          ss.modal = ss.app.popup.create(popupParams).open();
        }

        return ss;
      };

      _proto.openSheet = function openSheet() {
        var ss = this;
        if (ss.opened) return ss;
        ss.getItemsData();
        var sheetHtml = ss.renderSheet(ss.items);
        var sheetParams = {
          content: sheetHtml,
          backdrop: ss.params.sheetBackdrop,
          scrollToEl: ss.$el,
          closeByOutsideClick: true,
          push: ss.params.sheetPush,
          swipeToClose: ss.params.sheetSwipeToClose,
          on: {
            sheetOpen: function sheetOpen(sheet) {
              ss.onOpen('sheet', sheet.el);
            },
            sheetOpened: function sheetOpened(sheet) {
              ss.onOpened('sheet', sheet.el);
            },
            sheetClose: function sheetClose(sheet) {
              ss.onClose('sheet', sheet.el);
            },
            sheetClosed: function sheetClosed(sheet) {
              ss.onClosed('sheet', sheet.el);
            }
          }
        };

        if (ss.params.routableModals && ss.view) {
          ss.view.router.navigate({
            url: ss.url,
            route: {
              path: ss.url,
              sheet: sheetParams
            }
          });
        } else {
          ss.modal = ss.app.sheet.create(sheetParams).open();
        }

        return ss;
      };

      _proto.openPopover = function openPopover() {
        var ss = this;
        if (ss.opened) return ss;
        ss.getItemsData();
        var popoverHtml = ss.renderPopover(ss.items);
        var popoverParams = {
          content: popoverHtml,
          targetEl: ss.$el,
          on: {
            popoverOpen: function popoverOpen(popover) {
              ss.onOpen('popover', popover.el);
            },
            popoverOpened: function popoverOpened(popover) {
              ss.onOpened('popover', popover.el);
            },
            popoverClose: function popoverClose(popover) {
              ss.onClose('popover', popover.el);
            },
            popoverClosed: function popoverClosed(popover) {
              ss.onClosed('popover', popover.el);
            }
          }
        };

        if (ss.params.routableModals && ss.view) {
          ss.view.router.navigate({
            url: ss.url,
            route: {
              path: ss.url,
              popover: popoverParams
            }
          });
        } else {
          ss.modal = ss.app.popover.create(popoverParams).open();
        }

        return ss;
      };

      _proto.open = function open(type) {
        var ss = this;
        if (ss.opened) return ss;
        var prevented = false;

        function prevent() {
          prevented = true;
        }

        if (ss.$el) {
          ss.$el.trigger('smartselect:beforeopen', {
            prevent: prevent
          });
        }

        ss.emit('local::beforeOpen smartSelectBeforeOpen', ss, prevent);
        if (prevented) return ss;
        var openIn = type || ss.params.openIn;
        ss["open" + openIn.split('').map(function (el, index) {
          if (index === 0) return el.toUpperCase();
          return el;
        }).join('')]();
        return ss;
      };

      _proto.close = function close() {
        var ss = this;
        if (!ss.opened) return ss;

        if (ss.params.routableModals && ss.view || ss.openedIn === 'page') {
          ss.view.router.back();
        } else {
          ss.modal.once('modalClosed', function () {
            nextTick$1(function () {
              if (ss.destroyed) return;
              ss.modal.destroy();
              delete ss.modal;
            });
          });
          ss.modal.close();
        }

        return ss;
      };

      _proto.init = function init() {
        var ss = this;
        ss.attachEvents();
        ss.setValueText();
      };

      _proto.destroy = function destroy() {
        var ss = this;
        ss.emit('local::beforeDestroy smartSelectBeforeDestroy', ss);
        ss.$el.trigger('smartselect:beforedestroy');
        ss.detachEvents();
        delete ss.$el[0].f7SmartSelect;
        deleteProps$1(ss);
        ss.destroyed = true;
      };

      _createClass$1(SmartSelect, [{
        key: "view",
        get: function get() {
          var params = this.params,
              $el = this.$el;
          var view;

          if (params.view) {
            view = params.view;
          }

          if (!view) {
            view = $el.parents('.view').length && $el.parents('.view')[0].f7View;
          }

          if (!view && params.openIn === 'page') {
            throw Error('Smart Select requires initialized View');
          }

          return view;
        }
      }]);

      return SmartSelect;
    }(Framework7Class);

    var SmartSelect = {
      name: 'smartSelect',
      params: {
        smartSelect: {
          el: undefined,
          valueEl: undefined,
          setValueText: true,
          formatValueText: null,
          openIn: 'page',
          // or 'popup' or 'sheet' or 'popover'
          popupPush: false,
          popupSwipeToClose: undefined,
          // defaults to app
          sheetPush: false,
          sheetSwipeToClose: undefined,
          // defaults to app
          sheetBackdrop: false,
          pageTitle: undefined,
          pageBackLinkText: 'Back',
          popupCloseLinkText: 'Close',
          popupTabletFullscreen: false,
          sheetCloseLinkText: 'Done',
          searchbar: false,
          searchbarPlaceholder: 'Search',
          searchbarDisableText: 'Cancel',
          searchbarDisableButton: undefined,
          searchbarSpellcheck: false,
          closeOnSelect: false,
          virtualList: false,
          virtualListHeight: undefined,
          scrollToSelectedItem: false,
          formColorTheme: undefined,
          navbarColorTheme: undefined,
          routableModals: false,
          url: 'select/',
          cssClass: '',

          /*
            Custom render functions
          */
          renderPage: undefined,
          renderPopup: undefined,
          renderSheet: undefined,
          renderPopover: undefined,
          renderItems: undefined,
          renderItem: undefined,
          renderSearchbar: undefined
        }
      },
      static: {
        SmartSelect: SmartSelect$1
      },
      create: function create() {
        var app = this;
        app.smartSelect = extend$1(ConstructorMethods({
          defaultSelector: '.smart-select',
          constructor: SmartSelect$1,
          app: app,
          domProp: 'f7SmartSelect'
        }), {
          open: function open(smartSelectEl) {
            var ss = app.smartSelect.get(smartSelectEl);
            if (ss && ss.open) return ss.open();
            return undefined;
          },
          close: function close(smartSelectEl) {
            var ss = app.smartSelect.get(smartSelectEl);
            if (ss && ss.close) return ss.close();
            return undefined;
          }
        });
      },
      on: {
        tabMounted: function tabMounted(tabEl) {
          var app = this;
          $(tabEl).find('.smart-select-init').each(function (smartSelectEl) {
            app.smartSelect.create(extend$1({
              el: smartSelectEl
            }, $(smartSelectEl).dataset()));
          });
        },
        tabBeforeRemove: function tabBeforeRemove(tabEl) {
          $(tabEl).find('.smart-select-init').each(function (smartSelectEl) {
            if (smartSelectEl.f7SmartSelect && smartSelectEl.f7SmartSelect.destroy) {
              smartSelectEl.f7SmartSelect.destroy();
            }
          });
        },
        pageInit: function pageInit(page) {
          var app = this;
          page.$el.find('.smart-select-init').each(function (smartSelectEl) {
            app.smartSelect.create(extend$1({
              el: smartSelectEl
            }, $(smartSelectEl).dataset()));
          });
        },
        pageBeforeRemove: function pageBeforeRemove(page) {
          page.$el.find('.smart-select-init').each(function (smartSelectEl) {
            if (smartSelectEl.f7SmartSelect && smartSelectEl.f7SmartSelect.destroy) {
              smartSelectEl.f7SmartSelect.destroy();
            }
          });
        }
      },
      clicks: {
        '.smart-select': function open($clickedEl, data) {
          var app = this;

          if (!$clickedEl[0].f7SmartSelect) {
            var ss = app.smartSelect.create(extend$1({
              el: $clickedEl
            }, data));
            ss.open();
          }
        }
      },
      vnode: {
        'smart-select-init': {
          insert: function insert(vnode) {
            var app = this;
            var smartSelectEl = vnode.elm;
            app.smartSelect.create(extend$1({
              el: smartSelectEl
            }, $(smartSelectEl).dataset()));
          },
          destroy: function destroy(vnode) {
            var smartSelectEl = vnode.elm;

            if (smartSelectEl.f7SmartSelect && smartSelectEl.f7SmartSelect.destroy) {
              smartSelectEl.f7SmartSelect.destroy();
            }
          }
        }
      }
    };

    function getElMinSize(dimension, $el) {
      var minSize = $el.css("min-" + dimension);

      if (minSize === 'auto' || minSize === 'none') {
        minSize = 0;
      } else if (minSize.indexOf('px') >= 0) {
        minSize = parseFloat(minSize);
      } else if (minSize.indexOf('%') >= 0) {
        minSize = $el.parent()[0][dimension === 'height' ? 'offsetHeight' : 'offsetWidth'] * parseFloat(minSize) / 100;
      }

      return minSize;
    }

    function getElMaxSize(dimension, $el) {
      var maxSize = $el.css("max-" + dimension);

      if (maxSize === 'auto' || maxSize === 'none') {
        maxSize = null;
      } else if (maxSize.indexOf('px') >= 0) {
        maxSize = parseFloat(maxSize);
      } else if (maxSize.indexOf('%') >= 0) {
        maxSize = $el.parent()[0][dimension === 'height' ? 'offsetHeight' : 'offsetWidth'] * parseFloat(maxSize) / 100;
      }

      return maxSize;
    }

    var Grid = {
      init: function init() {
        var app = this;
        var isTouched;
        var isMoved;
        var touchStartX;
        var touchStartY;
        var $resizeHandlerEl;
        var $prevResizableEl;
        var $nextResizableEl;
        var prevElSize;
        var prevElMinSize;
        var prevElMaxSize;
        var nextElSize;
        var nextElMinSize;
        var nextElMaxSize;
        var parentSize;
        var itemsInFlow;
        var gapSize;
        var isScrolling;

        function handleTouchStart(e) {
          if (isTouched || isMoved) return;
          $resizeHandlerEl = $(e.target).closest('.resize-handler');
          touchStartX = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
          touchStartY = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
          isTouched = true;
          $prevResizableEl = undefined;
          $nextResizableEl = undefined;
          isScrolling = undefined;
        }

        function handleTouchMove(e) {
          if (!isTouched) return;
          var isRow = $resizeHandlerEl.parent('.row').length === 1;
          var sizeProp = isRow ? 'height' : 'width';
          var getSizeProp = isRow ? 'offsetHeight' : 'offsetWidth';

          if (!isMoved) {
            $prevResizableEl = $resizeHandlerEl.parent(isRow ? '.row' : '.col');

            if ($prevResizableEl.length && (!$prevResizableEl.hasClass('resizable') || $prevResizableEl.hasClass('resizable-fixed'))) {
              $prevResizableEl = $prevResizableEl.prevAll('.resizable:not(.resizable-fixed)').eq(0);
            }

            $nextResizableEl = $prevResizableEl.next(isRow ? '.row' : '.col');

            if ($nextResizableEl.length && (!$nextResizableEl.hasClass('resizable') || $nextResizableEl.hasClass('resizable-fixed'))) {
              $nextResizableEl = $nextResizableEl.nextAll('.resizable:not(.resizable-fixed)').eq(0);
            }

            if ($prevResizableEl.length) {
              prevElSize = $prevResizableEl[0][getSizeProp];
              prevElMinSize = getElMinSize(sizeProp, $prevResizableEl);
              prevElMaxSize = getElMaxSize(sizeProp, $prevResizableEl);
              parentSize = $prevResizableEl.parent()[0][getSizeProp];
              itemsInFlow = $prevResizableEl.parent().children(isRow ? '.row' : '[class*="col-"], .col').length;
              gapSize = parseFloat($prevResizableEl.css(isRow ? '--f7-grid-row-gap' : '--f7-grid-gap'));
            }

            if ($nextResizableEl.length) {
              nextElSize = $nextResizableEl[0][getSizeProp];
              nextElMinSize = getElMinSize(sizeProp, $nextResizableEl);
              nextElMaxSize = getElMaxSize(sizeProp, $nextResizableEl);

              if (!$prevResizableEl.length) {
                parentSize = $nextResizableEl.parent()[0][getSizeProp];
                itemsInFlow = $nextResizableEl.parent().children(isRow ? '.row' : '[class*="col-"], .col').length;
                gapSize = parseFloat($nextResizableEl.css(isRow ? '--f7-grid-row-gap' : '--f7-grid-gap'));
              }
            }
          }

          isMoved = true;
          var touchCurrentX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
          var touchCurrentY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

          if (typeof isScrolling === 'undefined' && !isRow) {
            isScrolling = !!(isScrolling || Math.abs(touchCurrentY - touchStartY) > Math.abs(touchCurrentX - touchStartX));
          }

          if (isScrolling) {
            isTouched = false;
            isMoved = false;
            return;
          }

          var isAbsolute = $prevResizableEl.hasClass('resizable-absolute') || $nextResizableEl.hasClass('resizable-absolute');
          var resizeNextEl = !isRow || isRow && !isAbsolute;

          if (resizeNextEl && !$nextResizableEl.length || !$prevResizableEl.length) {
            isTouched = false;
            isMoved = false;
            return;
          }

          e.preventDefault();
          var diff = isRow ? touchCurrentY - touchStartY : touchCurrentX - touchStartX;
          var prevElNewSize;
          var nextElNewSize;

          if ($prevResizableEl.length) {
            prevElNewSize = prevElSize + diff;

            if (prevElNewSize < prevElMinSize) {
              prevElNewSize = prevElMinSize;
              diff = prevElNewSize - prevElSize;
            }

            if (prevElMaxSize && prevElNewSize > prevElMaxSize) {
              prevElNewSize = prevElMaxSize;
              diff = prevElNewSize - prevElSize;
            }
          }

          if ($nextResizableEl.length && resizeNextEl) {
            nextElNewSize = nextElSize - diff;

            if (nextElNewSize < nextElMinSize) {
              nextElNewSize = nextElMinSize;
              diff = nextElSize - nextElNewSize;
              prevElNewSize = prevElSize + diff;
            }

            if (nextElMaxSize && nextElNewSize > nextElMaxSize) {
              nextElNewSize = nextElMaxSize;
              diff = nextElSize - nextElNewSize;
              prevElNewSize = prevElSize + diff;
            }
          }

          if (isAbsolute) {
            $prevResizableEl[0].style[sizeProp] = prevElNewSize + "px";

            if (resizeNextEl) {
              $nextResizableEl[0].style[sizeProp] = nextElNewSize + "px";
            }

            $prevResizableEl.trigger('grid:resize');
            $nextResizableEl.trigger('grid:resize');
            app.emit('gridResize', $prevResizableEl[0]);
            app.emit('gridResize', $nextResizableEl[0]);
            return;
          }

          var gapAddSize = (itemsInFlow - 1) * gapSize / itemsInFlow;
          var gapAddSizeCSS = isRow ? itemsInFlow - 1 + " * var(--f7-grid-row-gap) / " + itemsInFlow : '(var(--f7-cols-per-row) - 1) * var(--f7-grid-gap) / var(--f7-cols-per-row)';
          var prevElNewSizeNormalized = prevElNewSize + gapAddSize;
          var nextElNewSizeNormalized = nextElNewSize + gapAddSize;
          $prevResizableEl[0].style[sizeProp] = "calc(" + prevElNewSizeNormalized / parentSize * 100 + "% - " + gapAddSizeCSS + ")";
          $nextResizableEl[0].style[sizeProp] = "calc(" + nextElNewSizeNormalized / parentSize * 100 + "% - " + gapAddSizeCSS + ")";
          $prevResizableEl.trigger('grid:resize');
          $nextResizableEl.trigger('grid:resize');
          app.emit('gridResize', $prevResizableEl[0]);
          app.emit('gridResize', $nextResizableEl[0]);
        }

        function handleTouchEnd() {
          if (!isTouched) return;

          if (!isMoved) {
            isTouched = false;
          }

          isTouched = false;
          isMoved = false;
        }

        var document = getDocument();
        $(document).on(app.touchEvents.start, '.col > .resize-handler, .row > .resize-handler', handleTouchStart);
        app.on('touchmove', handleTouchMove);
        app.on('touchend', handleTouchEnd);
      }
    };
    var Grid$1 = {
      name: 'grid',
      create: function create() {
        var app = this;
        extend$1(app, {
          grid: {
            init: Grid.init.bind(app)
          }
        });
      },
      on: {
        init: function init() {
          var app = this;
          app.grid.init();
        }
      }
    };

    var Calendar$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(Calendar, _Framework7Class);

      function Calendar(app, params) {
        var _this;

        if (params === void 0) {
          params = {};
        }

        _this = _Framework7Class.call(this, params, [app]) || this;

        var calendar = _assertThisInitialized(_this);

        calendar.params = extend$1({}, app.params.calendar, params);
        var $containerEl;

        if (calendar.params.containerEl) {
          $containerEl = $(calendar.params.containerEl);
          if ($containerEl.length === 0) return calendar || _assertThisInitialized(_this);
        }

        var $inputEl;

        if (calendar.params.inputEl) {
          $inputEl = $(calendar.params.inputEl);
        }

        var isHorizontal = calendar.params.direction === 'horizontal';
        var inverter = 1;

        if (isHorizontal) {
          inverter = app.rtl ? -1 : 1;
        }

        extend$1(calendar, {
          app: app,
          $containerEl: $containerEl,
          containerEl: $containerEl && $containerEl[0],
          inline: $containerEl && $containerEl.length > 0,
          $inputEl: $inputEl,
          inputEl: $inputEl && $inputEl[0],
          initialized: false,
          opened: false,
          url: calendar.params.url,
          isHorizontal: isHorizontal,
          inverter: inverter,
          animating: false,
          allowTouchMove: true,
          hasTimePicker: calendar.params.timePicker && !calendar.params.rangePicker && !calendar.params.multiple
        });

        calendar.dayFormatter = function (date) {
          var formatter = new Intl.DateTimeFormat(calendar.params.locale, {
            day: 'numeric'
          });
          return formatter.format(date).replace(/日/, '');
        };

        calendar.monthFormatter = function (date) {
          var formatter = new Intl.DateTimeFormat(calendar.params.locale, {
            month: 'long'
          });
          return formatter.format(date);
        };

        calendar.yearFormatter = function (date) {
          var formatter = new Intl.DateTimeFormat(calendar.params.locale, {
            year: 'numeric'
          });
          return formatter.format(date);
        };

        calendar.timeSelectorFormatter = function (date) {
          var formatter = new Intl.DateTimeFormat(calendar.params.locale, calendar.params.timePickerFormat);
          return formatter.format(date);
        };

        var timeFormatCheckDate = calendar.timeSelectorFormatter(new Date()).toLowerCase();
        calendar.is12HoursFormat = timeFormatCheckDate.indexOf('pm') >= 0 || timeFormatCheckDate.indexOf('am') >= 0; // Auto names

        var _calendar$params = calendar.params,
            monthNames = _calendar$params.monthNames,
            monthNamesShort = _calendar$params.monthNamesShort,
            dayNames = _calendar$params.dayNames,
            dayNamesShort = _calendar$params.dayNamesShort;

        var _calendar$getIntlName = calendar.getIntlNames(),
            monthNamesIntl = _calendar$getIntlName.monthNamesIntl,
            monthNamesShortIntl = _calendar$getIntlName.monthNamesShortIntl,
            dayNamesIntl = _calendar$getIntlName.dayNamesIntl,
            dayNamesShortIntl = _calendar$getIntlName.dayNamesShortIntl;

        if (monthNames === 'auto') monthNames = monthNamesIntl;
        if (monthNamesShort === 'auto') monthNamesShort = monthNamesShortIntl;
        if (dayNames === 'auto') dayNames = dayNamesIntl;
        if (dayNamesShort === 'auto') dayNamesShort = dayNamesShortIntl;
        extend$1(calendar, {
          monthNames: monthNames,
          monthNamesShort: monthNamesShort,
          dayNames: dayNames,
          dayNamesShort: dayNamesShort
        });

        function onInputClick() {
          calendar.open();
        }

        function onInputFocus(e) {
          e.preventDefault();
        }

        function onInputClear() {
          calendar.setValue([]);

          if (calendar.opened) {
            calendar.update();
          }
        }

        function onHtmlClick(e) {
          var $targetEl = $(e.target);
          if (calendar.destroyed || !calendar.params) return;
          if (calendar.isPopover()) return;
          if (!calendar.opened || calendar.closing) return;
          if ($targetEl.closest('[class*="backdrop"]').length) return;

          if ($inputEl && $inputEl.length > 0) {
            if ($targetEl[0] !== $inputEl[0] && $targetEl.closest('.sheet-modal, .calendar-modal').length === 0) {
              calendar.close();
            }
          } else if ($(e.target).closest('.sheet-modal, .calendar-modal').length === 0) {
            calendar.close();
          }
        } // Events


        extend$1(calendar, {
          attachInputEvents: function attachInputEvents() {
            calendar.$inputEl.on('click', onInputClick);
            calendar.$inputEl.on('input:clear', onInputClear);

            if (calendar.params.inputReadOnly) {
              calendar.$inputEl.on('focus mousedown', onInputFocus);

              if (calendar.$inputEl[0]) {
                calendar.$inputEl[0].f7ValidateReadonly = true;
              }
            }
          },
          detachInputEvents: function detachInputEvents() {
            calendar.$inputEl.off('click', onInputClick);
            calendar.$inputEl.off('input:clear', onInputClear);

            if (calendar.params.inputReadOnly) {
              calendar.$inputEl.off('focus mousedown', onInputFocus);

              if (calendar.$inputEl[0]) {
                delete calendar.$inputEl[0].f7ValidateReadonly;
              }
            }
          },
          attachHtmlEvents: function attachHtmlEvents() {
            app.on('click', onHtmlClick);
          },
          detachHtmlEvents: function detachHtmlEvents() {
            app.off('click', onHtmlClick);
          }
        });

        calendar.attachCalendarEvents = function attachCalendarEvents() {
          var allowItemClick = true;
          var isTouched;
          var isMoved;
          var touchStartX;
          var touchStartY;
          var touchCurrentX;
          var touchCurrentY;
          var touchStartTime;
          var touchEndTime;
          var currentTranslate;
          var wrapperWidth;
          var wrapperHeight;
          var percentage;
          var touchesDiff;
          var isScrolling;
          var $el = calendar.$el,
              $wrapperEl = calendar.$wrapperEl;

          function handleTouchStart(e) {
            if (isMoved || isTouched) return;
            isTouched = true;
            touchStartX = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
            touchCurrentX = touchStartX;
            touchStartY = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
            touchCurrentY = touchStartY;
            touchStartTime = new Date().getTime();
            percentage = 0;
            allowItemClick = true;
            isScrolling = undefined;
            currentTranslate = calendar.monthsTranslate;
          }

          function handleTouchMove(e) {
            if (!isTouched) return;
            var isH = calendar.isHorizontal;
            touchCurrentX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
            touchCurrentY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

            if (typeof isScrolling === 'undefined') {
              isScrolling = !!(isScrolling || Math.abs(touchCurrentY - touchStartY) > Math.abs(touchCurrentX - touchStartX));
            }

            if (isH && isScrolling || !calendar.allowTouchMove) {
              isTouched = false;
              return;
            }

            e.preventDefault();

            if (calendar.animating) {
              isTouched = false;
              return;
            }

            allowItemClick = false;

            if (!isMoved) {
              // First move
              isMoved = true;
              wrapperWidth = $wrapperEl[0].offsetWidth;
              wrapperHeight = $wrapperEl[0].offsetHeight;
              $wrapperEl.transition(0);
            }

            touchesDiff = isH ? touchCurrentX - touchStartX : touchCurrentY - touchStartY;
            percentage = touchesDiff / (isH ? wrapperWidth : wrapperHeight);
            currentTranslate = (calendar.monthsTranslate * calendar.inverter + percentage) * 100; // Transform wrapper

            $wrapperEl.transform("translate3d(" + (isH ? currentTranslate : 0) + "%, " + (isH ? 0 : currentTranslate) + "%, 0)");
          }

          function handleTouchEnd() {
            if (!isTouched || !isMoved) {
              isTouched = false;
              isMoved = false;
              return;
            }

            isTouched = false;
            isMoved = false;
            touchEndTime = new Date().getTime();

            if (touchEndTime - touchStartTime < 300) {
              if (Math.abs(touchesDiff) < 10) {
                calendar.resetMonth();
              } else if (touchesDiff >= 10) {
                if (app.rtl) calendar.nextMonth();else calendar.prevMonth();
              } else if (app.rtl) calendar.prevMonth();else calendar.nextMonth();
            } else if (percentage <= -0.5) {
              if (app.rtl) calendar.prevMonth();else calendar.nextMonth();
            } else if (percentage >= 0.5) {
              if (app.rtl) calendar.nextMonth();else calendar.prevMonth();
            } else {
              calendar.resetMonth();
            } // Allow click


            setTimeout(function () {
              allowItemClick = true;
            }, 100);
          }

          function handleDayClick(e) {
            if (!allowItemClick) return;
            var $dayEl = $(e.target).parents('.calendar-day');

            if ($dayEl.length === 0 && $(e.target).hasClass('calendar-day')) {
              $dayEl = $(e.target);
            }

            if ($dayEl.length === 0) return;
            if ($dayEl.hasClass('calendar-day-disabled')) return;

            if (!calendar.params.rangePicker) {
              if ($dayEl.hasClass('calendar-day-next')) calendar.nextMonth();
              if ($dayEl.hasClass('calendar-day-prev')) calendar.prevMonth();
            }

            var dateYear = parseInt($dayEl.attr('data-year'), 10);
            var dateMonth = parseInt($dayEl.attr('data-month'), 10);
            var dateDay = parseInt($dayEl.attr('data-day'), 10);
            calendar.emit('local::dayClick calendarDayClick', calendar, $dayEl[0], dateYear, dateMonth, dateDay);

            if (!$dayEl.hasClass('calendar-day-selected') || calendar.params.multiple || calendar.params.rangePicker) {
              var valueToAdd = new Date(dateYear, dateMonth, dateDay, 0, 0, 0);

              if (calendar.hasTimePicker) {
                if (calendar.value && calendar.value[0]) {
                  valueToAdd.setHours(calendar.value[0].getHours(), calendar.value[0].getMinutes());
                } else {
                  valueToAdd.setHours(new Date().getHours(), new Date().getMinutes());
                }
              }

              calendar.addValue(valueToAdd);
            }

            if (calendar.params.closeOnSelect) {
              if (calendar.params.rangePicker && calendar.value.length === 2 || !calendar.params.rangePicker) {
                calendar.close();
              }
            }
          }

          function onNextMonthClick() {
            calendar.nextMonth();
          }

          function onPrevMonthClick() {
            calendar.prevMonth();
          }

          function onNextYearClick() {
            calendar.nextYear();
          }

          function onPrevYearClick() {
            calendar.prevYear();
          }

          function onMonthSelectorClick() {
            $el.append(calendar.renderMonthPicker());
          }

          function onMonthSelectorItemClick() {
            var $clickedEl = $(this);

            if ($clickedEl.hasClass('calendar-month-picker-item-current')) {
              $el.find('.calendar-month-picker').remove();
              return;
            }

            $el.find('.calendar-month-picker-item-current').add($clickedEl).toggleClass('calendar-month-picker-item-current');
            var index = $clickedEl.index();
            var localeMonthIndex = parseInt(calendar.$el.find('.calendar-month-current').attr('data-locale-month'), 10);
            var monthIndex = calendar.currentMonth;
            var diff = localeMonthIndex - monthIndex;
            var diffIndex = index - diff;
            calendar.setYearMonth(calendar.currentYear, diffIndex, 0);
            setTimeout(function () {
              $el.find('.calendar-month-picker').remove();
            }, 200);
          }

          function onYearSelectorClick() {
            $el.append(calendar.renderYearPicker());
            var $currentEl = $el.find('.calendar-year-picker-item-current');
            var $yearPickerEl = $el.find('.calendar-year-picker');
            if (!$currentEl || !$currentEl.length) return;
            $yearPickerEl.scrollTop($currentEl[0].offsetTop - $yearPickerEl[0].offsetHeight / 2 + $currentEl[0].offsetHeight / 2);
          }

          function onYearSelectorItemClick() {
            var $clickedEl = $(this);

            if ($clickedEl.hasClass('calendar-year-picker-item-current')) {
              $el.find('.calendar-year-picker').remove();
              return;
            }

            $el.find('.calendar-year-picker-item-current').add($clickedEl).toggleClass('calendar-year-picker-item-current');
            var year = parseInt($clickedEl.attr('data-year'), 10);
            calendar.setYearMonth(year, undefined, 0);
            setTimeout(function () {
              $el.find('.calendar-year-picker').remove();
            }, 200);
          }

          function onTimeSelectorClick() {
            calendar.openTimePicker();
          }

          function onTimePickerCloseClick() {
            calendar.closeTimePicker();
          }

          var passiveListener = app.touchEvents.start === 'touchstart' && getSupport$1().passiveListener ? {
            passive: true,
            capture: false
          } : false; // Selectors clicks

          $el.find('.calendar-prev-month-button').on('click', onPrevMonthClick);
          $el.find('.calendar-next-month-button').on('click', onNextMonthClick);
          $el.find('.calendar-prev-year-button').on('click', onPrevYearClick);
          $el.find('.calendar-next-year-button').on('click', onNextYearClick);

          if (calendar.params.monthPicker) {
            $el.find('.current-month-value').on('click', onMonthSelectorClick);
            $el.on('click', '.calendar-month-picker-item', onMonthSelectorItemClick);
          }

          if (calendar.params.yearPicker) {
            $el.find('.current-year-value').on('click', onYearSelectorClick);
            $el.on('click', '.calendar-year-picker-item', onYearSelectorItemClick);
          }

          if (calendar.hasTimePicker) {
            $el.find('.calendar-time-selector a').on('click', onTimeSelectorClick);
            $el.on('click', '.calendar-time-picker-close', onTimePickerCloseClick);
          } // Day clicks


          $wrapperEl.on('click', handleDayClick); // Touch events

          if (calendar.params.touchMove) {
            $wrapperEl.on(app.touchEvents.start, handleTouchStart, passiveListener);
            app.on('touchmove:active', handleTouchMove);
            app.on('touchend:passive', handleTouchEnd);
          }

          calendar.detachCalendarEvents = function detachCalendarEvents() {
            $el.find('.calendar-prev-month-button').off('click', onPrevMonthClick);
            $el.find('.calendar-next-month-button').off('click', onNextMonthClick);
            $el.find('.calendar-prev-year-button').off('click', onPrevYearClick);
            $el.find('.calendar-next-year-button').off('click', onNextYearClick);

            if (calendar.params.monthPicker) {
              $el.find('.current-month-value').off('click', onMonthSelectorClick);
              $el.off('click', '.calendar-month-picker-item', onMonthSelectorItemClick);
            }

            if (calendar.params.yearPicker) {
              $el.find('.current-year-value').off('click', onYearSelectorClick);
              $el.off('click', '.calendar-year-picker-item', onYearSelectorItemClick);
            }

            if (calendar.hasTimePicker) {
              $el.find('.calendar-time-selector a').off('click', onTimeSelectorClick);
              $el.off('click', '.calendar-time-picker-close', onTimePickerCloseClick);
            }

            $wrapperEl.off('click', handleDayClick);

            if (calendar.params.touchMove) {
              $wrapperEl.off(app.touchEvents.start, handleTouchStart, passiveListener);
              app.off('touchmove:active', handleTouchMove);
              app.off('touchend:passive', handleTouchEnd);
            }
          };
        };

        calendar.init();
        return calendar || _assertThisInitialized(_this);
      }

      var _proto = Calendar.prototype;

      _proto.getIntlNames = function getIntlNames() {
        var calendar = this;
        var locale = calendar.params.locale;
        var monthNamesIntl = [];
        var monthNamesShortIntl = [];
        var dayNamesIntl = [];
        var dayNamesShortIntl = [];
        var formatterMonthNames = new Intl.DateTimeFormat(locale, {
          month: 'long'
        });
        var formatterMonthNamesShort = new Intl.DateTimeFormat(locale, {
          month: 'short'
        });
        var formatterDayNames = new Intl.DateTimeFormat(locale, {
          weekday: 'long'
        });
        var formatterDayNamesShort = new Intl.DateTimeFormat(locale, {
          weekday: 'short'
        });
        var year;
        var yearStarted;
        var yearEnded;

        for (var i = 0; i < 24; i += 1) {
          var date = new Date().setMonth(i, 1);
          var currentYear = calendar.yearFormatter(date);

          if (year && currentYear !== year) {
            if (yearStarted) yearEnded = true;
            yearStarted = true;
            year = currentYear;
          }

          if (!year) {
            year = currentYear;
          }

          if (yearStarted && year === currentYear && !yearEnded) {
            monthNamesIntl.push(formatterMonthNames.format(date));
            monthNamesShortIntl.push(formatterMonthNamesShort.format(date));
          }
        }

        var weekDay = new Date().getDay();

        for (var _i = 0; _i < 7; _i += 1) {
          var _date = new Date().getTime() + (_i - weekDay) * 24 * 60 * 60 * 1000;

          dayNamesIntl.push(formatterDayNames.format(_date));
          dayNamesShortIntl.push(formatterDayNamesShort.format(_date));
        }

        return {
          monthNamesIntl: monthNamesIntl,
          monthNamesShortIntl: monthNamesShortIntl,
          dayNamesIntl: dayNamesIntl,
          dayNamesShortIntl: dayNamesShortIntl
        };
      };

      _proto.normalizeDate = function normalizeDate(date) {
        var calendar = this;
        var d = new Date(date);

        if (calendar.hasTimePicker) {
          return new Date(d.getFullYear(), d.getMonth(), d.getDate(), d.getHours(), d.getMinutes());
        }

        return new Date(d.getFullYear(), d.getMonth(), d.getDate());
      };

      _proto.normalizeValues = function normalizeValues(values) {
        var calendar = this;
        var newValues = [];

        if (values && Array.isArray(values)) {
          newValues = values.map(function (val) {
            return calendar.normalizeDate(val);
          });
        }

        return newValues;
      };

      _proto.initInput = function initInput() {
        var calendar = this;
        if (!calendar.$inputEl) return;
        if (calendar.params.inputReadOnly) calendar.$inputEl.prop('readOnly', true);
      };

      _proto.isPopover = function isPopover() {
        var calendar = this;
        var app = calendar.app,
            modal = calendar.modal,
            params = calendar.params;
        var device = getDevice$1();
        if (params.openIn === 'sheet') return false;
        if (modal && modal.type !== 'popover') return false;

        if (!calendar.inline && calendar.inputEl) {
          if (params.openIn === 'popover') return true;

          if (device.ios) {
            return !!device.ipad;
          }

          if (app.width >= 768) {
            return true;
          }

          if (device.desktop && app.theme === 'aurora') {
            return true;
          }
        }

        return false;
      };

      _proto.formatDate = function formatDate(d) {
        var calendar = this;
        var date = new Date(d);
        var year = date.getFullYear();
        var month = date.getMonth();
        var month1 = month + 1;
        var day = date.getDate();
        var weekDay = date.getDay();
        var monthNames = calendar.monthNames,
            monthNamesShort = calendar.monthNamesShort,
            dayNames = calendar.dayNames,
            dayNamesShort = calendar.dayNamesShort;
        var _calendar$params2 = calendar.params,
            dateFormat = _calendar$params2.dateFormat,
            locale = _calendar$params2.locale;

        function twoDigits(number) {
          return number < 10 ? "0" + number : number;
        }

        if (typeof dateFormat === 'string') {
          var tokens = {
            yyyy: year,
            yy: String(year).substring(2),
            mm: twoDigits(month1),
            m: month1,
            MM: monthNames[month],
            M: monthNamesShort[month],
            dd: twoDigits(day),
            d: day,
            DD: dayNames[weekDay],
            D: dayNamesShort[weekDay]
          };

          if (calendar.params.timePicker) {
            var hours = date.getHours();
            var minutes = date.getMinutes();
            var seconds = date.getSeconds();
            var hours12 = hours;
            if (hours > 12) hours12 = hours - 12;
            if (hours === 0) hours12 = 12;
            var a = hours >= 12 && hours !== 0 ? 'pm' : 'am';
            Object.assign(tokens, {
              HH: twoDigits(hours),
              H: hours,
              hh: twoDigits(hours12),
              h: hours12,
              ss: twoDigits(seconds),
              s: seconds,
              ':mm': twoDigits(minutes),
              ':m': minutes,
              a: a,
              A: a.toUpperCase()
            });
          }

          var regexp = new RegExp(Object.keys(tokens).map(function (t) {
            return "(" + t + ")";
          }).join('|'), 'g');
          return dateFormat.replace(regexp, function (token) {
            if (token in tokens) return tokens[token];
            return token;
          });
        }

        if (typeof dateFormat === 'function') {
          return dateFormat(date);
        } // Intl Object


        var formatter = new Intl.DateTimeFormat(locale, dateFormat);
        return formatter.format(date);
      };

      _proto.formatValue = function formatValue() {
        var calendar = this;
        var value = calendar.value;

        if (calendar.params.formatValue) {
          return calendar.params.formatValue.call(calendar, value);
        }

        return value.map(function (v) {
          return calendar.formatDate(v);
        }).join(calendar.params.rangePicker ? ' - ' : ', ');
      };

      _proto.addValue = function addValue(newValue) {
        var calendar = this;
        var _calendar$params3 = calendar.params,
            multiple = _calendar$params3.multiple,
            rangePicker = _calendar$params3.rangePicker,
            rangePickerMinDays = _calendar$params3.rangePickerMinDays,
            rangePickerMaxDays = _calendar$params3.rangePickerMaxDays;

        if (multiple) {
          if (!calendar.value) calendar.value = [];
          var inValuesIndex;

          for (var i = 0; i < calendar.value.length; i += 1) {
            if (new Date(newValue).getTime() === new Date(calendar.value[i]).getTime()) {
              inValuesIndex = i;
            }
          }

          if (typeof inValuesIndex === 'undefined') {
            calendar.value.push(newValue);
          } else {
            calendar.value.splice(inValuesIndex, 1);
          }

          calendar.updateValue();
        } else if (rangePicker) {
          if (!calendar.value) calendar.value = [];

          if (calendar.value.length === 2 || calendar.value.length === 0) {
            calendar.value = [];
          }

          if (calendar.value.length === 0 || Math.abs(calendar.value[0].getTime() - newValue.getTime()) >= (rangePickerMinDays - 1) * 60 * 60 * 24 * 1000 && (rangePickerMaxDays === 0 || Math.abs(calendar.value[0].getTime() - newValue.getTime()) <= (rangePickerMaxDays - 1) * 60 * 60 * 24 * 1000)) calendar.value.push(newValue);else calendar.value = [];
          calendar.value.sort(function (a, b) {
            return a - b;
          });
          calendar.updateValue();
        } else {
          calendar.value = [newValue];
          calendar.updateValue();
        }
      };

      _proto.setValue = function setValue(values) {
        var calendar = this;
        var currentValue = calendar.value;

        if (Array.isArray(currentValue) && Array.isArray(values) && currentValue.length === values.length) {
          var equal = true;
          currentValue.forEach(function (v, index) {
            if (v !== values[index]) equal = false;
          });
          if (equal) return;
        }

        calendar.value = values;
        calendar.updateValue();
      };

      _proto.getValue = function getValue() {
        var calendar = this;
        return calendar.value;
      };

      _proto.updateValue = function updateValue(onlyHeader) {
        var calendar = this;
        var $el = calendar.$el,
            $wrapperEl = calendar.$wrapperEl,
            $inputEl = calendar.$inputEl,
            value = calendar.value,
            params = calendar.params;
        var i;

        if ($el && $el.length > 0) {
          $wrapperEl.find('.calendar-day-selected').removeClass('calendar-day-selected calendar-day-selected-range calendar-day-selected-left calendar-day-selected-right');
          var valueDate;

          if (params.rangePicker && value.length === 2) {
            var leftDate = new Date(value[0]).getTime();
            var rightDate = new Date(value[1]).getTime();

            for (i = leftDate; i <= rightDate; i += 24 * 60 * 60 * 1000) {
              valueDate = new Date(i);
              var addClass = 'calendar-day-selected';

              if (leftDate !== rightDate) {
                if (i !== leftDate && i !== rightDate) {
                  addClass += ' calendar-day-selected-range';
                }

                if (i === leftDate) {
                  addClass += ' calendar-day-selected-left';
                }

                if (i === rightDate) {
                  addClass += ' calendar-day-selected-right';
                }
              }

              $wrapperEl.find(".calendar-day[data-date=\"" + valueDate.getFullYear() + "-" + valueDate.getMonth() + "-" + valueDate.getDate() + "\"]").addClass(addClass);
            }

            valueDate = new Date(leftDate);
            $wrapperEl.find(".calendar-day[data-date=\"" + valueDate.getFullYear() + "-" + valueDate.getMonth() + "-" + valueDate.getDate() + "\"]").removeClass('calendar-day-selected-range').addClass('calendar-day-selected calendar-day-selected-left');
            valueDate = new Date(rightDate);
            $wrapperEl.find(".calendar-day[data-date=\"" + valueDate.getFullYear() + "-" + valueDate.getMonth() + "-" + valueDate.getDate() + "\"]").removeClass('calendar-day-selected-range').addClass('calendar-day-selected calendar-day-selected-right');
          } else {
            for (i = 0; i < calendar.value.length; i += 1) {
              valueDate = new Date(value[i]);
              $wrapperEl.find(".calendar-day[data-date=\"" + valueDate.getFullYear() + "-" + valueDate.getMonth() + "-" + valueDate.getDate() + "\"]").addClass('calendar-day-selected');
            }
          }
        }

        if (!onlyHeader) {
          calendar.emit('local::change calendarChange', calendar, value);
        }

        if ($el && $el.length > 0 && calendar.hasTimePicker) {
          $el.find('.calendar-time-selector a').text(value && value.length ? calendar.timeSelectorFormatter(value[0]) : calendar.params.timePickerPlaceholder);
        }

        if ($inputEl && $inputEl.length || params.header) {
          var inputValue = calendar.formatValue(value);

          if (params.header && $el && $el.length) {
            $el.find('.calendar-selected-date').text(inputValue);
          }

          if ($inputEl && $inputEl.length && !onlyHeader) {
            $inputEl.val(inputValue);
            $inputEl.trigger('change');
          }
        }
      };

      _proto.updateCurrentMonthYear = function updateCurrentMonthYear(dir) {
        var calendar = this;
        var $months = calendar.$months,
            $el = calendar.$el,
            monthNames = calendar.monthNames;
        var currentLocaleMonth;
        var currentLocaleYear;

        if (typeof dir === 'undefined') {
          calendar.currentMonth = parseInt($months.eq(1).attr('data-month'), 10);
          calendar.currentYear = parseInt($months.eq(1).attr('data-year'), 10);
          currentLocaleMonth = $months.eq(1).attr('data-locale-month');
          currentLocaleYear = $months.eq(1).attr('data-locale-year');
        } else {
          calendar.currentMonth = parseInt($months.eq(dir === 'next' ? $months.length - 1 : 0).attr('data-month'), 10);
          calendar.currentYear = parseInt($months.eq(dir === 'next' ? $months.length - 1 : 0).attr('data-year'), 10);
          currentLocaleMonth = $months.eq(dir === 'next' ? $months.length - 1 : 0).attr('data-locale-month');
          currentLocaleYear = $months.eq(dir === 'next' ? $months.length - 1 : 0).attr('data-locale-year');
        }

        $el.find('.current-month-value').text(monthNames[currentLocaleMonth]);
        $el.find('.current-year-value').text(currentLocaleYear);
      };

      _proto.update = function update() {
        var calendar = this;
        var currentYear = calendar.currentYear,
            currentMonth = calendar.currentMonth,
            $wrapperEl = calendar.$wrapperEl;
        var currentDate = new Date(currentYear, currentMonth);
        var prevMonthHtml = calendar.renderMonth(currentDate, 'prev');
        var currentMonthHtml = calendar.renderMonth(currentDate);
        var nextMonthHtml = calendar.renderMonth(currentDate, 'next');
        $wrapperEl.transition(0).html("" + prevMonthHtml + currentMonthHtml + nextMonthHtml).transform('translate3d(0,0,0)');
        calendar.$months = $wrapperEl.find('.calendar-month');
        calendar.monthsTranslate = 0;
        calendar.setMonthsTranslate();
        calendar.$months.each(function (monthEl) {
          calendar.emit('local::monthAdd calendarMonthAdd', monthEl);
        });
      };

      _proto.onMonthChangeStart = function onMonthChangeStart(dir) {
        var calendar = this;
        var $months = calendar.$months,
            currentYear = calendar.currentYear,
            currentMonth = calendar.currentMonth;
        calendar.updateCurrentMonthYear(dir);
        $months.removeClass('calendar-month-current calendar-month-prev calendar-month-next');
        var currentIndex = dir === 'next' ? $months.length - 1 : 0;
        $months.eq(currentIndex).addClass('calendar-month-current');
        $months.eq(dir === 'next' ? currentIndex - 1 : currentIndex + 1).addClass(dir === 'next' ? 'calendar-month-prev' : 'calendar-month-next');
        calendar.emit('local::monthYearChangeStart calendarMonthYearChangeStart', calendar, currentYear, currentMonth);
      };

      _proto.onMonthChangeEnd = function onMonthChangeEnd(dir, rebuildBoth) {
        var calendar = this;
        var currentYear = calendar.currentYear,
            currentMonth = calendar.currentMonth,
            $wrapperEl = calendar.$wrapperEl,
            monthsTranslate = calendar.monthsTranslate;
        calendar.animating = false;
        var nextMonthHtml;
        var prevMonthHtml;
        var currentMonthHtml;
        $wrapperEl.find('.calendar-month:not(.calendar-month-prev):not(.calendar-month-current):not(.calendar-month-next)').remove();

        if (typeof dir === 'undefined') {
          dir = 'next'; // eslint-disable-line

          rebuildBoth = true; // eslint-disable-line
        }

        if (!rebuildBoth) {
          currentMonthHtml = calendar.renderMonth(new Date(currentYear, currentMonth), dir);
        } else {
          $wrapperEl.find('.calendar-month-next, .calendar-month-prev').remove();
          prevMonthHtml = calendar.renderMonth(new Date(currentYear, currentMonth), 'prev');
          nextMonthHtml = calendar.renderMonth(new Date(currentYear, currentMonth), 'next');
        }

        if (dir === 'next' || rebuildBoth) {
          $wrapperEl.append(currentMonthHtml || nextMonthHtml);
        }

        if (dir === 'prev' || rebuildBoth) {
          $wrapperEl.prepend(currentMonthHtml || prevMonthHtml);
        }

        var $months = $wrapperEl.find('.calendar-month');
        calendar.$months = $months;
        calendar.setMonthsTranslate(monthsTranslate);
        calendar.emit('local::monthAdd calendarMonthAdd', calendar, dir === 'next' ? $months.eq($months.length - 1)[0] : $months.eq(0)[0]);
        calendar.emit('local::monthYearChangeEnd calendarMonthYearChangeEnd', calendar, currentYear, currentMonth);
      };

      _proto.setMonthsTranslate = function setMonthsTranslate(translate) {
        var calendar = this;
        var $months = calendar.$months,
            isH = calendar.isHorizontal,
            inverter = calendar.inverter; // eslint-disable-next-line

        translate = translate || calendar.monthsTranslate || 0;

        if (typeof calendar.monthsTranslate === 'undefined') {
          calendar.monthsTranslate = translate;
        }

        $months.removeClass('calendar-month-current calendar-month-prev calendar-month-next');
        var prevMonthTranslate = -(translate + 1) * 100 * inverter;
        var currentMonthTranslate = -translate * 100 * inverter;
        var nextMonthTranslate = -(translate - 1) * 100 * inverter;
        $months.eq(0).transform("translate3d(" + (isH ? prevMonthTranslate : 0) + "%, " + (isH ? 0 : prevMonthTranslate) + "%, 0)").addClass('calendar-month-prev');
        $months.eq(1).transform("translate3d(" + (isH ? currentMonthTranslate : 0) + "%, " + (isH ? 0 : currentMonthTranslate) + "%, 0)").addClass('calendar-month-current');
        $months.eq(2).transform("translate3d(" + (isH ? nextMonthTranslate : 0) + "%, " + (isH ? 0 : nextMonthTranslate) + "%, 0)").addClass('calendar-month-next');
      };

      _proto.nextMonth = function nextMonth(transition) {
        var calendar = this;
        var params = calendar.params,
            $wrapperEl = calendar.$wrapperEl,
            inverter = calendar.inverter,
            isH = calendar.isHorizontal;

        if (typeof transition === 'undefined' || typeof transition === 'object') {
          transition = ''; // eslint-disable-line

          if (!params.animate) transition = 0; // eslint-disable-line
        }

        var nextMonth = parseInt(calendar.$months.eq(calendar.$months.length - 1).attr('data-month'), 10);
        var nextYear = parseInt(calendar.$months.eq(calendar.$months.length - 1).attr('data-year'), 10);
        var nextDate = new Date(nextYear, nextMonth);
        var nextDateTime = nextDate.getTime();
        var transitionEndCallback = !calendar.animating;

        if (params.maxDate) {
          if (nextDateTime > new Date(params.maxDate).getTime()) {
            calendar.resetMonth();
            return;
          }
        }

        calendar.monthsTranslate -= 1;

        if (nextMonth === calendar.currentMonth) {
          var nextMonthTranslate = -calendar.monthsTranslate * 100 * inverter;
          var nextMonthHtml = $(calendar.renderMonth(nextDateTime, 'next')).transform("translate3d(" + (isH ? nextMonthTranslate : 0) + "%, " + (isH ? 0 : nextMonthTranslate) + "%, 0)").addClass('calendar-month-next');
          $wrapperEl.append(nextMonthHtml[0]);
          calendar.$months = $wrapperEl.find('.calendar-month');
          calendar.emit('local::monthAdd calendarMonthAdd', calendar.$months.eq(calendar.$months.length - 1)[0]);
        }

        calendar.animating = true;
        calendar.onMonthChangeStart('next');
        var translate = calendar.monthsTranslate * 100 * inverter;
        $wrapperEl.transition(transition).transform("translate3d(" + (isH ? translate : 0) + "%, " + (isH ? 0 : translate) + "%, 0)");

        if (transitionEndCallback) {
          $wrapperEl.transitionEnd(function () {
            calendar.onMonthChangeEnd('next');
          });
        }

        if (!params.animate) {
          calendar.onMonthChangeEnd('next');
        }
      };

      _proto.prevMonth = function prevMonth(transition) {
        var calendar = this;
        var params = calendar.params,
            $wrapperEl = calendar.$wrapperEl,
            inverter = calendar.inverter,
            isH = calendar.isHorizontal;

        if (typeof transition === 'undefined' || typeof transition === 'object') {
          transition = ''; // eslint-disable-line

          if (!params.animate) transition = 0; // eslint-disable-line
        }

        var prevMonth = parseInt(calendar.$months.eq(0).attr('data-month'), 10);
        var prevYear = parseInt(calendar.$months.eq(0).attr('data-year'), 10);
        var prevDate = new Date(prevYear, prevMonth + 1, -1);
        var prevDateTime = prevDate.getTime();
        var transitionEndCallback = !calendar.animating;

        if (params.minDate) {
          var minDate = new Date(params.minDate);
          minDate = new Date(minDate.getFullYear(), minDate.getMonth(), 1);

          if (prevDateTime < minDate.getTime()) {
            calendar.resetMonth();
            return;
          }
        }

        calendar.monthsTranslate += 1;

        if (prevMonth === calendar.currentMonth) {
          var prevMonthTranslate = -calendar.monthsTranslate * 100 * inverter;
          var prevMonthHtml = $(calendar.renderMonth(prevDateTime, 'prev')).transform("translate3d(" + (isH ? prevMonthTranslate : 0) + "%, " + (isH ? 0 : prevMonthTranslate) + "%, 0)").addClass('calendar-month-prev');
          $wrapperEl.prepend(prevMonthHtml[0]);
          calendar.$months = $wrapperEl.find('.calendar-month');
          calendar.emit('local::monthAdd calendarMonthAdd', calendar.$months.eq(0)[0]);
        }

        calendar.animating = true;
        calendar.onMonthChangeStart('prev');
        var translate = calendar.monthsTranslate * 100 * inverter;
        $wrapperEl.transition(transition).transform("translate3d(" + (isH ? translate : 0) + "%, " + (isH ? 0 : translate) + "%, 0)");

        if (transitionEndCallback) {
          $wrapperEl.transitionEnd(function () {
            calendar.onMonthChangeEnd('prev');
          });
        }

        if (!params.animate) {
          calendar.onMonthChangeEnd('prev');
        }
      };

      _proto.resetMonth = function resetMonth(transition) {
        if (transition === void 0) {
          transition = '';
        }

        var calendar = this;
        var $wrapperEl = calendar.$wrapperEl,
            inverter = calendar.inverter,
            isH = calendar.isHorizontal,
            monthsTranslate = calendar.monthsTranslate;
        var translate = monthsTranslate * 100 * inverter;
        $wrapperEl.transition(transition).transform("translate3d(" + (isH ? translate : 0) + "%, " + (isH ? 0 : translate) + "%, 0)");
      } // eslint-disable-next-line
      ;

      _proto.setYearMonth = function setYearMonth(year, month, transition) {
        var calendar = this;
        var params = calendar.params,
            isH = calendar.isHorizontal,
            $wrapperEl = calendar.$wrapperEl,
            inverter = calendar.inverter; // eslint-disable-next-line

        if (typeof year === 'undefined') year = calendar.currentYear; // eslint-disable-next-line

        if (typeof month === 'undefined') month = calendar.currentMonth;

        if (typeof transition === 'undefined' || typeof transition === 'object') {
          // eslint-disable-next-line
          transition = ''; // eslint-disable-next-line

          if (!params.animate) transition = 0;
        }

        var targetDate;

        if (year < calendar.currentYear) {
          targetDate = new Date(year, month + 1, -1).getTime();
        } else {
          targetDate = new Date(year, month).getTime();
        }

        if (params.maxDate && targetDate > new Date(params.maxDate).getTime()) {
          return false;
        }

        if (params.minDate) {
          var minDate = new Date(params.minDate);
          minDate = new Date(minDate.getFullYear(), minDate.getMonth(), 1);

          if (targetDate < minDate.getTime()) {
            return false;
          }
        }

        var currentDate = new Date(calendar.currentYear, calendar.currentMonth).getTime();
        var dir = targetDate > currentDate ? 'next' : 'prev';
        var newMonthHTML = calendar.renderMonth(new Date(year, month));
        calendar.monthsTranslate = calendar.monthsTranslate || 0;
        var prevTranslate = calendar.monthsTranslate;
        var monthTranslate;
        var transitionEndCallback = !calendar.animating && transition !== 0;

        if (targetDate > currentDate) {
          // To next
          calendar.monthsTranslate -= 1;
          if (!calendar.animating) calendar.$months.eq(calendar.$months.length - 1).remove();
          $wrapperEl.append(newMonthHTML);
          calendar.$months = $wrapperEl.find('.calendar-month');
          monthTranslate = -(prevTranslate - 1) * 100 * inverter;
          calendar.$months.eq(calendar.$months.length - 1).transform("translate3d(" + (isH ? monthTranslate : 0) + "%, " + (isH ? 0 : monthTranslate) + "%, 0)").addClass('calendar-month-next');
        } else {
          // To prev
          calendar.monthsTranslate += 1;
          if (!calendar.animating) calendar.$months.eq(0).remove();
          $wrapperEl.prepend(newMonthHTML);
          calendar.$months = $wrapperEl.find('.calendar-month');
          monthTranslate = -(prevTranslate + 1) * 100 * inverter;
          calendar.$months.eq(0).transform("translate3d(" + (isH ? monthTranslate : 0) + "%, " + (isH ? 0 : monthTranslate) + "%, 0)").addClass('calendar-month-prev');
        }

        calendar.emit('local::monthAdd calendarMonthAdd', dir === 'next' ? calendar.$months.eq(calendar.$months.length - 1)[0] : calendar.$months.eq(0)[0]);
        calendar.animating = true;
        calendar.onMonthChangeStart(dir);
        var wrapperTranslate = calendar.monthsTranslate * 100 * inverter;
        $wrapperEl.transition(transition).transform("translate3d(" + (isH ? wrapperTranslate : 0) + "%, " + (isH ? 0 : wrapperTranslate) + "%, 0)");

        if (transitionEndCallback) {
          $wrapperEl.transitionEnd(function () {
            calendar.onMonthChangeEnd(dir, true);
          });
        }

        if (!params.animate || transition === 0) {
          calendar.onMonthChangeEnd(dir, true);
        }
      };

      _proto.nextYear = function nextYear() {
        var calendar = this;
        calendar.setYearMonth(calendar.currentYear + 1);
      };

      _proto.prevYear = function prevYear() {
        var calendar = this;
        calendar.setYearMonth(calendar.currentYear - 1);
      } // eslint-disable-next-line
      ;

      _proto.dateInRange = function dateInRange(dayDate, range) {
        var match = false;
        var i;
        if (!range) return false;

        if (Array.isArray(range)) {
          for (i = 0; i < range.length; i += 1) {
            if (range[i].from || range[i].to) {
              if (range[i].from && range[i].to) {
                if (dayDate <= new Date(range[i].to).getTime() && dayDate >= new Date(range[i].from).getTime()) {
                  match = true;
                }
              } else if (range[i].from) {
                if (dayDate >= new Date(range[i].from).getTime()) {
                  match = true;
                }
              } else if (range[i].to) {
                if (dayDate <= new Date(range[i].to).getTime()) {
                  match = true;
                }
              }
            } else if (range[i].date) {
              if (dayDate === new Date(range[i].date).getTime()) {
                match = true;
              }
            } else if (dayDate === new Date(range[i]).getTime()) {
              match = true;
            }
          }
        } else if (range.from || range.to) {
          if (range.from && range.to) {
            if (dayDate <= new Date(range.to).getTime() && dayDate >= new Date(range.from).getTime()) {
              match = true;
            }
          } else if (range.from) {
            if (dayDate >= new Date(range.from).getTime()) {
              match = true;
            }
          } else if (range.to) {
            if (dayDate <= new Date(range.to).getTime()) {
              match = true;
            }
          }
        } else if (range.date) {
          match = dayDate === new Date(range.date).getTime();
        } else if (typeof range === 'function') {
          match = range(new Date(dayDate));
        }

        return match;
      } // eslint-disable-next-line
      ;

      _proto.daysInMonth = function daysInMonth(date) {
        var d = new Date(date);
        return new Date(d.getFullYear(), d.getMonth() + 1, 0).getDate();
      };

      _proto.renderMonths = function renderMonths(date) {
        var calendar = this;

        if (calendar.params.renderMonths) {
          return calendar.params.renderMonths.call(calendar, date);
        }

        return $jsx("div", {
          class: "calendar-months-wrapper"
        }, calendar.renderMonth(date, 'prev'), calendar.renderMonth(date), calendar.renderMonth(date, 'next'));
      };

      _proto.renderMonth = function renderMonth(d, offset) {
        var calendar = this;
        var params = calendar.params,
            value = calendar.value;

        if (params.renderMonth) {
          return params.renderMonth.call(calendar, d, offset);
        }

        var date = new Date(d);
        var year = date.getFullYear();
        var month = date.getMonth();
        var localeMonth = calendar.monthNames.indexOf(calendar.monthFormatter(date));
        if (localeMonth < 0) localeMonth = month;
        var localeYear = calendar.yearFormatter(date);

        if (offset === 'next') {
          if (month === 11) date = new Date(year + 1, 0);else date = new Date(year, month + 1, 1);
        }

        if (offset === 'prev') {
          if (month === 0) date = new Date(year - 1, 11);else date = new Date(year, month - 1, 1);
        }

        if (offset === 'next' || offset === 'prev') {
          month = date.getMonth();
          year = date.getFullYear();
          localeMonth = calendar.monthNames.indexOf(calendar.monthFormatter(date));
          if (localeMonth < 0) localeMonth = month;
          localeYear = calendar.yearFormatter(date);
        }

        var currentValues = [];
        var today = new Date().setHours(0, 0, 0, 0);
        var minDate = params.minDate ? new Date(params.minDate).getTime() : null;
        var maxDate = params.maxDate ? new Date(params.maxDate).getTime() : null;
        var rows = 6;
        var cols = 7;
        var daysInPrevMonth = calendar.daysInMonth(new Date(date.getFullYear(), date.getMonth()).getTime() - 10 * 24 * 60 * 60 * 1000);
        var daysInMonth = calendar.daysInMonth(date);
        var minDayNumber = params.firstDay === 6 ? 0 : 1;
        var monthHtml = '';
        var dayIndex = 0 + (params.firstDay - 1);
        var disabled;
        var hasEvents;
        var firstDayOfMonthIndex = new Date(date.getFullYear(), date.getMonth()).getDay();
        if (firstDayOfMonthIndex === 0) firstDayOfMonthIndex = 7;

        if (value && value.length) {
          for (var i = 0; i < value.length; i += 1) {
            currentValues.push(new Date(value[i]).setHours(0, 0, 0, 0));
          }
        }

        for (var row = 1; row <= rows; row += 1) {
          var rowHtml = '';

          var _loop = function _loop(col) {
            dayIndex += 1;
            var dayDate = void 0;
            var dayNumber = dayIndex - firstDayOfMonthIndex;
            var addClass = '';

            if (row === 1 && col === 1 && dayNumber > minDayNumber && params.firstDay !== 1) {
              dayIndex -= 7;
              dayNumber = dayIndex - firstDayOfMonthIndex;
            }

            var weekDayIndex = col - 1 + params.firstDay > 6 ? col - 1 - 7 + params.firstDay : col - 1 + params.firstDay;

            if (dayNumber < 0) {
              dayNumber = daysInPrevMonth + dayNumber + 1;
              addClass += ' calendar-day-prev';
              dayDate = new Date(month - 1 < 0 ? year - 1 : year, month - 1 < 0 ? 11 : month - 1, dayNumber).getTime();
            } else {
              dayNumber += 1;

              if (dayNumber > daysInMonth) {
                dayNumber -= daysInMonth;
                addClass += ' calendar-day-next';
                dayDate = new Date(month + 1 > 11 ? year + 1 : year, month + 1 > 11 ? 0 : month + 1, dayNumber).getTime();
              } else {
                dayDate = new Date(year, month, dayNumber).getTime();
              }
            } // Today


            if (dayDate === today) addClass += ' calendar-day-today'; // Selected

            if (params.rangePicker && currentValues.length === 2) {
              if (dayDate >= currentValues[0] && dayDate <= currentValues[1]) {
                addClass += ' calendar-day-selected';
              }

              if (currentValues[0] !== currentValues[1]) {
                if (dayDate > currentValues[0] && dayDate < currentValues[1]) {
                  addClass += ' calendar-day-selected-range';
                }

                if (dayDate === currentValues[0]) {
                  addClass += ' calendar-day-selected-left';
                }

                if (dayDate === currentValues[1]) {
                  addClass += ' calendar-day-selected-right';
                }
              }
            } else if (currentValues.indexOf(dayDate) >= 0) addClass += ' calendar-day-selected'; // Weekend


            if (params.weekendDays.indexOf(weekDayIndex) >= 0) {
              addClass += ' calendar-day-weekend';
            } // Events


            var eventsHtml = '';
            hasEvents = false;

            if (params.events) {
              if (calendar.dateInRange(dayDate, params.events)) {
                hasEvents = true;
              }
            }

            if (hasEvents) {
              addClass += ' calendar-day-has-events'; // prettier-ignore

              eventsHtml = "\n            <span class=\"calendar-day-events\">\n              <span class=\"calendar-day-event\"></span>\n            </span>\n          ";

              if (Array.isArray(params.events)) {
                var eventDots = [];
                params.events.forEach(function (ev) {
                  var color = ev.color || '';

                  if (eventDots.indexOf(color) < 0 && calendar.dateInRange(dayDate, ev)) {
                    eventDots.push(color);
                  }
                }); // prettier-ignore

                eventsHtml = "\n              <span class=\"calendar-day-events\">\n                " + eventDots.map(function (color) {
                  return ("\n                  <span class=\"calendar-day-event\" style=\"" + (color ? "background-color: " + color : '') + "\"></span>\n                ").trim();
                }).join('') + "\n              </span>\n            ";
              }
            } // Custom Ranges


            if (params.rangesClasses) {
              for (var k = 0; k < params.rangesClasses.length; k += 1) {
                if (calendar.dateInRange(dayDate, params.rangesClasses[k].range)) {
                  addClass += " " + params.rangesClasses[k].cssClass;
                }
              }
            } // Disabled


            disabled = false;

            if (minDate && dayDate < minDate || maxDate && dayDate > maxDate) {
              disabled = true;
            }

            if (params.disabled) {
              if (calendar.dateInRange(dayDate, params.disabled)) {
                disabled = true;
              }
            }

            if (disabled) {
              addClass += ' calendar-day-disabled';
            }

            dayDate = new Date(dayDate);
            var dayYear = dayDate.getFullYear();
            var dayMonth = dayDate.getMonth();
            var dayNumberDisplay = calendar.dayFormatter(dayDate); // prettier-ignore

            rowHtml += ("\n          <div data-year=\"" + dayYear + "\" data-month=\"" + dayMonth + "\" data-day=\"" + dayNumber + "\" class=\"calendar-day" + addClass + "\" data-date=\"" + dayYear + "-" + dayMonth + "-" + dayNumber + "\">\n            <span class=\"calendar-day-number\">" + dayNumberDisplay + eventsHtml + "</span>\n          </div>").trim();
          };

          for (var col = 1; col <= cols; col += 1) {
            _loop(col);
          }

          monthHtml += "<div class=\"calendar-row\">" + rowHtml + "</div>";
        }

        monthHtml = "<div class=\"calendar-month\" data-year=\"" + year + "\" data-month=\"" + month + "\" data-locale-year=\"" + localeYear + "\" data-locale-month=\"" + localeMonth + "\">" + monthHtml + "</div>";
        return monthHtml;
      };

      _proto.renderWeekHeader = function renderWeekHeader() {
        var calendar = this;

        if (calendar.params.renderWeekHeader) {
          return calendar.params.renderWeekHeader.call(calendar);
        }

        var params = calendar.params;
        var weekDaysHtml = '';

        for (var i = 0; i < 7; i += 1) {
          var dayIndex = i + params.firstDay > 6 ? i - 7 + params.firstDay : i + params.firstDay;
          var dayName = calendar.dayNamesShort[dayIndex];
          weekDaysHtml += "<div class=\"calendar-week-day\">" + dayName + "</div>";
        }

        return $jsx("div", {
          class: "calendar-week-header"
        }, weekDaysHtml);
      };

      _proto.renderMonthSelector = function renderMonthSelector() {
        var calendar = this;

        if (calendar.params.renderMonthSelector) {
          return calendar.params.renderMonthSelector.call(calendar);
        }

        return $jsx("div", {
          class: "calendar-month-selector"
        }, $jsx("a", {
          class: "link icon-only calendar-prev-month-button"
        }, $jsx("i", {
          class: "icon icon-prev"
        })), calendar.params.monthPicker ? $jsx("a", {
          class: "current-month-value link"
        }) : $jsx("span", {
          class: "current-month-value"
        }), $jsx("a", {
          class: "link icon-only calendar-next-month-button"
        }, $jsx("i", {
          class: "icon icon-next"
        })));
      };

      _proto.renderMonthPicker = function renderMonthPicker() {
        var calendar = this;
        var localeMonth = parseInt(calendar.$el.find('.calendar-month-current').attr('data-locale-month'), 10);
        return $jsx("div", {
          class: "calendar-month-picker"
        }, calendar.monthNames.map(function (m, index) {
          return $jsx("div", {
            class: "calendar-month-picker-item " + (localeMonth === index ? 'calendar-month-picker-item-current' : '')
          }, $jsx("span", null, m));
        }));
      };

      _proto.renderYearSelector = function renderYearSelector() {
        var calendar = this;

        if (calendar.params.renderYearSelector) {
          return calendar.params.renderYearSelector.call(calendar);
        }

        return $jsx("div", {
          class: "calendar-year-selector"
        }, $jsx("a", {
          class: "link icon-only calendar-prev-year-button"
        }, $jsx("i", {
          class: "icon icon-prev"
        })), calendar.params.yearPicker ? $jsx("a", {
          class: "current-year-value link"
        }) : $jsx("span", {
          class: "current-year-value"
        }), $jsx("a", {
          class: "link icon-only calendar-next-year-button"
        }, $jsx("i", {
          class: "icon icon-next"
        })));
      };

      _proto.renderYearPicker = function renderYearPicker() {
        var calendar = this;
        var currentYear = calendar.currentYear;
        var yearMin = calendar.params.yearPickerMin || new Date().getFullYear() - 100;

        if (calendar.params.minDate) {
          yearMin = Math.max(yearMin, new Date(calendar.params.minDate).getFullYear());
        }

        var yearMax = calendar.params.yearPickerMax || new Date().getFullYear() + 100;

        if (calendar.params.maxDate) {
          yearMax = Math.min(yearMax, new Date(calendar.params.maxDate).getFullYear());
        }

        var years = [];

        for (var i = yearMin; i <= yearMax; i += 1) {
          years.push(i);
        }

        return $jsx("div", {
          class: "calendar-year-picker"
        }, years.map(function (year) {
          return $jsx("div", {
            "data-year": year,
            class: "calendar-year-picker-item " + (year === currentYear ? 'calendar-year-picker-item-current' : '')
          }, $jsx("span", null, calendar.yearFormatter(new Date().setFullYear(year))));
        }));
      } // eslint-disable-next-line
      ;

      _proto.renderTimeSelector = function renderTimeSelector() {
        var calendar = this;
        var value = calendar.value && calendar.value[0];
        var timeString;
        if (value) timeString = calendar.timeSelectorFormatter(value);
        return $jsx("div", {
          class: "calendar-time-selector"
        }, $jsx("a", {
          class: "link"
        }, timeString || calendar.params.timePickerPlaceholder));
      };

      _proto.renderHeader = function renderHeader() {
        var calendar = this;

        if (calendar.params.renderHeader) {
          return calendar.params.renderHeader.call(calendar);
        }

        return $jsx("div", {
          class: "calendar-header"
        }, $jsx("div", {
          class: "calendar-selected-date"
        }, calendar.params.headerPlaceholder));
      };

      _proto.renderFooter = function renderFooter() {
        var calendar = this;
        var app = calendar.app;

        if (calendar.params.renderFooter) {
          return calendar.params.renderFooter.call(calendar);
        }

        return $jsx("div", {
          class: "calendar-footer"
        }, $jsx("a", {
          class: (app.theme === 'md' ? 'button' : 'link') + " calendar-close sheet-close popover-close"
        }, calendar.params.toolbarCloseText));
      };

      _proto.renderToolbar = function renderToolbar() {
        var calendar = this;

        if (calendar.params.renderToolbar) {
          return calendar.params.renderToolbar.call(calendar, calendar);
        } // prettier-ignore


        return $jsx("div", {
          class: "toolbar toolbar-top no-shadow"
        }, $jsx("div", {
          class: "toolbar-inner"
        }, calendar.params.monthSelector ? calendar.renderMonthSelector() : '', calendar.params.yearSelector ? calendar.renderYearSelector() : ''));
      } // eslint-disable-next-line
      ;

      _proto.renderInline = function renderInline() {
        var calendar = this;
        var _calendar$params4 = calendar.params,
            cssClass = _calendar$params4.cssClass,
            toolbar = _calendar$params4.toolbar,
            header = _calendar$params4.header,
            footer = _calendar$params4.footer,
            rangePicker = _calendar$params4.rangePicker,
            weekHeader = _calendar$params4.weekHeader;
        var value = calendar.value,
            hasTimePicker = calendar.hasTimePicker;
        var date = value && value.length ? value[0] : new Date().setHours(0, 0, 0);
        return $jsx("div", {
          class: "calendar calendar-inline " + (rangePicker ? 'calendar-range' : '') + " " + (cssClass || '')
        }, header && calendar.renderHeader(), toolbar && calendar.renderToolbar(), weekHeader && calendar.renderWeekHeader(), $jsx("div", {
          class: "calendar-months"
        }, calendar.renderMonths(date)), hasTimePicker && calendar.renderTimeSelector(), footer && calendar.renderFooter());
      };

      _proto.renderCustomModal = function renderCustomModal() {
        var calendar = this;
        var _calendar$params5 = calendar.params,
            cssClass = _calendar$params5.cssClass,
            toolbar = _calendar$params5.toolbar,
            header = _calendar$params5.header,
            footer = _calendar$params5.footer,
            rangePicker = _calendar$params5.rangePicker,
            weekHeader = _calendar$params5.weekHeader;
        var value = calendar.value,
            hasTimePicker = calendar.hasTimePicker;
        var date = value && value.length ? value[0] : new Date().setHours(0, 0, 0);
        return $jsx("div", {
          class: "calendar calendar-modal " + (rangePicker ? 'calendar-range' : '') + " " + (cssClass || '')
        }, header && calendar.renderHeader(), toolbar && calendar.renderToolbar(), weekHeader && calendar.renderWeekHeader(), $jsx("div", {
          class: "calendar-months"
        }, calendar.renderMonths(date)), hasTimePicker && calendar.renderTimeSelector(), footer && calendar.renderFooter());
      };

      _proto.renderSheet = function renderSheet() {
        var calendar = this;
        var _calendar$params6 = calendar.params,
            cssClass = _calendar$params6.cssClass,
            toolbar = _calendar$params6.toolbar,
            header = _calendar$params6.header,
            footer = _calendar$params6.footer,
            rangePicker = _calendar$params6.rangePicker,
            weekHeader = _calendar$params6.weekHeader;
        var value = calendar.value,
            hasTimePicker = calendar.hasTimePicker;
        var date = value && value.length ? value[0] : new Date().setHours(0, 0, 0);
        return $jsx("div", {
          class: "sheet-modal calendar calendar-sheet " + (rangePicker ? 'calendar-range' : '') + " " + (cssClass || '')
        }, header && calendar.renderHeader(), toolbar && calendar.renderToolbar(), weekHeader && calendar.renderWeekHeader(), $jsx("div", {
          class: "sheet-modal-inner calendar-months"
        }, calendar.renderMonths(date)), hasTimePicker && calendar.renderTimeSelector(), footer && calendar.renderFooter());
      };

      _proto.renderPopover = function renderPopover() {
        var calendar = this;
        var _calendar$params7 = calendar.params,
            cssClass = _calendar$params7.cssClass,
            toolbar = _calendar$params7.toolbar,
            header = _calendar$params7.header,
            footer = _calendar$params7.footer,
            rangePicker = _calendar$params7.rangePicker,
            weekHeader = _calendar$params7.weekHeader;
        var value = calendar.value,
            hasTimePicker = calendar.hasTimePicker;
        var date = value && value.length ? value[0] : new Date().setHours(0, 0, 0);
        return $jsx("div", {
          class: "popover calendar-popover"
        }, $jsx("div", {
          class: "popover-inner"
        }, $jsx("div", {
          class: "calendar " + (rangePicker ? 'calendar-range' : '') + " " + (cssClass || '')
        }, header && calendar.renderHeader(), toolbar && calendar.renderToolbar(), weekHeader && calendar.renderWeekHeader(), $jsx("div", {
          class: "calendar-months"
        }, calendar.renderMonths(date)), hasTimePicker && calendar.renderTimeSelector(), footer && calendar.renderFooter())));
      };

      _proto.render = function render() {
        var calendar = this;
        var params = calendar.params;
        if (params.render) return params.render.call(calendar);

        if (!calendar.inline) {
          var modalType = params.openIn;
          if (modalType === 'auto') modalType = calendar.isPopover() ? 'popover' : 'sheet';
          if (modalType === 'popover') return calendar.renderPopover();
          if (modalType === 'sheet') return calendar.renderSheet();
          return calendar.renderCustomModal();
        }

        return calendar.renderInline();
      };

      _proto.openTimePicker = function openTimePicker() {
        var calendar = this;
        var $el = calendar.$el,
            app = calendar.app,
            is12HoursFormat = calendar.is12HoursFormat;
        if (!$el || !$el.length) return;
        $el.append('<div class="calendar-time-picker"></div>');
        var hoursArr = [];
        var minutesArr = [];
        var hoursMin = is12HoursFormat ? 1 : 0;
        var hoursMax = is12HoursFormat ? 12 : 23;

        for (var i = hoursMin; i <= hoursMax; i += 1) {
          hoursArr.push(i);
        }

        for (var _i2 = 0; _i2 <= 59; _i2 += 1) {
          minutesArr.push(_i2);
        }

        var value;

        if (calendar.value && calendar.value.length) {
          value = [calendar.value[0].getHours(), calendar.value[0].getMinutes()];
        } else {
          value = [new Date().getHours(), new Date().getMinutes()];
        }

        if (is12HoursFormat) {
          value.push(value[0] < 12 ? 'AM' : 'PM');
          if (value[0] > 12) value[0] -= 12;
          if (value[0] === 0) value[0] = 12;
        }

        calendar.timePickerInstance = app.picker.create({
          containerEl: $el.find('.calendar-time-picker'),
          value: value,
          toolbar: true,
          rotateEffect: false,
          toolbarCloseText: calendar.params.toolbarCloseText,
          cols: [{
            values: hoursArr
          }, {
            divider: true,
            content: ':'
          }, {
            values: minutesArr,
            displayValues: minutesArr.map(function (m) {
              return m < 10 ? "0" + m : m;
            })
          }].concat(is12HoursFormat ? [{
            values: ['AM', 'PM']
          }] : [])
        });
        calendar.timePickerInstance.$el.find('.toolbar a').removeClass('sheet-close popover-close').addClass('calendar-time-picker-close');
      };

      _proto.closeTimePicker = function closeTimePicker() {
        var calendar = this;
        var is12HoursFormat = calendar.is12HoursFormat;

        if (calendar.timePickerInstance) {
          var timePickerValue = calendar.timePickerInstance.value;
          var hours = parseInt(timePickerValue[0], 10);
          var minutes = parseInt(timePickerValue[1], 10);
          var period = calendar.timePickerInstance.value[2];

          if (is12HoursFormat) {
            if (period === 'AM' && hours === 12) {
              hours = 0;
            } else if (period === 'PM' && hours !== 12) {
              hours += 12;
            }
          }

          var value = calendar.value && calendar.value.length && calendar.value[0];

          if (!value) {
            value = new Date();
            value.setHours(hours, minutes, 0, 0);
          } else {
            value = new Date(value);
            value.setHours(hours, minutes);
          }

          calendar.setValue([value]);
          calendar.timePickerInstance.close();
          calendar.timePickerInstance.destroy();
          delete calendar.timePickerInstance;
        }

        if (calendar.$el && calendar.$el.length) {
          calendar.$el.find('.calendar-time-picker').remove();
        }
      };

      _proto.onOpen = function onOpen() {
        var calendar = this;
        var initialized = calendar.initialized,
            $el = calendar.$el,
            app = calendar.app,
            $inputEl = calendar.$inputEl,
            inline = calendar.inline,
            value = calendar.value,
            params = calendar.params;
        calendar.closing = false;
        calendar.opened = true;
        calendar.opening = true; // Init main events

        calendar.attachCalendarEvents();
        var updateValue = !value && params.value; // Set value

        if (!initialized) {
          if (value) calendar.setValue(value, 0);else if (params.value) {
            calendar.setValue(calendar.normalizeValues(params.value), 0);
          }
        } else if (value) {
          calendar.setValue(value, 0);
        } // Update current month and year


        calendar.updateCurrentMonthYear(); // Set initial translate

        calendar.monthsTranslate = 0;
        calendar.setMonthsTranslate(); // Update input value

        if (updateValue) calendar.updateValue();else if (params.header && value) {
          calendar.updateValue(true);
        } // Extra focus

        if (!inline && $inputEl && $inputEl.length && app.theme === 'md') {
          $inputEl.trigger('focus');
        }

        calendar.initialized = true;
        calendar.$months.each(function (monthEl) {
          calendar.emit('local::monthAdd calendarMonthAdd', monthEl);
        }); // Trigger events

        if ($el) {
          $el.trigger('calendar:open');
        }

        if ($inputEl) {
          $inputEl.trigger('calendar:open');
        }

        calendar.emit('local::open calendarOpen', calendar);
      };

      _proto.onOpened = function onOpened() {
        var calendar = this;
        calendar.opening = false;

        if (calendar.$el) {
          calendar.$el.trigger('calendar:opened');
        }

        if (calendar.$inputEl) {
          calendar.$inputEl.trigger('calendar:opened');
        }

        calendar.emit('local::opened calendarOpened', calendar);
      };

      _proto.onClose = function onClose() {
        var calendar = this;
        var app = calendar.app;
        calendar.opening = false;
        calendar.closing = true;

        if (calendar.$inputEl) {
          if (app.theme === 'md') {
            calendar.$inputEl.trigger('blur');
          } else {
            var validate = calendar.$inputEl.attr('validate');
            var required = calendar.$inputEl.attr('required');

            if (validate && required) {
              app.input.validate(calendar.$inputEl);
            }
          }
        }

        if (calendar.detachCalendarEvents) {
          calendar.detachCalendarEvents();
        }

        if (calendar.$el) {
          calendar.$el.trigger('calendar:close');
        }

        if (calendar.$inputEl) {
          calendar.$inputEl.trigger('calendar:close');
        }

        calendar.emit('local::close calendarClose', calendar);
      };

      _proto.onClosed = function onClosed() {
        var calendar = this;
        calendar.opened = false;
        calendar.closing = false;

        if (!calendar.inline) {
          nextTick$1(function () {
            if (calendar.modal && calendar.modal.el && calendar.modal.destroy) {
              if (!calendar.params.routableModals) {
                calendar.modal.destroy();
              }
            }

            delete calendar.modal;
          });
        }

        if (calendar.timePickerInstance) {
          if (calendar.timePickerInstance.destroy) calendar.timePickerInstance.destroy();
          delete calendar.timePickerInstance;
        }

        if (calendar.$el) {
          calendar.$el.trigger('calendar:closed');
        }

        if (calendar.$inputEl) {
          calendar.$inputEl.trigger('calendar:closed');
        }

        calendar.emit('local::closed calendarClosed', calendar);
      };

      _proto.open = function open() {
        var calendar = this;
        var app = calendar.app,
            opened = calendar.opened,
            inline = calendar.inline,
            $inputEl = calendar.$inputEl,
            params = calendar.params;
        if (opened) return;

        if (inline) {
          calendar.$el = $(calendar.render());
          calendar.$el[0].f7Calendar = calendar;
          calendar.$wrapperEl = calendar.$el.find('.calendar-months-wrapper');
          calendar.$months = calendar.$wrapperEl.find('.calendar-month');
          calendar.$containerEl.append(calendar.$el);
          calendar.onOpen();
          calendar.onOpened();
          return;
        }

        var modalType = params.openIn;

        if (modalType === 'auto') {
          modalType = calendar.isPopover() ? 'popover' : 'sheet';
        }

        var modalContent = calendar.render();
        var modalParams = {
          targetEl: $inputEl,
          scrollToEl: params.scrollToInput ? $inputEl : undefined,
          content: modalContent,
          backdrop: params.backdrop === true || modalType === 'popover' && app.params.popover.backdrop !== false && params.backdrop !== false,
          closeByBackdropClick: params.closeByBackdropClick,
          on: {
            open: function open() {
              var modal = this;
              calendar.modal = modal;
              calendar.$el = modalType === 'popover' ? modal.$el.find('.calendar') : modal.$el;
              calendar.$wrapperEl = calendar.$el.find('.calendar-months-wrapper');
              calendar.$months = calendar.$wrapperEl.find('.calendar-month');
              calendar.$el[0].f7Calendar = calendar;

              if (modalType === 'customModal') {
                $(calendar.$el).find('.calendar-close').once('click', function () {
                  calendar.close();
                });
              }

              calendar.onOpen();
            },
            opened: function opened() {
              calendar.onOpened();
            },
            close: function close() {
              calendar.onClose();
            },
            closed: function closed() {
              calendar.onClosed();
            }
          }
        };

        if (modalType === 'sheet') {
          modalParams.push = params.sheetPush;
          modalParams.swipeToClose = params.sheetSwipeToClose;
        }

        if (params.routableModals && calendar.view) {
          var _route;

          calendar.view.router.navigate({
            url: calendar.url,
            route: (_route = {
              path: calendar.url
            }, _route[modalType] = modalParams, _route)
          });
        } else {
          calendar.modal = app[modalType].create(modalParams);
          calendar.modal.open();
        }
      };

      _proto.close = function close() {
        var calendar = this;
        var opened = calendar.opened,
            inline = calendar.inline;
        if (!opened) return;

        if (inline) {
          calendar.onClose();
          calendar.onClosed();
          return;
        }

        if (calendar.params.routableModals && calendar.view) {
          calendar.view.router.back();
        } else {
          calendar.modal.close();
        }
      };

      _proto.init = function init() {
        var calendar = this;
        calendar.initInput();

        if (calendar.inline) {
          calendar.open();
          calendar.emit('local::init calendarInit', calendar);
          return;
        }

        if (!calendar.initialized && calendar.params.value) {
          calendar.setValue(calendar.normalizeValues(calendar.params.value));
        } // Attach input Events


        if (calendar.$inputEl) {
          calendar.attachInputEvents();
        }

        if (calendar.params.closeByOutsideClick) {
          calendar.attachHtmlEvents();
        }

        calendar.emit('local::init calendarInit', calendar);
      };

      _proto.destroy = function destroy() {
        var calendar = this;
        if (calendar.destroyed) return;
        var $el = calendar.$el;
        calendar.emit('local::beforeDestroy calendarBeforeDestroy', calendar);
        if ($el) $el.trigger('calendar:beforedestroy');
        calendar.close(); // Detach Events

        if (calendar.$inputEl) {
          calendar.detachInputEvents();
        }

        if (calendar.params.closeByOutsideClick) {
          calendar.detachHtmlEvents();
        }

        if (calendar.timePickerInstance) {
          if (calendar.timePickerInstance.destroy) calendar.timePickerInstance.destroy();
          delete calendar.timePickerInstance;
        }

        if ($el && $el.length) delete calendar.$el[0].f7Calendar;
        deleteProps$1(calendar);
        calendar.destroyed = true;
      };

      _createClass$1(Calendar, [{
        key: "view",
        get: function get() {
          var $inputEl = this.$inputEl,
              app = this.app,
              params = this.params;
          var view;

          if (params.view) {
            view = params.view;
          } else if ($inputEl) {
            view = $inputEl.parents('.view').length && $inputEl.parents('.view')[0].f7View;
          }

          if (!view) view = app.views.main;
          return view;
        }
      }]);

      return Calendar;
    }(Framework7Class);

    var Calendar = {
      name: 'calendar',
      static: {
        Calendar: Calendar$1
      },
      create: function create() {
        var app = this;
        app.calendar = ConstructorMethods({
          defaultSelector: '.calendar',
          constructor: Calendar$1,
          app: app,
          domProp: 'f7Calendar'
        });

        app.calendar.close = function close(el) {
          if (el === void 0) {
            el = '.calendar';
          }

          var $el = $(el);
          if ($el.length === 0) return;
          var calendar = $el[0].f7Calendar;
          if (!calendar || calendar && !calendar.opened) return;
          calendar.close();
        };
      },
      params: {
        calendar: {
          // Calendar settings
          dateFormat: undefined,
          monthNames: 'auto',
          monthNamesShort: 'auto',
          dayNames: 'auto',
          dayNamesShort: 'auto',
          locale: undefined,
          firstDay: 1,
          // First day of the week, Monday
          weekendDays: [0, 6],
          // Sunday and Saturday
          multiple: false,
          rangePicker: false,
          rangePickerMinDays: 1,
          // when calendar is used as rangePicker
          rangePickerMaxDays: 0,
          // when calendar is used as rangePicker, 0 means unlimited
          direction: 'horizontal',
          // or 'vertical'
          minDate: null,
          maxDate: null,
          disabled: null,
          // dates range of disabled days
          events: null,
          // dates range of days with events
          rangesClasses: null,
          // array with custom classes date ranges
          touchMove: true,
          animate: true,
          closeOnSelect: false,
          monthSelector: true,
          monthPicker: true,
          yearSelector: true,
          yearPicker: true,
          yearPickerMin: undefined,
          yearPickerMax: undefined,
          timePicker: false,
          timePickerFormat: {
            hour: 'numeric',
            minute: 'numeric'
          },
          timePickerPlaceholder: 'Select time',
          weekHeader: true,
          value: null,
          // Common opener settings
          containerEl: null,
          openIn: 'auto',
          // or 'popover' or 'sheet' or 'customModal'
          sheetPush: false,
          sheetSwipeToClose: undefined,
          formatValue: null,
          inputEl: null,
          inputReadOnly: true,
          closeByOutsideClick: true,
          scrollToInput: true,
          header: false,
          headerPlaceholder: 'Select date',
          toolbar: true,
          toolbarCloseText: 'Done',
          footer: false,
          cssClass: null,
          routableModals: false,
          view: null,
          url: 'date/',
          backdrop: null,
          closeByBackdropClick: true,
          // Render functions
          renderWeekHeader: null,
          renderMonths: null,
          renderMonth: null,
          renderMonthSelector: null,
          renderYearSelector: null,
          renderHeader: null,
          renderFooter: null,
          renderToolbar: null,
          renderInline: null,
          renderPopover: null,
          renderSheet: null,
          render: null
        }
      }
    };

    function pickerColumn(colEl, updateItems) {
      var picker = this;
      var app = picker.app;
      var $colEl = $(colEl);
      var colIndex = $colEl.index();
      var col = picker.cols[colIndex];
      if (col.divider) return;
      col.$el = $colEl;
      col.el = $colEl[0];
      col.$itemsEl = col.$el.find('.picker-items');
      col.items = col.$itemsEl.find('.picker-item');
      var itemHeight;
      var itemsHeight;
      var minTranslate;
      var maxTranslate;
      var animationFrameId;

      function updateDuringScroll() {
        animationFrameId = requestAnimationFrame(function () {
          col.updateItems(undefined, undefined, 0);
          updateDuringScroll();
        });
      }

      col.replaceValues = function replaceColValues(values, displayValues) {
        col.detachEvents();
        col.values = values;
        col.displayValues = displayValues;
        col.$itemsEl.html(picker.renderColumn(col, true));
        col.items = col.$itemsEl.find('.picker-item');
        col.calcSize();
        col.setValue(col.values[0], 0, true);
        col.attachEvents();
      };

      col.calcSize = function calcColSize() {
        if (picker.params.rotateEffect) {
          col.$el.removeClass('picker-column-absolute');
          if (!col.width) col.$el.css({
            width: ''
          });
        }

        var colWidth = 0;
        var colHeight = col.$el[0].offsetHeight;
        itemHeight = col.items[0].offsetHeight;
        itemsHeight = itemHeight * col.items.length;
        minTranslate = colHeight / 2 - itemsHeight + itemHeight / 2;
        maxTranslate = colHeight / 2 - itemHeight / 2;

        if (col.width) {
          colWidth = col.width;
          if (parseInt(colWidth, 10) === colWidth) colWidth += 'px';
          col.$el.css({
            width: colWidth
          });
        }

        if (picker.params.rotateEffect) {
          if (!col.width) {
            col.items.each(function (itemEl) {
              var item = $(itemEl).children('span');
              colWidth = Math.max(colWidth, item[0].offsetWidth);
            });
            col.$el.css({
              width: colWidth + 2 + "px"
            });
          }

          col.$el.addClass('picker-column-absolute');
        }
      };

      col.setValue = function setColValue(newValue, transition, valueCallbacks) {
        if (transition === void 0) {
          transition = '';
        }

        var newActiveIndex = col.$itemsEl.find(".picker-item[data-picker-value=\"" + newValue + "\"]").index();

        if (typeof newActiveIndex === 'undefined' || newActiveIndex === -1) {
          return;
        }

        var newTranslate = -newActiveIndex * itemHeight + maxTranslate; // Update wrapper

        col.$itemsEl.transition(transition);
        col.$itemsEl.transform("translate3d(0," + newTranslate + "px,0)"); // Watch items

        if (picker.params.updateValuesOnMomentum && col.activeIndex && col.activeIndex !== newActiveIndex) {
          cancelAnimationFrame(animationFrameId);
          col.$itemsEl.transitionEnd(function () {
            cancelAnimationFrame(animationFrameId);
          });
          updateDuringScroll();
        } // Update items


        col.updateItems(newActiveIndex, newTranslate, transition, valueCallbacks);
      };

      col.updateItems = function updateColItems(activeIndex, translate, transition, valueCallbacks) {
        if (typeof translate === 'undefined') {
          // eslint-disable-next-line
          translate = getTranslate$1(col.$itemsEl[0], 'y');
        }

        if (typeof activeIndex === 'undefined') // eslint-disable-next-line
          activeIndex = -Math.round((translate - maxTranslate) / itemHeight); // eslint-disable-next-line

        if (activeIndex < 0) activeIndex = 0; // eslint-disable-next-line

        if (activeIndex >= col.items.length) activeIndex = col.items.length - 1;
        var previousActiveIndex = col.activeIndex;
        col.activeIndex = activeIndex;
        col.$itemsEl.find('.picker-item-selected').removeClass('picker-item-selected');
        col.items.transition(transition);
        var selectedItem = col.items.eq(activeIndex).addClass('picker-item-selected').transform(''); // Set 3D rotate effect

        if (picker.params.rotateEffect) {
          col.items.each(function (itemEl) {
            var $itemEl = $(itemEl);
            var itemOffsetTop = $itemEl.index() * itemHeight;
            var translateOffset = maxTranslate - translate;
            var itemOffset = itemOffsetTop - translateOffset;
            var percentage = itemOffset / itemHeight;
            var itemsFit = Math.ceil(col.height / itemHeight / 2) + 1;
            var angle = -18 * percentage;
            if (angle > 180) angle = 180;
            if (angle < -180) angle = -180;

            if (Math.abs(percentage) > itemsFit) {
              $itemEl.addClass('picker-item-far');
            } else {
              $itemEl.removeClass('picker-item-far');
            }

            $itemEl.transform("translate3d(0, " + (-translate + maxTranslate) + "px, " + (picker.needsOriginFix ? -110 : 0) + "px) rotateX(" + angle + "deg)");
          });
        }

        if (valueCallbacks || typeof valueCallbacks === 'undefined') {
          // Update values
          col.value = selectedItem.attr('data-picker-value');
          col.displayValue = col.displayValues ? col.displayValues[activeIndex] : col.value; // On change callback

          if (previousActiveIndex !== activeIndex) {
            if (col.onChange) {
              col.onChange(picker, col.value, col.displayValue);
            }

            picker.updateValue();
          }
        }
      };

      var allowItemClick = true;
      var isTouched;
      var isMoved;
      var touchStartY;
      var touchCurrentY;
      var touchStartTime;
      var touchEndTime;
      var startTranslate;
      var returnTo;
      var currentTranslate;
      var prevTranslate;
      var velocityTranslate;

      function handleTouchStart(e) {
        if (isMoved || isTouched) return;
        e.preventDefault();
        isTouched = true;
        touchStartY = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
        touchCurrentY = touchStartY;
        touchStartTime = new Date().getTime();
        allowItemClick = true;
        startTranslate = getTranslate$1(col.$itemsEl[0], 'y');
        currentTranslate = startTranslate;
      }

      function handleTouchMove(e) {
        if (!isTouched) return;
        e.preventDefault();
        allowItemClick = false;
        touchCurrentY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

        if (!isMoved) {
          // First move
          cancelAnimationFrame(animationFrameId);
          isMoved = true;
          startTranslate = getTranslate$1(col.$itemsEl[0], 'y');
          currentTranslate = startTranslate;
          col.$itemsEl.transition(0);
        }

        var diff = touchCurrentY - touchStartY;
        currentTranslate = startTranslate + diff;
        returnTo = undefined; // Normalize translate

        if (currentTranslate < minTranslate) {
          currentTranslate = minTranslate - Math.pow(minTranslate - currentTranslate, 0.8);
          returnTo = 'min';
        }

        if (currentTranslate > maxTranslate) {
          currentTranslate = maxTranslate + Math.pow(currentTranslate - maxTranslate, 0.8);
          returnTo = 'max';
        } // Transform wrapper


        col.$itemsEl.transform("translate3d(0," + currentTranslate + "px,0)"); // Update items

        col.updateItems(undefined, currentTranslate, 0, picker.params.updateValuesOnTouchmove); // Calc velocity

        velocityTranslate = currentTranslate - prevTranslate || currentTranslate;
        prevTranslate = currentTranslate;
      }

      function handleTouchEnd() {
        if (!isTouched || !isMoved) {
          isTouched = false;
          isMoved = false;
          return;
        }

        isTouched = false;
        isMoved = false;
        col.$itemsEl.transition('');

        if (returnTo) {
          if (returnTo === 'min') {
            col.$itemsEl.transform("translate3d(0," + minTranslate + "px,0)");
          } else {
            col.$itemsEl.transform("translate3d(0," + maxTranslate + "px,0)");
          }
        }

        touchEndTime = new Date().getTime();
        var newTranslate;

        if (touchEndTime - touchStartTime > 300) {
          newTranslate = currentTranslate;
        } else {
          newTranslate = currentTranslate + velocityTranslate * picker.params.momentumRatio;
        }

        newTranslate = Math.max(Math.min(newTranslate, maxTranslate), minTranslate); // Active Index

        var activeIndex = Math.round(Math.abs((newTranslate - maxTranslate) / itemHeight)); // Normalize translate

        if (!picker.params.freeMode) newTranslate = -activeIndex * itemHeight + maxTranslate; // Transform wrapper

        col.$itemsEl.transform("translate3d(0," + parseInt(newTranslate, 10) + "px,0)"); // Update items

        col.updateItems(activeIndex, newTranslate, '', true); // Watch items

        if (picker.params.updateValuesOnMomentum) {
          updateDuringScroll();
          col.$itemsEl.transitionEnd(function () {
            cancelAnimationFrame(animationFrameId);
          });
        } // Allow click


        setTimeout(function () {
          allowItemClick = true;
        }, 100);
      }

      var mousewheelTimeout;

      function handleMouseWheel(e) {
        var deltaX = e.deltaX,
            deltaY = e.deltaY;
        if (Math.abs(deltaX) > Math.abs(deltaY)) return;
        clearTimeout(mousewheelTimeout);
        e.preventDefault();
        cancelAnimationFrame(animationFrameId);
        startTranslate = getTranslate$1(col.$itemsEl[0], 'y');
        col.$itemsEl.transition(0);
        currentTranslate = startTranslate - deltaY;
        returnTo = undefined; // Normalize translate

        if (currentTranslate < minTranslate) {
          currentTranslate = minTranslate;
          returnTo = 'min';
        }

        if (currentTranslate > maxTranslate) {
          currentTranslate = maxTranslate;
          returnTo = 'max';
        } // Transform wrapper


        col.$itemsEl.transform("translate3d(0," + currentTranslate + "px,0)"); // Update items

        col.updateItems(undefined, currentTranslate, 0, picker.params.updateValuesOnMousewheel); // On end

        mousewheelTimeout = setTimeout(function () {
          col.$itemsEl.transition('');

          if (returnTo) {
            if (returnTo === 'min') {
              col.$itemsEl.transform("translate3d(0," + minTranslate + "px,0)");
            } else {
              col.$itemsEl.transform("translate3d(0," + maxTranslate + "px,0)");
            }
          }

          touchEndTime = new Date().getTime();
          var newTranslate = currentTranslate;
          newTranslate = Math.max(Math.min(newTranslate, maxTranslate), minTranslate); // Active Index

          var activeIndex = Math.round(Math.abs((newTranslate - maxTranslate) / itemHeight)); // Normalize translate

          if (!picker.params.freeMode) newTranslate = -activeIndex * itemHeight + maxTranslate; // Transform wrapper

          col.$itemsEl.transform("translate3d(0," + parseInt(newTranslate, 10) + "px,0)"); // Update items

          col.updateItems(activeIndex, newTranslate, '', true);
        }, 200);
      }

      function handleClick() {
        if (!allowItemClick) return;
        cancelAnimationFrame(animationFrameId);
        var value = $(this).attr('data-picker-value');
        col.setValue(value);
      }

      var activeListener = getSupport$1().passiveListener ? {
        passive: false,
        capture: false
      } : false;

      col.attachEvents = function attachColEvents() {
        col.$el.on(app.touchEvents.start, handleTouchStart, activeListener);
        app.on('touchmove:active', handleTouchMove);
        app.on('touchend:passive', handleTouchEnd);

        if (picker.params.mousewheel) {
          col.$el.on('wheel', handleMouseWheel);
        }

        col.items.on('click', handleClick);
      };

      col.detachEvents = function detachColEvents() {
        col.$el.off(app.touchEvents.start, handleTouchStart, activeListener);
        app.off('touchmove:active', handleTouchMove);
        app.off('touchend:passive', handleTouchEnd);

        if (picker.params.mousewheel) {
          col.$el.off('wheel', handleMouseWheel);
        }

        col.items.off('click', handleClick);
      };

      col.init = function initCol() {
        col.calcSize();
        col.$itemsEl.transform("translate3d(0," + maxTranslate + "px,0)").transition(0);
        if (colIndex === 0) col.$el.addClass('picker-column-first');
        if (colIndex === picker.cols.length - 1) col.$el.addClass('picker-column-last'); // Update items on init

        if (updateItems) col.updateItems(0, maxTranslate, 0);
        col.attachEvents();
      };

      col.destroy = function destroyCol() {
        col.detachEvents();
      };

      col.init();
    }

    var Picker$1 = /*#__PURE__*/function (_Framework7Class) {
      _inheritsLoose(Picker, _Framework7Class);

      function Picker(app, params) {
        var _this;

        if (params === void 0) {
          params = {};
        }

        _this = _Framework7Class.call(this, params, [app]) || this;

        var picker = _assertThisInitialized(_this);

        var device = getDevice$1();
        var window = getWindow();
        picker.params = extend$1({}, app.params.picker, params);
        var $containerEl;

        if (picker.params.containerEl) {
          $containerEl = $(picker.params.containerEl);
          if ($containerEl.length === 0) return picker || _assertThisInitialized(_this);
        }

        var $inputEl;

        if (picker.params.inputEl) {
          $inputEl = $(picker.params.inputEl);
        }

        var $scrollToEl = picker.params.scrollToInput ? $inputEl : undefined;

        if (picker.params.scrollToEl) {
          var scrollToEl = $(picker.params.scrollToEl);

          if (scrollToEl.length > 0) {
            $scrollToEl = scrollToEl;
          }
        }

        extend$1(picker, {
          app: app,
          $containerEl: $containerEl,
          containerEl: $containerEl && $containerEl[0],
          inline: $containerEl && $containerEl.length > 0,
          needsOriginFix: device.ios || window.navigator.userAgent.toLowerCase().indexOf('safari') >= 0 && window.navigator.userAgent.toLowerCase().indexOf('chrome') < 0 && !device.android,
          cols: [],
          $inputEl: $inputEl,
          inputEl: $inputEl && $inputEl[0],
          $scrollToEl: $scrollToEl,
          initialized: false,
          opened: false,
          url: picker.params.url
        });

        function onResize() {
          picker.resizeCols();
        }

        function onInputClick() {
          picker.open();
        }

        function onInputFocus(e) {
          e.preventDefault();
        }

        var htmlTouchStartTarget = null;

        function onHtmlTouchStart(e) {
          htmlTouchStartTarget = e.target;
        }

        function onHtmlClick(e) {
          if (picker.destroyed || !picker.params) return;
          var $targetEl = $(e.target);
          if (picker.isPopover()) return;
          if (!picker.opened || picker.closing) return;
          if ($targetEl.closest('[class*="backdrop"]').length) return;

          if ($inputEl && $inputEl.length > 0) {
            if (htmlTouchStartTarget === e.target && $targetEl[0] !== $inputEl[0] && $targetEl.closest('.sheet-modal').length === 0) {
              picker.close();
            }
          } else if ($(e.target).closest('.sheet-modal').length === 0) {
            picker.close();
          }
        } // Events


        extend$1(picker, {
          attachResizeEvent: function attachResizeEvent() {
            app.on('resize', onResize);
          },
          detachResizeEvent: function detachResizeEvent() {
            app.off('resize', onResize);
          },
          attachInputEvents: function attachInputEvents() {
            picker.$inputEl.on('click', onInputClick);

            if (picker.params.inputReadOnly) {
              picker.$inputEl.on('focus mousedown', onInputFocus);

              if (picker.$inputEl[0]) {
                picker.$inputEl[0].f7ValidateReadonly = true;
              }
            }
          },
          detachInputEvents: function detachInputEvents() {
            picker.$inputEl.off('click', onInputClick);

            if (picker.params.inputReadOnly) {
              picker.$inputEl.off('focus mousedown', onInputFocus);

              if (picker.$inputEl[0]) {
                delete picker.$inputEl[0].f7ValidateReadonly;
              }
            }
          },
          attachHtmlEvents: function attachHtmlEvents() {
            app.on('click', onHtmlClick);
            app.on('touchstart', onHtmlTouchStart);
          },
          detachHtmlEvents: function detachHtmlEvents() {
            app.off('click', onHtmlClick);
            app.off('touchstart', onHtmlTouchStart);
          }
        });
        picker.init();
        return picker || _assertThisInitialized(_this);
      }

      var _proto = Picker.prototype;

      _proto.initInput = function initInput() {
        var picker = this;
        if (!picker.$inputEl) return;
        if (picker.params.inputReadOnly) picker.$inputEl.prop('readOnly', true);
      };

      _proto.resizeCols = function resizeCols() {
        var picker = this;
        if (!picker.opened) return;

        for (var i = 0; i < picker.cols.length; i += 1) {
          if (!picker.cols[i].divider) {
            picker.cols[i].calcSize();
            picker.cols[i].setValue(picker.cols[i].value, 0, false);
          }
        }
      };

      _proto.isPopover = function isPopover() {
        var picker = this;
        var app = picker.app,
            modal = picker.modal,
            params = picker.params;
        var device = getDevice$1();
        if (params.openIn === 'sheet') return false;
        if (modal && modal.type !== 'popover') return false;

        if (!picker.inline && picker.inputEl) {
          if (params.openIn === 'popover') return true;

          if (device.ios) {
            return !!device.ipad;
          }

          if (app.width >= 768) {
            return true;
          }

          if (device.desktop && app.theme === 'aurora') {
            return true;
          }
        }

        return false;
      };

      _proto.formatValue = function formatValue() {
        var picker = this;
        var value = picker.value,
            displayValue = picker.displayValue;

        if (picker.params.formatValue) {
          return picker.params.formatValue.call(picker, value, displayValue);
        }

        return value.join(' ');
      };

      _proto.setValue = function setValue(values, transition) {
        var picker = this;
        var valueIndex = 0;

        if (picker.cols.length === 0) {
          picker.value = values;
          picker.updateValue(values);
          return;
        }

        for (var i = 0; i < picker.cols.length; i += 1) {
          if (picker.cols[i] && !picker.cols[i].divider) {
            picker.cols[i].setValue(values[valueIndex], transition);
            valueIndex += 1;
          }
        }
      };

      _proto.getValue = function getValue() {
        var picker = this;
        return picker.value;
      };

      _proto.updateValue = function updateValue(forceValues) {
        var picker = this;
        var newValue = forceValues || [];
        var newDisplayValue = [];
        var column;

        if (picker.cols.length === 0) {
          var noDividerColumns = picker.params.cols.filter(function (c) {
            return !c.divider;
          });

          for (var i = 0; i < noDividerColumns.length; i += 1) {
            column = noDividerColumns[i];

            if (column.displayValues !== undefined && column.values !== undefined && column.values.indexOf(newValue[i]) !== -1) {
              newDisplayValue.push(column.displayValues[column.values.indexOf(newValue[i])]);
            } else {
              newDisplayValue.push(newValue[i]);
            }
          }
        } else {
          for (var _i = 0; _i < picker.cols.length; _i += 1) {
            if (!picker.cols[_i].divider) {
              newValue.push(picker.cols[_i].value);
              newDisplayValue.push(picker.cols[_i].displayValue);
            }
          }
        }

        if (newValue.indexOf(undefined) >= 0) {
          return;
        }

        picker.value = newValue;
        picker.displayValue = newDisplayValue;
        picker.emit('local::change pickerCha