<?php $__env->startSection('isi'); ?>
    <div class="container-fluid">
        <div class="card" style="border-radius: 20px">
            <div class="card-header">
                    <a href="<?php echo e(url('/pegawai/tambah-pegawai')); ?>" class="btn btn-sm btn-primary" style="border-radius: 10px">+ Tambah Data Pegawai</a>
                <button type="button" style="border-radius: 10px" class="btn btn-success btn-sm" data-toggle="modal" data-target="#import">
                    <i class="fa fa-table mr-2"></i>Import Data
                </button>
            </div>
            <div class="card-body">
                <form action="<?php echo e(url('/pegawai')); ?>">
                    <div class="form-row mb-2">
                        <div class="col-2">
                            <input type="text" class="form-control" value="<?php echo e(request('search')); ?>" name="search">
                        </div>
                        <div>
                            <button type="submit" id="search" class="form-control btn btn-secondary" style="border-radius: 10px"><i class="fas fa-search"></i></button>
                        </div>
                    </div>
                </form>
                <table id="tablePayroll" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Nama</th>
                            <th>Username</th>
                            <th>Jabatan</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data_user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $du): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($du->name); ?></td>
                                <td><?php echo e($du->username); ?></td>
                                <td><?php echo e($du->Jabatan->nama_jabatan); ?></td>
                                <td>
                                    <a href="<?php echo e(url('/pegawai/detail/'.$du->id)); ?>" class="btn btn-sm btn-info" title="Detail Pegawai"><i class="fa fa-solid fa-eye"></i></a>
                                    <a href="<?php echo e(url('/pegawai/edit-password/'.$du->id)); ?>" class="btn btn-sm btn-warning" title="Edit Password"><i class="fa fa-solid fa-key"></i></a>
                                    <form action="<?php echo e(url('/pegawai/delete/'.$du->id)); ?>" method="post" class="d-inline">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                        <button class="btn btn-danger btn-sm btn-circle" title="Delete Pegawai" onClick="return confirm('Are You Sure')"><i class="fa fa-solid fa-trash"></i></button>
                                    </form>
                                    <a href="<?php echo e(url('/pegawai/shift/'.$du->id)); ?>" class="btn btn-sm btn-success" title="Mapping Shift Pegawai"><i class="fa fa-solid fa-clock"></i></a>
                                    <a href="<?php echo e(url('/pegawai/dinas-luar/'.$du->id)); ?>" class="btn btn-sm btn-primary" title="Mapping Dinas Luar Pegawai"><i class="fa fa-solid fa-route"></i></a>
                                    <?php if($du->foto_face_recognition == null || $du->foto_face_recognition == ""): ?>
                                        <a href="<?php echo e(url('/pegawai/face/'.$du->id)); ?>" class="btn btn-sm" title="Face"><i class="fa fa-solid fa-camera"></i></a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
            </div>
            <div class="d-flex justify-content-end mr-4">
                <?php echo e($data_user->links()); ?>

            </div>
          </div>
    </div>
    <br>

    <div class="modal fade" id="import" tabindex="-1" role="dialog" aria-labelledby="importLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="importLabel">Import Data Karyawan</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <form action="<?php echo e(url('/pegawai/import')); ?>" method="POST" enctype="multipart/form-data">
                <div class="modal-body">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label for="file_excel">File Excel</label>
                        <input type="file" name="file_excel" id="file_excel" class="form-control <?php $__errorArgs = ['file_excel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['file_excel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback">
                                <?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
          </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>





<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\absensi_payroll\resources\views/karyawan/index.blade.php ENDPATH**/ ?>