
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Detail Pdf</title>
    <style>
        body {
          font-family: Arial, sans-serif;
        }
        .container {
          max-width: 800px;
          margin: 0 auto;
        }
        .header {
          font-size: 20px;
          font-weight: bold;
          margin-bottom: 20px;
        }
      </style>
</head>
<body>
    <?php
        $settings = App\Models\Settings::first();
        $logo_path = storage_path('app/public/' . $settings->logo);
        if (file_exists($logo_path)) {
            $logo_mime = mime_content_type($logo_path);
            $logo_data = base64_encode(file_get_contents($logo_path));
        } else {
            $logo_mime = null;
            $logo_data = null;
        }
    ?>
    <div class="container">
        <?php if($logo_data): ?>
            <img src="data:<?php echo e($logo_mime); ?>;base64,<?php echo e($logo_data); ?>" style="width: 80px; float:right">
        <?php endif; ?>
        <h3 style="text-transform: uppercase;"><?php echo e($settings->name); ?></h3>
        <span style="font-size: 10px; color:rgb(112, 112, 112);"><?php echo e($settings->alamat); ?></span>
        <br>
        <span style="font-size: 10px; color:rgb(112, 112, 112);"><?php echo e($settings->email); ?> - <?php echo e($settings->phone); ?></span>
        <hr>
        <center>
        <div class="header">Export Detail</div>
        </center>

        <table style="border-collapse: collapse; width: 100%; font-size: 8px;">
            <thead>
                <tr>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Nama Pegawai</td>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Shift</td>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Tanggal</td>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Jam Masuk</td>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Telat</td>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Keterangan Masuk</td>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Jam Pulang</td>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Pulang Cepat</td>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Keterangan Pulang</td>
                    <td style="border: 1px solid black; padding: 8px; text-align: center; font-weight: bold; text-transform: uppercase;">Status</td>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $telat = $d->telat;
                        $jam   = floor($telat / (60 * 60));
                        $menit = $telat - ( $jam * (60 * 60) );
                        $menit2 = floor( $menit / 60 );
                        $detik = $telat % 60;
                        if($jam <= 0 && $menit2 <= 0){
                            $late = '-';
                        } else {
                            $late = $jam . ' Jam ' . $menit2 . ' Menit ' . $detik . ' Detik';
                        }

                        $pulang_cepat = $d->pulang_cepat;
                        $jam_pulang_cepat   = floor($pulang_cepat / (60 * 60));
                        $menit_pulang_cepat = $pulang_cepat - ( $jam_pulang_cepat * (60 * 60) );
                        $menit_pulang_cepat2 = floor( $menit_pulang_cepat / 60 );
                        $detik_pulang_cepat = $pulang_cepat % 60;

                        if($jam_pulang_cepat <= 0 && $menit_pulang_cepat2 <= 0){
                            $quick_return = '-';
                        } else {
                            $quick_return = $jam_pulang_cepat . ' Hour ' . $menit_pulang_cepat2 . ' Minute ' . $detik_pulang_cepat . ' Second';
                        }

                        if ($d->Shift) {
                            $shift_name = $d->Shift->nama_shift . ' ' . $d->Shift->jam_masuk . ' - ' . $d->Shift->jam_keluar;
                        } else {
                            $shift_name = '-';
                        }
                    ?>
                    <tr>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($d->name); ?></td>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($shift_name); ?></td>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($d->tanggal ?? '-'); ?></td>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($d->jam_absen ? $d->jam_absen : '-'); ?></td>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($late); ?></td>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($d->keterangan_masuk); ?></td>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($d->jam_pulang ? $d->jam_pulang : '-'); ?></td>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($quick_return); ?></td>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($d->keterangan_pulang); ?></td>
                        <td style="border: 1px solid black; padding: 8px;"><?php echo e($d->status_absen); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\absensi\resources\views/rekapdata/detailPdf.blade.php ENDPATH**/ ?>