<?php $__env->startSection('isi'); ?>
    <div class="row">
        <div class="col-md-12 project-list">
            <div class="card">
                <div class="row">
                    <div class="col-md-6 mt-2 p-0 d-flex">
                        <h4><?php echo e($title); ?></h4>
                    </div>
                    <div class="col-md-6 p-0">
                        <a href="<?php echo e(url('/data-absen/export')); ?><?php echo e($_GET?'?'.$_SERVER['QUERY_STRING']: ''); ?>" class="btn btn-success">Export</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="cold-md-12">
            <div class="card">
                <div class="card-header">
                    <form action="<?php echo e(url('/data-absen')); ?>">
                        <div class="row">
                            <div class="col-3">
                                <select name="user_id" id="user_id" class="form-control selectpicker" data-live-search="true">
                                    <option value=""selected>Pilih Pegawai</option>
                                    <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(request('user_id') == $u->id): ?>
                                            <option value="<?php echo e($u->id); ?>"selected><?php echo e($u->name); ?></option>
                                        <?php else: ?>
                                            <option value="<?php echo e($u->id); ?>"><?php echo e($u->name); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-3">
                                <input type="datetime" class="form-control" name="mulai" placeholder="Tanggal Mulai" id="mulai" value="<?php echo e(request('mulai')); ?>">
                            </div>
                            <div class="col-3">
                                <input type="datetime" class="form-control" name="akhir" placeholder="Tanggal Akhir" id="akhir" value="<?php echo e(request('akhir')); ?>">
                            </div>
                            <div class="col-3">
                                <button type="submit" id="search"class="border-0 mt-3" style="background-color: transparent;"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">

                    <div class="table-responsive">
                        <table id="mytable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nama Pegawai</th>
                                    <th>Shift</th>
                                    <th>Tanggal</th>
                                    <th>Jam Masuk</th>
                                    <th>Telat</th>
                                    <th>Lokasi Masuk</th>
                                    <th>Foto Masuk</th>
                                    <th>Keterangan Masuk</th>
                                    <th>Jam Pulang</th>
                                    <th>Pulang Cepat</th>
                                    <th>Lokasi Pulang</th>
                                    <th>Foto Pulang</th>
                                    <th>Keterangan Pulang</th>
                                    <th>Status Absen</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data_absen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $da): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($da->name); ?></td>
                                <td>
                                    <?php if($da->Shift): ?>
                                        <?php echo e($da->Shift->nama_shift); ?> (<?php echo e($da->Shift->jam_masuk); ?> - <?php echo e($da->Shift->jam_keluar); ?>)
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($da->tanggal ?? '-'); ?></td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php else: ?>
                                        <?php echo e($da->jam_absen); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->status_absen == 'Izin Telat'): ?>
                                        <span class="badge badge-warning">Izin Telat</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php else: ?>
                                    <?php
                                        $telat = $da->telat;
                                        $jam   = floor($telat / (60 * 60));
                                        $menit = $telat - ( $jam * (60 * 60) );
                                        $menit2 = floor( $menit / 60 );
                                        $detik = $telat % 60;
                                    ?>
                                        <?php if($jam <= 0 && $menit2 <= 0): ?>
                                            <span class="badge badge-success">Tepat Waktu</span>
                                        <?php else: ?>
                                            <span class="badge badge-danger"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php else: ?>
                                        <?php
                                            $jarak_masuk = explode(".", $da->jarak_masuk);
                                        ?>
                                        <a href="<?php echo e(url('/maps/'.$da->lat_absen.'/'.$da->long_absen.'/'.$da->User->id)); ?>" style="background-color: rgb(146, 146, 146)" class="btn btn-xs" target="_blank"><i class="fa fa-eye" class="me-2"></i> Lihat</a>
                                        <span class="badge badge-warning"><?php echo e($jarak_masuk[0]); ?> Meter</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php else: ?>
                                        <img src="<?php echo e(url('storage/' . $da->foto_jam_absen)); ?>" style="width: 60px">
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php else: ?>
                                        <?php echo e($da->keterangan_masuk); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php elseif($da->jam_pulang == null): ?>
                                        <span class="badge badge-warning">Belum Pulang</span>
                                    <?php else: ?>
                                        <?php echo e($da->jam_pulang); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->status_absen == 'Izin Pulang Cepat'): ?>
                                        <span class="badge badge-warning">Izin Pulang Cepat</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php elseif($da->jam_pulang == null): ?>
                                        <span class="badge badge-warning">Belum Pulang</span>
                                    <?php else: ?>
                                        <?php
                                            $pulang_cepat = $da->pulang_cepat;

                                            $jam   = floor($pulang_cepat / (60 * 60));
                                            $menit = $pulang_cepat - ( $jam * (60 * 60) );
                                            $menit2 = floor( $menit / 60 );
                                            $detik = $pulang_cepat % 60;
                                        ?>
                                         <?php if($jam <= 0 && $menit2 <= 0): ?>
                                            <span class="badge badge-success">Tidak Pulang Cepat</span>
                                         <?php else: ?>
                                            <span class="badge badge-danger"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                         <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php elseif($da->jam_pulang == null): ?>
                                        <span class="badge badge-warning">Belum Pulang</span>
                                    <?php else: ?>
                                        <?php
                                            $jarak_pulang = explode(".", $da->jarak_pulang);
                                        ?>
                                        <a href="<?php echo e(url('/maps/'.$da->lat_pulang.'/'.$da->long_pulang.'/'.$da->User->id)); ?>" style="background-color: rgb(146, 146, 146)" class="btn btn-xs" target="_blank"><i class="fa fa-eye" class="me-2"></i> Lihat</a>
                                        <span class="badge badge-warning"><?php echo e($jarak_pulang[0]); ?> Meter</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php elseif($da->jam_pulang == null): ?>
                                        <span class="badge badge-warning">Belum Pulang</span>
                                    <?php else: ?>
                                        <img src="<?php echo e(url('storage/' . $da->foto_jam_pulang)); ?>" style="width: 60px">
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info">Libur</span>
                                    <?php elseif($da->status_absen == 'Cuti'): ?>
                                        <span class="badge badge-warning">Sedang Izin</span>
                                    <?php elseif($da->jam_absen == null): ?>
                                        <span class="badge badge-danger">Belum Absen</span>
                                    <?php elseif($da->jam_pulang == null): ?>
                                        <span class="badge badge-warning">Belum Pulang</span>
                                    <?php else: ?>
                                        <?php echo e($da->keterangan_pulang); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($da->status_absen == 'Libur'): ?>
                                        <span class="badge badge-info"><?php echo e($da->status_absen); ?></span>
                                    <?php elseif($da->status_absen == 'Cuti' || $da->status_absen == 'Izin Telat' || $da->status_absen == 'Izin Pulang Cepat'): ?>
                                        <span class="badge badge-warning"><?php echo e($da->status_absen); ?></span>
                                    <?php elseif($da->status_absen == 'Masuk'): ?>
                                        <span class="badge badge-success"><?php echo e($da->status_absen); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-danger"><?php echo e($da->status_absen); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <ul class="action">
                                        <?php if($da->status_absen == 'Libur'): ?>
                                            <li class="me-2">
                                                <span class="badge badge-info">Libur</span>
                                            </li>
                                         <?php elseif($da->status_absen == 'Cuti'): ?>
                                            <li class="me-2">
                                                <span class="badge badge-warning">Sedang Izin</span>
                                            </li>
                                        <?php else: ?>
                                            <?php if($da->id): ?>
                                                <li class="me-2">
                                                    <a href="<?php echo e(url('/data-absen/'.$da->id.'/edit-masuk')); ?>" class="btn btn-xs btn-warning">Edit Masuk</a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <?php if($da->status_absen == 'Libur'): ?>
                                            <li class="me-2">
                                                <span class="badge badge-info">Libur</span>
                                            </li>
                                        <?php elseif($da->status_absen == 'Cuti'): ?>
                                            <li class="me-2">
                                                <span class="badge badge-warning">Sedang Izin</span>
                                            </li>
                                        <?php elseif($da->jam_absen == null): ?>
                                            <li class="me-2">
                                                <span class="badge badge-danger">Belum Masuk</span>
                                            </li>
                                        <?php else: ?>
                                            <?php if($da->id): ?>
                                                <li class="me-2">
                                                    <a href="<?php echo e(url('/data-absen/'.$da->id.'/edit-pulang')); ?>" class="btn btn-xs btn-warning">Edit Pulang</a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <?php if($da->id): ?>
                                            <li class="delete">
                                                <form action="<?php echo e(url('/data-absen/'.$da->id.'/delete')); ?>" method="post" class="d-inline">
                                                    <?php echo method_field('delete'); ?>
                                                    <?php echo csrf_field(); ?>
                                                    <button class="border-0" style="background-color: transparent" onClick="return confirm('Are You Sure')"><i class="fas fa-trash"></i></button>
                                                </form>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-end mt-4">
                        <?php echo e($data_absen->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('script'); ?>
        <script>
            $(document).ready(function() {
                $('#mulai').change(function(){
                    var mulai = $(this).val();
                $('#akhir').val(mulai);
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\absensi\resources\views/absen/dataabsen.blade.php ENDPATH**/ ?>